(function() {
  'use strict';
  define(['angular'], function(angular) {
    return angular.module('ngModules.services.locationState', []).run([
      '$rootScope', '$location', '$injector', function($rootScope, $location, $injector) {
        $rootScope.$on('$locationChangeSuccess', function() {
          return $location.$$actualPath = $location.path();
        });
        if ($injector.has('$state')) {
          return $rootScope.$on('$stateChangeSuccess', function() {
            return $location.isLocationChanged = $location.path() === $location.$$actualPath;
          });
        } else {
          return $rootScope.$watch((function() {
            return $location.path();
          }), function(newLocation) {
            return $location.isLocationChanged = newLocation === $location.$$actualPath;
          });
        }
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=locationState.js.map
