(function() {
  'use strict';
  define(['angular'], function(angular) {
    return angular.module('ngModules.services.playRoutes', []).provider('$playRoutes', [
      function() {
        this.jsRoutes = window.jsRoutes;
        this.$get = [
          '$http', (function(_this) {
            return function($http) {
              var addRoutes, playRoutes, wrapHttp;
              wrapHttp = function(fn) {
                return function() {
                  var httpMethod, res, routeObject, url;
                  routeObject = fn.apply(this, arguments);
                  httpMethod = routeObject.method.toLowerCase();
                  url = routeObject.url;
                  res = {
                    $route: routeObject,
                    method: httpMethod,
                    url: url,
                    absoluteUrl: routeObject.absoluteURL,
                    webSocketUrl: routeObject.webSocketURL
                  };
                  res[httpMethod] = function(options) {
                    return $http[httpMethod](url, options);
                  };
                  return res;
                };
              };
              playRoutes = {};
              (addRoutes = function(playRoutesObject, jsRoutesObject) {
                var key, value, _results;
                _results = [];
                for (key in jsRoutesObject) {
                  value = jsRoutesObject[key];
                  if (angular.isFunction(value)) {
                    _results.push(playRoutesObject[key] = wrapHttp(value));
                  } else {
                    if (!(key in playRoutesObject)) {
                      playRoutesObject[key] = {};
                    }
                    _results.push(addRoutes(playRoutesObject[key], value));
                  }
                }
                return _results;
              })(playRoutes, _this.jsRoutes);
              return playRoutes;
            };
          })(this)
        ];
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=playRoutes.js.map
