(function() {
  'use strict';
  define(['angular', './locationState'], function(angular) {
    return angular.module('ngModules.services.retainScroll', ['ngModules.services.locationState']).provider('$retainScroll', [
      function() {
        this.target = null;
        this.inactive = false;
        this.tracking = false;
        this.positions = {};
        this.maxTryCount = 10;
        this.whetherScrollEvaluator = [
          '$location', function($location) {
            return $location.isLocationChanged;
          }
        ];
        this.isDelayedEvaluator = [
          function() {
            return false;
          }
        ];
        this.$get = [
          function() {
            return this;
          }
        ];
      }
    ]).run([
      '$rootScope', '$retainScroll', '$location', '$timeout', '$injector', function($rootScope, $retainScroll, $location, $timeout, $injector) {
        var $target;
        $target = $($retainScroll.target || window);
        $target.on('scroll', function() {
          if ($retainScroll.tracking) {
            return $retainScroll.positions[$location.url()] = $target.scrollTop();
          }
        });
        $rootScope.$on('$routeChangeStart', function() {
          return $retainScroll.inactive = $retainScroll.tracking = false;
        });
        $rootScope.$on('$viewContentLoaded', function(e) {
          var isCancel, offScopeDestroy, offScrollCanceler, onScrollCanceler;
          if ($retainScroll.inactive || !$injector.invoke($retainScroll.whetherScrollEvaluator)) {
            console.log("move to scroll top %o", $target[0]);
            $target.scrollTop(0);
            $retainScroll.tracking = true;
          } else {
            isCancel = false;
            offScopeDestroy = e.targetScope.$on('$destroy', function() {
              isCancel = true;
              return offScrollCanceler();
            });
            offScrollCanceler = function() {
              return $target.off('scroll.retainScroll-canceler' + e.targetScope.$id);
            };
            onScrollCanceler = function() {
              return $target.one('scroll.retainScroll-canceler' + e.targetScope.$id, function() {
                isCancel = true;
                return offScopeDestroy();
              });
            };
            $timeout(function() {
              var scrollTop, tryCount, tryScroll;
              if (isCancel) {
                console.log('Cancel scrolling %o', $target[0]);
                return $retainScroll.tracking = true;
              } else {
                tryCount = $retainScroll.maxTryCount;
                scrollTop = $retainScroll.positions[$location.url()] || 0;
                return (tryScroll = function() {
                  if (isCancel) {
                    console.log('Cancel scrolling %o', $target[0]);
                    return $retainScroll.tracking = true;
                  } else if ($injector.invoke($retainScroll.isDelayedEvaluator)) {
                    return $timeout(tryScroll, 200);
                  } else {
                    offScrollCanceler();
                    $target.scrollTop(scrollTop);
                    console.log("" + (1 + $retainScroll.maxTryCount - tryCount) + " try move to scroll " + ($target.scrollTop()) + " / " + scrollTop + " %o", $target[0]);
                    if ($target.scrollTop() === scrollTop || --tryCount <= 0) {
                      $retainScroll.tracking = true;
                      return offScopeDestroy();
                    } else {
                      onScrollCanceler();
                      return $timeout(tryScroll, 100);
                    }
                  }
                })();
              }
            }, 100);
          }
        });
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=retainScroll.js.map
