(function() {
  'use strict';
  define(['angular', 'jquery-extends'], function(angular, $) {
    return angular.module('ngModules.services.routeResolver', []).provider('$routeResolver', [
      function() {
        this.resolve = function(route, deps) {
          if (!$.isPlainObject(route)) {
            $.error("'route' must be plain object");
          }
          return $.obj.extend(true, {}, route, {
            resolve: (function(resolve, deps) {
              var hasInitializer, key, reservedName, resolver, _i, _j, _len, _len1, _ref, _ref1;
              if (resolve == null) {
                resolve = {};
              } else if (!$.isPlainObject(resolve)) {
                $.error("Resolve must be plain object : " + resolve);
              } else {
                _ref = ['$init', '$params'];
                for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                  reservedName = _ref[_i];
                  if (reservedName in resolve) {
                    $.error("Reserved resolve name: '" + reservedName + "'");
                  }
                }
                resolve = angular.copy(resolve);
              }
              hasInitializer = false;
              for (key = _j = 0, _len1 = resolve.length; _j < _len1; key = ++_j) {
                resolver = resolve[key];
                if ((_ref1 = $.type(resolver)) === 'string' || _ref1 === 'function' || _ref1 === 'array') {
                  resolve[key] = function($q, $rootScope, $injector) {
                    var deferred, doResolve, getOrInvoke;
                    deferred = $q.defer();
                    getOrInvoke = angular.isString(resolver) ? 'get' : 'invoke';
                    doResolve = function() {
                      return deferred.resolve($injector[getOrInvoke](resolver));
                    };
                    if (deps.length === 0) {
                      doResolve();
                    } else {
                      require(deps, function() {
                        return $rootScope.$evalAsync(doResolve);
                      });
                    }
                    return deferred.promise;
                  };
                  hasInitializer = true;
                }
              }
              if (!hasInitializer) {
                resolve.$init = function($q, $rootScope) {
                  var deferred;
                  deferred = $q.defer();
                  if (deps.length === 0) {
                    deferred.resolve();
                  } else {
                    require(deps, function() {
                      return $rootScope.$evalAsync(function() {
                        return deferred.resolve();
                      });
                    });
                  }
                  return deferred.promise;
                };
              }
              resolve.$params = function($route) {
                var params, _ref2;
                params = {};
                if (((_ref2 = $route.current) != null ? _ref2.params : void 0) != null) {
                  if ('$' in $route.current.params) {
                    params = angular.fromJson($route.current.params.$) || {};
                  }
                  for (key in $route.current.params) {
                    if (key !== '$') {
                      params[key] = $route.current.params[key];
                    }
                  }
                }
                return params;
              };
              return resolve;
            })(route.resolve, $.makeArray(deps))
          });
        };
        this.$get = [
          function() {
            return this;
          }
        ];
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=routeResolver.js.map
