'use strict'

define ['angular'], (angular) ->
  angular.module 'ngModules.directives.splitTagsWhenPaste', []
  .constant 'splitTagsWhenPasteConfig',
    delimiter: /[|/\n]/g
  .directive 'splitTagsWhenPaste', [
    'splitTagsWhenPasteConfig', '$parse'
    (splitTagsWhenPasteConfig, $parse) ->
      restrict: 'AC'
      require: 'tagsInput'
      link: (scope, element, attrs) ->
        delimiter = null
        attrs.$observe 'splitTagsWhenPaste', (value) ->
          delimiter = value or splitTagsWhenPasteConfig.delimiter
          delimiter = new RegExp(delimiter.toString(), 'g')  unless delimiter instanceof RegExp

        getModel = $parse(attrs.ngModel)
        setModel = getModel.assign

        element.on 'paste', (e) ->
          e.preventDefault()
          e.stopPropagation()
          splitedValue = e.originalEvent.clipboardData.getData('text/plain')?.split?(delimiter).filter (a) -> !!a
          if splitedValue.length > 0
            tags = getModel(scope) or []
            for text in splitedValue
              tags.push(text: text)  unless tags.some (a) -> a.text is text
            scope.$evalAsync -> setModel(scope, tags)

        return undefined
  ]
