'use strict'

define ['angular'], (angular) ->
  angular.module 'ngModules.directives.dateParser', []
  .constant 'dateParserConfig',
    'dateFormat': 'yyyy-MM-dd'
  .directive 'dateParser', [
    'dateParserConfig', 'dateFilter', 'dateParserFilter'
    (dateParserConfig, dateFilter, dateParserFilter) ->
      restrict: 'A',
      require: 'ngModel',
      link: (scope, elem, attrs, ngModel) ->
        dateFormat = null
        attrs.$observe 'dateParser', (value) ->
          dateFormat = value or dateParserConfig.dateFormat
          ngModel.$render()

        ngModel.$parsers.unshift (value) ->
          date = dateParserFilter(value, dateFormat)
          ngModel.$setValidity 'date', !value or angular.isDate(date)
          date

        ngModel.$render = ->
          elem.val(if ngModel.$modelValue then dateFilter(ngModel.$modelValue, dateFormat) else undefined)
          scope.ngModel = ngModel.$modelValue

        ngModel.$formatters.push (modelValue) ->
          ngModel.$setValidity 'date', !modelValue or angular.isDate(modelValue)
          if angular.isDate(modelValue) then dateFilter(modelValue, dateFormat) else ''

        return undefined
  ]
