'use strict'

define ['angular', 'jquery-extends'], (angular, $) ->
  angular.module 'ngModules.filters.arrays', []
  .filter 'makeArray', [-> (input) -> if angular.isArray input then input else $.makeArray(input)]
  .filter 'range', [-> Array.range]
  .filter 'join', [-> (input, sep) -> $.makeArray(input).join(sep)]
  .filter 'combine', [-> (input, transformers...) ->
    input = [input]  unless angular.isArray input
    (
      for value in input
        for transformer in transformers
          if angular.isFunction transformer
            value = transformer(value)
          else if typeof transformer is 'string'
            value = switch transformer
              when '=integer' then parseInt(value)
              when '=float'   then parseFloat(value)
              else $.obj.get(value, transformer)
        value
    ).reduce (t, v) -> t + v
  ]
  .filter 'limit', [-> (input, page, itemsPerPage) ->
    from = (page - 1) * itemsPerPage
    to = from + itemsPerPage
    $.makeArray(input)[from...to]
  ]
  .filter 'trimAll', [-> (input) -> if angular.isArray input then input.trimAll?() else input?.toString?()?.trim?()]
