(function() {
  'use strict';
  define(['angular', 'angular-dateparser'], function(angular) {
    return angular.module('ngModules.filters.dates', ['dateParser']).filter('dateParser', [
      '$dateParser', function($dateParser) {
        return function(input, dateFormat) {
          switch (false) {
            case !angular.isDate(input):
              return input;
            case !angular.isNumber(input):
              return new Date(input);
            case !angular.isString(input):
              return $dateParser(input, dateFormat || '');
          }
        };
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=dates.js.map
