(function() {
  'use strict';
  define(['angular'], function(angular) {
    return angular.module('ngModules.filters.strings', []).filter('trustAs', [
      '$sce', function($sce) {
        return $sce.trustAs;
      }
    ]).filter('trustAsHtml', [
      '$sce', function($sce) {
        return $sce.trustAsHtml;
      }
    ]).filter('trustAsJs', [
      '$sce', function($sce) {
        return $sce.trustAsJs;
      }
    ]).filter('trustAsResourceUrl', [
      '$sce', function($sce) {
        return $sce.trustAsResourceUrl;
      }
    ]).filter('trustAsUrl', [
      '$sce', function($sce) {
        return $sce.trustAsUrl;
      }
    ]).filter('replace', [
      function() {
        return function(input, search, replacement) {
          return (input || '').toString().replace(search, replacement);
        };
      }
    ]).filter('nl2br', [
      function() {
        return function(input) {
          return (input || '').toString().replace(/(\r\n|\n\r|\r|\n)/g, '<br/>');
        };
      }
    ]).filter('br2nl', [
      function() {
        return function(input) {
          return (input || '').toString().replace(/(<br>|<br\/>)/g, '\n');
        };
      }
    ]).filter('space2nbsp', [
      function() {
        return function(input) {
          return (input || '').toString().replace(/\s/g, '&nbsp;');
        };
      }
    ]).filter('nbsp2space', [
      function() {
        return function(input) {
          return (input || '').toString().replace(/&nbsp;/g, ' ');
        };
      }
    ]).filter('split', [
      function() {
        return function(input, separators, limit) {
          var s;
          if (input == null) {
            return input;
          } else {
            return input.toString().split(new RegExp(angular.isArray(separators) ? ((function() {
              var _i, _len, _results;
              _results = [];
              for (_i = 0, _len = separators.length; _i < _len; _i++) {
                s = separators[_i];
                _results.push(RegExp.escape(s));
              }
              return _results;
            })()).join('|') : RegExp.escape(separators)), limit);
          }
        };
      }
    ]).filter('cutstring', [
      function() {
        return function(input, maxLength, suffix) {
          var inputString;
          if (maxLength == null) {
            maxLength = 10;
          }
          if (suffix == null) {
            suffix = '...';
          }
          if (input == null) {
            return input;
          } else {
            inputString = input.toString();
            if (inputString.length > maxLength - suffix.length) {
              inputString = inputString.slice(0, maxLength) + suffix;
            }
            return inputString;
          }
        };
      }
    ]).filter('roundcutstring', [
      function() {
        return function(input, search, maxLength, prefix, suffix) {
          var doCut, i, inputString, searchString;
          if (maxLength == null) {
            maxLength = 20;
          }
          if (prefix == null) {
            prefix = '...';
          }
          if (suffix == null) {
            suffix = '...';
          }
          if (input == null) {
            return input;
          } else {
            inputString = input.toString();
            searchString = (search || '').toString();
            i = inputString.indexOf(searchString);
            if (i === -1) {
              if (inputString.length > maxLength - suffix.length) {
                inputString = inputString.slice(0, maxLength) + suffix;
              }
              return inputString;
            } else {
              return (doCut = function(before, after, string, restLength) {
                var emptyOrPrefix, emptyOrSuffix, halfLength, pieceOfAfter, pieceOfBefore, restOfAfter, restOfBefore;
                if (restLength <= 0 || before.length === 0 && after.length === 0) {
                  emptyOrPrefix = before.length > 0 ? prefix : '';
                  emptyOrSuffix = after.length > 0 ? suffix : '';
                  return emptyOrPrefix + string + emptyOrSuffix;
                } else {
                  halfLength = restLength / 2;
                  if (halfLength < 1) {
                    return doCut(before.slice(0, -1), after, before.slice(-1) + string, 0);
                  } else {
                    pieceOfBefore = before.slice(-halfLength);
                    pieceOfAfter = after.slice(0, halfLength);
                    restOfBefore = before.slice(0, -halfLength);
                    restOfAfter = after.slice(halfLength);
                    return doCut(restOfBefore, restOfAfter, pieceOfBefore + string + pieceOfAfter, restLength - pieceOfBefore.length - pieceOfAfter.length);
                  }
                }
              })(inputString.slice(0, i), inputString.slice(i + searchString.length), searchString, maxLength - searchString.length - prefix.length - suffix.length);
            }
          }
        };
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=strings.js.map
