'use strict'

define ['angular', 'jquery-extends'], (angular, $) ->
  angular.module 'ngModules.services.routeResolver', []
  .provider '$routeResolver', [->
    @resolve = (route, deps) ->
      $.error "'route' must be plain object"  unless $.isPlainObject route
      $.obj.extend true, {}, route,
        resolve: ((resolve, deps) ->
          unless resolve? then resolve = {}
          else unless $.isPlainObject resolve
            $.error "Resolve must be plain object : " + resolve
          else
            for reservedName in ['$init', '$params']
              $.error "Reserved resolve name: '#{reservedName}'"  if reservedName of resolve
            resolve = angular.copy(resolve)

          hasInitializer = false
          for resolver, key in resolve
            if $.type(resolver) in ['string', 'function', 'array']
              resolve[key] = ($q, $rootScope, $injector) ->
                deferred = $q.defer()
                getOrInvoke = if angular.isString(resolver) then 'get' else 'invoke'
                doResolve = -> deferred.resolve($injector[getOrInvoke](resolver))
                if deps.length is 0 then doResolve()
                else require deps, -> $rootScope.$evalAsync doResolve
                deferred.promise
              hasInitializer = true

          unless hasInitializer
            resolve.$init = ($q, $rootScope) ->
              deferred = $q.defer()
              if deps.length is 0 then deferred.resolve()
              else require deps, -> $rootScope.$evalAsync -> deferred.resolve()
              deferred.promise

          resolve.$params = ($route) ->
            params = {}
            if $route.current?.params?
              if '$' of $route.current.params then params = angular.fromJson($route.current.params.$) or {}
              for key of $route.current.params then params[key] = $route.current.params[key]  unless key is '$'
            params

          resolve
          #
        )(route.resolve, $.makeArray(deps))

    @$get = [-> @]

    return undefined
  ]