'use strict'

define ['angular'], (angular) ->
  angular.module 'ngModules.services.searchForm', []

  .factory '$searchForm', [-> (options) ->
    options = action: options  if angular.isFunction options
    options = angular.extend(
      defaults: {}
      #beforeSubmit: (form, filters, unfilters) ->
      #beforeReset: (form) ->
      #submit: (form, filters, unfilters) ->
      #reset: (form) ->
      #action: (form) ->
      #transform: (key, value) -> value
    , options)

    class SearchForm
      constructor: (@options) ->
        @current = angular.copy(@options.defaults) or {}
        @form = angular.copy(@options.defaults) or {}

      isDirty: -> !angular.equals(@current, @form)
      isPrune: -> !@isDirty()
      isChanged: -> !angular.equals(@current, @options.defaults)

      submit: (form, filters, unfilters) ->
        if @options.beforeSubmit?(form, filters, unfilters) isnt false
          if filters?
            isFiltered = ([key, value]  for key, value of filters or {}).every (keyWithValue) =>
              [key, value] = keyWithValue
              angular.equals(@form[key], value, true)
            angular.extend(@form, angular.copy(if isFiltered then unfilters else filters))
          @current = angular.copy(@form)
          @options.submit?(form, filters, unfilters)
          @options.action?(form)
        @

      reset: (form) ->
        if @options.beforeReset?(form) isnt false
          form?.$setPristine?()
          @current = angular.copy(@options.defaults) or {}
          @form = angular.copy(@options.defaults) or {}
          @options.reset?(form)
          @options.action?(form)
        @

      params: (refresh, defaults) ->
        [defaults, refresh] = [refresh, false]  if angular.isObject refresh

        params = if refresh is true
          angular.copy(@current)
        else
          angular.copy(@form = angular.copy(@current))

        for key of @options.defaults
          params[key] = params[key].filter((a) -> !!a)  if angular.isArray params[key]

        params = angular.extend params, angular.copy(defaults)

        if angular.isFunction @options.transform
          params[key] = @options.transform(key, value)  for key, value of params

        params

    new SearchForm(options)
  ]
