(function() {
  'use strict';
  define(['angular'], function(angular) {
    return angular.module('ngModules.services.searchForm', []).factory('$searchForm', [
      function() {
        return function(options) {
          var SearchForm;
          if (angular.isFunction(options)) {
            options = {
              action: options
            };
          }
          options = angular.extend({
            defaults: {}
          }, options);
          SearchForm = (function() {
            function SearchForm(options) {
              this.options = options;
              this.current = angular.copy(this.options.defaults) || {};
              this.form = angular.copy(this.options.defaults) || {};
            }

            SearchForm.prototype.isDirty = function() {
              return !angular.equals(this.current, this.form);
            };

            SearchForm.prototype.isPrune = function() {
              return !this.isDirty();
            };

            SearchForm.prototype.isChanged = function() {
              return !angular.equals(this.current, this.options.defaults);
            };

            SearchForm.prototype.submit = function(form, filters, unfilters) {
              var isFiltered, key, value, _base, _base1, _base2;
              if ((typeof (_base = this.options).beforeSubmit === "function" ? _base.beforeSubmit(form, filters, unfilters) : void 0) !== false) {
                if (filters != null) {
                  isFiltered = ((function() {
                    var _ref, _results;
                    _ref = filters || {};
                    _results = [];
                    for (key in _ref) {
                      value = _ref[key];
                      _results.push([key, value]);
                    }
                    return _results;
                  })()).every((function(_this) {
                    return function(keyWithValue) {
                      var key, value;
                      key = keyWithValue[0], value = keyWithValue[1];
                      return angular.equals(_this.form[key], value, true);
                    };
                  })(this));
                  angular.extend(this.form, angular.copy(isFiltered ? unfilters : filters));
                }
                this.current = angular.copy(this.form);
                if (typeof (_base1 = this.options).submit === "function") {
                  _base1.submit(form, filters, unfilters);
                }
                if (typeof (_base2 = this.options).action === "function") {
                  _base2.action(form);
                }
              }
              return this;
            };

            SearchForm.prototype.reset = function(form) {
              var _base, _base1, _base2;
              if ((typeof (_base = this.options).beforeReset === "function" ? _base.beforeReset(form) : void 0) !== false) {
                if (form != null) {
                  if (typeof form.$setPristine === "function") {
                    form.$setPristine();
                  }
                }
                this.current = angular.copy(this.options.defaults) || {};
                this.form = angular.copy(this.options.defaults) || {};
                if (typeof (_base1 = this.options).reset === "function") {
                  _base1.reset(form);
                }
                if (typeof (_base2 = this.options).action === "function") {
                  _base2.action(form);
                }
              }
              return this;
            };

            SearchForm.prototype.params = function(refresh, defaults) {
              var key, params, value, _ref;
              if (angular.isObject(refresh)) {
                _ref = [refresh, false], defaults = _ref[0], refresh = _ref[1];
              }
              params = refresh === true ? angular.copy(this.current) : angular.copy(this.form = angular.copy(this.current));
              for (key in this.options.defaults) {
                if (angular.isArray(params[key])) {
                  params[key] = params[key].filter(function(a) {
                    return !!a;
                  });
                }
              }
              params = angular.extend(params, angular.copy(defaults));
              if (angular.isFunction(this.options.transform)) {
                for (key in params) {
                  value = params[key];
                  params[key] = this.options.transform(key, value);
                }
              }
              return params;
            };

            return SearchForm;

          })();
          return new SearchForm(options);
        };
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=searchForm.js.map
