(function () {
  'use strict';
  var app = angular.module('ng-pinyin', []);
  app.filter('pinyin', function () {
    function getUpperCaseIndices(str) {
      var indices = [];
      for (var i = 0; i < str.length; i++) {
        if (str[i] === str[i].toUpperCase()) {
          indices.push(i);
        }
      }
      return indices;
    }
    function revertToUpperCase(str, indices) {
      var chars = str.split('');
      indices.map(function (idx) {
        chars[idx] = chars[idx].toUpperCase();
      });
      return chars.join('');
    }
    return function (text) {
      var tonePtn = /([aeiouvüAEIOUVÜ]{1,2}(n|ng|r|\'er|N|NG|R|\'ER){0,1}[1234])/g;
      var toneMap = {
          a: [
            '\u0101',
            '\xe1',
            '\u01ce',
            '\xe0'
          ],
          ai: [
            '\u0101i',
            '\xe1i',
            '\u01cei',
            '\xe0i'
          ],
          ao: [
            '\u0101o',
            '\xe1o',
            '\u01ceo',
            '\xe0o'
          ],
          e: [
            '\u0113',
            '\xe9',
            '\u011b',
            '\xe8'
          ],
          ei: [
            '\u0113i',
            '\xe9i',
            '\u011bi',
            '\xe8i'
          ],
          i: [
            '\u012b',
            '\xed',
            '\u01d0',
            '\xec'
          ],
          ia: [
            'i\u0101',
            'i\xe1',
            'i\u01ce',
            'i\xe0'
          ],
          ie: [
            'i\u0113',
            'i\xe9',
            'i\u011b',
            'i\xe8'
          ],
          io: [
            'i\u014d',
            'i\xf3',
            'i\u01d2',
            'i\xf2'
          ],
          iu: [
            'i\u016b',
            'i\xfa',
            'i\u01d4',
            'i\xf9'
          ],
          o: [
            '\u014d',
            '\xf3',
            '\u01d2',
            '\xf2'
          ],
          ou: [
            '\u014du',
            '\xf3u',
            '\u01d2u',
            '\xf2u'
          ],
          u: [
            '\u016b',
            '\xfa',
            '\u01d4',
            '\xf9'
          ],
          ua: [
            'u\u0101',
            'u\xe1',
            'u\u01ce',
            'u\xe0'
          ],
          ue: [
            'u\u0113',
            'u\xe9',
            'u\u011b',
            'u\xe8'
          ],
          ui: [
            'u\u012b',
            'u\xed',
            'u\u01d0',
            'u\xec'
          ],
          uo: [
            'u\u014d',
            'u\xf3',
            'u\u01d2',
            'u\xf2'
          ],
          v: [
            '\u01d6',
            '\u01d8',
            '\u01da',
            '\u01dc'
          ],
          ve: [
            '\xfc\u0113',
            '\xfc\xe9',
            '\xfc\u011b',
            '\xfc\xe8'
          ],
          ü: [
            '\u01d6',
            '\u01d8',
            '\u01da',
            '\u01dc'
          ],
          üe: [
            '\xfc\u0113',
            '\xfc\xe9',
            '\xfc\u011b',
            '\xfc\xe8'
          ]
        };
      var tones = text.match(tonePtn);
      if (tones) {
        tones.forEach(function (coda, idx, arr) {
          var toneIdx = parseInt(coda.slice(-1)) - 1;
          var vowel = coda.slice(0, -1);
          var suffix = vowel.match(/(n|ng|r|\'er|N|NG|R|\'ER)$/);
          vowel = vowel.replace(/(n|ng|r|\'er|N|NG|R|\'ER)$/, '');
          var upperCaseIdxs = getUpperCaseIndices(vowel);
          vowel = vowel.toLowerCase();
          var replacement = suffix && toneMap[vowel][toneIdx] + suffix[0] || toneMap[vowel][toneIdx];
          text = text.replace(coda, revertToUpperCase(replacement, upperCaseIdxs));
        });
      }
      return text;
    };
  });
  app.directive('ngPinyin', [
    '$timeout',
    'pinyinFilter',
    function ($timeout, pinyinFilter) {
      function link(scope, element, attrs, ngModelCtrl) {
        function convertToPinyin(text) {
          var updatedText = text;
          if (text && typeof text !== 'string') {
            throw Error('ng-pinyin: ng-model needs to refer to a string!');
          } else if (text) {
            updatedText = pinyinFilter(text);
          }
          if (updatedText !== text) {
            ngModelCtrl.$setViewValue(updatedText);
            ngModelCtrl.$render();
          }
          return text;
        }
        var modelValue = scope[attrs.ngModel];
        if (modelValue && typeof modelValue !== 'string') {
          throw Error('ng-pinyin: ng-model needs to refer to a string!');
        }
        ngModelCtrl.$parsers.push(convertToPinyin);
      }
      return {
        require: 'ngModel',
        restrict: 'A',
        link: link
      };
    }
  ]);
}());