angular.module("ng-token-auth",["ngCookies"]).provider("$auth",function(){var e,t;e={"default":{apiUrl:"/api",signOutUrl:"/auth/sign_out",emailSignInPath:"/auth/sign_in",emailRegistrationPath:"/auth",accountUpdatePath:"/auth",accountDeletePath:"/auth",confirmationSuccessUrl:function(){return window.location.href},passwordResetPath:"/auth/password",passwordUpdatePath:"/auth/password",passwordResetSuccessUrl:function(){return window.location.href},tokenValidationPath:"/auth/validate_token",proxyIf:function(){return false},proxyUrl:"/proxy",validateOnPageLoad:true,forceHardRedirect:false,storage:"cookies",tokenFormat:{"access-token":"{{ token }}","token-type":"Bearer",client:"{{ clientId }}",expiry:"{{ expiry }}",uid:"{{ uid }}"},parseExpiry:function(e){return parseInt(e["expiry"],10)*1e3||null},handleLoginResponse:function(e){return e.data},handleAccountUpdateResponse:function(e){return e.data},handleTokenValidationResponse:function(e){return e.data},authProviderPaths:{github:"/auth/github",facebook:"/auth/facebook",google:"/auth/google_oauth2"}}};t="default";return{configure:function(n){var r,i,s,o,u,a,f,l,c;if(n instanceof Array&&n.length){for(o=l=0,c=n.length;l<c;o=++l){r=n[o];a=null;for(u in r){f=r[u];a=u;if(o===0){t=a}}i=angular.copy(e["default"]);s={};s[a]=angular.extend(i,r[a]);angular.extend(e,s)}if(t!=="default"){delete e["default"]}}else if(n instanceof Object){angular.extend(e["default"],n)}else{throw"Invalid argument: ng-token-auth config should be an Array or Object."}return e},$get:["$http","$q","$location","$cookieStore","$window","$timeout","$rootScope","$interpolate",function(n){return function(n,r,i,s,o,u,a,f){return{header:null,dfd:null,user:{},mustResetPassword:false,listener:null,initialize:function(){this.initializeListeners();return this.addScopeMethods()},initializeListeners:function(){this.listener=this.handlePostMessage.bind(this);if(o.addEventListener){return o.addEventListener("message",this.listener,false)}},cancel:function(e){if(this.t!=null){u.cancel(this.t)}if(this.dfd!=null){this.rejectDfd(e)}return u(function(e){return function(){return e.t=null}}(this),0)},destroy:function(){this.cancel();if(o.removeEventListener){return o.removeEventListener("message",this.listener,false)}},handlePostMessage:function(e){var t;if(e.data.message==="deliverCredentials"){delete e.data.message;this.handleValidAuth(e.data,true);a.$broadcast("auth:login-success",e.data)}if(e.data.message==="authFailure"){t={reason:"unauthorized",errors:[e.data.error]};this.cancel(t);return a.$broadcast("auth:login-error",t)}},addScopeMethods:function(){a.user=this.user;a.authenticate=this.authenticate.bind(this);a.signOut=this.signOut.bind(this);a.destroyAccount=this.destroyAccount.bind(this);a.submitRegistration=this.submitRegistration.bind(this);a.submitLogin=this.submitLogin.bind(this);a.requestPasswordReset=this.requestPasswordReset.bind(this);a.updatePassword=this.updatePassword.bind(this);a.updateAccount=this.updateAccount.bind(this);if(this.getConfig().validateOnPageLoad){return this.validateUser({config:this.getSavedConfig()})}},submitRegistration:function(e,t){var r;if(t==null){t={}}r=this.getResultOrValue(this.getConfig(t.config).confirmationSuccessUrl);angular.extend(e,{confirm_success_url:r,config_name:this.getCurrentConfigName(t.config)});return n.post(this.apiUrl(t.config)+this.getConfig(t.config).emailRegistrationPath,e).success(function(t){return a.$broadcast("auth:registration-email-success",e)}).error(function(e){return a.$broadcast("auth:registration-email-error",e)})},submitLogin:function(e,t){if(t==null){t={}}this.initDfd();n.post(this.apiUrl(t.config)+this.getConfig(t.config).emailSignInPath,e).success(function(e){return function(n){var r;e.setConfigName(t.config);r=e.getConfig(t.config).handleLoginResponse(n);e.handleValidAuth(r);return a.$broadcast("auth:login-success",e.user)}}(this)).error(function(e){return function(t){e.rejectDfd({reason:"unauthorized",errors:["Invalid credentials"]});return a.$broadcast("auth:login-error",t)}}(this));return this.dfd.promise},userIsAuthenticated:function(){return this.retrieveData("auth_headers")&&this.user.signedIn&&!this.tokenHasExpired()},requestPasswordReset:function(e,t){var r;if(t==null){t={}}r=this.getResultOrValue(this.getConfig(t.config).passwordResetSuccessUrl);e.redirect_url=r;if(t.config!=null){e.config_name=t.config}return n.post(this.apiUrl(t.config)+this.getConfig(t.config).passwordResetPath,e).success(function(t){return a.$broadcast("auth:password-reset-request-success",e)}).error(function(e){return a.$broadcast("auth:password-reset-request-error",e)})},updatePassword:function(e){return n.put(this.apiUrl()+this.getConfig().passwordUpdatePath,e).success(function(e){return function(t){a.$broadcast("auth:password-change-success",t);return e.mustResetPassword=false}}(this)).error(function(e){return a.$broadcast("auth:password-change-error",e)})},updateAccount:function(e){return n.put(this.apiUrl()+this.getConfig().accountUpdatePath,e).success(function(e){return function(t){angular.extend(e.user,e.getConfig().handleAccountUpdateResponse(t));return a.$broadcast("auth:account-update-success",t)}}(this)).error(function(e){return a.$broadcast("auth:account-update-error",e)})},destroyAccount:function(e){return n["delete"](this.apiUrl()+this.getConfig().accountUpdatePath,e).success(function(e){return function(t){e.invalidateTokens();return a.$broadcast("auth:account-destroy-success",t)}}(this)).error(function(e){return a.$broadcast("auth:account-destroy-error",e)})},authenticate:function(e,t){if(t==null){t={}}if(this.dfd==null){this.setConfigName(t.config);this.initDfd();this.openAuthWindow(e,t)}return this.dfd.promise},setConfigName:function(e){if(e==null){e=t}return this.persistData("currentConfigName",e,e)},openAuthWindow:function(e,t){var n;n=this.buildAuthUrl(e,t);if(this.useExternalWindow()){return this.requestCredentials(this.createPopup(n))}else{return this.visitUrl(n)}},visitUrl:function(e){return o.location.replace(e)},buildAuthUrl:function(e,t){var n,r,i,s;if(t==null){t={}}n=this.getConfig(t.config).apiUrl;n+=this.getConfig(t.config).authProviderPaths[e];n+="?auth_origin_url="+encodeURIComponent(o.location.href);if(t.params!=null){s=t.params;for(r in s){i=s[r];n+="&";n+=encodeURIComponent(r);n+="=";n+=encodeURIComponent(i)}}return n},requestCredentials:function(e){if(e.closed){this.cancel({reason:"unauthorized",errors:["User canceled login"]});return a.$broadcast("auth:window-closed")}else{e.postMessage("requestCredentials","*");return this.t=u(function(t){return function(){return t.requestCredentials(e)}}(this),500)}},createPopup:function(e){return o.open(e)},resolveDfd:function(){this.dfd.resolve(this.user);return u(function(e){return function(){e.dfd=null;if(!a.$$phase){return a.$digest()}}}(this),0)},validateUser:function(e){var t,n,r,s,o;if(e==null){e={}}n=e.config;if(this.dfd==null){this.initDfd();if(this.userIsAuthenticated()){this.resolveDfd()}else{if(i.search().token!==void 0){s=i.search().token;t=i.search().client_id;o=i.search().uid;r=i.search().expiry;n=i.search().config;this.setConfigName(n);this.mustResetPassword=i.search().reset_password;this.firstTimeLogin=i.search().account_confirmation_success;this.setAuthHeaders(this.buildAuthHeaders({token:s,clientId:t,uid:o,expiry:r}));i.url(i.path()||"/")}else if(this.retrieveData("currentConfigName")){n=this.retrieveData("currentConfigName")}if(!isEmpty(this.retrieveData("auth_headers"))){if(this.tokenHasExpired()){a.$broadcast("auth:session-expired");this.rejectDfd({reason:"unauthorized",errors:["Session expired."]})}else{this.validateToken({config:n})}}else{this.rejectDfd({reason:"unauthorized",errors:["No credentials"]});a.$broadcast("auth:invalid")}}}return this.dfd.promise},validateToken:function(e){if(e==null){e={}}if(!this.tokenHasExpired()){return n.get(this.apiUrl(e.config)+this.getConfig(e.config).tokenValidationPath).success(function(t){return function(n){var r;r=t.getConfig(e.config).handleTokenValidationResponse(n);t.handleValidAuth(r);if(t.firstTimeLogin){a.$broadcast("auth:email-confirmation-success",t.user)}if(t.mustResetPassword){a.$broadcast("auth:password-reset-confirm-success",t.user)}return a.$broadcast("auth:validation-success",t.user)}}(this)).error(function(e){return function(t){if(e.firstTimeLogin){a.$broadcast("auth:email-confirmation-error",t)}if(e.mustResetPassword){a.$broadcast("auth:password-reset-confirm-error",t)}a.$broadcast("auth:validation-error",t);return e.rejectDfd({reason:"unauthorized",errors:t.errors})}}(this))}else{return this.rejectDfd({reason:"unauthorized",errors:["Expired credentials"]})}},tokenHasExpired:function(){var e,t;e=this.getExpiry();t=(new Date).getTime();return e&&e<t},getExpiry:function(){return this.getConfig().parseExpiry(this.retrieveData("auth_headers"))},invalidateTokens:function(){var e,t,n;n=this.user;for(e in n){t=n[e];delete this.user[e]}this.deleteData("currentConfigName");return this.deleteData("auth_headers")},signOut:function(){return n["delete"](this.apiUrl()+this.getConfig().signOutUrl).success(function(e){return function(t){e.invalidateTokens();return a.$broadcast("auth:logout-success")}}(this)).error(function(e){return function(t){e.invalidateTokens();return a.$broadcast("auth:logout-error",t)}}(this))},handleValidAuth:function(e,t){if(t==null){t=false}if(this.t!=null){u.cancel(this.t)}angular.extend(this.user,e);this.user.signedIn=true;this.user.configName=this.getCurrentConfigName();if(t){this.setAuthHeaders(this.buildAuthHeaders({token:this.user.auth_token,clientId:this.user.client_id,uid:this.user.uid,expiry:this.user.expiry}))}return this.resolveDfd()},buildAuthHeaders:function(e){var t,n,r,i;t={};i=this.getConfig().tokenFormat;for(n in i){r=i[n];t[n]=f(r)(e)}return t},persistData:function(e,t,n){switch(this.getConfig(n).storage){case"localStorage":return o.localStorage.setItem(e,JSON.stringify(t));default:return s.put(e,t)}},retrieveData:function(e){switch(this.getConfig().storage){case"localStorage":return JSON.parse(o.localStorage.getItem(e));default:return s.get(e)}},deleteData:function(e){switch(this.getConfig().storage){case"localStorage":return o.localStorage.removeItem(e);default:return s.remove(e)}},setAuthHeaders:function(e){var t;t=angular.extend(this.retrieveData("auth_headers")||{},e);return this.persistData("auth_headers",t)},useExternalWindow:function(){return!(this.getConfig().forceHardRedirect||o.isIE())},initDfd:function(){return this.dfd=r.defer()},rejectDfd:function(e){this.invalidateTokens();if(this.dfd!=null){this.dfd.reject(e);return u(function(e){return function(){return e.dfd=null}}(this),0)}},apiUrl:function(e){if(this.getConfig(e).proxyIf()){return this.getConfig(e).proxyUrl}else{return this.getConfig(e).apiUrl}},getConfig:function(t){return e[this.getCurrentConfigName(t)]},getResultOrValue:function(e){if(typeof e==="function"){return e()}else{return e}},getCurrentConfigName:function(e){return e||this.getSavedConfig()},getSavedConfig:function(){var e,n;e=void 0;n="currentConfigName";if(o.localStorage){if(e==null){e=JSON.parse(o.localStorage.getItem(n))}}if(e==null){e=s.get(n)}return e!=null?e:e=t}}}}(this)]}}).config(["$httpProvider",function(e){var t,n;n=function(e,t){var n,r,i,s;r={};s=e.getConfig().tokenFormat;for(n in s){i=s[n];if(t.headers(n)){r[n]=t.headers(n)}}return e.setAuthHeaders(r)};e.interceptors.push(["$injector",function(e){return{request:function(t){e.invoke(["$http","$auth",function(e,n){var r,i,s,o;if(t.url.match(n.apiUrl())){s=n.retrieveData("auth_headers");o=[];for(r in s){i=s[r];o.push(t.headers[r]=i)}return o}}]);return t},response:function(t){e.invoke(["$http","$auth",function(e,r){if(t.config.url.match(r.apiUrl())){return n(r,t)}}]);return t},responseError:function(t){e.invoke(["$http","$auth",function(e,r){if(t.config.url.match(r.apiUrl())){return n(r,t)}}]);return e.get("$q").reject(t)}}}]);t=["get","post","put","patch","delete"];return angular.forEach(t,function(t){var n;if((n=e.defaults.headers)[t]==null){n[t]={}}return e.defaults.headers[t]["If-Modified-Since"]="0"})}]).run(["$auth","$window","$rootScope",function(e,t,n){return e.initialize()}]);window.isOldIE=function(){var e,t,n;t=false;e=navigator.userAgent.toLowerCase();if(e&&e.indexOf("msie")!==-1){n=parseInt(e.split("msie")[1]);if(n<10){t=true}}return t};window.isIE=function(){var e;e=navigator.userAgent.toLowerCase();return e&&e.indexOf("msie")!==-1||!!navigator.userAgent.match(/Trident.*rv\:11\./)};window.isEmpty=function(e){var t,n;if(!e){return true}if(e.length>0){return false}if(e.length===0){return true}for(t in e){n=e[t];if(Object.prototype.hasOwnProperty.call(e,t)){return false}}return true}