var example = angular.module('exampleApp', ['ngVega']);

example.controller('BarChartController', function($scope) {
  $scope.renderer = 'canvas';
  $scope.spec = {
    "width": 300,
    "height": 200,
    "padding": {"top": 10, "left": 30, "bottom": 30, "right": 10},
    "data": [
      // only describe a name for dataset here and load data dynamically
      {"name": "table"}
    ],
    "scales": [
      {
        "name": "x",
        "type": "ordinal",
        "range": "width",
        "domain": {"data": "table", "field": "data.x"}
      },
      {
        "name": "y",
        "range": "height",
        "nice": true,
        "domain": {"data": "table", "field": "data.y"}
      }
    ],
    "axes": [
      {"type": "x", "scale": "x"},
      {"type": "y", "scale": "y"}
    ],
    "marks": [
      {
        "type": "rect",
        "from": {"data": "table"},
        "key": "data.x",
        "properties": {
          "enter": {
            "x": {"scale": "x", "field": "data.x"},
            "width": {"scale": "x", "band": true, "offset": -1},
            "y": {"scale": "y", "field": "data.y"},
            "y2": {"scale": "y", "value": 0}
          },
          "update": {
            "x": {"scale": "x", "field": "data.x"},
            "width": {"scale": "x", "band": true, "offset": -1},
            "y": {"scale": "y", "field": "data.y"},
            "y2": {"scale": "y", "value": 0},
            "fill": {"value": "steelblue"}
          },
          "hover": {
            "fill": {"value": "red"}
          }
        }
      }
    ]
  };

  var data1 = {
    table: [
      {"x": 1,  "y": 280}, {"x": 2,  "y": 55},
      {"x": 3,  "y": 43}, {"x": 4,  "y": 91},
      {"x": 5,  "y": 81}, {"x": 6,  "y": 53},
      {"x": 7,  "y": 19}, {"x": 8,  "y": 87},
      {"x": 9,  "y": 52}, {"x": 10, "y": 48},
      {"x": 11, "y": 24}, {"x": 12, "y": 49},
      {"x": 13, "y": 87}, {"x": 14, "y": 66},
      {"x": 15, "y": 17}, {"x": 16, "y": 27},
      {"x": 17, "y": 68}, {"x": 18, "y": 16},
      {"x": 19, "y": 49}, {"x": 20, "y": 15}
    ]
  };
  var data2 = {
    table: [
      {"x": 1,  "y": 2}, {"x": 2,  "y": 55},
      {"x": 3,  "y": 1}, {"x": 4,  "y": 91},
      {"x": 5,  "y": 81}, {"x": 6,  "y": 53},
      {"x": 7,  "y": 19}, {"x": 8,  "y": 87},
      {"x": 9,  "y": 52}, {"x": 10, "y": 48},
      {"x": 11, "y": 24}, {"x": 12, "y": 49},
      {"x": 13, "y": 87}, {"x": 14, "y": 66},
      {"x": 15, "y": 17}, {"x": 16, "y": 27}
    ]
  };

  $scope.testData = data1;
  $scope.data1 = data1;
  $scope.data2 = data2;
});
