# Contributing to Numbers.js

Want to contribute? Great! Here are some guidelines for contributing.

## Application Driven
Numbers.js is intended to be an application driven library. It's meant to be a set of tools for developers to use when building applications. This means that contributions outside of performance tweeks, bug fixes, architecture, or core mathematics tools must have a provided application. This is a [great example](http://bl.ocks.org/4279121/b40e188b3faf7ed76e8662cee0631d51ba48157d) of an example being used to explain and display a contribution (via [@zikes](https://github.com/zikes)).

## Mathematics
You don't have to have a PhD (we don't), but there is an expectation that well known algorithms and methods are used in development.

The realm of mathematics we're exploring includes basic mathematics, calculus, linear algebra and matrices, statistics, and prime numbers. Some of these areas are more abstract than others.

## Coding Standards
* Semicolons.
* Comma last.
* Thorough documentation (JSDoc Standard).
* Write tests.

Take a swing through the repo and you'll get a sense of the style more rigorously.

## License
By contributing, you agree to license your contribution under the terms of APLv2, which is a standard open-source license approved by the Free Software Foundation
[https://github.com/sjkaliski/numbers.js/blob/master/LICENSE](https://github.com/sjkaliski/numbers.js/blob/master/LICENSE)
