/* Generated by Opal 0.6.3 */
(function($opal) {
  var self = $opal.top, $scope = $opal, nil = $opal.nil, $breaker = $opal.breaker, $slice = $opal.slice, $klass = $opal.klass;

  $opal.add_stubs(['$allocate', '$wrap', '$clone', '$raise']);
  return (function($base, $super) {
    function $Date(){};
    var self = $Date = $klass($base, $super, 'Date', $Date);

    var def = self._proto, $scope = self._scope;

    def.date = nil;
    (function(self) {
      var $scope = self._scope, def = self._proto;

      self._proto.$civil = self._proto.$new;
      self._proto.$wrap = function(native$) {
        var self = this, instance = nil;

        instance = self.$allocate();
        instance.date = native$;
        return instance;
      };
      self._proto.$parse = function(string) {
        var self = this, match = nil;

        match = /^(\d*)-(\d*)-(\d*)/.exec(string);
        return self.$wrap(new Date(parseInt(match[1]), parseInt(match[2]) - 1, parseInt(match[3])));
      };
      return (self._proto.$today = function() {
        var self = this;

        return self.$wrap(new Date());
      }, nil) && 'today';
    })(self.$singleton_class());

    def.$initialize = function(year, month, day) {
      var self = this;

      return self.date = new Date(year, month - 1, day);
    };

    def['$-'] = function(date) {
      var self = this;

      
      if (date._isNumber) {
        var result = self.$clone();
        result.date.setDate(self.date.getDate() - date);
        return result;
      }
      else if (date.date) {
        return Math.round((self.date - date.date) / (1000 * 60 * 60 * 24));
      }
      else {
        self.$raise($scope.TypeError);
      }
    ;
    };

    def['$+'] = function(date) {
      var self = this;

      
      if (date._isNumber) {
        var result = self.$clone();
        result.date.setDate(self.date.getDate() + date);
        return result;
      }
      else {
        self.$raise($scope.TypeError);
      }
    ;
    };

    def['$<'] = function(other) {
      var self = this;

      
      var a = self.date, b = other.date;
      a.setHours(0, 0, 0, 0);
      b.setHours(0, 0, 0, 0);
      return a < b;
    ;
    };

    def['$<='] = function(other) {
      var self = this;

      
      var a = self.date, b = other.date;
      a.setHours(0, 0, 0, 0);
      b.setHours(0, 0, 0, 0);
      return a <= b;
    ;
    };

    def['$>'] = function(other) {
      var self = this;

      
      var a = self.date, b = other.date;
      a.setHours(0, 0, 0, 0);
      b.setHours(0, 0, 0, 0);
      return a > b;
    ;
    };

    def['$>='] = function(other) {
      var self = this;

      
      var a = self.date, b = other.date;
      a.setHours(0, 0, 0, 0);
      b.setHours(0, 0, 0, 0);
      return a >= b;
    ;
    };

    def['$=='] = function(other) {
      var self = this;

      
      var a = self.date, b = other.date;
      return (a.getFullYear() === b.getFullYear() && a.getMonth() === b.getMonth() && a.getDate() === b.getDate());
    ;
    };

    $opal.defn(self, '$eql?', def['$==']);

    def.$clone = function() {
      var self = this;

      return $scope.Date.$wrap(new Date(self.date.getTime()));
    };

    def.$day = function() {
      var self = this;

      return self.date.getDate();
    };

    def.$month = function() {
      var self = this;

      return self.date.getMonth() + 1;
    };

    def.$next = function() {
      var self = this, res = nil;

      res = self.$clone();
      res.date.setDate(self.date.getDate() + 1);
      return res;
    };

    def.$next_month = function() {
      var self = this;

      
      var result = self.$clone(), date = result.date, cur = date.getDate();
      date.setDate(1);
      date.setMonth(date.getMonth() + 1);
      date.setDate(Math.min(cur, days_in_month(date.getFullYear(), date.getMonth())));
      return result;
    ;
    };

    def.$prev = function() {
      var self = this, res = nil;

      res = self.$clone();
      res.date.setDate(self.date.getDate() - 1);
      return res;
    };

    def.$prev_month = function() {
      var self = this;

      
      var result = self.$clone(), date = result.date, cur = date.getDate();
      date.setDate(1);
      date.setMonth(date.getMonth() - 1);
      date.setDate(Math.min(cur, days_in_month(date.getFullYear(), date.getMonth())));
      return result;
    ;
    };

    def.$strftime = function(format) {
      var self = this;

      if (format == null) {
        format = ""
      }
      return self.date.$strftime(format);
    };

    def.$to_s = function() {
      var self = this;

      
      var d = self.date, year = d.getFullYear(), month = d.getMonth() + 1, day = d.getDate();
      if (month < 10) { month = '0' + month; }
      if (day < 10) { day = '0' + day; }
      return year + '-' + month + '-' + day;
    ;
    };

    def.$wday = function() {
      var self = this;

      return self.date.getDay();
    };

    def.$year = function() {
      var self = this;

      return self.date.getFullYear();
    };

    
    function days_in_month(year, month) {
      var leap = ((year % 4 === 0 && year % 100 !== 0) || year % 400 === 0);
      return [31, (leap ? 29 : 28), 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][month]
    }
  
  })(self, null)
})(Opal);

//# sourceMappingURL=/__opal_source_maps__/date.js.map
;
