sap.ui.define([
		'jquery.sap.global',
		'sap/ui/core/Fragment',
		'sap/ui/core/mvc/Controller',
		'sap/ui/model/Filter',
		'sap/ui/model/json/JSONModel'
	], function(jQuery, Fragment, Controller, Filter, JSONModel) {
	"use strict";

	var CController = Controller.extend("sap.m.sample.InputKeyValueTabularSuggestions.C", {
		inputId: '',

		onInit: function () {
			// set explored app's demo model on this sample
			var oModel = new JSONModel(jQuery.sap.getModulePath("sap.ui.demo.mock", "/products.json"));
			this.getView().setModel(oModel);

			var oInput = this.getView().byId('productInput');
			oInput.setSuggestionRowValidator(this.suggestionRowValidator);
		},

		handleValueHelp : function (oController) {
			this.inputId = oController.oSource.sId;
			// create value help dialog
			if (!this._valueHelpDialog) {
				this._valueHelpDialog = sap.ui.xmlfragment(
					"sap.m.sample.InputKeyValueTabularSuggestions.Dialog",
					this
				);
				this.getView().addDependent(this._valueHelpDialog);
			}

			// open value help dialog
			this._valueHelpDialog.open();
		},

		_handleValueHelpSearch : function (evt) {
			var sValue = evt.getParameter("value");
			var oFilter = new Filter(
				"Name",
				sap.ui.model.FilterOperator.Contains, sValue
			);
			evt.getSource().getBinding("items").filter([oFilter]);
		},

		_handleValueHelpClose : function (evt) {
			var oSelectedItem = evt.getParameter("selectedItem");
			if (oSelectedItem) {
				var productInput = this.getView().byId(this.inputId);
				productInput.setValue(oSelectedItem.getTitle());
			}
			evt.getSource().getBinding("items").filter([]);
		},

		suggestionRowValidator: function (oColumnListItem) {
			var aCells = oColumnListItem.getCells();

			return new sap.ui.core.Item({
				key: aCells[1].getText(),
				text: aCells[0].getText()
			});
		},

		suggestionItemSelected: function (evt) {

			var oInput = this.getView().byId('productInput'),
				oText = this.getView().byId('selectedKey'),
				sKey = oInput.getSelectedKey();

			oText.setText(sKey);
		}
	});


	return CController;

});
