jQuery.sap.registerPreloadedModules({
	"version": "2.0",
	"name": "sap.ui.table.library-preload",
	"modules": {
		"sap/ui/table/AnalyticalColumn.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./Column\",\"./library\",\"sap/ui/core/Element\",\"sap/ui/model/type/Boolean\",\"sap/ui/model/type/DateTime\",\"sap/ui/model/type/Float\",\"sap/ui/model/type/Integer\",\"sap/ui/model/type/Time\",\"./TableUtils\",\"./AnalyticalColumnMenu\"],function(e,t,r,a,i,n,o,p,s,l,u){\"use strict\";function g(e){return l.isInstanceOf(e,\"sap/ui/table/AnalyticalTable\")}var y=t.extend(\"sap.ui.table.AnalyticalColumn\",{metadata:{library:\"sap.ui.table\",properties:{leadingProperty:{type:\"string\",group:\"Misc\",defaultValue:null},summed:{type:\"boolean\",group:\"Misc\",defaultValue:!1},inResult:{type:\"boolean\",group:\"Misc\",defaultValue:!1},showIfGrouped:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},groupHeaderFormatter:{type:\"any\",group:\"Behavior\",defaultValue:null}}}});return y.prototype.init=function(){t.prototype.init.apply(this,arguments)},y._DEFAULT_FILTERTYPES={Time:new s({UTC:!0}),DateTime:new n({UTC:!0}),Float:new o,Integer:new p,Boolean:new Boolean},y.prototype._createMenu=function(){return new u(this.getId()+\"-menu\")},y.prototype.setGrouped=function(e,t){var r=this.getParent();g(r)&&(e?r._addGroupedColumn(this.getId()):r._removeGroupedColumn(this.getId()));var a=this.setProperty(\"grouped\",e,t);return this._updateColumns(!0),a},y.prototype.setSummed=function(e){var t=this.setProperty(\"summed\",e,!0);return this._updateTableAnalyticalInfo(),t},y.prototype.setVisible=function(e,t){return this.setProperty(\"visible\",e,t),this._updateColumns(),this},y.prototype.getLabel=function(){var e=this.getAggregation(\"label\");if(!e){if(!this._oBindingLabel){var t=this.getParent();if(g(t)){var a=t.getBinding(\"rows\");if(a){this._oBindingLabel=r.TableHelper.createLabel();var i=a.getModel();if(i.oMetadata&&i.oMetadata.isLoaded())this._oBindingLabel.setText(a.getPropertyLabel(this.getLeadingProperty()));else{var n=this;i.attachMetadataLoaded(function(){n._oBindingLabel.setText(a.getPropertyLabel(n.getLeadingProperty()))})}}}}e=this._oBindingLabel}return e},y.prototype.getFilterProperty=function(){var t=this.getProperty(\"filterProperty\");if(!t){var r=this.getParent();if(g(r)){var a=r.getBinding(\"rows\"),i=this.getLeadingProperty();a&&e.inArray(i,a.getFilterablePropertyNames())>-1&&(t=i)}}return t},y.prototype.getSortProperty=function(){var t=this.getProperty(\"sortProperty\");if(!t){var r=this.getParent();if(g(r)){var a=r.getBinding(\"rows\"),i=this.getLeadingProperty();a&&e.inArray(i,a.getSortablePropertyNames())>-1&&(t=i)}}return t},y.prototype.getFilterType=function(){var e=this.getProperty(\"filterType\");if(!e){var t=this.getParent();if(g(t)){var r=t.getBinding(\"rows\"),a=this.getLeadingProperty(),i=r&&r.getProperty(a);if(i)switch(i.type){case\"Edm.Time\":e=y._DEFAULT_FILTERTYPES.Time;break;case\"Edm.DateTime\":case\"Edm.DateTimeOffset\":e=y._DEFAULT_FILTERTYPES.DateTime;break;case\"Edm.Single\":case\"Edm.Double\":case\"Edm.Decimal\":e=y._DEFAULT_FILTERTYPES.Float;break;case\"Edm.SByte\":case\"Edm.Int16\":case\"Edm.Int32\":case\"Edm.Int64\":e=y._DEFAULT_FILTERTYPES.Integer;break;case\"Edm.Boolean\":e=y._DEFAULT_FILTERTYPES.Boolean}}}return e},y.prototype._afterSort=function(){this._updateTableAnalyticalInfo()},y.prototype._updateColumns=function(e,t){var r=this.getParent();g(r)&&r._updateColumns(e,t)},y.prototype._updateTableAnalyticalInfo=function(e){var t=this.getParent();t&&g(t)&&!t._bSuspendUpdateAnalyticalInfo&&t.updateAnalyticalInfo(e)},y.prototype._updateTableColumnDetails=function(){var e=this.getParent();e&&g(e)&&!e._bSuspendUpdateAnalyticalInfo&&e._updateTableColumnDetails()},y.prototype.shouldRender=function(){return!!this.getVisible()&&((!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped))},y.prototype.getTooltip_AsString=function(){var e=a.prototype.getTooltip_AsString.apply(this),t=this.getParent();if(!e&&g(t)){var r=t.getBinding(\"rows\");r&&this.getLeadingProperty()&&(e=r.getPropertyQuickInfo(this.getLeadingProperty()))}return e},y.prototype._menuHasItems=function(){var e=function(){var e=this.getParent(),t=e.getBinding(\"rows\"),r=t&&t.getAnalyticalQueryResult();return e&&r&&r.findMeasureByPropertyName(this.getLeadingProperty())}.bind(this);return t.prototype._menuHasItems.apply(this)||e()},y.prototype.isFilterableByMenu=function(){var t=this.getFilterProperty();if(!t||!this.getShowFilterMenuEntry())return!1;var r=this.getParent();if(g(r)){var a=r.getBinding(\"rows\");if(a&&e.inArray(t,a.getFilterablePropertyNames())>-1&&!a.isMeasure(t)&&a.getProperty(t))return!0}return!1},y.prototype.isGroupableByMenu=function(){var t=this.getParent();if(g(t)){var r=t.getBinding(\"rows\");if(r){var a=r.getAnalyticalQueryResult();if(a&&a.findDimensionByPropertyName(this.getLeadingProperty())&&e.inArray(this.getLeadingProperty(),r.getSortablePropertyNames())>-1&&e.inArray(this.getLeadingProperty(),r.getFilterablePropertyNames())>-1)return!0}}return!1},y});",
		"sap/ui/table/AnalyticalColumnMenu.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./ColumnMenu\",\"./library\"],function(e,t,o){\"use strict\";var u=o.GroupEventType,n=t.extend(\"sap.ui.table.AnalyticalColumnMenu\",{metadata:{library:\"sap.ui.table\"},renderer:\"sap.ui.table.ColumnMenuRenderer\"});return n.prototype._addMenuItems=function(){t.prototype._addMenuItems.apply(this),this._oColumn&&this._addSumMenuItem()},n.prototype._addGroupMenuItem=function(){var e=this._oColumn,t=this._oTable;e.isGroupableByMenu()&&(this._oGroupIcon=this._createMenuItem(\"group\",\"TBL_GROUP\",e.getGrouped()?\"accept\":null,function(o){var n=o.getSource(),p=e.getGrouped(),r=p?u.group:u.ungroup;e.setGrouped(!p),t.fireGroup({column:e,groupedColumns:t._aGroupedColumns,type:r}),n.setIcon(p?null:\"sap-icon://accept\"),t._getRowContexts()}),this.addItem(this._oGroupIcon))},n.prototype._addSumMenuItem=function(){var t=this._oColumn,o=this._oTable,u=o.getBinding(\"rows\"),n=u&&u.getAnalyticalQueryResult();o&&n&&n.findMeasureByPropertyName(t.getLeadingProperty())&&(this._oSumItem=this._createMenuItem(\"total\",\"TBL_TOTAL\",t.getSummed()?\"accept\":null,e.proxy(function(e){var u=e.getSource(),n=t.getSummed();t.setSummed(!n),u.setIcon(n?null:\"sap-icon://accept\"),o._getRowContexts()},this)),this.addItem(this._oSumItem))},n.prototype.open=function(){t.prototype.open.apply(this,arguments);var e=this._oColumn;this._oSumItem&&this._oSumItem.setIcon(e.getSummed()?\"sap-icon://accept\":null),this._oGroupIcon&&this._oGroupIcon.setIcon(e.getGrouped()?\"sap-icon://accept\":null)},n});",
		"sap/ui/table/AnalyticalColumnMenuRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/table/AnalyticalColumnMenu\"],function(e){\"use strict\";return e.getMetadata().getRenderer()},!0);",
		"sap/ui/table/AnalyticalTable.designtime.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";return{aggregations:{columns:{domRef:\".sapUiTableCHA\"},hScroll:{ignore:!1,domRef:function(e){return e.$(\"hsb\").get(0)}},vScroll:{ignore:!1,domRef:function(e){return e.$(\"vsb\").get(0)}}}}},!1);",
		"sap/ui/table/AnalyticalTable.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./AnalyticalColumn\",\"./Table\",\"./TreeTable\",\"./library\",\"sap/ui/model/analytics/ODataModelAdapter\",\"sap/ui/model/SelectionModel\",\"sap/ui/model/Sorter\",\"sap/ui/base/ManagedObject\",\"sap/ui/core/Popup\",\"sap/ui/unified/Menu\",\"sap/ui/unified/MenuItem\",\"./TableUtils\"],function(e,t,o,n,r,i,a,s,p,l,u,d,g){\"use strict\";var c=r.GroupEventType,h=r.SelectionBehavior,y=r.SelectionMode,m=r.SortOrder,f=r.TreeAutoExpandMode,_=o.extend(\"sap.ui.table.AnalyticalTable\",{metadata:{library:\"sap.ui.table\",properties:{sumOnTop:{type:\"boolean\",group:\"Appearance\",defaultValue:!1,deprecated:!0},numberOfExpandedLevels:{type:\"int\",group:\"Misc\",defaultValue:0,deprecated:!0},autoExpandMode:{type:\"string\",group:\"Misc\",defaultValue:\"Bundled\",deprecated:!0},columnVisibilityMenuSorter:{type:\"any\",group:\"Appearance\",defaultValue:null},collapseRecursive:{type:\"boolean\",defaultValue:!0},dirty:{type:\"boolean\",group:\"Appearance\",defaultValue:null,deprecated:!0}},designTime:!0},renderer:\"sap.ui.table.TableRenderer\"});return _.prototype._getFixedBottomRowContexts=function(){var e=this.getBinding(\"rows\");if(e)return[e.getGrandTotalNode()]},_.prototype._getContexts=n.prototype._getContexts,_.prototype.init=function(){o.prototype.init.apply(this,arguments),this.addStyleClass(\"sapUiAnalyticalTable\"),this.attachBrowserEvent(\"contextmenu\",this._onContextMenu),this.setSelectionMode(y.MultiToggle),this.setShowColumnVisibilityMenu(!0),this.setEnableColumnFreeze(!0),this.setEnableCellFilter(!0),this._aGroupedColumns=[],this._bSuspendUpdateAnalyticalInfo=!1,g.Grouping.setGroupMode(this)},_.prototype.exit=function(){this._cleanupGroupHeaderMenu(),o.prototype.exit.apply(this,arguments)},_.prototype._adaptLocalization=function(e,t){o.prototype._adaptLocalization.apply(this,arguments),t&&this._cleanupGroupHeaderMenu()},_.prototype.setFixedRowCount=function(){return e.sap.log.error(\"The property fixedRowCount is not supported by control sap.ui.table.AnalyticalTable!\"),this},_.prototype.setFixedBottomRowCount=function(){return e.sap.log.error(\"The property fixedBottomRowCount is managed by control sap.ui.table.AnalyticalTable!\"),this},_.prototype.setDirty=function(t){return e.sap.log.error(\"The property dirty of control sap.ui.table.AnalyticalTable is deprecated. Please use showOverlay instead.\"),this.setProperty(\"dirty\",t,!0),this.setShowOverlay(this.getDirty()),this},_.prototype.setEnableGrouping=function(t){return e.sap.log.error(\"The property enableGrouping is not supported by control sap.ui.table.AnalyticalTable!\"),this},_.prototype.getModel=function(e){var t=o.prototype.getModel.apply(this,arguments),n=this.getBindingInfo(\"rows\");return t&&n&&n.model==e&&i.apply(t),t},_.prototype._onBindingChange=function(e){o.prototype._onBindingChange.apply(this,arguments),\"sort\"!==(\"object\"==typeof e?e.getParameter(\"reason\"):e)&&this._invalidateColumnMenus()},_.prototype.bindRows=function(e){var t=this._sanitizeBindingInfo.apply(this,arguments),n=o.prototype.bindRows.call(this,t);return this._updateTotalRow(!0),n},_.prototype._bindAggregation=function(e,t,n,r,i){return\"rows\"===e&&(this.setProperty(\"firstVisibleRow\",0,!0),this._sanitizeBindingInfo.call(this,t,n,r,i)),o.prototype._bindAggregation.apply(this,arguments)},_.prototype._initSelectionModel=function(e){return this._oSelection=new a(e),this},_.prototype.setSelectionMode=function(t){if(t===y.None)return e.sap.log.fatal(\"SelectionMode 'None' is not supported by the AnalyticalTable.\"),this;var o=this.getBinding(\"rows\");return o&&o.clearSelection&&o.clearSelection(),t=g.sanitizeSelectionMode(this,t),this.setProperty(\"selectionMode\",t),this},_.prototype.setSelectionBehavior=function(t){return t===h.RowOnly?(e.sap.log.fatal(\"SelectionBehavior 'RowOnly' is not supported by the AnalyticalTable.\"),this):o.prototype.setSelectionBehavior.apply(this,arguments)},_.prototype._sanitizeBindingInfo=function(e){var t,o,n,r;\"string\"==typeof e&&(t=arguments[0],o=arguments[1],n=arguments[2],r=arguments[3],e={path:t,sorter:n,filters:r},o instanceof p?e.template=o:\"function\"==typeof o&&(e.factory=o));for(var a=this.getColumns(),l=0,u=a.length;l<u;l++)a[l].getSorted()&&(e.sorter=e.sorter||[],e.sorter.push(new s(a[l].getSortProperty()||a[l].getLeadingProperty(),a[l].getSortOrder()===m.Descending)));if(e.parameters=e.parameters||{},e.parameters.analyticalInfo=this._getColumnInformation(),e.parameters.hasOwnProperty(\"sumOnTop\")||(e.parameters.sumOnTop=this.getSumOnTop()),e.parameters.hasOwnProperty(\"numberOfExpandedLevels\")||(e.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels()),e.parameters.numberOfExpandedLevels>this._aGroupedColumns.length&&(e.parameters.numberOfExpandedLevels=0),!e.parameters.hasOwnProperty(\"autoExpandMode\")){var d=this.getAutoExpandMode();d!=f.Bundled&&d!=f.Sequential&&(d=f.Bundled),e.parameters.autoExpandMode=d}var g=this.getModel(e.model);return g&&i.apply(g),e},_.prototype._attachBindingListener=function(){var e=this.getBinding(\"rows\");e&&!e.hasListeners(\"selectionChanged\")&&e.attachSelectionChanged(this._onSelectionChanged,this),o.prototype._attachDataRequestedListeners.apply(this)},_.prototype._getColumnInformation=function(){for(var o=[],n=this.getColumns(),r=0;r<this._aGroupedColumns.length;r++){var i=sap.ui.getCore().byId(this._aGroupedColumns[r]);i&&o.push({name:i.getLeadingProperty(),visible:i.getVisible(),grouped:i.getGrouped(),total:i.getSummed(),sorted:i.getSorted(),sortOrder:i.getSortOrder(),inResult:i.getInResult(),formatter:i.getGroupHeaderFormatter()})}for(var r=0;r<n.length;r++){var i=n[r];e.inArray(i.getId(),this._aGroupedColumns)>-1||(!i instanceof t&&e.sap.log.error(\"You have to use AnalyticalColumns for the Analytical table\"),o.push({name:i.getLeadingProperty(),visible:i.getVisible(),grouped:i.getGrouped(),total:i.getSummed(),sorted:i.getSorted(),sortOrder:i.getSortOrder(),inResult:i.getInResult(),formatter:i.getGroupHeaderFormatter()}))}return o},_.prototype._updateTableContent=function(){var t=this.getBinding(\"rows\"),o=this.getFirstVisibleRow(),n=this.getFixedBottomRowCount(),r=this.getVisibleRowCount(),i=this.getColumns(),a=this.getRows();if(t)for(var s=this.getBindingInfo(\"rows\"),p=0,l=Math.min(r,a.length);p<l;p++){var u,d=p>r-n-1&&t.getLength()>r,c=d?t.getLength()-1-(r-1-p):o+p,h=a[p],y=h.$(),m=this.$().find(\"div[data-sap-ui-rowindex=\"+y.attr(\"data-sap-ui-rowindex\")+\"]\");u=d&&t.bProvideGrandTotals?t.getGrandTotalContextInfo():this.getContextInfoByIndex(c);var f=u?u.level:0;if(u&&u.context){t.nodeHasChildren&&t.nodeHasChildren(u)?g.Grouping.updateTableRowForGrouping(this,h,!0,u.nodeState.expanded,u.nodeState.expanded&&!s.parameters.sumOnTop,!1,f,t.getGroupName(u.context,u.level)):g.Grouping.updateTableRowForGrouping(this,h,!1,!1,!1,u.nodeState.sum,f,u.nodeState.sum&&u.level>0?t.getGroupName(u.context,u.level):null);for(var _=h.getCells(),C=0,v=_.length;C<v;C++){var G=_[C].data(\"sap-ui-colindex\"),b=i[G],I=e(_[C].$().closest(\"td\"));t.isMeasure(b.getLeadingProperty())?(I.addClass(\"sapUiTableMeasureCell\"),I.toggleClass(\"sapUiTableCellHidden\",u.nodeState.sum&&!b.getSummed())):I.removeClass(\"sapUiTableMeasureCell\")}}else g.Grouping.cleanupTableRowForGrouping(this,h),u&&!u.context&&(y.addClass(\"sapUiAnalyticalTableDummy\"),m.addClass(\"sapUiAnalyticalTableDummy\"))}else for(var C=0;C<a.length;C++)g.Grouping.cleanupTableRowForGrouping(this,a[C])},_.prototype._onContextMenu=function(t){if(e(t.target).closest(\"tr\").hasClass(\"sapUiTableGroupHeader\")||e(t.target).closest(\".sapUiTableRowHdr.sapUiTableGroupHeader\").length>0){this._iGroupedLevel=e(t.target).closest(\"[data-sap-ui-level]\").data(\"sap-ui-level\");var o=this._getGroupHeaderMenu(),n=l.Dock,r=t.pageX||t.clientX,i=t.pageY||t.clientY;return o.open(!1,t.target,n.LeftTop,n.LeftTop,document,r-2+\" \"+(i-2)),t.preventDefault(),void t.stopPropagation()}return!0},_.prototype._getGroupHeaderMenu=function(){function t(){var e=o._iGroupedLevel-1;if(o._aGroupedColumns[e]){return{column:o.getColumns().filter(function(t){if(o._aGroupedColumns[e]==t.getId())return!0})[0],index:e}}}var o=this;this._oGroupHeaderMenu||(this._oGroupHeaderMenu=new u,this._oGroupHeaderMenuVisibilityItem=new d({text:this._oResBundle.getText(\"TBL_SHOW_COLUMN\"),select:function(){var e=t();if(e){var n=e.column,r=n.getShowIfGrouped();n.setShowIfGrouped(!r),o.fireGroup({column:n,groupedColumns:n.getParent()._aGroupedColumns,type:r?c.hideGroupedColumn:c.showGroupedColumn})}}}),this._oGroupHeaderMenu.addItem(this._oGroupHeaderMenuVisibilityItem),this._oGroupHeaderMenu.addItem(new d({text:this._oResBundle.getText(\"TBL_UNGROUP\"),select:function(){var t,n=o.getColumns(),r=0,i=-1,a=-1;o.suspendUpdateAnalyticalInfo();for(var s=0;s<n.length;s++)t=n[s],t.getGrouped()&&(r++,r==o._iGroupedLevel?(t.setGrouped(!1),a=s,o.fireGroup({column:t,groupedColumns:t.getParent()._aGroupedColumns,type:c.ungroup})):i=s);if(i>-1&&a>-1&&a<i){var p=n[a],l=p.getHeaderSpan();e.isArray(l)&&(l=l[0]);for(var u=[],s=a;s<a+l;s++)u.push(n[s]);e.each(u,function(e,t){o.removeColumn(t),o.insertColumn(t,i)})}o.resumeUpdateAnalyticalInfo(),o._getRowContexts()}})),this._oGroupHeaderMenu.addItem(new d({text:this._oResBundle.getText(\"TBL_UNGROUP_ALL\"),select:function(){var e=o.getColumns();o.suspendUpdateAnalyticalInfo();for(var t=0;t<e.length;t++)e[t].setGrouped(!1);o.resumeUpdateAnalyticalInfo(),o._getRowContexts(),o.fireGroup({column:void 0,groupedColumns:[],type:c.ungroupAll})}})),this._oGroupHeaderMoveUpItem=new d({text:this._oResBundle.getText(\"TBL_MOVE_UP\"),select:function(){var n=t();if(n){var r=n.column,i=e.inArray(r.getId(),o._aGroupedColumns);i>0&&(o._aGroupedColumns[i]=o._aGroupedColumns.splice(i-1,1,o._aGroupedColumns[i])[0],o.updateAnalyticalInfo(),o.fireGroup({column:r,groupedColumns:r.getParent()._aGroupedColumns,type:c.moveUp}))}},icon:\"sap-icon://arrow-top\"}),this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveUpItem),this._oGroupHeaderMoveDownItem=new d({text:this._oResBundle.getText(\"TBL_MOVE_DOWN\"),select:function(){var n=t();if(n){var r=n.column,i=e.inArray(r.getId(),o._aGroupedColumns);i<o._aGroupedColumns.length&&(o._aGroupedColumns[i]=o._aGroupedColumns.splice(i+1,1,o._aGroupedColumns[i])[0],o.updateAnalyticalInfo(),o.fireGroup({column:r,groupedColumns:r.getParent()._aGroupedColumns,type:c.moveDown}))}},icon:\"sap-icon://arrow-bottom\"}),this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveDownItem),this._oGroupHeaderMenu.addItem(new d({text:this._oResBundle.getText(\"TBL_SORT_ASC\"),select:function(){var e=t();if(e){e.column.sort(!1)}},icon:\"sap-icon://up\"})),this._oGroupHeaderMenu.addItem(new d({text:this._oResBundle.getText(\"TBL_SORT_DESC\"),select:function(){var e=t();if(e){e.column.sort(!0)}},icon:\"sap-icon://down\"})),this._oGroupHeaderMenu.addItem(new d({text:this._oResBundle.getText(\"TBL_COLLAPSE_LEVEL\"),select:function(){o.getBinding(\"rows\").collapseToLevel(o._iGroupedLevel-1),o.setFirstVisibleRow(0),o.clearSelection()}})),this._oGroupHeaderMenu.addItem(new d({text:this._oResBundle.getText(\"TBL_COLLAPSE_ALL\"),select:function(){o.getBinding(\"rows\").collapseToLevel(0),o.setFirstVisibleRow(0),o.clearSelection()}})));var n=t();if(n){n.column.getShowIfGrouped()?this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText(\"TBL_HIDE_COLUMN\")):this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText(\"TBL_SHOW_COLUMN\")),this._oGroupHeaderMoveUpItem.setEnabled(n.index>0),this._oGroupHeaderMoveDownItem.setEnabled(n.index<this._aGroupedColumns.length-1)}else this._oGroupHeaderMoveUpItem.setEnabled(!0),this._oGroupHeaderMoveDownItem.setEnabled(!0);return this._oGroupHeaderMenu},_.prototype._cleanupGroupHeaderMenu=function(){this._oGroupHeaderMenu&&(this._oGroupHeaderMenu.destroy(),this._oGroupHeaderMenu=null,this._oGroupHeaderMenuVisibilityItem=null,this._oGroupHeaderMoveUpItem=null,this._oGroupHeaderMoveDownItem=null)},_.prototype.expand=function(e){var t=this.getBinding(\"rows\");t&&t.expand(e)},_.prototype.collapse=function(e){var t=this.getBinding(\"rows\");t&&t.collapse(e)},_.prototype.collapseAll=function(){var e=this.getBinding(\"rows\");return e&&(e.collapseToLevel(0),this.setFirstVisibleRow(0)),this},_.prototype.isExpanded=function(e){var t=this.getBinding(\"rows\");return!!t&&t.isExpanded(e)},_.prototype.getContextByIndex=function(e){var t=this.getBinding(\"rows\");return e>=0&&t?t.getContextByIndex(e):null},_.prototype.getContextInfoByIndex=function(e){var t=this.getBinding(\"rows\");return e>=0&&t?t.getNodeByIndex(e):null},_.prototype.suspendUpdateAnalyticalInfo=function(){this._bSuspendUpdateAnalyticalInfo=!0},_.prototype.resumeUpdateAnalyticalInfo=function(e,t){this._bSuspendUpdateAnalyticalInfo=!1,this._updateColumns(e,t)},_.prototype.addColumn=function(e,t){var n=this._getColumn(e);return n.getGrouped()&&this._addGroupedColumn(n.getId()),o.prototype.addColumn.call(this,n,t),this._updateColumns(t),this},_.prototype.insertColumn=function(e,t,n){var r=this._getColumn(e);return r.getGrouped()&&this._addGroupedColumn(r.getId()),o.prototype.insertColumn.call(this,r,t,n),this._updateColumns(n),this},_.prototype.removeColumn=function(t,n){var r=o.prototype.removeColumn.apply(this,arguments);return this._bReorderInProcess||(this._aGroupedColumns=e.grep(this._aGroupedColumns,function(e){return t.getId?e!=t.getId():e==t})),this.updateAnalyticalInfo(n),r},_.prototype.removeAllColumns=function(e){this._aGroupedColumns=[];var t=o.prototype.removeAllColumns.apply(this,arguments);return this._updateColumns(e),t},_.prototype._getColumn=function(e){if(\"string\"==typeof e){return new t({leadingProperty:e,template:e,managed:!0})}if(e instanceof t)return e;throw new Error(\"Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject\")},_.prototype._updateColumns=function(e,t){this._bSuspendUpdateAnalyticalInfo||(this._updateTableColumnDetails(),this.updateAnalyticalInfo(e,t))},_.prototype.updateAnalyticalInfo=function(e,t){if(!this._bSuspendUpdateAnalyticalInfo){var o=this.getBinding(\"rows\");if(o){var n=this._getColumnInformation();(o.getNumberOfExpandedLevels()||0)>this._aGroupedColumns.length&&o.setNumberOfExpandedLevels(0),o.updateAnalyticalInfo(n,t),this._updateTotalRow(e)}}},_.prototype.refreshRows=function(){sap.ui.table.Table.prototype.refreshRows.apply(this,arguments),this._updateTotalRow()},_.prototype._updateTotalRow=function(e){var t=this.getBinding(\"rows\"),o=this.getFixedBottomRowCount();t&&t.providesGrandTotal()&&t.hasTotaledMeasures()?1!==o&&this.setProperty(\"fixedBottomRowCount\",1,e):0!==o&&this.setProperty(\"fixedBottomRowCount\",0,e)},_.prototype._updateTableColumnDetails=function(){if(!this._bSuspendUpdateAnalyticalInfo){var t=this.getBinding(\"rows\"),o=t&&t.getAnalyticalQueryResult();if(o){for(var n,r,i=this.getColumns(),a=[],s=[],p=[],l={},u=0;u<i.length;u++)if(n=i[u],n._isLastGroupableLeft=!1,n._bLastGroupAndGrouped=!1,n._bDependendGrouped=!1,n.getVisible()){var d=n.getLeadingProperty();if(r=o.findDimensionByPropertyName(d)){var g=r.getName();l[g]?l[g].columns.push(n):l[g]={dimension:r,columns:[n]},n.getGrouped()&&-1==e.inArray(g,a)&&a.push(g),-1==e.inArray(g,p)&&p.push(g)}}if(s=e.grep(p,function(t){return-1==e.inArray(t,a)}),a.length>0&&(e.each(a,function(t,o){e.each(l[o].columns,function(e,t){t.getGrouped()||(t._bDependendGrouped=!0)})}),a.length==p.length)){r=o.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());var c=l[r.getName()].columns;e.each(c,function(e,t){t._bLastGroupAndGrouped=!0})}1==s.length&&e.each(l[s[0]].columns,function(e,t){t._isLastGroupableLeft=!0})}}},_.prototype._getFirstMeasureColumnIndex=function(){var e=this.getBinding(\"rows\"),t=e&&e.getAnalyticalQueryResult(),o=this._getVisibleColumns();if(!t)return-1;for(var n=0;n<o.length;n++){var r=o[n],i=r.getLeadingProperty();if(t.findMeasureByName(i)||t.findMeasureByPropertyName(i))return n}},_.prototype.getTotalSize=function(){var e=this.getBinding(\"rows\");return e?e.getTotalSize():0},_.prototype._onPersoApplied=function(){o.prototype._onPersoApplied.apply(this,arguments),this._aGroupedColumns=[];for(var e=this.getColumns(),t=0,n=e.length;t<n;t++)e[t].getGrouped()&&this._addGroupedColumn(e[t].getId());this._updateColumns()},_.prototype._addGroupedColumn=function(e){-1===this._aGroupedColumns.indexOf(e)&&this._aGroupedColumns.push(e)},_.prototype._removeGroupedColumn=function(e){var t=this._aGroupedColumns.indexOf(e);t>=0&&this._aGroupedColumns.splice(t,1)},_.prototype.getGroupedColumns=function(){return this._aGroupedColumns},_.prototype.setCollapseRecursive=function(t){var o=this.getBinding(\"rows\");return o&&(e.sap.assert(o.setCollapseRecursive,\"Collapse Recursive is not supported by the used binding\"),o.setCollapseRecursive&&o.setCollapseRecursive(t)),this.setProperty(\"collapseRecursive\",!!t,!0),this},_.prototype._getSelectableRowCount=function(){var e=this.getBinding(\"rows\");if(e){var t=e.getGrandTotalContextInfo();return t?t.totalNumberOfLeafs:0}},_.prototype.isIndexSelected=n.prototype.isIndexSelected,_.prototype.setSelectedIndex=n.prototype.setSelectedIndex,_.prototype.getSelectedIndices=n.prototype.getSelectedIndices,_.prototype.setSelectionInterval=n.prototype.setSelectionInterval,_.prototype.addSelectionInterval=n.prototype.addSelectionInterval,_.prototype.removeSelectionInterval=n.prototype.removeSelectionInterval,_.prototype.selectAll=n.prototype.selectAll,_.prototype.getSelectedIndex=n.prototype.getSelectedIndex,_.prototype.clearSelection=n.prototype.clearSelection,_.prototype._isRowSelectable=function(e){var t=this.getBinding(\"rows\");return!!t&&t.isIndexSelectable(e)},_.prototype._getSelectedIndicesCount=n.prototype._getSelectedIndicesCount,_.prototype.getAnalyticalInfoOfRow=function(e){if(!this._validateRow(e))return null;var t=this.getBindingInfo(\"rows\"),o=this.getBinding(\"rows\");if(!t||!o)return null;var n=e.getBindingContext(t.model);if(!n)return null;var r=n===o.getGrandTotalContext(),i=null,a=-1;r?(i=o.getGrandTotalContextInfo(),a=0):(i=this.getContextInfoByIndex(e.getIndex()))&&(a=i.level);var s=i&&o.nodeHasChildren&&o.nodeHasChildren(i),p=!s&&!r&&i&&i.nodeState&&i.nodeState.sum,l=[];if(p||s){var u=this.getGroupedColumns();if(u.length>0&&a>0&&a<=u.length)for(var d=0;d<a;d++)l.push(u[d])}return{grandTotal:r,group:s,groupTotal:p,level:a,context:n,groupedColumns:l}},_});",
		"sap/ui/table/AnalyticalTableRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/table/AnalyticalTable\"],function(e){\"use strict\";return e.getMetadata().getRenderer()},!0);",
		"sap/ui/table/Column.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Element\",\"sap/ui/core/library\",\"sap/ui/core/Popup\",\"sap/ui/core/RenderManager\",\"sap/ui/model/Filter\",\"sap/ui/model/FilterOperator\",\"sap/ui/model/FilterType\",\"sap/ui/model/Sorter\",\"sap/ui/model/Type\",\"sap/ui/model/type/String\",\"./TableUtils\",\"./library\",\"./ColumnMenu\"],function(e,t,r,i,o,n,s,a,l,p,u,h,g,f){\"use strict\";var d=r.HorizontalAlign,y=g.SortOrder,c=r.ValueState,_=t.extend(\"sap.ui.table.Column\",{metadata:{library:\"sap.ui.table\",properties:{width:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:null},minWidth:{type:\"int\",group:\"Dimension\",defaultValue:0},flexible:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},resizable:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},hAlign:{type:\"sap.ui.core.HorizontalAlign\",group:\"Appearance\",defaultValue:d.Begin},sorted:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},sortOrder:{type:\"sap.ui.table.SortOrder\",group:\"Appearance\",defaultValue:y.Ascending},sortProperty:{type:\"string\",group:\"Behavior\",defaultValue:null},filtered:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},filterProperty:{type:\"string\",group:\"Behavior\",defaultValue:null},filterValue:{type:\"string\",group:\"Behavior\",defaultValue:null},filterOperator:{type:\"string\",group:\"Behavior\",defaultValue:null},defaultFilterOperator:{type:\"string\",group:\"Behavior\",defaultValue:null},filterType:{type:\"any\",group:\"Misc\",defaultValue:null},grouped:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},visible:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},name:{type:\"string\",group:\"Appearance\",defaultValue:null},showFilterMenuEntry:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},showSortMenuEntry:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},headerSpan:{type:\"any\",group:\"Behavior\",defaultValue:1},autoResizable:{type:\"boolean\",group:\"Behavior\",defaultValue:!1}},defaultAggregation:\"label\",aggregations:{label:{type:\"sap.ui.core.Control\",altTypes:[\"string\"],multiple:!1},multiLabels:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"multiLabel\"},template:{type:\"sap.ui.core.Control\",multiple:!1},menu:{type:\"sap.ui.unified.Menu\",multiple:!1}},events:{columnMenuOpen:{allowPreventDefault:!0,parameters:{menu:{type:\"sap.ui.unified.Menu\"}}}}}});return _._DEFAULT_FILTER_TYPE=new u,_.prototype.init=function(){this._oSorter=null,this.mSkipPropagation={template:!0},this._aTemplateClones=[]},_.prototype.exit=function(){this._destroyTemplateClones()},_.prototype.setParent=function(e,r,i){t.prototype.setParent.apply(this,arguments);var o=this.getAggregation(\"menu\");o&&\"function\"==typeof o._updateReferences&&o._updateReferences(this)},_.prototype.invalidate=function(e){e===this.getTemplate()||h.isInstanceOf(e,\"sap/ui/table/ColumnMenu\")||t.prototype.invalidate.apply(this,arguments)},_.prototype.setLabel=function(e){var t=e;return\"string\"==typeof e&&(t=g.TableHelper.createLabel({text:e})),this.setAggregation(\"label\",t),this},_.prototype.setTemplate=function(e){var t=e;\"string\"==typeof e&&(t=g.TableHelper.createTextView().bindProperty(\"text\",e)),this.setAggregation(\"template\",t),this.invalidate(),this._destroyTemplateClones();var r=this.getParent();return r&&r.invalidateRowsAggregation&&1==this.getVisible()&&r.invalidateRowsAggregation(),this},_.prototype.getMenu=function(){var e=this.getAggregation(\"menu\");return e||(e=this._createMenu(),this.setMenu(e)),e},_.prototype.invalidateMenu=function(e){var t=this.getAggregation(\"menu\");this._bMenuIsColumnMenu&&(e?t._updateResourceBundle():t._invalidate())},_.prototype._menuHasItems=function(){var e=this.getAggregation(\"menu\"),t=this.getParent(),r=function(){return this.isSortableByMenu()||this.isFilterableByMenu()||this.isGroupableByMenu()||t&&t.getEnableColumnFreeze()||t&&t.getShowColumnVisibilityMenu()}.bind(this);return!!(e&&e.getItems().length>0||r())},_.prototype.isFilterableByMenu=function(){return!(!this.getFilterProperty()||!this.getShowFilterMenuEntry())},_.prototype.isSortableByMenu=function(){return!(!this.getSortProperty()||!this.getShowSortMenuEntry())},_.prototype.isGroupableByMenu=function(){var e=this.getParent();return!!(e&&e.getEnableGrouping&&e.getEnableGrouping()&&this.getSortProperty())},_.prototype.setMenu=function(e){return this.setAggregation(\"menu\",e,!0),this._bMenuIsColumnMenu=h.isInstanceOf(e,\"sap/ui/table/ColumnMenu\"),this},_.prototype._createMenu=function(){return this._defaultMenu||(this._defaultMenu=new f(this.getId()+\"-menu\",{ariaLabelledBy:this})),this._defaultMenu},_.prototype._setAppDefault=function(e,t){this._appDefaults||(this._appDefaults={}),\"sorted\"==e?this._appDefaults.sorted=t:\"sortOrder\"==e?this._appDefaults.sortOrder=t:\"filtered\"==e?this._appDefaults.filtered=t:\"filterValue\"==e?this._appDefaults.filterValue=t:\"filterOperator\"==e&&(this._appDefaults.filterOperator=t)},_.prototype._restoreAppDefaults=function(){this._appDefaults&&(this.setProperty(\"sorted\",this._appDefaults.sorted,!0),this.setProperty(\"sortOrder\",this._appDefaults.sortOrder,!0),this.setProperty(\"filtered\",this._appDefaults.filtered,!0),this.setProperty(\"filterValue\",this._appDefaults.filterValue,!0),this.setProperty(\"filterOperator\",this._appDefaults.filterOperator,!0),this._updateIcons())},_.prototype.setSortProperty=function(e){return this.setProperty(\"sortProperty\",e),this.invalidateMenu(),this},_.prototype.setSorted=function(e){return this.setProperty(\"sorted\",e,!0),this._setAppDefault(\"sorted\",e),this._updateIcons(),this},_.prototype.setSortOrder=function(e){return this.setProperty(\"sortOrder\",e,!0),this._setAppDefault(\"sortOrder\",e),this._updateIcons(),this},_.prototype.setFilterProperty=function(e){return this.invalidateMenu(),this.setProperty(\"filterProperty\",e)},_.prototype.setFiltered=function(e){return this.setProperty(\"filtered\",e,!0),this._setAppDefault(\"filtered\",e),this._updateIcons(),this},_.prototype.setFilterValue=function(e){this.setProperty(\"filterValue\",e,!0),this._setAppDefault(\"filterValue\",e);var t=this.getMenu();return this._bMenuIsColumnMenu&&t._setFilterValue(e),this},_.prototype.setFilterOperator=function(e){return this._setAppDefault(\"filterOperator\",e),this.setProperty(\"filterOperator\",e,!0)},_.prototype._openMenu=function(e,t){var r=this.getMenu();if(this.fireColumnMenuOpen({menu:r})){var o=i.Dock,n=e;e||(e=this.getDomRef(),n=this.getFocusDomRef()),r.open(!!t,n,o.BeginTop,o.BeginBottom,e,\"none none\")}},_.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===y.Ascending)},_.prototype.sort=function(t,r){var i=this.getParent();if(i){i.pushSortedColumn(this,r);var o=t?y.Descending:y.Ascending;if(i.fireSort({column:this,sortOrder:o,columnAdded:r})){for(var n=i.getSortedColumns(),s=i.getColumns(),a=0,p=s.length;a<p;a++)e.inArray(s[a],n)<0&&(s[a].setProperty(\"sorted\",!1,!0),s[a].setProperty(\"sortOrder\",y.Ascending,!0),s[a]._updateIcons(),delete s[a]._oSorter);this.setProperty(\"sorted\",!0,!0),this.setProperty(\"sortOrder\",o,!0),this._oSorter=new l(this.getSortProperty(),this.getSortOrder()===y.Descending);for(var u=[],a=0,p=n.length;a<p;a++)n[a]._updateIcons(),u.push(n[a]._oSorter);var h=i.getBinding(\"rows\");h?(h.sort(u),this._afterSort&&this._afterSort()):e.sap.log.warning(\"Sorting not performed because no binding present\",this)}}return this},_.prototype._updateIcons=function(){var e=this.getParent(),t=this.getSorted(),r=this.getFiltered();e&&e.getDomRef()&&(this.$().find(\".sapUiTableColCell\").toggleClass(\"sapUiTableColSF\",t||r).toggleClass(\"sapUiTableColFiltered\",r).toggleClass(\"sapUiTableColSorted\",t).toggleClass(\"sapUiTableColSortedD\",t&&this.getSortOrder()===y.Descending),e._getAccExtension().updateAriaStateOfColumn(this))},_.prototype._renderSortIcon=function(){this._updateIcons()},_.prototype._getFilter=function(){var e,t,r,i,o=this.getFilterProperty(),a=this.getFilterValue(),l=this.getFilterOperator(),p=this.getFilterType()||_._DEFAULT_FILTER_TYPE,h=p instanceof u;return a&&(l?e=new n(o,l,this._parseFilterValue(a)):(i=a.match(/(.*)\\s*\\.\\.\\s*(.*)/),0==a.indexOf(\"=\")?(l=s.EQ,t=a.substr(1)):0==a.indexOf(\"!=\")?(l=s.NE,t=a.substr(2)):0==a.indexOf(\"<=\")?(l=s.LE,t=a.substr(2)):0==a.indexOf(\"<\")?(l=s.LT,t=a.substr(1)):0==a.indexOf(\">=\")?(l=s.GE,t=a.substr(2)):0==a.indexOf(\">\")?(l=s.GT,t=a.substr(1)):i?i[1]&&i[2]?(l=s.BT,t=i[1],r=i[2]):i[1]&&!i[2]?(l=s.GE,t=i[1]):(l=s.LE,t=i[2]):h&&0==a.indexOf(\"*\")&&a.lastIndexOf(\"*\")==a.length-1?(l=s.Contains,t=a.substr(1,a.length-2)):h&&0==a.indexOf(\"*\")?(l=s.EndsWith,t=a.substr(1)):h&&a.lastIndexOf(\"*\")==a.length-1?(l=s.StartsWith,t=a.substr(0,a.length-1)):(l=this.getDefaultFilterOperator()?this.getDefaultFilterOperator():h?s.Contains:s.EQ,t=a.substr(0)),e=r?new n(o,l,this._parseFilterValue(t),this._parseFilterValue(r)):new n(o,l,this._parseFilterValue(t)))),e},_.prototype.filter=function(e){var t=this.getParent();if(t&&t.isBound(\"rows\")){if(t.fireFilter({column:this,value:e})){this.setProperty(\"filtered\",!!e,!0),this.setProperty(\"filterValue\",e,!0);var r=this.getMenu();this._bMenuIsColumnMenu&&r._setFilterValue(e);for(var i=[],o=t.getColumns(),n=0,s=o.length;n<s;n++){var l,p=o[n];r=p.getMenu();try{l=p._getFilter(),p._bMenuIsColumnMenu&&r._setFilterState(c.None)}catch(e){p._bMenuIsColumnMenu&&r._setFilterState(c.Error);continue}l&&i.push(l)}t.getBinding(\"rows\").filter(i,a.Control),this._updateIcons()}}return this},_.prototype._parseFilterValue=function(t){var r=this.getFilterType();return r&&(t=e.isFunction(r)?r(t):r.parseValue(t,\"string\")),t},_.prototype._restoreIcons=function(){this._updateIcons()},_.prototype.shouldRender=function(){return this.getVisible()&&!this.getGrouped()},_.PROPERTIES_FOR_ROW_INVALIDATION={visible:!0,flexible:!0,headerSpan:!0},_.prototype.setProperty=function(e,r){var i=this.getParent();return i&&i.invalidateRowsAggregation&&this.getProperty(e)!=r&&_.PROPERTIES_FOR_ROW_INVALIDATION[e]&&(this.getVisible()||\"visible\"==e)&&i.invalidateRowsAggregation(),t.prototype.setProperty.apply(this,arguments)},_.prototype.setFilterType=function(t){var r=t;if(\"string\"==typeof t){try{var i=e.sap.parseJS(t);if(\"string\"==typeof i.type){var o=e.sap.getObject(i.type);r=o&&new o(i.formatOptions,i.constraints)}}catch(i){var o=e.sap.getObject(t);r=o&&new o}r instanceof p||(e.sap.log.error(\"The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!\"),r=void 0)}return this.setProperty(\"filterType\",r,!0),this},_.prototype.getIndex=function(){var e=this.getParent();return e?e.indexOfColumn(this):-1},_.prototype._getFreeTemplateClone=function(){for(var e=null,t=0;t<this._aTemplateClones.length;t++)null==this._aTemplateClones[t]||this._aTemplateClones[t].bIsDestroyed?(this._aTemplateClones.splice(t,1),t--):null===e&&null==this._aTemplateClones[t].getParent()&&(e=this._aTemplateClones[t]);return e},_.prototype.getTemplateClone=function(e){if(null==e)return null;var t=this._getFreeTemplateClone();if(null===t){var r=this.getTemplate();r&&(t=r.clone(),this._aTemplateClones.push(t))}if(null!=t){t.data(\"sap-ui-colindex\",e),t.data(\"sap-ui-colid\",this.getId());var i=this.getParent();null!=i&&i._getAccExtension().addColumnHeaderLabel(this,t)}return t},_.prototype._destroyTemplateClones=function(){for(var e=0;e<this._aTemplateClones.length;e++)null==this._aTemplateClones[e]||this._aTemplateClones[e].bIsDestroyed||this._aTemplateClones[e].destroy();this._aTemplateClones=[]},_});",
		"sap/ui/table/ColumnMenu.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/RenderManager\",\"./library\",\"sap/ui/unified/Menu\",\"sap/ui/unified/MenuItem\",\"sap/ui/unified/MenuTextFieldItem\",\"sap/ui/Device\",\"./TableUtils\"],function(t,e,i,n,o,a,s,u){\"use strict\";var l=n.extend(\"sap.ui.table.ColumnMenu\",{metadata:{library:\"sap.ui.table\"},renderer:\"sap.ui.unified.MenuRenderer\"});return l.prototype.init=function(){n.prototype.init&&n.prototype.init.apply(this,arguments),this.addStyleClass(\"sapUiTableColumnMenu\"),this._oResBundle=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.table\"),this._bInvalidated=!0,this._iPopupClosedTimeoutId=null,this._oColumn=null,this._oTable=null,this._attachPopupClosed()},l.prototype.exit=function(){n.prototype.exit&&n.prototype.exit.apply(this,arguments),window.clearTimeout(this._iPopupClosedTimeoutId),this._detachEvents(),this._oColumn=this._oTable=null},l.prototype.onThemeChanged=function(){this.getDomRef()&&this._invalidate()},l.prototype.setParent=function(t){return this._detachEvents(),this._invalidate(),this._updateReferences(t),this._attachEvents(),n.prototype.setParent.apply(this,arguments)},l.prototype._updateReferences=function(e){this._oColumn=e,e&&(t.sap.assert(u.isInstanceOf(e,\"sap/ui/table/Column\"),\"ColumnMenu.setParent: parent must be a subclass of sap.ui.table.Column\"),this._oTable=this._oColumn.getParent(),this._oTable&&t.sap.assert(u.isInstanceOf(this._oTable,\"sap/ui/table/Table\"),\"ColumnMenu.setParent: parent of parent must be subclass of sap.ui.table.Table\"))},l.prototype._attachEvents=function(){this._oTable&&(this._oTable.attachColumnVisibility(this._invalidate,this),this._oTable.attachColumnMove(this._invalidate,this))},l.prototype._detachEvents=function(){this._oTable&&(this._oTable.detachColumnVisibility(this._invalidate,this),this._oTable.detachColumnMove(this._invalidate,this))},l.prototype._invalidate=function(){this._bInvalidated=!0},l.prototype._updateResourceBundle=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.table\"),this._invalidate()},l.prototype._attachPopupClosed=function(){var t=this;s.support.touch||this.getPopup().attachClosed(function(){t._iPopupClosedTimeoutId=window.setTimeout(function(){t._oColumn&&(t._lastFocusedDomRef?t._lastFocusedDomRef.focus():t._oColumn.focus())},0)})},l.prototype.open=function(){this._bInvalidated&&(this._bInvalidated=!1,this.destroyItems(),this._addMenuItems()),this.getItems().length>0&&(this._lastFocusedDomRef=arguments[4],n.prototype.open.apply(this,arguments))},l.prototype._addMenuItems=function(){this._oColumn&&(this._addSortMenuItem(!1),this._addSortMenuItem(!0),this._addFilterMenuItem(),this._addGroupMenuItem(),this._addFreezeMenuItem(),this._addColumnVisibilityMenuItem())},l.prototype._addSortMenuItem=function(t){var e=this._oColumn;if(e.isSortableByMenu()){var i=t?\"desc\":\"asc\",n=t?\"sort-descending\":\"sort-ascending\";this.addItem(this._createMenuItem(i,\"TBL_SORT_\"+i.toUpperCase(),n,function(i){e.sort(t,!0===i.getParameter(\"ctrlKey\"))}))}},l.prototype._addFilterMenuItem=function(){var t=this._oColumn;if(t.isFilterableByMenu()){var e=t.getParent();e&&e.getEnableCustomFilter()?this.addItem(this._createMenuItem(\"filter\",\"TBL_FILTER_ITEM\",\"filter\",function(){e.fireCustomFilter({column:t})})):this.addItem(this._createMenuTextFieldItem(\"filter\",\"TBL_FILTER\",\"filter\",t.getFilterValue(),function(){t.filter(this.getValue())}))}},l.prototype._addGroupMenuItem=function(){var t=this._oColumn;if(t.isGroupableByMenu()){var e=this._oTable;this.addItem(this._createMenuItem(\"group\",\"TBL_GROUP\",null,function(){e.setGroupBy(t)}))}},l.prototype._addFreezeMenuItem=function(){var t=this._oColumn,e=this._oTable;if(e&&e.getEnableColumnFreeze()){var i=t.getIndex(),n=i+u.Column.getHeaderSpan(t)==e.getFixedColumnCount();this.addItem(this._createMenuItem(\"freeze\",n?\"TBL_UNFREEZE\":\"TBL_FREEZE\",null,function(){e.fireColumnFreeze({column:t})&&(n?e.setFixedColumnCount(0):e.setFixedColumnCount(i+1))}))}},l.prototype._addColumnVisibilityMenuItem=function(){var t=this._oTable;if(t&&t.getShowColumnVisibilityMenu()){var e=this._createMenuItem(\"column-visibilty\",\"TBL_COLUMNS\");this.addItem(e);var i=new n(e.getId()+\"-menu\");e.setSubmenu(i);var o=t.getColumns();if(t.getColumnVisibilityMenuSorter&&\"function\"==typeof t.getColumnVisibilityMenuSorter){var a=t.getColumnVisibilityMenuSorter();\"function\"==typeof a&&(o=o.sort(a))}for(var s=t.getBinding(),l=u.isInstanceOf(s,\"sap/ui/model/analytics/AnalyticalBinding\"),r=0,p=o.length;r<p;r++){var d=o[r];if(l&&u.isInstanceOf(d,\"sap/ui/table/AnalyticalColumn\")){var c=s.getAnalyticalQueryResult(),h=c.getEntityType(),m=s.getModel().getProperty(\"/#\"+h.getTypeDescription().name+\"/\"+d.getLeadingProperty()+\"/sap:visible\");if(m&&(\"false\"===m.value||!1===m.value))continue}var _=this._createColumnVisibilityMenuItem(i.getId()+\"-item-\"+r,d);i.addItem(_)}}},l.prototype._createColumnVisibilityMenuItem=function(e,i){var n=i.getName()||(i.getLabel()&&i.getLabel().getText?i.getLabel().getText():null);return new o(e,{text:n,icon:i.getVisible()?\"sap-icon://accept\":null,select:t.proxy(function(t){var e=t.getSource(),n=!i.getVisible();if(n||u.getVisibleColumnCount(this._oTable)>1){var o=i.getParent(),a=!0;o&&u.isInstanceOf(o,\"sap/ui/table/Table\")&&(a=o.fireColumnVisibility({column:i,newVisible:n})),a&&i.setVisible(n),e.setIcon(n?\"sap-icon://accept\":null)}},this)})},l.prototype._createMenuItem=function(t,e,i,n){return new o(this.getId()+\"-\"+t,{text:this._oResBundle.getText(e),icon:i?\"sap-icon://\"+i:null,select:n||function(){}})},l.prototype._createMenuTextFieldItem=function(t,e,i,n,o){return o=o||function(){},new a(this.getId()+\"-\"+t,{label:this._oResBundle.getText(e),icon:i?\"sap-icon://\"+i:null,value:n,select:o||function(){}})},l.prototype._setFilterValue=function(t){var e=this.getParent(),i=e?e.getParent():void 0,n=sap.ui.getCore().byId(this.getId()+\"-filter\");return n&&i&&!i.getEnableCustomFilter()&&n.setValue(t),this},l.prototype._setFilterState=function(t){var e=this.getParent(),i=e?e.getParent():void 0,n=sap.ui.getCore().byId(this.getId()+\"-filter\");return n&&i&&!i.getEnableCustomFilter()&&n.setValueState(t),this},l});",
		"sap/ui/table/ColumnMenuRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/table/ColumnMenu\"],function(e){\"use strict\";return e.getMetadata().getRenderer()},!0);",
		"sap/ui/table/library.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Core\",\"sap/ui/model/TreeAutoExpandMode\",\"sap/ui/core/library\",\"sap/ui/unified/library\"],function(e,a,o){\"use strict\";sap.ui.getCore().initLibrary({name:\"sap.ui.table\",version:\"1.48.6\",dependencies:[\"sap.ui.core\",\"sap.ui.unified\"],types:[\"sap.ui.table.NavigationMode\",\"sap.ui.table.RowActionType\",\"sap.ui.table.SelectionBehavior\",\"sap.ui.table.SelectionMode\",\"sap.ui.table.SortOrder\",\"sap.ui.table.VisibleRowCountMode\",\"sap.ui.table.SharedDomRef\",\"sap.ui.table.TreeAutoExpandMode\"],interfaces:[],controls:[\"sap.ui.table.AnalyticalColumnMenu\",\"sap.ui.table.AnalyticalTable\",\"sap.ui.table.ColumnMenu\",\"sap.ui.table.Table\",\"sap.ui.table.TreeTable\",\"sap.ui.table.RowAction\"],elements:[\"sap.ui.table.AnalyticalColumn\",\"sap.ui.table.Column\",\"sap.ui.table.Row\",\"sap.ui.table.RowActionItem\",\"sap.ui.table.RowSettings\"],extensions:{flChangeHandlers:{\"sap.ui.table.Column\":{propertyChange:\"default\"},\"sap.ui.table.Table\":{moveElements:\"default\"},\"sap.ui.table.AnalyticalTable\":{moveElements:\"default\"}}}});var l=sap.ui.table;return l.NavigationMode={Scrollbar:\"Scrollbar\",Paginator:\"Paginator\"},l.RowActionType={Custom:\"Custom\",Navigation:\"Navigation\",Delete:\"Delete\"},l.SelectionBehavior={Row:\"Row\",RowSelector:\"RowSelector\",RowOnly:\"RowOnly\"},l.SelectionMode={MultiToggle:\"MultiToggle\",Multi:\"Multi\",Single:\"Single\",None:\"None\"},l.SortOrder={Ascending:\"Ascending\",Descending:\"Descending\"},l.VisibleRowCountMode={Fixed:\"Fixed\",Interactive:\"Interactive\",Auto:\"Auto\"},l.SharedDomRef={HorizontalScrollBar:\"hsb\",VerticalScrollBar:\"vsb\"},l.GroupEventType={group:\"group\",ungroup:\"ungroup\",ungroupAll:\"ungroupAll\",moveUp:\"moveUp\",moveDown:\"moveDown\",showGroupedColumn:\"showGroupedColumn\",hideGroupedColumn:\"hideGroupedColumn\"},l.ColumnHeader=l.Column,l.TreeAutoExpandMode=o,l.TableHelper||(l.TableHelper={addTableClass:function(){return\"\"},createLabel:function(e){throw new Error(\"no Label control available!\")},createTextView:function(e){throw new Error(\"no TextView control available!\")},bFinal:!1}),l});",
		"sap/ui/table/Row.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Element\",\"sap/ui/model/Context\",\"./TableUtils\"],function(e,t,o,i){\"use strict\";var s=t.extend(\"sap.ui.table.Row\",{metadata:{library:\"sap.ui.table\",defaultAggregation:\"cells\",aggregations:{cells:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"cell\"},_rowAction:{type:\"sap.ui.table.RowAction\",multiple:!1,visibility:\"hidden\"},_settings:{type:\"sap.ui.table.RowSettings\",multiple:!1,visibility:\"hidden\"}}}});return s.prototype.init=function(){this.initDomRefs()},s.prototype.exit=function(){this.initDomRefs()},s.prototype.getFocusInfo=function(){var e=this.getParent();return e?e.getFocusInfo():t.prototype.getFocusInfo.apply(this,arguments)},s.prototype.applyFocusInfo=function(e){var o=this.getParent();return o?o.applyFocusInfo(e):t.prototype.applyFocusInfo.apply(this,arguments),this},s.prototype.initDomRefs=function(){this._mDomRefs={}},s.prototype.getIndex=function(){var e=this.getParent();if(e){var t=e.indexOfRow(this),o=e.getFixedRowCount();if(o>0&&t<o)return t;var i=e.getFixedBottomRowCount(),s=e.getVisibleRowCount();if(i>0&&t>=s-i){var r=e.getBinding(\"rows\");return r&&r.getLength()>=s?r.getLength()-(s-t):t}return e.getFirstVisibleRow()+t}return-1},s.prototype.getDomRefs=function(t){var o,i;if(!0===t?(o=e.sap.byId,i=\"jQuery\"):(o=e.sap.domById,i=\"dom\"),!this._mDomRefs[i]){this._mDomRefs[i]={};var s=this.getParent();if(s){var r=s.indexOfRow(this);this._mDomRefs[i].rowSelector=o(s.getId()+\"-rowsel\"+r),this._mDomRefs[i].rowAction=o(s.getId()+\"-rowact\"+r)}this._mDomRefs[i].rowScrollPart=o(this.getId()),this._mDomRefs[i].rowFixedPart=o(this.getId()+\"-fixed\"),this._mDomRefs[i].rowSelectorText=o(this.getId()+\"-rowselecttext\"),!0===t&&(this._mDomRefs[i].row=this._mDomRefs[i].rowScrollPart,this._mDomRefs[i].rowFixedPart.length>0?this._mDomRefs[i].row=this._mDomRefs[i].row.add(this._mDomRefs[i].rowFixedPart):this._mDomRefs[i].rowFixedPart=void 0,this._mDomRefs[i].rowSelector&&this._mDomRefs[i].rowSelector.length>0?this._mDomRefs[i].row=this._mDomRefs[i].row.add(this._mDomRefs[i].rowSelector):this._mDomRefs[i].rowSelector=void 0,this._mDomRefs[i].rowAction&&this._mDomRefs[i].rowAction.length>0?this._mDomRefs[i].row=this._mDomRefs[i].row.add(this._mDomRefs[i].rowAction):this._mDomRefs[i].rowAction=void 0)}return this._mDomRefs[i]},s.prototype._updateSelection=function(e,t,o){var s=e.isIndexSelected(this.getIndex()),r=this.getDomRefs(!0),n=\"rowSelect\";if(s&&(n=\"rowDeselect\"),r.rowSelector&&r.rowSelector.attr(\"title\",t.mouse[n]),r.rowSelectorText){var a=\"\";this._bHidden||i.Grouping.isInSumRow(r.rowSelector)||i.Grouping.isInGroupingRow(r.rowSelector)||(a=t.keyboard[n]),r.rowSelectorText.text(a)}var l=r.rowScrollPart;r.rowFixedPart&&(l=l.add(r.rowFixedPart)),o?l.attr(\"title\",t.mouse[n]):l.removeAttr(\"title\"),r.row&&(r.row.toggleClass(\"sapUiTableRowSel\",s),e._getAccExtension().updateAriaStateOfRow(this,r,s))},s.prototype.setRowBindingContext=function(e,t,i){var s;!e||e instanceof o||(s=e,e=e.context);var r=this.getDomRefs(!0).row;this._bHidden=!e,r.toggleClass(\"sapUiTableRowHidden\",this._bHidden),this._collectRenderingInformation(e,s,i),this.setBindingContext(e,t)},s.prototype.setBindingContext=function(e,o){var i=t.prototype.setBindingContext.call(this,e||null,o);return this._updateTableCells(e),i},s.prototype._updateTableCells=function(e){var t=this.getParent();if(t)for(var o,i,s,r=this.getCells(),n=this.getIndex(),a=!!t._updateTableCell,l=0;l<r.length;l++)o=r[l],s=!!o._updateTableCell,i=s||a?o.$().closest(\"td\"):null,s&&o._updateTableCell(o,e,i,n),a&&t._updateTableCell(o,e,i,n)},s.prototype._collectRenderingInformation=function(e,t,o){this._oNodeState=void 0,this._iLevel=0,this._bIsExpanded=!1,this._bHasChildren=!1,this._sTreeIconClass=\"\",t&&(this._oNodeState=t.nodeState,this._iLevel=t.level,this._bIsExpanded=!1,this._bHasChildren=!1,this._sTreeIconClass=\"sapUiTableTreeIconLeaf\",this._sGroupIconClass=\"\",o&&(o.getLevel?this._bIsExpanded=o.isExpanded(this.getIndex()):o.findNode&&(this._bIsExpanded=!(!this||!this._oNodeState)&&this._oNodeState.expanded),o.nodeHasChildren?this._oNodeState&&(this._bHasChildren=o.nodeHasChildren(t)):o.hasChildren&&(this._bHasChildren=o.hasChildren(e)),this._bHasChildren&&(this._sTreeIconClass=this._bIsExpanded?\"sapUiTableTreeIconNodeOpen\":\"sapUiTableTreeIconNodeClosed\",this._sGroupIconClass=this._bIsExpanded?\"sapUiTableGroupIconOpen\":\"sapUiTableGroupIconClosed\")))},s.prototype.destroy=function(){return this.removeAllCells(),t.prototype.destroy.apply(this,arguments)},s});",
		"sap/ui/table/RowAction.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"./TableUtils\",\"./library\",\"sap/ui/core/Icon\",\"sap/ui/unified/Menu\",\"sap/ui/core/Popup\",\"./RowActionItem\"],function(t,e,i,s,o,n,a,r){\"use strict\";var l=e.extend(\"sap.ui.table.RowAction\",{metadata:{library:\"sap.ui.table\",properties:{visible:{type:\"boolean\",group:\"Misc\",defaultValue:!0}},defaultAggregation:\"items\",aggregations:{items:{type:\"sap.ui.table.RowActionItem\",multiple:!0},_icons:{type:\"sap.ui.core.Icon\",multiple:!0,visibility:\"hidden\"},_menu:{type:\"sap.ui.unified.Menu\",multiple:!1,visibility:\"hidden\"}},events:{}}});return l.prototype.init=function(){var e=function(t){return this.setAggregation(\"tooltip\",t,!0),this.setSrc(this.getSrc()),this},i=function(e){this._bKeyboard=e.which===t.sap.KeyCodes.SPACE||e.which===t.sap.KeyCodes.ENTER,o.prototype.onkeyup.apply(this,arguments)},s=this,n=new o(this.getId()+\"-icon0\",{decorative:!1,press:function(t){s._handlePress(t,!0)}});n.addStyleClass(\"sapUiTableActionIcon\"),n.setTooltip=e,n.onkeyup=i,this.addAggregation(\"_icons\",n),n=new o(this.getId()+\"-icon1\",{decorative:!1,press:function(t){s._handlePress(t,!1)}}),n.addStyleClass(\"sapUiTableActionIcon\"),n.setTooltip=e,n.onkeyup=i,this.addAggregation(\"_icons\",n),this._oResBundle=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.table\"),this._iLen=0,this._iCount=2,this._aActions=[\"\",\"\"],this._iLastCloseTime=0},l.prototype.onAfterRendering=function(){this._updateIcons()},l.prototype.setVisible=function(t){return this.setProperty(\"visible\",t,!0),this.$().toggleClass(\"sapUiTableActionHidden\",!t),this},l.prototype.setTooltip=function(t){this.setAggregation(\"tooltip\",t,!0);var e=this.getTooltip_AsString();return e?this.$().attr(\"title\",e):this.$().removeAttr(\"title\"),this},l.prototype.insertItem=function(t,e){return this.insertAggregation(\"items\",t,e,!0),this._updateIcons(!0),this},l.prototype.addItem=function(t){return this.addAggregation(\"items\",t,!0),this._updateIcons(!0),this},l.prototype.removeItem=function(t){var e=this.removeAggregation(\"items\",t,!0);return this._updateIcons(!0),e},l.prototype.removeAllItems=function(){var t=this.removeAllAggregation(\"items\",!0);return this._updateIcons(!0),t},l.prototype.destroyItems=function(){return this.destroyAggregation(\"items\",!0),this._updateIcons(!0),this},l.prototype.getAccessibilityInfo=function(){var t,e=this.$().parent(),i=this.getVisible()&&this._iLen>0&&this._iCount>0&&!e.hasClass(\"sapUiTableRowHidden\")&&!e.hasClass(\"sapUiTableGroupHeader\")&&!e.hasClass(\"sapUiAnalyticalTableSum\");return t=i?this._oResBundle.getText(1==this._iLen?\"TBL_ROW_ACTION_SINGLE_ACTION\":\"TBL_ROW_ACTION_MULTIPLE_ACTION\",[this._iLen]):this._oResBundle.getText(\"TBL_ROW_ACTION_NO_ACTION\"),{focusable:i,enabled:i,description:t}},l.prototype._getVisibleItems=function(t){if(!this._aVisibleItems||t){this._aVisibleItems=[],this._iLen=0;for(var e=this.getItems(),i=0;i<e.length;i++)e[i].getVisible()&&(this._aVisibleItems.push(e[i]),this._iLen++)}return this._aVisibleItems},l.prototype._getRow=function(){return this.getParent()},l.prototype._getCount=function(){return this._iCount},l.prototype._setCount=function(t){t<0?this._iCount=0:t>=0&&(this._iCount=Math.min(t,2)),this._updateIcons()},l.prototype._setFixedLayout=function(t){this._bFixedLayout=!!t,this._updateIcons()},l.prototype._setIconLabel=function(t){for(var e=this.getAggregation(\"_icons\"),i=0;i<e.length;i++)e[i].removeAllAriaLabelledBy(),t&&e[i].addAriaLabelledBy(t)},l.prototype._handlePress=function(t,e){var i=e?0:1,s=this.getAggregation(\"_icons\")[i],o=this._aActions[i],r=s._bKeyboard;if(s._bKeyboard=!1,\"action\"==o)this._getVisibleItems()[i]._doFirePress();else if(\"action_fixed\"==o)this._getVisibleItems()[0]._doFirePress();else if(\"menu\"==o){var l=this.getAggregation(\"_menu\");if(l||(l=new n,this.setAggregation(\"_menu\",l,!0),l.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now()},this)),l.removeAllItems(),Date.now()-this._iLastCloseTime<500)return;for(var p=this.getItems(),h=e?0:1;h<p.length;h++)l.addItem(p[h]._getMenuItem());l.open(!!r,s,a.Dock.EndTop,a.Dock.EndBottom,s)}},l.prototype._updateIcons=function(e){function i(t){o[0].$()[0==t?\"attr\":\"removeAttr\"](\"aria-haspopup\",0==t?\"true\":void 0),o[1].$()[1==t?\"attr\":\"removeAttr\"](\"aria-haspopup\",1==t?\"true\":void 0)}var s=this._getVisibleItems(e),o=this.getAggregation(\"_icons\"),n=this.$().children();if(this._bFixedLayout&&1==this._iLen&&2==this._iCount){var a=this.getItems();if(a.length>1&&s[0]===a[1])return s[0]._syncIcon(o[1]),t(n.get(0)).toggleClass(\"sapUiTableActionHidden\",!0),t(n.get(1)).toggleClass(\"sapUiTableActionHidden\",!1),i(-1),void(this._aActions=[\"\",\"action_fixed\"])}0==this._iLen||0==this._iCount?(n.toggleClass(\"sapUiTableActionHidden\",!0),i(-1),this._aActions=[\"\",\"\"]):1==this._iLen&&this._iCount>0?(s[0]._syncIcon(o[0]),t(n.get(0)).toggleClass(\"sapUiTableActionHidden\",!1),t(n.get(1)).toggleClass(\"sapUiTableActionHidden\",!0),i(-1),this._aActions=[\"action\",\"\"]):2==this._iLen&&2==this._iCount?(s[0]._syncIcon(o[0]),s[1]._syncIcon(o[1]),n.toggleClass(\"sapUiTableActionHidden\",!1),i(-1),this._aActions=[\"action\",\"action\"]):this._iLen>2&&2==this._iCount?(s[0]._syncIcon(o[0]),o[1].setSrc(\"sap-icon://overflow\"),o[1].setTooltip(this._oResBundle.getText(\"TBL_ROW_ACTION_MORE\")),n.toggleClass(\"sapUiTableActionHidden\",!1),i(1),this._aActions=[\"action\",\"menu\"]):(o[0].setSrc(\"sap-icon://overflow\"),o[0].setTooltip(this._oResBundle.getText(\"TBL_ROW_ACTION_MORE\")),t(n.get(0)).toggleClass(\"sapUiTableActionHidden\",!1),t(n.get(1)).toggleClass(\"sapUiTableActionHidden\",!0),i(0),this._aActions=[\"menu\",\"\"])},l});",
		"sap/ui/table/RowActionItem.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Element\",\"./library\",\"sap/ui/unified/MenuItem\"],function(t,e,i){\"use strict\";var o=e.RowActionType,s=t.extend(\"sap.ui.table.RowActionItem\",{metadata:{library:\"sap.ui.table\",properties:{icon:{type:\"sap.ui.core.URI\",group:\"Data\",defaultValue:null},visible:{type:\"boolean\",group:\"Misc\",defaultValue:!0},text:{type:\"string\",group:\"Misc\",defaultValue:\"\"},type:{type:\"sap.ui.table.RowActionType\",group:\"Behavior\",defaultValue:o.Custom}},events:{press:{item:{type:\"sap.ui.table.RowActionItem\"},row:{type:\"sap.ui.table.Row\"}}}}});return s.prototype.exit=function(){this._menuItem&&(this._menuItem.destroy(),this._menuItem=null)},s.prototype.setIcon=function(t){return this.setProperty(\"icon\",t,!0),this._updateRowAction(),this},s.prototype.setText=function(t){return this.setProperty(\"text\",t,!0),this._updateRowAction(),this},s.prototype.setType=function(t){return this.setProperty(\"type\",t,!0),this._updateRowAction(),this},s.prototype.setVisible=function(t){return this.setProperty(\"visible\",t,!0),this._updateRowAction(!0),this},s.prototype.setTooltip=function(t){return this.setAggregation(\"tooltip\",t,!0),this._updateRowAction(),this},s.prototype._doFirePress=function(){var t=this.getParent();this.firePress({item:this,row:t&&t._getRow?t._getRow():null})},s.prototype._getMenuItem=function(){if(!this._menuItem){var t=this;this._menuItem=new i({select:function(e){t._doFirePress()}})}return this._menuItem.setIcon(this._getIcon()),this._menuItem.setVisible(this.getVisible()),this._menuItem.setText(this._getText(!1)),this._menuItem},s.prototype._getIcon=function(){var t=this.getIcon();return t||(this.getType()==o.Navigation?\"sap-icon://navigation-right-arrow\":this.getType()==o.Delete?\"sap-icon://sys-cancel\":null)},s.prototype._getText=function(t){var e=t?this.getTooltip_AsString()||this.getText():this.getText()||this.getTooltip_AsString();return e||(this.getType()==o.Navigation?this.getParent()._oResBundle.getText(\"TBL_ROW_ACTION_NAVIGATE\"):this.getType()==o.Delete?this.getParent()._oResBundle.getText(\"TBL_ROW_ACTION_DELETE\"):null)},s.prototype._syncIcon=function(t){t.setSrc(this._getIcon()),t.setTooltip(this._getText(!0))},s.prototype._updateRowAction=function(t){var e=this.getParent();e&&e._updateIcons&&e._updateIcons(t)},s});",
		"sap/ui/table/RowActionRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/table/Row\"],function(e,t){\"use strict\";var i={};return i.render=function(e,i){e.write(\"<div\"),e.writeControlData(i),e.addClass(\"sapUiTableAction\"),i.getParent()instanceof t||e.addStyle(\"display\",\"none\"),i.getVisible()||e.addClass(\"sapUiTableActionHidden\"),e.writeClasses(),e.writeStyles();var r=i.getTooltip_AsString();r&&e.writeAttributeEscaped(\"title\",r),e.write(\">\");var a=i.getAggregation(\"_icons\");e.write(\"<div>\"),e.renderControl(a[0]),e.write(\"</div>\"),e.write(\"<div>\"),e.renderControl(a[1]),e.write(\"</div>\"),e.write(\"</div>\")},i},!0);",
		"sap/ui/table/RowSettings.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Element\",\"./TableUtils\",\"./library\",\"sap/ui/core/MessageType\"],function(t,e,i,a,s){\"use strict\";var r=e.extend(\"sap.ui.table.RowSettings\",{metadata:{library:\"sap.ui.table\",properties:{highlight:{type:\"sap.ui.core.MessageType\",group:\"Appearance\",defaultValue:\"None\"}}}});return r.prototype.init=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.table\")},r.prototype.setHighlight=function(t){var e,i;if(this.setProperty(\"highlight\",t,!0),null==(e=this._getRow()))return this;if(null==(i=e.getDomRef(\"highlight\")))return this;for(var a in s)i.classList.remove(\"sapUiTableRowHighlight\"+a);i.classList.add(this._getHighlightCSSClassName());var r=e.getParent(),l=null!=r?r._getAccExtension():null;return null!=l&&l.updateAriaStateOfRowHighlight(this),this},r.prototype._getHighlightCSSClassName=function(){var t=this.getHighlight();return null==t&&(t=s.None),\"sapUiTableRowHighlight\"+t},r.prototype._getHighlightText=function(){var t=this.getHighlight();return null==t||t===s.None?\"\":this._oResBundle.getText(\"TBL_ROW_STATE_\"+t.toUpperCase())},r.prototype._getRow=function(){var t=this.getParent();return i.isInstanceOf(t,\"sap/ui/table/Row\")?t:null},r});",
		"sap/ui/table/Table.designtime.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";return{aggregations:{columns:{domRef:\".sapUiTableCHA\"},hScroll:{ignore:!1,domRef:function(e){return e.$(\"hsb\").get(0)}},vScroll:{ignore:!1,domRef:function(e){return e.$(\"vsb\").get(0)}}}}},!1);",
		"sap/ui/table/Table.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/Device\",\"sap/ui/core/Control\",\"sap/ui/core/Element\",\"sap/ui/core/IconPool\",\"sap/ui/core/ResizeHandler\",\"sap/ui/core/ScrollBar\",\"sap/ui/core/delegate/ItemNavigation\",\"sap/ui/core/theming/Parameters\",\"sap/ui/model/ChangeReason\",\"sap/ui/model/Context\",\"sap/ui/model/Filter\",\"sap/ui/model/SelectionModel\",\"sap/ui/model/Sorter\",\"./Column\",\"./Row\",\"./library\",\"./TableUtils\",\"./TableExtension\",\"./TableAccExtension\",\"./TableKeyboardExtension\",\"./TablePointerExtension\",\"./TableScrollExtension\",\"jquery.sap.dom\",\"jquery.sap.trace\"],function(t,e,i,o,n,s,r,a,l,h,u,d,g,p,c,w,f,R,b,m,_,C,y){\"use strict\";var v=f.GroupEventType,S=f.NavigationMode,T=f.SelectionMode,x=f.SelectionBehavior,A=f.SortOrder,B=f.VisibleRowCountMode,H=i.extend(\"sap.ui.table.Table\",{metadata:{library:\"sap.ui.table\",properties:{width:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:\"auto\"},rowHeight:{type:\"int\",group:\"Appearance\",defaultValue:null},columnHeaderHeight:{type:\"int\",group:\"Appearance\",defaultValue:null},columnHeaderVisible:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},visibleRowCount:{type:\"int\",group:\"Appearance\",defaultValue:10},firstVisibleRow:{type:\"int\",group:\"Appearance\",defaultValue:0},selectionMode:{type:\"sap.ui.table.SelectionMode\",group:\"Behavior\",defaultValue:T.MultiToggle},selectionBehavior:{type:\"sap.ui.table.SelectionBehavior\",group:\"Behavior\",defaultValue:x.RowSelector},selectedIndex:{type:\"int\",group:\"Appearance\",defaultValue:-1},editable:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},navigationMode:{type:\"sap.ui.table.NavigationMode\",group:\"Behavior\",defaultValue:S.Scrollbar},threshold:{type:\"int\",group:\"Appearance\",defaultValue:100},enableColumnReordering:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},enableGrouping:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},showColumnVisibilityMenu:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},showNoData:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},visibleRowCountMode:{type:\"sap.ui.table.VisibleRowCountMode\",group:\"Appearance\",defaultValue:B.Fixed},minAutoRowCount:{type:\"int\",group:\"Appearance\",defaultValue:5},fixedColumnCount:{type:\"int\",group:\"Appearance\",defaultValue:0},fixedRowCount:{type:\"int\",group:\"Appearance\",defaultValue:0},fixedBottomRowCount:{type:\"int\",group:\"Appearance\",defaultValue:0},enableColumnFreeze:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},enableCellFilter:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},showOverlay:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},enableSelectAll:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},enableCustomFilter:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},enableBusyIndicator:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},rowActionCount:{type:\"int\",group:\"Appearance\",defaultValue:0}},defaultAggregation:\"columns\",aggregations:{title:{type:\"sap.ui.core.Control\",altTypes:[\"string\"],multiple:!1},footer:{type:\"sap.ui.core.Control\",altTypes:[\"string\"],multiple:!1},toolbar:{type:\"sap.ui.core.Toolbar\",multiple:!1,deprecated:!0},extension:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"extension\"},columns:{type:\"sap.ui.table.Column\",multiple:!0,singularName:\"column\",bindable:\"bindable\"},rows:{type:\"sap.ui.table.Row\",multiple:!0,singularName:\"row\",bindable:\"bindable\"},noData:{type:\"sap.ui.core.Control\",altTypes:[\"string\"],multiple:!1},rowActionTemplate:{type:\"sap.ui.table.RowAction\",multiple:!1},rowSettingsTemplate:{type:\"sap.ui.table.RowSettings\",multiple:!1}},associations:{groupBy:{type:\"sap.ui.table.Column\",multiple:!1},ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:\"int\"},rowContext:{type:\"object\"},rowIndices:{type:\"int[]\"},selectAll:{type:\"boolean\"},userInteraction:{type:\"boolean\"}}},columnSelect:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"}}},columnResize:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"},width:{type:\"sap.ui.core.CSSSize\"}}},columnMove:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"},newPos:{type:\"int\"}}},sort:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"},sortOrder:{type:\"sap.ui.table.SortOrder\"},columnAdded:{type:\"boolean\"}}},filter:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"},value:{type:\"string\"}}},group:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"}}},columnVisibility:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"},visible:{type:\"boolean\"}}},cellClick:{allowPreventDefault:!0,parameters:{cellControl:{type:\"sap.ui.core.Control\"},cellDomRef:{type:\"Object\"},rowIndex:{type:\"int\"},columnIndex:{type:\"int\"},columnId:{type:\"string\"},rowBindingContext:{type:\"sap.ui.model.Context\"}}},cellContextmenu:{allowPreventDefault:!0,parameters:{cellControl:{type:\"sap.ui.core.Control\"},cellDomRef:{type:\"Object\"},rowIndex:{type:\"int\"},columnIndex:{type:\"int\"},columnId:{type:\"string\"},rowBindingContext:{type:\"sap.ui.model.Context\"}}},columnFreeze:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"}}},customFilter:{column:{type:\"sap.ui.table.Column\"},value:{type:\"string\"}},firstVisibleRowChanged:{firstVisibleRow:{type:\"int\"}},busyStateChanged:{busy:{type:\"boolean\"}}},designTime:!0}});return n.insertFontFaceStyle(),H.prototype.init=function(){this._iBaseFontSize=parseFloat(t(\"body\").css(\"font-size\"))||16,this._oResBundle=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.table\"),this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL(),this._attachExtensions(),this._bBindingLengthChanged=!1,this._bRowAggregationInvalid=!0,this._mTimeouts={},this._bHideStandardTooltips=!1,this._lastCalledUpdateRows=0,this._iBindingTimerDelay=50,this._iMaxScrollbarHeight=1e6,this._aRowHeights=[],this._iRowHeightsDelta=0,this._iRenderedFirstVisibleRow=0,this._aSortedColumns=[];var e=this;this._performUpdateRows=function(t){if(!e.bIsDestroyed){if(e._lastCalledUpdateRows=Date.now(),e._updateBindingContexts(),!e._bInvalid&&(e._updateTableContent(),e._getAccExtension().updateAccForCurrentCell(!1),e._updateSelection(),e._collectTableSizes(),e._aRowHeights=e._collectRowHeights(!1),e._updateRowHeights(e._collectRowHeights(!0),!0),e._updateRowHeights(e._aRowHeights,!1),R.isVariableRowHeightEnabled(e)&&(e._iRowHeightsDelta=this._getRowHeightsDelta(e._aRowHeights),e._iRenderedFirstVisibleRow=this.getFirstVisibleRow()),e._bBindingLengthChanged&&e._updateVSbScrollTop(),e._toggleVSb(),R.isVariableRowHeightEnabled(e))){var i=0,o=e._getScrollExtension().getVerticalScrollbar();o&&(i=o.scrollTop),e._adjustTablePosition(i,e._aRowHeights)}e._mTimeouts.bindingTimer=void 0,e._fireRowsUpdated(t)}e._bBindingLengthChanged=!1},this._initSelectionModel(g.MULTI_SELECTION),this._aTableHeaders=[],this._aIdxCols2Cells=[],this._bInheritEditableToControls=!1,this._bAllowColumnHeaderTextSelection=!1,this._bPendingRequest=!1,this._iBindingLength=0,this._iTableRowContentHeight=0,this._bFirstRendering=!0,this._bInvalid=!0,this._bIsScrollVertical=null},H.prototype._attachExtensions=function(){this._bExtensionsInitialized||(b.enrich(this,C),b.enrich(this,y),b.enrich(this,_),b.enrich(this,m),this._bExtensionsInitialized=!0)},H.prototype.exit=function(){this._bExitCalled=!0,this.invalidateRowsAggregation(),this._detachExtensions(),null!=this._dataReceivedHandlerId&&(t.sap.clearDelayedCall(this._dataReceivedHandlerId),delete this._dataReceivedHandlerId),this._cleanUpTimers(),this._detachEvents(),this._oSelection&&this._oSelection.destroy(),delete this._aTableHeaders},H.prototype._detachExtensions=function(){b.cleanup(this)},H.prototype.onThemeChanged=function(){this.getDomRef()&&this.invalidate()},H.prototype.onlocalizationChanged=function(t){var e=t.changes||{},i=e.hasOwnProperty(\"rtl\"),o=e.hasOwnProperty(\"language\");(i||o)&&(this._adaptLocalization(i,o),this.invalidate())},H.prototype._adaptLocalization=function(t,e){if(t&&(this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL()),e){var i,o=this.getRows();this._oResBundle=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.table\");var n;for(i=0;i<o.length;i++)(n=o[i].getAggregation(\"_rowAction\"))&&(n._oResBundle=this._oResBundle);var s;for(i=0;i<o.length;i++)(s=o[i].getAggregation(\"_settings\"))&&(s._oResBundle=this._oResBundle);R.Menu.cleanupDataCellContextMenu(this),this._invalidateColumnMenus(!0)}},H.prototype._collectRowHeights=function(t){var i=this.getDomRef();if(!i)return[];if(t&&this.getColumnHeaderHeight())return[];for(var o=this._getDefaultRowHeight(),n=t?\".sapUiTableColHdrTr\":\".sapUiTableTr\",s=i.querySelectorAll(\".sapUiTableCtrlFixed > tbody > tr\"+n),r=i.querySelectorAll(\".sapUiTableCtrlScroll > tbody > tr\"+n),a=this.getRows().length,l=[],h=e.browser.chrome&&1!=window.devicePixelRatio,u=0;u<a;u++){var d=null==s[u]?0:s[u].getBoundingClientRect().height,g=null==r[u]?0:r[u].getBoundingClientRect().height,p=Math.max(d,g);if(h){var c=o-p;if(c>0&&c<1){l.push(Math.max(p,o-1));continue}}l.push(Math.max(p,o))}return l},H.prototype._resetRowHeights=function(){var t=this.getRowHeight(),e=\"\";t&&(e=t+\"px\");var i=this.getDomRef();if(i)for(var o=i.querySelectorAll(\".sapUiTableTr\"),n=0;n<o.length;n++)o[n].style.height=e},H.prototype._resetColumnHeaderHeights=function(){if(!this.getColumnHeaderHeight()){var t=this.getDomRef();if(t)for(var e=t.querySelectorAll(\".sapUiTableColHdrTr\"),i=0;i<e.length;i++)e[i].style.height=null}},H.prototype._determineAvailableSpace=function(){var e=this.getDomRef();if(e&&e.parentNode){var i=e.querySelector(\".sapUiTableCCnt\");if(i){var o=e.scrollHeight-parseFloat(window.getComputedStyle(i).height),n=0;if(e.parentNode.firstChild!==e){var s=parseFloat(window.getComputedStyle(e.parentNode).paddingTop);isNaN(s)&&(s=0),n=e.offsetTop-s}return o+=18,t(e.parentNode).height()-o-n}}return 0},H.prototype._collectTableSizes=function(){var t={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0},e=this.getDomRef();if(!e)return t;var i=e.querySelector(\".sapUiTableCnt\");i&&(t.tableCntHeight=i.clientHeight,t.tableCntWidth=i.clientWidth);var o=e.querySelector(\".sapUiTableCtrlScroll:not(.sapUiTableCHT)\");o&&(t.tableCtrlScrollWidth=o.clientWidth);var n=e.querySelector(\".sapUiTableRowHdrScr\");n&&(t.tableRowHdrScrWidth=n.clientWidth);var s=e.querySelector(\".sapUiTableCtrlScr:not(.sapUiTableCHA)\");s&&(t.tableCtrlScrWidth=s.clientWidth);var r=this._getScrollExtension().getHorizontalScrollbar();r&&(t.tableHSbScrollLeft=r.scrollLeft);var a=e.querySelector(\".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed\");a&&(t.tableCtrlFixedWidth=a.clientWidth);var l=this.getProperty(\"fixedColumnCount\"),h=0;if(l)for(var u=e.querySelectorAll(\".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th\"),d=0;d<u.length;d++){var g=parseInt(u[d].getAttribute(\"data-sap-ui-headcolindex\"),10);!isNaN(g)&&g<l&&(h+=u[d].getBoundingClientRect().width)}if(h>0){var p=t.tableRowHdrScrWidth,c=this.getDomRef(\"vsb\");if(c&&(p+=c.offsetWidth),R.hasRowActions(this)){var w=this.getDomRef(\"sapUiTableRowActionScr\");w&&(p+=w.offsetWidth)}var f=t.tableCtrlScrollWidth===t.tableCtrlScrWidth;f||(p+=R.Column.getMinColumnWidth());var b=t.tableCtrlFixedWidth+p<=t.tableCntWidth,m=!1;f&&b||(m=t.tableCntWidth-p<h),this._bIgnoreFixedColumnCount!==m&&(this._bIgnoreFixedColumnCount=m,this.invalidate())}return t},H.prototype._updateRowHeights=function(t,e){function i(e,i){var o=t[i];o&&(e.style.height=o+\"px\")}var o=this.getDomRef();if(o&&(!e||!this.getColumnHeaderHeight())){var n=e?\".sapUiTableColHdrTr\":\".sapUiTableTr\",s=e?[]:o.querySelectorAll(\".sapUiTableRowHdr\"),r=e?[]:o.querySelectorAll(\".sapUiTableRowAction\"),a=o.querySelectorAll(\".sapUiTableCtrlFixed > tbody > tr\"+n),l=o.querySelectorAll(\".sapUiTableCtrlScroll > tbody > tr\"+n),h=[];h.forEach.call(s,i),h.forEach.call(r,i),h.forEach.call(a,i),h.forEach.call(l,i)}},H.prototype.onBeforeRendering=function(t){if(!t||!t.isMarked(\"renderRows\")){this._mTimeouts.bindingTimer&&this._updateBindingContexts(),this._cleanUpTimers(),this._detachEvents();var e=this.getVisibleRowCountMode(),i=this.getRows();if(e==B.Interactive||e==B.Fixed||e==B.Auto&&this._iTableRowContentHeight&&0==i.length)if(this.getBinding(\"rows\"))this._updateRows(this._calculateRowsToDisplay(),R.RowsUpdateReason.Render);else{var o=this;this._mTimeouts.onBeforeRenderingAdjustRows=this._mTimeouts.onBeforeRenderingAdjustRows||window.setTimeout(function(){o._updateRows(o._calculateRowsToDisplay(),R.RowsUpdateReason.Render),o._mTimeouts.onBeforeRenderingAdjustRows=void 0},0)}else this._bRowAggregationInvalid&&i.length>0&&this._updateRows(i.length,R.RowsUpdateReason.Render);this._aTableHeaders=[]}},H.prototype.onAfterRendering=function(t){var e=t&&t.isMarked(\"renderRows\");e&&(this._getScrollExtension().updateVerticalScrollbarHeight(),this._updateVSbRange()),this._bInvalid=!1,this._bOnAfterRendering=!0;var i=this.$();this._attachEvents(),this._initRowDomRefs();for(var o=this.getColumns(),n=0,s=o.length;n<s;n++)o[n].getVisible()&&o[n]._restoreIcons();this._bAllowColumnHeaderTextSelection||e||this._disableTextSelection(i.find(\".sapUiTableColHdrCnt\")),this._bOnAfterRendering=!1,this._getKeyboardExtension().invalidateItemNavigation(),this._updateTableContent(),this._bFirstRendering&&this.getVisibleRowCountMode()==B.Auto?(this._bFirstRendering=!1,Promise.resolve().then(this._updateTableSizes.bind(this,R.RowsUpdateReason.Render,!0))):this._updateTableSizes(R.RowsUpdateReason.Render),e||(this._aTableHeaders=this.$().find(\".sapUiTableColHdrCnt th\"),this.getBinding(\"rows\")&&this._fireRowsUpdated(R.RowsUpdateReason.Render))},H.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=!0;var t=i.prototype.invalidate.call(this);R.Column.invalidateColumnUtils(this)}return t},H.prototype._initRowDomRefs=function(){for(var t=this.getRows(),e=0;e<t.length;e++)t[e].initDomRefs()},H.prototype._updateTableSizes=function(t,e,i){function o(){R.registerResizeHandler(s,\"\",s._onTableResize.bind(s),!0)}var n=this.getDomRef(),s=this;if(!this._bInvalid&&n){if(!n.offsetWidth)return R.deregisterResizeHandler(this,\"\"),void o();this._resetRowHeights(),this._resetColumnHeaderHeights(),this._aRowHeights=this._collectRowHeights(!1);var r=this._collectRowHeights(!0);R.isVariableRowHeightEnabled(this)&&(this._iRowHeightsDelta=this._getRowHeightsDelta(this._aRowHeights));var a=0;if(i||this.getVisibleRowCountMode()!=B.Auto||(a=this._determineAvailableSpace(),!this._handleRowCountModeAuto(a,t)||e)){R.deregisterResizeHandler(this,\"\"),function(t){function e(t,e){return t<=e?Math.max(t,e-5,s)+\"px\":-1}function i(i){var o,l,h,u=Math.max(i._minWidth||0,s,i.getMinWidth()),d=i.getWidth();if(R.isVariableWidth(d)&&!R.isFixedColumn(t,i.getIndex())&&(o=n.querySelectorAll('th[data-sap-ui-colid=\"'+i.getId()+'\"]'),l=o[a?0:1],null!==(h=l?l.offsetWidth:null))){if(h<=u)return{headers:o,newWidth:e(h,u)};if(l&&l.style.width!=d)return r.push({col:i,header:l,minWidth:u,headers:o}),{headers:o,newWidth:d};r.push({col:i,header:l,minWidth:u,headers:o})}return null}function o(t){t&&Array.prototype.forEach.call(t.headers,function(e){e.style.width=t.newWidth})}var n=t.getDomRef(),s=R.Column.getMinColumnWidth(),r=[],a=t.getColumnHeaderVisible();if(t._getVisibleColumns().map(i).forEach(o),r.length)for(var l,h=0;h<r.length;h++)l=r[h].header&&r[h].header.offsetWidth,r[h].newWidth=e(l,r[h].minWidth),parseInt(r[h].newWidth,10)>=0&&o(r[h])}(this);var l=this._collectTableSizes();if(0==l.tableCntHeight&&0==l.tableCntWidth)return void R.registerResizeHandler(this,\"\",this._onTableResize.bind(this),!0);this._updateRowHeights(this._aRowHeights,!1),this._updateRowHeights(r,!0),this._determineVisibleCols(l),i||this._setRowContentHeight(a),this._updateHSb(l),this._updateVSbTop();var h=this.$();if(R.hasRowActions(this)){var u=h.hasClass(\"sapUiTableRActFlexible\"),d=this.getDomRef(\"dummycolhdr\"),g=d?d.clientWidth:0;if(!u&&g>0){var p=l.tableCtrlScrWidth+l.tableRowHdrScrWidth+l.tableCtrlFixedWidth-g,c={width:\"auto\"};c[this._bRtlMode?\"right\":\"left\"]=p,this.$(\"sapUiTableRowActionScr\").css(c),this.$(\"rowacthdr\").css(c),h.toggleClass(\"sapUiTableRActFlexible\",!0)}else u&&g<=0&&(this.$(\"sapUiTableRowActionScr\").removeAttr(\"style\"),this.$(\"rowacthdr\").removeAttr(\"style\"),h.toggleClass(\"sapUiTableRActFlexible\",!1))}h.find(\".sapUiTableNoOpacity\").addBack().removeClass(\"sapUiTableNoOpacity\"),h.closest(\".sapUiLoSplitter\").length?o():Promise.resolve().then(o)}}},H.prototype.setShowOverlay=function(t){if(t=!!t,this.setProperty(\"showOverlay\",t,!0),this.getDomRef()){var e=document.activeElement;this.$().toggleClass(\"sapUiTableOverlay\",t),this._getAccExtension().updateAriaStateForOverlayAndNoData(),this._getKeyboardExtension().updateNoDataAndOverlayFocus(e)}return this},H.prototype._updateFixedBottomRows=function(){var e=this.getFixedBottomRowCount(),i=this.getDomRef();if(i&&e>0){t(i).find(\".sapUiTableFixedPreBottomRow\").removeClass(\"sapUiTableFixedPreBottomRow\");t(i).find(\".sapUiTableFixedFirstBottomRow\").removeClass(\"sapUiTableFixedFirstBottomRow\");var o,n=R.getFirstFixedButtomRowIndex(this),s=this.getRows();n>=0&&n<s.length&&(o=s[n].getDomRefs(!0),o.row.addClass(\"sapUiTableFixedFirstBottomRow\",!0)),n>=1&&n<s.length&&(o=s[n-1].getDomRefs(!0),o.row.addClass(\"sapUiTableFixedPreBottomRow\",!0))}},H.prototype.getFocusInfo=function(){var t=this.$().find(\":focus\").attr(\"id\");return t?{customId:t}:o.prototype.getFocusInfo.apply(this,arguments)},H.prototype.applyFocusInfo=function(t){return t&&t.customId?this.$().find(\"#\"+t.customId).focus():o.prototype.getFocusInfo.apply(this,arguments),this},H.prototype.setTitle=function(t){var e=t;return(\"string\"==typeof t||t instanceof String)&&(e=f.TableHelper.createTextView({text:t,width:\"100%\"}),e.addStyleClass(\"sapUiTableHdrTitle\")),this.setAggregation(\"title\",e),this},H.prototype.setFooter=function(t){var e=t;return(\"string\"==typeof t||t instanceof String)&&(e=f.TableHelper.createTextView({text:t,width:\"100%\"})),this.setAggregation(\"footer\",e),this},H.prototype.setSelectionMode=function(t){return this.clearSelection(),t===T.Single?this._oSelection.setSelectionMode(g.SINGLE_SELECTION):this._oSelection.setSelectionMode(g.MULTI_SELECTION),t=R.sanitizeSelectionMode(this,t),this.setProperty(\"selectionMode\",t),this},H.prototype._adjustTablePosition=function(t,e){var i=t<this._getVirtualScrollRange(),o=this._getRowCount()>this.getVisibleRowCount();if(!i||this.getFirstVisibleRow()==this._iRenderedFirstVisibleRow){var n=null;if(i&&o){var s=e[0],r=this._getScrollingPixelsForRow(),a=t-this.getFirstVisibleRow()*r,l=a/r;n=Math.ceil(l*s),n>s&&(n=null)}else if(this._iRowHeightsDelta>=0){var h=o?t-this._getVirtualScrollRange():t;n=this._iRowHeightsDelta/this._getRowCorrectionScrollRange()*h}null!=n&&n>-1&&this.$().find(\".sapUiTableCCnt\").scrollTop(n)}},H.prototype.setFirstVisibleRow=function(e,i,o){if(parseInt(e,10)<0&&(t.sap.log.error(\"The index of the first visible row must be greater than or equal to 0. The value has been set to 0.\",this),e=0),this._getRowCount()>0){var n=this._getMaxRowIndex();n<e&&(t.sap.log.warning(\"The index of the first visible row must be lesser or equal than the scrollable row count minus the visible row count. The value has been set to \"+n+\".\",this),e=n)}if(this.getFirstVisibleRow()!=e){if(this.setProperty(\"firstVisibleRow\",e,!0),this.getBinding(\"rows\")){var s=!0===i?R.RowsUpdateReason.VerticalScroll:R.RowsUpdateReason.FirstVisibleRowChange;this.updateRows(s),i||this._updateVSbScrollTop()}o||this.fireFirstVisibleRowChanged({firstVisibleRow:e})}return this},H.getMetadata().getAggregation(\"rows\")._doesNotRequireFactory=!0,H.prototype.bindAggregation=function(t){return\"rows\"==t?this.bindRows.apply(this,[].slice.call(arguments,1)):i.prototype.bindAggregation.apply(this,arguments)},H.prototype.bindRows=function(e,o,n,s){return\"string\"==typeof e&&(o instanceof p||t.isArray(n)&&n[0]instanceof d)&&(s=n,n=o,o=void 0),i.prototype.bindAggregation.call(this,\"rows\",e,o,n,s)},H.prototype._bindAggregation=function(t,e,i,n,s){o.prototype._bindAggregation.apply(this,arguments);var r=this.getBinding(\"rows\");return\"rows\"===t&&r&&r.attachChange(this._onBindingChange,this),this._initSelectionModel(g.MULTI_SELECTION),r&&this.isTreeBinding(\"rows\")&&!r.hasListeners(\"selectionChanged\")&&r.attachSelectionChanged(this._onSelectionChanged,this),this},H.prototype._initSelectionModel=function(t){return this._oSelection&&this._oSelection.detachSelectionChanged(this._onSelectionChanged,this),this._oSelection=new g(t),this._oSelection.attachSelectionChanged(this._onSelectionChanged,this),this},H.prototype._onBindingChange=function(t){var e=\"object\"==typeof t?t.getParameter(\"reason\"):t;\"sort\"!==e&&\"filter\"!==e||(this.clearSelection(),this.setFirstVisibleRow(0))},H.prototype.unbindAggregation=function(t,e){var i=this.getBinding(\"rows\");\"rows\"===t&&this.isBound(\"rows\")&&(e=!0);var n=o.prototype.unbindAggregation.apply(this,[t,e]);return\"rows\"===t&&i&&(this._restoreAppDefaultsColumnHeaderSortFilter(),this._invalidateColumnMenus(),this._updateBindingLength(),this.updateRows(R.RowsUpdateReason.Unbind)),n},H.prototype.setVisibleRowCount=function(e){if(null!=e&&!isFinite(e))return this;if(this.getVisibleRowCountMode()==B.Auto)return t.sap.log.error(\"VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto\",this),this;var i=this.getFixedRowCount()+this.getFixedBottomRowCount();return e<=i&&i>0?(t.sap.log.error(\"Table: \"+this.getId()+\" visibleRowCount('\"+e+\"') must be bigger than number of fixed rows('\"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+\"')\",this),this):(e=this.validateProperty(\"visibleRowCount\",e),this.getBinding(\"rows\")&&this.getBinding(\"rows\").getLength()<=e&&this.setProperty(\"firstVisibleRow\",0),this.setProperty(\"visibleRowCount\",e),this._setRowContentHeight(e*this._getDefaultRowHeight()),this)},H.prototype.setRowHeight=function(t){return this.setProperty(\"rowHeight\",t),this._iTableRowContentHeight=void 0,this},H.prototype.setTooltip=function(e){return t.sap.log.warning(\"The aggregation tooltip is not supported for sap.ui.table.Table\"),this.setAggregation(\"tooltip\",e,!0)},H.prototype.setNavigationMode=function(){this.setProperty(\"navigationMode\",S.Scrollbar,!0),t.sap.log.error(\"The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'\",this)},H.prototype._getFixedBottomRowContexts=function(t,e){var i=this.getBinding(\"rows\"),o=[];if(!i)return o;t=t||this.getFixedBottomRowCount(),e=e||i.getLength();var n=this.getVisibleRowCount();return t>0&&n-t<e&&(o=this._getContexts(e-t,t,1)),o},H.prototype._getFixedRowContexts=function(t){return t=t||this.getFixedRowCount(),t>0?this._getContexts(0,t):[]},H.prototype._getContexts=function(t,e,i){var o=this.getBinding(\"rows\");return o?o.getContexts(t,e,i):[]},H.prototype._getRowContexts=function(t,e,i){var o=this.getBinding(\"rows\"),n=null==t?this.getRows().length:t;if(!o||n<=0)return[];e=!0===e,i=!0===i;var s,r,a=this.getFirstVisibleRow(),l=this.getFixedRowCount(),h=this.getFixedBottomRowCount(),u=0,d=[],g=n-h,p=0,c=g,w=this.getThreshold();w=w?Math.max(n,w):0;var f=a,R=function(t,e,i){for(var o=0;o<e.length;o++)t[i+o]=e[o]};l>0&&a>0&&(f=a+l,g-=l,p=l,r=this._getFixedRowContexts(l),u+=r.length,d=d.concat(r)),r=this._getContexts(f,g,w);var b=this._updateBindingLength(e);if(s=r.length<Math.min(g,b-h),u+=r.length,R(d,r,p),c=Math.min(c,Math.max(b-h,0)),h>0&&(r=this._getFixedBottomRowContexts(h,b),u+=r.length,R(d,r,c)),s&&!i&&b>0){var m=this._getMaxRowIndex();m<a&&(a=m,this.setProperty(\"firstVisibleRow\",a,!0),d=this._getRowContexts(n,e,!0),u=d.length)}return d},H.prototype._updateBindingLength=function(t){var e=this.getBinding(\"rows\"),i=0;if(t=!0===t,e&&(i=e.getLength()),i!=this._iBindingLength&&(this._iBindingLength=i,this._bBindingLengthChanged=!0,!t)){this._updateFixedBottomRows(),this._toggleVSb(),this._updateVSbRange();var o=R.isInstanceOf(e,\"sap/ui/model/ClientListBinding\")||R.isInstanceOf(e,\"sap/ui/model/ClientTreeBinding\");(null==e||o)&&this._updateNoData()}return i},H.prototype.refreshRows=function(e){var i=this.getBinding(\"rows\");if(!i)return void t.sap.log.error(\"RefreshRows must not be called without a binding\",this);var o=this,n=\"object\"==typeof e?e.getParameter(\"reason\"):e;n===h.Refresh&&this._attachBindingListener();var s=this.getVisibleRowCountMode();if(this.bOutput&&s===B.Auto||s!==B.Auto){var r=this._calculateRowsToDisplay();this.bOutput&&i.attachEventOnce(\"dataRequested\",function(){o._mTimeouts.refreshRowsAdjustRows&&window.clearTimeout(o._mTimeouts.refreshRowsAdjustRows),o._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){o._updateRows(r,n,!1)},0)}),n!==h.Filter&&n!==h.Sort||this.setFirstVisibleRow(0),this._updateBindingContexts(r,!0)}},H.prototype.updateRows=function(t){if(!this._bExitCalled){var e=this.getVisibleRowCountMode();if((this.getRows().length<=0||this._bRowAggregationInvalid)&&(e==B.Auto&&this.bOutput||e!=B.Auto)&&this._iTableRowContentHeight&&this._updateRows(this._calculateRowsToDisplay(),t),!this.bIsDestroyed){var i=t===h.Change||!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay||t===R.RowsUpdateReason.Unbind?0:this._iBindingTimerDelay,o=this;0===i&&t?Promise.resolve().then(function(){o._performUpdateRows(t)}):this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){o._performUpdateRows(t)},i)}}},H.prototype.insertRow=function(){t.sap.log.error('The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!',this)},H.prototype.addRow=function(){t.sap.log.error('The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!',this)},H.prototype.removeRow=function(){t.sap.log.error('The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!',this)},H.prototype.removeAllRows=function(){t.sap.log.error('The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!',this)},H.prototype.destroyRows=function(){t.sap.log.error('The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!',this)},H.prototype.autoResizeColumn=function(t){this._getPointerExtension().doAutoResizeColumn(t)},H.prototype._attachEvents=function(){var e=this.$();if(e.find(\".sapUiTableColHdrScr\").scroll(t.proxy(this._oncolscroll,this)),e.find(\".sapUiTableCtrlScr\").scroll(t.proxy(this._oncntscroll,this)),e.find(\".sapUiTableCtrlScrFixed\").scroll(t.proxy(this._oncntscroll,this)),e.find(\".sapUiTableCtrlScrFixed\").on(\"scroll.sapUiTablePreventFixedAreaScroll\",function(t){t.target.scrollLeft=0}),R.isVariableRowHeightEnabled(this)){var i=e.find(\".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableRowHdrScr\");i.on(\"scroll.sapUiTableSyncScrollPosition\",function(t){i.scrollTop(t.target.scrollTop)})}sap.ui.getCore().getConfiguration().getAnimation()&&t(document.body).on(\"webkitTransitionEnd transitionend\",function(i){t(i.target).has(e).length>0&&(this._iDefaultRowHeight=void 0,this._updateTableSizes(R.RowsUpdateReason.Animation))}.bind(this)),b.attachEvents(this)},H.prototype._detachEvents=function(){t(document.body).off(\"webkitTransitionEnd transitionend\"),R.deregisterResizeHandler(this),b.detachEvents(this)},H.prototype._getScrollTargets=function(){var e=t(this.getDomRef(\"sapUiTableCtrlScr\")),i=t(this.getDomRef(\"rsz\")),o=t(this.getDomRef(\"sapUiTableCtrlScrFixed\")),n=t(this.getDomRef(\"sapUiTableRowHdrScr\"));return e.add(o).add(n).add(i)},H.prototype._cleanUpTimers=function(){for(var t in this._mTimeouts)this._mTimeouts[t]&&(window.clearTimeout(this._mTimeouts[t]),delete this._mTimeouts[t])},H.prototype._updateHSb=function(t){var i=this.$(),o=t.tableCtrlScrollWidth;if(e.browser.safari&&(o=Math.max(o,this._getColumnsWidth(this.getFixedColumnCount()))),o>t.tableCtrlScrWidth){if(!this._getScrollExtension().isHorizontalScrollbarVisible()&&(i.addClass(\"sapUiTableHScr\"),e.browser.safari)){i.find(\".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr\").outerWidth(o)}var n=t.tableCtrlFixedWidth;if(i.find(\".sapUiTableRowHdrScr\").length>0&&(n+=t.tableRowHdrScrWidth),this.getRows().length>0){var s=i.find(\".sapUiTableHSb\");this._bRtlMode?s.css(\"margin-right\",n+\"px\"):s.css(\"margin-left\",n+\"px\")}var r=this.getDomRef(\"hsb-content\");r&&(r.style.width=o+\"px\")}else this._getScrollExtension().isHorizontalScrollbarVisible()&&(i.removeClass(\"sapUiTableHScr\"),e.browser.safari&&i.find(\".sapUiTableCtrlScroll, .sapUiTableColHdr\").css(\"width\",\"\"))},H.prototype._updateVSbTop=function(){var t=this._getScrollExtension().getVerticalScrollbar();if(t){var e=this.getDomRef(\"tableCCnt\");if(e){var i=e.offsetTop;this.getDomRef(\"vsb-bg\").style.top=i+\"px\";this.getFixedRowCount()>0&&(i+=this._iVsbTop),t.style.top=i+\"px\"}}},H.prototype._updateVSbScrollTop=function(t){var e=this._getScrollExtension(),i=e.getVerticalScrollbar();i&&this._isVSbRequired()&&(void 0===t&&(t=Math.ceil(this.getFirstVisibleRow()*this._getScrollingPixelsForRow())),e._iVerticalScrollPosition=null,window.requestAnimationFrame(function(){i.scrollTop=t}))},H.prototype._updateVSbRange=function(){this._getScrollExtension().getVerticalScrollbar()&&t(this.getDomRef(\"vsb-content\")).height(this._getTotalScrollRange())},H.prototype._toggleVSb=function(){var t=this.getDomRef();t&&(this._isVSbRequired()?t.classList.contains(\"sapUiTableVScr\")||(t.classList.add(\"sapUiTableVScr\"),this._updateVSbScrollTop(0)):t.classList.remove(\"sapUiTableVScr\"))},H.prototype._isVSbRequired=function(){return!!(this._iRowHeightsDelta>0||this.getBinding(\"rows\")&&this._iBindingLength>this.getVisibleRowCount())},H.prototype._updateBindingContexts=function(t,e){var i,o=this.getBinding(\"rows\");if(e=!0===e,null!=o&&(i=this._getRowContexts(t,e)),!e){this._resetRowHeights();for(var n=this.getRows(),s=this.mBindingInfos.rows,r=s&&s.model,a=n.length-1;a>=0;a--){var l=i?i[a]:void 0,h=n[a];h&&h.setRowBindingContext(l,r,o)}}},H.prototype._updateNoData=function(){if(this.getDomRef()){var t=document.activeElement;this.$().toggleClass(\"sapUiTableEmpty\",R.isNoDataVisible(this)),this._getAccExtension().updateAriaStateForOverlayAndNoData(),this._getKeyboardExtension().updateNoDataAndOverlayFocus(t)}},H.prototype._determineVisibleCols=function(t){var e=[];this.getColumns().forEach(function(t,i){t.shouldRender()&&e.push(i)})},H.prototype.removeColumn=function(e,i){var o=this.removeAggregation(\"columns\",e,i);\"number\"==typeof e&&e>-1&&(e=this.getColumns()[e]);var n=t.inArray(e,this._aSortedColumns);return!this._bReorderInProcess&&n>=0&&this._aSortedColumns.splice(n,1),this.invalidateRowsAggregation(),o},H.prototype.removeAllColumns=function(){var t=this.removeAllAggregation(\"columns\");return this._aSortedColumns=[],this.invalidateRowsAggregation(),t},H.prototype.destroyColumns=function(){var t=this.destroyAggregation(\"columns\");return this._aSortedColumns=[],this.invalidateRowsAggregation(),t},H.prototype.addColumn=function(t,e){return this.addAggregation(\"columns\",t,e),this.invalidateRowsAggregation(),this},H.prototype.insertColumn=function(t,e,i){return this.insertAggregation(\"columns\",t,e,i),this.invalidateRowsAggregation(),this},H.prototype._getRowCount=function(){return this._iBindingLength},H.prototype._getSelectableRowCount=function(){var t=this.getBinding(\"rows\");return this._iBindingLength||(t?t.getLength():0)},H.prototype._getFirstVisibleRowByScrollTop=function(t){if(R.isVariableRowHeightEnabled(this)&&this._getRowCount()<this.getVisibleRowCount())return 0;if(e.browser.chrome&&1!=window.devicePixelRatio){var i=this._getScrollExtension().getVerticalScrollbar();if(null!=i){if(this._getVirtualScrollRange()-i.scrollTop<1)return this._getMaxRowIndex()}}var o=Math.floor(t/this._getScrollingPixelsForRow());return Math.min(this._getMaxRowIndex(),o)},H.prototype._getScrollingPixelsForRow=function(){return this._getVirtualScrollRange()/Math.max(1,this._getMaxRowIndex())},\nH.prototype._getVSbHeight=function(){return this._getScrollableRowCount()*this._getDefaultRowHeight()},H.prototype._getScrollableRowCount=function(){return Math.max(1,this.getVisibleRowCount()-this.getFixedRowCount()-this.getFixedBottomRowCount())},H.prototype._getRowHeightsDelta=function(t){var e=this._getDefaultRowHeight()*this.getVisibleRowCount();this.getVisibleRowCount()>=this._getRowCount()&&(t=t.slice(0,this._getRowCount()));var i=t.reduce(function(t,e){return t+e},0)-e;return i>0&&(i=Math.ceil(i)),Math.max(0,i)},H.prototype._getTotalScrollRange=function(){var t=Math.max(this._getRowCount(),this.getVisibleRowCount()+1),e=this._getDefaultRowHeight()*t;return Math.min(this._iMaxScrollbarHeight,e)},H.prototype._getVirtualScrollRange=function(){var t=this._getTotalScrollRange()-this._getVSbHeight();return R.isVariableRowHeightEnabled(this)&&(t-=this._iRowHeightsDelta),Math.max(1,t)},H.prototype._getRowCorrectionScrollRange=function(){var t=this._getTotalScrollRange()-this._getVSbHeight();return this._getRowCount()>this.getVisibleRowCount()&&(t-=this._getVirtualScrollRange()),Math.max(1,t)},H.prototype._getMaxRowIndex=function(){var t=this._getRowCount()-this.getVisibleRowCount();return R.isVariableRowHeightEnabled(this)&&(t-=1),Math.max(0,t)},H.prototype._getVisibleColumns=function(){for(var t=[],e=this.getColumns(),i=0,o=e.length;i<o;i++)e[i].shouldRender()&&t.push(e[i]);return t},H.prototype._getColumnsWidth=function(t,e){var i=this.getColumns(),o=0;0===t||t||(t=0),0===e||e||(e=i.length);for(var n=t,s=e;n<s;n++)i[n]&&i[n].shouldRender()&&(o+=this._CSSSizeToPixel(i[n].getWidth()));return o},H.prototype._CSSSizeToPixel=function(e,i){var o=R.Column.getMinColumnWidth();return e&&(t.sap.endsWith(e,\"px\")?o=parseInt(e,10):(t.sap.endsWith(e,\"em\")||t.sap.endsWith(e,\"rem\"))&&(o=Math.ceil(parseFloat(e)*this._getBaseFontSize()))),i?o+\"px\":parseInt(o,10)},H.prototype._getBaseFontSize=function(){return this._iBaseFontSize},H.prototype._onTableResize=function(){!this._bInvalid&&this.getDomRef()&&this._updateTableSizes(R.RowsUpdateReason.Resize)},H.prototype._handleRowCountModeAuto=function(t,e){var i=this.getBinding(\"rows\");if(i&&this.getRows().length>0)return this._executeAdjustRows(e,t);var o=!this._mTimeouts.handleRowCountModeAutoAdjustRows,n=this.getBusyIndicatorDelay(),s=this.getEnableBusyIndicator(),r=this;return i&&s&&(this.setBusyIndicatorDelay(0),this.setBusy(!0)),t&&this._setRowContentHeight(t),this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){r._executeAdjustRows(e)||r._updateTableSizes(e,!1,!0),delete r._mTimeouts.handleRowCountModeAutoAdjustRows,i&&s&&(r.setBusyIndicatorDelay(n),r.setBusy(!1))},0),o},H.prototype._executeAdjustRows=function(t,e){e=e||this._determineAvailableSpace();var i=this._calculateRowsToDisplay(e);return i==this._determineMinAutoRowCount()?this.$().height(\"auto\"):this.$().height(\"0px\"),this._updateRows(i,t)},H.prototype._disableTextSelection=function(e){t(e||document.body).attr(\"unselectable\",\"on\").css({\"-moz-user-select\":\"none\",\"-webkit-user-select\":\"none\",\"user-select\":\"none\"}).bind(\"selectstart\",function(t){return t.preventDefault(),!1})},H.prototype._enableTextSelection=function(e){t(e||document.body).attr(\"unselectable\",\"off\").css({\"-moz-user-select\":\"\",\"-webkit-user-select\":\"\",\"user-select\":\"\"}).unbind(\"selectstart\")},H.prototype._clearTextSelection=function(){if(window.getSelection)window.getSelection().empty?window.getSelection().empty():window.getSelection().removeAllRanges&&window.getSelection().removeAllRanges();else if(document.selection&&document.selection.empty)try{document.selection.empty()}catch(t){}},H.prototype._findAndfireCellEvent=function(e,i,o){var n=t(i.target),s=n.closest(\"td.sapUiTableTd\"),r=s.attr(\"id\"),a=/.*-row(\\d*)-col(\\d*)/i.exec(r),l=!1;if(a){var h,u=a[1],d=a[2],g=this.getRows()[u],p=g&&g.getCells()[d],c=g&&g.getIndex(),w=p.data(\"sap-ui-colid\");this.getBindingInfo(\"rows\")&&(h=g.getBindingContext(this.getBindingInfo(\"rows\").model));var f={rowIndex:c,columnIndex:d,columnId:w,cellControl:p,rowBindingContext:h,cellDomRef:s.get(0)};l=!e.call(this,f),l||\"function\"!=typeof o||(f.cellDomRef=s[0],l=o.call(this,f))}return l},H.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();var t=R.getFocusedItemInfo(this);return null!==t?t.domRef||i.prototype.getFocusDomRef.apply(this,arguments):null},H.prototype._isRowSelectable=function(t){return t>=0&&t<this._getRowCount()},H.prototype.pushSortedColumn=function(t,e){e||(this._aSortedColumns=[]),this._aSortedColumns.push(t)},H.prototype.getSortedColumns=function(){return this._aSortedColumns.slice()},H.prototype.sort=function(e,i,o){if(!e){for(var n=0;n<this._aSortedColumns.length;n++)this._aSortedColumns[n].setSorted(!1);var s=this.getBinding(\"rows\");s&&s.sort(),this._aSortedColumns=[]}t.inArray(e,this.getColumns())>=0&&e.sort(i===A.Descending,o)},H.prototype.filter=function(e,i){t.inArray(e,this.getColumns())>=0&&e.filter(i)},H.prototype._updateSelection=function(){if(this.getSelectionMode()!==T.None){for(var t=this._getAccExtension().getAriaTextsForSelectionMode(!0),e=R.isRowSelectionAllowed(this),i=this.getRows(),o=0;o<i.length;o++)i[o]._updateSelection(this,t,e);if(this.setProperty(\"selectedIndex\",this.getSelectedIndex(),!0),R.hasSelectAll(this)){var n=this.$(\"selall\"),s=R.areAllRowsSelected(this);if(n.toggleClass(\"sapUiTableSelAll\",!s),this._getAccExtension().setSelectAllState(s),this._getShowStandardTooltips()){var r=s?\"TBL_DESELECT_ALL\":\"TBL_SELECT_ALL\";n.attr(\"title\",this._oResBundle.getText(r))}}}},H.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips},H.prototype._onSelectionChanged=function(t){var e=t.getParameter(\"rowIndices\"),i=t.getParameter(\"selectAll\"),o=void 0!==this._iSourceRowIndex?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection(),this.fireRowSelectionChange({rowIndex:o,rowContext:this.getContextByIndex(o),rowIndices:e,selectAll:i,userInteraction:void 0!==this._iSourceRowIndex})},H.prototype.getContextByIndex=function(t){var e=this.getBinding(\"rows\");return t>=0&&e?e.getContexts(t,1)[0]:null},H.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex()},H.prototype.setSelectedIndex=function(t){return-1===t?this.clearSelection():this._oSelection.setSelectionInterval(t,t),this},H.prototype.clearSelection=function(){return this._oSelection.clearSelection(),this},H.prototype.selectAll=function(){if(!R.hasSelectAll(this))return this;var t=this.getBinding(\"rows\");return t&&this._oSelection.selectAll((t.getLength()||0)-1),this},H.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices()},H.prototype.addSelectionInterval=function(t,e){return this.getSelectionMode()===f.SelectionMode.None?this:(this._oSelection.addSelectionInterval(t,e),this)},H.prototype.setSelectionInterval=function(t,e){return this.getSelectionMode()===f.SelectionMode.None?this:(this._oSelection.setSelectionInterval(t,e),this)},H.prototype.removeSelectionInterval=function(t,e){return this._oSelection.removeSelectionInterval(t,e),this},H.prototype.isIndexSelected=function(t){return this._oSelection.isSelectedIndex(t)},H.prototype.setGroupBy=function(e){var i=e;\"string\"==typeof i&&(i=sap.ui.getCore().byId(i));var o=!1;if(i&&i instanceof c){if(-1===t.inArray(i,this.getColumns()))throw new Error(\"Column has to be part of the columns aggregation!\");var n=this.fireGroup({column:i,groupedColumns:[i.getId()],type:v.group}),s=sap.ui.getCore().byId(this.getGroupBy());s&&(s.setGrouped(!1),o=!0),n&&i instanceof c&&i.setGrouped(!0)}if(!i||o){var r=this.getBindingInfo(\"rows\");delete r.binding,this._bindAggregation(\"rows\",r)}return this.setAssociation(\"groupBy\",i)},H.prototype.getBinding=function(t){return R.Grouping.setupExperimentalGrouping(this),o.prototype.getBinding.call(this,[t||\"rows\"])},H.prototype.setEnableGrouping=function(t){return this.setProperty(\"enableGrouping\",t),t||R.Grouping.resetExperimentalGrouping(this),this._invalidateColumnMenus(),this},H.prototype.setEnableCustomFilter=function(t){return this.setProperty(\"enableCustomFilter\",t),this._invalidateColumnMenus(),this},H.prototype.setEnableColumnFreeze=function(t){return this.setProperty(\"enableColumnFreeze\",t),this._invalidateColumnMenus(),this},H.prototype.setShowColumnVisibilityMenu=function(t){return this.setProperty(\"showColumnVisibilityMenu\",t),this._invalidateColumnMenus(),this},H.prototype.getFixedColumnCount=function(){return this._bIgnoreFixedColumnCount?0:this.getProperty(\"fixedColumnCount\")},H.prototype.setFixedColumnCount=function(t,e){var i,o,n=this.getColumns();for(o=t-1;o>=0;o--)if((i=n[o])&&i.getVisible()){t=Math.max(t,i.getIndex()+R.Column.getHeaderSpan(i));break}var s=this.$().find(\".sapUiTableCtrlFirstCol > th\");for(o=t-1;o>=0;o--)(i=n[o])&&R.isVariableWidth(i.getWidth())&&(i._iFixWidth=s.filter(\"[data-sap-ui-headcolindex='\"+i.getIndex()+\"']\").width());return this.setProperty(\"fixedColumnCount\",t,e),this._collectTableSizes(),this._invalidateColumnMenus(),this},H.prototype.setFixedRowCount=function(e){return parseInt(e,10)>=0?(e+this.getFixedBottomRowCount()<this.getVisibleRowCount()?(this.setProperty(\"fixedRowCount\",e),this._updateBindingContexts()):t.sap.log.error(\"Table '\"+this.getId()+\"' fixed rows('\"+(e+this.getFixedBottomRowCount())+\"') must be smaller than numberOfVisibleRows('\"+this.getVisibleRowCount()+\"')\",this),this):(t.sap.log.error(\"Number of fixed rows must be greater or equal 0\",this),this)},H.prototype.setFixedBottomRowCount=function(e){return parseInt(e,10)>=0?(e+this.getFixedRowCount()<this.getVisibleRowCount()?(this.setProperty(\"fixedBottomRowCount\",e),this._updateBindingContexts()):t.sap.log.error(\"Table '\"+this.getId()+\"' fixed rows('\"+(e+this.getFixedRowCount())+\"') must be smaller than numberOfVisibleRows('\"+this.getVisibleRowCount()+\"')\",this),this):(t.sap.log.error(\"Number of fixed bottom rows must be greater or equal 0\",this),this)},H.prototype.setThreshold=function(t){this.setProperty(\"threshold\",t,!0)},H.prototype._invalidateColumnMenus=function(t){for(var e=this.getColumns(),i=0,o=e.length;i<o;i++)e[i].invalidateMenu(t)},H.prototype._isTouchEvent=function(t){return null!=t&&null!=t.originalEvent&&null!=t.originalEvent.touches},H.prototype._getRowClone=function(t){for(var e=new w(this.getId()+\"-rows-row\"+t),i=this.getColumns(),o=0,n=i.length;o<n;o++)if(i[o].getVisible()){var s=i[o].getTemplateClone(o);s&&e.addCell(s)}if(R.hasRowActions(this)){var r=this.getRowActionTemplate().clone();r._setFixedLayout(!0),r._setCount(this.getRowActionCount()),r._setIconLabel(this.getId()+\"-rowacthdr\"),e.setAggregation(\"_rowAction\",r,!0)}var a=this.getRowSettingsTemplate();if(a){var l=a.clone();e.setAggregation(\"_settings\",l,!0)}return e},H.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=!0},H.prototype._updateRows=function(t,e,i){if(isNaN(t))return!1;null==i&&(i=!0),R.isVariableRowHeightEnabled(this)&&(t+=1);var o,n=this.getRows();if(this._bRowAggregationInvalid&&n.length>0&&(this.destroyAggregation(\"rows\",!0),n=[]),t==n.length)return!1;for(o=n.length-1;o>=t;o--)this.removeAggregation(\"rows\",o,!0).destroy();R.isVariableRowHeightEnabled(this)?this.setProperty(\"visibleRowCount\",t-1,!0):this.setProperty(\"visibleRowCount\",t,!0),this._ignoreInvalidateOfChildControls=!0;var s,r,a,l=this.getBinding(\"rows\");if(i)for(r=this.getBindingInfo(\"rows\"),a=r&&r.model,s=this._getRowContexts(t),o=0;o<n.length;o++)n[o].setRowBindingContext(s[o],a,l);if(n.length<t)for(o=n.length;o<t;o++){var h=this._getRowClone(o);i&&h.setRowBindingContext(s[o],a,l),this.addAggregation(\"rows\",h,!0),this._bRowAggregationInvalid=!1,i&&h._updateTableCells(s[o])}this._ignoreInvalidateOfChildControls=!1;var u=i&&s.length>0;return this._renderRows(e,u)},H.prototype._renderRows=function(e,i){var o=!1;if(i=!0===i,!this._bInvalid){var n=this.getDomRef(\"tableCCnt\");if(0===this.getRows().length||!n)return!1;if(this._detachEvents(),this.getVisibleRowCountMode()===B.Auto){var s=this.getDomRef();s&&(s.style.height=\"0px\")}var r=t.Event(\"BeforeRendering\");r.setMarked(\"renderRows\"),r.srcControl=this,this._handleEvent(r);var a=(new sap.ui.getCore).createRenderManager();this.getRenderer().renderTableCCnt(a,this),a.flush(n,!1,!1),a.destroy(),r=t.Event(\"AfterRendering\"),r.setMarked(\"renderRows\"),r.srcControl=this,this._handleEvent(r),o=!0}if(i&&!this._bInvalid&&this.getBinding(\"rows\")){var l=this;this._mTimeouts._rowsUpdated&&window.clearTimeout(this._mTimeouts._rowsUpdated),this._mTimeouts._rowsUpdated=window.setTimeout(function(){l._fireRowsUpdated(e)},0)}return o},H.prototype._getDefaultRowHeight=function(){var t=this.getRowHeight();if(t>0)return t;var e=R.getContentDensity(this);return R.DEFAULT_ROW_HEIGHT[e]},H.prototype._setRowContentHeight=function(e){e=e||0;var i,o=this.getVisibleRowCountMode(),n=this.getVisibleRowCount(),s=this._getDefaultRowHeight(),r=this.getMinAutoRowCount();o==B.Interactive||o==B.Fixed?this._iTableRowContentHeight&&o==B.Interactive?(i=r*s,e||(e=this._iTableRowContentHeight)):(i=n*s,e=i):o==B.Auto&&(i=r*s);var a=Math.max(e,i);o==B.Fixed&&0==this.getRows().length||o!=B.Fixed?this._iTableRowContentHeight=Math.floor(a/s)*s:this._iTableRowContentHeight=void 0,R.isVariableRowHeightEnabled(this)?t(this.getDomRef(\"tableCCnt\")).css(\"height\",s*this.getVisibleRowCount()+\"px\"):(o==B.Fixed||o==B.Interactive)&&this.getRows().length>0?t(this.getDomRef(\"tableCtrlCnt\")).css(\"height\",\"auto\"):t(this.getDomRef(\"tableCtrlCnt\")).css(\"height\",this._iTableRowContentHeight+\"px\"),this._toggleVSb()},H.prototype._determineMinAutoRowCount=function(){var t=this.getVisibleRowCount(),e=this.getMinAutoRowCount(),i=e||t||5;return this.getVisibleRowCountMode()!=B.Interactive||this.bOutput||(i=t||e||5),i},H.prototype._calculateRowsToDisplay=function(t){t=t||this._iTableRowContentHeight;var e=this.getVisibleRowCountMode(),i=0;if(e==B.Fixed)i=this.getVisibleRowCount()||0;else if(e==B.Interactive||e==B.Auto){var o=this._determineMinAutoRowCount(),n=this._getDefaultRowHeight();if(n&&t){var s=Math.min(t,5e4),r=Math.floor(s/n);i=Math.max(this.getFixedRowCount()+this.getFixedBottomRowCount()+1,Math.max(o,r))}else i=o}return Math.max(i,0)},H.prototype.setShowNoData=function(t){return this.setProperty(\"showNoData\",t,!0),this._updateNoData(),this},H.prototype.exportData=function(t){var e=sap.ui.requireSync(\"sap/ui/core/util/Export\");if(t=t||{},!t.rows){var i=this.getBinding(\"rows\"),o=this.getBindingInfo(\"rows\"),n=i.aFilters.concat(i.aApplicationFilters);t.rows={path:o.path,model:o.model,sorter:i.aSorters,filters:n,parameters:o.parameters}}if(!t.exportType){var s=sap.ui.requireSync(\"sap/ui/core/util/ExportTypeCSV\");t.exportType=new s}var r=t.rows.model;if(!r){var a=t.rows.path,l=a.indexOf(\">\");l>0&&(r=a.substr(0,l))}if(!t.columns){t.columns=[];for(var h=this.getColumns(),u=0,d=h.length;u<d;u++){var g=h[u];g.getSortProperty()&&t.columns.push({name:g.getLabel().getText(),template:{content:{path:g.getSortProperty(),model:r}}})}}var p=new e(t);return this.addDependent(p),p},H.prototype._onPersoApplied=function(){for(var t=this.getColumns(),e=[],i=0,o=t.length;i<o;i++){var n=t[i];n.getSorted()&&e.push(new p(n.getSortProperty(),n.getSortOrder()===A.Descending))}var s=this.getBinding(\"rows\");s&&(e.length>0&&s.sort(e),this.refreshRows())},H.prototype._toggleSelectAll=function(){R.hasData(this)&&(R.areAllRowsSelected(this)?(this._iSourceRowIndex=-1,this.clearSelection()):(this._iSourceRowIndex=0,this.selectAll()),this._iSourceRowIndex=void 0)},H.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var e=this.getColumns();t.each(e,function(t,e){e._restoreAppDefaults()})},H.prototype.setBusy=function(t,e){var o=this.getBusy()!=t;e=\"sapUiTableCnt\";var n=i.prototype.setBusy.call(this,t,e);return o&&this.fireBusyStateChanged({busy:t}),n},H.prototype.setEnableBusyIndicator=function(t){this.setProperty(\"enableBusyIndicator\",t,!0)},H.prototype._attachBindingListener=function(){this._attachDataRequestedListeners()},H.prototype._attachDataRequestedListeners=function(){var t=this.getBinding(\"rows\");t&&(t.detachDataRequested(this._onBindingDataRequestedListener),t.attachDataRequested(this._onBindingDataRequestedListener,this),t.detachDataReceived(this._onBindingDataReceivedListener),t.attachDataReceived(this._onBindingDataReceivedListener,this))},H.prototype._onBindingDataRequestedListener=function(e){e.getSource()!=this.getBinding(\"rows\")||e.getParameter(\"__simulateAsyncAnalyticalBinding\")||(this._bPendingRequest=!0,this.getEnableBusyIndicator()&&this.setBusy(!0),null!=this._dataReceivedHandlerId&&(t.sap.clearDelayedCall(this._dataReceivedHandlerId),delete this._dataReceivedHandlerId))},H.prototype._onBindingDataReceivedListener=function(e){e.getSource()!=this.getBinding(\"rows\")||e.getParameter(\"__simulateAsyncAnalyticalBinding\")||(this._bPendingRequest=!1,null!=this._dataReceivedHandlerId&&(t.sap.clearDelayedCall(this._dataReceivedHandlerId),delete this._dataReceivedHandlerId),this._dataReceivedHandlerId=t.sap.delayedCall(0,this,function(){this.getEnableBusyIndicator()&&this.setBusy(!1),this._updateBindingLength(!0),this._updateNoData(),delete this._dataReceivedHandlerId}))},H.prototype._setLargeDataScrolling=function(t){this._bLargeDataScrolling=!!t},H.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length},H.prototype._updateTableContent=function(){R.Grouping.updateGroups(this)},H.prototype.setRowActionTemplate=function(t){return this.setAggregation(\"rowActionTemplate\",t),t=this.getRowActionTemplate(),t&&t._setCount(this.getRowActionCount()),this.invalidateRowsAggregation(),this},H.prototype.setRowActionCount=function(t){this.setProperty(\"rowActionCount\",t),t=this.getRowActionCount();var e=this.getRowActionTemplate();e&&e._setCount(t);for(var i=this.getRows(),o=0;o<i.length;o++)(e=i[o].getAggregation(\"_rowAction\"))&&e._setCount(t);return this},H.prototype.setRowSettingsTemplate=function(t){return this.setAggregation(\"rowSettingsTemplate\",t),this.invalidateRowsAggregation(),this},H.prototype._validateRow=function(t){return t&&t instanceof w&&t.getParent()===this},H.prototype.getRowForCell=function(t){if(t){var e=t.getParent();if(this._validateRow(e))return e}return null},H.prototype.getColumnForCell=function(t){if(this.getRowForCell(t)){var e=t.data(\"sap-ui-colindex\"),i=this.getColumns();if(e>=0&&e<i.length)return i[e]}return null},H.prototype.getCellControl=function(t,e,i){return R.getRowColCell(this,t,e,!i).cell},H.prototype._fireRowsUpdated=function(t){null==t&&(t=R.RowsUpdateReason.Unknown),this.fireEvent(\"_rowsUpdated\",{reason:t})},H});",
		"sap/ui/table/TableAccExtension.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"./library\",\"./TableExtension\",\"./TableAccRenderExtension\",\"./TableUtils\"],function(e,t,a,l,i,r){\"use strict\";var o=a.SelectionMode,n={getAccInfoOfControl:function(e,t){if(e&&\"function\"==typeof e.getAccessibilityInfo){if(\"function\"==typeof e.getVisible&&!e.getVisible())return n._normalize({});var a=e.getAccessibilityInfo();if(a){var l={};return n._flatten(a,l,t),l}}return null},_normalize:function(e){return e?e._normalized?e:(e.role=e.role||\"\",e.type=e.type||\"\",e.description=e.description||\"\",e.focusable=!!e.focusable,e.enabled=!0===e.enabled||!1===e.enabled?e.enabled:null,e.editable=!0===e.editable||!1===e.editable?e.editable:null,e.children=e.children||[],e._normalized=!0,e):null},_flatten:function(e,t,a,l){l=l||0,n._normalize(e),0==l&&(n._normalize(t),t._descriptions=[]),t.focusable=t.focusable||e.focusable,t._descriptions.push(n._getFullDescription(e,a)),e.children.forEach(function(e){if(e.getAccessibilityInfo&&(!e.getVisible||e.getVisible())){var i=e.getAccessibilityInfo();i&&n._flatten(i,t,a,l+1)}}),0==l&&(t.description=t._descriptions.join(\" \").trim(),t._descriptions=void 0)},_getFullDescription:function(e,t){var a=e.type+\" \"+e.description;return null==e.enabled||e.enabled?null==e.editable||e.editable||(a=a+\" \"+t.getText(\"TBL_CTRL_STATE_READONLY\")):a=a+\" \"+t.getText(\"TBL_CTRL_STATE_DISABLED\"),a.trim()}},s={getColumnIndexOfFocusedCell:function(e){var t=e.getTable();return r.getFocusedItemInfo(t).cellInRow-(r.hasRowHeader(t)?1:0)},getInfoOfFocusedCell:function(e){var t=e.getTable(),a=t._getItemNavigation(),l=t.getDomRef();if(!e.getAccMode()||!l||!a)return null;var i=a.getFocusedDomRef();return i&&i===document.activeElement?r.getCellInfo(i):null},getRelevantColumnHeaders:function(e,t){if(!e||!t)return[];var a=r.getHeaderRowCount(e),l=t.getId(),i=[l];if(a>1){for(var o=1;o<a;o++)i.push(l+\"_\"+o);var n=r.Column.getParentSpannedColumns(e,l);if(n&&n.length)for(var o=0;o<n.length;o++){var s=n[o].level,d=n[o].column.getId();i[s]=0===s?d:d+\"_\"+s}}return i},isHiddenCell:function(e,t){var a=r.Grouping.isInGroupingRow(e),l=r.Grouping.isInSumRow(e),i=!!t&&!!t.hasStyleClass,o=e.parent().hasClass(\"sapUiTableRowHidden\"),n=e.hasClass(\"sapUiTableCellHidden\"),s=a&&e.hasClass(\"sapUiTableTdFirst\")&&!e.hasClass(\"sapUiTableMeasureCell\"),d=a&&i&&t.hasStyleClass(\"sapUiAnalyticalTableGroupCellHidden\"),u=l&&i&&t.hasStyleClass(\"sapUiAnalyticalTableSumCellHidden\");return o||n||s||d||u},isTreeColumnCell:function(e,t){return r.Grouping.isTreeMode(e.getTable())&&t.hasClass(\"sapUiTableTdFirst\")},getColumnTooltip:function(e){if(!e)return null;var a=e.getTooltip_AsString();if(a)return a;var l=e.getLabel();return l instanceof t&&(a=l.getTooltip_AsString()),a||null},updateRowColCount:function(e){var t=e.getTable(),a=t._getItemNavigation(),l=!1,i=!1,o=!1;if(a){var n=s.getColumnIndexOfFocusedCell(e)+1,d=r.getRowIndexOfFocusedCell(t)+t.getFirstVisibleRow()+1,u=r.getVisibleColumnCount(t)+(r.hasRowActions(t)?1:0),c=r.isNoDataVisible(t)?0:r.getTotalRowCount(t,!0);l=e._iLastRowNumber!=d||e._iLastRowNumber==d&&e._iLastColumnNumber==n,i=e._iLastColumnNumber!=n,o=!e._iLastRowNumber&&!e._iLastColumnNumber,t.$(\"rownumberofrows\").text(l?t._oResBundle.getText(\"TBL_ROW_ROWCOUNT\",[d,c]):\" \"),t.$(\"colnumberofcols\").text(i?t._oResBundle.getText(\"TBL_COL_COLCOUNT\",[n,u]):\" \"),t.$(\"ariacount\").text(o?t._oResBundle.getText(\"TBL_DATA_ROWS_COLS\",[c,u]):\" \"),e._iLastRowNumber=d,e._iLastColumnNumber=n}return{rowChange:l,colChange:i,initial:o}},cleanupCellModifications:function(e){e._cleanupInfo&&(e._cleanupInfo.cell.attr(e._cleanupInfo.attr),e._cleanupInfo=null)},storeDefaultsBeforeCellModifications:function(e,t,a,l){e._cleanupInfo={cell:t,attr:{\"aria-labelledby\":a&&a.length?a.join(\" \"):null,\"aria-describedby\":l&&l.length?l.join(\" \"):null}}},performCellModifications:function(e,t,a,l,i,r,n,d){s.storeDefaultsBeforeCellModifications(e,t,a,l);var u=s.updateRowColCount(e);e.getTable().$(\"cellacc\").text(n||\" \"),d&&d(i,r,u.rowChange,u.colChange,u.initial);var c=\"\";if(u.initial){var E=e.getTable();c=E.getAriaLabelledBy().join(\" \")+\" \"+E.getId()+\"-ariadesc \"+E.getId()+\"-ariacount\",E.getSelectionMode()!==o.None&&(c=c+\" \"+E.getId()+\"-ariaselection\")}i&&i.length&&(c=c+\" \"+i.join(\" \")),t.attr({\"aria-labelledby\":c||null,\"aria-describedby\":r&&r.length?r.join(\" \"):null})},modifyAccOfDATACELL:function(e,t){var a=this.getTable(),l=a.getId();if(a._getItemNavigation()){var i=r.getRowIndexOfFocusedCell(a),o=s.getColumnIndexOfFocusedCell(this),u=r.getRowColCell(a,i,o,!1),c=null,E=s.isHiddenCell(e,u.cell),g=s.isTreeColumnCell(this,e),T=r.Grouping.isInGroupingRow(e),b=r.Grouping.isInSumRow(e),p=s.getAriaAttributesFor(this,d.ELEMENTTYPES.DATACELL,{index:o,column:u.column,fixed:r.isFixedColumn(a,o)})[\"aria-labelledby\"]||[],f=[],h=[l+\"-rownumberofrows\",l+\"-colnumberofcols\"];if(T&&(h.push(l+\"-ariarowgrouplabel\"),h.push(l+\"-rows-row\"+i+\"-groupHeader\")),b){var C=e.parent().data(\"sap-ui-level\");0==C?h.push(l+\"-ariagrandtotallabel\"):C>0&&(h.push(l+\"-ariagrouptotallabel\"),h.push(l+\"-rows-row\"+i+\"-groupHeader\"))}!r.hasRowHighlights(a)||T||b||h.push(u.row.getId()+\"-highlighttext\"),h=h.concat(p),E||(c=n.getAccInfoOfControl(u.cell,a._oResBundle),h.push(c?l+\"-cellacc\":u.cell.getId()),((!c||c.focusable)&&!this._readonly||g&&u.row&&u.row._bHasChildren)&&f.push(l+\"-toggleedit\"));var A=c?c.description:\" \";if(g&&!E){var L=s.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:u.row});L&&L[\"aria-label\"]&&(A=L[\"aria-label\"]+\" \"+A)}s.performCellModifications(this,e,p,null,h,f,A,function(e,t,l,i,o){!E&&r.isRowSelectionAllowed(a)&&l&&t.push(u.row.getId()+\"-rowselecttext\")})}},modifyAccOfROWHEADER:function(e,t){var a=this.getTable(),l=a.getId(),i=r.Grouping.isInGroupingRow(e),o=r.Grouping.isInSumRow(e),n=a.getRows()[e.attr(\"data-sap-ui-rowindex\")],u=s.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWHEADER)[\"aria-labelledby\"]||[],c=u.concat([l+\"-rownumberofrows\"]);if(o||i||e.hasClass(\"sapUiTableRowHidden\")||(c.push(n.getId()+\"-rowselecttext\"),r.hasRowHighlights(a)&&c.push(n.getId()+\"-highlighttext\")),i&&c.push(l+\"-ariarowgrouplabel\"),o){var E=e.data(\"sap-ui-level\");0==E?c.push(l+\"-ariagrandtotallabel\"):E>0&&c.push(l+\"-ariagrouptotallabel\")}s.performCellModifications(this,e,u,null,c,null,null)},modifyAccOfCOLUMNHEADER:function(e,t){var a=this.getTable(),l=sap.ui.getCore().byId(e.attr(\"data-sap-ui-colid\")),i=s.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:e.attr(\"id\"),column:l,index:e.attr(\"data-sap-ui-colindex\")}),o=s.getColumnTooltip(l),n=[a.getId()+\"-colnumberofcols\"].concat(i[\"aria-labelledby\"]),u=r.getColumnHeaderCellInfo(e),c=u?u.span:1,E=l&&l.getId()===e.attr(\"id\");c>1&&(n.push(a.getId()+\"-ariacolspan\"),a.$(\"ariacolspan\").text(a._oResBundle.getText(\"TBL_COL_DESC_SPAN\",[\"\"+c]))),o&&n.push(a.getId()+\"-cellacc\"),E&&l&&l.getSorted()&&n.push(a.getId()+(\"Ascending\"===l.getSortOrder()?\"-ariacolsortedasc\":\"-ariacolsorteddes\")),E&&l&&l.getFiltered()&&n.push(a.getId()+\"-ariacolfiltered\"),\"true\"===e.attr(\"aria-haspopup\")&&n.push(a.getId()+\"-ariacolmenu\"),s.performCellModifications(this,e,i[\"aria-labelledby\"],i[\"aria-describedby\"],n,i[\"aria-describedby\"],o)},modifyAccOfCOLUMNROWHEADER:function(e,t){var a=this.getTable(),l=e.hasClass(\"sapUiTableSelAllEnabled\"),i=s.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNROWHEADER,{enabled:l,checked:l&&!a.$().hasClass(\"sapUiTableSelAll\")});s.performCellModifications(this,e,i[\"aria-labelledby\"],i[\"aria-describedby\"],i[\"aria-labelledby\"],i[\"aria-describedby\"],null)},modifyAccOfROWACTION:function(e,t){var a=this.getTable(),l=a.getId(),i=r.Grouping.isInGroupingRow(e),o=r.Grouping.isInSumRow(e),n=e.attr(\"data-sap-ui-rowindex\"),u=a.getRows()[n],c=s.isHiddenCell(e),E=s.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWACTION)[\"aria-labelledby\"]||[],g=[l+\"-rownumberofrows\",l+\"-colnumberofcols\"].concat(E),T=[];if(i&&(g.push(l+\"-ariarowgrouplabel\"),g.push(l+\"-rows-row\"+n+\"-groupHeader\")),o){var b=e.data(\"sap-ui-level\");0==b?g.push(l+\"-ariagrandtotallabel\"):b>0&&(g.push(l+\"-ariagrouptotallabel\"),g.push(l+\"-rows-row\"+n+\"-groupHeader\"))}o||i||\"true\"!=e.attr(\"aria-selected\")||g.push(l+\"-ariarowselected\"),!r.hasRowHighlights(a)||i||o||g.push(u.getId()+\"-highlighttext\");var p=\"\";if(!c){var f=u.getAggregation(\"_rowAction\");if(f){var h=f.getAccessibilityInfo();h&&(g.push(l+\"-cellacc\"),p=h.description,h.focusable&&T.push(l+\"-toggleedit\"))}}s.performCellModifications(this,e,E,[],g,T,p)},getAriaAttributesFor:function(a,l,i){function n(e,t,a,l){var i=\"\";a&&l?i=\"overlay,nodata\":a&&!l?i=\"overlay\":!a&&l&&(i=\"nodata\");var o=!1;(a&&e.getShowOverlay()||l&&r.isNoDataVisible(e))&&(o=!0),o&&(u[\"aria-hidden\"]=\"true\"),i&&(u[\"data-sap-ui-table-acc-covered\"]=i)}var u={},c=a.getTable(),E=c.getId();switch(l){case d.ELEMENTTYPES.COLUMNROWHEADER:u[\"aria-labelledby\"]=[E+\"-ariacolrowheaderlabel\"];var g=!1;u.role=[\"button\"],i&&i.enabled?u[\"aria-pressed\"]=i.checked?\"true\":\"false\":(g=!0,u[\"aria-disabled\"]=\"true\",u[\"aria-pressed\"]=\"false\"),!g&&c._getShowStandardTooltips()||u[\"aria-labelledby\"].push(E+\"-ariaselectall\");break;case d.ELEMENTTYPES.ROWHEADER:if(u[\"aria-labelledby\"]=[E+\"-ariarowheaderlabel\"],r.Grouping.isTreeMode(c)||(u.role=[\"rowheader\"]),!(c.getSelectionMode()===o.None||i&&i.rowHidden)){var T=i&&i.rowSelected;u[\"aria-selected\"]=\"\"+T;var b=a.getAriaTextsForSelectionMode(!0);u.title=b.mouse[T?\"rowDeselect\":\"rowSelect\"]}break;case d.ELEMENTTYPES.ROWACTION:if(u.role=[\"gridcell\"],u[\"aria-labelledby\"]=[E+\"-rowacthdr\"],!(c.getSelectionMode()===o.None||i&&i.rowHidden)){var T=i&&i.rowSelected;u[\"aria-selected\"]=\"\"+T}break;case d.ELEMENTTYPES.COLUMNHEADER:var p=i&&i.column,f=p&&p.getId()===i.headerId;u.role=\"columnheader\";var h=[];if(i&&i.headerId){var C=s.getRelevantColumnHeaders(c,p),A=e.inArray(i.headerId,C);h=A>0?C.slice(0,A+1):[i.headerId]}for(var L=0;L<h.length;L++)h[L]=h[L]+\"-inner\";u[\"aria-labelledby\"]=h,i&&i.index<c.getFixedColumnCount()&&u[\"aria-labelledby\"].push(E+\"-ariafixedcolumn\"),f&&p&&p.getSorted()&&(u[\"aria-sort\"]=\"Ascending\"===p.getSortOrder()?\"ascending\":\"descending\"),p&&p._menuHasItems()&&(u[\"aria-haspopup\"]=\"true\");break;case d.ELEMENTTYPES.DATACELL:u.role=\"gridcell\",i&&\"number\"==typeof i.index&&(u.headers=E+\"_col\"+i.index);var h=[],p=i&&i.column?i.column:null;if(p){h=s.getRelevantColumnHeaders(c,p);for(var L=0;L<h.length;L++)h[L]=h[L]+\"-inner\";i&&i.fixed&&h.push(E+\"-ariafixedcolumn\")}if(u[\"aria-labelledby\"]=h,r.Grouping.isTreeMode(c)&&i&&i.firstCol&&i.row){var R=c.mBindingInfos.rows;i.row.getBindingContext(R&&R.model)&&(u[\"aria-level\"]=i.row._iLevel+1,u[\"aria-expanded\"]=\"\"+i.row._bIsExpanded)}break;case d.ELEMENTTYPES.ROOT:break;case d.ELEMENTTYPES.TABLE:u.role=\"presentation\",n(c,u,!0,!0);break;case d.ELEMENTTYPES.CONTENT:u.role=r.Grouping.isGroupMode(c)||r.Grouping.isTreeMode(c)?\"treegrid\":\"grid\",u[\"aria-labelledby\"]=[].concat(c.getAriaLabelledBy()),c.getTitle()&&u[\"aria-labelledby\"].push(c.getTitle().getId()),c.getSelectionMode()!==o.Multi&&c.getSelectionMode()!==o.MultiToggle||(u[\"aria-multiselectable\"]=\"true\");break;case d.ELEMENTTYPES.TABLEHEADER:u.role=\"heading\",n(c,u,!0,!1);break;case d.ELEMENTTYPES.COLUMNHEADER_TBL:u.role=\"presentation\";break;case d.ELEMENTTYPES.COLUMNHEADER_ROW:r.hasRowHeader(c)||(u.role=\"row\"),n(c,u,!0,!1);break;case d.ELEMENTTYPES.ROWHEADER_COL:n(c,u,!0,!0);break;case d.ELEMENTTYPES.TH:var _=c.getFixedColumnCount()>0;u.role=_?\"columnheader\":\"presentation\",u.scope=\"col\",_?i&&i.column&&(u[\"aria-owns\"]=i.column.getId(),u[\"aria-labelledby\"]=[i.column.getId()]):u[\"aria-hidden\"]=\"true\";break;case d.ELEMENTTYPES.ROWHEADER_TD:if(u.role=\"rowheader\",u[\"aria-labelledby\"]=[E+\"-ariarowheaderlabel\"],u.headers=E+\"-colsel\",i&&\"number\"==typeof i.index&&(u[\"aria-owns\"]=E+\"-rowsel\"+i.index),c.getSelectionMode()!==o.None){var T=i&&i.rowSelected;u[\"aria-selected\"]=\"\"+T}break;case d.ELEMENTTYPES.TR:u.role=\"row\";var T=!1;if(i&&\"number\"==typeof i.index&&c.getSelectionMode()!==o.None&&c.isIndexSelected(i.index)&&(u[\"aria-selected\"]=\"true\",T=!0),r.isRowSelectionAllowed(c)){var b=a.getAriaTextsForSelectionMode(!0);u.title=b.mouse[T?\"rowDeselect\":\"rowSelect\"]}break;case d.ELEMENTTYPES.TREEICON:if(r.Grouping.isTreeMode(c)&&(u={\"aria-label\":\"\",title:\"\",role:\"\"},c.getBinding(\"rows\")&&(u.role=\"button\",i&&i.row)))if(i.row._bHasChildren){var m=c._oResBundle.getText(i.row._bIsExpanded?\"TBL_COLLAPSE\":\"TBL_EXPAND\");c._getShowStandardTooltips()?u.title=m:u[\"aria-label\"]=m,u[\"aria-expanded\"]=\"\"+!!i.row._bIsExpanded}else u[\"aria-label\"]=c._oResBundle.getText(\"TBL_LEAF\");break;case d.ELEMENTTYPES.NODATA:u.role=\"gridcell\";var O=c.getNoData();u[\"aria-labelledby\"]=[O instanceof t?O.getId():E+\"-noDataMsg\"],n(c,u,!0,!1);break;case d.ELEMENTTYPES.OVERLAY:u.role=\"region\",u[\"aria-labelledby\"]=[].concat(c.getAriaLabelledBy()),c.getTitle()&&u[\"aria-labelledby\"].push(c.getTitle().getId()),u[\"aria-labelledby\"].push(E+\"-ariainvalid\");break;case d.ELEMENTTYPES.TABLEFOOTER:case d.ELEMENTTYPES.TABLESUBHEADER:n(c,u,!0,!1);break;case d.ELEMENTTYPES.ROWACTIONHEADER:u[\"aria-hidden\"]=\"true\";break;case\"PRESENTATION\":u.role=\"presentation\"}return u}},d=l.extend(\"sap.ui.table.TableAccExtension\",{_init:function(e,t,a){return this._accMode=sap.ui.getCore().getConfiguration().getAccessibility(),this._readonly=t==l.TABLETYPES.ANALYTICAL,e.addEventDelegate(this),l.enrich(e,i),\"AccExtension\"},destroy:function(){this.getTable().removeEventDelegate(this),this._readonly=!1,l.prototype.destroy.apply(this,arguments)},_debug:function(){this._ExtensionHelper=s,this._ACCInfoHelper=n},_getAriaAttributesFor:function(e,t){return s.getAriaAttributesFor(this,e,t)},onfocusin:function(t){var a=this.getTable();a&&r.getCellInfo(t.target)&&(a._mTimeouts._cleanupACCExtension&&(e.sap.clearDelayedCall(a._mTimeouts._cleanupACCExtension),a._mTimeouts._cleanupACCExtension=null),this.updateAccForCurrentCell(!0))},onfocusout:function(t){var a=this.getTable();a&&(a._mTimeouts._cleanupACCExtension=e.sap.delayedCall(100,this,function(){var e=this.getTable();e&&(this._iLastRowNumber=null,this._iLastColumnNumber=null,s.cleanupCellModifications(this),e._mTimeouts._cleanupACCExtension=null)}))}});return d.ELEMENTTYPES={DATACELL:r.CELLTYPES.DATACELL,COLUMNHEADER:r.CELLTYPES.COLUMNHEADER,ROWHEADER:r.CELLTYPES.ROWHEADER,ROWACTION:r.CELLTYPES.ROWACTION,COLUMNROWHEADER:r.CELLTYPES.COLUMNROWHEADER,ROOT:\"ROOT\",CONTENT:\"CONTENT\",TABLE:\"TABLE\",TABLEHEADER:\"TABLEHEADER\",TABLEFOOTER:\"TABLEFOOTER\",TABLESUBHEADER:\"TABLESUBHEADER\",COLUMNHEADER_TBL:\"COLUMNHEADER_TABLE\",COLUMNHEADER_ROW:\"COLUMNHEADER_ROW\",ROWHEADER_COL:\"ROWHEADER_COL\",TH:\"TH\",ROWHEADER_TD:\"ROWHEADER_TD\",TR:\"TR\",TREEICON:\"TREEICON\",ROWACTIONHEADER:\"ROWACTIONHEADER\",NODATA:\"NODATA\",OVERLAY:\"OVERLAY\"},d.prototype.getAccMode=function(){return this._accMode},d.prototype.updateAccForCurrentCell=function(t){if(this._accMode&&this.getTable()._getItemNavigation()){var a=this.getTable();a._mTimeouts._cleanupACCFocusRefresh&&(e.sap.clearDelayedCall(a._mTimeouts._cleanupACCFocusRefresh),a._mTimeouts._cleanupACCFocusRefresh=null),t&&s.cleanupCellModifications(this);var l=s.getInfoOfFocusedCell(this);if(l&&l.cell&&l.type&&s[\"modifyAccOf\"+l.type])return t?void s[\"modifyAccOf\"+l.type].apply(this,[l.cell,t]):void((l.type===r.CELLTYPES.DATACELL||r.CELLTYPES.ROWHEADER)&&(a._mTimeouts._cleanupACCFocusRefresh=e.sap.delayedCall(100,this,function(e){var t=this.getTable();if(t){var a=s.getInfoOfFocusedCell(this);a&&a.cell&&a.type&&a.cell.get(0)&&e.get(0)===a.cell.get(0)&&a.cell.blur().focus(),t._mTimeouts._cleanupACCFocusRefresh=null}},[l.cell])))}},d.prototype.updateAriaStateOfColumn=function(e,t){if(this._accMode){var a=s.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:e.getId(),column:e,index:this.getTable().indexOfColumn(e)});t=t||e.$(),t.attr({\"aria-sort\":a[\"aria-sort\"]||null,\"aria-labelledby\":a[\"aria-labelledby\"]?a[\"aria-labelledby\"].join(\" \"):null})}},d.prototype.updateAriaStateOfRow=function(e,t,a){if(this._accMode&&(t||(t=e.getDomRefs(!0)),t.row&&(t.row.children(\"td\").add(t.row).attr(\"aria-selected\",a?\"true\":null),a&&t.rowSelectorText))){var l=t.rowSelectorText.text();l&&(l=this.getTable()._oResBundle.getText(\"TBL_ROW_DESC_SELECTED\")+\" \"+l),t.rowSelectorText.text(l)}},d.prototype.updateAriaExpandAndLevelState=function(e,t,a,l,i,r,o,n,u){if(this._accMode){var c=null,E=this.getTable(),g=[t,t.children(),a,l,l?l.children():null,i],T=!!u,b=E.getBinding(\"rows\");if(!r&&a&&!T){var p=a.attr(\"data-sap-ui-rowindex\");c=s.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWHEADER,{rowSelected:!e._bHidden&&E.isIndexSelected(p)}).title||null}a&&!T&&a.attr({\"aria-haspopup\":r?\"true\":null,title:c}),!(b&&b.hasTotaledMeasures&&n>0)||b.bProvideGrandTotals&&b.hasTotaledMeasures()||(n-=1);for(var f=0;f<g.length;f++)g[f]&&g[f].attr({\"aria-expanded\":r?o+\"\":null,\"aria-level\":n<0?null:n+1});T&&u.attr(s.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:e}))}},d.prototype.updateAriaStateOfRowHighlight=function(e){if(this._accMode&&null!=e){var t=e._getRow();if(null!=t){t.getDomRef(\"highlighttext\").innerText=e._getHighlightText()}}},d.prototype.updateAriaStateForOverlayAndNoData=function(){var e=this.getTable();e&&e.getDomRef()&&this._accMode&&(e.getShowOverlay()?e.$().find(\"[data-sap-ui-table-acc-covered*='overlay']\").attr(\"aria-hidden\",\"true\"):(e.$().find(\"[data-sap-ui-table-acc-covered*='overlay']\").removeAttr(\"aria-hidden\"),r.isNoDataVisible(e)?e.$().find(\"[data-sap-ui-table-acc-covered*='nodata']\").attr(\"aria-hidden\",\"true\"):e.$().find(\"[data-sap-ui-table-acc-covered*='nodata']\").removeAttr(\"aria-hidden\")))},d.prototype.getAriaTextsForSelectionMode=function(e,t){var a=this.getTable();t||(t=a.getSelectionMode());var l=a._oResBundle,i=a._getShowStandardTooltips(),r={mouse:{rowSelect:\"\",rowDeselect:\"\"},keyboard:{rowSelect:\"\",rowDeselect:\"\"}},n=a._getSelectedIndicesCount();return t===o.Single?(r.mouse.rowSelect=i?l.getText(\"TBL_ROW_SELECT\"):\"\",r.mouse.rowDeselect=i?l.getText(\"TBL_ROW_DESELECT\"):\"\",r.keyboard.rowSelect=l.getText(\"TBL_ROW_SELECT_KEY\"),r.keyboard.rowDeselect=l.getText(\"TBL_ROW_DESELECT_KEY\")):t===o.MultiToggle&&(r.mouse.rowSelect=i?l.getText(\"TBL_ROW_SELECT_MULTI_TOGGLE\"):\"\",r.mouse.rowDeselect=i?l.getText(\"TBL_ROW_DESELECT\"):\"\",r.keyboard.rowSelect=l.getText(\"TBL_ROW_SELECT_MULTI_TOGGLE_KEY\"),r.keyboard.rowDeselect=l.getText(\"TBL_ROW_DESELECT_KEY\"),!0===e&&0===n&&(r.mouse.rowSelect=i?l.getText(\"TBL_ROW_SELECT\"):\"\",r.keyboard.rowSelect=l.getText(\"TBL_ROW_SELECT_KEY\"))),r},d.prototype.setSelectAllState=function(e){var t=this.getTable();t&&t.$(\"selall\").attr(\"aria-pressed\",e?\"true\":\"false\")},d.prototype.addColumnHeaderLabel=function(t,a){var l=this.getTable();if(this._accMode&&a.getAriaLabelledBy&&l){var i=l.getColumnHeaderVisible()?t.getId():null;if(!i){var r=t.getAggregation(\"label\");r&&(i=r.getId())}var o=a.getAriaLabelledBy();i&&e.inArray(i,o)<0&&a.addAriaLabelledBy(i)}},d});",
		"sap/ui/table/TableAccRenderExtension.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./TableExtension\",\"./library\"],function(e,t,i){\"use strict\";var r=i.SelectionMode,a=function(e,t,i,r,a){a=a||[],a.push(\"sapUiInvisibleText\"),e.write(\"<span\"),e.writeAttribute(\"id\",t+\"-\"+i),e.writeAttribute(\"class\",a.join(\" \")),e.writeAttribute(\"aria-hidden\",\"true\"),e.write(\">\"),r&&e.writeEscaped(r),e.write(\"</span>\")};return t.extend(\"sap.ui.table.TableAccRenderExtension\",{_init:function(e,t,i){return\"AccRenderExtension\"},writeHiddenAccTexts:function(e,t){if(t._getAccExtension().getAccMode()){var i=t._oResBundle,o=t.getId();e.write(\"<div class='sapUiTableHiddenTexts' style='display:none;' aria-hidden='true'>\");var n=t.getTitle()&&t.getTitle().getText&&\"\"!=t.getTitle().getText()?t.getTitle().getText():\"\";a(e,o,\"ariadesc\",n),a(e,o,\"ariacount\"),a(e,o,\"toggleedit\",i.getText(\"TBL_TOGGLE_EDIT_KEY\")),a(e,o,\"ariaselectall\",i.getText(\"TBL_SELECT_ALL\")),a(e,o,\"ariarowheaderlabel\",i.getText(\"TBL_ROW_HEADER_LABEL\")),a(e,o,\"ariarowgrouplabel\",i.getText(\"TBL_ROW_GROUP_LABEL\")),a(e,o,\"ariagrandtotallabel\",i.getText(\"TBL_GRAND_TOTAL_ROW\")),a(e,o,\"ariagrouptotallabel\",i.getText(\"TBL_GROUP_TOTAL_ROW\")),a(e,o,\"ariacolrowheaderlabel\",i.getText(\"TBL_ROW_COL_HEADER_LABEL\")),a(e,o,\"rownumberofrows\"),a(e,o,\"colnumberofcols\"),a(e,o,\"cellacc\"),a(e,o,\"ariarowselected\",i.getText(\"TBL_ROW_DESC_SELECTED\")),a(e,o,\"ariacolmenu\",i.getText(\"TBL_COL_DESC_MENU\")),a(e,o,\"ariacolspan\"),a(e,o,\"ariacolfiltered\",i.getText(\"TBL_COL_DESC_FILTERED\")),a(e,o,\"ariacolsortedasc\",i.getText(\"TBL_COL_DESC_SORTED_ASC\")),a(e,o,\"ariacolsorteddes\",i.getText(\"TBL_COL_DESC_SORTED_DES\")),a(e,o,\"ariainvalid\",i.getText(\"TBL_TABLE_INVALID\"));var T=t.getSelectionMode();T!==r.None&&a(e,o,\"ariaselection\",i.getText(T==r.MultiToggle?\"TBL_TABLE_SELECTION_MULTI\":\"TBL_TABLE_SELECTION_SINGLE\")),t.getFixedColumnCount()>0&&a(e,o,\"ariafixedcolumn\",i.getText(\"TBL_FIXED_COLUMN\")),e.write(\"</div>\")}},writeAriaAttributesFor:function(t,i,r,a){var o=i._getAccExtension();if(o.getAccMode()){var n,T,c=o._getAriaAttributesFor(r,a);for(T in c)n=c[T],e.isArray(n)&&(n=n.join(\" \")),n&&t.writeAttributeEscaped(T,n)}},writeAccRowSelectorText:function(e,t,i,r){if(!t._getAccExtension().getAccMode())return\"\";var o=t.isIndexSelected(r),n=t._getAccExtension().getAriaTextsForSelectionMode(!0),T=n.keyboard[o?\"rowDeselect\":\"rowSelect\"];a(e,i.getId(),\"rowselecttext\",i._bHidden?\"\":T,[\"sapUiTableAriaRowSel\"])},writeAccRowHighlightText:function(e,t,i,r){if(t._getAccExtension().getAccMode()){var o=i.getAggregation(\"_settings\"),n=o._getHighlightText();a(e,i.getId(),\"highlighttext\",n)}}})});",
		"sap/ui/table/TableColumnUtils.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Element\",\"sap/ui/Device\",\"./library\"],function(n,e,t,r){\"use strict\";var l={TableUtils:null,initColumnUtils:function(n){n._oColumnInfo||l.updateColumnInfo(n,l.collectColumnInfo(n))},invalidateColumnUtils:function(n){n._oColumnInfo=null},updateColumnInfo:function(n,e){n._oColumnInfo=e},collectColumnInfo:function(n){return{columnCount:n.getColumns().length,visibleColumnCount:l.TableUtils.getVisibleColumnCount(n),columnMap:l._getColumnMap(n)}},_getColumnMap:function(n){for(var e,t,r={},o={},u=n.getColumns(),a=l.TableUtils.getHeaderRowCount(n),i={},m=0;m<u.length;m++){t=u[m],r={},r.id=t.getId(),r.column=t,r.levelInfo=[],r.parents=[];for(var d=0;d<a;d++){r.levelInfo[d]={},r.levelInfo[d].spannedColumns=[];var s=l.getHeaderSpan(t,d);for(e=1;e<s;e++){var g=u[m+e];if(g){var f=g.getId();r.levelInfo[d].spannedColumns.push(u[m+e]),i[f]||(i[f]=[]),i[f].push({column:t,level:d})}}}o[r.id]=r}var C=Object.keys(i);for(e=0;e<C.length;e++){var v=C[e];o[v].parents=i[v]}return o},_getColumnMapItem:function(e,t){l.initColumnUtils(e);var r=e._oColumnInfo.columnMap[t];if(r)return r;n.sap.log.error(\"Column with ID '\"+t+\"' not found\",e)},getParentSpannedColumns:function(n,e,t){var r=l._getColumnMapItem(n,e);if(r){for(var o=[],u=0;u<r.parents.length;u++){var a=r.parents[u];void 0!==t&&a.level!==t||o.push(a)}return o}},getChildrenSpannedColumns:function(n,e,t){var r=l._getColumnMapItem(n,e);if(r){var o,u=[];o=void 0===t?r.levelInfo.length:t+1;for(var a=t||0;a<o;a++)for(var i=r.levelInfo[a],m=0;m<i.spannedColumns.length;m++)u.push({column:i.spannedColumns[m],level:a});return u}},getHeaderSpan:function(n,e){function t(n){var e=parseInt(n,10);return isNaN(e)?1:e}var r,l=n.getHeaderSpan();return l?(Array.isArray(l)||(l=(l+\"\").split(\",\")),r=isNaN(e)?Math.max.apply(null,l.map(t)):t(l[e]),Math.max(r,1)):1},getMaxHeaderSpan:function(n){return l.getHeaderSpan(n)},hasHeaderSpan:function(n){return l.getHeaderSpan(n)>1},getColumnBoundaries:function(n,e){var t=l._getColumnMapItem(n,e);if(t){var r={};e&&(r[e]=t.column);var o=function(e,t){var r,u,a=[];for(t=t||[],u=0;u<t.length;u++)r=e[t[u]],a=a.concat(l.getParentSpannedColumns(n,r.getId())),a=a.concat(l.getChildrenSpannedColumns(n,r.getId()));for(t=[],u=0;u<a.length;u++){r=a[u].column;var i=r.getId();e[i]||(t.push(i),e[i]=r)}return t.length>0?o(e,t):e};r=o(r,[e]);for(var u=n.indexOfColumn(t.column),a={startColumn:t.column,startIndex:u,endColumn:t.column,endIndex:-1},i=n.getColumns(),m=Object.getOwnPropertyNames(r),d=0;d<m.length;d++){var s=r[m[d]];u=n.indexOfColumn(s);var g=l.getMaxHeaderSpan(s);u<a.startIndex&&(a.startIndex=u,a.startColumn=s);var f=u+g-1;f>a.endIndex&&(a.endIndex=f,a.endColumn=i[f])}return a}},isColumnMovable:function(n){var e=n.getParent();if(!e||!e.getEnableColumnReordering())return!1;var t=e.indexOfColumn(n);return!(t<e.getFixedColumnCount()||t<e._iFirstReorderableIndex)&&(!l.hasHeaderSpan(n)&&0==l.getParentSpannedColumns(e,n.getId()).length)},_normalizeColumnMoveTargetIndex:function(n,e){var t=n.getParent(),r=t.indexOfColumn(n),l=t.getColumns();return e>r&&e--,e<0?e=0:e>l.length&&(e=l.length),e},isColumnMovableTo:function(n,e){var t=n.getParent();if(!t||void 0===e||!l.isColumnMovable(n))return!1;if((e=l._normalizeColumnMoveTargetIndex(n,e))<t.getFixedColumnCount()||e<t._iFirstReorderableIndex)return!1;var r=t.indexOfColumn(n),o=t.getColumns();if(e>r){var u=o[e>=o.length?o.length-1:e],a=l.getColumnBoundaries(t,u.getId());if(l.hasHeaderSpan(u)||a.endIndex>e)return!1}else{var i=o[e];if(0!=l.getParentSpannedColumns(t,i.getId()).length)return!1}return!0},moveColumnTo:function(n,e){if(!l.isColumnMovableTo(n,e))return!1;var t=n.getParent();return e!==t.indexOfColumn(n)&&(e=l._normalizeColumnMoveTargetIndex(n,e),!!t.fireColumnMove({column:n,newPos:e})&&(t._bReorderInProcess=!0,t.removeColumn(n),t.insertColumn(n,e),t._bReorderInProcess=!1,!0))},getMinColumnWidth:function(){return this._iColMinWidth?this._iColMinWidth:(this._iColMinWidth=48,t.system.desktop||(this._iColMinWidth=88),this._iColMinWidth)},resizeColumn:function(n,e,t,r,o){if(null==n||null==e||e<0||null==t||t<=0)return!1;(null==o||o<=0)&&(o=1),null==r&&(r=!0);var u=n.getColumns();if(e>=u.length||!u[e].getVisible())return!1;for(var a=[],i=e;i<u.length;i++){var m=u[i];if(m.getVisible()&&(a.push(m),a.length===o))break}for(var d=[],i=0;i<a.length;i++){var s=a[i];s.getResizable()&&d.push(s)}if(0===d.length)return!1;for(var g=0,i=0;i<a.length;i++){var s=a[i];g+=l.getColumnWidth(n,s.getIndex())}var f=t-g,C=Math.round(f/d.length),v=!1,h=n.getDomRef();l.TableUtils.isFixedColumn(n,e)||n._getVisibleColumns().forEach(function(n){var e,t=n.getWidth();h&&d.indexOf(n)<0&&l.TableUtils.isVariableWidth(t)&&(e=h.querySelector('th[data-sap-ui-colid=\"'+n.getId()+'\"]'))&&(n._minWidth=Math.max(e.offsetWidth,l.getMinColumnWidth()))});for(var i=0;i<d.length;i++){var c=d[i],p=l.getColumnWidth(n,c.getIndex()),I=p+C,x=l.getMinColumnWidth();I<x&&(I=x);var M=I-p;if(Math.abs(M)<Math.abs(C)){var b=d.length-(i+1);f-=M,C=Math.round(f/b)}if(0!==M){var _=!0,S=I+\"px\";r&&(_=n.fireColumnResize({column:c,width:S})),_&&(c.setWidth(S),v=!0)}}return v},getColumnWidth:function(n,e){if(null==n||null==e||e<0)return null;var t=n.getColumns();if(e>=t.length)return null;var r=t[e],l=r.getWidth();if(\"\"===l||\"auto\"===l||l.match(/%$/)){if(r.getVisible()){var o=r.getDomRef();return null!=o?o.offsetWidth:0}return 0}return n._CSSSizeToPixel(l)},getFixedColumnCount:function(n,e){var t=n.getFixedColumnCount();if(!e)return t;if(t<=0||n._bIgnoreFixedColumnCount)return 0;var r=n.getColumns(),l=0;t=Math.min(t,r.length);for(var o=0;o<t;o++)r[o].shouldRender()&&l++;return l}};return l},!0);",
		"sap/ui/table/TableExtension.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/base/Object\",\"./TableUtils\"],function(t,n,e){\"use strict\";var s=n.extend(\"sap.ui.table.TableExtension\",{constructor:function(t,i){n.call(this),this._table=t,this._settings=i||{},this._type=s.TABLETYPES.STANDARD,e.isInstanceOf(t,\"sap/ui/table/TreeTable\")?this._type=s.TABLETYPES.TREE:e.isInstanceOf(t,\"sap/ui/table/AnalyticalTable\")&&(this._type=s.TABLETYPES.ANALYTICAL);var a=this._init(this._table,this._type,this._settings);if(a){var o=this;t[\"_get\"+a]=function(){return o}}},destroy:function(){this._table=null,this._type=null,n.prototype.destroy.apply(this,arguments)},getInterface:function(){return this}});return s.TABLETYPES={TREE:\"TREE\",ANALYTICAL:\"ANALYTICAL\",STANDARD:\"STANDARD\"},s.prototype.getTable=function(){return this._table},s.prototype._init=function(t,n,e){return null},s.prototype._attachEvents=function(){},s.prototype._detachEvents=function(){},s.attachEvents=function(t){if(t._aExtensions)for(var n=0;n<t._aExtensions.length;n++)t._aExtensions[n]._attachEvents()},s.detachEvents=function(t){if(t._aExtensions)for(var n=0;n<t._aExtensions.length;n++)t._aExtensions[n]._detachEvents()},s.enrich=function(t,n,e){if(!(n&&n.prototype instanceof s))return null;var i=new n(t,e);return t._aExtensions||(t._aExtensions=[]),t._aExtensions.push(i),i},s.cleanup=function(t){if(t._bExtensionsInitialized&&t._aExtensions){for(var n=0;n<t._aExtensions.length;n++)t._aExtensions[n].destroy();delete t._aExtensions,delete t._bExtensionsInitialized}},s});",
		"sap/ui/table/TableGrouping.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Element\",\"sap/ui/model/Sorter\",\"sap/ui/Device\",\"./library\"],function(e,o,n,t,r){\"use strict\";var a={TableUtils:null,clearMode:function(e){e._mode=null},setGroupMode:function(e){e._mode=\"Group\"},isGroupMode:function(e){return\"Group\"==e._mode},setTreeMode:function(e){e._mode=\"Tree\"},isTreeMode:function(e){return\"Tree\"==e._mode},getModeCssClass:function(e){return e._mode?\"sapUiTable\"+e._mode+\"Mode\":null},showGroupMenuButton:function(e){return!0===e._bShowGroupMenuButton||!1===e._bShowGroupMenuButton?e._bShowGroupMenuButton:(!t.system.desktop&&a.TableUtils.isInstanceOf(e,\"sap/ui/table/AnalyticalTable\")?e._bShowGroupMenuButton=!0:e._bShowGroupMenuButton=!1,e._bShowGroupMenuButton)},toggleGroupHeader:function(e,o,n){var t=e.getBinding(\"rows\");if(t){var r=t.isExpanded(o),a=!0;if(null!=t.nodeHasChildren&&(a=null!=t.getNodeByIndex&&!t.nodeHasChildren(t.getNodeByIndex(o))),a)return null;if(!0!==n||r)if(!1===n&&r)t.collapse(o);else{if(!0===n||!1===n)return null;t.toggleIndex(o)}else t.expand(o);return!r}return null},toggleGroupHeaderByRef:function(o,n,t){var r,i=e(n);r=i.hasClass(\"sapUiTableTreeIcon\")||a.isTreeMode(o)&&i.hasClass(\"sapUiTableTdFirst\")?i.closest(\"tr\",o.getDomRef()):i.closest(\".sapUiTableGroupHeader\",o.getDomRef());var l=o.getBinding(\"rows\");if(r.length>0&&l){var s=r.data(\"sap-ui-rowindex\"),d=o.getRows()[s];if(null!=d){var u=d.getIndex(),p=a.toggleGroupHeader(o,u,t),g=!0===p||!1===p;return g&&o._onGroupHeaderChanged&&o._onGroupHeaderChanged(u,p),g}}return!1},isInGroupingRow:function(e){var o=a.TableUtils.getCellInfo(e);return o&&o.type===a.TableUtils.CELLTYPES.DATACELL?o.cell.parent().hasClass(\"sapUiTableGroupHeader\"):!!(o&&o.type===a.TableUtils.CELLTYPES.ROWHEADER||o&&o.type===a.TableUtils.CELLTYPES.ROWACTION)&&o.cell.hasClass(\"sapUiTableGroupHeader\")},isGroupingRow:function(o){return!!o&&e(o).hasClass(\"sapUiTableGroupHeader\")},isInSumRow:function(e){var o=a.TableUtils.getCellInfo(e);return o&&o.type===a.TableUtils.CELLTYPES.DATACELL?o.cell.parent().hasClass(\"sapUiAnalyticalTableSum\"):!!(o&&o.type===a.TableUtils.CELLTYPES.ROWHEADER||o&&o.type===a.TableUtils.CELLTYPES.ROWACTION)&&o.cell.hasClass(\"sapUiAnalyticalTableSum\")},_calcGroupIndent:function(e,o,n){if(a.TableUtils.isInstanceOf(e,\"sap/ui/table/TreeTable\")){for(var t=0,r=0;r<o;r++)t+=r<2?12:8;return t}if(a.TableUtils.isInstanceOf(e,\"sap/ui/table/AnalyticalTable\")){var t=0;o-=1,o=n?o:o-1,o=Math.max(o,0);for(var r=0;r<o;r++)0==t&&(t=12),t+=r<2?12:8;return t}var t=0;o=n?o:o-1,o=Math.max(o,0);for(var r=0;r<o;r++)t+=r<2?12:8;return t},_setIndent:function(e,o,n,t){var r=e._bRtlMode,a=o.find(\"td.sapUiTableTdFirst > .sapUiTableCell\"),i=n.find(\".sapUiTableGroupShield\");t<=0?(n.css(r?\"right\":\"left\",\"\"),i.css(\"width\",\"\").css(r?\"margin-right\":\"margin-left\",\"\"),a.css(r?\"padding-right\":\"padding-left\",\"\")):(n.css(r?\"right\":\"left\",t+\"px\"),i.css(\"width\",t+\"px\").css(r?\"margin-right\":\"margin-left\",-1*t+\"px\"),a.css(r?\"padding-right\":\"padding-left\",t+8+\"px\"))},updateTableRowForGrouping:function(o,n,t,r,i,l,s,d){var u=n.getDomRefs(!0),p=u.row,g=u.rowScrollPart,f=u.rowFixedPart,c=u.rowSelector,T=u.rowAction;p.attr({\"data-sap-ui-level\":s}),p.data(\"sap-ui-level\",s),a.isGroupMode(o)&&(p.toggleClass(\"sapUiAnalyticalTableSum\",!t&&l).toggleClass(\"sapUiAnalyticalTableDummy\",!1).toggleClass(\"sapUiTableGroupHeader\",t).toggleClass(\"sapUiTableRowHidden\",t&&i||n._bHidden),e.sap.byId(n.getId()+\"-groupHeader\").toggleClass(\"sapUiTableGroupIconOpen\",t&&r).toggleClass(\"sapUiTableGroupIconClosed\",t&&!r).attr(\"title\",o._getShowStandardTooltips()&&d?d:null).text(d||\"\"),a._setIndent(o,p,c,a._calcGroupIndent(o,s,t)));var _=null;if(a.isTreeMode(o)&&(_=p.find(\".sapUiTableTreeIcon\"),_.css(o._bRtlMode?\"margin-right\":\"margin-left\",17*s+\"px\").toggleClass(\"sapUiTableTreeIconLeaf\",!t).toggleClass(\"sapUiTableTreeIconNodeOpen\",t&&r).toggleClass(\"sapUiTableTreeIconNodeClosed\",t&&!r)),a.showGroupMenuButton(o)){var b=0,h=o.$();h.hasClass(\"sapUiTableVScr\")&&(b+=h.find(\".sapUiTableVSb\").width());var C=c.find(\".sapUiTableGroupMenuButton\");o._bRtlMode?C.css(\"right\",h.width()-C.width()+c.position().left-b-5+\"px\"):C.css(\"left\",h.width()-C.width()-c.position().left-b-5+\"px\")}o._getAccExtension().updateAriaExpandAndLevelState(n,g,c,f,T,t,r,s,_)},cleanupTableRowForGrouping:function(e,o){var n=o.getDomRefs(!0);n.row.removeAttr(\"data-sap-ui-level\"),n.row.removeData(\"sap-ui-level\"),a.isGroupMode(e)&&(n.row.removeClass(\"sapUiTableGroupHeader sapUiAnalyticalTableSum sapUiAnalyticalTableDummy\"),a._setIndent(e,n.row,n.rowSelector,0));var t=null;a.isTreeMode(e)&&(t=n.row.find(\".sapUiTableTreeIcon\"),t.removeClass(\"sapUiTableTreeIconLeaf\").removeClass(\"sapUiTableTreeIconNodeOpen\").removeClass(\"sapUiTableTreeIconNodeClosed\").css(this._bRtlMode?\"margin-right\":\"margin-left\",\"\")),e._getAccExtension().updateAriaExpandAndLevelState(o,n.rowScrollPart,n.rowSelector,n.rowFixedPart,n.rowAction,!1,!1,-1,t)},updateGroups:function(e){if(a.isGroupMode(e)||a.isTreeMode(e)){var o=e.getBinding(\"rows\"),n=e.getBindingInfo(\"rows\"),t=e.getRows(),r=t.length;if(o)for(var i,l=0;l<r;l++)i=a._getRowGroupInfo(e,t[l],o,n),a.updateTableRowForGrouping(e,t[l],i.isHeader,i.expanded,i.hidden,!1,i.level,i.title);else for(var l=0;l<r;l++)a.cleanupTableRowForGrouping(e,t[l])}},_getRowGroupInfo:function(e,o,n,t){var r={isHeader:!1,expanded:!1,hidden:!1,title:\"\",level:0};if(e.getGroupHeaderProperty){r.isHeader=o._bHasChildren,r.expanded=o._bIsExpanded,r.hidden=r.isHeader,r.level=o._iLevel;var i=e.getGroupHeaderProperty();if(a.isGroupMode(e)&&i){var l=t&&t.model;r.title=e.getModel(l).getProperty(i,o.getBindingContext(l))}}else{var s=o.getIndex();r.isHeader=!!n.isGroupHeader(s),r.level=r.isHeader?0:1,r.isHeader&&(r.expanded=!!n.isExpanded(s),r.hidden=!0,r.title=n.getTitle(s))}return r},setupExperimentalGrouping:function(t){if(t.getEnableGrouping()){var r=o.prototype.getBinding.call(t,\"rows\"),i=sap.ui.getCore().byId(t.getGroupBy());if(i&&i.getGrouped()&&r&&a.TableUtils.isInstanceOf(r,\"sap/ui/model/ClientListBinding\")&&!r._modified){r._modified=!0,a.setGroupMode(t);var l=i.getSortProperty();r.sort(new n(l));for(var s,d=r.getLength(),u=r.getContexts(0,d),p=0,g=d-1;g>=0;g--){var f=u[g].getProperty(l);if(s||(s=f),s!==f){var c=u[g+1].getModel().getContext(\"/sap.ui.table.GroupInfo\"+g);c.__groupInfo={oContext:u[g+1],name:s,count:p,groupHeader:!0,expanded:!0},u.splice(g+1,0,c),s=f,p=0}p++}var c=u[0].getModel().getContext(\"/sap.ui.table.GroupInfo\");c.__groupInfo={oContext:u[0],name:s,count:p,groupHeader:!0,expanded:!0},u.splice(0,0,c),e.extend(r,{getLength:function(){return u.length},getContexts:function(e,o){return u.slice(e,e+o)},isGroupHeader:function(e){var o=u[e];return!0===(o&&o.__groupInfo&&o.__groupInfo.groupHeader)},getTitle:function(e){var o=u[e];return o&&o.__groupInfo&&o.__groupInfo.name+\" - \"+o.__groupInfo.count},isExpanded:function(e){var o=u[e];return this.isGroupHeader(e)&&o.__groupInfo&&o.__groupInfo.expanded},expand:function(e){if(this.isGroupHeader(e)&&!u[e].__groupInfo.expanded){for(var o=0;o<u[e].__childs.length;o++)u.splice(e+1+o,0,u[e].__childs[o]);delete u[e].__childs,u[e].__groupInfo.expanded=!0,this._fireChange()}},collapse:function(e){this.isGroupHeader(e)&&u[e].__groupInfo.expanded&&(u[e].__childs=u.splice(e+1,u[e].__groupInfo.count),u[e].__groupInfo.expanded=!1,this._fireChange())},toggleIndex:function(e){this.isExpanded(e)?this.collapse(e):this.expand(e)},nodeHasChildren:function(e){return null!=e&&null!=e.__groupInfo&&!0===e.__groupInfo.groupHeader},getNodeByIndex:function(e){return u[e]}}),t._mTimeouts.groupingFireBindingChange=t._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){r._fireChange()},0)}}},resetExperimentalGrouping:function(e){var o=e.getBinding(\"rows\");if(o&&o._modified){a.clearMode(e);var n=e.getBindingInfo(\"rows\");e.unbindRows(),e.bindRows(n)}}};return a},!0);",
		"sap/ui/table/TableKeyboardDelegate2.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/base/Object\",\"sap/ui/Device\",\"./library\",\"./TableUtils\"],function(e,t,o,n,i){\"use strict\";function s(e,t){e instanceof window.HTMLInputElement&&(!1===t?e.setSelectionRange(0,0):e.select())}function l(e,t){var o=i.getCell(e,t);if(!o)return{};var n,s=i.getCellInfo(o[0])||{};return s.type===u.ROWHEADER||s.type===u.ROWACTION?s.row=parseInt(o.data(\"sap-ui-rowindex\"),10):s.type===u.DATACELL?(n=i.getDataCellInfo(e,o),s.row=n.rowIndex,s.col=n.columnIndex):s.type===u.COLUMNHEADER&&(s.col=parseInt(o.data(\"sap-ui-colindex\"),10),s.span=parseInt(o.attr(\"colspan\")||1,10)),s}function a(e,t,o,n,i){function l(){var t=a&&a[0];if(t){var o=(i?f._getInteractiveElements(t)||[]:[])[0],n=e._getKeyboardExtension();n._actionMode=!!o,s(document.activeElement,!1),n._setSilentFocus(o||t),s(o)}}var a;if(n===u.ROWHEADER)e.$().find('.sapUiTableRowHdr[data-sap-ui-rowindex=\"'+t+'\"]').focus();else if(n===u.ROWACTION)a=e.$().find('.sapUiTableRowAction[data-sap-ui-rowindex=\"'+t+'\"]'),l();else if(n===u.DATACELL){var r=e.getColumns()[o];a=r?e.$().find('[data-sap-ui-rowindex=\"'+t+'\"] [data-sap-ui-colid=\"'+r.getId()+'\"]'):null,l()}}function r(e,t){e.setMarked(\"sapUiTableSkipItemNavigation\",!1!==t)}var u=i.CELLTYPES,g=n.SelectionMode,c={CTRL:1,SHIFT:2,ALT:4},f=t.extend(\"sap.ui.table.TableKeyboardDelegate2\",{constructor:function(e){t.call(this)},destroy:function(){t.prototype.destroy.apply(this,arguments)},getInterface:function(){return this}});return f._restoreFocusOnLastFocusedDataCell=function(e,t){var o=i.getFocusedItemInfo(e),n=e._getKeyboardExtension()._getLastFocusedCellInfo();i.focusItem(e,o.cellInRow+o.columnCount*n.row,t)},f._setFocusOnColumnHeaderOfLastFocusedDataCell=function(e,t){var o=i.getFocusedItemInfo(e);i.focusItem(e,o.cellInRow,t)},f._forwardFocusToTabDummy=function(e,t){e._getKeyboardExtension()._setSilentFocus(e.$().find(\".\"+t))},f._isKeyCombination=function(t,n,i){null==i&&(i=0);var s=\"string\"==typeof n?String.fromCharCode(t.charCode):t.keyCode,l=0;l|=(o.os.macintosh?t.metaKey:t.ctrlKey)&&n!==e.sap.KeyCodes.CONTROL?c.CTRL:0,l|=t.shiftKey&&n!==e.sap.KeyCodes.SHIFT?c.SHIFT:0,l|=t.altKey&&n!==e.sap.KeyCodes.ALT?c.ALT:0;var a=null==n||s===n,r=i===l;return a&&r},f._handleSpaceAndEnter=function(e,t){var o=i.getCellInfo(t.target)||{};if(o.type===u.COLUMNROWHEADER)e._toggleSelectAll();else if(f._isElementGroupToggler(e,t.target))i.Grouping.toggleGroupHeaderByRef(e,t.target);else if(o.type===u.ROWHEADER)i.toggleRowSelection(e,t.target);else if(o.type===u.DATACELL||o.type===u.ROWACTION){var n=!e.hasListeners(\"cellClick\");if(e._findAndfireCellEvent(e.fireCellClick,t)||i.isRowSelectionAllowed(e)&&(i.toggleRowSelection(e,t.target),n=!1),n){var s=f._getInteractiveElements(t.target);null!==s&&e._getKeyboardExtension().setActionMode(!0)}}},f._moveColumn=function(e,t){var o,n=e.getParent(),s=n._getVisibleColumns(),l=s.indexOf(e);t&&l<s.length-1?o=n.indexOfColumn(s[l+1])+1:!t&&l>0&&(o=n.indexOfColumn(s[l-1])),null!=o&&i.Column.moveColumnTo(e,o)},f._getVisibleAndGroupedColumns=function(e){return e.getColumns().filter(function(e){return e.getVisible()||e.getGrouped()})},f._getColumnIndexInVisibleAndGroupedColumns=function(e,t){for(var o=f._getVisibleAndGroupedColumns(e),n=0;n<o.length;n++){if(o[n]===t)return n}return-1},f._focusRowSelector=function(e,t){e._getKeyboardExtension()._setFocus(e.getDomRef(\"rowsel\"+t))},f._isElementGroupToggler=function(e,t){return i.Grouping.isInGroupingRow(t)||i.Grouping.isTreeMode(e)&&t.classList.contains(\"sapUiTableTdFirst\")&&(null!=t.querySelector(\".sapUiTableTreeIconNodeOpen\")||null!=t.querySelector(\".sapUiTableTreeIconNodeClosed\"))||t.classList.contains(\"sapUiTableTreeIconNodeOpen\")||t.classList.contains(\"sapUiTableTreeIconNodeClosed\")},f._isElementInteractive=function(t){return null!=t&&e(t).is(\":sapTabbable, input:sapFocusable, .sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)\")},f._getInteractiveElements=function(t){if(null==t)return null;var o=e(t),n=i.getCellInfo(o);if(null!==n&&(n.type===i.CELLTYPES.DATACELL||n.type===i.CELLTYPES.ROWACTION)){var s=o.find(\":sapTabbable, input:sapFocusable, .sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)\");if(s.length>0)return s}return null},f._getFirstInteractiveElement=function(e){if(null==e)return null;for(var t,o,n,s=e.getParent(),l=e.getCells(),a=0;a<l.length;a++)if(t=l[a].getDomRef(),o=i.getCell(s,t),null!==(n=this._getInteractiveElements(o)))return n.first();return i.hasRowActions(s)&&(t=e.getAggregation(\"_rowAction\").getDomRef(),o=i.getCell(s,t),null!==(n=this._getInteractiveElements(o)))?n.first():null},f._getLastInteractiveElement=function(e){if(null==e)return null;var t,o,n,s=e.getParent(),l=e.getCells();if(i.hasRowActions(s)&&(t=e.getAggregation(\"_rowAction\").getDomRef(),o=i.getParentRowActionCell(s,t),null!==(n=this._getInteractiveElements(o))))return n.last();for(var a=l.length-1;a>=0;a--)if(t=l[a].getDomRef(),o=i.getParentDataCell(s,t),null!==(n=this._getInteractiveElements(o)))return n.last();return null},f._getPreviousInteractiveElement=function(t,o){if(null==t||null==o)return null;var n=e(o);if(!this._isElementInteractive(n))return null;var s,l,a,r,u,g,c,p,C=i.getParentRowActionCell(t,o);if(null!==C){if(l=this._getInteractiveElements(C),l[0]!==n[0])return l.eq(l.index(o)-1);var d=i.getRowActionCellInfo(t,C).rowIndex;r=t.getRows()[d],u=r.getCells(),s=i.getParentDataCell(t,u[u.length-1].getDomRef()),a=i.getDataCellInfo(t,s),g=t.getColumns()[a.columnIndex],c=f._getColumnIndexInVisibleAndGroupedColumns(t,g),p=c}else if(s=i.getParentDataCell(t,o),a=i.getDataCellInfo(t,s),r=t.getRows()[a.rowIndex],u=r.getCells(),g=t.getColumns()[a.columnIndex],c=f._getColumnIndexInVisibleAndGroupedColumns(t,g),p=c-1,l=this._getInteractiveElements(s),l[0]!==n[0])return l.eq(l.index(o)-1);for(var h=p;h>=0;h--){var R=u[h].getDomRef();if(s=i.getParentDataCell(t,R),null!==(l=this._getInteractiveElements(s)))return l.last()}return null},f._getNextInteractiveElement=function(t,o){if(null==t||null==o)return null;var n=e(o);if(!this._isElementInteractive(n))return null;var s,l=i.getParentDataCell(t,o),a=null;if(null!==l){var r=i.getDataCellInfo(t,l),u=t.getRows()[r.rowIndex],g=u.getCells();if(s=this._getInteractiveElements(l),s.get(-1)!==n[0])return s.eq(s.index(o)+1);for(var c=t.getColumns()[r.columnIndex],p=f._getColumnIndexInVisibleAndGroupedColumns(t,c),C=p+1;C<g.length;C++){var d=g[C].getDomRef();if(l=i.getParentDataCell(t,d),null!==(s=this._getInteractiveElements(l)))return s.first()}i.hasRowActions(t)&&(a=i.getParentRowActionCell(t,u.getAggregation(\"_rowAction\").getDomRef()))}return i.hasRowActions(t)&&(null===a&&(a=i.getParentRowActionCell(t,o)),null!==a&&(s=this._getInteractiveElements(a),s.get(-1)!==n[0]))?s.eq(s.index(o)+1):null},f.prototype.enterActionMode=function(){var e=this._getKeyboardExtension(),t=document.activeElement,o=f._getInteractiveElements(t),n=i.getParentDataCell(this,t),l=n||i.getParentRowActionCell(this,t);return null!==o?(e._suspendItemNavigation(),t.tabIndex=-1,s(t,!1),e._setSilentFocus(o[0]),s(o[0]),!0):null!==l&&(this._getKeyboardExtension()._suspendItemNavigation(),!0)},f.prototype.leaveActionMode=function(e){e=null==e||e;var t=this._getKeyboardExtension(),o=document.activeElement;t._resumeItemNavigation();var n=i.getParentDataCell(this,o),l=n||i.getParentRowActionCell(this,o);e&&(null!==l?(s(o,!1),t._setSilentFocus(l)):(o.blur(),t._setSilentFocus(o)))},f.prototype.onfocusin=function(t){if(!t.isMarked(\"sapUiTableIgnoreFocusIn\")){var o=e(t.target);if(o.hasClass(\"sapUiTableOuterBefore\")||o.hasClass(\"sapUiTableOuterAfter\")||t.target!=this.getDomRef(\"overlay\")&&this.getShowOverlay())this.$(\"overlay\").focus();else if(o.hasClass(\"sapUiTableCtrlBefore\")){var n=i.isNoDataVisible(this);!n||n&&this.getColumnHeaderVisible()?f._setFocusOnColumnHeaderOfLastFocusedDataCell(this,t):this._getKeyboardExtension()._setSilentFocus(this.$(\"noDataCnt\"))}else o.hasClass(\"sapUiTableCtrlAfter\")&&(i.isNoDataVisible(this)||f._restoreFocusOnLastFocusedDataCell(this,t));var s=i.getParentDataCell(this,o),l=s||i.getParentRowActionCell(this,o),a=null!==l,r=a&&f._isElementInteractive(o);if(this._getKeyboardExtension().isInActionMode()){var g=i.getCellInfo(t.target)||{},c=null!=g.cell,p=g.type===u.ROWHEADER&&i.Grouping.isInGroupingRow(t.target),C=g.type===u.ROWHEADER&&!p&&i.isRowSelectorSelectionAllowed(this);!c||p||C?a&&!r&&this._getKeyboardExtension().setActionMode(!1,!1):this._getKeyboardExtension().setActionMode(!1)}else r&&this._getKeyboardExtension().setActionMode(!0)}},f.prototype.onkeydown=function(t){var o=this._getKeyboardExtension();if(f._isKeyCombination(t,e.sap.KeyCodes.F2)){var n=o.isInActionMode(),s=i.getParentDataCell(this,t.target),l=s||i.getParentRowActionCell(this,t.target);return void(n||null==l?o.setActionMode(!n):l.focus())}if(f._isKeyCombination(t,e.sap.KeyCodes.F4)&&f._isElementGroupToggler(this,t.target))return void i.Grouping.toggleGroupHeaderByRef(this,t.target);if(!this._getKeyboardExtension().isInActionMode()){var a=e(t.target),r=i.getCellInfo(a)||{};if(f._isKeyCombination(t,e.sap.KeyCodes.SHIFT)&&this.getSelectionMode()===g.MultiToggle&&(r.type===u.ROWHEADER&&i.isRowSelectorSelectionAllowed(this)||(r.type===u.DATACELL||r.type===u.ROWACTION)&&i.isRowSelectionAllowed(this))){var p=i.getRowIndexOfFocusedCell(this),C=this.getRows()[p].getIndex();this._oRangeSelection={startIndex:C,selected:this.isIndexSelected(C)}}else f._isKeyCombination(t,e.sap.KeyCodes.A,c.CTRL)?(t.preventDefault(),r.type!==u.DATACELL&&r.type!==u.ROWHEADER&&r.type!==u.ROWACTION&&r.type!==u.COLUMNROWHEADER||this.getSelectionMode()!==g.MultiToggle||this._toggleSelectAll()):f._isKeyCombination(t,e.sap.KeyCodes.A,c.CTRL+c.SHIFT)?r.type!==u.DATACELL&&r.type!==u.ROWHEADER&&r.type!==u.ROWACTION&&r.type!==u.COLUMNROWHEADER||this.clearSelection():f._isKeyCombination(t,e.sap.KeyCodes.F4)?r.type===u.DATACELL&&o.setActionMode(!0):f._isKeyCombination(t,e.sap.KeyCodes.F10,c.SHIFT)&&(t.preventDefault(),i.Menu.openContextMenu(this,t.target,!0))}},f.prototype.onkeypress=function(e){var t=this._getKeyboardExtension(),o=i.getCellInfo(e.target)||{};f._isKeyCombination(e,\"+\")?f._isElementGroupToggler(this,e.target)?i.Grouping.toggleGroupHeaderByRef(this,e.target,!0):o.type!==u.DATACELL&&o.type!==u.ROWACTION||t.setActionMode(!0):f._isKeyCombination(e,\"-\")&&(f._isElementGroupToggler(this,e.target)?i.Grouping.toggleGroupHeaderByRef(this,e.target,!1):o.type!==u.DATACELL&&o.type!==u.ROWACTION||t.setActionMode(!0))},f.prototype.oncontextmenu=function(e){if(!e.isMarked(\"handledByPointerExtension\")){e.preventDefault();var t=i.getCell(this,e.target),o=i.getCellInfo(t)||{};o.type!==u.COLUMNHEADER&&o.type!==u.DATACELL||i.Menu.openContextMenu(this,e.target,!0)}},f.prototype.onkeyup=function(t){var o=i.getCellInfo(t.target)||{};f._isKeyCombination(t,e.sap.KeyCodes.SHIFT)&&delete this._oRangeSelection,f._isKeyCombination(t,e.sap.KeyCodes.SPACE)&&(t.preventDefault(),o.type===u.COLUMNHEADER?i.Menu.openContextMenu(this,t.target,!0):f._handleSpaceAndEnter(this,t)),f._isKeyCombination(t,e.sap.KeyCodes.ENTER)&&o.type===u.COLUMNHEADER&&i.Menu.openContextMenu(this,t.target,!0)},f.prototype.onsaptabnext=function(t){var o,n,l=this._getKeyboardExtension(),a=i.getCellInfo(t.target)||{};if(l.isInActionMode()){n=i.getParentDataCell(this,t.target);var r,g,c=i.getParentRowActionCell(this,t.target),p=!1;if(null===n&&null===c){if(a.type!==u.ROWHEADER)return;o=e(t.target),r=o.data(\"sap-ui-rowindex\"),p=!0}else null!==n?(o=n,r=i.getDataCellInfo(this,n).rowIndex):(o=c,r=i.getRowActionCellInfo(this,c).rowIndex);var C=this.getRows()[r],d=f._getLastInteractiveElement(C);if(null===d||d[0]===t.target){var h=C.getIndex(),R=i.isLastScrollableRow(this,o),m=this._getRowCount()-1===h,E=i.isRowSelectorSelectionAllowed(this),I=!1;if(!m&&R&&(I=this._getScrollExtension().scroll(!0,null,!0)),m)t.preventDefault(),l.setActionMode(!1);else if(I)t.preventDefault(),this.attachEventOnce(\"_rowsUpdated\",function(){setTimeout(function(){var e=i.Grouping.isGroupingRow(C.getDomRef());E||e?f._focusRowSelector(this,r):(g=f._getFirstInteractiveElement(C),s(document.activeElement,!1),g.focus(),s(g[0]))}.bind(this),0)}.bind(this));else{t.preventDefault();var y=r+1,A=this.getRows()[y],v=i.Grouping.isGroupingRow(A.getDomRef());E||v?f._focusRowSelector(this,y):(g=f._getFirstInteractiveElement(A),s(document.activeElement,!1),g.focus(),s(g[0]))}}else p?(t.preventDefault(),g=f._getFirstInteractiveElement(C),s(document.activeElement,!1),g.focus(),s(g[0])):(t.preventDefault(),g=f._getNextInteractiveElement(this,t.target),s(document.activeElement,!1),g.focus(),s(g[0]))}else a.type===u.COLUMNHEADER||a.type===u.COLUMNROWHEADER?(i.isNoDataVisible(this)?this.$(\"noDataCnt\").focus():f._restoreFocusOnLastFocusedDataCell(this,t),t.preventDefault()):a.type===u.DATACELL||a.type===u.ROWHEADER?f._forwardFocusToTabDummy(this,\"sapUiTableCtrlAfter\"):t.target===this.getDomRef(\"overlay\")?l._setSilentFocus(this.$().find(\".sapUiTableOuterAfter\")):0===Object.keys(a).length&&null!==(n=i.getParentDataCell(this,t.target))&&(t.preventDefault(),n.focus())},f.prototype.onsaptabprevious=function(t){var o,n,l=this._getKeyboardExtension(),a=i.getCellInfo(t.target)||{};if(l.isInActionMode()){n=i.getParentDataCell(this,t.target);var r,g,c=i.getParentRowActionCell(this,t.target),p=!1;if(null===n&&null===c){if(a.type!==u.ROWHEADER)return;o=e(t.target),r=o.data(\"sap-ui-rowindex\"),p=!0}else null!==n?(o=n,r=i.getDataCellInfo(this,n).rowIndex):(o=c,r=i.getRowActionCellInfo(this,c).rowIndex);var C=this.getRows()[r],d=C.getIndex(),h=f._getFirstInteractiveElement(C),R=null!==h&&h[0]===t.target,m=i.isRowSelectorSelectionAllowed(this),E=i.Grouping.isGroupingRow(C),I=m||E;if(R&&I)t.preventDefault(),f._focusRowSelector(this,r);else if(R&&!I||p){var y=i.isFirstScrollableRow(this,o),A=0===d,v=!1;if(!A&&y&&(v=this._getScrollExtension().scroll(!1,null,!0)),A)t.preventDefault(),l.setActionMode(!1);else if(v)t.preventDefault(),this.attachEventOnce(\"_rowsUpdated\",function(){setTimeout(function(){i.Grouping.isGroupingRow(C.getDomRef())?f._focusRowSelector(this,r):(g=f._getLastInteractiveElement(C),s(document.activeElement,!1),g.focus(),s(g[0]))}.bind(this),0)}.bind(this));else{t.preventDefault();var w=r-1,_=this.getRows()[w],D=i.Grouping.isGroupingRow(_.getDomRef());D?f._focusRowSelector(this,w):(g=f._getLastInteractiveElement(_),s(document.activeElement,!1),g.focus(),s(g[0]))}}else t.preventDefault(),g=f._getPreviousInteractiveElement(this,t.target),s(document.activeElement,!1),g.focus(),s(g[0])}else a.type===u.DATACELL||a.type===u.ROWHEADER||t.target===this.getDomRef(\"noDataCnt\")?this.getColumnHeaderVisible()?(f._setFocusOnColumnHeaderOfLastFocusedDataCell(this,t),t.preventDefault()):f._forwardFocusToTabDummy(this,\"sapUiTableCtrlBefore\"):t.target===this.getDomRef(\"overlay\")?this._getKeyboardExtension()._setSilentFocus(this.$().find(\".sapUiTableOuterBefore\")):0===Object.keys(a).length&&null!==(n=i.getParentDataCell(this,t.target))&&(t.preventDefault(),n.focus())},f.prototype.onsapdown=function(e){if(!e.isMarked()){var t=this._getKeyboardExtension(),o=t.isInActionMode(),n=l(this,e.target),s=!1,g=this;if(n.type===u.DATACELL||n.type===u.ROWHEADER||n.type===u.ROWACTION){var p=f._isKeyCombination(e,null,c.CTRL),C=p||o,d=i.getParentDataCell(this,e.target),h=d||i.getParentRowActionCell(this,e.target);if(!p&&(e.target instanceof window.HTMLInputElement||e.target instanceof window.HTMLTextAreaElement))return;if(!C&&null!=h)return void h.focus();r(e),i.isLastScrollableRow(this,n.cell[0])&&(s=this._getScrollExtension().scroll(!0,!1,!0)),s?C&&this.attachEventOnce(\"_rowsUpdated\",function(){setTimeout(function(){a(g,n.row,n.col,n.type,!0),e.preventDefault()},0)}):n.row===g.getVisibleRowCount()-1?o||null==h?t.setActionMode(!1):h.focus():(a(g,n.row+1,n.col,n.type,C),e.preventDefault())}else if(n.type===u.COLUMNHEADER||n.type===u.COLUMNROWHEADER){var R=i.getHeaderRowCount(this);if(i.isNoDataVisible(this)){var m=i.getFocusedItemInfo(this);m.row-R<=1&&r(e)}else n.type===u.COLUMNROWHEADER&&R>1&&(r(e),i.focusItem(this,R*(i.getVisibleColumnCount(this)+1),e))}}},f.prototype.onsapdownmodifiers=function(e){if(f._isKeyCombination(e,null,c.CTRL))return f.prototype.onsapdown.call(this,e);var t=this._getKeyboardExtension();if(f._isKeyCombination(e,null,c.ALT)&&f._isElementGroupToggler(this,e.target))return r(e),void i.Grouping.toggleGroupHeaderByRef(this,e.target,!0);if(!t.isInActionMode()){var o=i.getCellInfo(e.target)||{};if(f._isKeyCombination(e,null,c.SHIFT))if(e.preventDefault(),o.type===u.ROWHEADER||o.type===u.DATACELL||o.type===u.ROWACTION){if(!this._oRangeSelection)return void r(e);var n=i.getRowIndexOfFocusedCell(this),s=this.getRows()[n].getIndex();if(s===this._getRowCount()-1)return;if(i.isLastScrollableRow(this,e.target)){var l=this._getScrollExtension().scroll(!0,!1,!0);l&&r(e)}this._oRangeSelection.startIndex<=s?(s++,this._oRangeSelection.selected?i.toggleRowSelection(this,s,!0):i.toggleRowSelection(this,s,!1)):i.toggleRowSelection(this,s,!1)}else r(e);f._isKeyCombination(e,null,c.ALT)&&(o.type===u.DATACELL&&t.setActionMode(!0),r(e))}},f.prototype.onsapup=function(e){if(!e.isMarked()){var t=this._getKeyboardExtension(),o=t.isInActionMode(),n=l(this,e.target),s=!1,g=this;if(n.type===u.DATACELL||n.type===u.ROWHEADER||n.type===u.ROWACTION){var p=f._isKeyCombination(e,null,c.CTRL),C=p||o,d=i.getParentDataCell(this,e.target),h=d||i.getParentRowActionCell(this,e.target);if(!p&&(e.target instanceof window.HTMLInputElement||e.target instanceof window.HTMLTextAreaElement))return;if(!C&&null!=h)return void h.focus();r(e),i.isFirstScrollableRow(this,n.cell[0])&&(s=this._getScrollExtension().scroll(!1,!1,!0)),s?C&&this.attachEventOnce(\"_rowsUpdated\",function(){setTimeout(function(){a(g,n.row,n.col,n.type,!0),e.preventDefault()},0)}):0===n.row?(r(e,!!C||n.type===u.ROWACTION),o||null==h?t.setActionMode(!1):h.focus()):(a(g,n.row-1,n.col,n.type,C),e.preventDefault())}}},f.prototype.onsapupmodifiers=function(e){var t=this._getKeyboardExtension();if(f._isKeyCombination(e,null,c.CTRL))return f.prototype.onsapup.call(this,e);if(f._isKeyCombination(e,null,c.ALT)&&f._isElementGroupToggler(this,e.target))return r(e),void i.Grouping.toggleGroupHeaderByRef(this,e.target,!1);if(!t.isInActionMode()){var o=i.getCellInfo(e.target)||{};if(f._isKeyCombination(e,null,c.SHIFT))if(e.preventDefault(),o.type===u.ROWHEADER||o.type===u.DATACELL||o.type===u.ROWACTION){if(!this._oRangeSelection)return void r(e);var n=i.getRowIndexOfFocusedCell(this),s=this.getRows()[n].getIndex();if(0===s)return void r(e);if(i.isFirstScrollableRow(this,e.target)){var l=this._getScrollExtension().scroll(!1,!1,!0);l&&r(e)}this._oRangeSelection.startIndex>=s?(s--,this._oRangeSelection.selected?i.toggleRowSelection(this,s,!0):i.toggleRowSelection(this,s,!1)):i.toggleRowSelection(this,s,!1)}else r(e);f._isKeyCombination(e,null,c.ALT)&&(o.type===u.DATACELL&&t.setActionMode(!0),r(e))}},f.prototype.onsapleft=function(e){if(!this._getKeyboardExtension().isInActionMode()){var t=sap.ui.getCore().getConfiguration().getRTL();if((i.getCellInfo(e.target)||{}).type===u.COLUMNHEADER&&t){var o=i.getFocusedItemInfo(this),n=o.cellInRow-(i.hasRowHeader(this)?1:0),s=i.getVisibleColumnCount(this);i.hasRowActions(this)&&n===s-1&&r(e)}}},f.prototype.onsapleftmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()){var t=i.getCellInfo(e.target)||{},o=sap.ui.getCore().getConfiguration().getRTL();if(f._isKeyCombination(e,null,c.SHIFT)){if(e.preventDefault(),t.type===u.DATACELL){if(!this._oRangeSelection)return void r(e);var n=i.getFocusedItemInfo(this),s=i.hasRowHeader(this)&&1===n.cellInRow;s&&!i.isRowSelectorSelectionAllowed(this)&&r(e)}else if(t.type===u.ROWACTION)this._oRangeSelection||r(e);else if(t.type===u.ROWHEADER&&o)i.isRowSelectionAllowed(this)||r(e);else if(t.type===u.COLUMNROWHEADER&&o)r(e);else if(t.type===u.COLUMNHEADER){var l=-this._CSSSizeToPixel(\"1em\");o&&(l*=-1);for(var a=i.getColumnHeaderCellInfo(e.target),g=0,p=a.index;p<a.index+a.span;p++)g+=i.Column.getColumnWidth(this,p);i.Column.resizeColumn(this,a.index,g+l,!0,a.span),r(e)}}else if(f._isKeyCombination(e,null,c.CTRL)&&t.type===u.COLUMNHEADER){e.preventDefault(),e.stopImmediatePropagation();var C=i.getColumnHeaderCellInfo(e.target).index,d=this.getColumns()[C];f._moveColumn(d,o)}}},f.prototype.onsaprightmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()){var t=i.getCellInfo(e.target)||{},o=sap.ui.getCore().getConfiguration().getRTL();if(f._isKeyCombination(e,null,c.SHIFT))if(e.preventDefault(),t.type===u.DATACELL)this._oRangeSelection||r(e);else if(t.type===u.ROWHEADER)i.isRowSelectionAllowed(this)||r(e);else if(t.type===u.ROWACTION&&o)this._oRangeSelection||r(e);else if(t.type===u.COLUMNHEADER){var n=this._CSSSizeToPixel(\"1em\");o&&(n*=-1);for(var s=i.getColumnHeaderCellInfo(e.target),l=0,a=s.index;a<s.index+s.span;a++)l+=i.Column.getColumnWidth(this,a);i.Column.resizeColumn(this,s.index,l+n,!0,s.span),r(e)}else t.type===u.COLUMNROWHEADER&&r(e);else if(f._isKeyCombination(e,null,c.CTRL)&&t.type===u.COLUMNHEADER){e.preventDefault(),e.stopImmediatePropagation();var g=i.getColumnHeaderCellInfo(e.target).index,p=this.getColumns()[g];f._moveColumn(p,!o)}}},f.prototype.onsaphome=function(e){if(!this._getKeyboardExtension().isInActionMode()){if(i.Grouping.isInGroupingRow(e.target))return void r(e);var t=i.getCellInfo(e.target)||{};if(t.type===u.DATACELL||t.type===u.ROWACTION||t.type===u.COLUMNHEADER){var o=i.getFocusedItemInfo(this),n=o.cell,s=o.cellInRow,l=i.hasRowHeader(this),a=l?1:0;i.hasFixedColumns(this)&&s>this.getFixedColumnCount()+a?(r(e),i.focusItem(this,n-s+this.getFixedColumnCount()+a,null)):l&&s>1&&(r(e),i.focusItem(this,n-s+a,null))}}},f.prototype.onsapend=function(e){if(!this._getKeyboardExtension().isInActionMode()){if(i.Grouping.isInGroupingRow(e.target))return void r(e);var t=i.getCellInfo(e.target)||{};if(t.type===u.DATACELL||t.type===u.ROWHEADER||t.type===u.ROWACTION||t.type===u.COLUMNHEADER||t.type===u.COLUMNROWHEADER){var o=i.getFocusedItemInfo(this),n=o.cell,s=o.columnCount,l=o.cellInRow,a=i.hasRowHeader(this),g=a?1:0,c=!1;if(t.type===u.COLUMNHEADER&&i.hasFixedColumns(this)){var f=parseInt(t.cell.attr(\"colspan\")||1,10);f>1&&l+f-g===this.getFixedColumnCount()&&(c=!0)}a&&0===l?(r(e),i.focusItem(this,n+1,null)):i.hasFixedColumns(this)&&l<this.getFixedColumnCount()-1+g&&!c?(r(e),i.focusItem(this,n+this.getFixedColumnCount()-l,null)):i.hasRowActions(this)&&t.type===u.DATACELL&&l<s-2&&(r(e),i.focusItem(this,n-l+s-2,null))}}},f.prototype.onsaphomemodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()&&f._isKeyCombination(e,null,c.CTRL)){e.preventDefault();var t=i.getCellInfo(e.target)||{};if(t.type===u.DATACELL||t.type===u.ROWHEADER||t.type===u.ROWACTION||t.type===u.COLUMNHEADER){r(e);var o=i.getFocusedItemInfo(this),n=o.row;if(n>0){var s=o.cell,l=o.columnCount,a=i.getHeaderRowCount(this);n<a+this.getFixedRowCount()?t.type===u.ROWACTION?i.focusItem(this,s-l*(n-a),e):i.focusItem(this,s-l*n,e):n>=a+this.getFixedRowCount()&&n<a+i.getNonEmptyVisibleRowCount(this)-this.getFixedBottomRowCount()?(this._getScrollExtension().scrollMax(!1,!0),this.getFixedRowCount()>0||t.type===u.ROWACTION?i.focusItem(this,s-l*(n-a),e):i.focusItem(this,s-l*n,e)):(this._getScrollExtension().scrollMax(!1,!0),i.focusItem(this,s-l*(n-a-this.getFixedRowCount()),e))}}}},f.prototype.onsapendmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()&&f._isKeyCombination(e,null,c.CTRL)){e.preventDefault();var t=i.getCellInfo(e.target)||{};if(t.type===u.DATACELL||t.type===u.ROWHEADER||t.type===u.ROWACTION||t.type===u.COLUMNHEADER||t.type===u.COLUMNROWHEADER){r(e);var o=i.getFocusedItemInfo(this),n=o.row,s=i.getHeaderRowCount(this),l=i.getNonEmptyVisibleRowCount(this);if(0===this.getFixedBottomRowCount()||n<s+l-1||i.isNoDataVisible(this)&&n<s-1){var a=o.cell,g=o.columnCount;i.isNoDataVisible(this)?i.focusItem(this,a+g*(s-n-1),e):n<s?this.getFixedRowCount()>0?i.focusItem(this,a+g*(s+this.getFixedRowCount()-n-1),e):(this._getScrollExtension().scrollMax(!0,!0),i.focusItem(this,a+g*(s+l-this.getFixedBottomRowCount()-n-1),e)):n>=s&&n<s+this.getFixedRowCount()?(this._getScrollExtension().scrollMax(!0,!0),i.focusItem(this,a+g*(s+l-this.getFixedBottomRowCount()-n-1),e)):n>=s+this.getFixedRowCount()&&n<s+l-this.getFixedBottomRowCount()?(this._getScrollExtension().scrollMax(!0,!0),i.focusItem(this,a+g*(s+l-n-1),e)):i.focusItem(this,a+g*(s+l-n-1),e)}}}},f.prototype.onsappageup=function(e){if(!this._getKeyboardExtension().isInActionMode()){var t=i.getCellInfo(e.target)||{};if(t.type===u.DATACELL||t.type===u.ROWHEADER||t.type===u.ROWACTION||t.type===u.COLUMNHEADER){var o=i.getFocusedItemInfo(this),n=o.row,s=i.getHeaderRowCount(this);if(0===this.getFixedRowCount()&&n>=s||this.getFixedRowCount()>0&&n>s){r(e);var l=o.cell,a=o.columnCount;if(n<s+this.getFixedRowCount())i.focusItem(this,l-a*(n-s),e);else if(n===s+this.getFixedRowCount()){var g=i.getNonEmptyVisibleRowCount(this)-this.getFixedRowCount()-this.getFixedBottomRowCount(),c=this.getFirstVisibleRow();this._getScrollExtension().scroll(!1,!0,!0),c<g&&(this.getFixedRowCount()>0||t.type===u.ROWACTION?i.focusItem(this,l-a*(n-s),e):i.focusItem(this,l-a*s,e))}else n>s+this.getFixedRowCount()&&n<s+i.getNonEmptyVisibleRowCount(this)?i.focusItem(this,l-a*(n-s-this.getFixedRowCount()),e):i.focusItem(this,l-a*(n-s-i.getNonEmptyVisibleRowCount(this)+1),e)}t.type===u.ROWACTION&&n===s&&this.getFixedRowCount()>0&&r(e)}}},f.prototype.onsappagedown=function(e){if(!this._getKeyboardExtension().isInActionMode()){var t=i.getCellInfo(e.target)||{};if(t.type===u.DATACELL||t.type===u.ROWHEADER||t.type===u.COLUMNHEADER||t.type===u.ROWACTION||t.type===u.COLUMNROWHEADER){r(e);var o=i.getFocusedItemInfo(this),n=o.row,s=i.getHeaderRowCount(this),l=i.getNonEmptyVisibleRowCount(this);if(i.isNoDataVisible(this)&&n<s-1||0===this.getFixedBottomRowCount()||n<s+l-1){var a=o.cell,g=o.columnCount;if(n<s-1&&t.type!==u.COLUMNROWHEADER)i.focusItem(this,a+g*(s-n-1),e);else if(n<s)i.isNoDataVisible(this)||i.focusItem(this,a+g*(s-n),e);else if(n>=s&&n<s+l-this.getFixedBottomRowCount()-1)i.focusItem(this,a+g*(s+l-this.getFixedBottomRowCount()-n-1),e);else if(n===s+l-this.getFixedBottomRowCount()-1){var c=i.getNonEmptyVisibleRowCount(this)-this.getFixedRowCount()-this.getFixedBottomRowCount(),f=this._getRowCount()-this.getFixedBottomRowCount()-this.getFirstVisibleRow()-2*c;this._getScrollExtension().scroll(!0,!0,!0),f<c&&this.getFixedBottomRowCount()>0&&i.focusItem(this,a+g*(s+l-n-1),e)}else i.focusItem(this,a+g*(s+l-n-1),e)}}}},f.prototype.onsappageupmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()&&f._isKeyCombination(e,null,c.ALT)){var t=i.getCellInfo(e.target)||{};if(t.type===u.DATACELL||t.type===u.COLUMNHEADER){var o=i.getFocusedItemInfo(this),n=o.cell,s=o.cellInRow,l=i.hasRowHeader(this),a=l?1:0;r(e),l&&(i.Grouping.isInGroupingRow(e.target)||1===s)?i.focusItem(this,n-s,null):s-a<5?i.focusItem(this,n-s+a,null):i.focusItem(this,n-5,null)}else if(t.type===u.ROWACTION){var o=i.getFocusedItemInfo(this);i.focusItem(this,o.cell-1,null)}}},f.prototype.onsappagedownmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()&&f._isKeyCombination(e,null,c.ALT)){var t=i.getCellInfo(e.target)||{};if(t.type===u.DATACELL||t.type===u.ROWHEADER||t.type===u.COLUMNHEADER||t.type===u.COLUMNROWHEADER){var o=i.getFocusedItemInfo(this),n=o.cellInRow,s=i.hasRowHeader(this),l=s?1:0,a=i.getVisibleColumnCount(this),g=parseInt(t.cell.attr(\"colspan\")||1,10);if(r(e),n+g-l<a){var p=o.cell;s&&0===n?i.focusItem(this,p+1,null):g>5?i.focusItem(this,p+g,null):n+g-l+5>a?i.focusItem(this,p+a-n-1+l,null):i.Grouping.isInGroupingRow(e.target)||i.focusItem(this,p+5,null)}else t.type===u.DATACELL&&i.hasRowActions(this)&&n==o.columnCount-2&&i.focusItem(this,o.cell+1,null)}}},f.prototype.onsapenter=function(e){f._handleSpaceAndEnter(this,e)},f});",
		"sap/ui/table/TableKeyboardExtension.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./TableExtension\",\"sap/ui/core/delegate/ItemNavigation\",\"./TableUtils\",\"./TableKeyboardDelegate2\",\"sap/ui/Device\"],function(t,e,i,a,o,n){\"use strict\";function s(e){if(n.browser.msie){d||(t(\"head\").append('<style type=\"text/css\">/* Avoid focus outline problems in tables */\\n.sapUiTableStatic[data-sap-ui-table-focus]{}</style>'),d=!0);var i=a.getCellInfo(e)||{};i.type&&i.cell.attr(\"data-sap-ui-table-focus\",Date.now())}}var d=!1,l={_forward:function(t,e){var i=t._getItemNavigation();null==i||t._getKeyboardExtension()._isItemNavigationSuspended()||e.isMarked(\"sapUiTableSkipItemNavigation\")||a.isBusyIndicatorVisible(t)||i[\"on\"+e.type](e)},onfocusin:function(t){l._forward(this,t),s(t.target)},onsapfocusleave:function(t){l._forward(this,t)},onmousedown:function(t){l._forward(this,t)},onsapnext:function(t){l._forward(this,t)},onsapnextmodifiers:function(t){l._forward(this,t)},onsapprevious:function(t){l._forward(this,t)},onsappreviousmodifiers:function(t){l._forward(this,t)},onsappageup:function(t){l._forward(this,t)},onsappagedown:function(t){l._forward(this,t)},onsaphome:function(t){l._forward(this,t)},onsaphomemodifiers:function(t){l._forward(this,t)},onsapend:function(t){l._forward(this,t)},onsapendmodifiers:function(t){l._forward(this,t)},onsapkeyup:function(t){l._forward(this,t)}},r={onfocusin:function(t){var e=this._getKeyboardExtension();e._bIgnoreFocusIn?t.setMarked(\"sapUiTableIgnoreFocusIn\"):(e.initItemNavigation(),u.isItemNavigationInvalid(this)&&t.setMarked(\"sapUiTableInitItemNavigation\")),t.target&&t.target.id===this.getId()+\"-rsz\"&&(t.preventDefault(),t.setMarked(\"sapUiTableSkipItemNavigation\"))}},u={_initItemNavigation:function(e){var o=e.getTable();if(!a.isBusyIndicatorVisible(o)){var n,s,d,l,r,g=o.$(),p=a.getVisibleColumnCount(o),f=p,c=a.hasRowHeader(o),v=a.hasRowActions(o),m=a.hasFixedColumns(o),h=[];m&&(d=g.find(\".sapUiTableCtrlFixed.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)\"),l=g.find(\".sapUiTableCtrlFixed.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)\"),r=g.find(\".sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)\"));var b=g.find(\".sapUiTableCtrlScroll.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)\"),_=g.find(\".sapUiTableCtrlScroll.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)\"),I=g.find(\".sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)\");c&&(n=g.find(\".sapUiTableRowHdr\").get(),f++),v&&(s=g.find(\".sapUiTableRowAction\").get(),f++);for(var T=0;T<o.getVisibleRowCount();T++)c&&h.push(n[T]),m&&(h=h.concat(d.find('tr[data-sap-ui-rowindex=\"'+T+'\"]').find(\"td[tabindex]\").get())),h=h.concat(b.find('tr[data-sap-ui-rowindex=\"'+T+'\"]').find(\"td[tabindex]\").get()),m&&(h=h.concat(l.find('tr[data-sap-ui-rowindex=\"'+T+'\"]').find(\"td[tabindex]\").get())),h=h.concat(_.find('tr[data-sap-ui-rowindex=\"'+T+'\"]').find(\"td[tabindex]\").get()),m&&(h=h.concat(r.find('tr[data-sap-ui-rowindex=\"'+T+'\"]').find(\"td[tabindex]\").get())),h=h.concat(I.find('tr[data-sap-ui-rowindex=\"'+T+'\"]').find(\"td[tabindex]\").get()),v&&h.push(s[T]);if(o.getColumnHeaderVisible()){for(var C=[],y=g.find(\".sapUiTableCHT.sapUiTableCtrlFixed>tbody>tr\"),N=g.find(\".sapUiTableCHT.sapUiTableCtrlScroll>tbody>tr\"),T=0;T<a.getHeaderRowCount(o);T++)c&&C.push(o.getDomRef(\"selall\")),y.length&&(C=C.concat(t(y.get(T)).find(\".sapUiTableCol\").get())),N.length&&(C=C.concat(t(N.get(T)).find(\".sapUiTableCol\").get())),v&&C.push(g.find(\".sapUiTableRowActionHeader\").get(0));h=C.concat(h)}e._itemNavigation||(e._itemNavigation=new i,e._itemNavigation.setTableMode(!0),e._itemNavigation.attachEvent(i.Events.AfterFocus,function(t){var i=a.getFocusedItemInfo(o);i.header=a.getHeaderRowCount(o),i.domRef=null,i.row>=i.header&&(e._oLastFocusedCellInfo=i)},o)),e._itemNavigation.setColumns(f),e._itemNavigation.setRootDomRef(g.find(\".sapUiTableCnt\").get(0)),e._itemNavigation.setItemDomRefs(h),e._itemNavigation.setFocusedIndex(u.getInitialItemNavigationIndex(e)),e._itemNavigationInvalidated=!1}},getInitialItemNavigationIndex:function(t){return a.hasRowHeader(t.getTable())?1:0},isItemNavigationInvalid:function(t){return!t._itemNavigation||t._itemNavigationInvalidated}},g=e.extend(\"sap.ui.table.TableKeyboardExtension\",{_init:function(t,e,i){return this._itemNavigation=null,this._itemNavigationInvalidated=!1,this._itemNavigationSuspended=!1,this._type=e,this._delegate=new o(e),this._actionMode=!1,t.addEventDelegate(r,t),t.addEventDelegate(this._delegate,t),t.addEventDelegate(l,t),t._getItemNavigation=function(){return this._itemNavigation}.bind(this),\"KeyboardExtension\"},_debug:function(){this._ExtensionHelper=u,this._ItemNavigationDelegate=l,this._ExtensionDelegate=r},destroy:function(){var t=this.getTable();t&&(t.removeEventDelegate(r),t.removeEventDelegate(this._delegate),t.removeEventDelegate(l)),this._itemNavigation&&(this._itemNavigation.destroy(),this._itemNavigation=null),this._delegate&&(this._delegate.destroy(),this._delegate=null),e.prototype.destroy.apply(this,arguments)}});return g.prototype.initItemNavigation=function(){u.isItemNavigationInvalid(this)&&u._initItemNavigation(this)},g.prototype.invalidateItemNavigation=function(){this._itemNavigationInvalidated=!0},g.prototype.setActionMode=function(t){!0===t&&!this._actionMode&&this._delegate.enterActionMode?this._actionMode=!0===this._delegate.enterActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1)):!1===t&&this._actionMode&&this._delegate.leaveActionMode&&(this._actionMode=!1,this._delegate.leaveActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1)))},g.prototype.isInActionMode=function(){return this._actionMode},g.prototype.updateNoDataAndOverlayFocus=function(e){var i=this.getTable();i&&i.getDomRef()&&(i.getShowOverlay()?t.sap.containsOrEquals(i.getDomRef(),e)&&i.$(\"overlay\").focus():a.isNoDataVisible(i)?t.sap.containsOrEquals(i.getDomRef(\"sapUiTableCnt\"),e)&&i.$(\"noDataCnt\").focus():(t.sap.containsOrEquals(i.getDomRef(\"noDataCnt\"),e)||t.sap.containsOrEquals(i.getDomRef(\"overlay\"),e))&&a.focusItem(i,u.getInitialItemNavigationIndex(this)))},g.prototype._suspendItemNavigation=function(){this._itemNavigationSuspended=!0},g.prototype._resumeItemNavigation=function(){this._itemNavigationSuspended=!1},g.prototype._isItemNavigationSuspended=function(){return this._itemNavigationSuspended},g.prototype._getLastFocusedCellInfo=function(){var t=a.getHeaderRowCount(this.getTable());if(!this._oLastFocusedCellInfo||this._oLastFocusedCellInfo.header!=t){var e=a.getFocusedItemInfo(this.getTable()),i=u.getInitialItemNavigationIndex(this);return{cellInRow:i,row:t,header:t,cellCount:e.cellCount,columnCount:e.columnCount,cell:e.columnCount*t+i}}return this._oLastFocusedCellInfo},g.prototype._setSilentFocus=function(t){this._bIgnoreFocusIn=!0,this._setFocus(t),this._bIgnoreFocusIn=!1},g.prototype._setFocus=function(e){if(e){var i=this.getTable();if((a.getCellInfo(e)||{}).type&&i){var o=t(e);if(\"0\"!=o.attr(\"tabindex\")){var n=i._getItemNavigation();if(n&&n.aItemDomRefs)for(var s=0;s<n.aItemDomRefs.length;s++)n.aItemDomRefs[s]&&n.aItemDomRefs[s].setAttribute(\"tabindex\",\"-1\");o.attr(\"tabindex\",\"0\")}}e.focus()}},g.prototype._getTableType=function(){return this._type},g},!0);",
		"sap/ui/table/TableMenuUtils.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/Device\",\"sap/ui/unified/Menu\",\"sap/ui/unified/MenuItem\",\"sap/ui/core/Popup\"],function(e,l,n,t,o){\"use strict\";o.setInitialZIndex(10);var u={TableUtils:null,openContextMenu:function(n,t,o,i){if(null!=n&&null!=t){null==i&&(i=!0);var a=e(t),C=u.TableUtils.getCell(n,a);if(null!==C){var s,r,f=u.TableUtils.getCellInfo(C);if(f.type===u.TableUtils.CELLTYPES.COLUMNHEADER){var g=C.find(\".sapUiTableColDropDown\").length>0;s=u.TableUtils.getColumnHeaderCellInfo(C).index,l.system.desktop||g?(u.removeColumnHeaderCellMenu(n,s),r=!0,i&&(r=n.fireColumnSelect({column:n.getColumns()[s]})),r&&u.openColumnContextMenu(n,s,o,C)):u.applyColumnHeaderCellMenu(n,s)}else if(f.type===u.TableUtils.CELLTYPES.DATACELL){var d=u.TableUtils.getDataCellInfo(n,C),c=d.rowIndex;if(r=!0,s=d.columnIndex,i){var m,p=u.TableUtils.getRowColCell(n,c,s,!0),v=p.row,x=n.getBindingInfo(\"rows\");null!=x&&(m=v.getBindingContext(x.model));var M={rowIndex:v.getIndex(),columnIndex:s,columnId:p.column.getId(),cellControl:p.cell,rowBindingContext:m,cellDomRef:C[0]};r=n.fireCellContextmenu(M)}r&&u.openDataCellContextMenu(n,s,c,o)}}}},openColumnContextMenu:function(e,l,n,t){if(!(null==e||null==l||l<0)){null==n&&(n=!1);var o=e.getColumns();if(!(l>=o.length)){var i=o[l];if(i.getVisible()){for(var a=0;a<o.length;a++)o[a]!==i&&u.closeColumnContextMenu(e,a);u.closeDataCellContextMenu(e),i._openMenu(t&&t[0]||i.getDomRef(),n)}}}},closeColumnContextMenu:function(e,l){if(!(null==e||null==l||l<0)){var n=e.getColumns();if(!(l>=n.length)){n[l].getMenu().close()}}},openDataCellContextMenu:function(e,l,i,a){if(!(null==e||null==l||l<0||null==i||i<0||i>=u.TableUtils.getNonEmptyVisibleRowCount(e))){null==a&&(a=!1);var C=e.getColumns();if(!(l>=C.length)){var s=C[l];if(s.getVisible()&&e.getEnableCellFilter()&&s.isFilterableByMenu()){var r=e.getRows()[i];if(null==e._oCellContextMenu){e._oCellContextMenu=new n(e.getId()+\"-cellcontextmenu\");var f=new t({text:e._oResBundle.getText(\"TBL_FILTER\")});f._onSelect=function(e,l){var n=this.getContextByIndex(l),t=e.getFilterProperty(),o=n.getProperty(t);this.getEnableCustomFilter()?this.fireCustomFilter({column:e,value:o}):this.filter(e,o)},f.attachSelect(f._onSelect.bind(e,s,r.getIndex())),e._oCellContextMenu.addItem(f),e.addDependent(e._oCellContextMenu)}else{var g=e._oCellContextMenu.getItems()[0];g.mEventRegistry.select[0].fFunction=g._onSelect.bind(e,s,r.getIndex())}var d=r.getCells()[l],c=u.TableUtils.getParentDataCell(e,d.getDomRef());if(null!==c&&!u.TableUtils.Grouping.isInGroupingRow(c)){d=c[0];e._oCellContextMenu.bOpen&&e._oCellContextMenu.oOpenerRef!==d&&u.closeDataCellContextMenu(e);for(var m=0;m<C.length;m++)u.closeColumnContextMenu(e,m);e._oCellContextMenu.open(a,d,o.Dock.BeginTop,o.Dock.BeginBottom,d,\"none none\")}}}}},closeDataCellContextMenu:function(e){if(null!=e){var l=e._oCellContextMenu;null!=l&&l.bOpen&&l.close()}},cleanupDataCellContextMenu:function(e){e&&e._oCellContextMenu&&(e._oCellContextMenu.destroy(),e._oCellContextMenu=null)},applyColumnHeaderCellMenu:function(l,n){if(!(null==l||null==n||n<0)){var t=l.getColumns();if(!(n>=t.length)){var o=t[n];if(o.getVisible()&&(o.getResizable()||o._menuHasItems())){var i=o.$(),a=i.find(\".sapUiTableColCell\");if(!(i.find(\".sapUiTableColCellMenu\").length>0)){a.hide();var C=\"\";o._menuHasItems()&&(C=\"<div class='sapUiTableColDropDown'></div>\");var s=\"\";o.getResizable()&&(s=\"<div class='sapUiTableColResizer''></div>\");var r=e(\"<div class='sapUiTableColCellMenu'>\"+C+s+\"</div>\");i.append(r),i.on(\"focusout\",function(e,l){u.removeColumnHeaderCellMenu(e,l),this.off(\"focusout\")}.bind(i,l,n))}}}}},removeColumnHeaderCellMenu:function(e,l){if(!(null==e||null==l||l<0)){var n=e.getColumns();if(!(l>=n.length)){var t=n[l],o=t.$(),u=o.find(\".sapUiTableColCellMenu\");if(u.length>0){o.find(\".sapUiTableColCell\").show(),u.remove()}}}}};return u},!0);",
		"sap/ui/table/TablePersoController.js": "/*\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/base/ManagedObject\"],function(e,t){\"use strict\";var r=t.extend(\"sap.ui.table.TablePersoController\",{constructor:function(e,r){t.apply(this,arguments)},metadata:{properties:{autoSave:{type:\"boolean\",defaultValue:!0},persoService:{type:\"any\"},customDataKey:{type:\"string\",defaultValue:\"persoKey\"}},associations:{table:{type:\"sap.ui.table.Table\",multiple:!1}},library:\"sap.ui.table\"}});return r.prototype.init=function(){this._schemaProperty=\"_persoSchemaVersion\",this._schemaVersion=\"1.0\",this._oInitialPersoData=null,this._aTableEvents=[\"columnResize\",\"columnMove\",\"columnVisibility\",\"sort\",\"filter\",\"group\"],this._aColumnProperties=[\"visible\",\"width\",\"sorted\",\"sortOrder\",\"grouped\",\"summed\"],this._bSaveFilters=!1,this._bSaveFilters&&(this._aTableEvents.push(\"filter\"),this._aColumnProperties.push(\"filtered\"),this._aColumnProperties.push(\"filterValue\"))},r.prototype.exit=function(){var e=this._getTable();e&&this._manageTableEventHandlers(e,!1),delete this._schemaProperty,delete this._schemaVersion,delete this._oInitialPersoData,delete this._oDialog},r.prototype.setPersoService=function(t){if((t=this.validateProperty(\"persoService\",t))&&(!e.isFunction(t.getPersData)||!e.isFunction(t.setPersData)||!e.isFunction(t.delPersData)))throw new Error('Value of property \"persoService\" needs to be null/undefined or an object that has the methods \"getPersData\", \"setPersData\" and \"delPersData\".');var r=this.getPersoService();this.setProperty(\"persoService\",t,!0);var a=this.getPersoService();return a&&a!==r&&this._getTable()&&(this.getAutoSave()||!r)&&this.refresh(),this},r.prototype.setAutoSave=function(e){var t=this.getAutoSave();return this.setProperty(\"autoSave\",e,!0),this.getAutoSave()&&!t&&this.savePersonalizations(),this},r.prototype.setTable=function(e){var t=this._getTable();t&&(t._oPersoController=void 0),this.setAssociation(\"table\",e,!0);var r=this._getTable();return r&&(r._oPersoController=this),t&&this._manageTableEventHandlers(t,!1),r&&r!==t?(this._oInitialPersoData=this._getCurrentTablePersoData(!0),this._manageTableEventHandlers(r,!0),!this.getPersoService()||!this.getAutoSave()&&t||this.refresh()):r||(this._oInitialPersoData=null),this},r.prototype.setCustomDataKey=function(e){var t=this.getCustomDataKey();return this.setProperty(\"customDataKey\",e,!0),t!==this.getCustomDataKey()&&this.getAutoSave()&&this.savePersonalizations(),this},r.prototype._manageTableEventHandlers=function(e,t){for(var r=0,a=this._aTableEvents.length;r<a;r++){e[t?\"attachEvent\":\"detachEvent\"].apply(e,[this._aTableEvents[r],this._tableEventHandler,this])}},r.prototype.refresh=function(){var t=this,r=this.getPersoService();if(r)return r.getPersData().done(function(r){var a=r&&e.isArray(r.aColumns)?r:t._oInitialPersoData;t._adjustTable(a)}).fail(function(){e.sap.log.error(\"Problem reading persisted personalization data.\")});e.sap.log.error(\"The Personalization Service is not available!\");var a=e.Deferred();return a.reject(),a.promise()},r.prototype.savePersonalizations=function(){var t=this.getPersoService();if(t){var r=this._getCurrentTablePersoData();return r[this._schemaProperty]=this._schemaVersion,t.setPersData(r).fail(function(){e.sap.log.error(\"Problem persisting personalization data.\")})}e.sap.log.error(\"The Personalization Service is not available!\");var a=e.Deferred();return a.reject(),a.promise()},r.prototype._adjustTable=function(t){var r=this._getTable();if(r&&t&&e.isArray(t.aColumns)){for(var a={},o=r.getColumns(),s=0,i=o.length;s<i;s++)a[this._getColumnPersoKey(o[s])]=o[s];for(var n=t.aColumns,s=0,i=n.length;s<i;s++){var l=n[s],u=a[l.id];if(u){r.indexOfColumn(u)!==l.order&&(r.removeColumn(u),r.insertColumn(u,l.order));for(var h=u.getMetadata(),p=0,g=this._aColumnProperties.length;p<g;p++){var v=this._aColumnProperties[p];if(void 0!==l[v])try{h.hasProperty(v)&&u.getProperty(v)!=l[v]&&u.setProperty(v,l[v])}catch(t){e.sap.log.error('sap.ui.table.TablePersoController: failed to apply the value \"'+u[v]+'\" for the property + \"'+v+'\".')}}}}\"function\"==typeof r._onPersoApplied&&r._onPersoApplied()}},r.prototype._tableEventHandler=function(e){if(this.getAutoSave()&&!this._iTriggerSaveTimeout){var t=this;this._iTriggerSaveTimeout=setTimeout(function(){t.savePersonalizations(),t._iTriggerSaveTimeout=null},0)}},r.prototype._getCurrentTablePersoData=function(e){for(var t=this._getTable(),r=t.getColumns(),a={aColumns:[]},o=0,s=r.length;o<s;o++){for(var i=r[o],n=this._getColumnPersoKey(i),l={id:n,order:o},u=i.getMetadata(),h=0,p=this._aColumnProperties.length;h<p;h++){var g=this._aColumnProperties[h];u.hasProperty(g)&&(l[g]=i.getProperty(g))}e&&(l.text=i.getLabel()&&i.getLabel().getText()||n),a.aColumns.push(l)}return a},r.prototype._getTable=function(){return sap.ui.getCore().byId(this.getTable())},r.prototype._getColumnPersoKey=function(e){return this._getPersoKey(this._getTable())+\"-\"+this._getPersoKey(e)},r.prototype._getPersoKey=function(t){var r=t.data(this.getCustomDataKey());return r||(r=t.getId(),0===r.indexOf(sap.ui.getCore().getConfiguration().getUIDPrefix())&&e.sap.log.warning('Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: \"'+t.getId()+'\")')),r},r.prototype.openDialog=function(t){sap.ui.getCore().loadLibrary(\"sap.m\");var r=sap.ui.requireSync(\"sap/m/TablePersoDialog\");if(!this._oDialog){var a=this;this._oDialog=new r({persoService:this.getPersoService(),showSelectAll:!0,showResetAll:!0,grouping:!1,contentWidth:t&&t.contentWidth,contentHeight:t&&t.contentHeight||\"20rem\",initialColumnState:this._oInitialPersoData.aColumns,columnInfoCallback:function(e,t,r){return a._getCurrentTablePersoData(!0).aColumns},confirm:function(){a._adjustTable(this.retrievePersonalizations()),a.getAutoSave()&&a.savePersonalizations()}}),this._oDialog._oDialog.removeStyleClass(\"sapUiPopupWithPadding\"),e.sap.syncStyleClass(\"sapUiSizeCompact\",this._getTable(),this._oDialog._oDialog)}this._oDialog.open()},r});",
		"sap/ui/table/TablePointerExtension.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"./library\",\"jquery.sap.global\",\"./TableExtension\",\"./TableUtils\",\"sap/ui/Device\",\"sap/ui/core/Popup\",\"jquery.sap.dom\"],function(e,t,i,o,n,l,s){\"use strict\";var a=e.SelectionMode,r=[\"sapMBtnBase\",\"sapMInputBase\",\"sapMLnk\",\"sapMSlt\",\"sapMCb\",\"sapMRI\",\"sapMSegBBtn\",\"sapUiIconPointer\"],d={_getEventPosition:function(e,t){var i;return i=function(i){if(!t._isTouchEvent(i))return null;for(var o=[\"touches\",\"targetTouches\",\"changedTouches\"],n=0;n<o.length;n++){var l=o[n];if(e[l]&&e[l][0])return e[l][0];if(e.originalEvent[l]&&e.originalEvent[l][0])return e.originalEvent[l][0]}return null}(e)||e,{x:i.pageX,y:i.pageY}},_skipClick:function(e,i,n){if(n.type!=o.CELLTYPES.DATACELL&&n.type!=o.CELLTYPES.ROWACTION)return!1;if(e.isMarked())return!0;var l=i.control(0);if(l){var s=l.$();if(s.length)for(var a=0;a<r.length;a++)if(s.hasClass(r[a]))return\"function\"!=typeof l.getEnabled||l.getEnabled()}var d=!1;if(window.getSelection){var u=window.getSelection();d=!!u.rangeCount&&!u.getRangeAt(0).collapsed}return!!d&&(t.sap.log.debug(\"DOM Selection detected -> Click event on table skipped, Target: \"+e.target),!0)},_handleClickSelection:function(e,t,i){o.toggleRowSelection(i,t,null,function(t){n.browser.internet_explorer&&e.shiftKey&&i._clearTextSelection();var o=i.getSelectionMode();if(o===a.Single)i.isIndexSelected(t)?i.clearSelection():i.setSelectedIndex(t);else{var l=!(!e.metaKey&&!e.ctrlKey);if(o===a.MultiToggle&&(l=!0),e.shiftKey){var s=i.getSelectedIndex();s>=0?i.addSelectionInterval(s,t):i.setSelectedIndex(t)}else i.isIndexSelected(t)?l?i.removeSelectionInterval(t,t):1===i._getSelectedIndicesCount()?i.clearSelection():i.setSelectedIndex(t):l?i.addSelectionInterval(t,t):i.setSelectedIndex(t)}return!0})}},u={initColumnResizing:function(e,i){if(!e._bIsColumnResizerMoving){e._bIsColumnResizerMoving=!0,e.$().toggleClass(\"sapUiTableResizing\",!0);var o=t(document),n=e._isTouchEvent(i);e._$colResize=e.$(\"rsz\"),e._iColumnResizeStart=d._getEventPosition(i,e).x,o.bind((n?\"touchend\":\"mouseup\")+\".sapUiTableColumnResize\",u.exitColumnResizing.bind(e)),o.bind((n?\"touchmove\":\"mousemove\")+\".sapUiTableColumnResize\",u.onMouseMoveWhileColumnResizing.bind(e)),e._disableTextSelection()}},exitColumnResizing:function(e){u._resizeColumn(this,this._iLastHoveredColumnIndex)},onMouseMoveWhileColumnResizing:function(e){var t=d._getEventPosition(e,this).x;if(!(this._iColumnResizeStart&&t<this._iColumnResizeStart+3&&t>this._iColumnResizeStart-3)){this._isTouchEvent(e)&&(e.stopPropagation(),e.preventDefault()),this._$colResize.toggleClass(\"sapUiTableColRszActive\",!0);var i=this._getVisibleColumns()[this._iLastHoveredColumnIndex],n=t-this._iColumnResizeStart,l=this.$().find('th[data-sap-ui-colid=\"'+i.getId()+'\"]').width(),s=Math.max(l+n*(this._bRtlMode?-1:1),o.Column.getMinColumnWidth()),a=this.$().find(\".sapUiTableCnt\").offset().left,r=Math.floor(t-a-this._$colResize.width()/2);this._$colResize.css(\"left\",r+\"px\"),i._iNewWidth=s}},_cleanupColumResizing:function(e){e._$colResize&&(e._$colResize.toggleClass(\"sapUiTableColRszActive\",!1),e._$colResize=null),e._iColumnResizeStart=null,e._bIsColumnResizerMoving=!1,e.$().toggleClass(\"sapUiTableResizing\",!1),e._enableTextSelection();var i=t(document);i.unbind(\"touchmove.sapUiTableColumnResize\"),i.unbind(\"touchend.sapUiTableColumnResize\"),i.unbind(\"mousemove.sapUiTableColumnResize\"),i.unbind(\"mouseup.sapUiTableColumnResize\")},_resizeColumn:function(e,t){var i,n=e._getVisibleColumns(),l=!1;t>=0&&t<n.length&&(i=n[t],i._iNewWidth&&(o.Column.resizeColumn(e,e.indexOfColumn(i),i._iNewWidth),delete i._iNewWidth,l=!0)),u._cleanupColumResizing(e),i.focus(),l&&e.invalidate()},doAutoResizeColumn:function(e,t){var i,o=e._getVisibleColumns();if(t>=0&&t<o.length){if(i=o[t],!i.getAutoResizable()||!i.getResizable())return;var n=u._calculateAutomaticColumnWidth.apply(e,[i,t]);n&&(i._iNewWidth=n,u._resizeColumn(e,t))}},_calculateAutomaticColumnWidth:function(e,i){e=e||this.getColumns()[i];var n=this.$(),l=t(\"<div>\").addClass(\"sapUiTableHiddenSizeDetector\");n.append(l);var s=n.find('td[data-sap-ui-colid = \"'+e.getId()+'\"]:not([colspan])').filter(function(e,t){return\"none\"!=t.style.display}).children().clone();s.find(\"[id]\").removeAttr(\"id\");var a=l.append(s).width()+4;return a=Math.min(a,n.find(\".sapUiTableCnt\").width()),a=Math.max(a+4,o.Column.getMinColumnWidth()),l.remove(),a},initColumnTracking:function(e){e.$().find(\".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed\").mousemove(function(e){var t=this.getDomRef();if(t&&!this._bIsColumnResizerMoving){for(var i=e.clientX,o=t.getBoundingClientRect(),n=0,l=this._bRtlMode?1e4:-1e4,s=0;s<this._aTableHeaders.length;s++){var a=this._aTableHeaders[s].getBoundingClientRect();if(this._bRtlMode){if(i<a.right-5&&i>=a.left){n=s,l=a.left-o.left;break}}else if(i>a.left+5&&i<=a.right){n=s,l=a.right-o.left;break}}var r=this._getVisibleColumns()[n];r&&r.getResizable()&&(this.$(\"rsz\").css(\"left\",l+\"px\"),this._iLastHoveredColumnIndex=n)}}.bind(e))}},h={initInteractiveResizing:function(e,i){var o=t(document.body),n=e.$(\"sb\"),l=t(document),s=n.offset(),a=n.height(),r=n.width(),d=e._isTouchEvent(i);o.bind(\"selectstart\",h.onSelectStartWhileInteractiveResizing),o.append('<div id=\"'+e.getId()+'-ghost\" class=\"sapUiTableInteractiveResizerGhost\" style =\" height:'+a+\"px; width:\"+r+\"px; left:\"+s.left+\"px; top:\"+s.top+'px\" ></div>'),n.append('<div id=\"'+e.getId()+'-rzoverlay\" style =\"left: 0px; right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>'),l.bind((d?\"touchend\":\"mouseup\")+\".sapUiTableInteractiveResize\",h.exitInteractiveResizing.bind(e)),l.bind((d?\"touchmove\":\"mousemove\")+\".sapUiTableInteractiveResize\",h.onMouseMoveWhileInteractiveResizing.bind(e)),e._disableTextSelection()},exitInteractiveResizing:function(e){var i=t(document.body),n=t(document),l=this.$(),s=this.$(\"ghost\"),a=d._getEventPosition(e,this).y,r=a-l.find(\".sapUiTableCCnt\").offset().top-s.height()-l.find(\".sapUiTableFtr\").height();this._setRowContentHeight(r),this._updateRows(this._calculateRowsToDisplay(r),o.RowsUpdateReason.Resize),s.remove(),this.$(\"rzoverlay\").remove(),i.unbind(\"selectstart\",h.onSelectStartWhileInteractiveResizing),n.unbind(\"touchend.sapUiTableInteractiveResize\"),n.unbind(\"touchmove.sapUiTableInteractiveResize\"),n.unbind(\"mouseup.sapUiTableInteractiveResize\"),n.unbind(\"mousemove.sapUiTableInteractiveResize\"),this._enableTextSelection()},onSelectStartWhileInteractiveResizing:function(e){return e.preventDefault(),e.stopPropagation(),!1},onMouseMoveWhileInteractiveResizing:function(e){var t=d._getEventPosition(e,this).y;t>this.$().offset().top&&this.$(\"ghost\").css(\"top\",t+\"px\")}},c={initReordering:function(e,i,n){var s=e.getColumns()[i],a=s.$(),r=e.$();e._disableTextSelection(),r.addClass(\"sapUiTableDragDrop\");var d=a.clone();d.find(\"*\").addBack(d).removeAttr(\"id\").removeAttr(\"data-sap-ui\").removeAttr(\"tabindex\"),d.attr(\"id\",e.getId()+\"-roghost\").addClass(\"sapUiTableColReorderGhost\").css({left:-1e4,top:-1e4,\"z-index\":l.getNextZIndex()}),d.toggleClass(o.getContentDensity(e),!0),d.appendTo(document.body),e._$ReorderGhost=e.getDomRef(\"roghost\"),r.find(\"td[data-sap-ui-colid='\"+s.getId()+\"']\").toggleClass(\"sapUiTableColReorderFade\",!0),t(\"<div id='\"+e.getId()+\"-roind' class='sapUiTableColReorderIndicator'><div class='sapUiTableColReorderIndicatorArrow'></div><div class='sapUiTableColReorderIndicatorInner'></div></div>\").appendTo(e.getDomRef(\"sapUiTableCnt\")),e._$ReorderIndicator=e.getDomRef(\"roind\"),e._iDnDColIndex=i;var u=t(document),h=e._isTouchEvent(n);u.bind((h?\"touchend\":\"mouseup\")+\".sapUiColumnMove\",c.exitReordering.bind(e)),u.bind((h?\"touchmove\":\"mousemove\")+\".sapUiColumnMove\",c.onMouseMoveWhileReordering.bind(e))},onMouseMoveWhileReordering:function(e){var i=d._getEventPosition(e,this),n=i.x,l=i.y,s=this._iNewColPos;this._iNewColPos=this._iDnDColIndex,e.preventDefault();var a=c.findColumnForPosition(this,n);if(!a||!a.id)return void(this._iNewColPos=s);var r=this.getDomRef(\"sapUiTableCtrlScr\"),u=t(r),h=r.getBoundingClientRect(),g=u.outerWidth(),p=this._bRtlMode?u.scrollLeftRTL():u.scrollLeft();this._bReorderScroll=!1,n>h.left+g-40&&p+g<r.scrollWidth?(this._bReorderScroll=!0,c.doScroll(this,!this._bRtlMode),c.adaptReorderMarkerPosition(this,a,!1)):n<h.left+40&&p>0&&(this._bReorderScroll=!0,c.doScroll(this,this._bRtlMode),c.adaptReorderMarkerPosition(this,a,!1)),t(this._$ReorderGhost).css({left:n+5,top:l+5}),!this._bReorderScroll&&a&&(a.before||a.after&&a.index==this._iDnDColIndex?this._iNewColPos=a.index:a.after&&a.index!=this._iDnDColIndex&&(this._iNewColPos=a.index+1),o.Column.isColumnMovableTo(this.getColumns()[this._iDnDColIndex],this._iNewColPos)?c.adaptReorderMarkerPosition(this,a,!0):this._iNewColPos=s)},exitReordering:function(e){var i=this._iDnDColIndex,n=this._iNewColPos,l=t(document);l.unbind(\"touchmove.sapUiColumnMove\"),l.unbind(\"touchend.sapUiColumnMove\"),l.unbind(\"mousemove.sapUiColumnMove\"),l.unbind(\"mouseup.sapUiColumnMove\"),this._bReorderScroll=!1,this.$().removeClass(\"sapUiTableDragDrop\"),delete this._iDnDColIndex,delete this._iNewColPos,t(this._$ReorderGhost).remove(),delete this._$ReorderGhost,t(this._$ReorderIndicator).remove(),delete this._$ReorderIndicator,this.$().find(\".sapUiTableColReorderFade\").removeClass(\"sapUiTableColReorderFade\"),this._enableTextSelection(),o.Column.moveColumnTo(this.getColumns()[i],n),this._mTimeouts.reApplyFocusTimerId&&window.clearTimeout(this._mTimeouts.reApplyFocusTimerId);var s=this;this._mTimeouts.reApplyFocusTimerId=window.setTimeout(function(){var t=o.getFocusedItemInfo(s).cell;o.focusItem(s,0,e),o.focusItem(s,t,e)},0),this.updateAnalyticalInfo&&this.updateAnalyticalInfo(!0,!0)},findColumnForPosition:function(e,i){for(var o,n,l,s,a,r,d,u=0;u<e._aTableHeaders.length;u++)if(o=e._aTableHeaders[u],n=t(o),l=o.getBoundingClientRect(),s=n.outerWidth(),a={left:l.left,center:l.left+s/2,right:l.left+s,width:s,index:parseInt(n.attr(\"data-sap-ui-headcolindex\"),10),id:n.attr(\"data-sap-ui-colid\")},r=i>=a.left&&i<=a.center,d=i>=a.center&&i<=a.right,r||d)return a.before=e._bRtlMode?d:r,a.after=e._bRtlMode?r:d,a;return null},doScroll:function(e,i){if(e._mTimeouts.horizontalReorderScrollTimerId&&(window.clearTimeout(e._mTimeouts.horizontalReorderScrollTimerId),e._mTimeouts.horizontalReorderScrollTimerId=null),e._bReorderScroll){var o=i?30:-30;e._bRtlMode&&(o*=-1),e._mTimeouts.horizontalReorderScrollTimerId=t.sap.delayedCall(60,e,c.doScroll,[e,i]);var n=e.$(\"sapUiTableCtrlScr\"),l=e._bRtlMode?\"scrollLeftRTL\":\"scrollLeft\";n[l](n[l]()+o)}},adaptReorderMarkerPosition:function(e,i,o){if(i&&e._$ReorderIndicator){var n=i.left-e.getDomRef().getBoundingClientRect().left;(e._bRtlMode&&i.before||!e._bRtlMode&&i.after)&&(n+=i.width),t(e._$ReorderIndicator).css({left:n+\"px\"}).toggleClass(\"sapUiTableColReorderIndicatorActive\",o)}}},g={ROWAREAS:[\".sapUiTableRowHdr\",\".sapUiTableRowAction\",\".sapUiTableCtrlFixed > tbody > .sapUiTableTr\",\".sapUiTableCtrlScroll > tbody > .sapUiTableTr\"],initRowHovering:function(e){for(var t=e.$(),i=0;i<g.ROWAREAS.length;i++)g._initRowHoveringForArea(t,g.ROWAREAS[i])},_initRowHoveringForArea:function(e,t){e.find(t).hover(function(){g._onHover(this,e,t)},function(){g._onUnhover(this,e)})},_onHover:function(e,t,i){for(var o=t.find(i).index(e),n=0;n<g.ROWAREAS.length;n++)t.find(g.ROWAREAS[n]).filter(\":eq(\"+o+\")\").addClass(\"sapUiTableRowHvr\")},_onUnhover:function(e,t){for(var i=0;i<g.ROWAREAS.length;i++)t.find(g.ROWAREAS[i]).removeClass(\"sapUiTableRowHvr\")}},p={onmousedown:function(e){var i=this._getPointerExtension(),l=o.getCell(this,e.target),s=o.getCellInfo(l)||{},a=t(e.target);if(this._getKeyboardExtension().initItemNavigation(),0===e.button){if(e.target===this.getDomRef(\"sb\"))h.initInteractiveResizing(this,e);else if(e.target===this.getDomRef(\"rsz\"))u.initColumnResizing(this,e);else if(a.hasClass(\"sapUiTableColResizer\")){var r=a.closest(\".sapUiTableCol\").attr(\"data-sap-ui-colindex\");this._iLastHoveredColumnIndex=parseInt(r,10),u.initColumnResizing(this,e)}else if(s.type===o.CELLTYPES.COLUMNHEADER){var c=o.getColumnHeaderCellInfo(l).index,g=this.getColumns()[c],p=g.getAggregation(\"menu\"),f=p&&p.bOpen;f||(i._bShowMenu=!0,this._mTimeouts.delayedMenuTimerId=t.sap.delayedCall(200,this,function(){delete i._bShowMenu})),!this.getEnableColumnReordering()||this._isTouchEvent(e)&&a.hasClass(\"sapUiTableColDropDown\")||this._getPointerExtension().doReorderColumn(c,e)}(n.browser.firefox&&(e.metaKey||e.ctrlKey)||1===a.closest(\".sapUiTableHSb\",this.getDomRef()).length||1===a.closest(\".sapUiTableVSb\",this.getDomRef()).length)&&e.preventDefault()}if(2===e.button){if(d._skipClick(e,a,s))return void(i._bShowDefaultMenu=!0);if(s.type===o.CELLTYPES.COLUMNHEADER){var C=o.getColumnHeaderCellInfo(l),g=this.getColumns()[C.index],p=g.getAggregation(\"menu\"),f=p&&p.bOpen;f?i._bHideMenu=!0:i._bShowMenu=!0}else if(s.type===o.CELLTYPES.DATACELL){var f=this._oCellContextMenu&&this._oCellContextMenu.bOpen,m=f&&this._oCellContextMenu.oOpenerRef!==l[0];!f||m?i._bShowMenu=!0:i._bHideMenu=!0}else i._bShowDefaultMenu=!0}},onmouseup:function(e){t.sap.clearDelayedCall(this._mTimeouts.delayedColumnReorderTimerId)},ondblclick:function(e){n.system.desktop&&e.target===this.getDomRef(\"rsz\")&&(e.preventDefault(),u.doAutoResizeColumn(this,this._iLastHoveredColumnIndex))},onclick:function(e){if(t.sap.clearDelayedCall(this._mTimeouts.delayedColumnReorderTimerId),!e.isMarked()){var i=t(e.target);if(i.hasClass(\"sapUiAnalyticalTableSum\"))return void e.preventDefault();if(i.hasClass(\"sapUiTableGroupMenuButton\"))return this._onContextMenu(e),void e.preventDefault();if(!i.hasClass(\"sapUiTableGroupIcon\")&&!i.hasClass(\"sapUiTableTreeIcon\")||!o.Grouping.toggleGroupHeaderByRef(this,e.target)){var n=o.getCell(this,e.target),l=o.getCellInfo(n)||{};if(l.type===o.CELLTYPES.COLUMNHEADER){var s=this._getPointerExtension();s._bShowMenu&&(o.Menu.openContextMenu(this,e.target,!1),delete s._bShowMenu)}else{if(d._skipClick(e,i,l))return;this._findAndfireCellEvent(this.fireCellClick,e)?e.preventDefault():l.type===o.CELLTYPES.COLUMNROWHEADER?this._toggleSelectAll():d._handleClickSelection(e,n,this)}}}},oncontextmenu:function(e){var t=this._getPointerExtension();t._bShowDefaultMenu?(e.setMarked(\"handledByPointerExtension\"),delete t._bShowDefaultMenu):t._bShowMenu?(e.setMarked(\"handledByPointerExtension\"),e.preventDefault(),o.Menu.openContextMenu(this,e.target,!1),delete t._bShowMenu):t._bHideMenu&&(e.setMarked(\"handledByPointerExtension\"),e.preventDefault(),delete t._bHideMenu)}};return i.extend(\"sap.ui.table.TablePointerExtension\",{_init:function(e,t,o){return this._type=t,this._delegate=p,e.addEventDelegate(this._delegate,e),e._iLastHoveredColumnIndex=0,e._bIsColumnResizerMoving=!1,e._iFirstReorderableIndex=t==i.TABLETYPES.TREE?1:0,\"PointerExtension\"},_attachEvents:function(){var e=this.getTable();e&&(u.initColumnTracking(e),g.initRowHovering(e))},_detachEvents:function(){var e=this.getTable();if(e){var t=e.$();t.find(\".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed\").unbind(),t.find(\".sapUiTableCtrl > tbody > tr\").unbind(),t.find(\".sapUiTableRowHdr\").unbind()}},_debug:function(){this._ExtensionHelper=d,this._ColumnResizeHelper=u,this._InteractiveResizeHelper=h,this._ReorderHelper=c,this._ExtensionDelegate=p,this._RowHoverHandler=g,this._KNOWNCLICKABLECONTROLS=r},doAutoResizeColumn:function(e){var t=this.getTable();t&&u.doAutoResizeColumn(t,e)},doReorderColumn:function(e,i){var n=this.getTable();n&&o.Column.isColumnMovable(n.getColumns()[e])&&(n._mTimeouts.delayedColumnReorderTimerId=t.sap.delayedCall(200,n,function(){c.initReordering(this,e,i)}))},destroy:function(){var e=this.getTable();e&&e.removeEventDelegate(this._delegate),this._delegate=null,i.prototype.destroy.apply(this,arguments)}})},!0);",
		"sap/ui/table/TableRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/core/theming/Parameters\",\"sap/ui/Device\",\"./library\",\"./TableUtils\",\"sap/ui/core/Renderer\",\"sap/ui/core/IconPool\"],function(e,t,i,r,a,d,s,l){\"use strict\";var n=a.SelectionMode,o=a.VisibleRowCountMode,w={};return w.render=function(e,t){delete t._iHeaderRowCount,e.write(\"<div\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"ROOT\"),e.writeControlData(t),e.addClass(\"sapUiTable\"),\"ontouchstart\"in document&&e.addClass(\"sapUiTableTouch\"),e.addClass(\"sapUiTableSelMode\"+t.getSelectionMode()),t.getColumnHeaderVisible()&&e.addClass(\"sapUiTableCHdr\"),d.hasRowHeader(t)&&e.addClass(\"sapUiTableRowSelectors\"),d.hasRowHighlights(t)&&e.addClass(\"sapUiTableRowHighlights\");var i=a.TableHelper.addTableClass();if(i&&e.addClass(i),t._isVSbRequired()&&e.addClass(\"sapUiTableVScr\"),t.getEditable()&&e.addClass(\"sapUiTableEdt\"),d.hasRowActions(t)){var r=d.getRowActionCount(t);e.addClass(1==r?\"sapUiTableRActS\":\"sapUiTableRAct\")}d.isNoDataVisible(t)&&!d.hasPendingRequest(t)&&e.addClass(\"sapUiTableEmpty\"),t.getShowOverlay()&&e.addClass(\"sapUiTableOverlay\");var s=d.Grouping.getModeCssClass(t);s&&e.addClass(s),t.getWidth()&&e.addStyle(\"width\",t.getWidth()),t.getVisibleRowCountMode()==o.Auto&&(e.addStyle(\"height\",\"0px\"),t._bFirstRendering&&e.addClass(\"sapUiTableNoOpacity\")),e.writeClasses(),e.writeStyles(),e.write(\">\"),this.renderTabElement(e,\"sapUiTableOuterBefore\"),t.getTitle()&&this.renderHeader(e,t,t.getTitle()),t.getToolbar()&&this.renderToolbar(e,t,t.getToolbar()),t.getExtension()&&t.getExtension().length>0&&this.renderExtensions(e,t,t.getExtension()),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-sapUiTableCnt\"),e.addClass(\"sapUiTableCnt\"),e.writeClasses(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"CONTENT\"),e.writeAttribute(\"data-sap-ui-fastnavgroup\",\"true\"),e.write(\">\"),this.renderColRsz(e,t),this.renderColHdr(e,t),this.renderTable(e,t),t._getAccRenderExtension().writeHiddenAccTexts(e,t),e.write(\"<div\"),e.addClass(\"sapUiTableOverlayArea\"),e.writeClasses(),e.writeAttribute(\"tabindex\",\"0\"),e.writeAttribute(\"id\",t.getId()+\"-overlay\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"OVERLAY\"),e.write(\"></div>\"),e.write(\"</div>\"),t.getFooter()&&this.renderFooter(e,t,t.getFooter()),t.getVisibleRowCountMode()==o.Interactive&&this.renderVariableHeight(e,t),this.renderTabElement(e,\"sapUiTableOuterAfter\"),e.write(\"</div>\")},w.renderHeader=function(e,t,i){e.write(\"<div\"),e.addClass(\"sapUiTableHdr\"),e.writeClasses(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TABLEHEADER\"),e.write(\">\"),e.renderControl(i),e.write(\"</div>\")},w.renderToolbar=function(e,t,r){e.write(\"<div\"),e.addClass(\"sapUiTableTbr\"),\"function\"!=typeof r.getStandalone&&e.addClass(\"sapUiTableMTbr\"),e.writeClasses(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TABLESUBHEADER\"),e.write(\">\"),\"function\"==typeof r.getStandalone&&r.getStandalone()&&r.setStandalone(!1),d.isInstanceOf(r,\"sap/m/Toolbar\")&&r.setDesign(i.get(\"_sap_ui_table_Table_ToolbarDesign\"),!0),e.renderControl(r),e.write(\"</div>\")},w.renderExtensions=function(e,t,i){for(var r=0,a=i.length;r<a;r++)this.renderExtension(e,t,i[r])},w.renderExtension=function(e,t,i){e.write(\"<div\"),e.addClass(\"sapUiTableExt\"),e.writeClasses(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TABLESUBHEADER\"),e.write(\">\"),e.renderControl(i),e.write(\"</div>\")},w.renderTable=function(e,t){e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-tableCCnt\"),e.addClass(\"sapUiTableCCnt\"),e.writeClasses(),e.write(\">\"),this.renderTableCCnt(e,t),e.write(\"</div>\"),this.renderVSb(e,t),this.renderHSb(e,t)},w.renderTableCCnt=function(e,i){this.renderTabElement(e,\"sapUiTableCtrlBefore\"),this.renderTableCtrl(e,i),this.renderRowHdr(e,i),this.renderRowActions(e,i),this.renderTabElement(e,\"sapUiTableCtrlAfter\"),e.write(\"<div\"),e.addClass(\"sapUiTableCtrlEmpty\"),e.writeClasses(),e.writeAttribute(\"tabindex\",\"0\"),e.writeAttribute(\"id\",i.getId()+\"-noDataCnt\"),i._getAccRenderExtension().writeAriaAttributesFor(e,i,\"NODATA\"),e.write(\">\"),i.getNoData()instanceof t?e.renderControl(i.getNoData()):(e.write(\"<span\"),e.writeAttribute(\"id\",i.getId()+\"-noDataMsg\"),e.addClass(\"sapUiTableCtrlEmptyMsg\"),e.writeClasses(),e.write(\">\"),e.writeEscaped(d.getNoDataText(i)),e.write(\"</span>\")),e.write(\"</div>\")},w.renderFooter=function(e,t,i){e.write(\"<div\"),e.addClass(\"sapUiTableFtr\"),e.writeClasses(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TABLEFOOTER\"),e.write(\">\"),e.renderControl(i),e.write(\"</div>\")},w.renderVariableHeight=function(e,t){e.write('<div id=\"'+t.getId()+'-sb\" tabIndex=\"-1\"'),e.addClass(\"sapUiTableHeightResizer\"),e.addStyle(\"height\",\"5px\"),e.writeClasses(),e.writeStyles(),e.write(\">\"),e.write(\"</div>\")},w.renderColHdr=function(e,t){var i=d.getHeaderRowCount(t),r=t.getColumns(),a=t.getFixedColumnCount();e.write(\"<div\"),e.addClass(\"sapUiTableColHdrCnt\"),e.writeClasses(),t.getColumnHeaderHeight()>0&&e.addStyle(\"height\",t.getColumnHeaderHeight()*i+\"px\"),e.writeStyles(),e.write(\">\"),this.renderColRowHdr(e,t),a>0&&(e.write(\"<div\"),e.addClass(\"sapUiTableCHA\"),e.addClass(\"sapUiTableCtrlScrFixed\"),e.addClass(\"sapUiTableNoOpacity\"),e.writeClasses(),e.write(\">\"),this.renderTableControlCnt(e,t,!0,0,a,!0,!1,0,i,!0),e.write(\"</div>\")),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-sapUiTableColHdrScr\"),e.addClass(\"sapUiTableCHA\"),e.addClass(\"sapUiTableCtrlScr\"),0==r.length&&e.addClass(\"sapUiTableHasNoColumns\"),e.writeClasses(),a>0&&(t._bRtlMode?e.addStyle(\"margin-right\",\"0\"):e.addStyle(\"margin-left\",\"0\"),e.writeStyles()),e.write(\">\"),this.renderTableControlCnt(e,t,!1,a,r.length,!1,!1,0,i,!0),e.write(\"</div>\"),d.hasRowActions(t)&&(e.write(\"<div class='sapUiTableRowActionHeader' id='\"+t.getId()+\"-rowacthdr'\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"ROWACTIONHEADER\"),e.write(\"><span>\"),e.writeEscaped(t._oResBundle.getText(\"TBL_ROW_ACTION_COLUMN_LABEL\")),e.write(\"</span></div>\")),e.write(\"</div>\")},w.renderColRowHdr=function(e,t){var i=!1,r=!1;if(e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-selall\"),d.hasSelectAll(t)){var a=d.areAllRowsSelected(t);if(t._getShowStandardTooltips()){var s=a?\"TBL_DESELECT_ALL\":\"TBL_SELECT_ALL\";e.writeAttributeEscaped(\"title\",t._oResBundle.getText(s))}a?r=!0:e.addClass(\"sapUiTableSelAll\"),e.addClass(\"sapUiTableSelAllEnabled\"),i=!0}else e.addClass(\"sapUiTableSelAllDisabled\");e.addClass(\"sapUiTableColRowHdr\"),e.writeClasses(),e.writeAttribute(\"tabindex\",\"-1\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"COLUMNROWHEADER\",{enabled:i,checked:r}),e.write(\">\"),t.getSelectionMode()!==n.Single&&(e.write(\"<div\"),e.addClass(\"sapUiTableColRowHdrIco\"),e.writeClasses(),t.getColumnHeaderHeight()>0&&e.addStyle(\"height\",t.getColumnHeaderHeight()+\"px\"),e.write(\">\"),e.write(\"</div>\")),e.write(\"</div>\")},w.renderCol=function(e,t,i,r,a,d){var l,n=!a,o=i.getIndex(),w=i.getMultiLabels();w.length>0?l=w[r]:0==r&&(l=i.getLabel()),e.write(\"<td\");var C=i.getId();0===r?e.writeElementData(i):(C=C+\"_\"+r,e.writeAttribute(\"id\",C)),e.writeAttribute(\"data-sap-ui-colid\",i.getId()),e.writeAttribute(\"data-sap-ui-colindex\",o),e.writeAttribute(\"tabindex\",\"-1\"),a>1&&e.writeAttribute(\"colspan\",a),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"COLUMNHEADER\",{column:i,headerId:C,index:o}),e.addClass(\"sapUiTableCol\"),d&&e.addClass(\"sapUiTableColLastFixed\"),e.writeClasses(),t.getColumnHeaderHeight()>0&&e.addStyle(\"height\",t.getColumnHeaderHeight()+\"px\"),n&&e.addStyle(\"display\",\"none\"),e.writeStyles();var b=i.getTooltip_AsString();b&&e.writeAttributeEscaped(\"title\",b),e.write(\"><div\"),e.addClass(\"sapUiTableColCell\"),e.writeAttribute(\"id\",C+\"-inner\"),e.writeClasses();var g=s.getTextAlign(i.getHAlign(),l&&l.getTextDirection&&l.getTextDirection());g&&e.addStyle(\"text-align\",g),e.writeStyles(),e.write(\">\"),l&&e.renderControl(l),e.write(\"</div></td>\")},w.renderColRsz=function(e,t){e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-rsz\"),e.addClass(\"sapUiTableColRsz\"),e.writeClasses(),e.write(\"></div>\")},w.renderRowHdr=function(e,t){e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-sapUiTableRowHdrScr\"),e.addClass(\"sapUiTableRowHdrScr\"),e.addClass(\"sapUiTableNoOpacity\"),e.writeClasses(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"ROWHEADER_COL\"),e.write(\">\");for(var i=0,r=t.getRows().length;i<r;i++)this.renderRowAddon(e,t,t.getRows()[i],i,!0);e.write(\"</div>\")},w.renderRowActions=function(e,t){if(d.hasRowActions(t)){e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-sapUiTableRowActionScr\"),e.addClass(\"sapUiTableRowActionScr\"),e.addClass(\"sapUiTableNoOpacity\"),e.writeClasses(),e.write(\">\");for(var i=0,r=t.getRows().length;i<r;i++)this.renderRowAddon(e,t,t.getRows()[i],i,!1);e.write(\"</div>\")}},w._addFixedRowCSSClasses=function(e,t,i){var r=t.getFixedRowCount(),a=d.getFirstFixedButtomRowIndex(t);r>0&&(i<r&&e.addClass(\"sapUiTableFixedTopRow\"),i==r-1&&e.addClass(\"sapUiTableFixedLastTopRow\")),a>=0&&a===i?e.addClass(\"sapUiTableFixedFirstBottomRow\"):a>=1&&a-1===i&&e.addClass(\"sapUiTableFixedPreBottomRow\")},w.renderRowAddon=function(e,t,i,r,a){e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+(a?\"-rowsel\":\"-rowact\")+r),e.writeAttribute(\"data-sap-ui-rowindex\",r),e.addClass(a?\"sapUiTableRowHdr\":\"sapUiTableRowAction\"),this._addFixedRowCSSClasses(e,t,r);var d=!1,s=!1;if(i._bHidden?(e.addClass(\"sapUiTableRowHidden\"),s=!0):t.isIndexSelected(i.getIndex())&&(e.addClass(\"sapUiTableRowSel\"),d=!0),e.writeClasses(),t.getRowHeight()>0&&e.addStyle(\"height\",t.getRowHeight()+\"px\"),e.writeAttribute(\"tabindex\",\"-1\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,a?\"ROWHEADER\":\"ROWACTION\",{rowSelected:d,rowHidden:s}),e.writeStyles(),e.write(\">\"),a)this.writeRowHighlightContent(e,t,i,r),this.writeRowSelectorContent(e,t,i,r);else{var l=i.getAggregation(\"_rowAction\");l&&e.renderControl(l)}e.write(\"</div>\")},w.renderTableCtrl=function(e,t){t.getFixedColumnCount()>0&&(e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-sapUiTableCtrlScrFixed\"),e.addClass(\"sapUiTableCtrlScrFixed\"),e.writeClasses(),e.write(\">\"),this.renderTableControl(e,t,!0),e.write(\"</div>\")),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-sapUiTableCtrlScr\"),e.addClass(\"sapUiTableCtrlScr\"),e.writeClasses(),t.getFixedColumnCount()>0&&(t._bRtlMode?e.addStyle(\"margin-right\",\"0\"):e.addStyle(\"margin-left\",\"0\"),e.writeStyles()),e.write(\">\"),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-tableCtrlCnt\"),e.addClass(\"sapUiTableCtrlCnt\"),e.writeClasses();var i=t.getVisibleRowCountMode();if(t._iTableRowContentHeight&&(i==o.Fixed||i==o.Interactive)){var r=\"height\";t.getVisibleRowCountMode()==o.Fixed&&(r=\"min-height\"),e.addStyle(r,t._iTableRowContentHeight+\"px\"),e.writeStyles()}e.write(\">\"),this.renderTableControl(e,t,!1),e.write(\"</div></div>\")},w.renderTableControl=function(e,t,i){var r,a;i?(r=0,a=t.getFixedColumnCount()):(r=t.getFixedColumnCount(),a=t.getColumns().length);var d=t.getFixedRowCount(),s=t.getFixedBottomRowCount(),l=t.getRows();d>0&&this.renderTableControlCnt(e,t,i,r,a,!0,!1,0,d),this.renderTableControlCnt(e,t,i,r,a,!1,!1,d,l.length-s),s>0&&l.length>0&&this.renderTableControlCnt(e,t,i,r,a,!1,!0,l.length-s,l.length)},w.renderTableControlCnt=function(e,t,i,a,s,l,n,o,w,C){e.write(\"<table\");var b=C?\"-header\":\"-table\",g=t.getId()+b;i?(g+=\"-fixed\",e.addClass(\"sapUiTableCtrlFixed\")):e.addClass(\"sapUiTableCtrlScroll\"),l?(g+=\"-fixrow\",e.addClass(\"sapUiTableCtrlRowFixed\")):n?(g+=\"-fixrow-bottom\",e.addClass(\"sapUiTableCtrlRowFixedBottom\")):e.addClass(\"sapUiTableCtrlRowScroll\"),e.writeAttribute(\"id\",g),t._getAccRenderExtension().writeAriaAttributesFor(e,t,C?\"COLUMNHEADER_TABLE\":\"TABLE\"),e.addClass(\"sapUiTableCtrl\"),C&&e.addClass(\"sapUiTableCHT\"),e.writeClasses(),e.addStyle(\"min-width\",t._getColumnsWidth(a,s)+\"px\"),i&&(r.browser.firefox||r.browser.chrome||r.browser.safari)&&e.addStyle(\"width\",t._getColumnsWidth(a,s)+\"px\"),e.writeStyles(),e.write(\">\"),e.write(\"<thead>\"),e.write(\"<tr\"),e.addClass(\"sapUiTableCtrlCol\"),0==o&&e.addClass(\"sapUiTableCtrlFirstCol\"),C&&e.addClass(\"sapUiTableCHTHR\"),e.writeClasses(),e.write(\">\");var u,T,c=t.getColumns(),A=new Array(s),p=!1,h=!i&&s>a;for(u=a;u<s;u++){T=c[u];var R={shouldRender:!(!T||!T.shouldRender())};if(R.shouldRender){var x=T.getWidth();d.isVariableWidth(x)&&(h=!1,i?x=(T._iFixWidth||160)+\"px\":x&&x.indexOf(\"%\")>0&&(p=!0)),R.width=x}A[u]=R}for(d.hasRowHeader(t)&&!C?(e.write(\"<th\"),p?e.addStyle(\"width\",\"0%\"):e.addStyle(\"width\",\"0px\"),e.writeStyles(),0==o&&(t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TH\"),C||e.writeAttribute(\"id\",t.getId()+\"-colsel\"),e.addClass(\"sapUiTableColSel\"),e.writeClasses()),e.write(\"></th>\")):0===c.length&&e.write(\"<th></th>\"),u=a;u<s;u++)b=C?\"_hdr\":\"_col\",T=c[u],R=A[u],R.shouldRender&&(e.write(\"<th\"),R.width&&(e.addStyle(\"width\",R.width),e.writeStyles()),0==o&&(t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TH\",{column:T}),e.writeAttribute(\"id\",t.getId()+b+u)),e.writeAttribute(\"data-sap-ui-headcolindex\",u),e.writeAttribute(\"data-sap-ui-colid\",T.getId()),e.write(\">\"),0!=o||0!=d.getHeaderRowCount(t)||C||(T.getMultiLabels().length>0?e.renderControl(T.getMultiLabels()[0]):e.renderControl(T.getLabel())),e.write(\"</th>\"));h&&(e.write(\"<th\"),C&&e.writeAttribute(\"id\",t.getId()+\"-dummycolhdr\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"PRESENTATION\"),e.write(\"></th>\")),e.write(\"</tr>\"),e.write(\"</thead>\"),e.write(\"<tbody>\");var v,S,U=t._getVisibleColumns(),E=t.getRows();if(C)for(v=o,S=w;v<S;v++)this.renderColumnHeaderRow(e,t,v,i,a,s,h);else{var H=t._getAccExtension().getAriaTextsForSelectionMode(!0),f=d.isRowSelectionAllowed(t);for(v=o,S=w;v<S;v++)this.renderTableRow(e,t,E[v],v,i,a,s,!1,U,h,H,f)}e.write(\"</tbody>\"),e.write(\"</table>\")},w.addTrClasses=function(e,t,i,r){},w.writeRowSelectorContent=function(e,t,i,r){if(t._getAccRenderExtension().writeAccRowSelectorText(e,t,i,r),d.Grouping.isGroupMode(t)&&(e.write(\"<div\"),e.writeAttribute(\"class\",\"sapUiTableGroupShield\"),e.write(\"></div>\"),e.write(\"<div\"),e.writeAttribute(\"id\",i.getId()+\"-groupHeader\"),e.writeAttribute(\"class\",\"sapUiTableGroupIcon\"),e.write(\"></div>\"),d.Grouping.showGroupMenuButton(t))){var a=l.getIconInfo(\"sap-icon://drop-down-list\");e.write(\"<div class='sapUiTableGroupMenuButton'>\"),e.writeEscaped(a.content),e.write(\"</div>\")}},w.writeRowHighlightContent=function(e,t,i,r){if(d.hasRowHighlights(t)){var a=i.getAggregation(\"_settings\"),s=a._getHighlightCSSClassName();e.write(\"<div\"),e.writeAttribute(\"id\",i.getId()+\"-highlight\"),e.addClass(\"sapUiTableRowHighlight\"),e.addClass(s),e.writeClasses(),e.write(\">\"),t._getAccRenderExtension().writeAccRowHighlightText(e,t,i,r),e.write(\"</div>\")}},w.renderColumnHeaderRow=function(e,t,i,r,a,s,l){function n(e,t,r){var a,s=d.Column.getHeaderSpan(e,i);C<1?(s>1&&(a=e.getIndex(),s=r.slice(t+1,t+s).reduce(function(e,t){return t.getIndex()-a<s?e+1:e},1)),e._nSpan=C=s,b=t):e._nSpan=0,C--}function o(a,d){this.renderCol(e,t,a,i,a._nSpan,r&&d==b),a._nSpan=void 0}e.write(\"<tr\"),e.addClass(\"sapUiTableColHdrTr\"),e.writeClasses(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"COLUMNHEADER_ROW\"),e.write(\">\");var w,C=0,b=-1;w=t.getColumns().slice(a,s).filter(function(e){return!!e&&e.shouldRender()}),w.forEach(n),w.forEach(o.bind(this)),!r&&l&&w.length>0&&(e.write('<td class=\"sapUiTableTDDummy\"'),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"PRESENTATION\"),e.write(\"></td>\")),e.write(\"</tr>\")},w.renderTableRow=function(e,t,i,r,a,s,l,n,o,w,C,b){if(i){e.write(\"<tr\"),i._bDummyRow&&e.addStyle(\"opacity\",\"0\"),e.addClass(\"sapUiTableTr\"),a?e.writeAttribute(\"id\",i.getId()+\"-fixed\"):e.writeElementData(i),i._bHidden?e.addClass(\"sapUiTableRowHidden\"):(t.isIndexSelected(i.getIndex())&&e.addClass(\"sapUiTableRowSel\"),this.addTrClasses(e,t,i,r)),r%2==0?e.addClass(\"sapUiTableRowEven\"):e.addClass(\"sapUiTableRowOdd\");var g=t.getRows(),u=g.length;u>0&&g[u-1]===i?e.addClass(\"sapUiTableLastRow\"):u>0&&g[0]===i&&e.addClass(\"sapUiTableFirstRow\"),this._addFixedRowCSSClasses(e,t,r),e.writeClasses(),e.writeAttribute(\"data-sap-ui-rowindex\",r);var T=t.getRowHeight();T>0&&e.addStyle(\"height\",T+\"px\"),e.writeStyles(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TR\",{index:r}),e.write(\">\");var c=i.getCells();(d.hasRowHeader(t)||0===c.length)&&(e.write(\"<td\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"ROWHEADER_TD\",{rowSelected:!i._bHidden&&t.isIndexSelected(i.getIndex()),index:r}),e.write(\"></td>\"));for(var A=0,p=c.length;A<p;A++)this.renderTableCell(e,t,i,c[A],A,a,s,l,o);!a&&w&&c.length>0&&(e.write('<td class=\"sapUiTableTDDummy\"'),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"PRESENTATION\"),e.write(\"></td>\")),e.write(\"</tr>\")}},w.renderTableCell=function(e,t,i,r,a,l,n,w,C){var b=r.data(\"sap-ui-colindex\"),g=t.getColumns()[b];if(g.shouldRender()&&n<=b&&w>b){e.write(\"<td\");var u=i.getId()+\"-col\"+a;e.writeAttribute(\"id\",u),e.writeAttribute(\"tabindex\",\"-1\"),e.writeAttribute(\"data-sap-ui-colid\",g.getId());var T=C.length,c=T>0&&C[0]===g,A=T>0&&C[T-1]===g;t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"DATACELL\",{index:b,column:g,row:i,fixed:l,firstCol:c});var p=s.getTextAlign(g.getHAlign(),r&&r.getTextDirection&&r.getTextDirection());p&&e.addStyle(\"text-align\",p),e.writeStyles(),e.addClass(\"sapUiTableTd\"),c&&e.addClass(\"sapUiTableTdFirst\"),A&&e.addClass(\"sapUiTableTdLast\"),g.getGrouped()&&e.addClass(\"sapUiTableTdGroup\");var h=t.getBinding(\"rows\");h&&g.getLeadingProperty&&h.isMeasure(g.getLeadingProperty())&&e.addClass(\"sapUiTableMeasureCell\"),e.writeClasses(),e.write(\"><div\"),e.addClass(\"sapUiTableCell\"),c&&d.Grouping.isTreeMode(t)&&e.addClass(\"sapUiTableCellFlex\"),e.writeClasses(),t.getRowHeight()&&t.getVisibleRowCountMode()==o.Auto&&e.addStyle(\"max-height\",t.getRowHeight()+\"px\"),e.writeStyles(),e.write(\">\"),this.renderTableCellControl(e,t,r,c),e.write(\"</div></td>\")}},w.renderTableCellControl=function(e,t,i,r){if(r&&d.Grouping.isTreeMode(t)){var a=i.getParent();e.write(\"<span class='sapUiTableTreeIcon' tabindex='-1' id='\"+a.getId()+\"-treeicon'\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TREEICON\",{row:a}),e.write(\"></span>\")}e.renderControl(i)},w.renderVSb=function(e,t){e.write(\"<div\"),e.addClass(\"sapUiTableVSbBg\"),e.writeAttribute(\"id\",t.getId()+\"-vsb-bg\"),e.writeClasses(),e.write(\"></div>\"),e.write(\"<div\"),e.addClass(\"sapUiTableVSb\"),e.writeClasses(),e.writeAttribute(\"id\",t.getId()+\"-vsb\"),e.writeAttribute(\"tabindex\",\"-1\"),e.addStyle(\"max-height\",t._getVSbHeight()+\"px\"),t.getFixedRowCount()>0&&(t._iVsbTop=t.getFixedRowCount()*t._getDefaultRowHeight()-1,e.addStyle(\"top\",t._iVsbTop+\"px\")),e.writeStyles(),e.write(\">\"),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-vsb-content\"),e.addClass(\"sapUiTableVSbContent\"),e.writeClasses(),e.addStyle(\"height\",t._getTotalScrollRange()+\"px\"),e.writeStyles(),e.write(\">\"),e.write(\"</div>\"),e.write(\"</div>\")},w.renderHSb=function(e,t){e.write(\"<div\"),e.addClass(\"sapUiTableHSbBg\"),e.writeAttribute(\"id\",t.getId()+\"-hsb-bg\"),e.writeClasses(),e.write(\"></div>\"),e.write(\"<div\"),e.addClass(\"sapUiTableHSb\"),e.writeClasses(),e.writeAttribute(\"id\",t.getId()+\"-hsb\"),e.writeAttribute(\"tabindex\",\"-1\"),e.write(\">\"),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-hsb-content\"),e.addClass(\"sapUiTableHSbContent\"),e.writeClasses(),e.write(\">\"),e.write(\"</div>\"),e.write(\"</div>\")},w.renderTabElement=function(e,t){e.write(\"<div\"),t&&(e.addClass(t),e.writeClasses()),e.writeAttribute(\"tabindex\",\"0\"),e.write(\"></div>\")},w},!0);",
		"sap/ui/table/TableRendererUtils.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\"],function(e,t){\"use strict\";var r=null,n={addClass:function(e,t,a){return t&&(a||2==arguments.length)&&(e.addClass(t),r&&(r.writeClasses=!0)),n},addStyle:function(e,t,a,i){return t&&a&&(i||3==arguments.length)&&(e.addStyle(t,a),r&&(r.writeStyles=!0)),n},startElement:function(a,i,s){if(s=s||{},a.write(\"<\",s.tag||\"div\"),r=s,s.furtherSettings&&s.furtherSettings(a,i),e.isArray(s.classname)&&s.classname.length)for(var l=0;l<s.classname.length;l++)n.addClass(a,s.classname[l]);else s.classname&&n.addClass(a,s.classname);if(s.id?a.writeAttribute(\"id\",(s.element||i).getId()+\"-\"+s.id):s.element&&(s.element instanceof t?a.writeControlData(s.element):a.writeElementData(s.element)),s.attributes)for(var u in s.attributes)s.attributes.hasOwnProperty(u)&&a.writeAttribute(u,s.attributes[u]);return\"number\"==typeof s.tabindex&&a.writeAttribute(\"tabindex\",\"\"+s.tabindex),s.aria&&i._getAccRenderExtension().writeAriaAttributesFor(a,i,s.aria,s.ariaconfig),r.writeClasses&&a.writeClasses(),r.writeStyles&&a.writeStyles(),r=null,a.write(\">\"),n},endElement:function(e,t){return e.write(\"</\",t||\"div\",\">\"),n},renderElement:function(e,t,r){return n.startElement(e,t,r),n.endElement(e,r?r.tag:null),n}};return n},!0);",
		"sap/ui/table/TableScrollExtension.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./TableExtension\",\"./TableUtils\",\"sap/ui/Device\",\"./library\"],function(e,l,t,o,r){\"use strict\";function i(e){if(\"touchstart\"===e.type||\"touch\"===e.pointerType){this._bIsScrollVertical=null;var l=e.touches?e.touches[0]:e;this._aTouchStartPosition=[l.pageX,l.pageY],this._oVSb&&(this._iTouchScrollTop=this._oVSb.scrollTop),this._oHSb&&(this._iTouchScrollLeft=this._oHSb.scrollLeft)}}function n(e){if((\"touchmove\"===e.type||\"touch\"===e.pointerType)&&this._aTouchStartPosition){var l=e.touches?e.touches[0]:e,t=l.pageX-this._aTouchStartPosition[0],r=l.pageY-this._aTouchStartPosition[1];if(null===this._bIsScrollVertical){if(0===t&&0===r)return;this._bIsScrollVertical=Math.abs(r)>=Math.abs(t)}this._bIsScrollVertical&&this._oVSb?(this._oVSb.scrollTop=this._iTouchScrollTop-r,o.browser.safari&&e.preventDefault()):!this._bIsScrollVertical&&this._oHSb&&(this._oHSb.scrollLeft=this._iTouchScrollLeft-t,o.browser.safari&&e.preventDefault())}}var s=r.SharedDomRef,a={onScroll:function(l){var t=this._getScrollExtension();if(e.sap.interaction.notifyScrollEvent&&e.sap.interaction.notifyScrollEvent(l),!this._bOnAfterRendering){var o=l.target.scrollLeft;if(o!==l.target._scrollLeft){var r=a._getScrollAreas(this);l.target._scrollLeft=o;for(var i=0;i<r.length;i++){var n=r[i];n!==l.target&&n.scrollLeft!==o&&(n.scrollLeft=o,n._scrollLeft=o)}t._iHorizontalScrollPosition=o,this._determineVisibleCols(this._collectTableSizes())}}},restoreScrollPosition:function(l){var t=l._getScrollExtension(),o=t.getHorizontalScrollbar();if(null!==o&&null!==t._iHorizontalScrollPosition){for(var r=a._getScrollAreas(l),i=0;i<r.length;i++){delete r[i]._scrollLeft}if(o.scrollLeft!==t._iHorizontalScrollPosition)o.scrollLeft=t._iHorizontalScrollPosition;else{var n=e.Event(\"scroll\");n.target=o,a.onScroll.call(l,n)}}},addEventListeners:function(e){var l=e._getScrollExtension(),t=a._getScrollAreas(e);null==l._onHorizontalScrollEventHandler&&(l._onHorizontalScrollEventHandler=a.onScroll.bind(e));for(var o=0;o<t.length;o++)t[o].addEventListener(\"scroll\",l._onHorizontalScrollEventHandler)},removeEventListeners:function(e){var l=e._getScrollExtension(),t=a._getScrollAreas(e);if(null!=l._onHorizontalScrollEventHandler){for(var o=0;o<t.length;o++)t[o].removeEventListener(\"scroll\",l._onHorizontalScrollEventHandler),delete t[o]._scrollLeft;delete l._onHorizontalScrollEventHandler}},_getScrollAreas:function(e){return[e._getScrollExtension().getHorizontalScrollbar(),e.getDomRef(\"sapUiTableColHdrScr\"),e.getDomRef(\"sapUiTableCtrlScr\")].filter(function(e){return null!=e})}},c={onScroll:function(l){function o(e){var l=e._getScrollExtension().getVerticalScrollbar();if(l){var o=l.scrollTop;r._iVerticalScrollPosition=o;var i=e._getFirstVisibleRowByScrollTop(o);i!==e.getFirstVisibleRow()?(e.setFirstVisibleRow(i,!0),t.isVariableRowHeightEnabled(e)&&e.attachEventOnce(\"_rowsUpdated\",function(){this._adjustTablePosition(l.scrollTop,this._aRowHeights)})):t.isVariableRowHeightEnabled(e)&&e._adjustTablePosition(o,e._aRowHeights)}}var r=this._getScrollExtension();e.sap.interaction.notifyScrollEvent&&e.sap.interaction.notifyScrollEvent(l),r._bIsScrolledVerticallyByKeyboard||(this._getKeyboardExtension().setActionMode(!1),this._bLargeDataScrolling&&!r._bIsScrolledVerticallyByWheel?(e.sap.clearDelayedCall(this._mTimeouts.scrollUpdateTimerId),this._mTimeouts.scrollUpdateTimerId=e.sap.delayedCall(300,this,function(){o(this),delete this._mTimeouts.scrollUpdateTimerId}.bind(this))):o(this),r._bIsScrolledVerticallyByWheel=!1)},onScrollbarMouseDown:function(e){var l=this._getScrollExtension();l._bIsScrolledVerticallyByWheel=!1,l._bIsScrolledVerticallyByKeyboard=!1},restoreScrollPosition:function(e){var l=e._getScrollExtension();null!==l._iVerticalScrollPosition?e._updateVSbScrollTop(l._iVerticalScrollPosition):e._updateVSbScrollTop()},addEventListeners:function(e){var l=e._getScrollExtension(),t=c._getScrollAreas(e),o=l.getVerticalScrollbar();null==l._onVerticalScrollEventHandler&&(l._onVerticalScrollEventHandler=c.onScroll.bind(e));for(var r=0;r<t.length;r++)t[r].addEventListener(\"scroll\",l._onVerticalScrollEventHandler);null!==o&&(null==l._onVerticalScrollbarMouseDownEventHandler&&(l._onVerticalScrollbarMouseDownEventHandler=c.onScrollbarMouseDown.bind(e)),o.addEventListener(\"mousedown\",l._onVerticalScrollbarMouseDownEventHandler))},removeEventListeners:function(e){var l=e._getScrollExtension(),t=c._getScrollAreas(e),o=l.getVerticalScrollbar();if(null!=l._onVerticalScrollEventHandler){for(var r=0;r<t.length;r++)t[r].removeEventListener(\"scroll\",l._onVerticalScrollEventHandler);delete l._onVerticalScrollEventHandler}null!==o&&null!=l._onVerticalScrollbarMouseDownEventHandler&&(o.removeEventListener(\"mousedown\",l._onVerticalScrollbarMouseDownEventHandler),delete l._onVerticalScrollbarMouseDownEventHandler)},_getScrollAreas:function(e){return[e._getScrollExtension().getVerticalScrollbar()].filter(function(e){return null!=e})}},h={onMouseWheelScrolling:function(e){var l,t=this._getScrollExtension(),r=e.originalEvent,i=r.shiftKey,n=!1,s=0;if(s=o.browser.firefox?r.detail:i?r.deltaX:r.deltaY,l=s>0,i){var a=t.getHorizontalScrollbar();n=l?a.scrollLeft===a.scrollWidth-a.clientWidth:0===a.scrollLeft,t.isHorizontalScrollbarVisible()&&!n&&(e.preventDefault(),e.stopPropagation(),a.scrollLeft=a.scrollLeft+s)}else{var c=t.getVerticalScrollbar();if(n=l?c.scrollTop===c.scrollHeight-c.clientHeight:0===c.scrollTop,t.isVerticalScrollbarVisible()&&!n){e.preventDefault(),e.stopPropagation();var h=s/this._getDefaultRowHeight();h>1&&(h=Math.floor(h)),t._bIsScrolledVerticallyByWheel=!0,t._bIsScrolledVerticallyByKeyboard=!1,c.scrollTop+=h*this._getScrollingPixelsForRow()}}}},u={_ontouchstart:i,_ontouchmove:n,onAfterRendering:function(e){c.restoreScrollPosition(this),a.restoreScrollPosition(this),this._oVSb=this._getScrollExtension().getVerticalScrollbar(),this._oHSb=this._getScrollExtension().getHorizontalScrollbar();var l=this.getDomRef(\"tableCCnt\");o.support.pointer&&o.system.desktop?(l.addEventListener(\"pointerdown\",i.bind(this)),l.addEventListener(\"pointermove\",n.bind(this),!!o.browser.chrome&&{passive:!0})):o.support.touch&&(l.addEventListener(\"touchstart\",i.bind(this)),l.addEventListener(\"touchmove\",n.bind(this)))},onfocusin:function(l){var t,r=e(l.target);if(r.parent(\".sapUiTableTr\").length>0?t=e(this.getDomRef(\"sapUiTableCtrlScr\")):r.parent(\".sapUiTableColHdr\").length>0&&(t=e(this.getDomRef(\"sapUiTableColHdrScr\"))),(o.browser.firefox||o.browser.chrome)&&t&&t.length>0){var i=t.scrollLeft(),n=t.width(),s=r.position().left,a=s+r.width(),c=s-i,h=a-n-i,u=this._getScrollExtension().getHorizontalScrollbar();h>0?u.scrollLeft=u.scrollLeft+h+1:c<0&&(u.scrollLeft=u.scrollLeft+c-1)}}};return l.extend(\"sap.ui.table.TableScrollExtension\",{_init:function(e,l,t){return this._type=l,this._delegate=u,this._iHorizontalScrollPosition=null,this._iVerticalScrollPosition=null,this._bIsScrolledVerticallyByWheel=!1,this._bIsScrolledVerticallyByKeyboard=!1,e.addEventDelegate(this._delegate,e),\"ScrollExtension\"},_attachEvents:function(){var e=this.getTable();a.addEventListeners(e),c.addEventListeners(e),o.browser.firefox?e._getScrollTargets().on(\"MozMousePixelScroll.sapUiTableMouseWheel\",h.onMouseWheelScrolling.bind(e)):e._getScrollTargets().on(\"wheel.sapUiTableMouseWheel\",h.onMouseWheelScrolling.bind(e))},_detachEvents:function(){var e=this.getTable();a.removeEventListeners(e),c.removeEventListeners(e),o.browser.firefox?e._getScrollTargets().off(\"MozMousePixelScroll.sapUiTableMouseWheel\"):e._getScrollTargets().off(\"wheel.sapUiTableMouseWheel\")},_debug:function(){this._ExtensionHelper=h,this._ExtensionDelegate=u,this._HorizontalScrollingHelper=a,this._VerticalScrollingHelper=c},destroy:function(){var e=this.getTable();e&&e.removeEventDelegate(this._delegate),this._delegate=null,l.prototype.destroy.apply(this,arguments)},scroll:function(e,l,t){null==e&&(e=!1),null==l&&(l=!1),null==t&&(t=!1);var o=this.getTable(),r=!1,i=o._getRowCount(),n=o.getVisibleRowCount(),s=n-o.getFixedRowCount()-o.getFixedBottomRowCount(),a=o.getFirstVisibleRow(),c=l?s:1;return e?a+n<i&&(o.setFirstVisibleRow(Math.min(a+c,i-n)),r=!0):a>0&&(o.setFirstVisibleRow(Math.max(a-c,0)),r=!0),r&&t&&(this._bIsScrolledVerticallyByKeyboard=!0),r},scrollMax:function(e,l){null==e&&(e=!1),null==l&&(l=!1);var o=this.getTable(),r=!1,i=o.getFirstVisibleRow();if(e){var n=o._getRowCount()-t.getNonEmptyVisibleRowCount(o);i<n&&(o.setFirstVisibleRow(n),r=!0)}else i>0&&(o.setFirstVisibleRow(0),r=!0);return r&&l&&(this._bIsScrolledVerticallyByKeyboard=!0),r},getHorizontalScrollbar:function(){var e=this.getTable();if(null!=e){var l=e.getDomRef(s.HorizontalScrollBar);if(null!=l)return l}return null},getVerticalScrollbar:function(){var e=this.getTable();if(null!=e){var l=e.getDomRef(s.VerticalScrollBar);if(null!=l)return l}return null},isHorizontalScrollbarVisible:function(){var e=this.getTable();if(null!=e){var l=e.getDomRef();if(null!=l)return l.classList.contains(\"sapUiTableHScr\")}return!1},isVerticalScrollbarVisible:function(){var e=this.getTable();if(null!=e){var l=e.getDomRef();if(null!=l)return l.classList.contains(\"sapUiTableVScr\")}return!1},updateVerticalScrollbarHeight:function(){var e=this.getTable();e.getDomRef(s.VerticalScrollBar).style.maxHeight=e._getVSbHeight()+\"px\"}})},!0);",
		"sap/ui/table/TableUtils.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/core/ResizeHandler\",\"sap/ui/core/MessageType\",\"sap/ui/Device\",\"sap/ui/model/ChangeReason\",\"./TableGrouping\",\"./TableColumnUtils\",\"./TableMenuUtils\",\"./library\"],function(e,t,n,o,i,l,r,a,s,u){\"use strict\";function d(t,n,o){if(null==t||null==n||null==o)return null;var i=e(n),l=i.parent().closest(o,t.getDomRef());return l.length>0?l:null}var g=u.SelectionBehavior,c=u.SelectionMode,f={Grouping:r,Column:a,Menu:s,CELLTYPES:{DATACELL:\"DATACELL\",COLUMNHEADER:\"COLUMNHEADER\",ROWHEADER:\"ROWHEADER\",ROWACTION:\"ROWACTION\",COLUMNROWHEADER:\"COLUMNROWHEADER\"},DEFAULT_ROW_HEIGHT:{sapUiSizeCondensed:25,sapUiSizeCompact:33,sapUiSizeCozy:49,undefined:33},RowsUpdateReason:function(){var e={};for(var t in l)e[t]=l[t];return e.Render=\"Render\",e.VerticalScroll=\"VerticalScroll\",e.FirstVisibleRowChange=\"FirstVisibleRowChange\",e.Unbind=\"Unbind\",e.Animation=\"Animation\",e.Resize=\"Resize\",e.Unknown=\"Unknown\",e}(),hasRowHeader:function(e){return e.getSelectionMode()!==c.None&&e.getSelectionBehavior()!==g.RowOnly||r.isGroupMode(e)},hasSelectAll:function(e){var t=null!=e?e.getSelectionMode():c.None;return(t===c.Multi||t===c.MultiToggle)&&e.getEnableSelectAll()},hasRowHighlights:function(e){if(null==e)return!1;var t=e.getRowSettingsTemplate();if(null==t)return!1;var n=t.getHighlight();return t.isBound(\"highlight\")||null!=n&&n!==o.None},getRowActionCount:function(e){var t=e.getRowActionTemplate();return t?t._getCount():0},hasRowActions:function(e){var t=e.getRowActionTemplate();return null!=t&&(t.isBound(\"visible\")||t.getVisible())&&f.getRowActionCount(e)>0},isRowSelectionAllowed:function(e){return e.getSelectionMode()!==c.None&&(e.getSelectionBehavior()===g.Row||e.getSelectionBehavior()===g.RowOnly)},isRowSelectorSelectionAllowed:function(e){return e.getSelectionMode()!==c.None&&f.hasRowHeader(e)},areAllRowsSelected:function(e){if(null==e)return!1;var t=e._getSelectableRowCount();return t>0&&t===e._getSelectedIndicesCount()},isNoDataVisible:function(e){return!!e.getShowNoData()&&!f.hasData(e)},hasData:function(e){var t=e.getBinding(\"rows\"),n=e._getRowCount(),o=!!t&&!!n;if(t&&t.providesGrandTotal){var i=t.providesGrandTotal()&&t.hasTotaledMeasures();o=!(i&&n<2||!i&&0===n)}return o},isBusyIndicatorVisible:function(e){return null!=e&&null!=e.getDomRef()&&null!=e.getDomRef().querySelector(\".sapUiTableCnt > .sapUiLocalBusyIndicator\")},hasPendingRequest:function(e){return null!=e&&!0===e._bPendingRequest},isInstanceOf:function(e,t){if(!e||!t)return!1;var n=sap.ui.require(t);return!!(n&&e instanceof n)},toggleRowSelection:function(t,n,o,i){function l(e){if(!t._isRowSelectable(e))return!1;t._iSourceRowIndex=e;var n=!0;if(i)n=i(e,o);else if(t.isIndexSelected(e)){if(null!=o&&o)return!1;t.removeSelectionInterval(e,e)}else{if(null!=o&&!o)return!1;t.addSelectionInterval(e,e)}return delete t._iSourceRowIndex,n}if(null==t||null==t.getBinding(\"rows\")||t.getSelectionMode()===c.None||null==n)return!1;if(\"number\"==typeof n)return!(n<0||n>=t._getRowCount())&&l(n);var r=e(n),a=this.getCellInfo(r[0]),s=this.isRowSelectionAllowed(t);if(null!==a&&!f.Grouping.isInGroupingRow(r[0])&&(a.type===this.CELLTYPES.DATACELL&&s||a.type===this.CELLTYPES.ROWACTION&&s||a.type===this.CELLTYPES.ROWHEADER&&this.isRowSelectorSelectionAllowed(t))){var u;return u=a.type===this.CELLTYPES.DATACELL?t.getRows()[parseInt(r.closest(\"tr\",t.getDomRef()).attr(\"data-sap-ui-rowindex\"),10)].getIndex():t.getRows()[parseInt(r.attr(\"data-sap-ui-rowindex\"),10)].getIndex(),l(u)}return!1},getNoDataText:function(e){var n=e.getNoData();return n instanceof t?null:\"string\"==typeof n||e.getNoData()instanceof String?n:e._oResBundle.getText(\"TBL_NO_DATA\")},getVisibleColumnCount:function(e){return e._getVisibleColumns().length},getHeaderRowCount:function(e){if(void 0===e._iHeaderRowCount)if(e.getColumnHeaderVisible()){for(var t=1,n=e.getColumns(),o=0;o<n.length;o++)n[o].shouldRender()&&(t=Math.max(t,n[o].getMultiLabels().length));e._iHeaderRowCount=t}else e._iHeaderRowCount=0;return e._iHeaderRowCount},isVariableRowHeightEnabled:function(e){return e._bVariableRowHeightEnabled&&e.getFixedRowCount()<=0&&e.getFixedBottomRowCount()<=0},getTotalRowCount:function(e,t){var n=e._getRowCount();return t&&(n=Math.max(n,e.getVisibleRowCount())),n},getNonEmptyVisibleRowCount:function(e){return Math.min(e.getVisibleRowCount(),e._getRowCount())},getFocusedItemInfo:function(e){var t=e._getItemNavigation();return t?{cell:t.getFocusedIndex(),columnCount:t.iColumns,cellInRow:t.getFocusedIndex()%t.iColumns,row:Math.floor(t.getFocusedIndex()/t.iColumns),cellCount:t.getItemDomRefs().length,domRef:t.getFocusedDomRef()}:null},getRowIndexOfFocusedCell:function(e){return f.getFocusedItemInfo(e).row-f.getHeaderRowCount(e)},isFixedColumn:function(e,t){return t<e.getFixedColumnCount()},hasFixedColumns:function(e){return e.getFixedColumnCount()>0},focusItem:function(e,t,n){var o=e._getItemNavigation();o&&o.focusItem(t,n)},getCellInfo:function(t){if(!t)return null;var n=e(t);return n.hasClass(\"sapUiTableTd\")?{type:f.CELLTYPES.DATACELL,cell:n}:n.hasClass(\"sapUiTableCol\")?{type:f.CELLTYPES.COLUMNHEADER,cell:n}:n.hasClass(\"sapUiTableRowHdr\")?{type:f.CELLTYPES.ROWHEADER,cell:n}:n.hasClass(\"sapUiTableRowAction\")?{type:f.CELLTYPES.ROWACTION,cell:n}:n.hasClass(\"sapUiTableColRowHdr\")?{type:f.CELLTYPES.COLUMNROWHEADER,cell:n}:null},getColumnHeaderCellInfo:function(t){if(null==t)return null;var n=e(t),o=this.getCellInfo(n);return null!==o&&o.type===f.CELLTYPES.COLUMNHEADER?{index:parseInt(n.data(\"sap-ui-colindex\"),10),span:parseInt(n.attr(\"colspan\")||1,10)}:null},getDataCellInfo:function(t,n){if(null==t||null==n)return null;var o=e(n),i=this.getCellInfo(o);if(null!==i&&i.type===f.CELLTYPES.DATACELL){var l=o.data(\"sap-ui-colid\"),r=sap.ui.getCore().byId(l);if(null!=r){var a=r.getIndex();return{rowIndex:parseInt(o.parent().data(\"sap-ui-rowindex\"),10),columnIndex:a}}}return null},getRowActionCellInfo:function(t,n){if(null==t||null==n)return null;var o=e(n),i=this.getCellInfo(o);return null!==i&&i.type===f.CELLTYPES.ROWACTION?{rowIndex:parseInt(o.data(\"sap-ui-rowindex\"),10)}:null},getRowColCell:function(e,t,n,o){var i=t>=0&&t<e.getRows().length?e.getRows()[t]:null,l=o?e.getColumns():e._getVisibleColumns(),r=n>=0&&n<l.length?l[n]:null,a=null;if(i&&r){if(o){if(r.shouldRender())for(var s=e._getVisibleColumns(),u=0;u<s.length;u++)if(s[u]===r){a=i.getCells()[u];break}}else a=i.getCells()[n];if(a&&a.data(\"sap-ui-colid\")!=r.getId())for(var d=i.getCells(),u=0;u<d.length;u++)if(d[u].data(\"sap-ui-colid\")===r.getId()){a=d[u];break}}return{row:i,column:r,cell:a}},getParentDataCell:function(e,t){return d(e,t,\".sapUiTableTd\")},getParentRowActionCell:function(e,t){return d(e,t,\".sapUiTableRowAction\")},getCell:function(t,n){if(null==t||null==n)return null;var o,i=e(n),l=t.getDomRef();return o=i.closest(\".sapUiTableTd\",l),o.length>0?o:(o=i.closest(\".sapUiTableCol\",l),o.length>0?o:(o=i.closest(\".sapUiTableRowHdr\",l),o.length>0?o:(o=i.closest(\".sapUiTableRowAction\",l),o.length>0?o:(o=i.closest(\".sapUiTableColRowHdr\",l),o.length>0?o:null))))},registerResizeHandler:function(t,o,i,l){var r;return\"string\"!=typeof o?void e.sap.log.error(\"sIdSuffix must be a string\",t):(r=t.getDomRef(o),\"function\"!=typeof i?void e.sap.log.error(\"fnHandler must be a function\",t):(this.deregisterResizeHandler(t,o),t._mResizeHandlerIds||(t._mResizeHandlerIds={}),l&&r&&(r=r.parentNode),r&&(t._mResizeHandlerIds[o]=n.register(r,i)),t._mResizeHandlerIds[o]))},deregisterResizeHandler:function(t,o){var i;if(t._mResizeHandlerIds){if(\"string\"==typeof o)i=[o];else if(void 0===o){i=[];for(var l in t._mResizeHandlerIds)\"string\"==typeof l&&t._mResizeHandlerIds.hasOwnProperty(l)&&i.push(l)}else e.isArray(o)&&(i=o);for(var r=0;r<i.length;r++){var a=i[r];t._mResizeHandlerIds[a]&&(n.deregister(t._mResizeHandlerIds[a]),t._mResizeHandlerIds[a]=void 0)}}},isFirstScrollableRow:function(t,n){if(isNaN(n)){var o=e(n);n=parseInt(o.add(o.parent()).filter(\"[data-sap-ui-rowindex]\").data(\"sap-ui-rowindex\"),10)}return n==(t.getFixedRowCount()||0)},isLastScrollableRow:function(t,n){if(isNaN(n)){var o=e(n);n=parseInt(o.add(o.parent()).filter(\"[data-sap-ui-rowindex]\").data(\"sap-ui-rowindex\"),10)}var i=t.getFixedBottomRowCount()||0;return n==t.getVisibleRowCount()-i-1},getContentDensity:function(t){var n,o=[\"sapUiSizeCompact\",\"sapUiSizeCondensed\",\"sapUiSizeCozy\"],i=function(e,t){if(t[e])for(var n=0;n<o.length;n++)if(t[e](o[n]))return o[n]},l=t.$();if(n=l.length>0?i(\"hasClass\",l):i(\"hasStyleClass\",t))return n;var r=null,a=t.getParent();if(a)do{if(n=i(\"hasStyleClass\",a))return n;a.getDomRef?r=a.getDomRef():a.getRootNode&&(r=a.getRootNode()),a=!r&&a.getParent?a.getParent():null}while(a&&!r);return l=e(r||document.body),n=i(\"hasClass\",l.closest(\".\"+o.join(\",.\")))},sanitizeSelectionMode:function(t,n){return n===c.Multi&&(n=c.MultiToggle,e.sap.log.warning(\"The selection mode 'Multi' is deprecated and must not be used anymore. Your setting was defaulted to selection mode 'MultiToggle'\")),n},isVariableWidth:function(e){return!e||\"auto\"==e||e.toString().match(/%$/)},getFirstFixedButtomRowIndex:function(e){var t=e.getFixedBottomRowCount(),n=e.getBinding(\"rows\"),o=-1;if(n&&t>0){var i=e.getVisibleRowCount(),l=e.getFirstVisibleRow();if(e._iBindingLength>=i)o=i-t;else{var r=e._iBindingLength-t-l;r>=0&&l+r<e._iBindingLength&&(o=r)}}return o}};return r.TableUtils=f,a.TableUtils=f,s.TableUtils=f,f},!0);",
		"sap/ui/table/TreeTable.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./Table\",\"sap/ui/model/odata/ODataTreeBindingAdapter\",\"sap/ui/model/ClientTreeBindingAdapter\",\"sap/ui/model/TreeBindingCompatibilityAdapter\",\"./library\",\"sap/ui/core/Element\",\"./TableUtils\"],function(e,t,o,n,r,i,s,l){\"use strict\";var a=t.extend(\"sap.ui.table.TreeTable\",{metadata:{library:\"sap.ui.table\",properties:{expandFirstLevel:{type:\"boolean\",defaultValue:!1,deprecated:!0},useGroupMode:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},groupHeaderProperty:{type:\"string\",group:\"Data\",defaultValue:null},collapseRecursive:{type:\"boolean\",defaultValue:!0},rootLevel:{type:\"int\",group:\"Data\",defaultValue:0}},events:{toggleOpenState:{parameters:{rowIndex:{type:\"int\"},rowContext:{type:\"object\"},expanded:{type:\"boolean\"}}}}},renderer:\"sap.ui.table.TableRenderer\"});return a.prototype.init=function(){t.prototype.init.apply(this,arguments),l.Grouping.setTreeMode(this)},a.prototype.bindRows=function(e,o,n,r){var i,s,n,r;return\"string\"==typeof e&&(i=arguments[0],s=arguments[1],n=arguments[2],r=arguments[3],e={path:i,sorter:n,filters:r,template:s}),\"object\"==typeof e&&(e.parameters=e.parameters||{},e.parameters.rootLevel=this.getRootLevel(),e.parameters.collapseRecursive=this.getCollapseRecursive(),e.parameters.numberOfExpandedLevels=e.parameters.numberOfExpandedLevels||(this.getExpandFirstLevel()?1:0),e.parameters.rootNodeID=e.parameters.rootNodeID),t.prototype.bindRows.call(this,e)},a.prototype.setSelectionMode=function(e){var o=this.getBinding(\"rows\");return o&&o.clearSelection?(o.clearSelection(),e=l.sanitizeSelectionMode(this,e),this.setProperty(\"selectionMode\",e)):t.prototype.setSelectionMode.call(this,e),this},a.prototype.refreshRows=function(e){t.prototype.refreshRows.apply(this,arguments);var o=this.getBinding(\"rows\");o&&this.isTreeBinding(\"rows\")&&!o.hasListeners(\"selectionChanged\")&&o.attachSelectionChanged(this._onSelectionChanged,this)},a.prototype.setFixedRowCount=function(t){return e.sap.log.warning('TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!'),this},a.prototype.isTreeBinding=function(e){return\"rows\"===(e=e||\"rows\")||s.prototype.isTreeBinding.apply(this,arguments)},a.prototype.getBinding=function(t){t=t||\"rows\";var o=s.prototype.getBinding.call(this,t);return o&&\"rows\"===t&&!o.getLength&&(l.isInstanceOf(o,\"sap/ui/model/odata/ODataTreeBinding\")?r(o,this):l.isInstanceOf(o,\"sap/ui/model/odata/v2/ODataTreeBinding\")?o.applyAdapterInterface():l.isInstanceOf(o,\"sap/ui/model/ClientTreeBinding\")?n.apply(o):e.sap.log.error(\"Binding not supported by sap.ui.table.TreeTable\")),o},a.prototype._getContexts=function(e,t,o){var n=this.getBinding(\"rows\");return n?n.getNodes(e,t,o):[]},a.prototype._onGroupHeaderChanged=function(e,t){this.fireToggleOpenState({rowIndex:e,rowContext:this.getContextByIndex(e),expanded:t})},a.prototype.expand=function(e){var t=this.getBinding(\"rows\");return t&&e>=0&&t.expand(e),this},a.prototype.collapse=function(e){var t=this.getBinding(\"rows\");return t&&e>=0&&t.collapse(e),this},a.prototype.collapseAll=function(){var e=this.getBinding(\"rows\");return e&&(e.collapseToLevel(0),this.setFirstVisibleRow(0)),this},a.prototype.expandToLevel=function(t){var o=this.getBinding(\"rows\");return e.sap.assert(o&&o.expandToLevel,\"TreeTable.expandToLevel is not supported with your current Binding. Please check if you are running on an ODataModel V2.\"),o&&o.expandToLevel&&o.expandToLevel(t),this},a.prototype.isExpanded=function(e){var t=this.getBinding(\"rows\");return!!t&&t.isExpanded(e)},a.prototype.isIndexSelected=function(e){var o=this.getBinding(\"rows\");return o&&o.isIndexSelected?o.isIndexSelected(e):t.prototype.isIndexSelected.call(this,e)},a.prototype.setSelectedIndex=function(e){-1===e&&this.clearSelection();var o=this.getBinding(\"rows\");return o&&o.findNode&&o.setNodeSelection?o.setSelectedIndex(e):t.prototype.setSelectedIndex.call(this,e),this},a.prototype.getSelectedIndices=function(){var e=this.getBinding(\"rows\");return e&&e.findNode&&e.getSelectedIndices?e.getSelectedIndices():t.prototype.getSelectedIndices.call(this)},a.prototype.setSelectionInterval=function(e,o){var n=this.getSelectionMode();if(n===i.SelectionMode.None)return this;var r=this.getBinding(\"rows\");return r&&r.findNode&&r.setSelectionInterval?n===i.SelectionMode.Single?r.setSelectionInterval(e,e):r.setSelectionInterval(e,o):t.prototype.setSelectionInterval.call(this,e,o),this},a.prototype.addSelectionInterval=function(e,o){var n=this.getSelectionMode();if(n===i.SelectionMode.None)return this;var r=this.getBinding(\"rows\");return r&&r.findNode&&r.addSelectionInterval?n===i.SelectionMode.Single?r.setSelectionInterval(e,e):r.addSelectionInterval(e,o):t.prototype.addSelectionInterval.call(this,e,o),this},a.prototype.removeSelectionInterval=function(e,o){var n=this.getBinding(\"rows\");return n&&n.findNode&&n.removeSelectionInterval?n.removeSelectionInterval(e,o):t.prototype.removeSelectionInterval.call(this,e,o),this},a.prototype.selectAll=function(){if(!l.hasSelectAll(this))return this;var e=this.getBinding(\"rows\");return e&&e.selectAll?e.selectAll():t.prototype.selectAll.call(this),this},a.prototype.getSelectedIndex=function(){var e=this.getBinding(\"rows\");return e&&e.findNode?e.getSelectedIndex():t.prototype.getSelectedIndex.call(this)},a.prototype.clearSelection=function(){var e=this.getBinding(\"rows\");return e&&e.clearSelection?e.clearSelection():t.prototype.clearSelection.call(this),this},a.prototype.getContextByIndex=function(e){var t=this.getBinding(\"rows\");if(t)return t.getContextByIndex(e)},a.prototype.setRootLevel=function(t){this.setFirstVisibleRow(0);var o=this.getBinding(\"rows\");return o&&(e.sap.assert(o.setRootLevel,\"rootLevel is not supported by the used binding\"),o.setRootLevel&&o.setRootLevel(t)),this.setProperty(\"rootLevel\",t,!0),this},a.prototype.setCollapseRecursive=function(t){var o=this.getBinding(\"rows\");return o&&(e.sap.assert(o.setCollapseRecursive,\"Collapse Recursive is not supported by the used binding\"),o.setCollapseRecursive&&o.setCollapseRecursive(t)),this.setProperty(\"collapseRecursive\",!!t,!0),this},a.prototype._getSelectedIndicesCount=function(){var e=this.getBinding(\"rows\");return e&&e.getSelectedNodesCount?e.getSelectedNodesCount():t.prototype.getSelectedIndices.call(this)},a.prototype.setUseGroupMode=function(e){return this.setProperty(\"useGroupMode\",!!e),e?l.Grouping.setGroupMode(this):l.Grouping.setTreeMode(this),this},a.prototype.setEnableGrouping=function(t){return e.sap.log.warning(\"The property enableGrouping is not supported by control sap.ui.table.TreeTable\"),this},a});",
		"sap/ui/table/TreeTableRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/table/TreeTable\"],function(e){\"use strict\";return e.getMetadata().getRenderer()},!0);"
	}
});