define(['exports', 'module'], function (exports, module) {
  'use strict';

  var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

  var Path = function Path(init) {
    var _instructions = init || [];

    var push = function push(arr, el) {
      var copy = arr.slice(0, arr.length);
      copy.push(el);
      return copy;
    };

    var areEqualPoints = function areEqualPoints(_ref, _ref3) {
      var _ref2 = _slicedToArray(_ref, 2);

      var a1 = _ref2[0];
      var b1 = _ref2[1];

      var _ref32 = _slicedToArray(_ref3, 2);

      var a2 = _ref32[0];
      var b2 = _ref32[1];
      return a1 === a2 && b1 === b2;
    };

    var trimZeros = function trimZeros(string, char) {
      var l = string.length;
      while (string.charAt(l - 1) === '0') {
        l = l - 1;
      }
      if (string.charAt(l - 1) === '.') {
        l = l - 1;
      }
      return string.substr(0, l);
    };

    var round = function round(number, digits) {
      var str = number.toFixed(digits);
      return trimZeros(str);
    };

    var printInstrunction = function printInstrunction(_ref4) {
      var command = _ref4.command;
      var params = _ref4.params;

      var numbers = params.map(function (param) {
        return round(param, 6);
      });
      return command + ' ' + numbers.join(' ');
    };

    var point = function point(_ref5, _ref6) {
      var command = _ref5.command;
      var params = _ref5.params;

      var _ref62 = _slicedToArray(_ref6, 2);

      var prevX = _ref62[0];
      var prevY = _ref62[1];

      switch (command) {
        case 'M':
          return [params[0], params[1]];
        case 'L':
          return [params[0], params[1]];
        case 'H':
          return [params[0], prevY];
        case 'V':
          return [prevX, params[0]];
        case 'Z':
          return null;
        case 'C':
          return [params[4], params[5]];
        case 'S':
          return [params[2], params[3]];
        case 'Q':
          return [params[2], params[3]];
        case 'T':
          return [params[0], params[1]];
        case 'A':
          return [params[5], params[6]];
      }
    };

    var verbosify = function verbosify(keys, f) {
      return function (a) {
        var args = typeof a === 'object' ? keys.map(function (k) {
          return a[k];
        }) : arguments;
        return f.apply(null, args);
      };
    };

    var plus = function plus(instruction) {
      return Path(push(_instructions, instruction));
    };

    return {
      moveto: verbosify(['x', 'y'], function (x, y) {
        return plus({
          command: 'M',
          params: [x, y]
        });
      }),
      lineto: verbosify(['x', 'y'], function (x, y) {
        return plus({
          command: 'L',
          params: [x, y]
        });
      }),
      hlineto: verbosify(['x'], function (x) {
        return plus({
          command: 'H',
          params: [x]
        });
      }),
      vlineto: verbosify(['y'], function (y) {
        return plus({
          command: 'V',
          params: [y]
        });
      }),
      closepath: function closepath() {
        return plus({
          command: 'Z',
          params: []
        });
      },
      curveto: verbosify(['x1', 'y1', 'x2', 'y2', 'x', 'y'], function (x1, y1, x2, y2, x, y) {
        return plus({
          command: 'C',
          params: [x1, y1, x2, y2, x, y]
        });
      }),
      smoothcurveto: verbosify(['x2', 'y2', 'x', 'y'], function (x2, y2, x, y) {
        return plus({
          command: 'S',
          params: [x2, y2, x, y]
        });
      }),
      qcurveto: verbosify(['x1', 'y1', 'x', 'y'], function (x1, y1, x, y) {
        return plus({
          command: 'Q',
          params: [x1, y1, x, y]
        });
      }),
      smoothqcurveto: verbosify(['x', 'y'], function (x, y) {
        return plus({
          command: 'T',
          params: [x, y]
        });
      }),
      arc: verbosify(['rx', 'ry', 'xrot', 'largeArcFlag', 'sweepFlag', 'x', 'y'], function (rx, ry, xrot, largeArcFlag, sweepFlag, x, y) {
        return plus({
          command: 'A',
          params: [rx, ry, xrot, largeArcFlag, sweepFlag, x, y]
        });
      }),
      print: function print() {
        return _instructions.map(printInstrunction).join(' ');
      },
      points: function points() {
        var ps = [];
        var prev = [0, 0];
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = _instructions[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var instruction = _step.value;

            var p = point(instruction, prev);
            prev = p;
            if (p) {
              ps.push(p);
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator['return']) {
              _iterator['return']();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }

        return ps;
      },
      instructions: function instructions() {
        return _instructions.slice(0, _instructions.length);
      },
      connect: function connect(path) {
        var ps = this.points();
        var last = ps[ps.length - 1];
        var first = path.points()[0];
        var newInstructions = path.instructions().slice(1);
        if (!areEqualPoints(last, first)) {
          newInstructions.unshift({
            command: "L",
            params: first
          });
        }
        return Path(this.instructions().concat(newInstructions));
      }
    };
  };

  module.exports = function () {
    return Path();
  };
});