import { decodeFontData, ttx, verifyTtxOutput } from "./fontutils.js";
import { Font, ToUnicodeMap } from "../../src/core/fonts.js";
import { CMapFactory } from "../../src/core/cmap.js";
import { Name } from "../../src/core/primitives.js";
import { Stream } from "../../src/core/stream.js";

describe("font_post", function () {
  const font2154 = decodeFontData(
    // eslint-disable-next-line max-len
    "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"
  );
  const font1282 = decodeFontData(
    // eslint-disable-next-line max-len
    "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"
  );

  describe("OS/2 table removal on bad post table values", function () {
    it("has invalid version number", function (done) {
      const font = new Font("font", new Stream(font2154), {
        loadedName: "font",
        type: "TrueType",
        differences: [],
        defaultEncoding: [],
        toUnicode: new ToUnicodeMap([]),
      });
      ttx(font.data, function (output) {
        verifyTtxOutput(output);
        expect(/<OS_2>\s*<version value="3"\/>/.test(output)).toEqual(true);
        done();
      });
    });

    it("has invalid selection attributes presence", function (done) {
      CMapFactory.create({
        encoding: Name.get("Identity-H"),
      }).then(function (cMap) {
        const font = new Font("font", new Stream(font1282), {
          loadedName: "font",
          type: "CIDFontType2",
          differences: [],
          defaultEncoding: [],
          cMap,
          toUnicode: new ToUnicodeMap([]),
        });
        ttx(font.data, function (output) {
          verifyTtxOutput(output);
          expect(/<OS_2>\s*<version value="3"\/>/.test(output)).toEqual(true);
          done();
        });
      });
    });
  });
});
