/**
* Copyright 2012-2016, Plotly, Inc.
* All rights reserved.
*
* This source code is licensed under the MIT license found in the
* LICENSE file in the root directory of this source tree.
*/


'use strict';

module.exports = {
    DZA: 'algeria',
    AGO: 'angola',
    EGY: 'egypt',
    BGD: 'bangladesh|^(?=.*east).*paki?stan',
    NER: '\\bniger(?!ia)',
    LIE: 'liechtenstein',
    NAM: 'namibia',
    BGR: 'bulgaria',
    BOL: 'bolivia',
    GHA: 'ghana|gold.?coast',
    CCK: '\\bcocos|keeling',
    PAK: '^(?!.*east).*paki?stan',
    CPV: 'verde',
    JOR: 'jordan',
    LBR: 'liberia',
    LBY: 'libya',
    MYS: 'malaysia',
    IOT: 'british.?indian.?ocean',
    PRI: 'puerto.?rico',
    MYT: 'mayotte',
    PRK: '^(?=.*democrat).*\\bkorea|^(?=.*people).*\\bkorea|^(?=.*north).*\\bkorea|\\bd\\.?p\\.?r\\.?k',
    PSE: 'palestin|\\bgaza|west.?bank',
    TZA: 'tanzania',
    BWA: 'botswana|bechuana',
    KHM: 'cambodia|kampuchea|khmer|^p\\.?r\\.?k\\.?$',
    UMI: 'minor.?outlying.?is',
    TTO: 'trinidad|tobago',
    PRY: 'paraguay',
    HKG: 'hong.?kong',
    SAU: '\\bsa\\w*.?arabia',
    LBN: 'lebanon',
    SVN: 'slovenia',
    BFA: 'burkina|\\bfaso|upper.?volta',
    SVK: '^(?!.*cze).*slovak',
    MRT: 'mauritania',
    HRV: 'croatia',
    CHL: '\\bchile',
    CHN: '^(?!.*\\bmac)(?!.*\\bhong)(?!.*\\btai).*china|^p\\.?r\\.?c\\.?$',
    KNA: 'kitts|\\bnevis',
    JAM: 'jamaica',
    SMR: 'san.?marino',
    GIB: 'gibraltar',
    DJI: 'djibouti',
    GIN: '^(?!.*eq)(?!.*span)(?!.*bissau)(?!.*portu)(?!.*new).*guinea',
    FIN: 'finland',
    URY: 'uruguay',
    VAT: 'holy.?see|vatican|papal.?st',
    STP: '\\bs(a|ã)o.?tom(e|é)',
    SYC: 'seychell',
    NPL: 'nepal',
    CXR: 'christmas',
    LAO: '\\blaos?\\b',
    YEM: '^(?!.*arab)(?!.*north)(?!.*sana)(?!.*peo)(?!.*dem)(?!.*south)(?!.*aden)(?!.*\\bp\\.?d\\.?r).*yemen',
    BVT: 'bouvet',
    ZAF: '\\bs\\w*.?africa',
    KIR: 'kiribati',
    PHL: 'philippines',
    SXM: '^(?!.*martin)(?!.*saba).*maarten',
    ROU: 'r(o|u|ou)mania',
    VIR: '^(?=.*\\bu\\.?\\s?s).*virgin|^(?=.*states).*virgin',
    SYR: 'syria',
    MAC: 'maca(o|u)',
    NFK: 'norfolk',
    NIC: 'nicaragua',
    MLT: '\\bmalta',
    KAZ: 'kazak',
    TCA: 'turks',
    PYF: 'french.?polynesia|tahiti',
    NIU: 'niue',
    DMA: 'dominica(?!n)',
    GBR: 'united.?kingdom|britain|^u\\.?k\\.?$',
    BEN: 'benin|dahome',
    GUF: '^(?=.*french).*guiana',
    BEL: '^(?!.*luxem).*belgium',
    MSR: 'montserrat',
    TGO: 'togo',
    DEU: '^(?!.*east).*germany|^(?=.*\\bfed.*\\brep).*german',
    GUM: '\\bguam',
    LKA: 'sri.?lanka|ceylon',
    SSD: '\\bs\\w*.?sudan',
    FLK: 'falkland|malvinas',
    PCN: 'pitcairn',
    BES: '^(?=.*bonaire).*eustatius|^(?=.*carib).*netherlands|\\bbes.?islands',
    GUY: 'guyana|british.?guiana',
    CRI: 'costa.?rica',
    COK: '\\bcook',
    MAR: 'morocco|\\bmaroc',
    MNP: 'mariana',
    LSO: 'lesotho|basuto',
    HUN: '^(?!.*austr).*hungary',
    TKM: 'turkmen',
    SUR: 'surinam|dutch.?guiana',
    NLD: '^(?!.*\\bant)(?!.*\\bcarib).*netherlands',
    BMU: 'bermuda',
    HMD: 'heard.*mcdonald',
    TCD: '\\bchad',
    GEO: '^(?!.*south).*georgia',
    MNE: '^(?!.*serbia).*montenegro',
    MNG: 'mongolia',
    MHL: 'marshall',
    MTQ: 'martinique',
    CSK: 'czechoslovakia',
    BLZ: 'belize|^(?=.*british).*honduras',
    DDR: 'german.?democratic.?republic|^(d|g)\\.?d\\.?r\\.?$|^(?=.*east).*germany',
    MMR: 'myanmar|burma',
    AFG: 'afghan',
    BDI: 'burundi',
    VGB: '^(?=.*\\bu\\.?\\s?k).*virgin|^(?=.*brit).*virgin|^(?=.*kingdom).*virgin',
    BLR: 'belarus|byelo',
    BLM: 'barth(e|é)lemy',
    GRD: 'grenada',
    TKL: 'tokelau',
    GRC: 'greece|hellenic|hellas',
    GRL: 'greenland',
    SHN: 'helena',
    AND: 'andorra',
    MOZ: 'mozambique',
    TJK: 'tajik',
    THA: 'thailand|\\bsiam',
    HTI: 'haiti',
    MEX: '\\bmexic',
    ANT: '^(?=.*\\bant).*(nether|dutch)',
    ZWE: 'zimbabwe|^(?!.*northern).*rhodesia',
    LCA: '\\blucia',
    IND: 'india(?!.*ocea)',
    LVA: 'latvia',
    BTN: 'bhutan',
    VCT: 'vincent',
    VNM: '^(?!.*republic).*viet.?nam|^(?=.*socialist).*viet.?nam',
    NOR: 'norway',
    CZE: '^(?=.*rep).*czech|czechia|bohemia',
    ATF: 'french.?southern|\\bfr.*\\bso.*\\ban.*\\b\\bt',
    ATG: 'antigua',
    FJI: 'fiji',
    HND: '^(?!.*brit).*honduras',
    MUS: 'mauritius',
    DOM: 'dominican',
    LUX: '^(?!.*belg).*luxem',
    ISR: 'israel',
    YUG: 'yugoslavia',
    FSM: 'micronesia',
    PER: 'peru',
    REU: 'r(e|é)union',
    IDN: 'indonesia',
    VUT: 'vanuatu|new.?hebrides',
    MKD: 'macedonia|^f\\.?y\\.?r\\.?o\\.?m\\.?$',
    COD: '\\bdem.*congo|congo.*\\bdem|congo.*\\bdr|\\bdr.*congo|\\bd\\.?r\\.?c|\\bd\\.?r\\.?o\\.?c|\\br\\.?d\\.?c|belgian.?congo|congo.?free.?state|kinshasa|zaire|l\\w{1,2}opoldville',
    COG: '^(?!.*\\bdem)(?!.*\\bdr)(?!.*kinshasa)(?!.*zaire)(?!.*belg)(?!.*l\\w{1,2}opoldville)(?!.*free).*\\bcongo',
    ISL: 'iceland',
    GLP: 'guadeloupe',
    ETH: 'ethiopia|abyssinia',
    COM: 'comoro',
    COL: 'colombia',
    NGA: 'nigeria',
    TLS: '^(?=.*leste).*timor|^(?=.*east).*timor',
    TWN: 'taiwan|taipei|formosa',
    PRT: 'portugal',
    MDA: 'moldov|b(a|e)ssarabia',
    GGY: 'guernsey',
    MDG: 'madagascar|malagasy',
    ATA: 'antarctica',
    ECU: 'ecuador',
    SEN: 'senegal',
    ESH: 'sahara',
    MDV: 'maldive',
    ASM: '^(?=.*americ).*samoa',
    SPM: 'miquelon',
    CUW: '^(?!.*bonaire).*\\bcura(c|ç)ao',
    FRA: '^(?!.*\\bdep)(?!.*martinique).*france|french.?republic|\\bgaul',
    LTU: 'lithuania',
    RWA: 'rwanda',
    ZMB: 'zambia|northern.?rhodesia',
    GMB: 'gambia',
    WLF: 'futuna|wallis',
    JEY: 'jersey',
    FRO: 'faroe|faeroe',
    GTM: 'guatemala',
    DNK: 'denmark',
    IMN: '^(?=.*isle).*\\bman',
    MAF: '^(?=.*collectivity).*martin|^(?=.*france).*martin(?!ique)|^(?=.*french).*martin(?!ique)',
    AUS: 'australia',
    AUT: '^(?!.*hungary).*austria|\\baust.*\\bemp',
    SJM: 'svalbard',
    VEN: 'venezuela',
    PLW: 'palau',
    KEN: 'kenya|british.?east.?africa|east.?africa.?prot',
    TUR: 'turkey',
    ALB: 'albania',
    OMN: '\\boman|trucial',
    TUV: 'tuvalu',
    ALA: '\\b(a|å)land',
    BRN: 'brunei',
    TUN: 'tunisia',
    RUS: '\\brussia|soviet.?union|u\\.?s\\.?s\\.?r|socialist.?republics',
    BRB: 'barbados',
    BRA: 'brazil',
    CIV: 'ivoire|ivory',
    SRB: '^(?!.*monte).*serbia',
    GNQ: 'guine.*eq|eq.*guine|^(?=.*span).*guinea',
    USA: '^(?!.*islands).*united.?states|^u\\.?s\\.?a\\.?$|^u\\.?s\\.?$',
    QAT: 'qatar',
    WSM: '^(?!.*amer).*samoa',
    AZE: 'azerbaijan',
    GNB: 'bissau|^(?=.*portu).*guinea',
    SWZ: 'swaziland',
    TON: 'tonga',
    CAN: 'canada',
    UKR: 'ukrain',
    KOR: '^(?!.*democrat)(?!.*people)(?!.*north).*\\bkorea|\\br\\.?o\\.?k\\b',
    AIA: 'anguill?a',
    CAF: '\\bcen.*\\baf|^c\\.?a\\.?r\\.?$',
    CHE: 'switz|swiss',
    CYP: 'cyprus',
    BIH: 'herzegovina|bosnia',
    SGP: 'singapore',
    SGS: 'south.?georgia|sandwich',
    SOM: 'somali',
    UZB: 'uzbek',
    CMR: 'cameroon',
    POL: 'poland',
    EAZ: 'zanz',
    KWT: 'kuwait',
    ERI: 'eritrea',
    GAB: 'gabon',
    CYM: 'cayman',
    ARE: 'emirates|^u\\.?a\\.?e\\.?$|united.?arab.?em',
    EST: 'estonia',
    MWI: 'malawi|nyasa',
    ESP: 'spain',
    IRQ: '\\biraq|mesopotamia',
    SLV: 'el.?salvador',
    MLI: '\\bmali\\b',
    YMD: '^(?=.*peo).*yemen|^(?!.*rep)(?=.*dem).*yemen|^(?=.*south).*yemen|^(?=.*aden).*yemen|^(?=.*\\bp\\.?d\\.?r).*yemen',
    IRL: 'ireland',
    IRN: '\\biran|persia',
    ABW: '^(?!.*bonaire).*\\baruba',
    SLE: 'sierra',
    PAN: 'panama',
    SDN: '^(?!.*\\bs(?!u)).*sudan',
    SLB: 'solomon',
    NZL: 'new.?zealand',
    MCO: 'monaco',
    ITA: 'italy',
    JPN: 'japan',
    KGZ: 'kyrgyz|kirghiz',
    UGA: 'uganda',
    NCL: 'new.?caledonia',
    PNG: 'papua|\\bp.*\\bn.*\\bguin.*|^p\\.?n\\.?g\\.?$|new.?guinea',
    ARG: 'argentin',
    SWE: 'sweden',
    BHS: 'bahamas',
    BHR: 'bahrain',
    ARM: 'armenia',
    NRU: 'nauru',
    CUB: '\\bcuba'
};
