var gulp = require('gulp');
var concat = require('gulp-concat');
var rename = require('gulp-rename');
var uglify = require('gulp-uglify');
var sourcemaps = require('gulp-sourcemaps');
var watch = require('gulp-watch');
var jshint = require('gulp-jshint');
var changed = require('gulp-changed');
var ngAnnotate = require('gulp-ng-annotate');

var src = {
    jsDir: 'src/**/*.js'
};

var dest = {
    distDir: 'dist'
};

gulp.task('lint', function () {
    return gulp.src(src.jsDir)
        .pipe(jshint({
            globalstrict: true,
            strict: false,
            globals: {
                angular: true,
                document: true,
                plupload: true,
                Image: true,
                FileReader: true
            }
        }))
        .pipe(jshint.reporter('jshint-stylish'));
});


gulp.task('js', function () {
    return gulp.src([src.jsDir])
        .pipe(concat('plupload-angular-directive.js'))
        .pipe(ngAnnotate({remove: true, add: true, single_quotes: true}))
        .on('error', console.log)
        .pipe(gulp.dest(dest.distDir))
        .pipe(sourcemaps.init())
        .pipe(uglify())
        .pipe(rename({basename: 'plupload-angular-directive.min'}))
        .pipe(sourcemaps.write('.'))
        .pipe(gulp.dest(dest.distDir))
        ;
});

gulp.task('watch', function () {
    gulp.watch([src.jsDir], ['js']);
});

gulp.task('build', function () {
    gulp.start('js');
});

gulp.task('default', function () {
    gulp.start('build');
    gulp.start('watch');
});