/**
 * @fileOverview Kickass library to create and place poppers near their reference elements.
 * @version 0.5.2
 * @license
 * Copyright (c) 2016 Federico Zivolo and contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
!function(a,b){"function"==typeof define&&define.amd?define(b):"object"==typeof module&&module.exports?module.exports=b():a.Popper=b()}(this,function(){"use strict";function a(a,b,c){this._reference=a.jquery?a[0]:a,this.state={};var d="undefined"==typeof b||null===b,e=b&&"[object Object]"===Object.prototype.toString.call(b);return d||e?this._popper=this.parse(e?b:{}):this._popper=b.jquery?b[0]:b,this._options=Object.assign({},r,c),this._options.modifiers=this._options.modifiers.map(function(a){return-1===this._options.modifiersIgnored.indexOf(a)?("applyStyle"===a&&this._popper.setAttribute("x-placement",this._options.placement),this.modifiers[a]||a):void 0}.bind(this)),this.state.position=this._getPosition(this._popper,this._reference),k(this._popper,{position:this.state.position}),this.state.isParentTransformed=this._getIsParentTransformed(this._popper),this.update(),this._setupEventListeners(),this}function b(a){var b=a.style.display,c=a.style.visibility;a.style.display="block",a.style.visibility="hidden";var d=(a.offsetWidth,q.getComputedStyle(a)),e=parseFloat(d.marginTop)+parseFloat(d.marginBottom),f=parseFloat(d.marginLeft)+parseFloat(d.marginRight),g={width:a.offsetWidth+f,height:a.offsetHeight+e};return a.style.display=b,a.style.visibility=c,g}function c(a){var b={left:"right",right:"left",bottom:"top",top:"bottom"};return a.replace(/left|right|bottom|top/g,function(a){return b[a]})}function d(a){var b=Object.assign({},a);return b.right=b.left+b.width,b.bottom=b.top+b.height,b}function e(a,b){var c,d=0;for(c in a){if(a[c]===b)return d;d++}return null}function f(a,b){var c=q.getComputedStyle(a,null);return c[b]}function g(a){var b=a.offsetParent;return b!==q.document.body&&b?b:q.document.documentElement}function h(a){return a===q.document?q.document.body.scrollTop?q.document.body:q.document.documentElement:-1!==["scroll","auto"].indexOf(f(a,"overflow"))||-1!==["scroll","auto"].indexOf(f(a,"overflow-x"))||-1!==["scroll","auto"].indexOf(f(a,"overflow-y"))?a:a.parentNode?h(a.parentNode):a}function i(a){return a===q.document.body?!1:"fixed"===f(a,"position")?!0:a.parentNode?i(a.parentNode):a}function j(a){return a===q.document.body?!1:"none"!==f(a,"transform")?!0:a.parentNode?j(a.parentNode):a}function k(a,b){function c(a){return""!==a&&!isNaN(parseFloat(a))&&isFinite(a)}Object.keys(b).forEach(function(d){var e="";-1!==["width","height","top","right","bottom","left"].indexOf(d)&&c(b[d])&&(e="px"),a.style[d]=b[d]+e})}function l(a){var b={};return a&&"[object Function]"===b.toString.call(a)}function m(a){var b={width:a.offsetWidth,height:a.offsetHeight,left:a.offsetLeft,top:a.offsetTop};return b.right=b.left+b.width,b.bottom=b.top+b.height,b}function n(a){var b=a.getBoundingClientRect();return{left:b.left,top:b.top,right:b.right,bottom:b.bottom,width:b.right-b.left,height:b.bottom-b.top}}function o(a,b,c,d){var e=n(a),f=n(b);if(c&&!d){var g=h(b);f.top+=g.scrollTop,f.bottom+=g.scrollTop,f.left+=g.scrollLeft,f.right+=g.scrollLeft}var i={top:e.top-f.top,left:e.left-f.left,bottom:e.top-f.top+e.height,right:e.left-f.left+e.width,width:e.width,height:e.height};return i}function p(a){for(var b=["","ms","webkit","moz","o"],c=0;c<b.length;c++){var d=b[c]?b[c]+a.charAt(0).toUpperCase()+a.slice(1):a;if("undefined"!=typeof q.document.body.style[d])return d}return null}var q=window,r={placement:"bottom",gpuAcceleration:!0,offset:0,boundariesElement:"viewport",boundariesPadding:5,preventOverflowOrder:["left","right","top","bottom"],flipBehavior:"flip",arrowElement:"[x-arrow]",modifiers:["shift","offset","preventOverflow","keepTogether","arrow","flip","applyStyle"],modifiersIgnored:[]};return a.prototype.destroy=function(){return this._popper.removeAttribute("x-placement"),this._popper.style.left="",this._popper.style.position="",this._popper.style.top="",this._popper.style[p("transform")]="",this._removeEventListeners(),this._options.removeOnDestroy&&this._popper.remove(),this},a.prototype.update=function(){var a={instance:this,styles:{}};a.placement=this._options.placement,a._originalPlacement=this._options.placement,a.offsets=this._getOffsets(this._popper,this._reference,a.placement),a.boundaries=this._getBoundaries(a,this._options.boundariesPadding,this._options.boundariesElement),a=this.runModifiers(a,this._options.modifiers),"function"==typeof this.state.updateCallback&&this.state.updateCallback(a)},a.prototype.onCreate=function(a){return a(this),this},a.prototype.onUpdate=function(a){return this.state.updateCallback=a,this},a.prototype.parse=function(a){function b(a,b){b.forEach(function(b){a.classList.add(b)})}function c(a,b){b.forEach(function(b){a.setAttribute(b.split(":")[0],b.split(":")[1]||"")})}var d={tagName:"div",classNames:["popper"],attributes:[],parent:q.document.body,content:"",contentType:"text",arrowTagName:"div",arrowClassNames:["popper__arrow"],arrowAttributes:["x-arrow"]};a=Object.assign({},d,a);var e=q.document,f=e.createElement(a.tagName);if(b(f,a.classNames),c(f,a.attributes),"node"===a.contentType?f.appendChild(a.content.jquery?a.content[0]:a.content):"html"===a.contentType?f.innerHTML=a.content:f.textContent=a.content,a.arrowTagName){var g=e.createElement(a.arrowTagName);b(g,a.arrowClassNames),c(g,a.arrowAttributes),f.appendChild(g)}var h=a.parent.jquery?a.parent[0]:a.parent;if("string"==typeof h){if(h=e.querySelectorAll(a.parent),h.length>1&&console.warn("WARNING: the given `parent` query("+a.parent+") matched more than one element, the first one will be used"),0===h.length)throw"ERROR: the given `parent` doesn't exists!";h=h[0]}return h.length>1&&h instanceof Element==!1&&(console.warn("WARNING: you have passed as parent a list of elements, the first one will be used"),h=h[0]),h.appendChild(f),f},a.prototype._getPosition=function(a,b){var c=g(b),d=i(b,c);return d?"fixed":"absolute"},a.prototype._getIsParentTransformed=function(a){return j(a.parentNode)},a.prototype._getOffsets=function(a,c,d){d=d.split("-")[0];var e={};e.position=this.state.position;var f="fixed"===e.position,h=this.state.isParentTransformed,i=g(f&&h?c:a),j=o(c,i,f,h),k=b(a);return-1!==["right","left"].indexOf(d)?(e.top=j.top+j.height/2-k.height/2,"left"===d?e.left=j.left-k.width:e.left=j.right):(e.left=j.left+j.width/2-k.width/2,"top"===d?e.top=j.top-k.height:e.top=j.bottom),e.width=k.width,e.height=k.height,{popper:e,reference:j}},a.prototype._setupEventListeners=function(){if(this.state.updateBound=this.update.bind(this),q.addEventListener("resize",this.state.updateBound),"window"!==this._options.boundariesElement){var a=h(this._reference);a!==q.document.body&&a!==q.document.documentElement||(a=q),a.addEventListener("scroll",this.state.updateBound)}},a.prototype._removeEventListeners=function(){if(q.removeEventListener("resize",this.state.updateBound),"window"!==this._options.boundariesElement){var a=h(this._reference);a!==q.document.body&&a!==q.document.documentElement||(a=q),a.removeEventListener("scroll",this.state.updateBound)}this.state.updateBound=null},a.prototype._getBoundaries=function(a,b,c){var d,e,f={};if("window"===c){var i=q.document.body,j=q.document.documentElement;e=Math.max(i.scrollHeight,i.offsetHeight,j.clientHeight,j.scrollHeight,j.offsetHeight),d=Math.max(i.scrollWidth,i.offsetWidth,j.clientWidth,j.scrollWidth,j.offsetWidth),f={top:0,right:d,bottom:e,left:0}}else if("viewport"===c){var k=g(this._popper),l=h(this._popper),n=m(k),o="fixed"===a.offsets.popper.position?0:l.scrollTop,p="fixed"===a.offsets.popper.position?0:l.scrollLeft;f={top:0-(n.top-o),right:q.document.documentElement.clientWidth-(n.left-p),bottom:q.document.documentElement.clientHeight-(n.top-o),left:0-(n.left-p)}}else f=g(this._popper)===c?{top:0,left:0,right:c.clientWidth,bottom:c.clientHeight}:m(c);return f.left+=b,f.right-=b,f.top=f.top+b,f.bottom=f.bottom-b,f},a.prototype.runModifiers=function(a,b,c){var d=b.slice();return void 0!==c&&(d=this._options.modifiers.slice(0,e(this._options.modifiers,c))),d.forEach(function(b){l(b)&&(a=b.call(this,a))}.bind(this)),a},a.prototype.isModifierRequired=function(a,b){var c=e(this._options.modifiers,a);return!!this._options.modifiers.slice(0,c).filter(function(a){return a===b}).length},a.prototype.modifiers={},a.prototype.modifiers.applyStyle=function(a){var b,c={position:a.offsets.popper.position},d=Math.round(a.offsets.popper.left),e=Math.round(a.offsets.popper.top);return this._options.gpuAcceleration&&(b=p("transform"))?(c[b]="translate3d("+d+"px, "+e+"px, 0)",c.top=0,c.left=0):(c.left=d,c.top=e),Object.assign(c,a.styles),k(this._popper,c),this._popper.setAttribute("x-placement",a.placement),this.isModifierRequired(this.modifiers.applyStyle,this.modifiers.arrow)&&a.offsets.arrow&&k(a.arrowElement,a.offsets.arrow),a},a.prototype.modifiers.shift=function(a){var b=a.placement,c=b.split("-")[0],e=b.split("-")[1];if(e){var f=a.offsets.reference,g=d(a.offsets.popper),h={y:{start:{top:f.top},end:{top:f.top+f.height-g.height}},x:{start:{left:f.left},end:{left:f.left+f.width-g.width}}},i=-1!==["bottom","top"].indexOf(c)?"x":"y";a.offsets.popper=Object.assign(g,h[i][e])}return a},a.prototype.modifiers.preventOverflow=function(a){var b=this._options.preventOverflowOrder,c=d(a.offsets.popper),e={left:function(){var b=c.left;return c.left<a.boundaries.left&&(b=Math.max(c.left,a.boundaries.left)),{left:b}},right:function(){var b=c.left;return c.right>a.boundaries.right&&(b=Math.min(c.left,a.boundaries.right-c.width)),{left:b}},top:function(){var b=c.top;return c.top<a.boundaries.top&&(b=Math.max(c.top,a.boundaries.top)),{top:b}},bottom:function(){var b=c.top;return c.bottom>a.boundaries.bottom&&(b=Math.min(c.top,a.boundaries.bottom-c.height)),{top:b}}};return b.forEach(function(b){a.offsets.popper=Object.assign(c,e[b]())}),a},a.prototype.modifiers.keepTogether=function(a){var b=d(a.offsets.popper),c=a.offsets.reference,e=Math.floor;return b.right<e(c.left)&&(a.offsets.popper.left=e(c.left)-b.width),b.left>e(c.right)&&(a.offsets.popper.left=e(c.right)),b.bottom<e(c.top)&&(a.offsets.popper.top=e(c.top)-b.height),b.top>e(c.bottom)&&(a.offsets.popper.top=e(c.bottom)),a},a.prototype.modifiers.flip=function(a){if(!this.isModifierRequired(this.modifiers.flip,this.modifiers.preventOverflow))return console.warn("WARNING: preventOverflow modifier is required by flip modifier in order to work, be sure to include it before flip!"),a;if(a.flipped&&a.placement===a._originalPlacement)return a;var b=a.placement.split("-")[0],e=c(b),f=a.placement.split("-")[1]||"",g=[];return g="flip"===this._options.flipBehavior?[b,e]:this._options.flipBehavior,g.forEach(function(h,i){if(b===h&&g.length!==i+1){b=a.placement.split("-")[0],e=c(b);var j=d(a.offsets.popper),k=-1!==["right","bottom"].indexOf(b);(k&&Math.floor(a.offsets.reference[b])>Math.floor(j[e])||!k&&Math.floor(a.offsets.reference[b])<Math.floor(j[e]))&&(a.flipped=!0,a.placement=g[i+1],f&&(a.placement+="-"+f),a.offsets.popper=this._getOffsets(this._popper,this._reference,a.placement).popper,a=this.runModifiers(a,this._options.modifiers,this._flip))}}.bind(this)),a},a.prototype.modifiers.offset=function(a){var b=this._options.offset,c=a.offsets.popper;return-1!==a.placement.indexOf("left")?c.top-=b:-1!==a.placement.indexOf("right")?c.top+=b:-1!==a.placement.indexOf("top")?c.left-=b:-1!==a.placement.indexOf("bottom")&&(c.left+=b),a},a.prototype.modifiers.arrow=function(a){var c=this._options.arrowElement;if("string"==typeof c&&(c=this._popper.querySelector(c)),!c)return a;if(!this._popper.contains(c))return console.warn("WARNING: `arrowElement` must be child of its popper element!"),a;if(!this.isModifierRequired(this.modifiers.arrow,this.modifiers.keepTogether))return console.warn("WARNING: keepTogether modifier is required by arrow modifier in order to work, be sure to include it before arrow!"),a;var e={},f=a.placement.split("-")[0],g=d(a.offsets.popper),h=a.offsets.reference,i=-1!==["left","right"].indexOf(f),j=i?"height":"width",k=i?"top":"left",l=i?"left":"top",m=i?"bottom":"right",n=b(c)[j];h[m]-n<g[k]&&(a.offsets.popper[k]-=g[k]-(h[m]-n)),h[k]+n>g[m]&&(a.offsets.popper[k]+=h[k]+n-g[m]);var o=h[k]+h[j]/2-n/2,p=o-d(a.offsets.popper)[k];return p=Math.max(Math.min(g[j]-n,p),0),e[k]=p,e[l]="",a.offsets.arrow=e,a.arrowElement=c,a},Object.assign||Object.defineProperty(Object,"assign",{enumerable:!1,configurable:!0,writable:!0,value:function(a){if(void 0===a||null===a)throw new TypeError("Cannot convert first argument to object");for(var b=Object(a),c=1;c<arguments.length;c++){var d=arguments[c];if(void 0!==d&&null!==d){d=Object(d);for(var e=Object.keys(d),f=0,g=e.length;g>f;f++){var h=e[f],i=Object.getOwnPropertyDescriptor(d,h);void 0!==i&&i.enumerable&&(b[h]=d[h])}}}return b}}),a});
//# sourceMappingURL=popper.min.js.map