# Contributing to post-robot

We are always looking for ways to make our modules better. Adding features and fixing bugs allows everyone who depends
on this code to create better, more stable applications.
Feel free to raise a pull request to us. Our team would review your proposed modifications and, if appropriate, merge
your changes into our code. Ideas and other comments are also welcome.

## Getting Started
1. Create your own [fork](https://help.github.com/articles/fork-a-repo) of this [repository](../../fork).
```bash
# Clone it
$ git clone git@github.com:me/post-robot.git

# Change directory
$ cd post-robot

# Add the upstream repo
$ git remote add upstream git://github.com/krakenjs/post-robot.git

# Get the latest upstream changes
$ git pull upstream

# Install dependencies
$ npm install

# Run scripts to verify installation
$ npm test
$ npm run-script lint
$ npm run-script cover
```

## Making Changes
1. Make sure that your changes adhere to the current coding conventions used throughout the project, indentation, accurate comments, etc.
2. Lint your code regularly and ensure it passes prior to submitting a PR:
`$ npm run lint`.
3. Ensure existing tests pass (`$ npm test`) and include test cases which fail without your change and succeed with it.

## Submitting Changes
1. Ensure that no errors are generated by ESLint.
2. Commit your changes in logical chunks, i.e. keep your changes small per single commit.
3. Locally merge (or rebase) the upstream branch into your topic branch: `$ git pull upstream && git merge`.
4. Push your topic branch up to your fork: `$ git push origin <topic-branch-name>`.
5. Open a [Pull Request](https://help.github.com/articles/using-pull-requests) with a clear title and description.

If you have any questions about contributing, please feel free to contact us by posting your questions on GitHub.

Copyright 2016, PayPal under [the Apache 2.0 license](LICENSE.txt).
