(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(factory.toString()).default;
	else if(typeof exports === 'object')
		exports["Quagga"] = factory(factory.toString()).default;
	else
		root["Quagga"] = factory(factory.toString()).default;
})(this, function(__factorySource__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].e;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			e: {},
/******/ 			i: moduleId,
/******/ 			l: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.e, module, module.e, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.e;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 156);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	
	var logDisabled_ = false;
	
	// Utility methods.
	var utils = {
	  disableLog: function(bool) {
	    if (typeof bool !== 'boolean') {
	      return new Error('Argument type: ' + typeof bool +
	          '. Please use a boolean.');
	    }
	    logDisabled_ = bool;
	    return (bool) ? 'adapter.js logging disabled' :
	        'adapter.js logging enabled';
	  },
	
	  log: function() {
	    if (typeof window === 'object') {
	      if (logDisabled_) {
	        return;
	      }
	      console.log.apply(console, arguments);
	    }
	  },
	
	   /**
	   * Extract browser version out of the provided user agent string.
	   * @param {!string} uastring userAgent string.
	   * @param {!string} expr Regular expression used as match criteria.
	   * @param {!number} pos position in the version string to be returned.
	   * @return {!number} browser version.
	   */
	  extractVersion: function(uastring, expr, pos) {
	    var match = uastring.match(expr);
	    return match && match.length >= pos && parseInt(match[pos], 10);
	  },
	
	  /**
	   * Browser detector.
	   * @return {object} result containing browser, version and minVersion
	   *     properties.
	   */
	  detectBrowser: function() {
	    // Returned result object.
	    var result = {};
	    result.browser = null;
	    result.version = null;
	    result.minVersion = null;
	
	    if (typeof window === 'undefined' || !window.navigator) {
	      result.browser = 'Not a browser.';
	      return result;
	    } else if (navigator.mozGetUserMedia) {
	      // Firefox.
	      result.browser = 'firefox';
	      result.version = this.extractVersion(navigator.userAgent,
	          /Firefox\/([0-9]+)\./, 1);
	      result.minVersion = 31;
	    } else if (navigator.webkitGetUserMedia && window.webkitRTCPeerConnection) {
	      // Chrome, Chromium, WebView, Opera and other WebKit browsers.
	      result.browser = 'chrome';
	      result.version = this.extractVersion(navigator.userAgent,
	          /Chrom(e|ium)\/([0-9]+)\./, 2);
	      result.minVersion = 38;
	    } else if(navigator.mediaDevices &&
	        navigator.userAgent.match(/Edge\/(\d+).(\d+)$/)) {
	      // Edge.
	      result.browser = 'edge';
	      result.version = this.extractVersion(navigator.userAgent,
	          /Edge\/(\d+).(\d+)$/, 2);
	      result.minVersion = 10547;
	    } else {
	      result.browser = 'Not a supported browser.';
	      return result;
	    }
	
	    // Warn if version is less than minVersion.
	    if (result.version < result.minVersion) {
	      utils.log('Browser: ' + result.browser + ' Version: ' + result.version +
	          ' < minimum supported version: ' + result.minVersion +
	          '\n some things might not work!');
	    }
	
	    return result;
	  }
	};
	
	// Export.
	module.e = {
	  log: utils.log,
	  disableLog: utils.disableLog,
	  browserDetails: utils.detectBrowser(),
	  extractVersion: utils.extractVersion
	};


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module, global) {var checkGlobal = __webpack_require__(106);
	
	/** Used to determine if values are of the language type `Object`. */
	var objectTypes = {
	  'function': true,
	  'object': true
	};
	
	/** Detect free variable `exports`. */
	var freeExports = (objectTypes[typeof exports] && exports && !exports.nodeType)
	  ? exports
	  : undefined;
	
	/** Detect free variable `module`. */
	var freeModule = (objectTypes[typeof module] && module && !module.nodeType)
	  ? module
	  : undefined;
	
	/** Detect free variable `global` from Node.js. */
	var freeGlobal = checkGlobal(freeExports && freeModule && typeof global == 'object' && global);
	
	/** Detect free variable `self`. */
	var freeSelf = checkGlobal(objectTypes[typeof self] && self);
	
	/** Detect free variable `window`. */
	var freeWindow = checkGlobal(objectTypes[typeof window] && window);
	
	/** Detect `this` as the global object. */
	var thisGlobal = checkGlobal(objectTypes[typeof this] && this);
	
	/**
	 * Used as a reference to the global object.
	 *
	 * The `this` value is used if it's the global object to avoid Greasemonkey's
	 * restricted `window` object, otherwise the `window` object is used.
	 */
	var root = freeGlobal ||
	  ((freeWindow !== (thisGlobal && thisGlobal.window)) && freeWindow) ||
	    freeSelf || thisGlobal || Function('return this')();
	
	module.e = root;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(48)(module), (function() { return this; }())))

/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Checks if `value` is the [language type](https://es5.github.io/#x8) of `Object`.
	 * (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
	 * @example
	 *
	 * _.isObject({});
	 * // => true
	 *
	 * _.isObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isObject(_.noop);
	 * // => true
	 *
	 * _.isObject(null);
	 * // => false
	 */
	function isObject(value) {
	  var type = typeof value;
	  return !!value && (type == 'object' || type == 'function');
	}
	
	module.e = isObject;


/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_merge__ = __webpack_require__(17);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_merge___default = __WEBPACK_IMPORTED_MODULE_0_lodash_merge__ && __WEBPACK_IMPORTED_MODULE_0_lodash_merge__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_lodash_merge__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_lodash_merge__; }
	/* harmony import */ Object.defineProperty(__WEBPACK_IMPORTED_MODULE_0_lodash_merge___default, 'a', { get: __WEBPACK_IMPORTED_MODULE_0_lodash_merge___default });
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__barcode_reader__ = __webpack_require__(6);
	
	
	var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };
	
	
	
	
	function EANReader(opts, supplements) {
	    opts = /* harmony import */__WEBPACK_IMPORTED_MODULE_0_lodash_merge___default.a.bind()(getDefaulConfig(), opts);
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_1__barcode_reader__["a"].call(this, opts, supplements);
	}
	
	function getDefaulConfig() {
	    var config = {};
	
	    Object.keys(EANReader.CONFIG_KEYS).forEach(function (key) {
	        config[key] = EANReader.CONFIG_KEYS[key].default;
	    });
	    return config;
	}
	
	var properties = {
	    CODE_L_START: { value: 0 },
	    CODE_G_START: { value: 10 },
	    START_PATTERN: { value: [1, 1, 1] },
	    STOP_PATTERN: { value: [1, 1, 1] },
	    MIDDLE_PATTERN: { value: [1, 1, 1, 1, 1] },
	    EXTENSION_START_PATTERN: { value: [1, 1, 2] },
	    CODE_PATTERN: { value: [[3, 2, 1, 1], [2, 2, 2, 1], [2, 1, 2, 2], [1, 4, 1, 1], [1, 1, 3, 2], [1, 2, 3, 1], [1, 1, 1, 4], [1, 3, 1, 2], [1, 2, 1, 3], [3, 1, 1, 2], [1, 1, 2, 3], [1, 2, 2, 2], [2, 2, 1, 2], [1, 1, 4, 1], [2, 3, 1, 1], [1, 3, 2, 1], [4, 1, 1, 1], [2, 1, 3, 1], [3, 1, 2, 1], [2, 1, 1, 3]] },
	    CODE_FREQUENCY: { value: [0, 11, 13, 14, 19, 25, 28, 21, 22, 26] },
	    SINGLE_CODE_ERROR: { value: 0.70 },
	    AVG_CODE_ERROR: { value: 0.48 },
	    FORMAT: { value: "ean_13", writeable: false }
	};
	
	EANReader.prototype = Object.create(/* harmony import */__WEBPACK_IMPORTED_MODULE_1__barcode_reader__["a"].prototype, properties);
	EANReader.prototype.constructor = EANReader;
	
	EANReader.prototype._decodeCode = function (start, coderange) {
	    var counter = [0, 0, 0, 0],
	        i,
	        self = this,
	        offset = start,
	        isWhite = !self._row[offset],
	        counterPos = 0,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: start,
	        end: start
	    },
	        code,
	        error;
	
	    if (!coderange) {
	        coderange = self.CODE_PATTERN.length;
	    }
	
	    for (i = offset; i < self._row.length; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            if (counterPos === counter.length - 1) {
	                for (code = 0; code < coderange; code++) {
	                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
	                    if (error < bestMatch.error) {
	                        bestMatch.code = code;
	                        bestMatch.error = error;
	                    }
	                }
	                bestMatch.end = i;
	                if (bestMatch.error > self.AVG_CODE_ERROR) {
	                    return null;
	                }
	                return bestMatch;
	            } else {
	                counterPos++;
	            }
	            counter[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return null;
	};
	
	EANReader.prototype._findPattern = function (pattern, offset, isWhite, tryHarder, epsilon) {
	    var counter = [],
	        self = this,
	        i,
	        counterPos = 0,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: 0,
	        end: 0
	    },
	        error,
	        j,
	        sum;
	
	    if (!offset) {
	        offset = self._nextSet(self._row);
	    }
	
	    if (isWhite === undefined) {
	        isWhite = false;
	    }
	
	    if (tryHarder === undefined) {
	        tryHarder = true;
	    }
	
	    if (epsilon === undefined) {
	        epsilon = self.AVG_CODE_ERROR;
	    }
	
	    for (i = 0; i < pattern.length; i++) {
	        counter[i] = 0;
	    }
	
	    for (i = offset; i < self._row.length; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            if (counterPos === counter.length - 1) {
	                sum = 0;
	                for (j = 0; j < counter.length; j++) {
	                    sum += counter[j];
	                }
	                error = self._matchPattern(counter, pattern);
	
	                if (error < epsilon) {
	                    bestMatch.error = error;
	                    bestMatch.start = i - sum;
	                    bestMatch.end = i;
	                    return bestMatch;
	                }
	                if (tryHarder) {
	                    for (j = 0; j < counter.length - 2; j++) {
	                        counter[j] = counter[j + 2];
	                    }
	                    counter[counter.length - 2] = 0;
	                    counter[counter.length - 1] = 0;
	                    counterPos--;
	                } else {
	                    return null;
	                }
	            } else {
	                counterPos++;
	            }
	            counter[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return null;
	};
	
	EANReader.prototype._findStart = function () {
	    var self = this,
	        leadingWhitespaceStart,
	        offset = self._nextSet(self._row),
	        startInfo;
	
	    while (!startInfo) {
	        startInfo = self._findPattern(self.START_PATTERN, offset);
	        if (!startInfo) {
	            return null;
	        }
	        leadingWhitespaceStart = startInfo.start - (startInfo.end - startInfo.start);
	        if (leadingWhitespaceStart >= 0) {
	            if (self._matchRange(leadingWhitespaceStart, startInfo.start, 0)) {
	                return startInfo;
	            }
	        }
	        offset = startInfo.end;
	        startInfo = null;
	    }
	};
	
	EANReader.prototype._verifyTrailingWhitespace = function (endInfo) {
	    var self = this,
	        trailingWhitespaceEnd;
	
	    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start);
	    if (trailingWhitespaceEnd < self._row.length) {
	        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
	            return endInfo;
	        }
	    }
	    return null;
	};
	
	EANReader.prototype._findEnd = function (offset, isWhite) {
	    var self = this,
	        endInfo = self._findPattern(self.STOP_PATTERN, offset, isWhite, false);
	
	    return endInfo !== null ? self._verifyTrailingWhitespace(endInfo) : null;
	};
	
	EANReader.prototype._calculateFirstDigit = function (codeFrequency) {
	    var i,
	        self = this;
	
	    for (i = 0; i < self.CODE_FREQUENCY.length; i++) {
	        if (codeFrequency === self.CODE_FREQUENCY[i]) {
	            return i;
	        }
	    }
	    return null;
	};
	
	EANReader.prototype._decodePayload = function (code, result, decodedCodes) {
	    var i,
	        self = this,
	        codeFrequency = 0x0,
	        firstDigit;
	
	    for (i = 0; i < 6; i++) {
	        code = self._decodeCode(code.end);
	        if (!code) {
	            return null;
	        }
	        if (code.code >= self.CODE_G_START) {
	            code.code = code.code - self.CODE_G_START;
	            codeFrequency |= 1 << 5 - i;
	        } else {
	            codeFrequency |= 0 << 5 - i;
	        }
	        result.push(code.code);
	        decodedCodes.push(code);
	    }
	
	    firstDigit = self._calculateFirstDigit(codeFrequency);
	    if (firstDigit === null) {
	        return null;
	    }
	    result.unshift(firstDigit);
	
	    code = self._findPattern(self.MIDDLE_PATTERN, code.end, true, false);
	    if (code === null) {
	        return null;
	    }
	    decodedCodes.push(code);
	
	    for (i = 0; i < 6; i++) {
	        code = self._decodeCode(code.end, self.CODE_G_START);
	        if (!code) {
	            return null;
	        }
	        decodedCodes.push(code);
	        result.push(code.code);
	    }
	
	    return code;
	};
	
	EANReader.prototype._decode = function () {
	    var startInfo,
	        self = this,
	        code,
	        result = [],
	        decodedCodes = [],
	        resultInfo = {};
	
	    startInfo = self._findStart();
	    if (!startInfo) {
	        return null;
	    }
	    code = {
	        code: startInfo.code,
	        start: startInfo.start,
	        end: startInfo.end
	    };
	    decodedCodes.push(code);
	    code = self._decodePayload(code, result, decodedCodes);
	    if (!code) {
	        return null;
	    }
	    code = self._findEnd(code.end, false);
	    if (!code) {
	        return null;
	    }
	
	    decodedCodes.push(code);
	
	    // Checksum
	    if (!self._checksum(result)) {
	        return null;
	    }
	
	    if (this.supplements.length > 0) {
	        var ext = this._decodeExtensions(code.end);
	        if (!ext) {
	            return null;
	        }
	        var lastCode = ext.decodedCodes[ext.decodedCodes.length - 1],
	            endInfo = {
	            start: lastCode.start + ((lastCode.end - lastCode.start) / 2 | 0),
	            end: lastCode.end
	        };
	        if (!self._verifyTrailingWhitespace(endInfo)) {
	            return null;
	        }
	        resultInfo = {
	            supplement: ext,
	            code: result.join("") + ext.code
	        };
	    }
	
	    return _extends({
	        code: result.join(""),
	        start: startInfo.start,
	        end: code.end,
	        codeset: "",
	        startInfo: startInfo,
	        decodedCodes: decodedCodes
	    }, resultInfo);
	};
	
	EANReader.prototype._decodeExtensions = function (offset) {
	    var i,
	        start = this._nextSet(this._row, offset),
	        startInfo = this._findPattern(this.EXTENSION_START_PATTERN, start, false, false),
	        result;
	
	    if (startInfo === null) {
	        return null;
	    }
	
	    for (i = 0; i < this.supplements.length; i++) {
	        result = this.supplements[i].decode(this._row, startInfo.end);
	        if (result !== null) {
	            return {
	                code: result.code,
	                start: start,
	                startInfo: startInfo,
	                end: result.end,
	                codeset: "",
	                decodedCodes: result.decodedCodes
	            };
	        }
	    }
	    return null;
	};
	
	EANReader.prototype._checksum = function (result) {
	    var sum = 0,
	        i;
	
	    for (i = result.length - 2; i >= 0; i -= 2) {
	        sum += result[i];
	    }
	    sum *= 3;
	    for (i = result.length - 1; i >= 0; i -= 2) {
	        sum += result[i];
	    }
	    return sum % 10 === 0;
	};
	
	EANReader.CONFIG_KEYS = {
	    supplements: {
	        'type': 'arrayOf(string)',
	        'default': [],
	        'description': 'Allowed extensions to be decoded (2 and/or 5)'
	    }
	};
	
	/* harmony default export */ exports["a"] = EANReader;

/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	var getNative = __webpack_require__(12),
	    root = __webpack_require__(1);
	
	/* Built-in method references that are verified to be native. */
	var Map = getNative(root, 'Map');
	
	module.e = Map;


/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Checks if `value` is classified as an `Array` object.
	 *
	 * @static
	 * @memberOf _
	 * @type {Function}
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
	 * @example
	 *
	 * _.isArray([1, 2, 3]);
	 * // => true
	 *
	 * _.isArray(document.body.children);
	 * // => false
	 *
	 * _.isArray('abc');
	 * // => false
	 *
	 * _.isArray(_.noop);
	 * // => false
	 */
	var isArray = Array.isArray;
	
	module.e = isArray;


/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

	function BarcodeReader(config, supplements) {
	    this._row = [];
	    this.config = config || {};
	    this.supplements = supplements;
	    return this;
	}
	
	BarcodeReader.prototype._nextUnset = function (line, start) {
	    var i;
	
	    if (start === undefined) {
	        start = 0;
	    }
	    for (i = start; i < line.length; i++) {
	        if (!line[i]) {
	            return i;
	        }
	    }
	    return line.length;
	};
	
	BarcodeReader.prototype._matchPattern = function (counter, code, maxSingleError) {
	    var i,
	        error = 0,
	        singleError = 0,
	        sum = 0,
	        modulo = 0,
	        barWidth,
	        count,
	        scaled;
	
	    maxSingleError = maxSingleError || this.SINGLE_CODE_ERROR || 1;
	
	    for (i = 0; i < counter.length; i++) {
	        sum += counter[i];
	        modulo += code[i];
	    }
	    if (sum < modulo) {
	        return Number.MAX_VALUE;
	    }
	    barWidth = sum / modulo;
	    maxSingleError *= barWidth;
	
	    for (i = 0; i < counter.length; i++) {
	        count = counter[i];
	        scaled = code[i] * barWidth;
	        singleError = Math.abs(count - scaled) / scaled;
	        if (singleError > maxSingleError) {
	            return Number.MAX_VALUE;
	        }
	        error += singleError;
	    }
	    return error / modulo;
	};
	
	BarcodeReader.prototype._nextSet = function (line, offset) {
	    var i;
	
	    offset = offset || 0;
	    for (i = offset; i < line.length; i++) {
	        if (line[i]) {
	            return i;
	        }
	    }
	    return line.length;
	};
	
	BarcodeReader.prototype._correctBars = function (counter, correction, indices) {
	    var length = indices.length,
	        tmp = 0;
	    while (length--) {
	        tmp = counter[indices[length]] * (1 - (1 - correction) / 2);
	        if (tmp > 1) {
	            counter[indices[length]] = tmp;
	        }
	    }
	};
	
	BarcodeReader.prototype._matchTrace = function (cmpCounter, epsilon) {
	    var counter = [],
	        i,
	        self = this,
	        offset = self._nextSet(self._row),
	        isWhite = !self._row[offset],
	        counterPos = 0,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: 0
	    },
	        error;
	
	    if (cmpCounter) {
	        for (i = 0; i < cmpCounter.length; i++) {
	            counter.push(0);
	        }
	        for (i = offset; i < self._row.length; i++) {
	            if (self._row[i] ^ isWhite) {
	                counter[counterPos]++;
	            } else {
	                if (counterPos === counter.length - 1) {
	                    error = self._matchPattern(counter, cmpCounter);
	
	                    if (error < epsilon) {
	                        bestMatch.start = i - offset;
	                        bestMatch.end = i;
	                        bestMatch.counter = counter;
	                        return bestMatch;
	                    } else {
	                        return null;
	                    }
	                } else {
	                    counterPos++;
	                }
	                counter[counterPos] = 1;
	                isWhite = !isWhite;
	            }
	        }
	    } else {
	        counter.push(0);
	        for (i = offset; i < self._row.length; i++) {
	            if (self._row[i] ^ isWhite) {
	                counter[counterPos]++;
	            } else {
	                counterPos++;
	                counter.push(0);
	                counter[counterPos] = 1;
	                isWhite = !isWhite;
	            }
	        }
	    }
	
	    // if cmpCounter was not given
	    bestMatch.start = offset;
	    bestMatch.end = self._row.length - 1;
	    bestMatch.counter = counter;
	    return bestMatch;
	};
	
	BarcodeReader.prototype.decodePattern = function (pattern) {
	    var self = this,
	        result;
	
	    self._row = pattern;
	    result = self._decode();
	    if (result === null) {
	        self._row.reverse();
	        result = self._decode();
	        if (result) {
	            result.direction = BarcodeReader.DIRECTION.REVERSE;
	            result.start = self._row.length - result.start;
	            result.end = self._row.length - result.end;
	        }
	    } else {
	        result.direction = BarcodeReader.DIRECTION.FORWARD;
	    }
	    if (result) {
	        result.format = self.FORMAT;
	    }
	    return result;
	};
	
	BarcodeReader.prototype._matchRange = function (start, end, value) {
	    var i;
	
	    start = start < 0 ? 0 : start;
	    for (i = start; i < end; i++) {
	        if (this._row[i] !== value) {
	            return false;
	        }
	    }
	    return true;
	};
	
	BarcodeReader.prototype._fillCounters = function (offset, end, isWhite) {
	    var self = this,
	        counterPos = 0,
	        i,
	        counters = [];
	
	    isWhite = typeof isWhite !== 'undefined' ? isWhite : true;
	    offset = typeof offset !== 'undefined' ? offset : self._nextUnset(self._row);
	    end = end || self._row.length;
	
	    counters[counterPos] = 0;
	    for (i = offset; i < end; i++) {
	        if (self._row[i] ^ isWhite) {
	            counters[counterPos]++;
	        } else {
	            counterPos++;
	            counters[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return counters;
	};
	
	Object.defineProperty(BarcodeReader.prototype, "FORMAT", {
	    value: 'unknown',
	    writeable: false
	});
	
	BarcodeReader.DIRECTION = {
	    FORWARD: 1,
	    REVERSE: -1
	};
	
	BarcodeReader.Exception = {
	    StartNotFoundException: "Start-Info was not found!",
	    CodeNotFoundException: "Code could not be found!",
	    PatternNotFoundException: "Pattern could not be found!"
	};
	
	BarcodeReader.CONFIG_KEYS = {};
	
	/* harmony default export */ exports["a"] = BarcodeReader;

/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	module.e = clone
	
	/**
	 * Creates a new vec2 initialized with values from an existing vector
	 *
	 * @param {vec2} a vector to clone
	 * @returns {vec2} a new 2D vector
	 */
	function clone(a) {
	    var out = new Float32Array(2)
	    out[0] = a[0]
	    out[1] = a[1]
	    return out
	}

/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Checks if `value` is object-like. A value is object-like if it's not `null`
	 * and has a `typeof` result of "object".
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
	 * @example
	 *
	 * _.isObjectLike({});
	 * // => true
	 *
	 * _.isObjectLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isObjectLike(_.noop);
	 * // => false
	 *
	 * _.isObjectLike(null);
	 * // => false
	 */
	function isObjectLike(value) {
	  return !!value && typeof value == 'object';
	}
	
	module.e = isObjectLike;


/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony default export */ exports["a"] = {
	    init: function init(arr, val) {
	        var l = arr.length;
	        while (l--) {
	            arr[l] = val;
	        }
	    },
	
	    /**
	     * Shuffles the content of an array
	     * @return {Array} the array itself shuffled
	     */
	    shuffle: function shuffle(arr) {
	        var i = arr.length - 1,
	            j,
	            x;
	        for (i; i >= 0; i--) {
	            j = Math.floor(Math.random() * i);
	            x = arr[i];
	            arr[i] = arr[j];
	            arr[j] = x;
	        }
	        return arr;
	    },
	
	    toPointList: function toPointList(arr) {
	        var i,
	            j,
	            row = [],
	            rows = [];
	        for (i = 0; i < arr.length; i++) {
	            row = [];
	            for (j = 0; j < arr[i].length; j++) {
	                row[j] = arr[i][j];
	            }
	            rows[i] = "[" + row.join(",") + "]";
	        }
	        return "[" + rows.join(",\r\n") + "]";
	    },
	
	    /**
	     * returns the elements which's score is bigger than the threshold
	     * @return {Array} the reduced array
	     */
	    threshold: function threshold(arr, _threshold, scoreFunc) {
	        var i,
	            queue = [];
	        for (i = 0; i < arr.length; i++) {
	            if (scoreFunc.apply(arr, [arr[i]]) >= _threshold) {
	                queue.push(arr[i]);
	            }
	        }
	        return queue;
	    },
	
	    maxIndex: function maxIndex(arr) {
	        var i,
	            max = 0;
	        for (i = 0; i < arr.length; i++) {
	            if (arr[i] > arr[max]) {
	                max = i;
	            }
	        }
	        return max;
	    },
	
	    max: function max(arr) {
	        var i,
	            max = 0;
	        for (i = 0; i < arr.length; i++) {
	            if (arr[i] > max) {
	                max = arr[i];
	            }
	        }
	        return max;
	    },
	
	    sum: function sum(arr) {
	        var length = arr.length,
	            sum = 0;
	
	        while (length--) {
	            sum += arr[length];
	        }
	        return sum;
	    }
	};

/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony default export */ exports["a"] = {
	    drawRect: function drawRect(pos, size, ctx, style) {
	        ctx.strokeStyle = style.color;
	        ctx.fillStyle = style.color;
	        ctx.lineWidth = 1;
	        ctx.beginPath();
	        ctx.strokeRect(pos.x, pos.y, size.x, size.y);
	    },
	    drawPath: function drawPath(path, def, ctx, style) {
	        ctx.strokeStyle = style.color;
	        ctx.fillStyle = style.color;
	        ctx.lineWidth = style.lineWidth;
	        ctx.beginPath();
	        ctx.moveTo(path[0][def.x], path[0][def.y]);
	        for (var j = 1; j < path.length; j++) {
	            ctx.lineTo(path[j][def.x], path[j][def.y]);
	        }
	        ctx.closePath();
	        ctx.stroke();
	    },
	    drawImage: function drawImage(imageData, size, ctx) {
	        var canvasData = ctx.getImageData(0, 0, size.x, size.y),
	            data = canvasData.data,
	            imageDataPos = imageData.length,
	            canvasDataPos = data.length,
	            value;
	
	        if (canvasDataPos / imageDataPos !== 4) {
	            return false;
	        }
	        while (imageDataPos--) {
	            value = imageData[imageDataPos];
	            data[--canvasDataPos] = 255;
	            data[--canvasDataPos] = value;
	            data[--canvasDataPos] = value;
	            data[--canvasDataPos] = value;
	        }
	        ctx.putImageData(canvasData, 0, 0);
	        return true;
	    }
	};

/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	var eq = __webpack_require__(15);
	
	/**
	 * Gets the index at which the first occurrence of `key` is found in `array`
	 * of key-value pairs.
	 *
	 * @private
	 * @param {Array} array The array to search.
	 * @param {*} key The key to search for.
	 * @returns {number} Returns the index of the matched value, else `-1`.
	 */
	function assocIndexOf(array, key) {
	  var length = array.length;
	  while (length--) {
	    if (eq(array[length][0], key)) {
	      return length;
	    }
	  }
	  return -1;
	}
	
	module.e = assocIndexOf;


/***/ },
/* 12 */
/***/ function(module, exports, __webpack_require__) {

	var isNative = __webpack_require__(142);
	
	/**
	 * Gets the native function at `key` of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {string} key The key of the method to get.
	 * @returns {*} Returns the function if it's native, else `undefined`.
	 */
	function getNative(object, key) {
	  var value = object[key];
	  return isNative(value) ? value : undefined;
	}
	
	module.e = getNative;


/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Checks if `value` is suitable for use as unique object key.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
	 */
	function isKeyable(value) {
	  var type = typeof value;
	  return type == 'number' || type == 'boolean' ||
	    (type == 'string' && value != '__proto__') || value == null;
	}
	
	module.e = isKeyable;


/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	var getNative = __webpack_require__(12);
	
	/* Built-in method references that are verified to be native. */
	var nativeCreate = getNative(Object, 'create');
	
	module.e = nativeCreate;


/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Performs a [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
	 * comparison between two values to determine if they are equivalent.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to compare.
	 * @param {*} other The other value to compare.
	 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
	 * @example
	 *
	 * var object = { 'user': 'fred' };
	 * var other = { 'user': 'fred' };
	 *
	 * _.eq(object, object);
	 * // => true
	 *
	 * _.eq(object, other);
	 * // => false
	 *
	 * _.eq('a', 'a');
	 * // => true
	 *
	 * _.eq('a', Object('a'));
	 * // => false
	 *
	 * _.eq(NaN, NaN);
	 * // => true
	 */
	function eq(value, other) {
	  return value === other || (value !== value && other !== other);
	}
	
	module.e = eq;


/***/ },
/* 16 */
/***/ function(module, exports, __webpack_require__) {

	var isObject = __webpack_require__(2);
	
	/** `Object#toString` result references. */
	var funcTag = '[object Function]',
	    genTag = '[object GeneratorFunction]';
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/**
	 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;
	
	/**
	 * Checks if `value` is classified as a `Function` object.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
	 * @example
	 *
	 * _.isFunction(_);
	 * // => true
	 *
	 * _.isFunction(/abc/);
	 * // => false
	 */
	function isFunction(value) {
	  // The use of `Object#toString` avoids issues with the `typeof` operator
	  // in Safari 8 which returns 'object' for typed array and weak map constructors,
	  // and PhantomJS 1.9 which returns 'function' for `NodeList` instances.
	  var tag = isObject(value) ? objectToString.call(value) : '';
	  return tag == funcTag || tag == genTag;
	}
	
	module.e = isFunction;


/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	var baseMerge = __webpack_require__(101),
	    createAssigner = __webpack_require__(115);
	
	/**
	 * This method is like `_.assign` except that it recursively merges own and
	 * inherited enumerable properties of source objects into the destination
	 * object. Source properties that resolve to `undefined` are skipped if a
	 * destination value exists. Array and plain object properties are merged
	 * recursively.Other objects and value types are overridden by assignment.
	 * Source objects are applied from left to right. Subsequent sources
	 * overwrite property assignments of previous sources.
	 *
	 * **Note:** This method mutates `object`.
	 *
	 * @static
	 * @memberOf _
	 * @category Object
	 * @param {Object} object The destination object.
	 * @param {...Object} [sources] The source objects.
	 * @returns {Object} Returns `object`.
	 * @example
	 *
	 * var users = {
	 *   'data': [{ 'user': 'barney' }, { 'user': 'fred' }]
	 * };
	 *
	 * var ages = {
	 *   'data': [{ 'age': 36 }, { 'age': 40 }]
	 * };
	 *
	 * _.merge(users, ages);
	 * // => { 'data': [{ 'user': 'barney', 'age': 36 }, { 'user': 'fred', 'age': 40 }] }
	 */
	var merge = createAssigner(function(object, source, srcIndex) {
	  baseMerge(object, source, srcIndex);
	});
	
	module.e = merge;


/***/ },
/* 18 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__cluster__ = __webpack_require__(51);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__array_helper__ = __webpack_require__(9);
	/* harmony export */ exports["f"] = imageRef;/* unused harmony export computeIntegralImage2 *//* unused harmony export computeIntegralImage *//* unused harmony export thresholdImage *//* unused harmony export computeHistogram *//* unused harmony export sharpenLine *//* unused harmony export determineOtsuThreshold *//* harmony export */ exports["c"] = otsuThreshold;/* unused harmony export computeBinaryImage *//* harmony export */ exports["d"] = cluster;/* unused harmony export dilate *//* unused harmony export erode *//* unused harmony export subtract *//* unused harmony export bitwiseOr *//* unused harmony export countNonZero *//* harmony export */ exports["e"] = topGeneric;/* unused harmony export grayArrayFromImage *//* unused harmony export grayArrayFromContext *//* harmony export */ exports["i"] = grayAndHalfSampleFromCanvasData;/* harmony export */ exports["j"] = computeGray;/* unused harmony export loadImageArray *//* harmony export */ exports["g"] = halfSample;/* harmony export */ exports["a"] = hsv2rgb;/* unused harmony export _computeDivisors *//* harmony export */ exports["b"] = calculatePatchSize;/* unused harmony export _parseCSSDimensionValues *//* harmony export */ exports["h"] = computeImageArea;
	
	var vec2 = {
	    clone: __webpack_require__(7)
	};
	var vec3 = {
	    clone: __webpack_require__(80)
	};
	
	/**
	 * @param x x-coordinate
	 * @param y y-coordinate
	 * @return ImageReference {x,y} Coordinate
	 */
	function imageRef(x, y) {
	    var that = {
	        x: x,
	        y: y,
	        toVec2: function toVec2() {
	            return vec2.clone([this.x, this.y]);
	        },
	        toVec3: function toVec3() {
	            return vec3.clone([this.x, this.y, 1]);
	        },
	        round: function round() {
	            this.x = this.x > 0.0 ? Math.floor(this.x + 0.5) : Math.floor(this.x - 0.5);
	            this.y = this.y > 0.0 ? Math.floor(this.y + 0.5) : Math.floor(this.y - 0.5);
	            return this;
	        }
	    };
	    return that;
	};
	
	/**
	 * Computes an integral image of a given grayscale image.
	 * @param imageDataContainer {ImageDataContainer} the image to be integrated
	 */
	function computeIntegralImage2(imageWrapper, integralWrapper) {
	    var imageData = imageWrapper.data;
	    var width = imageWrapper.size.x;
	    var height = imageWrapper.size.y;
	    var integralImageData = integralWrapper.data;
	    var sum = 0,
	        posA = 0,
	        posB = 0,
	        posC = 0,
	        posD = 0,
	        x,
	        y;
	
	    // sum up first column
	    posB = width;
	    sum = 0;
	    for (y = 1; y < height; y++) {
	        sum += imageData[posA];
	        integralImageData[posB] += sum;
	        posA += width;
	        posB += width;
	    }
	
	    posA = 0;
	    posB = 1;
	    sum = 0;
	    for (x = 1; x < width; x++) {
	        sum += imageData[posA];
	        integralImageData[posB] += sum;
	        posA++;
	        posB++;
	    }
	
	    for (y = 1; y < height; y++) {
	        posA = y * width + 1;
	        posB = (y - 1) * width + 1;
	        posC = y * width;
	        posD = (y - 1) * width;
	        for (x = 1; x < width; x++) {
	            integralImageData[posA] += imageData[posA] + integralImageData[posB] + integralImageData[posC] - integralImageData[posD];
	            posA++;
	            posB++;
	            posC++;
	            posD++;
	        }
	    }
	};
	
	function computeIntegralImage(imageWrapper, integralWrapper) {
	    var imageData = imageWrapper.data;
	    var width = imageWrapper.size.x;
	    var height = imageWrapper.size.y;
	    var integralImageData = integralWrapper.data;
	    var sum = 0;
	
	    // sum up first row
	    for (var i = 0; i < width; i++) {
	        sum += imageData[i];
	        integralImageData[i] = sum;
	    }
	
	    for (var v = 1; v < height; v++) {
	        sum = 0;
	        for (var u = 0; u < width; u++) {
	            sum += imageData[v * width + u];
	            integralImageData[v * width + u] = sum + integralImageData[(v - 1) * width + u];
	        }
	    }
	};
	
	function thresholdImage(imageWrapper, threshold, targetWrapper) {
	    if (!targetWrapper) {
	        targetWrapper = imageWrapper;
	    }
	    var imageData = imageWrapper.data,
	        length = imageData.length,
	        targetData = targetWrapper.data;
	
	    while (length--) {
	        targetData[length] = imageData[length] < threshold ? 1 : 0;
	    }
	};
	
	function computeHistogram(imageWrapper, bitsPerPixel) {
	    if (!bitsPerPixel) {
	        bitsPerPixel = 8;
	    }
	    var imageData = imageWrapper.data,
	        length = imageData.length,
	        bitShift = 8 - bitsPerPixel,
	        bucketCnt = 1 << bitsPerPixel,
	        hist = new Int32Array(bucketCnt);
	
	    while (length--) {
	        hist[imageData[length] >> bitShift]++;
	    }
	    return hist;
	};
	
	function sharpenLine(line) {
	    var i,
	        length = line.length,
	        left = line[0],
	        center = line[1],
	        right;
	
	    for (i = 1; i < length - 1; i++) {
	        right = line[i + 1];
	        //  -1 4 -1 kernel
	        line[i - 1] = center * 2 - left - right & 255;
	        left = center;
	        center = right;
	    }
	    return line;
	};
	
	function determineOtsuThreshold(imageWrapper, bitsPerPixel) {
	    if (!bitsPerPixel) {
	        bitsPerPixel = 8;
	    }
	    var hist,
	        threshold,
	        bitShift = 8 - bitsPerPixel;
	
	    function px(init, end) {
	        var sum = 0,
	            i;
	        for (i = init; i <= end; i++) {
	            sum += hist[i];
	        }
	        return sum;
	    }
	
	    function mx(init, end) {
	        var i,
	            sum = 0;
	
	        for (i = init; i <= end; i++) {
	            sum += i * hist[i];
	        }
	
	        return sum;
	    }
	
	    function determineThreshold() {
	        var vet = [0],
	            p1,
	            p2,
	            p12,
	            k,
	            m1,
	            m2,
	            m12,
	            max = (1 << bitsPerPixel) - 1;
	
	        hist = computeHistogram(imageWrapper, bitsPerPixel);
	        for (k = 1; k < max; k++) {
	            p1 = px(0, k);
	            p2 = px(k + 1, max);
	            p12 = p1 * p2;
	            if (p12 === 0) {
	                p12 = 1;
	            }
	            m1 = mx(0, k) * p2;
	            m2 = mx(k + 1, max) * p1;
	            m12 = m1 - m2;
	            vet[k] = m12 * m12 / p12;
	        }
	        return /* harmony import */__WEBPACK_IMPORTED_MODULE_1__array_helper__["a"].maxIndex(vet);
	    }
	
	    threshold = determineThreshold();
	    return threshold << bitShift;
	};
	
	function otsuThreshold(imageWrapper, targetWrapper) {
	    var threshold = determineOtsuThreshold(imageWrapper);
	
	    thresholdImage(imageWrapper, threshold, targetWrapper);
	    return threshold;
	};
	
	// local thresholding
	function computeBinaryImage(imageWrapper, integralWrapper, targetWrapper) {
	    computeIntegralImage(imageWrapper, integralWrapper);
	
	    if (!targetWrapper) {
	        targetWrapper = imageWrapper;
	    }
	    var imageData = imageWrapper.data;
	    var targetData = targetWrapper.data;
	    var width = imageWrapper.size.x;
	    var height = imageWrapper.size.y;
	    var integralImageData = integralWrapper.data;
	    var sum = 0,
	        v,
	        u,
	        kernel = 3,
	        A,
	        B,
	        C,
	        D,
	        avg,
	        size = (kernel * 2 + 1) * (kernel * 2 + 1);
	
	    // clear out top & bottom-border
	    for (v = 0; v <= kernel; v++) {
	        for (u = 0; u < width; u++) {
	            targetData[v * width + u] = 0;
	            targetData[(height - 1 - v) * width + u] = 0;
	        }
	    }
	
	    // clear out left & right border
	    for (v = kernel; v < height - kernel; v++) {
	        for (u = 0; u <= kernel; u++) {
	            targetData[v * width + u] = 0;
	            targetData[v * width + (width - 1 - u)] = 0;
	        }
	    }
	
	    for (v = kernel + 1; v < height - kernel - 1; v++) {
	        for (u = kernel + 1; u < width - kernel; u++) {
	            A = integralImageData[(v - kernel - 1) * width + (u - kernel - 1)];
	            B = integralImageData[(v - kernel - 1) * width + (u + kernel)];
	            C = integralImageData[(v + kernel) * width + (u - kernel - 1)];
	            D = integralImageData[(v + kernel) * width + (u + kernel)];
	            sum = D - C - B + A;
	            avg = sum / size;
	            targetData[v * width + u] = imageData[v * width + u] > avg + 5 ? 0 : 1;
	        }
	    }
	};
	
	function cluster(points, threshold, property) {
	    var i,
	        k,
	        cluster,
	        point,
	        clusters = [];
	
	    if (!property) {
	        property = "rad";
	    }
	
	    function addToCluster(newPoint) {
	        var found = false;
	        for (k = 0; k < clusters.length; k++) {
	            cluster = clusters[k];
	            if (cluster.fits(newPoint)) {
	                cluster.add(newPoint);
	                found = true;
	            }
	        }
	        return found;
	    }
	
	    // iterate over each cloud
	    for (i = 0; i < points.length; i++) {
	        point = /* harmony import */__WEBPACK_IMPORTED_MODULE_0__cluster__["a"].createPoint(points[i], i, property);
	        if (!addToCluster(point)) {
	            clusters.push(/* harmony import */__WEBPACK_IMPORTED_MODULE_0__cluster__["a"].create(point, threshold));
	        }
	    }
	    return clusters;
	};
	
	var Tracer = {
	    trace: function trace(points, vec) {
	        var iteration,
	            maxIterations = 10,
	            top = [],
	            result = [],
	            centerPos = 0,
	            currentPos = 0;
	
	        function trace(idx, forward) {
	            var from,
	                to,
	                toIdx,
	                predictedPos,
	                thresholdX = 1,
	                thresholdY = Math.abs(vec[1] / 10),
	                found = false;
	
	            function match(pos, predicted) {
	                if (pos.x > predicted.x - thresholdX && pos.x < predicted.x + thresholdX && pos.y > predicted.y - thresholdY && pos.y < predicted.y + thresholdY) {
	                    return true;
	                } else {
	                    return false;
	                }
	            }
	
	            // check if the next index is within the vec specifications
	            // if not, check as long as the threshold is met
	
	            from = points[idx];
	            if (forward) {
	                predictedPos = {
	                    x: from.x + vec[0],
	                    y: from.y + vec[1]
	                };
	            } else {
	                predictedPos = {
	                    x: from.x - vec[0],
	                    y: from.y - vec[1]
	                };
	            }
	
	            toIdx = forward ? idx + 1 : idx - 1;
	            to = points[toIdx];
	            while (to && (found = match(to, predictedPos)) !== true && Math.abs(to.y - from.y) < vec[1]) {
	                toIdx = forward ? toIdx + 1 : toIdx - 1;
	                to = points[toIdx];
	            }
	
	            return found ? toIdx : null;
	        }
	
	        for (iteration = 0; iteration < maxIterations; iteration++) {
	            // randomly select point to start with
	            centerPos = Math.floor(Math.random() * points.length);
	
	            // trace forward
	            top = [];
	            currentPos = centerPos;
	            top.push(points[currentPos]);
	            while ((currentPos = trace(currentPos, true)) !== null) {
	                top.push(points[currentPos]);
	            }
	            if (centerPos > 0) {
	                currentPos = centerPos;
	                while ((currentPos = trace(currentPos, false)) !== null) {
	                    top.push(points[currentPos]);
	                }
	            }
	
	            if (top.length > result.length) {
	                result = top;
	            }
	        }
	        return result;
	    }
	};/* unused harmony export Tracer */
	
	var DILATE = 1;/* unused harmony export DILATE */
	var ERODE = 2;/* unused harmony export ERODE */
	
	function dilate(inImageWrapper, outImageWrapper) {
	    var v,
	        u,
	        inImageData = inImageWrapper.data,
	        outImageData = outImageWrapper.data,
	        height = inImageWrapper.size.y,
	        width = inImageWrapper.size.x,
	        sum,
	        yStart1,
	        yStart2,
	        xStart1,
	        xStart2;
	
	    for (v = 1; v < height - 1; v++) {
	        for (u = 1; u < width - 1; u++) {
	            yStart1 = v - 1;
	            yStart2 = v + 1;
	            xStart1 = u - 1;
	            xStart2 = u + 1;
	            sum = inImageData[yStart1 * width + xStart1] + inImageData[yStart1 * width + xStart2] + inImageData[v * width + u] + inImageData[yStart2 * width + xStart1] + inImageData[yStart2 * width + xStart2];
	            outImageData[v * width + u] = sum > 0 ? 1 : 0;
	        }
	    }
	};
	
	function erode(inImageWrapper, outImageWrapper) {
	    var v,
	        u,
	        inImageData = inImageWrapper.data,
	        outImageData = outImageWrapper.data,
	        height = inImageWrapper.size.y,
	        width = inImageWrapper.size.x,
	        sum,
	        yStart1,
	        yStart2,
	        xStart1,
	        xStart2;
	
	    for (v = 1; v < height - 1; v++) {
	        for (u = 1; u < width - 1; u++) {
	            yStart1 = v - 1;
	            yStart2 = v + 1;
	            xStart1 = u - 1;
	            xStart2 = u + 1;
	            sum = inImageData[yStart1 * width + xStart1] + inImageData[yStart1 * width + xStart2] + inImageData[v * width + u] + inImageData[yStart2 * width + xStart1] + inImageData[yStart2 * width + xStart2];
	            outImageData[v * width + u] = sum === 5 ? 1 : 0;
	        }
	    }
	};
	
	function subtract(aImageWrapper, bImageWrapper, resultImageWrapper) {
	    if (!resultImageWrapper) {
	        resultImageWrapper = aImageWrapper;
	    }
	    var length = aImageWrapper.data.length,
	        aImageData = aImageWrapper.data,
	        bImageData = bImageWrapper.data,
	        cImageData = resultImageWrapper.data;
	
	    while (length--) {
	        cImageData[length] = aImageData[length] - bImageData[length];
	    }
	};
	
	function bitwiseOr(aImageWrapper, bImageWrapper, resultImageWrapper) {
	    if (!resultImageWrapper) {
	        resultImageWrapper = aImageWrapper;
	    }
	    var length = aImageWrapper.data.length,
	        aImageData = aImageWrapper.data,
	        bImageData = bImageWrapper.data,
	        cImageData = resultImageWrapper.data;
	
	    while (length--) {
	        cImageData[length] = aImageData[length] || bImageData[length];
	    }
	};
	
	function countNonZero(imageWrapper) {
	    var length = imageWrapper.data.length,
	        data = imageWrapper.data,
	        sum = 0;
	
	    while (length--) {
	        sum += data[length];
	    }
	    return sum;
	};
	
	function topGeneric(list, top, scoreFunc) {
	    var i,
	        minIdx = 0,
	        min = 0,
	        queue = [],
	        score,
	        hit,
	        pos;
	
	    for (i = 0; i < top; i++) {
	        queue[i] = {
	            score: 0,
	            item: null
	        };
	    }
	
	    for (i = 0; i < list.length; i++) {
	        score = scoreFunc.apply(this, [list[i]]);
	        if (score > min) {
	            hit = queue[minIdx];
	            hit.score = score;
	            hit.item = list[i];
	            min = Number.MAX_VALUE;
	            for (pos = 0; pos < top; pos++) {
	                if (queue[pos].score < min) {
	                    min = queue[pos].score;
	                    minIdx = pos;
	                }
	            }
	        }
	    }
	
	    return queue;
	};
	
	function grayArrayFromImage(htmlImage, offsetX, ctx, array) {
	    ctx.drawImage(htmlImage, offsetX, 0, htmlImage.width, htmlImage.height);
	    var ctxData = ctx.getImageData(offsetX, 0, htmlImage.width, htmlImage.height).data;
	    computeGray(ctxData, array);
	};
	
	function grayArrayFromContext(ctx, size, offset, array) {
	    var ctxData = ctx.getImageData(offset.x, offset.y, size.x, size.y).data;
	    computeGray(ctxData, array);
	};
	
	function grayAndHalfSampleFromCanvasData(canvasData, size, outArray) {
	    var topRowIdx = 0;
	    var bottomRowIdx = size.x;
	    var endIdx = Math.floor(canvasData.length / 4);
	    var outWidth = size.x / 2;
	    var outImgIdx = 0;
	    var inWidth = size.x;
	    var i;
	
	    while (bottomRowIdx < endIdx) {
	        for (i = 0; i < outWidth; i++) {
	            outArray[outImgIdx] = Math.floor((0.299 * canvasData[topRowIdx * 4 + 0] + 0.587 * canvasData[topRowIdx * 4 + 1] + 0.114 * canvasData[topRowIdx * 4 + 2] + (0.299 * canvasData[(topRowIdx + 1) * 4 + 0] + 0.587 * canvasData[(topRowIdx + 1) * 4 + 1] + 0.114 * canvasData[(topRowIdx + 1) * 4 + 2]) + (0.299 * canvasData[bottomRowIdx * 4 + 0] + 0.587 * canvasData[bottomRowIdx * 4 + 1] + 0.114 * canvasData[bottomRowIdx * 4 + 2]) + (0.299 * canvasData[(bottomRowIdx + 1) * 4 + 0] + 0.587 * canvasData[(bottomRowIdx + 1) * 4 + 1] + 0.114 * canvasData[(bottomRowIdx + 1) * 4 + 2])) / 4);
	            outImgIdx++;
	            topRowIdx = topRowIdx + 2;
	            bottomRowIdx = bottomRowIdx + 2;
	        }
	        topRowIdx = topRowIdx + inWidth;
	        bottomRowIdx = bottomRowIdx + inWidth;
	    }
	};
	
	function computeGray(imageData, outArray, config) {
	    var l = imageData.length / 4 | 0,
	        i,
	        singleChannel = config && config.singleChannel === true;
	
	    if (singleChannel) {
	        for (i = 0; i < l; i++) {
	            outArray[i] = imageData[i * 4 + 0];
	        }
	    } else {
	        for (i = 0; i < l; i++) {
	            outArray[i] = Math.floor(0.299 * imageData[i * 4 + 0] + 0.587 * imageData[i * 4 + 1] + 0.114 * imageData[i * 4 + 2]);
	        }
	    }
	};
	
	function loadImageArray(src, callback, canvas) {
	    if (!canvas) {
	        canvas = document.createElement('canvas');
	    }
	    var img = new Image();
	    img.callback = callback;
	    img.onload = function () {
	        canvas.width = this.width;
	        canvas.height = this.height;
	        var ctx = canvas.getContext('2d');
	        ctx.drawImage(this, 0, 0);
	        var array = new Uint8Array(this.width * this.height);
	        ctx.drawImage(this, 0, 0);
	        var data = ctx.getImageData(0, 0, this.width, this.height).data;
	        computeGray(data, array);
	        this.callback(array, {
	            x: this.width,
	            y: this.height
	        }, this);
	    };
	    img.src = src;
	};
	
	/**
	 * @param inImg {ImageWrapper} input image to be sampled
	 * @param outImg {ImageWrapper} to be stored in
	 */
	function halfSample(inImgWrapper, outImgWrapper) {
	    var inImg = inImgWrapper.data;
	    var inWidth = inImgWrapper.size.x;
	    var outImg = outImgWrapper.data;
	    var topRowIdx = 0;
	    var bottomRowIdx = inWidth;
	    var endIdx = inImg.length;
	    var outWidth = inWidth / 2;
	    var outImgIdx = 0;
	    while (bottomRowIdx < endIdx) {
	        for (var i = 0; i < outWidth; i++) {
	            outImg[outImgIdx] = Math.floor((inImg[topRowIdx] + inImg[topRowIdx + 1] + inImg[bottomRowIdx] + inImg[bottomRowIdx + 1]) / 4);
	            outImgIdx++;
	            topRowIdx = topRowIdx + 2;
	            bottomRowIdx = bottomRowIdx + 2;
	        }
	        topRowIdx = topRowIdx + inWidth;
	        bottomRowIdx = bottomRowIdx + inWidth;
	    }
	};
	
	function hsv2rgb(hsv, rgb) {
	    var h = hsv[0],
	        s = hsv[1],
	        v = hsv[2],
	        c = v * s,
	        x = c * (1 - Math.abs(h / 60 % 2 - 1)),
	        m = v - c,
	        r = 0,
	        g = 0,
	        b = 0;
	
	    rgb = rgb || [0, 0, 0];
	
	    if (h < 60) {
	        r = c;
	        g = x;
	    } else if (h < 120) {
	        r = x;
	        g = c;
	    } else if (h < 180) {
	        g = c;
	        b = x;
	    } else if (h < 240) {
	        g = x;
	        b = c;
	    } else if (h < 300) {
	        r = x;
	        b = c;
	    } else if (h < 360) {
	        r = c;
	        b = x;
	    }
	    rgb[0] = (r + m) * 255 | 0;
	    rgb[1] = (g + m) * 255 | 0;
	    rgb[2] = (b + m) * 255 | 0;
	    return rgb;
	};
	
	function _computeDivisors(n) {
	    var largeDivisors = [],
	        divisors = [],
	        i;
	
	    for (i = 1; i < Math.sqrt(n) + 1; i++) {
	        if (n % i === 0) {
	            divisors.push(i);
	            if (i !== n / i) {
	                largeDivisors.unshift(Math.floor(n / i));
	            }
	        }
	    }
	    return divisors.concat(largeDivisors);
	};
	
	function _computeIntersection(arr1, arr2) {
	    var i = 0,
	        j = 0,
	        result = [];
	
	    while (i < arr1.length && j < arr2.length) {
	        if (arr1[i] === arr2[j]) {
	            result.push(arr1[i]);
	            i++;
	            j++;
	        } else if (arr1[i] > arr2[j]) {
	            j++;
	        } else {
	            i++;
	        }
	    }
	    return result;
	};
	
	function calculatePatchSize(patchSize, imgSize) {
	    var divisorsX = _computeDivisors(imgSize.x),
	        divisorsY = _computeDivisors(imgSize.y),
	        wideSide = Math.max(imgSize.x, imgSize.y),
	        common = _computeIntersection(divisorsX, divisorsY),
	        nrOfPatchesList = [8, 10, 15, 20, 32, 60, 80],
	        nrOfPatchesMap = {
	        "x-small": 5,
	        "small": 4,
	        "medium": 3,
	        "large": 2,
	        "x-large": 1
	    },
	        nrOfPatchesIdx = nrOfPatchesMap[patchSize] || nrOfPatchesMap.medium,
	        nrOfPatches = nrOfPatchesList[nrOfPatchesIdx],
	        desiredPatchSize = Math.floor(wideSide / nrOfPatches),
	        optimalPatchSize;
	
	    function findPatchSizeForDivisors(divisors) {
	        var i = 0,
	            found = divisors[Math.floor(divisors.length / 2)];
	
	        while (i < divisors.length - 1 && divisors[i] < desiredPatchSize) {
	            i++;
	        }
	        if (i > 0) {
	            if (Math.abs(divisors[i] - desiredPatchSize) > Math.abs(divisors[i - 1] - desiredPatchSize)) {
	                found = divisors[i - 1];
	            } else {
	                found = divisors[i];
	            }
	        }
	        if (desiredPatchSize / found < nrOfPatchesList[nrOfPatchesIdx + 1] / nrOfPatchesList[nrOfPatchesIdx] && desiredPatchSize / found > nrOfPatchesList[nrOfPatchesIdx - 1] / nrOfPatchesList[nrOfPatchesIdx]) {
	            return { x: found, y: found };
	        }
	        return null;
	    }
	
	    optimalPatchSize = findPatchSizeForDivisors(common);
	    if (!optimalPatchSize) {
	        optimalPatchSize = findPatchSizeForDivisors(_computeDivisors(wideSide));
	        if (!optimalPatchSize) {
	            optimalPatchSize = findPatchSizeForDivisors(_computeDivisors(desiredPatchSize * nrOfPatches));
	        }
	    }
	    return optimalPatchSize;
	};
	
	function _parseCSSDimensionValues(value) {
	    var dimension = {
	        value: parseFloat(value),
	        unit: value.indexOf("%") === value.length - 1 ? "%" : "%"
	    };
	
	    return dimension;
	};
	
	var _dimensionsConverters = {
	    top: function top(dimension, context) {
	        if (dimension.unit === "%") {
	            return Math.floor(context.height * (dimension.value / 100));
	        }
	    },
	    right: function right(dimension, context) {
	        if (dimension.unit === "%") {
	            return Math.floor(context.width - context.width * (dimension.value / 100));
	        }
	    },
	    bottom: function bottom(dimension, context) {
	        if (dimension.unit === "%") {
	            return Math.floor(context.height - context.height * (dimension.value / 100));
	        }
	    },
	    left: function left(dimension, context) {
	        if (dimension.unit === "%") {
	            return Math.floor(context.width * (dimension.value / 100));
	        }
	    }
	};/* unused harmony export _dimensionsConverters */
	
	function computeImageArea(inputWidth, inputHeight, area) {
	    var context = { width: inputWidth, height: inputHeight };
	
	    var parsedArea = Object.keys(area).reduce(function (result, key) {
	        var value = area[key],
	            parsed = _parseCSSDimensionValues(value),
	            calculated = _dimensionsConverters[key](parsed, context);
	
	        result[key] = calculated;
	        return result;
	    }, {});
	
	    return {
	        sx: parsedArea.left,
	        sy: parsedArea.top,
	        sw: parsedArea.right - parsedArea.left,
	        sh: parsedArea.bottom - parsedArea.top
	    };
	};

/***/ },
/* 19 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__subImage__ = __webpack_require__(53);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_cv_utils__ = __webpack_require__(18);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__common_array_helper__ = __webpack_require__(9);
	
	
	
	var vec2 = {
	    clone: __webpack_require__(7)
	};
	
	/**
	 * Represents a basic image combining the data and size.
	 * In addition, some methods for manipulation are contained.
	 * @param size {x,y} The size of the image in pixel
	 * @param data {Array} If given, a flat array containing the pixel data
	 * @param ArrayType {Type} If given, the desired DataType of the Array (may be typed/non-typed)
	 * @param initialize {Boolean} Indicating if the array should be initialized on creation.
	 * @returns {ImageWrapper}
	 */
	function ImageWrapper(size, data, ArrayType, initialize) {
	    if (!data) {
	        if (ArrayType) {
	            this.data = new ArrayType(size.x * size.y);
	            if (ArrayType === Array && initialize) {
	                /* harmony import */__WEBPACK_IMPORTED_MODULE_2__common_array_helper__["a"].init(this.data, 0);
	            }
	        } else {
	            this.data = new Uint8Array(size.x * size.y);
	            if (Uint8Array === Array && initialize) {
	                /* harmony import */__WEBPACK_IMPORTED_MODULE_2__common_array_helper__["a"].init(this.data, 0);
	            }
	        }
	    } else {
	        this.data = data;
	    }
	    this.size = size;
	}
	
	/**
	 * tests if a position is within the image with a given offset
	 * @param imgRef {x, y} The location to test
	 * @param border Number the padding value in pixel
	 * @returns {Boolean} true if location inside the image's border, false otherwise
	 * @see cvd/image.h
	 */
	ImageWrapper.prototype.inImageWithBorder = function (imgRef, border) {
	    return imgRef.x >= border && imgRef.y >= border && imgRef.x < this.size.x - border && imgRef.y < this.size.y - border;
	};
	
	/**
	 * Performs bilinear sampling
	 * @param inImg Image to extract sample from
	 * @param x the x-coordinate
	 * @param y the y-coordinate
	 * @returns the sampled value
	 * @see cvd/vision.h
	 */
	ImageWrapper.sample = function (inImg, x, y) {
	    var lx = Math.floor(x);
	    var ly = Math.floor(y);
	    var w = inImg.size.x;
	    var base = ly * inImg.size.x + lx;
	    var a = inImg.data[base + 0];
	    var b = inImg.data[base + 1];
	    var c = inImg.data[base + w];
	    var d = inImg.data[base + w + 1];
	    var e = a - b;
	    x -= lx;
	    y -= ly;
	
	    var result = Math.floor(x * (y * (e - c + d) - e) + y * (c - a) + a);
	    return result;
	};
	
	/**
	 * Initializes a given array. Sets each element to zero.
	 * @param array {Array} The array to initialize
	 */
	ImageWrapper.clearArray = function (array) {
	    var l = array.length;
	    while (l--) {
	        array[l] = 0;
	    }
	};
	
	/**
	 * Creates a {SubImage} from the current image ({this}).
	 * @param from {ImageRef} The position where to start the {SubImage} from. (top-left corner)
	 * @param size {ImageRef} The size of the resulting image
	 * @returns {SubImage} A shared part of the original image
	 */
	ImageWrapper.prototype.subImage = function (from, size) {
	    return new /* harmony import */__WEBPACK_IMPORTED_MODULE_0__subImage__["a"](from, size, this);
	};
	
	/**
	 * Creates an {ImageWrapper) and copies the needed underlying image-data area
	 * @param imageWrapper {ImageWrapper} The target {ImageWrapper} where the data should be copied
	 * @param from {ImageRef} The location where to copy from (top-left location)
	 */
	ImageWrapper.prototype.subImageAsCopy = function (imageWrapper, from) {
	    var sizeY = imageWrapper.size.y,
	        sizeX = imageWrapper.size.x;
	    var x, y;
	    for (x = 0; x < sizeX; x++) {
	        for (y = 0; y < sizeY; y++) {
	            imageWrapper.data[y * sizeX + x] = this.data[(from.y + y) * this.size.x + from.x + x];
	        }
	    }
	};
	
	ImageWrapper.prototype.copyTo = function (imageWrapper) {
	    var length = this.data.length,
	        srcData = this.data,
	        dstData = imageWrapper.data;
	
	    while (length--) {
	        dstData[length] = srcData[length];
	    }
	};
	
	/**
	 * Retrieves a given pixel position from the image
	 * @param x {Number} The x-position
	 * @param y {Number} The y-position
	 * @returns {Number} The grayscale value at the pixel-position
	 */
	ImageWrapper.prototype.get = function (x, y) {
	    return this.data[y * this.size.x + x];
	};
	
	/**
	 * Retrieves a given pixel position from the image
	 * @param x {Number} The x-position
	 * @param y {Number} The y-position
	 * @returns {Number} The grayscale value at the pixel-position
	 */
	ImageWrapper.prototype.getSafe = function (x, y) {
	    var i;
	
	    if (!this.indexMapping) {
	        this.indexMapping = {
	            x: [],
	            y: []
	        };
	        for (i = 0; i < this.size.x; i++) {
	            this.indexMapping.x[i] = i;
	            this.indexMapping.x[i + this.size.x] = i;
	        }
	        for (i = 0; i < this.size.y; i++) {
	            this.indexMapping.y[i] = i;
	            this.indexMapping.y[i + this.size.y] = i;
	        }
	    }
	    return this.data[this.indexMapping.y[y + this.size.y] * this.size.x + this.indexMapping.x[x + this.size.x]];
	};
	
	/**
	 * Sets a given pixel position in the image
	 * @param x {Number} The x-position
	 * @param y {Number} The y-position
	 * @param value {Number} The grayscale value to set
	 * @returns {ImageWrapper} The Image itself (for possible chaining)
	 */
	ImageWrapper.prototype.set = function (x, y, value) {
	    this.data[y * this.size.x + x] = value;
	    return this;
	};
	
	/**
	 * Sets the border of the image (1 pixel) to zero
	 */
	ImageWrapper.prototype.zeroBorder = function () {
	    var i,
	        width = this.size.x,
	        height = this.size.y,
	        data = this.data;
	    for (i = 0; i < width; i++) {
	        data[i] = data[(height - 1) * width + i] = 0;
	    }
	    for (i = 1; i < height - 1; i++) {
	        data[i * width] = data[i * width + (width - 1)] = 0;
	    }
	};
	
	/**
	 * Inverts a binary image in place
	 */
	ImageWrapper.prototype.invert = function () {
	    var data = this.data,
	        length = data.length;
	
	    while (length--) {
	        data[length] = data[length] ? 0 : 1;
	    }
	};
	
	ImageWrapper.prototype.convolve = function (kernel) {
	    var x,
	        y,
	        kx,
	        ky,
	        kSize = kernel.length / 2 | 0,
	        accu = 0;
	    for (y = 0; y < this.size.y; y++) {
	        for (x = 0; x < this.size.x; x++) {
	            accu = 0;
	            for (ky = -kSize; ky <= kSize; ky++) {
	                for (kx = -kSize; kx <= kSize; kx++) {
	                    accu += kernel[ky + kSize][kx + kSize] * this.getSafe(x + kx, y + ky);
	                }
	            }
	            this.data[y * this.size.x + x] = accu;
	        }
	    }
	};
	
	ImageWrapper.prototype.moments = function (labelcount) {
	    var data = this.data,
	        x,
	        y,
	        height = this.size.y,
	        width = this.size.x,
	        val,
	        ysq,
	        labelsum = [],
	        i,
	        label,
	        mu11,
	        mu02,
	        mu20,
	        x_,
	        y_,
	        tmp,
	        result = [],
	        PI = Math.PI,
	        PI_4 = PI / 4;
	
	    if (labelcount <= 0) {
	        return result;
	    }
	
	    for (i = 0; i < labelcount; i++) {
	        labelsum[i] = {
	            m00: 0,
	            m01: 0,
	            m10: 0,
	            m11: 0,
	            m02: 0,
	            m20: 0,
	            theta: 0,
	            rad: 0
	        };
	    }
	
	    for (y = 0; y < height; y++) {
	        ysq = y * y;
	        for (x = 0; x < width; x++) {
	            val = data[y * width + x];
	            if (val > 0) {
	                label = labelsum[val - 1];
	                label.m00 += 1;
	                label.m01 += y;
	                label.m10 += x;
	                label.m11 += x * y;
	                label.m02 += ysq;
	                label.m20 += x * x;
	            }
	        }
	    }
	
	    for (i = 0; i < labelcount; i++) {
	        label = labelsum[i];
	        if (!isNaN(label.m00) && label.m00 !== 0) {
	            x_ = label.m10 / label.m00;
	            y_ = label.m01 / label.m00;
	            mu11 = label.m11 / label.m00 - x_ * y_;
	            mu02 = label.m02 / label.m00 - y_ * y_;
	            mu20 = label.m20 / label.m00 - x_ * x_;
	            tmp = (mu02 - mu20) / (2 * mu11);
	            tmp = 0.5 * Math.atan(tmp) + (mu11 >= 0 ? PI_4 : -PI_4) + PI;
	            label.theta = (tmp * 180 / PI + 90) % 180 - 90;
	            if (label.theta < 0) {
	                label.theta += 180;
	            }
	            label.rad = tmp > PI ? tmp - PI : tmp;
	            label.vec = vec2.clone([Math.cos(tmp), Math.sin(tmp)]);
	            result.push(label);
	        }
	    }
	
	    return result;
	};
	
	/**
	 * Displays the {ImageWrapper} in a given canvas
	 * @param canvas {Canvas} The canvas element to write to
	 * @param scale {Number} Scale which is applied to each pixel-value
	 */
	ImageWrapper.prototype.show = function (canvas, scale) {
	    var ctx, frame, data, current, pixel, x, y;
	
	    if (!scale) {
	        scale = 1.0;
	    }
	    ctx = canvas.getContext('2d');
	    canvas.width = this.size.x;
	    canvas.height = this.size.y;
	    frame = ctx.getImageData(0, 0, canvas.width, canvas.height);
	    data = frame.data;
	    current = 0;
	    for (y = 0; y < this.size.y; y++) {
	        for (x = 0; x < this.size.x; x++) {
	            pixel = y * this.size.x + x;
	            current = this.get(x, y) * scale;
	            data[pixel * 4 + 0] = current;
	            data[pixel * 4 + 1] = current;
	            data[pixel * 4 + 2] = current;
	            data[pixel * 4 + 3] = 255;
	        }
	    }
	    //frame.data = data;
	    ctx.putImageData(frame, 0, 0);
	};
	
	/**
	 * Displays the {SubImage} in a given canvas
	 * @param canvas {Canvas} The canvas element to write to
	 * @param scale {Number} Scale which is applied to each pixel-value
	 */
	ImageWrapper.prototype.overlay = function (canvas, scale, from) {
	    if (!scale || scale < 0 || scale > 360) {
	        scale = 360;
	    }
	    var hsv = [0, 1, 1];
	    var rgb = [0, 0, 0];
	    var whiteRgb = [255, 255, 255];
	    var blackRgb = [0, 0, 0];
	    var result = [];
	    var ctx = canvas.getContext('2d');
	    var frame = ctx.getImageData(from.x, from.y, this.size.x, this.size.y);
	    var data = frame.data;
	    var length = this.data.length;
	    while (length--) {
	        hsv[0] = this.data[length] * scale;
	        result = hsv[0] <= 0 ? whiteRgb : hsv[0] >= 360 ? blackRgb : /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["a"].bind()(hsv, rgb);
	        data[length * 4 + 0] = result[0];
	        data[length * 4 + 1] = result[1];
	        data[length * 4 + 2] = result[2];
	        data[length * 4 + 3] = 255;
	    }
	    ctx.putImageData(frame, from.x, from.y);
	};
	
	/* harmony default export */ exports["a"] = ImageWrapper;

/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * A specialized version of `_.reduce` for arrays without support for
	 * iteratee shorthands.
	 *
	 * @private
	 * @param {Array} array The array to iterate over.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @param {*} [accumulator] The initial value.
	 * @param {boolean} [initAccum] Specify using the first element of `array` as the initial value.
	 * @returns {*} Returns the accumulated value.
	 */
	function arrayReduce(array, iteratee, accumulator, initAccum) {
	  var index = -1,
	      length = array.length;
	
	  if (initAccum && length) {
	    accumulator = array[++index];
	  }
	  while (++index < length) {
	    accumulator = iteratee(accumulator, array[index], index, array);
	  }
	  return accumulator;
	}
	
	module.e = arrayReduce;


/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

	var copyObjectWith = __webpack_require__(113);
	
	/**
	 * Copies properties of `source` to `object`.
	 *
	 * @private
	 * @param {Object} source The object to copy properties from.
	 * @param {Array} props The property names to copy.
	 * @param {Object} [object={}] The object to copy properties to.
	 * @returns {Object} Returns `object`.
	 */
	function copyObject(source, props, object) {
	  return copyObjectWith(source, props, object);
	}
	
	module.e = copyObject;


/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Checks if `value` is a host object in IE < 9.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
	 */
	function isHostObject(value) {
	  // Many host objects are `Object` objects that can coerce to strings
	  // despite having improperly defined `toString` methods.
	  var result = false;
	  if (value != null && typeof value.toString != 'function') {
	    try {
	      result = !!(value + '');
	    } catch (e) {}
	  }
	  return result;
	}
	
	module.e = isHostObject;


/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

	/** Used as references for various `Number` constants. */
	var MAX_SAFE_INTEGER = 9007199254740991;
	
	/** Used to detect unsigned integer values. */
	var reIsUint = /^(?:0|[1-9]\d*)$/;
	
	/**
	 * Checks if `value` is a valid array-like index.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
	 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
	 */
	function isIndex(value, length) {
	  value = (typeof value == 'number' || reIsUint.test(value)) ? +value : -1;
	  length = length == null ? MAX_SAFE_INTEGER : length;
	  return value > -1 && value % 1 == 0 && value < length;
	}
	
	module.e = isIndex;


/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/**
	 * Checks if `value` is likely a prototype object.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
	 */
	function isPrototype(value) {
	  var Ctor = value && value.constructor,
	      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;
	
	  return value === proto;
	}
	
	module.e = isPrototype;


/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

	var isArrayLikeObject = __webpack_require__(27);
	
	/** `Object#toString` result references. */
	var argsTag = '[object Arguments]';
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/**
	 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;
	
	/** Built-in value references. */
	var propertyIsEnumerable = objectProto.propertyIsEnumerable;
	
	/**
	 * Checks if `value` is likely an `arguments` object.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
	 * @example
	 *
	 * _.isArguments(function() { return arguments; }());
	 * // => true
	 *
	 * _.isArguments([1, 2, 3]);
	 * // => false
	 */
	function isArguments(value) {
	  // Safari 8.1 incorrectly makes `arguments.callee` enumerable in strict mode.
	  return isArrayLikeObject(value) && hasOwnProperty.call(value, 'callee') &&
	    (!propertyIsEnumerable.call(value, 'callee') || objectToString.call(value) == argsTag);
	}
	
	module.e = isArguments;


/***/ },
/* 26 */
/***/ function(module, exports, __webpack_require__) {

	var getLength = __webpack_require__(117),
	    isFunction = __webpack_require__(16),
	    isLength = __webpack_require__(28);
	
	/**
	 * Checks if `value` is array-like. A value is considered array-like if it's
	 * not a function and has a `value.length` that's an integer greater than or
	 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
	 * @example
	 *
	 * _.isArrayLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isArrayLike(document.body.children);
	 * // => true
	 *
	 * _.isArrayLike('abc');
	 * // => true
	 *
	 * _.isArrayLike(_.noop);
	 * // => false
	 */
	function isArrayLike(value) {
	  return value != null && isLength(getLength(value)) && !isFunction(value);
	}
	
	module.e = isArrayLike;


/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

	var isArrayLike = __webpack_require__(26),
	    isObjectLike = __webpack_require__(8);
	
	/**
	 * This method is like `_.isArrayLike` except that it also checks if `value`
	 * is an object.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an array-like object, else `false`.
	 * @example
	 *
	 * _.isArrayLikeObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isArrayLikeObject(document.body.children);
	 * // => true
	 *
	 * _.isArrayLikeObject('abc');
	 * // => false
	 *
	 * _.isArrayLikeObject(_.noop);
	 * // => false
	 */
	function isArrayLikeObject(value) {
	  return isObjectLike(value) && isArrayLike(value);
	}
	
	module.e = isArrayLikeObject;


/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	/** Used as references for various `Number` constants. */
	var MAX_SAFE_INTEGER = 9007199254740991;
	
	/**
	 * Checks if `value` is a valid array-like length.
	 *
	 * **Note:** This function is loosely based on [`ToLength`](http://ecma-international.org/ecma-262/6.0/#sec-tolength).
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
	 * @example
	 *
	 * _.isLength(3);
	 * // => true
	 *
	 * _.isLength(Number.MIN_VALUE);
	 * // => false
	 *
	 * _.isLength(Infinity);
	 * // => false
	 *
	 * _.isLength('3');
	 * // => false
	 */
	function isLength(value) {
	  return typeof value == 'number' &&
	    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
	}
	
	module.e = isLength;


/***/ },
/* 29 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * http://www.codeproject.com/Tips/407172/Connected-Component-Labeling-and-Vectorization
	 */
	var Tracer = {
	    searchDirections: [[0, 1], [1, 1], [1, 0], [1, -1], [0, -1], [-1, -1], [-1, 0], [-1, 1]],
	    create: function create(imageWrapper, labelWrapper) {
	        var imageData = imageWrapper.data,
	            labelData = labelWrapper.data,
	            searchDirections = this.searchDirections,
	            width = imageWrapper.size.x,
	            pos;
	
	        function _trace(current, color, label, edgelabel) {
	            var i, y, x;
	
	            for (i = 0; i < 7; i++) {
	                y = current.cy + searchDirections[current.dir][0];
	                x = current.cx + searchDirections[current.dir][1];
	                pos = y * width + x;
	                if (imageData[pos] === color && (labelData[pos] === 0 || labelData[pos] === label)) {
	                    labelData[pos] = label;
	                    current.cy = y;
	                    current.cx = x;
	                    return true;
	                } else {
	                    if (labelData[pos] === 0) {
	                        labelData[pos] = edgelabel;
	                    }
	                    current.dir = (current.dir + 1) % 8;
	                }
	            }
	            return false;
	        }
	
	        function vertex2D(x, y, dir) {
	            return {
	                dir: dir,
	                x: x,
	                y: y,
	                next: null,
	                prev: null
	            };
	        }
	
	        function _contourTracing(sy, sx, label, color, edgelabel) {
	            var Fv = null,
	                Cv,
	                P,
	                ldir,
	                current = {
	                cx: sx,
	                cy: sy,
	                dir: 0
	            };
	
	            if (_trace(current, color, label, edgelabel)) {
	                Fv = vertex2D(sx, sy, current.dir);
	                Cv = Fv;
	                ldir = current.dir;
	                P = vertex2D(current.cx, current.cy, 0);
	                P.prev = Cv;
	                Cv.next = P;
	                P.next = null;
	                Cv = P;
	                do {
	                    current.dir = (current.dir + 6) % 8;
	                    _trace(current, color, label, edgelabel);
	                    if (ldir !== current.dir) {
	                        Cv.dir = current.dir;
	                        P = vertex2D(current.cx, current.cy, 0);
	                        P.prev = Cv;
	                        Cv.next = P;
	                        P.next = null;
	                        Cv = P;
	                    } else {
	                        Cv.dir = ldir;
	                        Cv.x = current.cx;
	                        Cv.y = current.cy;
	                    }
	                    ldir = current.dir;
	                } while (current.cx !== sx || current.cy !== sy);
	                Fv.prev = Cv.prev;
	                Cv.prev.next = Fv;
	            }
	            return Fv;
	        }
	
	        return {
	            trace: function trace(current, color, label, edgelabel) {
	                return _trace(current, color, label, edgelabel);
	            },
	            contourTracing: function contourTracing(sy, sx, label, color, edgelabel) {
	                return _contourTracing(sy, sx, label, color, edgelabel);
	            }
	        };
	    }
	};
	
	/* harmony default export */ exports["a"] = Tracer;

/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__barcode_reader__ = __webpack_require__(6);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_array_helper__ = __webpack_require__(9);
	
	
	
	function Code39Reader() {
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a"].call(this);
	}
	
	var properties = {
	    ALPHABETH_STRING: { value: "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%" },
	    ALPHABET: { value: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 45, 46, 32, 42, 36, 47, 43, 37] },
	    CHARACTER_ENCODINGS: { value: [0x034, 0x121, 0x061, 0x160, 0x031, 0x130, 0x070, 0x025, 0x124, 0x064, 0x109, 0x049, 0x148, 0x019, 0x118, 0x058, 0x00D, 0x10C, 0x04C, 0x01C, 0x103, 0x043, 0x142, 0x013, 0x112, 0x052, 0x007, 0x106, 0x046, 0x016, 0x181, 0x0C1, 0x1C0, 0x091, 0x190, 0x0D0, 0x085, 0x184, 0x0C4, 0x094, 0x0A8, 0x0A2, 0x08A, 0x02A] },
	    ASTERISK: { value: 0x094 },
	    FORMAT: { value: "code_39", writeable: false }
	};
	
	Code39Reader.prototype = Object.create(/* harmony import */__WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a"].prototype, properties);
	Code39Reader.prototype.constructor = Code39Reader;
	
	Code39Reader.prototype._toCounters = function (start, counter) {
	    var self = this,
	        numCounters = counter.length,
	        end = self._row.length,
	        isWhite = !self._row[start],
	        i,
	        counterPos = 0;
	
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_array_helper__["a"].init(counter, 0);
	
	    for (i = start; i < end; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            counterPos++;
	            if (counterPos === numCounters) {
	                break;
	            } else {
	                counter[counterPos] = 1;
	                isWhite = !isWhite;
	            }
	        }
	    }
	
	    return counter;
	};
	
	Code39Reader.prototype._decode = function () {
	    var self = this,
	        counters = [0, 0, 0, 0, 0, 0, 0, 0, 0],
	        result = [],
	        start = self._findStart(),
	        decodedChar,
	        lastStart,
	        pattern,
	        nextStart;
	
	    if (!start) {
	        return null;
	    }
	    nextStart = self._nextSet(self._row, start.end);
	
	    do {
	        counters = self._toCounters(nextStart, counters);
	        pattern = self._toPattern(counters);
	        if (pattern < 0) {
	            return null;
	        }
	        decodedChar = self._patternToChar(pattern);
	        if (decodedChar < 0) {
	            return null;
	        }
	        result.push(decodedChar);
	        lastStart = nextStart;
	        nextStart += /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_array_helper__["a"].sum(counters);
	        nextStart = self._nextSet(self._row, nextStart);
	    } while (decodedChar !== '*');
	    result.pop();
	
	    if (!result.length) {
	        return null;
	    }
	
	    if (!self._verifyTrailingWhitespace(lastStart, nextStart, counters)) {
	        return null;
	    }
	
	    return {
	        code: result.join(""),
	        start: start.start,
	        end: nextStart,
	        startInfo: start,
	        decodedCodes: result
	    };
	};
	
	Code39Reader.prototype._verifyTrailingWhitespace = function (lastStart, nextStart, counters) {
	    var trailingWhitespaceEnd,
	        patternSize = /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_array_helper__["a"].sum(counters);
	
	    trailingWhitespaceEnd = nextStart - lastStart - patternSize;
	    if (trailingWhitespaceEnd * 3 >= patternSize) {
	        return true;
	    }
	    return false;
	};
	
	Code39Reader.prototype._patternToChar = function (pattern) {
	    var i,
	        self = this;
	
	    for (i = 0; i < self.CHARACTER_ENCODINGS.length; i++) {
	        if (self.CHARACTER_ENCODINGS[i] === pattern) {
	            return String.fromCharCode(self.ALPHABET[i]);
	        }
	    }
	    return -1;
	};
	
	Code39Reader.prototype._findNextWidth = function (counters, current) {
	    var i,
	        minWidth = Number.MAX_VALUE;
	
	    for (i = 0; i < counters.length; i++) {
	        if (counters[i] < minWidth && counters[i] > current) {
	            minWidth = counters[i];
	        }
	    }
	
	    return minWidth;
	};
	
	Code39Reader.prototype._toPattern = function (counters) {
	    var numCounters = counters.length,
	        maxNarrowWidth = 0,
	        numWideBars = numCounters,
	        wideBarWidth = 0,
	        self = this,
	        pattern,
	        i;
	
	    while (numWideBars > 3) {
	        maxNarrowWidth = self._findNextWidth(counters, maxNarrowWidth);
	        numWideBars = 0;
	        pattern = 0;
	        for (i = 0; i < numCounters; i++) {
	            if (counters[i] > maxNarrowWidth) {
	                pattern |= 1 << numCounters - 1 - i;
	                numWideBars++;
	                wideBarWidth += counters[i];
	            }
	        }
	
	        if (numWideBars === 3) {
	            for (i = 0; i < numCounters && numWideBars > 0; i++) {
	                if (counters[i] > maxNarrowWidth) {
	                    numWideBars--;
	                    if (counters[i] * 2 >= wideBarWidth) {
	                        return -1;
	                    }
	                }
	            }
	            return pattern;
	        }
	    }
	    return -1;
	};
	
	Code39Reader.prototype._findStart = function () {
	    var self = this,
	        offset = self._nextSet(self._row),
	        patternStart = offset,
	        counter = [0, 0, 0, 0, 0, 0, 0, 0, 0],
	        counterPos = 0,
	        isWhite = false,
	        i,
	        j,
	        whiteSpaceMustStart;
	
	    for (i = offset; i < self._row.length; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            if (counterPos === counter.length - 1) {
	                // find start pattern
	                if (self._toPattern(counter) === self.ASTERISK) {
	                    whiteSpaceMustStart = Math.floor(Math.max(0, patternStart - (i - patternStart) / 4));
	                    if (self._matchRange(whiteSpaceMustStart, patternStart, 0)) {
	                        return {
	                            start: patternStart,
	                            end: i
	                        };
	                    }
	                }
	
	                patternStart += counter[0] + counter[1];
	                for (j = 0; j < 7; j++) {
	                    counter[j] = counter[j + 2];
	                }
	                counter[7] = 0;
	                counter[8] = 0;
	                counterPos--;
	            } else {
	                counterPos++;
	            }
	            counter[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return null;
	};
	
	/* harmony default export */ exports["a"] = Code39Reader;

/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	module.e = dot
	
	/**
	 * Calculates the dot product of two vec2's
	 *
	 * @param {vec2} a the first operand
	 * @param {vec2} b the second operand
	 * @returns {Number} dot product of a and b
	 */
	function dot(a, b) {
	    return a[0] * b[0] + a[1] * b[1]
	}

/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	var stackClear = __webpack_require__(135),
	    stackDelete = __webpack_require__(136),
	    stackGet = __webpack_require__(137),
	    stackHas = __webpack_require__(138),
	    stackSet = __webpack_require__(139);
	
	/**
	 * Creates a stack cache object to store key-value pairs.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [values] The values to cache.
	 */
	function Stack(values) {
	  var index = -1,
	      length = values ? values.length : 0;
	
	  this.clear();
	  while (++index < length) {
	    var entry = values[index];
	    this.set(entry[0], entry[1]);
	  }
	}
	
	// Add functions to the `Stack` cache.
	Stack.prototype.clear = stackClear;
	Stack.prototype['delete'] = stackDelete;
	Stack.prototype.get = stackGet;
	Stack.prototype.has = stackHas;
	Stack.prototype.set = stackSet;
	
	module.e = Stack;


/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * A specialized version of `_.forEach` for arrays without support for
	 * iteratee shorthands.
	 *
	 * @private
	 * @param {Array} array The array to iterate over.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @returns {Array} Returns `array`.
	 */
	function arrayEach(array, iteratee) {
	  var index = -1,
	      length = array.length;
	
	  while (++index < length) {
	    if (iteratee(array[index], index, array) === false) {
	      break;
	    }
	  }
	  return array;
	}
	
	module.e = arrayEach;


/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	var eq = __webpack_require__(15);
	
	/**
	 * This function is like `assignValue` except that it doesn't assign
	 * `undefined` values.
	 *
	 * @private
	 * @param {Object} object The object to modify.
	 * @param {string} key The key of the property to assign.
	 * @param {*} value The value to assign.
	 */
	function assignMergeValue(object, key, value) {
	  if ((value !== undefined && !eq(object[key], value)) ||
	      (typeof key == 'number' && value === undefined && !(key in object))) {
	    object[key] = value;
	  }
	}
	
	module.e = assignMergeValue;


/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	var eq = __webpack_require__(15);
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/**
	 * Assigns `value` to `key` of `object` if the existing value is not equivalent
	 * using [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
	 * for equality comparisons.
	 *
	 * @private
	 * @param {Object} object The object to modify.
	 * @param {string} key The key of the property to assign.
	 * @param {*} value The value to assign.
	 */
	function assignValue(object, key, value) {
	  var objValue = object[key];
	  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
	      (value === undefined && !(key in object))) {
	    object[key] = value;
	  }
	}
	
	module.e = assignValue;


/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	var assocIndexOf = __webpack_require__(11);
	
	/** Used for built-in method references. */
	var arrayProto = Array.prototype;
	
	/** Built-in value references. */
	var splice = arrayProto.splice;
	
	/**
	 * Removes `key` and its value from the associative array.
	 *
	 * @private
	 * @param {Array} array The array to query.
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function assocDelete(array, key) {
	  var index = assocIndexOf(array, key);
	  if (index < 0) {
	    return false;
	  }
	  var lastIndex = array.length - 1;
	  if (index == lastIndex) {
	    array.pop();
	  } else {
	    splice.call(array, index, 1);
	  }
	  return true;
	}
	
	module.e = assocDelete;


/***/ },
/* 37 */
/***/ function(module, exports, __webpack_require__) {

	var assocIndexOf = __webpack_require__(11);
	
	/**
	 * Gets the associative array value for `key`.
	 *
	 * @private
	 * @param {Array} array The array to query.
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function assocGet(array, key) {
	  var index = assocIndexOf(array, key);
	  return index < 0 ? undefined : array[index][1];
	}
	
	module.e = assocGet;


/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	var assocIndexOf = __webpack_require__(11);
	
	/**
	 * Checks if an associative array value for `key` exists.
	 *
	 * @private
	 * @param {Array} array The array to query.
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function assocHas(array, key) {
	  return assocIndexOf(array, key) > -1;
	}
	
	module.e = assocHas;


/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	var assocIndexOf = __webpack_require__(11);
	
	/**
	 * Sets the associative array `key` to `value`.
	 *
	 * @private
	 * @param {Array} array The array to modify.
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 */
	function assocSet(array, key, value) {
	  var index = assocIndexOf(array, key);
	  if (index < 0) {
	    array.push([key, value]);
	  } else {
	    array[index][1] = value;
	  }
	}
	
	module.e = assocSet;


/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	var Uint8Array = __webpack_require__(86);
	
	/**
	 * Creates a clone of `arrayBuffer`.
	 *
	 * @private
	 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
	 * @returns {ArrayBuffer} Returns the cloned array buffer.
	 */
	function cloneArrayBuffer(arrayBuffer) {
	  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
	  new Uint8Array(result).set(new Uint8Array(arrayBuffer));
	  return result;
	}
	
	module.e = cloneArrayBuffer;


/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Copies the values of `source` to `array`.
	 *
	 * @private
	 * @param {Array} source The array to copy values from.
	 * @param {Array} [array=[]] The array to copy values to.
	 * @returns {Array} Returns `array`.
	 */
	function copyArray(source, array) {
	  var index = -1,
	      length = source.length;
	
	  array || (array = Array(length));
	  while (++index < length) {
	    array[index] = source[index];
	  }
	  return array;
	}
	
	module.e = copyArray;


/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

	var nativeCreate = __webpack_require__(14);
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/**
	 * Checks if a hash value for `key` exists.
	 *
	 * @private
	 * @param {Object} hash The hash to query.
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function hashHas(hash, key) {
	  return nativeCreate ? hash[key] !== undefined : hasOwnProperty.call(hash, key);
	}
	
	module.e = hashHas;


/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	var baseTimes = __webpack_require__(105),
	    isArguments = __webpack_require__(25),
	    isArray = __webpack_require__(5),
	    isLength = __webpack_require__(28),
	    isString = __webpack_require__(144);
	
	/**
	 * Creates an array of index keys for `object` values of arrays,
	 * `arguments` objects, and strings, otherwise `null` is returned.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array|null} Returns index keys, else `null`.
	 */
	function indexKeys(object) {
	  var length = object ? object.length : undefined;
	  if (isLength(length) &&
	      (isArray(object) || isString(object) || isArguments(object))) {
	    return baseTimes(length, String);
	  }
	  return null;
	}
	
	module.e = indexKeys;


/***/ },
/* 44 */
/***/ function(module, exports, __webpack_require__) {

	var isLength = __webpack_require__(28),
	    isObjectLike = __webpack_require__(8);
	
	/** `Object#toString` result references. */
	var argsTag = '[object Arguments]',
	    arrayTag = '[object Array]',
	    boolTag = '[object Boolean]',
	    dateTag = '[object Date]',
	    errorTag = '[object Error]',
	    funcTag = '[object Function]',
	    mapTag = '[object Map]',
	    numberTag = '[object Number]',
	    objectTag = '[object Object]',
	    regexpTag = '[object RegExp]',
	    setTag = '[object Set]',
	    stringTag = '[object String]',
	    weakMapTag = '[object WeakMap]';
	
	var arrayBufferTag = '[object ArrayBuffer]',
	    float32Tag = '[object Float32Array]',
	    float64Tag = '[object Float64Array]',
	    int8Tag = '[object Int8Array]',
	    int16Tag = '[object Int16Array]',
	    int32Tag = '[object Int32Array]',
	    uint8Tag = '[object Uint8Array]',
	    uint8ClampedTag = '[object Uint8ClampedArray]',
	    uint16Tag = '[object Uint16Array]',
	    uint32Tag = '[object Uint32Array]';
	
	/** Used to identify `toStringTag` values of typed arrays. */
	var typedArrayTags = {};
	typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
	typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
	typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
	typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
	typedArrayTags[uint32Tag] = true;
	typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
	typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
	typedArrayTags[dateTag] = typedArrayTags[errorTag] =
	typedArrayTags[funcTag] = typedArrayTags[mapTag] =
	typedArrayTags[numberTag] = typedArrayTags[objectTag] =
	typedArrayTags[regexpTag] = typedArrayTags[setTag] =
	typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/**
	 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;
	
	/**
	 * Checks if `value` is classified as a typed array.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
	 * @example
	 *
	 * _.isTypedArray(new Uint8Array);
	 * // => true
	 *
	 * _.isTypedArray([]);
	 * // => false
	 */
	function isTypedArray(value) {
	  return isObjectLike(value) &&
	    isLength(value.length) && !!typedArrayTags[objectToString.call(value)];
	}
	
	module.e = isTypedArray;


/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	var baseHas = __webpack_require__(98),
	    baseKeys = __webpack_require__(99),
	    indexKeys = __webpack_require__(43),
	    isArrayLike = __webpack_require__(26),
	    isIndex = __webpack_require__(23),
	    isPrototype = __webpack_require__(24);
	
	/**
	 * Creates an array of the own enumerable property names of `object`.
	 *
	 * **Note:** Non-object values are coerced to objects. See the
	 * [ES spec](http://ecma-international.org/ecma-262/6.0/#sec-object.keys)
	 * for more details.
	 *
	 * @static
	 * @memberOf _
	 * @category Object
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 * @example
	 *
	 * function Foo() {
	 *   this.a = 1;
	 *   this.b = 2;
	 * }
	 *
	 * Foo.prototype.c = 3;
	 *
	 * _.keys(new Foo);
	 * // => ['a', 'b'] (iteration order is not guaranteed)
	 *
	 * _.keys('hi');
	 * // => ['0', '1']
	 */
	function keys(object) {
	  var isProto = isPrototype(object);
	  if (!(isProto || isArrayLike(object))) {
	    return baseKeys(object);
	  }
	  var indexes = indexKeys(object),
	      skipIndexes = !!indexes,
	      result = indexes || [],
	      length = result.length;
	
	  for (var key in object) {
	    if (baseHas(object, key) &&
	        !(skipIndexes && (key == 'length' || isIndex(key, length))) &&
	        !(isProto && key == 'constructor')) {
	      result.push(key);
	    }
	  }
	  return result;
	}
	
	module.e = keys;


/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	var baseKeysIn = __webpack_require__(100),
	    indexKeys = __webpack_require__(43),
	    isIndex = __webpack_require__(23),
	    isPrototype = __webpack_require__(24);
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/**
	 * Creates an array of the own and inherited enumerable property names of `object`.
	 *
	 * **Note:** Non-object values are coerced to objects.
	 *
	 * @static
	 * @memberOf _
	 * @category Object
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 * @example
	 *
	 * function Foo() {
	 *   this.a = 1;
	 *   this.b = 2;
	 * }
	 *
	 * Foo.prototype.c = 3;
	 *
	 * _.keysIn(new Foo);
	 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
	 */
	function keysIn(object) {
	  var index = -1,
	      isProto = isPrototype(object),
	      props = baseKeysIn(object),
	      propsLength = props.length,
	      indexes = indexKeys(object),
	      skipIndexes = !!indexes,
	      result = indexes || [],
	      length = result.length;
	
	  while (++index < propsLength) {
	    var key = props[index];
	    if (!(skipIndexes && (key == 'length' || isIndex(key, length))) &&
	        !(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
	      result.push(key);
	    }
	  }
	  return result;
	}
	
	module.e = keysIn;


/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	var apply = __webpack_require__(90),
	    toInteger = __webpack_require__(146);
	
	/** Used as the `TypeError` message for "Functions" methods. */
	var FUNC_ERROR_TEXT = 'Expected a function';
	
	/* Built-in method references for those with the same name as other `lodash` methods. */
	var nativeMax = Math.max;
	
	/**
	 * Creates a function that invokes `func` with the `this` binding of the
	 * created function and arguments from `start` and beyond provided as an array.
	 *
	 * **Note:** This method is based on the [rest parameter](https://mdn.io/rest_parameters).
	 *
	 * @static
	 * @memberOf _
	 * @category Function
	 * @param {Function} func The function to apply a rest parameter to.
	 * @param {number} [start=func.length-1] The start position of the rest parameter.
	 * @returns {Function} Returns the new function.
	 * @example
	 *
	 * var say = _.rest(function(what, names) {
	 *   return what + ' ' + _.initial(names).join(', ') +
	 *     (_.size(names) > 1 ? ', & ' : '') + _.last(names);
	 * });
	 *
	 * say('hello', 'fred', 'barney', 'pebbles');
	 * // => 'hello fred, barney, & pebbles'
	 */
	function rest(func, start) {
	  if (typeof func != 'function') {
	    throw new TypeError(FUNC_ERROR_TEXT);
	  }
	  start = nativeMax(start === undefined ? (func.length - 1) : toInteger(start), 0);
	  return function() {
	    var args = arguments,
	        index = -1,
	        length = nativeMax(args.length - start, 0),
	        array = Array(length);
	
	    while (++index < length) {
	      array[index] = args[start + index];
	    }
	    switch (start) {
	      case 0: return func.call(this, array);
	      case 1: return func.call(this, args[0], array);
	      case 2: return func.call(this, args[0], args[1], array);
	    }
	    var otherArgs = Array(start + 1);
	    index = -1;
	    while (++index < start) {
	      otherArgs[index] = args[index];
	    }
	    otherArgs[start] = array;
	    return apply(func, this, otherArgs);
	  };
	}
	
	module.e = rest;


/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	module.e = function(module) {
		if(!module.webpackPolyfill) {
			module.deprecate = function() {};
			module.paths = [];
			// module.parent = undefined by default
			module.children = [];
			Object.defineProperty(module, "exports", {
				enumerable: true,
				configurable: false,
				get: function() { return module.e; },
				set: function(v) { return module.e = v; }
			});
			Object.defineProperty(module, "loaded", {
				enumerable: true,
				configurable: false,
				get: function() { return module.l; }
			});
			Object.defineProperty(module, "id", {
				enumerable: true,
				configurable: false,
				get: function() { return module.i; }
			});
			module.webpackPolyfill = 1;
		}
		return module;
	}


/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_merge__ = __webpack_require__(17);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_merge___default = __WEBPACK_IMPORTED_MODULE_0_lodash_merge__ && __WEBPACK_IMPORTED_MODULE_0_lodash_merge__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_lodash_merge__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_lodash_merge__; }
	/* harmony import */ Object.defineProperty(__WEBPACK_IMPORTED_MODULE_0_lodash_merge___default, 'a', { get: __WEBPACK_IMPORTED_MODULE_0_lodash_merge___default });
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_typedefs__ = __webpack_require__(54);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_typedefs___default = __WEBPACK_IMPORTED_MODULE_1__common_typedefs__ && __WEBPACK_IMPORTED_MODULE_1__common_typedefs__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1__common_typedefs__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1__common_typedefs__; }
	/* harmony import */ Object.defineProperty(__WEBPACK_IMPORTED_MODULE_1__common_typedefs___default, 'a', { get: __WEBPACK_IMPORTED_MODULE_1__common_typedefs___default });
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_webrtc_adapter__ = __webpack_require__(149);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_webrtc_adapter___default = __WEBPACK_IMPORTED_MODULE_2_webrtc_adapter__ && __WEBPACK_IMPORTED_MODULE_2_webrtc_adapter__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_2_webrtc_adapter__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_2_webrtc_adapter__; }
	/* harmony import */ Object.defineProperty(__WEBPACK_IMPORTED_MODULE_2_webrtc_adapter___default, 'a', { get: __WEBPACK_IMPORTED_MODULE_2_webrtc_adapter___default });
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__common_image_wrapper__ = __webpack_require__(19);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__locator_barcode_locator__ = __webpack_require__(63);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__decoder_barcode_decoder__ = __webpack_require__(57);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__common_events__ = __webpack_require__(52);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__input_camera_access__ = __webpack_require__(59);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__common_image_debug__ = __webpack_require__(10);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__analytics_result_collector__ = __webpack_require__(50);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__config_config__ = __webpack_require__(56);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_input_stream__ = __webpack_require__(62);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_frame_grabber__ = __webpack_require__(60);
	
	
	var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };
	
	 // eslint-disable-line no-unused-vars
	 // eslint-disable-line no-unused-vars
	
	
	
	
	
	
	
	
	
	
	
	var vec2 = {
	    clone: __webpack_require__(7)
	};
	
	var _inputStream,
	    _framegrabber,
	    _stopped,
	    _canvasContainer = {
	    ctx: {
	        image: null,
	        overlay: null
	    },
	    dom: {
	        image: null,
	        overlay: null
	    }
	},
	    _inputImageWrapper,
	    _boxSize,
	    _decoder,
	    _workerPool = [],
	    _onUIThread = true,
	    _resultCollector,
	    _config = {};
	
	function initializeData(imageWrapper) {
	    initBuffers(imageWrapper);
	    _decoder = /* harmony import */__WEBPACK_IMPORTED_MODULE_5__decoder_barcode_decoder__["a"].create(_config.decoder, _inputImageWrapper);
	}
	
	function initInputStream(cb) {
	    var video;
	    if (_config.inputStream.type === "VideoStream") {
	        video = document.createElement("video");
	        _inputStream = /* harmony import */__WEBPACK_IMPORTED_MODULE_11_input_stream__["a"].createVideoStream(video);
	    } else if (_config.inputStream.type === "ImageStream") {
	        _inputStream = /* harmony import */__WEBPACK_IMPORTED_MODULE_11_input_stream__["a"].createImageStream();
	    } else if (_config.inputStream.type === "LiveStream") {
	        var $viewport = getViewPort();
	        if ($viewport) {
	            video = $viewport.querySelector("video");
	            if (!video) {
	                video = document.createElement("video");
	                $viewport.appendChild(video);
	            }
	        }
	        _inputStream = /* harmony import */__WEBPACK_IMPORTED_MODULE_11_input_stream__["a"].createLiveStream(video);
	        /* harmony import */__WEBPACK_IMPORTED_MODULE_7__input_camera_access__["a"].request(video, _config.inputStream.constraints).then(function () {
	            _inputStream.trigger("canrecord");
	        }).catch(function (err) {
	            return cb(err);
	        });
	    }
	
	    _inputStream.setAttribute("preload", "auto");
	    _inputStream.setAttribute("autoplay", true);
	    _inputStream.setInputStream(_config.inputStream);
	    _inputStream.addEventListener("canrecord", canRecord.bind(undefined, cb));
	}
	
	function getViewPort() {
	    var target = _config.inputStream.target;
	    // Check if target is already a DOM element
	    if (target && target.nodeName && target.nodeType === 1) {
	        return target;
	    } else {
	        // Use '#interactive.viewport' as a fallback selector (backwards compatibility)
	        var selector = typeof target === 'string' ? target : '#interactive.viewport';
	        return document.querySelector(selector);
	    }
	}
	
	function canRecord(cb) {
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_4__locator_barcode_locator__["a"].checkImageConstraints(_inputStream, _config.locator);
	    initCanvas(_config);
	    _framegrabber = /* harmony import */__WEBPACK_IMPORTED_MODULE_12_frame_grabber__["a"].create(_inputStream, _canvasContainer.dom.image);
	
	    adjustWorkerPool(_config.numOfWorkers, function () {
	        if (_config.numOfWorkers === 0) {
	            initializeData();
	        }
	        ready(cb);
	    });
	}
	
	function ready(cb) {
	    _inputStream.play();
	    cb();
	}
	
	function initCanvas() {
	    if (typeof document !== "undefined") {
	        var $viewport = getViewPort();
	        _canvasContainer.dom.image = document.querySelector("canvas.imgBuffer");
	        if (!_canvasContainer.dom.image) {
	            _canvasContainer.dom.image = document.createElement("canvas");
	            _canvasContainer.dom.image.className = "imgBuffer";
	            if ($viewport && _config.inputStream.type === "ImageStream") {
	                $viewport.appendChild(_canvasContainer.dom.image);
	            }
	        }
	        _canvasContainer.ctx.image = _canvasContainer.dom.image.getContext("2d");
	        _canvasContainer.dom.image.width = _inputStream.getCanvasSize().x;
	        _canvasContainer.dom.image.height = _inputStream.getCanvasSize().y;
	
	        _canvasContainer.dom.overlay = document.querySelector("canvas.drawingBuffer");
	        if (!_canvasContainer.dom.overlay) {
	            _canvasContainer.dom.overlay = document.createElement("canvas");
	            _canvasContainer.dom.overlay.className = "drawingBuffer";
	            if ($viewport) {
	                $viewport.appendChild(_canvasContainer.dom.overlay);
	            }
	            var clearFix = document.createElement("br");
	            clearFix.setAttribute("clear", "all");
	            if ($viewport) {
	                $viewport.appendChild(clearFix);
	            }
	        }
	        _canvasContainer.ctx.overlay = _canvasContainer.dom.overlay.getContext("2d");
	        _canvasContainer.dom.overlay.width = _inputStream.getCanvasSize().x;
	        _canvasContainer.dom.overlay.height = _inputStream.getCanvasSize().y;
	    }
	}
	
	function initBuffers(imageWrapper) {
	    if (imageWrapper) {
	        _inputImageWrapper = imageWrapper;
	    } else {
	        _inputImageWrapper = new /* harmony import */__WEBPACK_IMPORTED_MODULE_3__common_image_wrapper__["a"]({
	            x: _inputStream.getWidth(),
	            y: _inputStream.getHeight()
	        });
	    }
	
	    if (true) {
	        console.log(_inputImageWrapper.size);
	    }
	    _boxSize = [vec2.clone([0, 0]), vec2.clone([0, _inputImageWrapper.size.y]), vec2.clone([_inputImageWrapper.size.x, _inputImageWrapper.size.y]), vec2.clone([_inputImageWrapper.size.x, 0])];
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_4__locator_barcode_locator__["a"].init(_inputImageWrapper, _config.locator);
	}
	
	function getBoundingBoxes() {
	    if (_config.locate) {
	        return /* harmony import */__WEBPACK_IMPORTED_MODULE_4__locator_barcode_locator__["a"].locate();
	    } else {
	        return [[vec2.clone(_boxSize[0]), vec2.clone(_boxSize[1]), vec2.clone(_boxSize[2]), vec2.clone(_boxSize[3])]];
	    }
	}
	
	function transformResult(result) {
	    var topRight = _inputStream.getTopRight(),
	        xOffset = topRight.x,
	        yOffset = topRight.y,
	        i;
	
	    if (xOffset === 0 && yOffset === 0) {
	        return;
	    }
	
	    if (result.barcodes) {
	        for (i = 0; i < result.barcodes.length; i++) {
	            transformResult(result.barcodes[i]);
	        }
	    }
	
	    if (result.line && result.line.length === 2) {
	        moveLine(result.line);
	    }
	
	    if (result.box) {
	        moveBox(result.box);
	    }
	
	    if (result.boxes && result.boxes.length > 0) {
	        for (i = 0; i < result.boxes.length; i++) {
	            moveBox(result.boxes[i]);
	        }
	    }
	
	    function moveBox(box) {
	        var corner = box.length;
	
	        while (corner--) {
	            box[corner][0] += xOffset;
	            box[corner][1] += yOffset;
	        }
	    }
	
	    function moveLine(line) {
	        line[0].x += xOffset;
	        line[0].y += yOffset;
	        line[1].x += xOffset;
	        line[1].y += yOffset;
	    }
	}
	
	function addResult(result, imageData) {
	    if (!imageData || !_resultCollector) {
	        return;
	    }
	
	    if (result.barcodes) {
	        result.barcodes.filter(function (barcode) {
	            return barcode.codeResult;
	        }).forEach(function (barcode) {
	            return addResult(barcode, imageData);
	        });
	    } else if (result.codeResult) {
	        _resultCollector.addResult(imageData, _inputStream.getCanvasSize(), result.codeResult);
	    }
	}
	
	function hasCodeResult(result) {
	    return result && (result.barcodes ? result.barcodes.some(function (barcode) {
	        return barcode.codeResult;
	    }) : result.codeResult);
	}
	
	function publishResult(result, imageData) {
	    var resultToPublish = result;
	
	    if (result && _onUIThread) {
	        transformResult(result);
	        addResult(result, imageData);
	        resultToPublish = result.barcodes || result;
	    }
	
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_6__common_events__["a"].publish("processed", resultToPublish);
	    if (hasCodeResult(result)) {
	        /* harmony import */__WEBPACK_IMPORTED_MODULE_6__common_events__["a"].publish("detected", resultToPublish);
	    }
	}
	
	function locateAndDecode() {
	    var result, boxes;
	
	    boxes = getBoundingBoxes();
	    if (boxes) {
	        result = _decoder.decodeFromBoundingBoxes(boxes);
	        result = result || {};
	        result.boxes = boxes;
	        publishResult(result, _inputImageWrapper.data);
	    } else {
	        publishResult();
	    }
	}
	
	function update() {
	    var availableWorker;
	
	    if (_onUIThread) {
	        if (_workerPool.length > 0) {
	            availableWorker = _workerPool.filter(function (workerThread) {
	                return !workerThread.busy;
	            })[0];
	            if (availableWorker) {
	                _framegrabber.attachData(availableWorker.imageData);
	            } else {
	                return; // all workers are busy
	            }
	        } else {
	                _framegrabber.attachData(_inputImageWrapper.data);
	            }
	        if (_framegrabber.grab()) {
	            if (availableWorker) {
	                availableWorker.busy = true;
	                availableWorker.worker.postMessage({
	                    cmd: 'process',
	                    imageData: availableWorker.imageData
	                }, [availableWorker.imageData.buffer]);
	            } else {
	                locateAndDecode();
	            }
	        }
	    } else {
	        locateAndDecode();
	    }
	}
	
	function startContinuousUpdate() {
	    var next = null,
	        delay = 1000 / (_config.frequency || 60);
	
	    _stopped = false;
	    (function frame(timestamp) {
	        next = next || timestamp;
	        if (!_stopped) {
	            if (timestamp >= next) {
	                next += delay;
	                update();
	            }
	            window.requestAnimFrame(frame);
	        }
	    })(performance.now());
	}
	
	function _start() {
	    if (_onUIThread && _config.inputStream.type === "LiveStream") {
	        startContinuousUpdate();
	    } else {
	        update();
	    }
	}
	
	function initWorker(cb) {
	    var blobURL,
	        workerThread = {
	        worker: undefined,
	        imageData: new Uint8Array(_inputStream.getWidth() * _inputStream.getHeight()),
	        busy: true
	    };
	
	    blobURL = generateWorkerBlob();
	    workerThread.worker = new Worker(blobURL);
	
	    workerThread.worker.onmessage = function (e) {
	        if (e.data.event === 'initialized') {
	            URL.revokeObjectURL(blobURL);
	            workerThread.busy = false;
	            workerThread.imageData = new Uint8Array(e.data.imageData);
	            if (true) {
	                console.log("Worker initialized");
	            }
	            return cb(workerThread);
	        } else if (e.data.event === 'processed') {
	            workerThread.imageData = new Uint8Array(e.data.imageData);
	            workerThread.busy = false;
	            publishResult(e.data.result, workerThread.imageData);
	        } else if (e.data.event === 'error') {
	            if (true) {
	                console.log("Worker error: " + e.data.message);
	            }
	        }
	    };
	
	    workerThread.worker.postMessage({
	        cmd: 'init',
	        size: { x: _inputStream.getWidth(), y: _inputStream.getHeight() },
	        imageData: workerThread.imageData,
	        config: configForWorker(_config)
	    }, [workerThread.imageData.buffer]);
	}
	
	function configForWorker(config) {
	    return _extends({}, config, {
	        inputStream: _extends({}, config.inputStream, {
	            target: null
	        })
	    });
	}
	
	function workerInterface(factory) {
	    /* eslint-disable no-undef*/
	    if (factory) {
	        var Quagga = factory().default;
	        if (!Quagga) {
	            self.postMessage({ 'event': 'error', message: 'Quagga could not be created' });
	            return;
	        }
	    }
	    var imageWrapper;
	
	    self.onmessage = function (e) {
	        if (e.data.cmd === 'init') {
	            var config = e.data.config;
	            config.numOfWorkers = 0;
	            imageWrapper = new Quagga.ImageWrapper({
	                x: e.data.size.x,
	                y: e.data.size.y
	            }, new Uint8Array(e.data.imageData));
	            Quagga.init(config, ready, imageWrapper);
	            Quagga.onProcessed(onProcessed);
	        } else if (e.data.cmd === 'process') {
	            imageWrapper.data = new Uint8Array(e.data.imageData);
	            Quagga.start();
	        } else if (e.data.cmd === 'setReaders') {
	            Quagga.setReaders(e.data.readers);
	        }
	    };
	
	    function onProcessed(result) {
	        self.postMessage({
	            'event': 'processed',
	            imageData: imageWrapper.data,
	            result: result
	        }, [imageWrapper.data.buffer]);
	    }
	
	    function ready() {
	        // eslint-disable-line
	        self.postMessage({ 'event': 'initialized', imageData: imageWrapper.data }, [imageWrapper.data.buffer]);
	    }
	
	    /* eslint-enable */
	}
	
	function generateWorkerBlob() {
	    var blob, factorySource;
	
	    /* jshint ignore:start */
	    if (typeof __factorySource__ !== 'undefined') {
	        factorySource = __factorySource__; // eslint-disable-line no-undef
	    }
	    /* jshint ignore:end */
	
	    blob = new Blob(['(' + workerInterface.toString() + ')(' + factorySource + ');'], { type: 'text/javascript' });
	
	    return window.URL.createObjectURL(blob);
	}
	
	function _setReaders(readers) {
	    if (_decoder) {
	        _decoder.setReaders(readers);
	    } else if (_onUIThread && _workerPool.length > 0) {
	        _workerPool.forEach(function (workerThread) {
	            workerThread.worker.postMessage({ cmd: 'setReaders', readers: readers });
	        });
	    }
	}
	
	function adjustWorkerPool(capacity, cb) {
	    var increaseBy = capacity - _workerPool.length;
	    if (increaseBy === 0) {
	        return cb && cb();
	    }
	    if (increaseBy < 0) {
	        var workersToTerminate = _workerPool.slice(increaseBy);
	        workersToTerminate.forEach(function (workerThread) {
	            workerThread.worker.terminate();
	            if (true) {
	                console.log("Worker terminated!");
	            }
	        });
	        _workerPool = _workerPool.slice(0, increaseBy);
	        return cb && cb();
	    } else {
	        var workerInitialized = function workerInitialized(workerThread) {
	            _workerPool.push(workerThread);
	            if (_workerPool.length >= capacity) {
	                cb && cb();
	            }
	        };
	
	        for (var i = 0; i < increaseBy; i++) {
	            initWorker(workerInitialized);
	        }
	    }
	}
	
	/* harmony default export */ exports["default"] = {
	    init: function init(config, cb, imageWrapper) {
	        _config = /* harmony import */__WEBPACK_IMPORTED_MODULE_0_lodash_merge___default.a.bind()({}, /* harmony import */__WEBPACK_IMPORTED_MODULE_10__config_config__["a"], config);
	        if (imageWrapper) {
	            _onUIThread = false;
	            initializeData(imageWrapper);
	            return cb();
	        } else {
	            initInputStream(cb);
	        }
	    },
	    start: function start() {
	        _start();
	    },
	    stop: function stop() {
	        _stopped = true;
	        adjustWorkerPool(0);
	        if (_config.inputStream.type === "LiveStream") {
	            /* harmony import */__WEBPACK_IMPORTED_MODULE_7__input_camera_access__["a"].release();
	            _inputStream.clearEventHandlers();
	        }
	    },
	    pause: function pause() {
	        _stopped = true;
	    },
	    onDetected: function onDetected(callback) {
	        /* harmony import */__WEBPACK_IMPORTED_MODULE_6__common_events__["a"].subscribe("detected", callback);
	    },
	    offDetected: function offDetected(callback) {
	        /* harmony import */__WEBPACK_IMPORTED_MODULE_6__common_events__["a"].unsubscribe("detected", callback);
	    },
	    onProcessed: function onProcessed(callback) {
	        /* harmony import */__WEBPACK_IMPORTED_MODULE_6__common_events__["a"].subscribe("processed", callback);
	    },
	    offProcessed: function offProcessed(callback) {
	        /* harmony import */__WEBPACK_IMPORTED_MODULE_6__common_events__["a"].unsubscribe("processed", callback);
	    },
	    setReaders: function setReaders(readers) {
	        _setReaders(readers);
	    },
	    registerResultCollector: function registerResultCollector(resultCollector) {
	        if (resultCollector && typeof resultCollector.addResult === 'function') {
	            _resultCollector = resultCollector;
	        }
	    },
	    canvas: _canvasContainer,
	    decodeSingle: function decodeSingle(config, resultCallback) {
	        var _this = this;
	
	        config = /* harmony import */__WEBPACK_IMPORTED_MODULE_0_lodash_merge___default.a.bind()({
	            inputStream: {
	                type: "ImageStream",
	                sequence: false,
	                size: 800,
	                src: config.src
	            },
	            numOfWorkers: true && config.debug ? 0 : 1,
	            locator: {
	                halfSample: false
	            }
	        }, config);
	        this.init(config, function () {
	            /* harmony import */__WEBPACK_IMPORTED_MODULE_6__common_events__["a"].once("processed", function (result) {
	                _this.stop();
	                resultCallback.call(null, result);
	            }, true);
	            _start();
	        });
	    },
	    ImageWrapper: /* harmony import */__WEBPACK_IMPORTED_MODULE_3__common_image_wrapper__["a"],
	    ImageDebug: /* harmony import */__WEBPACK_IMPORTED_MODULE_8__common_image_debug__["a"],
	    ResultCollector: /* harmony import */__WEBPACK_IMPORTED_MODULE_9__analytics_result_collector__["a"]
	};

/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__common_image_debug__ = __webpack_require__(10);
	
	
	function contains(codeResult, list) {
	    if (list) {
	        return list.some(function (item) {
	            return Object.keys(item).every(function (key) {
	                return item[key] === codeResult[key];
	            });
	        });
	    }
	    return false;
	}
	
	function passesFilter(codeResult, filter) {
	    if (typeof filter === 'function') {
	        return filter(codeResult);
	    }
	    return true;
	}
	
	/* harmony default export */ exports["a"] = {
	    create: function create(config) {
	        var canvas = document.createElement("canvas"),
	            ctx = canvas.getContext("2d"),
	            results = [],
	            capacity = config.capacity || 20,
	            capture = config.capture === true;
	
	        function matchesConstraints(codeResult) {
	            return capacity && codeResult && !contains(codeResult, config.blacklist) && passesFilter(codeResult, config.filter);
	        }
	
	        return {
	            addResult: function addResult(data, imageSize, codeResult) {
	                var result = {};
	
	                if (matchesConstraints(codeResult)) {
	                    capacity--;
	                    result.codeResult = codeResult;
	                    if (capture) {
	                        canvas.width = imageSize.x;
	                        canvas.height = imageSize.y;
	                        /* harmony import */__WEBPACK_IMPORTED_MODULE_0__common_image_debug__["a"].drawImage(data, imageSize, ctx);
	                        result.frame = canvas.toDataURL();
	                    }
	                    results.push(result);
	                }
	            },
	            getResults: function getResults() {
	                return results;
	            }
	        };
	    }
	};

/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

	var vec2 = {
	    clone: __webpack_require__(7),
	    dot: __webpack_require__(31)
	};
	/**
	 * Creates a cluster for grouping similar orientations of datapoints
	 */
	/* harmony default export */ exports["a"] = {
	    create: function create(point, threshold) {
	        var points = [],
	            center = {
	            rad: 0,
	            vec: vec2.clone([0, 0])
	        },
	            pointMap = {};
	
	        function init() {
	            _add(point);
	            updateCenter();
	        }
	
	        function _add(pointToAdd) {
	            pointMap[pointToAdd.id] = pointToAdd;
	            points.push(pointToAdd);
	        }
	
	        function updateCenter() {
	            var i,
	                sum = 0;
	            for (i = 0; i < points.length; i++) {
	                sum += points[i].rad;
	            }
	            center.rad = sum / points.length;
	            center.vec = vec2.clone([Math.cos(center.rad), Math.sin(center.rad)]);
	        }
	
	        init();
	
	        return {
	            add: function add(pointToAdd) {
	                if (!pointMap[pointToAdd.id]) {
	                    _add(pointToAdd);
	                    updateCenter();
	                }
	            },
	            fits: function fits(otherPoint) {
	                // check cosine similarity to center-angle
	                var similarity = Math.abs(vec2.dot(otherPoint.point.vec, center.vec));
	                if (similarity > threshold) {
	                    return true;
	                }
	                return false;
	            },
	            getPoints: function getPoints() {
	                return points;
	            },
	            getCenter: function getCenter() {
	                return center;
	            }
	        };
	    },
	    createPoint: function createPoint(newPoint, id, property) {
	        return {
	            rad: newPoint[property],
	            point: newPoint,
	            id: id
	        };
	    }
	};

/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony default export */ exports["a"] = function () {
	    var events = {};
	
	    function getEvent(eventName) {
	        if (!events[eventName]) {
	            events[eventName] = {
	                subscribers: []
	            };
	        }
	        return events[eventName];
	    }
	
	    function clearEvents() {
	        events = {};
	    }
	
	    function publishSubscription(subscription, data) {
	        if (subscription.async) {
	            setTimeout(function () {
	                subscription.callback(data);
	            }, 4);
	        } else {
	            subscription.callback(data);
	        }
	    }
	
	    function _subscribe(event, callback, async) {
	        var subscription;
	
	        if (typeof callback === "function") {
	            subscription = {
	                callback: callback,
	                async: async
	            };
	        } else {
	            subscription = callback;
	            if (!subscription.callback) {
	                throw "Callback was not specified on options";
	            }
	        }
	
	        getEvent(event).subscribers.push(subscription);
	    }
	
	    return {
	        subscribe: function subscribe(event, callback, async) {
	            return _subscribe(event, callback, async);
	        },
	        publish: function publish(eventName, data) {
	            var event = getEvent(eventName),
	                subscribers = event.subscribers;
	
	            event.subscribers = subscribers.filter(function (subscriber) {
	                publishSubscription(subscriber, data);
	                return !subscriber.once;
	            });
	        },
	        once: function once(event, callback, async) {
	            _subscribe(event, {
	                callback: callback,
	                async: async,
	                once: true
	            });
	        },
	        unsubscribe: function unsubscribe(eventName, callback) {
	            var event;
	
	            if (eventName) {
	                event = getEvent(eventName);
	                if (event && callback) {
	                    event.subscribers = event.subscribers.filter(function (subscriber) {
	                        return subscriber.callback !== callback;
	                    });
	                } else {
	                    event.subscribers = [];
	                }
	            } else {
	                clearEvents();
	            }
	        }
	    };
	}();

/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Construct representing a part of another {ImageWrapper}. Shares data
	 * between the parent and the child.
	 * @param from {ImageRef} The position where to start the {SubImage} from. (top-left corner)
	 * @param size {ImageRef} The size of the resulting image
	 * @param I {ImageWrapper} The {ImageWrapper} to share from
	 * @returns {SubImage} A shared part of the original image
	 */
	function SubImage(from, size, I) {
	    if (!I) {
	        I = {
	            data: null,
	            size: size
	        };
	    }
	    this.data = I.data;
	    this.originalSize = I.size;
	    this.I = I;
	
	    this.from = from;
	    this.size = size;
	}
	
	/**
	 * Displays the {SubImage} in a given canvas
	 * @param canvas {Canvas} The canvas element to write to
	 * @param scale {Number} Scale which is applied to each pixel-value
	 */
	SubImage.prototype.show = function (canvas, scale) {
	    var ctx, frame, data, current, y, x, pixel;
	
	    if (!scale) {
	        scale = 1.0;
	    }
	    ctx = canvas.getContext('2d');
	    canvas.width = this.size.x;
	    canvas.height = this.size.y;
	    frame = ctx.getImageData(0, 0, canvas.width, canvas.height);
	    data = frame.data;
	    current = 0;
	    for (y = 0; y < this.size.y; y++) {
	        for (x = 0; x < this.size.x; x++) {
	            pixel = y * this.size.x + x;
	            current = this.get(x, y) * scale;
	            data[pixel * 4 + 0] = current;
	            data[pixel * 4 + 1] = current;
	            data[pixel * 4 + 2] = current;
	            data[pixel * 4 + 3] = 255;
	        }
	    }
	    frame.data = data;
	    ctx.putImageData(frame, 0, 0);
	};
	
	/**
	 * Retrieves a given pixel position from the {SubImage}
	 * @param x {Number} The x-position
	 * @param y {Number} The y-position
	 * @returns {Number} The grayscale value at the pixel-position
	 */
	SubImage.prototype.get = function (x, y) {
	    return this.data[(this.from.y + y) * this.originalSize.x + this.from.x + x];
	};
	
	/**
	 * Updates the underlying data from a given {ImageWrapper}
	 * @param image {ImageWrapper} The updated image
	 */
	SubImage.prototype.updateData = function (image) {
	    this.originalSize = image.size;
	    this.data = image.data;
	};
	
	/**
	 * Updates the position of the shared area
	 * @param from {x,y} The new location
	 * @returns {SubImage} returns {this} for possible chaining
	 */
	SubImage.prototype.updateFrom = function (from) {
	    this.from = from;
	    return this;
	};
	
	/* harmony default export */ exports["a"] = SubImage;

/***/ },
/* 54 */
/***/ function(module, exports) {

	/*
	 * typedefs.js
	 * Normalizes browser-specific prefixes
	 */
	
	if (typeof window !== 'undefined') {
	    window.requestAnimFrame = function () {
	        return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function ( /* function FrameRequestCallback */callback) {
	            window.setTimeout(callback, 1000 / 60);
	        };
	    }();
	}
	Math.imul = Math.imul || function (a, b) {
	    var ah = a >>> 16 & 0xffff,
	        al = a & 0xffff,
	        bh = b >>> 16 & 0xffff,
	        bl = b & 0xffff;
	    // the shift by 0 fixes the sign on the high part
	    // the final |0 converts the unsigned value into a signed value
	    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
	};

/***/ },
/* 55 */
/***/ function(module, exports, __webpack_require__) {

	module.e = {
	    inputStream: {
	        name: "Live",
	        type: "LiveStream",
	        constraints: {
	            width: 640,
	            height: 480,
	            // aspectRatio: 640/480, // optional
	            facingMode: "environment" },
	        // or user
	        // deviceId: "38745983457387598375983759834"
	        area: {
	            top: "0%",
	            right: "0%",
	            left: "0%",
	            bottom: "0%"
	        },
	        singleChannel: false // true: only the red color-channel is read
	    },
	    locate: true,
	    numOfWorkers: 0,
	    decoder: {
	        readers: ['code_128_reader'],
	        debug: {
	            drawBoundingBox: false,
	            showFrequency: false,
	            drawScanline: false,
	            showPattern: false
	        }
	    },
	    locator: {
	        halfSample: true,
	        patchSize: "medium", // x-small, small, medium, large, x-large
	        debug: {
	            showCanvas: false,
	            showPatches: false,
	            showFoundPatches: false,
	            showSkeleton: false,
	            showLabels: false,
	            showPatchLabels: false,
	            showRemainingPatchLabels: false,
	            boxFromPatches: {
	                showTransformed: false,
	                showTransformedBox: false,
	                showBB: false
	            }
	        }
	    }
	};

/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

	var config = void 0;
	
	if (true) {
	    config = __webpack_require__(55);
	} else if (ENV.node) {
	    config = require('./config.node.js');
	} else {
	    config = require('./config.prod.js');
	}
	
	/* harmony default export */ exports["a"] = config;

/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__bresenham__ = __webpack_require__(58);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_image_debug__ = __webpack_require__(10);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__reader_code_128_reader__ = __webpack_require__(67);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__reader_ean_reader__ = __webpack_require__(3);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__reader_code_39_reader__ = __webpack_require__(30);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__reader_code_39_vin_reader__ = __webpack_require__(68);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__reader_codabar_reader__ = __webpack_require__(66);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__reader_upc_reader__ = __webpack_require__(74);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__reader_ean_8_reader__ = __webpack_require__(71);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__reader_ean_2_reader__ = __webpack_require__(69);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__reader_ean_5_reader__ = __webpack_require__(70);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__reader_upc_e_reader__ = __webpack_require__(73);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__reader_i2of5_reader__ = __webpack_require__(72);
	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	var READERS = {
	    code_128_reader: /* harmony import */__WEBPACK_IMPORTED_MODULE_2__reader_code_128_reader__["a"],
	    ean_reader: /* harmony import */__WEBPACK_IMPORTED_MODULE_3__reader_ean_reader__["a"],
	    ean_5_reader: /* harmony import */__WEBPACK_IMPORTED_MODULE_10__reader_ean_5_reader__["a"],
	    ean_2_reader: /* harmony import */__WEBPACK_IMPORTED_MODULE_9__reader_ean_2_reader__["a"],
	    ean_8_reader: /* harmony import */__WEBPACK_IMPORTED_MODULE_8__reader_ean_8_reader__["a"],
	    code_39_reader: /* harmony import */__WEBPACK_IMPORTED_MODULE_4__reader_code_39_reader__["a"],
	    code_39_vin_reader: /* harmony import */__WEBPACK_IMPORTED_MODULE_5__reader_code_39_vin_reader__["a"],
	    codabar_reader: /* harmony import */__WEBPACK_IMPORTED_MODULE_6__reader_codabar_reader__["a"],
	    upc_reader: /* harmony import */__WEBPACK_IMPORTED_MODULE_7__reader_upc_reader__["a"],
	    upc_e_reader: /* harmony import */__WEBPACK_IMPORTED_MODULE_11__reader_upc_e_reader__["a"],
	    i2of5_reader: /* harmony import */__WEBPACK_IMPORTED_MODULE_12__reader_i2of5_reader__["a"]
	};
	/* harmony default export */ exports["a"] = {
	    create: function create(config, inputImageWrapper) {
	        var _canvas = {
	            ctx: {
	                frequency: null,
	                pattern: null,
	                overlay: null
	            },
	            dom: {
	                frequency: null,
	                pattern: null,
	                overlay: null
	            }
	        },
	            _barcodeReaders = [];
	
	        initCanvas();
	        initReaders();
	        initConfig();
	
	        function initCanvas() {
	            if (true && typeof document !== 'undefined') {
	                var $debug = document.querySelector("#debug.detection");
	                _canvas.dom.frequency = document.querySelector("canvas.frequency");
	                if (!_canvas.dom.frequency) {
	                    _canvas.dom.frequency = document.createElement("canvas");
	                    _canvas.dom.frequency.className = "frequency";
	                    if ($debug) {
	                        $debug.appendChild(_canvas.dom.frequency);
	                    }
	                }
	                _canvas.ctx.frequency = _canvas.dom.frequency.getContext("2d");
	
	                _canvas.dom.pattern = document.querySelector("canvas.patternBuffer");
	                if (!_canvas.dom.pattern) {
	                    _canvas.dom.pattern = document.createElement("canvas");
	                    _canvas.dom.pattern.className = "patternBuffer";
	                    if ($debug) {
	                        $debug.appendChild(_canvas.dom.pattern);
	                    }
	                }
	                _canvas.ctx.pattern = _canvas.dom.pattern.getContext("2d");
	
	                _canvas.dom.overlay = document.querySelector("canvas.drawingBuffer");
	                if (_canvas.dom.overlay) {
	                    _canvas.ctx.overlay = _canvas.dom.overlay.getContext("2d");
	                }
	            }
	        }
	
	        function initReaders() {
	            config.readers.forEach(function (readerConfig) {
	                var reader,
	                    configuration = {},
	                    supplements = [];
	
	                if ((typeof readerConfig === 'undefined' ? 'undefined' : _typeof(readerConfig)) === 'object') {
	                    reader = readerConfig.format;
	                    configuration = readerConfig.config;
	                } else if (typeof readerConfig === 'string') {
	                    reader = readerConfig;
	                }
	                if (true) {
	                    console.log("Before registering reader: ", reader);
	                }
	                if (configuration.supplements) {
	                    supplements = configuration.supplements.map(function (supplement) {
	                        return new READERS[supplement]();
	                    });
	                }
	                _barcodeReaders.push(new READERS[reader](configuration, supplements));
	            });
	            if (true) {
	                console.log("Registered Readers: " + _barcodeReaders.map(function (reader) {
	                    return JSON.stringify({ format: reader.FORMAT, config: reader.config });
	                }).join(', '));
	            }
	        }
	
	        function initConfig() {
	            if (true && typeof document !== 'undefined') {
	                var i,
	                    vis = [{
	                    node: _canvas.dom.frequency,
	                    prop: config.debug.showFrequency
	                }, {
	                    node: _canvas.dom.pattern,
	                    prop: config.debug.showPattern
	                }];
	
	                for (i = 0; i < vis.length; i++) {
	                    if (vis[i].prop === true) {
	                        vis[i].node.style.display = "block";
	                    } else {
	                        vis[i].node.style.display = "none";
	                    }
	                }
	            }
	        }
	
	        /**
	         * extend the line on both ends
	         * @param {Array} line
	         * @param {Number} angle
	         */
	        function getExtendedLine(line, angle, ext) {
	            function extendLine(amount) {
	                var extension = {
	                    y: amount * Math.sin(angle),
	                    x: amount * Math.cos(angle)
	                };
	
	                line[0].y -= extension.y;
	                line[0].x -= extension.x;
	                line[1].y += extension.y;
	                line[1].x += extension.x;
	            }
	
	            // check if inside image
	            extendLine(ext);
	            while (ext > 1 && (!inputImageWrapper.inImageWithBorder(line[0], 0) || !inputImageWrapper.inImageWithBorder(line[1], 0))) {
	                ext -= Math.ceil(ext / 2);
	                extendLine(-ext);
	            }
	            return line;
	        }
	
	        function getLine(box) {
	            return [{
	                x: (box[1][0] - box[0][0]) / 2 + box[0][0],
	                y: (box[1][1] - box[0][1]) / 2 + box[0][1]
	            }, {
	                x: (box[3][0] - box[2][0]) / 2 + box[2][0],
	                y: (box[3][1] - box[2][1]) / 2 + box[2][1]
	            }];
	        }
	
	        function tryDecode(line) {
	            var result = null,
	                i,
	                barcodeLine = /* harmony import */__WEBPACK_IMPORTED_MODULE_0__bresenham__["a"].getBarcodeLine(inputImageWrapper, line[0], line[1]);
	
	            if (true && config.debug.showFrequency) {
	                /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_image_debug__["a"].drawPath(line, { x: 'x', y: 'y' }, _canvas.ctx.overlay, { color: 'red', lineWidth: 3 });
	                /* harmony import */__WEBPACK_IMPORTED_MODULE_0__bresenham__["a"].debug.printFrequency(barcodeLine.line, _canvas.dom.frequency);
	            }
	
	            /* harmony import */__WEBPACK_IMPORTED_MODULE_0__bresenham__["a"].toBinaryLine(barcodeLine);
	
	            if (true && config.debug.showPattern) {
	                /* harmony import */__WEBPACK_IMPORTED_MODULE_0__bresenham__["a"].debug.printPattern(barcodeLine.line, _canvas.dom.pattern);
	            }
	
	            for (i = 0; i < _barcodeReaders.length && result === null; i++) {
	                result = _barcodeReaders[i].decodePattern(barcodeLine.line);
	            }
	            if (result === null) {
	                return null;
	            }
	            return {
	                codeResult: result,
	                barcodeLine: barcodeLine
	            };
	        }
	
	        /**
	         * This method slices the given area apart and tries to detect a barcode-pattern
	         * for each slice. It returns the decoded barcode, or null if nothing was found
	         * @param {Array} box
	         * @param {Array} line
	         * @param {Number} lineAngle
	         */
	        function tryDecodeBruteForce(box, line, lineAngle) {
	            var sideLength = Math.sqrt(Math.pow(box[1][0] - box[0][0], 2) + Math.pow(box[1][1] - box[0][1], 2)),
	                i,
	                slices = 16,
	                result = null,
	                dir,
	                extension,
	                xdir = Math.sin(lineAngle),
	                ydir = Math.cos(lineAngle);
	
	            for (i = 1; i < slices && result === null; i++) {
	                // move line perpendicular to angle
	                dir = sideLength / slices * i * (i % 2 === 0 ? -1 : 1);
	                extension = {
	                    y: dir * xdir,
	                    x: dir * ydir
	                };
	                line[0].y += extension.x;
	                line[0].x -= extension.y;
	                line[1].y += extension.x;
	                line[1].x -= extension.y;
	
	                result = tryDecode(line);
	            }
	            return result;
	        }
	
	        function getLineLength(line) {
	            return Math.sqrt(Math.pow(Math.abs(line[1].y - line[0].y), 2) + Math.pow(Math.abs(line[1].x - line[0].x), 2));
	        }
	
	        /**
	         * With the help of the configured readers (Code128 or EAN) this function tries to detect a
	         * valid barcode pattern within the given area.
	         * @param {Object} box The area to search in
	         * @returns {Object} the result {codeResult, line, angle, pattern, threshold}
	         */
	        function _decodeFromBoundingBox(box) {
	            var line,
	                lineAngle,
	                ctx = _canvas.ctx.overlay,
	                result,
	                lineLength;
	
	            if (true) {
	                if (config.debug.drawBoundingBox && ctx) {
	                    /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_image_debug__["a"].drawPath(box, { x: 0, y: 1 }, ctx, { color: "blue", lineWidth: 2 });
	                }
	            }
	
	            line = getLine(box);
	            lineLength = getLineLength(line);
	            lineAngle = Math.atan2(line[1].y - line[0].y, line[1].x - line[0].x);
	            line = getExtendedLine(line, lineAngle, Math.floor(lineLength * 0.1));
	            if (line === null) {
	                return null;
	            }
	
	            result = tryDecode(line);
	            if (result === null) {
	                result = tryDecodeBruteForce(box, line, lineAngle);
	            }
	
	            if (result === null) {
	                return null;
	            }
	
	            if (true && result && config.debug.drawScanline && ctx) {
	                /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_image_debug__["a"].drawPath(line, { x: 'x', y: 'y' }, ctx, { color: 'red', lineWidth: 3 });
	            }
	
	            return {
	                codeResult: result.codeResult,
	                line: line,
	                angle: lineAngle,
	                pattern: result.barcodeLine.line,
	                threshold: result.barcodeLine.threshold
	            };
	        }
	
	        return {
	            decodeFromBoundingBox: function decodeFromBoundingBox(box) {
	                return _decodeFromBoundingBox(box);
	            },
	            decodeFromBoundingBoxes: function decodeFromBoundingBoxes(boxes) {
	                var i,
	                    result,
	                    barcodes = [],
	                    multiple = config.multiple;
	
	                for (i = 0; i < boxes.length; i++) {
	                    var box = boxes[i];
	                    result = _decodeFromBoundingBox(box) || {};
	                    result.box = box;
	
	                    if (multiple) {
	                        barcodes.push(result);
	                    } else if (result.codeResult) {
	                        return result;
	                    }
	                }
	
	                if (multiple) {
	                    return {
	                        barcodes: barcodes
	                    };
	                }
	            },
	            setReaders: function setReaders(readers) {
	                config.readers = readers;
	                _barcodeReaders.length = 0;
	                initReaders();
	            }
	        };
	    }
	};

/***/ },
/* 58 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__ = __webpack_require__(19);
	
	
	var Bresenham = {};
	
	var Slope = {
	    DIR: {
	        UP: 1,
	        DOWN: -1
	    }
	};
	/**
	 * Scans a line of the given image from point p1 to p2 and returns a result object containing
	 * gray-scale values (0-255) of the underlying pixels in addition to the min
	 * and max values.
	 * @param {Object} imageWrapper
	 * @param {Object} p1 The start point {x,y}
	 * @param {Object} p2 The end point {x,y}
	 * @returns {line, min, max}
	 */
	Bresenham.getBarcodeLine = function (imageWrapper, p1, p2) {
	    var x0 = p1.x | 0,
	        y0 = p1.y | 0,
	        x1 = p2.x | 0,
	        y1 = p2.y | 0,
	        steep = Math.abs(y1 - y0) > Math.abs(x1 - x0),
	        deltax,
	        deltay,
	        error,
	        ystep,
	        y,
	        tmp,
	        x,
	        line = [],
	        imageData = imageWrapper.data,
	        width = imageWrapper.size.x,
	        sum = 0,
	        val,
	        min = 255,
	        max = 0;
	
	    function read(a, b) {
	        val = imageData[b * width + a];
	        sum += val;
	        min = val < min ? val : min;
	        max = val > max ? val : max;
	        line.push(val);
	    }
	
	    if (steep) {
	        tmp = x0;
	        x0 = y0;
	        y0 = tmp;
	
	        tmp = x1;
	        x1 = y1;
	        y1 = tmp;
	    }
	    if (x0 > x1) {
	        tmp = x0;
	        x0 = x1;
	        x1 = tmp;
	
	        tmp = y0;
	        y0 = y1;
	        y1 = tmp;
	    }
	    deltax = x1 - x0;
	    deltay = Math.abs(y1 - y0);
	    error = deltax / 2 | 0;
	    y = y0;
	    ystep = y0 < y1 ? 1 : -1;
	    for (x = x0; x < x1; x++) {
	        if (steep) {
	            read(y, x);
	        } else {
	            read(x, y);
	        }
	        error = error - deltay;
	        if (error < 0) {
	            y = y + ystep;
	            error = error + deltax;
	        }
	    }
	
	    return {
	        line: line,
	        min: min,
	        max: max
	    };
	};
	
	/**
	 * Converts the result from getBarcodeLine into a binary representation
	 * also considering the frequency and slope of the signal for more robust results
	 * @param {Object} result {line, min, max}
	 */
	Bresenham.toBinaryLine = function (result) {
	    var min = result.min,
	        max = result.max,
	        line = result.line,
	        slope,
	        slope2,
	        center = min + (max - min) / 2,
	        extrema = [],
	        currentDir,
	        dir,
	        threshold = (max - min) / 12,
	        rThreshold = -threshold,
	        i,
	        j;
	
	    // 1. find extrema
	    currentDir = line[0] > center ? Slope.DIR.UP : Slope.DIR.DOWN;
	    extrema.push({
	        pos: 0,
	        val: line[0]
	    });
	    for (i = 0; i < line.length - 2; i++) {
	        slope = line[i + 1] - line[i];
	        slope2 = line[i + 2] - line[i + 1];
	        if (slope + slope2 < rThreshold && line[i + 1] < center * 1.5) {
	            dir = Slope.DIR.DOWN;
	        } else if (slope + slope2 > threshold && line[i + 1] > center * 0.5) {
	            dir = Slope.DIR.UP;
	        } else {
	            dir = currentDir;
	        }
	
	        if (currentDir !== dir) {
	            extrema.push({
	                pos: i,
	                val: line[i]
	            });
	            currentDir = dir;
	        }
	    }
	    extrema.push({
	        pos: line.length,
	        val: line[line.length - 1]
	    });
	
	    for (j = extrema[0].pos; j < extrema[1].pos; j++) {
	        line[j] = line[j] > center ? 0 : 1;
	    }
	
	    // iterate over extrema and convert to binary based on avg between minmax
	    for (i = 1; i < extrema.length - 1; i++) {
	        if (extrema[i + 1].val > extrema[i].val) {
	            threshold = extrema[i].val + (extrema[i + 1].val - extrema[i].val) / 3 * 2 | 0;
	        } else {
	            threshold = extrema[i + 1].val + (extrema[i].val - extrema[i + 1].val) / 3 | 0;
	        }
	
	        for (j = extrema[i].pos; j < extrema[i + 1].pos; j++) {
	            line[j] = line[j] > threshold ? 0 : 1;
	        }
	    }
	
	    return {
	        line: line,
	        threshold: threshold
	    };
	};
	
	/**
	 * Used for development only
	 */
	Bresenham.debug = {
	    printFrequency: function printFrequency(line, canvas) {
	        var i,
	            ctx = canvas.getContext("2d");
	        canvas.width = line.length;
	        canvas.height = 256;
	
	        ctx.beginPath();
	        ctx.strokeStyle = "blue";
	        for (i = 0; i < line.length; i++) {
	            ctx.moveTo(i, 255);
	            ctx.lineTo(i, 255 - line[i]);
	        }
	        ctx.stroke();
	        ctx.closePath();
	    },
	
	    printPattern: function printPattern(line, canvas) {
	        var ctx = canvas.getContext("2d"),
	            i;
	
	        canvas.width = line.length;
	        ctx.fillColor = "black";
	        for (i = 0; i < line.length; i++) {
	            if (line[i] === 1) {
	                ctx.fillRect(i, 0, 1, 100);
	            }
	        }
	    }
	};
	
	/* harmony default export */ exports["a"] = Bresenham;

/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_pick__ = __webpack_require__(145);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_pick___default = __WEBPACK_IMPORTED_MODULE_0_lodash_pick__ && __WEBPACK_IMPORTED_MODULE_0_lodash_pick__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_lodash_pick__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_lodash_pick__; }
	/* harmony import */ Object.defineProperty(__WEBPACK_IMPORTED_MODULE_0_lodash_pick___default, 'a', { get: __WEBPACK_IMPORTED_MODULE_0_lodash_pick___default });
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash_merge__ = __webpack_require__(17);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash_merge___default = __WEBPACK_IMPORTED_MODULE_1_lodash_merge__ && __WEBPACK_IMPORTED_MODULE_1_lodash_merge__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_1_lodash_merge__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_1_lodash_merge__; }
	/* harmony import */ Object.defineProperty(__WEBPACK_IMPORTED_MODULE_1_lodash_merge___default, 'a', { get: __WEBPACK_IMPORTED_MODULE_1_lodash_merge___default });
	
	
	
	
	var streamRef, loadedDataHandler;
	
	function waitForVideo(video) {
	    return new Promise(function (resolve, reject) {
	        var attempts = 10;
	
	        function checkVideo() {
	            if (attempts > 0) {
	                if (video.videoWidth > 0 && video.videoHeight > 0) {
	                    if (true) {
	                        console.log(video.videoWidth + "px x " + video.videoHeight + "px");
	                    }
	                    resolve();
	                } else {
	                    window.setTimeout(checkVideo, 500);
	                }
	            } else {
	                reject('Unable to play video stream. Is webcam working?');
	            }
	            attempts--;
	        }
	        checkVideo();
	    });
	}
	
	/**
	 * Tries to attach the camera-stream to a given video-element
	 * and calls the callback function when the content is ready
	 * @param {Object} constraints
	 * @param {Object} video
	 */
	function initCamera(video, constraints) {
	    return navigator.mediaDevices.getUserMedia(constraints).then(function (stream) {
	        return new Promise(function (resolve, reject) {
	            streamRef = stream;
	            video.src = window.URL.createObjectURL(stream);
	            video.onloadedmetadata = function (e) {
	                video.play();
	                resolve();
	            };
	        });
	    }).then(waitForVideo.bind(null, video));
	}
	
	function deprecatedConstraints(videoConstraints) {
	    var normalized = /* harmony import */__WEBPACK_IMPORTED_MODULE_0_lodash_pick___default.a.bind()(videoConstraints, ["width", "height", "facingMode", "aspectRatio", "deviceId"]);
	
	    if (typeof videoConstraints["minAspectRatio"] !== 'undefined' && videoConstraints["minAspectRatio"] > 0) {
	        normalized["aspectRatio"] = videoConstraints["minAspectRatio"];
	        console.log("WARNING: Constraint 'minAspectRatio' is deprecated; Use 'aspectRatio' instead");
	    }
	    if (typeof videoConstraints["facing"] !== 'undefined') {
	        normalized["facingMode"] = videoConstraints["facing"];
	        console.log("WARNING: Constraint 'facing' is deprecated. Use 'facingMode' instead'");
	    }
	    return normalized;
	}
	
	function applyCameraFacing(facing, constraints) {
	    if (typeof constraints.video.deviceId !== 'undefined' || !facing) {
	        return Promise.resolve(constraints);
	    }
	    if (typeof MediaStreamTrack !== 'undefined' && typeof MediaStreamTrack.getSources !== 'undefined') {
	        return new Promise(function (resolve, reject) {
	            MediaStreamTrack.getSources(function (sourceInfos) {
	                var videoSource = sourceInfos.filter(function (sourceInfo) {
	                    return sourceInfo.kind === "video" && sourceInfo.facing === facing;
	                })[0];
	                if (videoSource) {
	                    return resolve(/* harmony import */__WEBPACK_IMPORTED_MODULE_1_lodash_merge___default.a.bind()({}, constraints, { video: { deviceId: videoSource.id } }));
	                }
	                return resolve(constraints);
	            });
	        });
	    }
	    return Promise.resolve(/* harmony import */__WEBPACK_IMPORTED_MODULE_1_lodash_merge___default.a.bind()({}, constraints, { video: { facingMode: facing } }));
	}
	
	function pickConstraints(videoConstraints) {
	    var constraints = {
	        audio: false,
	        video: deprecatedConstraints(videoConstraints)
	    };
	    return applyCameraFacing(constraints.video.facingMode, constraints);
	}
	
	/* harmony default export */ exports["a"] = {
	    request: function request(video, videoConstraints) {
	        return pickConstraints(videoConstraints).then(initCamera.bind(null, video));
	    },
	    release: function release() {
	        var tracks = streamRef && streamRef.getVideoTracks();
	        if (tracks && tracks.length) {
	            tracks[0].stop();
	        }
	        streamRef = null;
	    }
	};

/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__common_cv_utils__ = __webpack_require__(18);
	
	
	var FrameGrabber = {};
	
	FrameGrabber.create = function (inputStream, canvas) {
	    var _that = {},
	        _streamConfig = inputStream.getConfig(),
	        _video_size = /* harmony import */__WEBPACK_IMPORTED_MODULE_0__common_cv_utils__["f"].bind()(inputStream.getRealWidth(), inputStream.getRealHeight()),
	        _canvasSize = inputStream.getCanvasSize(),
	        _size = /* harmony import */__WEBPACK_IMPORTED_MODULE_0__common_cv_utils__["f"].bind()(inputStream.getWidth(), inputStream.getHeight()),
	        topRight = inputStream.getTopRight(),
	        _sx = topRight.x,
	        _sy = topRight.y,
	        _canvas,
	        _ctx = null,
	        _data = null;
	
	    _canvas = canvas ? canvas : document.createElement("canvas");
	    _canvas.width = _canvasSize.x;
	    _canvas.height = _canvasSize.y;
	    _ctx = _canvas.getContext("2d");
	    _data = new Uint8Array(_size.x * _size.y);
	    if (true) {
	        console.log("FrameGrabber", JSON.stringify({
	            size: _size,
	            topRight: topRight,
	            videoSize: _video_size,
	            canvasSize: _canvasSize
	        }));
	    }
	
	    /**
	     * Uses the given array as frame-buffer
	     */
	    _that.attachData = function (data) {
	        _data = data;
	    };
	
	    /**
	     * Returns the used frame-buffer
	     */
	    _that.getData = function () {
	        return _data;
	    };
	
	    /**
	     * Fetches a frame from the input-stream and puts into the frame-buffer.
	     * The image-data is converted to gray-scale and then half-sampled if configured.
	     */
	    _that.grab = function () {
	        var doHalfSample = _streamConfig.halfSample,
	            frame = inputStream.getFrame(),
	            ctxData;
	        if (frame) {
	            _ctx.drawImage(frame, 0, 0, _canvasSize.x, _canvasSize.y);
	            ctxData = _ctx.getImageData(_sx, _sy, _size.x, _size.y).data;
	            if (doHalfSample) {
	                /* harmony import */__WEBPACK_IMPORTED_MODULE_0__common_cv_utils__["i"].bind()(ctxData, _size, _data);
	            } else {
	                /* harmony import */__WEBPACK_IMPORTED_MODULE_0__common_cv_utils__["j"].bind()(ctxData, _data, _streamConfig);
	            }
	            return true;
	        } else {
	            return false;
	        }
	    };
	
	    _that.getSize = function () {
	        return _size;
	    };
	
	    return _that;
	};
	
	/* harmony default export */ exports["a"] = FrameGrabber;

/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

	var ImageLoader = {};
	ImageLoader.load = function (directory, callback, offset, size, sequence) {
	    var htmlImagesSrcArray = new Array(size),
	        htmlImagesArray = new Array(htmlImagesSrcArray.length),
	        i,
	        img,
	        num;
	
	    if (sequence === false) {
	        htmlImagesSrcArray[0] = directory;
	    } else {
	        for (i = 0; i < htmlImagesSrcArray.length; i++) {
	            num = offset + i;
	            htmlImagesSrcArray[i] = directory + "image-" + ("00" + num).slice(-3) + ".jpg";
	        }
	    }
	    htmlImagesArray.notLoaded = [];
	    htmlImagesArray.addImage = function (image) {
	        htmlImagesArray.notLoaded.push(image);
	    };
	    htmlImagesArray.loaded = function (loadedImg) {
	        var notloadedImgs = htmlImagesArray.notLoaded;
	        for (var x = 0; x < notloadedImgs.length; x++) {
	            if (notloadedImgs[x] === loadedImg) {
	                notloadedImgs.splice(x, 1);
	                for (var y = 0; y < htmlImagesSrcArray.length; y++) {
	                    var imgName = htmlImagesSrcArray[y].substr(htmlImagesSrcArray[y].lastIndexOf("/"));
	                    if (loadedImg.src.lastIndexOf(imgName) !== -1) {
	                        htmlImagesArray[y] = loadedImg;
	                        break;
	                    }
	                }
	                break;
	            }
	        }
	        if (notloadedImgs.length === 0) {
	            if (true) {
	                console.log("Images loaded");
	            }
	            callback.apply(null, [htmlImagesArray]);
	        }
	    };
	
	    for (i = 0; i < htmlImagesSrcArray.length; i++) {
	        img = new Image();
	        htmlImagesArray.addImage(img);
	        addOnloadHandler(img, htmlImagesArray);
	        img.src = htmlImagesSrcArray[i];
	    }
	};
	
	function addOnloadHandler(img, htmlImagesArray) {
	    img.onload = function () {
	        htmlImagesArray.loaded(this);
	    };
	}
	
	/* harmony default export */ exports["a"] = ImageLoader;

/***/ },
/* 62 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__image_loader__ = __webpack_require__(61);
	
	
	var InputStream = {};
	InputStream.createVideoStream = function (video) {
	    var that = {},
	        _config = null,
	        _eventNames = ['canrecord', 'ended'],
	        _eventHandlers = {},
	        _calculatedWidth,
	        _calculatedHeight,
	        _topRight = { x: 0, y: 0 },
	        _canvasSize = { x: 0, y: 0 };
	
	    function initSize() {
	        var width = video.videoWidth,
	            height = video.videoHeight;
	
	        _calculatedWidth = _config.size ? width / height > 1 ? _config.size : Math.floor(width / height * _config.size) : width;
	        _calculatedHeight = _config.size ? width / height > 1 ? Math.floor(height / width * _config.size) : _config.size : height;
	
	        _canvasSize.x = _calculatedWidth;
	        _canvasSize.y = _calculatedHeight;
	    }
	
	    that.getRealWidth = function () {
	        return video.videoWidth;
	    };
	
	    that.getRealHeight = function () {
	        return video.videoHeight;
	    };
	
	    that.getWidth = function () {
	        return _calculatedWidth;
	    };
	
	    that.getHeight = function () {
	        return _calculatedHeight;
	    };
	
	    that.setWidth = function (width) {
	        _calculatedWidth = width;
	    };
	
	    that.setHeight = function (height) {
	        _calculatedHeight = height;
	    };
	
	    that.setInputStream = function (config) {
	        _config = config;
	        video.src = typeof config.src !== 'undefined' ? config.src : '';
	    };
	
	    that.ended = function () {
	        return video.ended;
	    };
	
	    that.getConfig = function () {
	        return _config;
	    };
	
	    that.setAttribute = function (name, value) {
	        video.setAttribute(name, value);
	    };
	
	    that.pause = function () {
	        video.pause();
	    };
	
	    that.play = function () {
	        video.play();
	    };
	
	    that.setCurrentTime = function (time) {
	        if (_config.type !== "LiveStream") {
	            video.currentTime = time;
	        }
	    };
	
	    that.addEventListener = function (event, f, bool) {
	        if (_eventNames.indexOf(event) !== -1) {
	            if (!_eventHandlers[event]) {
	                _eventHandlers[event] = [];
	            }
	            _eventHandlers[event].push(f);
	        } else {
	            video.addEventListener(event, f, bool);
	        }
	    };
	
	    that.clearEventHandlers = function () {
	        _eventNames.forEach(function (eventName) {
	            var handlers = _eventHandlers[eventName];
	            if (handlers && handlers.length > 0) {
	                handlers.forEach(function (handler) {
	                    video.removeEventListener(eventName, handler);
	                });
	            }
	        });
	    };
	
	    that.trigger = function (eventName, args) {
	        var j,
	            handlers = _eventHandlers[eventName];
	
	        if (eventName === 'canrecord') {
	            initSize();
	        }
	        if (handlers && handlers.length > 0) {
	            for (j = 0; j < handlers.length; j++) {
	                handlers[j].apply(that, args);
	            }
	        }
	    };
	
	    that.setTopRight = function (topRight) {
	        _topRight.x = topRight.x;
	        _topRight.y = topRight.y;
	    };
	
	    that.getTopRight = function () {
	        return _topRight;
	    };
	
	    that.setCanvasSize = function (size) {
	        _canvasSize.x = size.x;
	        _canvasSize.y = size.y;
	    };
	
	    that.getCanvasSize = function () {
	        return _canvasSize;
	    };
	
	    that.getFrame = function () {
	        return video;
	    };
	
	    return that;
	};
	
	InputStream.createLiveStream = function (video) {
	    video.setAttribute("autoplay", true);
	    var that = InputStream.createVideoStream(video);
	
	    that.ended = function () {
	        return false;
	    };
	
	    return that;
	};
	
	InputStream.createImageStream = function () {
	    var that = {};
	    var _config = null;
	
	    var width = 0,
	        height = 0,
	        frameIdx = 0,
	        paused = true,
	        loaded = false,
	        imgArray = null,
	        size = 0,
	        offset = 1,
	        baseUrl = null,
	        ended = false,
	        calculatedWidth,
	        calculatedHeight,
	        _eventNames = ['canrecord', 'ended'],
	        _eventHandlers = {},
	        _topRight = { x: 0, y: 0 },
	        _canvasSize = { x: 0, y: 0 };
	
	    function loadImages() {
	        loaded = false;
	        /* harmony import */__WEBPACK_IMPORTED_MODULE_0__image_loader__["a"].load(baseUrl, function (imgs) {
	            imgArray = imgs;
	            width = imgs[0].width;
	            height = imgs[0].height;
	            calculatedWidth = _config.size ? width / height > 1 ? _config.size : Math.floor(width / height * _config.size) : width;
	            calculatedHeight = _config.size ? width / height > 1 ? Math.floor(height / width * _config.size) : _config.size : height;
	            _canvasSize.x = calculatedWidth;
	            _canvasSize.y = calculatedHeight;
	            loaded = true;
	            frameIdx = 0;
	            setTimeout(function () {
	                publishEvent("canrecord", []);
	            }, 0);
	        }, offset, size, _config.sequence);
	    }
	
	    function publishEvent(eventName, args) {
	        var j,
	            handlers = _eventHandlers[eventName];
	
	        if (handlers && handlers.length > 0) {
	            for (j = 0; j < handlers.length; j++) {
	                handlers[j].apply(that, args);
	            }
	        }
	    }
	
	    that.trigger = publishEvent;
	
	    that.getWidth = function () {
	        return calculatedWidth;
	    };
	
	    that.getHeight = function () {
	        return calculatedHeight;
	    };
	
	    that.setWidth = function (newWidth) {
	        calculatedWidth = newWidth;
	    };
	
	    that.setHeight = function (newHeight) {
	        calculatedHeight = newHeight;
	    };
	
	    that.getRealWidth = function () {
	        return width;
	    };
	
	    that.getRealHeight = function () {
	        return height;
	    };
	
	    that.setInputStream = function (stream) {
	        _config = stream;
	        if (stream.sequence === false) {
	            baseUrl = stream.src;
	            size = 1;
	        } else {
	            baseUrl = stream.src;
	            size = stream.length;
	        }
	        loadImages();
	    };
	
	    that.ended = function () {
	        return ended;
	    };
	
	    that.setAttribute = function () {};
	
	    that.getConfig = function () {
	        return _config;
	    };
	
	    that.pause = function () {
	        paused = true;
	    };
	
	    that.play = function () {
	        paused = false;
	    };
	
	    that.setCurrentTime = function (time) {
	        frameIdx = time;
	    };
	
	    that.addEventListener = function (event, f) {
	        if (_eventNames.indexOf(event) !== -1) {
	            if (!_eventHandlers[event]) {
	                _eventHandlers[event] = [];
	            }
	            _eventHandlers[event].push(f);
	        }
	    };
	
	    that.setTopRight = function (topRight) {
	        _topRight.x = topRight.x;
	        _topRight.y = topRight.y;
	    };
	
	    that.getTopRight = function () {
	        return _topRight;
	    };
	
	    that.setCanvasSize = function (canvasSize) {
	        _canvasSize.x = canvasSize.x;
	        _canvasSize.y = canvasSize.y;
	    };
	
	    that.getCanvasSize = function () {
	        return _canvasSize;
	    };
	
	    that.getFrame = function () {
	        var frame;
	
	        if (!loaded) {
	            return null;
	        }
	        if (!paused) {
	            frame = imgArray[frameIdx];
	            if (frameIdx < size - 1) {
	                frameIdx++;
	            } else {
	                setTimeout(function () {
	                    ended = true;
	                    publishEvent("ended", []);
	                }, 0);
	            }
	        }
	        return frame;
	    };
	
	    return that;
	};
	
	/* harmony default export */ exports["a"] = InputStream;

/***/ },
/* 63 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__ = __webpack_require__(19);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_cv_utils__ = __webpack_require__(18);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__common_array_helper__ = __webpack_require__(9);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__common_image_debug__ = __webpack_require__(10);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__rasterizer__ = __webpack_require__(64);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__tracer__ = __webpack_require__(29);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__skeletonizer__ = __webpack_require__(65);
	
	
	
	
	
	
	
	var vec2 = {
	    clone: __webpack_require__(7),
	    dot: __webpack_require__(31),
	    scale: __webpack_require__(78),
	    transformMat2: __webpack_require__(79)
	};
	var mat2 = {
	    copy: __webpack_require__(75),
	    create: __webpack_require__(76),
	    invert: __webpack_require__(77)
	};
	
	var _config,
	    _currentImageWrapper,
	    _skelImageWrapper,
	    _subImageWrapper,
	    _labelImageWrapper,
	    _patchGrid,
	    _patchLabelGrid,
	    _imageToPatchGrid,
	    _binaryImageWrapper,
	    _patchSize,
	    _canvasContainer = {
	    ctx: {
	        binary: null
	    },
	    dom: {
	        binary: null
	    }
	},
	    _numPatches = { x: 0, y: 0 },
	    _inputImageWrapper,
	    _skeletonizer;
	
	function initBuffers() {
	    var skeletonImageData;
	
	    if (_config.halfSample) {
	        _currentImageWrapper = new /* harmony import */__WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a"]({
	            x: _inputImageWrapper.size.x / 2 | 0,
	            y: _inputImageWrapper.size.y / 2 | 0
	        });
	    } else {
	        _currentImageWrapper = _inputImageWrapper;
	    }
	
	    _patchSize = /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["b"].bind()(_config.patchSize, _currentImageWrapper.size);
	
	    _numPatches.x = _currentImageWrapper.size.x / _patchSize.x | 0;
	    _numPatches.y = _currentImageWrapper.size.y / _patchSize.y | 0;
	
	    _binaryImageWrapper = new /* harmony import */__WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a"](_currentImageWrapper.size, undefined, Uint8Array, false);
	
	    _labelImageWrapper = new /* harmony import */__WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a"](_patchSize, undefined, Array, true);
	
	    skeletonImageData = new ArrayBuffer(64 * 1024);
	    _subImageWrapper = new /* harmony import */__WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a"](_patchSize, new Uint8Array(skeletonImageData, 0, _patchSize.x * _patchSize.y));
	    _skelImageWrapper = new /* harmony import */__WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a"](_patchSize, new Uint8Array(skeletonImageData, _patchSize.x * _patchSize.y * 3, _patchSize.x * _patchSize.y), undefined, true);
	    _skeletonizer = /* harmony import */__WEBPACK_IMPORTED_MODULE_6__skeletonizer__["a"].bind()(typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : global, {
	        size: _patchSize.x
	    }, skeletonImageData);
	
	    _imageToPatchGrid = new /* harmony import */__WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a"]({
	        x: _currentImageWrapper.size.x / _subImageWrapper.size.x | 0,
	        y: _currentImageWrapper.size.y / _subImageWrapper.size.y | 0
	    }, undefined, Array, true);
	    _patchGrid = new /* harmony import */__WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a"](_imageToPatchGrid.size, undefined, undefined, true);
	    _patchLabelGrid = new /* harmony import */__WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a"](_imageToPatchGrid.size, undefined, Int32Array, true);
	}
	
	function initCanvas() {
	    if (_config.useWorker || typeof document === 'undefined') {
	        return;
	    }
	    _canvasContainer.dom.binary = document.createElement("canvas");
	    _canvasContainer.dom.binary.className = "binaryBuffer";
	    if (true && _config.debug.showCanvas === true) {
	        document.querySelector("#debug").appendChild(_canvasContainer.dom.binary);
	    }
	    _canvasContainer.ctx.binary = _canvasContainer.dom.binary.getContext("2d");
	    _canvasContainer.dom.binary.width = _binaryImageWrapper.size.x;
	    _canvasContainer.dom.binary.height = _binaryImageWrapper.size.y;
	}
	
	/**
	 * Creates a bounding box which encloses all the given patches
	 * @returns {Array} The minimal bounding box
	 */
	function boxFromPatches(patches) {
	    var overAvg,
	        i,
	        j,
	        patch,
	        transMat,
	        minx = _binaryImageWrapper.size.x,
	        miny = _binaryImageWrapper.size.y,
	        maxx = -_binaryImageWrapper.size.x,
	        maxy = -_binaryImageWrapper.size.y,
	        box,
	        scale;
	
	    // draw all patches which are to be taken into consideration
	    overAvg = 0;
	    for (i = 0; i < patches.length; i++) {
	        patch = patches[i];
	        overAvg += patch.rad;
	        if (true && _config.debug.showPatches) {
	            /* harmony import */__WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a"].drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "red" });
	        }
	    }
	
	    overAvg /= patches.length;
	    overAvg = (overAvg * 180 / Math.PI + 90) % 180 - 90;
	    if (overAvg < 0) {
	        overAvg += 180;
	    }
	
	    overAvg = (180 - overAvg) * Math.PI / 180;
	    transMat = mat2.copy(mat2.create(), [Math.cos(overAvg), Math.sin(overAvg), -Math.sin(overAvg), Math.cos(overAvg)]);
	
	    // iterate over patches and rotate by angle
	    for (i = 0; i < patches.length; i++) {
	        patch = patches[i];
	        for (j = 0; j < 4; j++) {
	            vec2.transformMat2(patch.box[j], patch.box[j], transMat);
	        }
	
	        if (true && _config.debug.boxFromPatches.showTransformed) {
	            /* harmony import */__WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a"].drawPath(patch.box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#99ff00', lineWidth: 2 });
	        }
	    }
	
	    // find bounding box
	    for (i = 0; i < patches.length; i++) {
	        patch = patches[i];
	        for (j = 0; j < 4; j++) {
	            if (patch.box[j][0] < minx) {
	                minx = patch.box[j][0];
	            }
	            if (patch.box[j][0] > maxx) {
	                maxx = patch.box[j][0];
	            }
	            if (patch.box[j][1] < miny) {
	                miny = patch.box[j][1];
	            }
	            if (patch.box[j][1] > maxy) {
	                maxy = patch.box[j][1];
	            }
	        }
	    }
	
	    box = [[minx, miny], [maxx, miny], [maxx, maxy], [minx, maxy]];
	
	    if (true && _config.debug.boxFromPatches.showTransformedBox) {
	        /* harmony import */__WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a"].drawPath(box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#ff0000', lineWidth: 2 });
	    }
	
	    scale = _config.halfSample ? 2 : 1;
	    // reverse rotation;
	    transMat = mat2.invert(transMat, transMat);
	    for (j = 0; j < 4; j++) {
	        vec2.transformMat2(box[j], box[j], transMat);
	    }
	
	    if (true && _config.debug.boxFromPatches.showBB) {
	        /* harmony import */__WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a"].drawPath(box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#ff0000', lineWidth: 2 });
	    }
	
	    for (j = 0; j < 4; j++) {
	        vec2.scale(box[j], box[j], scale);
	    }
	
	    return box;
	}
	
	/**
	 * Creates a binary image of the current image
	 */
	function binarizeImage() {
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["c"].bind()(_currentImageWrapper, _binaryImageWrapper);
	    _binaryImageWrapper.zeroBorder();
	    if (true && _config.debug.showCanvas) {
	        _binaryImageWrapper.show(_canvasContainer.dom.binary, 255);
	    }
	}
	
	/**
	 * Iterate over the entire image
	 * extract patches
	 */
	function findPatches() {
	    var i,
	        j,
	        x,
	        y,
	        moments,
	        patchesFound = [],
	        rasterizer,
	        rasterResult,
	        patch;
	    for (i = 0; i < _numPatches.x; i++) {
	        for (j = 0; j < _numPatches.y; j++) {
	            x = _subImageWrapper.size.x * i;
	            y = _subImageWrapper.size.y * j;
	
	            // seperate parts
	            skeletonize(x, y);
	
	            // Rasterize, find individual bars
	            _skelImageWrapper.zeroBorder();
	            /* harmony import */__WEBPACK_IMPORTED_MODULE_2__common_array_helper__["a"].init(_labelImageWrapper.data, 0);
	            rasterizer = /* harmony import */__WEBPACK_IMPORTED_MODULE_4__rasterizer__["a"].create(_skelImageWrapper, _labelImageWrapper);
	            rasterResult = rasterizer.rasterize(0);
	
	            if (true && _config.debug.showLabels) {
	                _labelImageWrapper.overlay(_canvasContainer.dom.binary, Math.floor(360 / rasterResult.count), { x: x, y: y });
	            }
	
	            // calculate moments from the skeletonized patch
	            moments = _labelImageWrapper.moments(rasterResult.count);
	
	            // extract eligible patches
	            patchesFound = patchesFound.concat(describePatch(moments, [i, j], x, y));
	        }
	    }
	
	    if (true && _config.debug.showFoundPatches) {
	        for (i = 0; i < patchesFound.length; i++) {
	            patch = patchesFound[i];
	            /* harmony import */__WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a"].drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "#99ff00", lineWidth: 2 });
	        }
	    }
	
	    return patchesFound;
	}
	
	/**
	 * Finds those connected areas which contain at least 6 patches
	 * and returns them ordered DESC by the number of contained patches
	 * @param {Number} maxLabel
	 */
	function findBiggestConnectedAreas(maxLabel) {
	    var i,
	        sum,
	        labelHist = [],
	        topLabels = [];
	
	    for (i = 0; i < maxLabel; i++) {
	        labelHist.push(0);
	    }
	    sum = _patchLabelGrid.data.length;
	    while (sum--) {
	        if (_patchLabelGrid.data[sum] > 0) {
	            labelHist[_patchLabelGrid.data[sum] - 1]++;
	        }
	    }
	
	    labelHist = labelHist.map(function (val, idx) {
	        return {
	            val: val,
	            label: idx + 1
	        };
	    });
	
	    labelHist.sort(function (a, b) {
	        return b.val - a.val;
	    });
	
	    // extract top areas with at least 6 patches present
	    topLabels = labelHist.filter(function (el) {
	        return el.val >= 5;
	    });
	
	    return topLabels;
	}
	
	/**
	 *
	 */
	function findBoxes(topLabels, maxLabel) {
	    var i,
	        j,
	        sum,
	        patches = [],
	        patch,
	        box,
	        boxes = [],
	        hsv = [0, 1, 1],
	        rgb = [0, 0, 0];
	
	    for (i = 0; i < topLabels.length; i++) {
	        sum = _patchLabelGrid.data.length;
	        patches.length = 0;
	        while (sum--) {
	            if (_patchLabelGrid.data[sum] === topLabels[i].label) {
	                patch = _imageToPatchGrid.data[sum];
	                patches.push(patch);
	            }
	        }
	        box = boxFromPatches(patches);
	        if (box) {
	            boxes.push(box);
	
	            // draw patch-labels if requested
	            if (true && _config.debug.showRemainingPatchLabels) {
	                for (j = 0; j < patches.length; j++) {
	                    patch = patches[j];
	                    hsv[0] = topLabels[i].label / (maxLabel + 1) * 360;
	                    /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["a"].bind()(hsv, rgb);
	                    /* harmony import */__WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a"].drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "rgb(" + rgb.join(",") + ")", lineWidth: 2 });
	                }
	            }
	        }
	    }
	    return boxes;
	}
	
	/**
	 * Find similar moments (via cluster)
	 * @param {Object} moments
	 */
	function similarMoments(moments) {
	    var clusters = /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["d"].bind()(moments, 0.90);
	    var topCluster = /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["e"].bind()(clusters, 1, function (e) {
	        return e.getPoints().length;
	    });
	    var points = [],
	        result = [];
	    if (topCluster.length === 1) {
	        points = topCluster[0].item.getPoints();
	        for (var i = 0; i < points.length; i++) {
	            result.push(points[i].point);
	        }
	    }
	    return result;
	}
	
	function skeletonize(x, y) {
	    _binaryImageWrapper.subImageAsCopy(_subImageWrapper, /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["f"].bind()(x, y));
	    _skeletonizer.skeletonize();
	
	    // Show skeleton if requested
	    if (true && _config.debug.showSkeleton) {
	        _skelImageWrapper.overlay(_canvasContainer.dom.binary, 360, /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["f"].bind()(x, y));
	    }
	}
	
	/**
	 * Extracts and describes those patches which seem to contain a barcode pattern
	 * @param {Array} moments
	 * @param {Object} patchPos,
	 * @param {Number} x
	 * @param {Number} y
	 * @returns {Array} list of patches
	 */
	function describePatch(moments, patchPos, x, y) {
	    var k,
	        avg,
	        eligibleMoments = [],
	        matchingMoments,
	        patch,
	        patchesFound = [],
	        minComponentWeight = Math.ceil(_patchSize.x / 3);
	
	    if (moments.length >= 2) {
	        // only collect moments which's area covers at least minComponentWeight pixels.
	        for (k = 0; k < moments.length; k++) {
	            if (moments[k].m00 > minComponentWeight) {
	                eligibleMoments.push(moments[k]);
	            }
	        }
	
	        // if at least 2 moments are found which have at least minComponentWeights covered
	        if (eligibleMoments.length >= 2) {
	            matchingMoments = similarMoments(eligibleMoments);
	            avg = 0;
	            // determine the similarity of the moments
	            for (k = 0; k < matchingMoments.length; k++) {
	                avg += matchingMoments[k].rad;
	            }
	
	            // Only two of the moments are allowed not to fit into the equation
	            // add the patch to the set
	            if (matchingMoments.length > 1 && matchingMoments.length >= eligibleMoments.length / 4 * 3 && matchingMoments.length > moments.length / 4) {
	                avg /= matchingMoments.length;
	                patch = {
	                    index: patchPos[1] * _numPatches.x + patchPos[0],
	                    pos: {
	                        x: x,
	                        y: y
	                    },
	                    box: [vec2.clone([x, y]), vec2.clone([x + _subImageWrapper.size.x, y]), vec2.clone([x + _subImageWrapper.size.x, y + _subImageWrapper.size.y]), vec2.clone([x, y + _subImageWrapper.size.y])],
	                    moments: matchingMoments,
	                    rad: avg,
	                    vec: vec2.clone([Math.cos(avg), Math.sin(avg)])
	                };
	                patchesFound.push(patch);
	            }
	        }
	    }
	    return patchesFound;
	}
	
	/**
	 * finds patches which are connected and share the same orientation
	 * @param {Object} patchesFound
	 */
	function rasterizeAngularSimilarity(patchesFound) {
	    var label = 0,
	        threshold = 0.95,
	        currIdx = 0,
	        j,
	        patch,
	        hsv = [0, 1, 1],
	        rgb = [0, 0, 0];
	
	    function notYetProcessed() {
	        var i;
	        for (i = 0; i < _patchLabelGrid.data.length; i++) {
	            if (_patchLabelGrid.data[i] === 0 && _patchGrid.data[i] === 1) {
	                return i;
	            }
	        }
	        return _patchLabelGrid.length;
	    }
	
	    function trace(currentIdx) {
	        var x,
	            y,
	            currentPatch,
	            idx,
	            dir,
	            current = {
	            x: currentIdx % _patchLabelGrid.size.x,
	            y: currentIdx / _patchLabelGrid.size.x | 0
	        },
	            similarity;
	
	        if (currentIdx < _patchLabelGrid.data.length) {
	            currentPatch = _imageToPatchGrid.data[currentIdx];
	            // assign label
	            _patchLabelGrid.data[currentIdx] = label;
	            for (dir = 0; dir < /* harmony import */__WEBPACK_IMPORTED_MODULE_5__tracer__["a"].searchDirections.length; dir++) {
	                y = current.y + /* harmony import */__WEBPACK_IMPORTED_MODULE_5__tracer__["a"].searchDirections[dir][0];
	                x = current.x + /* harmony import */__WEBPACK_IMPORTED_MODULE_5__tracer__["a"].searchDirections[dir][1];
	                idx = y * _patchLabelGrid.size.x + x;
	
	                // continue if patch empty
	                if (_patchGrid.data[idx] === 0) {
	                    _patchLabelGrid.data[idx] = Number.MAX_VALUE;
	                    continue;
	                }
	
	                if (_patchLabelGrid.data[idx] === 0) {
	                    similarity = Math.abs(vec2.dot(_imageToPatchGrid.data[idx].vec, currentPatch.vec));
	                    if (similarity > threshold) {
	                        trace(idx);
	                    }
	                }
	            }
	        }
	    }
	
	    // prepare for finding the right patches
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_2__common_array_helper__["a"].init(_patchGrid.data, 0);
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_2__common_array_helper__["a"].init(_patchLabelGrid.data, 0);
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_2__common_array_helper__["a"].init(_imageToPatchGrid.data, null);
	
	    for (j = 0; j < patchesFound.length; j++) {
	        patch = patchesFound[j];
	        _imageToPatchGrid.data[patch.index] = patch;
	        _patchGrid.data[patch.index] = 1;
	    }
	
	    // rasterize the patches found to determine area
	    _patchGrid.zeroBorder();
	
	    while ((currIdx = notYetProcessed()) < _patchLabelGrid.data.length) {
	        label++;
	        trace(currIdx);
	    }
	
	    // draw patch-labels if requested
	    if (true && _config.debug.showPatchLabels) {
	        for (j = 0; j < _patchLabelGrid.data.length; j++) {
	            if (_patchLabelGrid.data[j] > 0 && _patchLabelGrid.data[j] <= label) {
	                patch = _imageToPatchGrid.data[j];
	                hsv[0] = _patchLabelGrid.data[j] / (label + 1) * 360;
	                /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["a"].bind()(hsv, rgb);
	                /* harmony import */__WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a"].drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "rgb(" + rgb.join(",") + ")", lineWidth: 2 });
	            }
	        }
	    }
	
	    return label;
	}
	
	/* harmony default export */ exports["a"] = {
	    init: function init(inputImageWrapper, config) {
	        _config = config;
	        _inputImageWrapper = inputImageWrapper;
	
	        initBuffers();
	        initCanvas();
	    },
	
	    locate: function locate() {
	        var patchesFound, topLabels, boxes;
	
	        if (_config.halfSample) {
	            /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["g"].bind()(_inputImageWrapper, _currentImageWrapper);
	        }
	
	        binarizeImage();
	        patchesFound = findPatches();
	        // return unless 5% or more patches are found
	        if (patchesFound.length < _numPatches.x * _numPatches.y * 0.05) {
	            return null;
	        }
	
	        // rasterrize area by comparing angular similarity;
	        var maxLabel = rasterizeAngularSimilarity(patchesFound);
	        if (maxLabel < 1) {
	            return null;
	        }
	
	        // search for area with the most patches (biggest connected area)
	        topLabels = findBiggestConnectedAreas(maxLabel);
	        if (topLabels.length === 0) {
	            return null;
	        }
	
	        boxes = findBoxes(topLabels, maxLabel);
	        return boxes;
	    },
	
	    checkImageConstraints: function checkImageConstraints(inputStream, config) {
	        var patchSize,
	            width = inputStream.getWidth(),
	            height = inputStream.getHeight(),
	            halfSample = config.halfSample ? 0.5 : 1,
	            size,
	            area;
	
	        // calculate width and height based on area
	        if (inputStream.getConfig().area) {
	            area = /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["h"].bind()(width, height, inputStream.getConfig().area);
	            inputStream.setTopRight({ x: area.sx, y: area.sy });
	            inputStream.setCanvasSize({ x: width, y: height });
	            width = area.sw;
	            height = area.sh;
	        }
	
	        size = {
	            x: Math.floor(width * halfSample),
	            y: Math.floor(height * halfSample)
	        };
	
	        patchSize = /* harmony import */__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["b"].bind()(config.patchSize, size);
	        if (true) {
	            console.log("Patch-Size: " + JSON.stringify(patchSize));
	        }
	
	        inputStream.setWidth(Math.floor(Math.floor(size.x / patchSize.x) * (1 / halfSample) * patchSize.x));
	        inputStream.setHeight(Math.floor(Math.floor(size.y / patchSize.y) * (1 / halfSample) * patchSize.y));
	
	        if (inputStream.getWidth() % patchSize.x === 0 && inputStream.getHeight() % patchSize.y === 0) {
	            return true;
	        }
	
	        throw new Error("Image dimensions do not comply with the current settings: Width (" + width + " )and height (" + height + ") must a multiple of " + patchSize.x);
	    }
	};
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__tracer__ = __webpack_require__(29);
	
	
	/**
	 * http://www.codeproject.com/Tips/407172/Connected-Component-Labeling-and-Vectorization
	 */
	var Rasterizer = {
	    createContour2D: function createContour2D() {
	        return {
	            dir: null,
	            index: null,
	            firstVertex: null,
	            insideContours: null,
	            nextpeer: null,
	            prevpeer: null
	        };
	    },
	    CONTOUR_DIR: {
	        CW_DIR: 0,
	        CCW_DIR: 1,
	        UNKNOWN_DIR: 2
	    },
	    DIR: {
	        OUTSIDE_EDGE: -32767,
	        INSIDE_EDGE: -32766
	    },
	    create: function create(imageWrapper, labelWrapper) {
	        var imageData = imageWrapper.data,
	            labelData = labelWrapper.data,
	            width = imageWrapper.size.x,
	            height = imageWrapper.size.y,
	            tracer = /* harmony import */__WEBPACK_IMPORTED_MODULE_0__tracer__["a"].create(imageWrapper, labelWrapper);
	
	        return {
	            rasterize: function rasterize(depthlabel) {
	                var color,
	                    bc,
	                    lc,
	                    labelindex,
	                    cx,
	                    cy,
	                    colorMap = [],
	                    vertex,
	                    p,
	                    cc,
	                    sc,
	                    pos,
	                    connectedCount = 0,
	                    i;
	
	                for (i = 0; i < 400; i++) {
	                    colorMap[i] = 0;
	                }
	
	                colorMap[0] = imageData[0];
	                cc = null;
	                for (cy = 1; cy < height - 1; cy++) {
	                    labelindex = 0;
	                    bc = colorMap[0];
	                    for (cx = 1; cx < width - 1; cx++) {
	                        pos = cy * width + cx;
	                        if (labelData[pos] === 0) {
	                            color = imageData[pos];
	                            if (color !== bc) {
	                                if (labelindex === 0) {
	                                    lc = connectedCount + 1;
	                                    colorMap[lc] = color;
	                                    bc = color;
	                                    vertex = tracer.contourTracing(cy, cx, lc, color, Rasterizer.DIR.OUTSIDE_EDGE);
	                                    if (vertex !== null) {
	                                        connectedCount++;
	                                        labelindex = lc;
	                                        p = Rasterizer.createContour2D();
	                                        p.dir = Rasterizer.CONTOUR_DIR.CW_DIR;
	                                        p.index = labelindex;
	                                        p.firstVertex = vertex;
	                                        p.nextpeer = cc;
	                                        p.insideContours = null;
	                                        if (cc !== null) {
	                                            cc.prevpeer = p;
	                                        }
	                                        cc = p;
	                                    }
	                                } else {
	                                    vertex = tracer.contourTracing(cy, cx, Rasterizer.DIR.INSIDE_EDGE, color, labelindex);
	                                    if (vertex !== null) {
	                                        p = Rasterizer.createContour2D();
	                                        p.firstVertex = vertex;
	                                        p.insideContours = null;
	                                        if (depthlabel === 0) {
	                                            p.dir = Rasterizer.CONTOUR_DIR.CCW_DIR;
	                                        } else {
	                                            p.dir = Rasterizer.CONTOUR_DIR.CW_DIR;
	                                        }
	                                        p.index = depthlabel;
	                                        sc = cc;
	                                        while (sc !== null && sc.index !== labelindex) {
	                                            sc = sc.nextpeer;
	                                        }
	                                        if (sc !== null) {
	                                            p.nextpeer = sc.insideContours;
	                                            if (sc.insideContours !== null) {
	                                                sc.insideContours.prevpeer = p;
	                                            }
	                                            sc.insideContours = p;
	                                        }
	                                    }
	                                }
	                            } else {
	                                labelData[pos] = labelindex;
	                            }
	                        } else if (labelData[pos] === Rasterizer.DIR.OUTSIDE_EDGE || labelData[pos] === Rasterizer.DIR.INSIDE_EDGE) {
	                            labelindex = 0;
	                            if (labelData[pos] === Rasterizer.DIR.INSIDE_EDGE) {
	                                bc = imageData[pos];
	                            } else {
	                                bc = colorMap[0];
	                            }
	                        } else {
	                            labelindex = labelData[pos];
	                            bc = colorMap[labelindex];
	                        }
	                    }
	                }
	                sc = cc;
	                while (sc !== null) {
	                    sc.index = depthlabel;
	                    sc = sc.nextpeer;
	                }
	                return {
	                    cc: cc,
	                    count: connectedCount
	                };
	            },
	            debug: {
	                drawContour: function drawContour(canvas, firstContour) {
	                    var ctx = canvas.getContext("2d"),
	                        pq = firstContour,
	                        iq,
	                        q,
	                        p;
	
	                    ctx.strokeStyle = "red";
	                    ctx.fillStyle = "red";
	                    ctx.lineWidth = 1;
	
	                    if (pq !== null) {
	                        iq = pq.insideContours;
	                    } else {
	                        iq = null;
	                    }
	
	                    while (pq !== null) {
	                        if (iq !== null) {
	                            q = iq;
	                            iq = iq.nextpeer;
	                        } else {
	                            q = pq;
	                            pq = pq.nextpeer;
	                            if (pq !== null) {
	                                iq = pq.insideContours;
	                            } else {
	                                iq = null;
	                            }
	                        }
	
	                        switch (q.dir) {
	                            case Rasterizer.CONTOUR_DIR.CW_DIR:
	                                ctx.strokeStyle = "red";
	                                break;
	                            case Rasterizer.CONTOUR_DIR.CCW_DIR:
	                                ctx.strokeStyle = "blue";
	                                break;
	                            case Rasterizer.CONTOUR_DIR.UNKNOWN_DIR:
	                                ctx.strokeStyle = "green";
	                                break;
	                        }
	
	                        p = q.firstVertex;
	                        ctx.beginPath();
	                        ctx.moveTo(p.x, p.y);
	                        do {
	                            p = p.next;
	                            ctx.lineTo(p.x, p.y);
	                        } while (p !== q.firstVertex);
	                        ctx.stroke();
	                    }
	                }
	            }
	        };
	    }
	};
	
	/* harmony default export */ exports["a"] = Rasterizer;

/***/ },
/* 65 */
/***/ function(module, exports, __webpack_require__) {

	/* @preserve ASM BEGIN */
	/* eslint-disable eqeqeq*/
	function Skeletonizer(stdlib, foreign, buffer) {
	    "use asm";
	
	    var images = new stdlib.Uint8Array(buffer),
	        size = foreign.size | 0,
	        imul = stdlib.Math.imul;
	
	    function erode(inImagePtr, outImagePtr) {
	        inImagePtr = inImagePtr | 0;
	        outImagePtr = outImagePtr | 0;
	
	        var v = 0,
	            u = 0,
	            sum = 0,
	            yStart1 = 0,
	            yStart2 = 0,
	            xStart1 = 0,
	            xStart2 = 0,
	            offset = 0;
	
	        for (v = 1; (v | 0) < (size - 1 | 0); v = v + 1 | 0) {
	            offset = offset + size | 0;
	            for (u = 1; (u | 0) < (size - 1 | 0); u = u + 1 | 0) {
	                yStart1 = offset - size | 0;
	                yStart2 = offset + size | 0;
	                xStart1 = u - 1 | 0;
	                xStart2 = u + 1 | 0;
	                sum = (images[inImagePtr + yStart1 + xStart1 | 0] | 0) + (images[inImagePtr + yStart1 + xStart2 | 0] | 0) + (images[inImagePtr + offset + u | 0] | 0) + (images[inImagePtr + yStart2 + xStart1 | 0] | 0) + (images[inImagePtr + yStart2 + xStart2 | 0] | 0) | 0;
	                if ((sum | 0) == (5 | 0)) {
	                    images[outImagePtr + offset + u | 0] = 1;
	                } else {
	                    images[outImagePtr + offset + u | 0] = 0;
	                }
	            }
	        }
	        return;
	    }
	
	    function subtract(aImagePtr, bImagePtr, outImagePtr) {
	        aImagePtr = aImagePtr | 0;
	        bImagePtr = bImagePtr | 0;
	        outImagePtr = outImagePtr | 0;
	
	        var length = 0;
	
	        length = imul(size, size) | 0;
	
	        while ((length | 0) > 0) {
	            length = length - 1 | 0;
	            images[outImagePtr + length | 0] = (images[aImagePtr + length | 0] | 0) - (images[bImagePtr + length | 0] | 0) | 0;
	        }
	    }
	
	    function bitwiseOr(aImagePtr, bImagePtr, outImagePtr) {
	        aImagePtr = aImagePtr | 0;
	        bImagePtr = bImagePtr | 0;
	        outImagePtr = outImagePtr | 0;
	
	        var length = 0;
	
	        length = imul(size, size) | 0;
	
	        while ((length | 0) > 0) {
	            length = length - 1 | 0;
	            images[outImagePtr + length | 0] = images[aImagePtr + length | 0] | 0 | (images[bImagePtr + length | 0] | 0) | 0;
	        }
	    }
	
	    function countNonZero(imagePtr) {
	        imagePtr = imagePtr | 0;
	
	        var sum = 0,
	            length = 0;
	
	        length = imul(size, size) | 0;
	
	        while ((length | 0) > 0) {
	            length = length - 1 | 0;
	            sum = (sum | 0) + (images[imagePtr + length | 0] | 0) | 0;
	        }
	
	        return sum | 0;
	    }
	
	    function init(imagePtr, value) {
	        imagePtr = imagePtr | 0;
	        value = value | 0;
	
	        var length = 0;
	
	        length = imul(size, size) | 0;
	
	        while ((length | 0) > 0) {
	            length = length - 1 | 0;
	            images[imagePtr + length | 0] = value;
	        }
	    }
	
	    function dilate(inImagePtr, outImagePtr) {
	        inImagePtr = inImagePtr | 0;
	        outImagePtr = outImagePtr | 0;
	
	        var v = 0,
	            u = 0,
	            sum = 0,
	            yStart1 = 0,
	            yStart2 = 0,
	            xStart1 = 0,
	            xStart2 = 0,
	            offset = 0;
	
	        for (v = 1; (v | 0) < (size - 1 | 0); v = v + 1 | 0) {
	            offset = offset + size | 0;
	            for (u = 1; (u | 0) < (size - 1 | 0); u = u + 1 | 0) {
	                yStart1 = offset - size | 0;
	                yStart2 = offset + size | 0;
	                xStart1 = u - 1 | 0;
	                xStart2 = u + 1 | 0;
	                sum = (images[inImagePtr + yStart1 + xStart1 | 0] | 0) + (images[inImagePtr + yStart1 + xStart2 | 0] | 0) + (images[inImagePtr + offset + u | 0] | 0) + (images[inImagePtr + yStart2 + xStart1 | 0] | 0) + (images[inImagePtr + yStart2 + xStart2 | 0] | 0) | 0;
	                if ((sum | 0) > (0 | 0)) {
	                    images[outImagePtr + offset + u | 0] = 1;
	                } else {
	                    images[outImagePtr + offset + u | 0] = 0;
	                }
	            }
	        }
	        return;
	    }
	
	    function memcpy(srcImagePtr, dstImagePtr) {
	        srcImagePtr = srcImagePtr | 0;
	        dstImagePtr = dstImagePtr | 0;
	
	        var length = 0;
	
	        length = imul(size, size) | 0;
	
	        while ((length | 0) > 0) {
	            length = length - 1 | 0;
	            images[dstImagePtr + length | 0] = images[srcImagePtr + length | 0] | 0;
	        }
	    }
	
	    function zeroBorder(imagePtr) {
	        imagePtr = imagePtr | 0;
	
	        var x = 0,
	            y = 0;
	
	        for (x = 0; (x | 0) < (size - 1 | 0); x = x + 1 | 0) {
	            images[imagePtr + x | 0] = 0;
	            images[imagePtr + y | 0] = 0;
	            y = y + size - 1 | 0;
	            images[imagePtr + y | 0] = 0;
	            y = y + 1 | 0;
	        }
	        for (x = 0; (x | 0) < (size | 0); x = x + 1 | 0) {
	            images[imagePtr + y | 0] = 0;
	            y = y + 1 | 0;
	        }
	    }
	
	    function skeletonize() {
	        var subImagePtr = 0,
	            erodedImagePtr = 0,
	            tempImagePtr = 0,
	            skelImagePtr = 0,
	            sum = 0,
	            done = 0;
	
	        erodedImagePtr = imul(size, size) | 0;
	        tempImagePtr = erodedImagePtr + erodedImagePtr | 0;
	        skelImagePtr = tempImagePtr + erodedImagePtr | 0;
	
	        // init skel-image
	        init(skelImagePtr, 0);
	        zeroBorder(subImagePtr);
	
	        do {
	            erode(subImagePtr, erodedImagePtr);
	            dilate(erodedImagePtr, tempImagePtr);
	            subtract(subImagePtr, tempImagePtr, tempImagePtr);
	            bitwiseOr(skelImagePtr, tempImagePtr, skelImagePtr);
	            memcpy(erodedImagePtr, subImagePtr);
	            sum = countNonZero(subImagePtr) | 0;
	            done = (sum | 0) == 0 | 0;
	        } while (!done);
	    }
	    return {
	        skeletonize: skeletonize
	    };
	}
	/* @preserve ASM END */
	/* harmony default export */ exports["a"] = Skeletonizer;
	/* eslint-enable eqeqeq*/

/***/ },
/* 66 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__barcode_reader__ = __webpack_require__(6);
	
	
	function CodabarReader() {
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a"].call(this);
	    this._counters = [];
	}
	
	var properties = {
	    ALPHABETH_STRING: { value: "0123456789-$:/.+ABCD" },
	    ALPHABET: { value: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 36, 58, 47, 46, 43, 65, 66, 67, 68] },
	    CHARACTER_ENCODINGS: { value: [0x003, 0x006, 0x009, 0x060, 0x012, 0x042, 0x021, 0x024, 0x030, 0x048, 0x00c, 0x018, 0x045, 0x051, 0x054, 0x015, 0x01A, 0x029, 0x00B, 0x00E] },
	    START_END: { value: [0x01A, 0x029, 0x00B, 0x00E] },
	    MIN_ENCODED_CHARS: { value: 4 },
	    MAX_ACCEPTABLE: { value: 2.0 },
	    PADDING: { value: 1.5 },
	    FORMAT: { value: "codabar", writeable: false }
	};
	
	CodabarReader.prototype = Object.create(/* harmony import */__WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a"].prototype, properties);
	CodabarReader.prototype.constructor = CodabarReader;
	
	CodabarReader.prototype._decode = function () {
	    var self = this,
	        result = [],
	        start,
	        decodedChar,
	        pattern,
	        nextStart,
	        end;
	
	    this._counters = self._fillCounters();
	    start = self._findStart();
	    if (!start) {
	        return null;
	    }
	    nextStart = start.startCounter;
	
	    do {
	        pattern = self._toPattern(nextStart);
	        if (pattern < 0) {
	            return null;
	        }
	        decodedChar = self._patternToChar(pattern);
	        if (decodedChar < 0) {
	            return null;
	        }
	        result.push(decodedChar);
	        nextStart += 8;
	        if (result.length > 1 && self._isStartEnd(pattern)) {
	            break;
	        }
	    } while (nextStart < self._counters.length);
	
	    // verify end
	    if (result.length - 2 < self.MIN_ENCODED_CHARS || !self._isStartEnd(pattern)) {
	        return null;
	    }
	
	    // verify end white space
	    if (!self._verifyWhitespace(start.startCounter, nextStart - 8)) {
	        return null;
	    }
	
	    if (!self._validateResult(result, start.startCounter)) {
	        return null;
	    }
	
	    nextStart = nextStart > self._counters.length ? self._counters.length : nextStart;
	    end = start.start + self._sumCounters(start.startCounter, nextStart - 8);
	
	    return {
	        code: result.join(""),
	        start: start.start,
	        end: end,
	        startInfo: start,
	        decodedCodes: result
	    };
	};
	
	CodabarReader.prototype._verifyWhitespace = function (startCounter, endCounter) {
	    if (startCounter - 1 <= 0 || this._counters[startCounter - 1] >= this._calculatePatternLength(startCounter) / 2.0) {
	        if (endCounter + 8 >= this._counters.length || this._counters[endCounter + 7] >= this._calculatePatternLength(endCounter) / 2.0) {
	            return true;
	        }
	    }
	    return false;
	};
	
	CodabarReader.prototype._calculatePatternLength = function (offset) {
	    var i,
	        sum = 0;
	
	    for (i = offset; i < offset + 7; i++) {
	        sum += this._counters[i];
	    }
	
	    return sum;
	};
	
	CodabarReader.prototype._thresholdResultPattern = function (result, startCounter) {
	    var self = this,
	        categorization = {
	        space: {
	            narrow: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE },
	            wide: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE }
	        },
	        bar: {
	            narrow: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE },
	            wide: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE }
	        }
	    },
	        kind,
	        cat,
	        i,
	        j,
	        pos = startCounter,
	        pattern;
	
	    for (i = 0; i < result.length; i++) {
	        pattern = self._charToPattern(result[i]);
	        for (j = 6; j >= 0; j--) {
	            kind = (j & 1) === 2 ? categorization.bar : categorization.space;
	            cat = (pattern & 1) === 1 ? kind.wide : kind.narrow;
	            cat.size += self._counters[pos + j];
	            cat.counts++;
	            pattern >>= 1;
	        }
	        pos += 8;
	    }
	
	    ["space", "bar"].forEach(function (key) {
	        var newkind = categorization[key];
	        newkind.wide.min = Math.floor((newkind.narrow.size / newkind.narrow.counts + newkind.wide.size / newkind.wide.counts) / 2);
	        newkind.narrow.max = Math.ceil(newkind.wide.min);
	        newkind.wide.max = Math.ceil((newkind.wide.size * self.MAX_ACCEPTABLE + self.PADDING) / newkind.wide.counts);
	    });
	
	    return categorization;
	};
	
	CodabarReader.prototype._charToPattern = function (char) {
	    var self = this,
	        charCode = char.charCodeAt(0),
	        i;
	
	    for (i = 0; i < self.ALPHABET.length; i++) {
	        if (self.ALPHABET[i] === charCode) {
	            return self.CHARACTER_ENCODINGS[i];
	        }
	    }
	    return 0x0;
	};
	
	CodabarReader.prototype._validateResult = function (result, startCounter) {
	    var self = this,
	        thresholds = self._thresholdResultPattern(result, startCounter),
	        i,
	        j,
	        kind,
	        cat,
	        size,
	        pos = startCounter,
	        pattern;
	
	    for (i = 0; i < result.length; i++) {
	        pattern = self._charToPattern(result[i]);
	        for (j = 6; j >= 0; j--) {
	            kind = (j & 1) === 0 ? thresholds.bar : thresholds.space;
	            cat = (pattern & 1) === 1 ? kind.wide : kind.narrow;
	            size = self._counters[pos + j];
	            if (size < cat.min || size > cat.max) {
	                return false;
	            }
	            pattern >>= 1;
	        }
	        pos += 8;
	    }
	    return true;
	};
	
	CodabarReader.prototype._patternToChar = function (pattern) {
	    var i,
	        self = this;
	
	    for (i = 0; i < self.CHARACTER_ENCODINGS.length; i++) {
	        if (self.CHARACTER_ENCODINGS[i] === pattern) {
	            return String.fromCharCode(self.ALPHABET[i]);
	        }
	    }
	    return -1;
	};
	
	CodabarReader.prototype._computeAlternatingThreshold = function (offset, end) {
	    var i,
	        min = Number.MAX_VALUE,
	        max = 0,
	        counter;
	
	    for (i = offset; i < end; i += 2) {
	        counter = this._counters[i];
	        if (counter > max) {
	            max = counter;
	        }
	        if (counter < min) {
	            min = counter;
	        }
	    }
	
	    return (min + max) / 2.0 | 0;
	};
	
	CodabarReader.prototype._toPattern = function (offset) {
	    var numCounters = 7,
	        end = offset + numCounters,
	        barThreshold,
	        spaceThreshold,
	        bitmask = 1 << numCounters - 1,
	        pattern = 0,
	        i,
	        threshold;
	
	    if (end > this._counters.length) {
	        return -1;
	    }
	
	    barThreshold = this._computeAlternatingThreshold(offset, end);
	    spaceThreshold = this._computeAlternatingThreshold(offset + 1, end);
	
	    for (i = 0; i < numCounters; i++) {
	        threshold = (i & 1) === 0 ? barThreshold : spaceThreshold;
	        if (this._counters[offset + i] > threshold) {
	            pattern |= bitmask;
	        }
	        bitmask >>= 1;
	    }
	
	    return pattern;
	};
	
	CodabarReader.prototype._isStartEnd = function (pattern) {
	    var i;
	
	    for (i = 0; i < this.START_END.length; i++) {
	        if (this.START_END[i] === pattern) {
	            return true;
	        }
	    }
	    return false;
	};
	
	CodabarReader.prototype._sumCounters = function (start, end) {
	    var i,
	        sum = 0;
	
	    for (i = start; i < end; i++) {
	        sum += this._counters[i];
	    }
	    return sum;
	};
	
	CodabarReader.prototype._findStart = function () {
	    var self = this,
	        i,
	        pattern,
	        start = self._nextUnset(self._row),
	        end;
	
	    for (i = 1; i < this._counters.length; i++) {
	        pattern = self._toPattern(i);
	        if (pattern !== -1 && self._isStartEnd(pattern)) {
	            // TODO: Look for whitespace ahead
	            start += self._sumCounters(0, i);
	            end = start + self._sumCounters(i, i + 8);
	            return {
	                start: start,
	                end: end,
	                startCounter: i,
	                endCounter: i + 8
	            };
	        }
	    }
	};
	
	/* harmony default export */ exports["a"] = CodabarReader;

/***/ },
/* 67 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__barcode_reader__ = __webpack_require__(6);
	
	
	function Code128Reader() {
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a"].call(this);
	}
	
	var properties = {
	    CODE_SHIFT: { value: 98 },
	    CODE_C: { value: 99 },
	    CODE_B: { value: 100 },
	    CODE_A: { value: 101 },
	    START_CODE_A: { value: 103 },
	    START_CODE_B: { value: 104 },
	    START_CODE_C: { value: 105 },
	    STOP_CODE: { value: 106 },
	    CODE_PATTERN: { value: [[2, 1, 2, 2, 2, 2], [2, 2, 2, 1, 2, 2], [2, 2, 2, 2, 2, 1], [1, 2, 1, 2, 2, 3], [1, 2, 1, 3, 2, 2], [1, 3, 1, 2, 2, 2], [1, 2, 2, 2, 1, 3], [1, 2, 2, 3, 1, 2], [1, 3, 2, 2, 1, 2], [2, 2, 1, 2, 1, 3], [2, 2, 1, 3, 1, 2], [2, 3, 1, 2, 1, 2], [1, 1, 2, 2, 3, 2], [1, 2, 2, 1, 3, 2], [1, 2, 2, 2, 3, 1], [1, 1, 3, 2, 2, 2], [1, 2, 3, 1, 2, 2], [1, 2, 3, 2, 2, 1], [2, 2, 3, 2, 1, 1], [2, 2, 1, 1, 3, 2], [2, 2, 1, 2, 3, 1], [2, 1, 3, 2, 1, 2], [2, 2, 3, 1, 1, 2], [3, 1, 2, 1, 3, 1], [3, 1, 1, 2, 2, 2], [3, 2, 1, 1, 2, 2], [3, 2, 1, 2, 2, 1], [3, 1, 2, 2, 1, 2], [3, 2, 2, 1, 1, 2], [3, 2, 2, 2, 1, 1], [2, 1, 2, 1, 2, 3], [2, 1, 2, 3, 2, 1], [2, 3, 2, 1, 2, 1], [1, 1, 1, 3, 2, 3], [1, 3, 1, 1, 2, 3], [1, 3, 1, 3, 2, 1], [1, 1, 2, 3, 1, 3], [1, 3, 2, 1, 1, 3], [1, 3, 2, 3, 1, 1], [2, 1, 1, 3, 1, 3], [2, 3, 1, 1, 1, 3], [2, 3, 1, 3, 1, 1], [1, 1, 2, 1, 3, 3], [1, 1, 2, 3, 3, 1], [1, 3, 2, 1, 3, 1], [1, 1, 3, 1, 2, 3], [1, 1, 3, 3, 2, 1], [1, 3, 3, 1, 2, 1], [3, 1, 3, 1, 2, 1], [2, 1, 1, 3, 3, 1], [2, 3, 1, 1, 3, 1], [2, 1, 3, 1, 1, 3], [2, 1, 3, 3, 1, 1], [2, 1, 3, 1, 3, 1], [3, 1, 1, 1, 2, 3], [3, 1, 1, 3, 2, 1], [3, 3, 1, 1, 2, 1], [3, 1, 2, 1, 1, 3], [3, 1, 2, 3, 1, 1], [3, 3, 2, 1, 1, 1], [3, 1, 4, 1, 1, 1], [2, 2, 1, 4, 1, 1], [4, 3, 1, 1, 1, 1], [1, 1, 1, 2, 2, 4], [1, 1, 1, 4, 2, 2], [1, 2, 1, 1, 2, 4], [1, 2, 1, 4, 2, 1], [1, 4, 1, 1, 2, 2], [1, 4, 1, 2, 2, 1], [1, 1, 2, 2, 1, 4], [1, 1, 2, 4, 1, 2], [1, 2, 2, 1, 1, 4], [1, 2, 2, 4, 1, 1], [1, 4, 2, 1, 1, 2], [1, 4, 2, 2, 1, 1], [2, 4, 1, 2, 1, 1], [2, 2, 1, 1, 1, 4], [4, 1, 3, 1, 1, 1], [2, 4, 1, 1, 1, 2], [1, 3, 4, 1, 1, 1], [1, 1, 1, 2, 4, 2], [1, 2, 1, 1, 4, 2], [1, 2, 1, 2, 4, 1], [1, 1, 4, 2, 1, 2], [1, 2, 4, 1, 1, 2], [1, 2, 4, 2, 1, 1], [4, 1, 1, 2, 1, 2], [4, 2, 1, 1, 1, 2], [4, 2, 1, 2, 1, 1], [2, 1, 2, 1, 4, 1], [2, 1, 4, 1, 2, 1], [4, 1, 2, 1, 2, 1], [1, 1, 1, 1, 4, 3], [1, 1, 1, 3, 4, 1], [1, 3, 1, 1, 4, 1], [1, 1, 4, 1, 1, 3], [1, 1, 4, 3, 1, 1], [4, 1, 1, 1, 1, 3], [4, 1, 1, 3, 1, 1], [1, 1, 3, 1, 4, 1], [1, 1, 4, 1, 3, 1], [3, 1, 1, 1, 4, 1], [4, 1, 1, 1, 3, 1], [2, 1, 1, 4, 1, 2], [2, 1, 1, 2, 1, 4], [2, 1, 1, 2, 3, 2], [2, 3, 3, 1, 1, 1, 2]] },
	    SINGLE_CODE_ERROR: { value: 0.64 },
	    AVG_CODE_ERROR: { value: 0.30 },
	    FORMAT: { value: "code_128", writeable: false },
	    MODULE_INDICES: { value: { bar: [0, 2, 4], space: [1, 3, 5] } }
	};
	
	Code128Reader.prototype = Object.create(/* harmony import */__WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a"].prototype, properties);
	Code128Reader.prototype.constructor = Code128Reader;
	
	Code128Reader.prototype._decodeCode = function (start, correction) {
	    var counter = [0, 0, 0, 0, 0, 0],
	        i,
	        self = this,
	        offset = start,
	        isWhite = !self._row[offset],
	        counterPos = 0,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: start,
	        end: start,
	        correction: {
	            bar: 1,
	            space: 1
	        }
	    },
	        code,
	        error;
	
	    for (i = offset; i < self._row.length; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            if (counterPos === counter.length - 1) {
	                if (correction) {
	                    self._correct(counter, correction);
	                }
	                for (code = 0; code < self.CODE_PATTERN.length; code++) {
	                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
	                    if (error < bestMatch.error) {
	                        bestMatch.code = code;
	                        bestMatch.error = error;
	                    }
	                }
	                bestMatch.end = i;
	                if (bestMatch.code === -1 || bestMatch.error > self.AVG_CODE_ERROR) {
	                    return null;
	                }
	                if (self.CODE_PATTERN[bestMatch.code]) {
	                    bestMatch.correction.bar = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.bar);
	                    bestMatch.correction.space = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.space);
	                }
	                return bestMatch;
	            } else {
	                counterPos++;
	            }
	            counter[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return null;
	};
	
	Code128Reader.prototype._correct = function (counter, correction) {
	    this._correctBars(counter, correction.bar, this.MODULE_INDICES.bar);
	    this._correctBars(counter, correction.space, this.MODULE_INDICES.space);
	};
	
	Code128Reader.prototype._findStart = function () {
	    var counter = [0, 0, 0, 0, 0, 0],
	        i,
	        self = this,
	        offset = self._nextSet(self._row),
	        isWhite = false,
	        counterPos = 0,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: 0,
	        end: 0,
	        correction: {
	            bar: 1,
	            space: 1
	        }
	    },
	        code,
	        error,
	        j,
	        sum;
	
	    for (i = offset; i < self._row.length; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            if (counterPos === counter.length - 1) {
	                sum = 0;
	                for (j = 0; j < counter.length; j++) {
	                    sum += counter[j];
	                }
	                for (code = self.START_CODE_A; code <= self.START_CODE_C; code++) {
	                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
	                    if (error < bestMatch.error) {
	                        bestMatch.code = code;
	                        bestMatch.error = error;
	                    }
	                }
	                if (bestMatch.error < self.AVG_CODE_ERROR) {
	                    bestMatch.start = i - sum;
	                    bestMatch.end = i;
	                    bestMatch.correction.bar = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.bar);
	                    bestMatch.correction.space = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.space);
	                    return bestMatch;
	                }
	
	                for (j = 0; j < 4; j++) {
	                    counter[j] = counter[j + 2];
	                }
	                counter[4] = 0;
	                counter[5] = 0;
	                counterPos--;
	            } else {
	                counterPos++;
	            }
	            counter[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return null;
	};
	
	Code128Reader.prototype._decode = function () {
	    var self = this,
	        startInfo = self._findStart(),
	        code = null,
	        done = false,
	        result = [],
	        multiplier = 0,
	        checksum = 0,
	        codeset,
	        rawResult = [],
	        decodedCodes = [],
	        shiftNext = false,
	        unshift,
	        removeLastCharacter = true;
	
	    if (startInfo === null) {
	        return null;
	    }
	    code = {
	        code: startInfo.code,
	        start: startInfo.start,
	        end: startInfo.end,
	        correction: {
	            bar: startInfo.correction.bar,
	            space: startInfo.correction.space
	        }
	    };
	    decodedCodes.push(code);
	    checksum = code.code;
	    switch (code.code) {
	        case self.START_CODE_A:
	            codeset = self.CODE_A;
	            break;
	        case self.START_CODE_B:
	            codeset = self.CODE_B;
	            break;
	        case self.START_CODE_C:
	            codeset = self.CODE_C;
	            break;
	        default:
	            return null;
	    }
	
	    while (!done) {
	        unshift = shiftNext;
	        shiftNext = false;
	        code = self._decodeCode(code.end, code.correction);
	        if (code !== null) {
	            if (code.code !== self.STOP_CODE) {
	                removeLastCharacter = true;
	            }
	
	            if (code.code !== self.STOP_CODE) {
	                rawResult.push(code.code);
	                multiplier++;
	                checksum += multiplier * code.code;
	            }
	            decodedCodes.push(code);
	
	            switch (codeset) {
	                case self.CODE_A:
	                    if (code.code < 64) {
	                        result.push(String.fromCharCode(32 + code.code));
	                    } else if (code.code < 96) {
	                        result.push(String.fromCharCode(code.code - 64));
	                    } else {
	                        if (code.code !== self.STOP_CODE) {
	                            removeLastCharacter = false;
	                        }
	                        switch (code.code) {
	                            case self.CODE_SHIFT:
	                                shiftNext = true;
	                                codeset = self.CODE_B;
	                                break;
	                            case self.CODE_B:
	                                codeset = self.CODE_B;
	                                break;
	                            case self.CODE_C:
	                                codeset = self.CODE_C;
	                                break;
	                            case self.STOP_CODE:
	                                done = true;
	                                break;
	                        }
	                    }
	                    break;
	                case self.CODE_B:
	                    if (code.code < 96) {
	                        result.push(String.fromCharCode(32 + code.code));
	                    } else {
	                        if (code.code !== self.STOP_CODE) {
	                            removeLastCharacter = false;
	                        }
	                        switch (code.code) {
	                            case self.CODE_SHIFT:
	                                shiftNext = true;
	                                codeset = self.CODE_A;
	                                break;
	                            case self.CODE_A:
	                                codeset = self.CODE_A;
	                                break;
	                            case self.CODE_C:
	                                codeset = self.CODE_C;
	                                break;
	                            case self.STOP_CODE:
	                                done = true;
	                                break;
	                        }
	                    }
	                    break;
	                case self.CODE_C:
	                    if (code.code < 100) {
	                        result.push(code.code < 10 ? "0" + code.code : code.code);
	                    } else {
	                        if (code.code !== self.STOP_CODE) {
	                            removeLastCharacter = false;
	                        }
	                        switch (code.code) {
	                            case self.CODE_A:
	                                codeset = self.CODE_A;
	                                break;
	                            case self.CODE_B:
	                                codeset = self.CODE_B;
	                                break;
	                            case self.STOP_CODE:
	                                done = true;
	                                break;
	                        }
	                    }
	                    break;
	            }
	        } else {
	            done = true;
	        }
	        if (unshift) {
	            codeset = codeset === self.CODE_A ? self.CODE_B : self.CODE_A;
	        }
	    }
	
	    if (code === null) {
	        return null;
	    }
	
	    code.end = self._nextUnset(self._row, code.end);
	    if (!self._verifyTrailingWhitespace(code)) {
	        return null;
	    }
	
	    checksum -= multiplier * rawResult[rawResult.length - 1];
	    if (checksum % 103 !== rawResult[rawResult.length - 1]) {
	        return null;
	    }
	
	    if (!result.length) {
	        return null;
	    }
	
	    // remove last code from result (checksum)
	    if (removeLastCharacter) {
	        result.splice(result.length - 1, 1);
	    }
	
	    return {
	        code: result.join(""),
	        start: startInfo.start,
	        end: code.end,
	        codeset: codeset,
	        startInfo: startInfo,
	        decodedCodes: decodedCodes,
	        endInfo: code
	    };
	};
	
	/* harmony import */__WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a"].prototype._verifyTrailingWhitespace = function (endInfo) {
	    var self = this,
	        trailingWhitespaceEnd;
	
	    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
	    if (trailingWhitespaceEnd < self._row.length) {
	        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
	            return endInfo;
	        }
	    }
	    return null;
	};
	
	function calculateCorrection(expected, normalized, indices) {
	    var length = indices.length,
	        sumNormalized = 0,
	        sumExpected = 0;
	
	    while (length--) {
	        sumExpected += expected[indices[length]];
	        sumNormalized += normalized[indices[length]];
	    }
	    return sumExpected / sumNormalized;
	}
	
	/* harmony default export */ exports["a"] = Code128Reader;

/***/ },
/* 68 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__code_39_reader__ = __webpack_require__(30);
	
	
	function Code39VINReader() {
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_0__code_39_reader__["a"].call(this);
	}
	
	var patterns = {
	    IOQ: /[IOQ]/g,
	    AZ09: /[A-Z0-9]{17}/
	};
	
	Code39VINReader.prototype = Object.create(/* harmony import */__WEBPACK_IMPORTED_MODULE_0__code_39_reader__["a"].prototype);
	Code39VINReader.prototype.constructor = Code39VINReader;
	
	// Cribbed from:
	// https://github.com/zxing/zxing/blob/master/core/src/main/java/com/google/zxing/client/result/VINResultParser.java
	Code39VINReader.prototype._decode = function () {
	    var result = /* harmony import */__WEBPACK_IMPORTED_MODULE_0__code_39_reader__["a"].prototype._decode.apply(this);
	    if (!result) {
	        return null;
	    }
	
	    var code = result.code;
	
	    if (!code) {
	        return null;
	    }
	
	    code = code.replace(patterns.IOQ, '');
	
	    if (!code.match(patterns.AZ09)) {
	        if (true) {
	            console.log('Failed AZ09 pattern code:', code);
	        }
	        return null;
	    }
	
	    if (!this._checkChecksum(code)) {
	        return null;
	    }
	
	    result.code = code;
	    return result;
	};
	
	Code39VINReader.prototype._checkChecksum = function (code) {
	    // TODO
	    return !!code;
	};
	
	/* harmony default export */ exports["a"] = Code39VINReader;

/***/ },
/* 69 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__ean_reader__ = __webpack_require__(3);
	
	
	function EAN2Reader() {
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a"].call(this);
	}
	
	var properties = {
	    FORMAT: { value: "ean_2", writeable: false }
	};
	
	EAN2Reader.prototype = Object.create(/* harmony import */__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a"].prototype, properties);
	EAN2Reader.prototype.constructor = EAN2Reader;
	
	EAN2Reader.prototype.decode = function (row, start) {
	    this._row = row;
	    var counters = [0, 0, 0, 0],
	        codeFrequency = 0,
	        i = 0,
	        offset = start,
	        end = this._row.length,
	        code,
	        result = [],
	        decodedCodes = [];
	
	    for (i = 0; i < 2 && offset < end; i++) {
	        code = this._decodeCode(offset);
	        if (!code) {
	            return null;
	        }
	        decodedCodes.push(code);
	        result.push(code.code % 10);
	        if (code.code >= this.CODE_G_START) {
	            codeFrequency |= 1 << 1 - i;
	        }
	        if (i != 1) {
	            offset = this._nextSet(this._row, code.end);
	            offset = this._nextUnset(this._row, offset);
	        }
	    }
	
	    if (result.length != 2 || parseInt(result.join("")) % 4 !== codeFrequency) {
	        return null;
	    }
	    return {
	        code: result.join(""),
	        decodedCodes: decodedCodes,
	        end: code.end
	    };
	};
	
	/* harmony default export */ exports["a"] = EAN2Reader;

/***/ },
/* 70 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__ean_reader__ = __webpack_require__(3);
	
	
	function EAN5Reader() {
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a"].call(this);
	}
	
	var properties = {
	    FORMAT: { value: "ean_5", writeable: false }
	};
	
	var CHECK_DIGIT_ENCODINGS = [24, 20, 18, 17, 12, 6, 3, 10, 9, 5];
	
	EAN5Reader.prototype = Object.create(/* harmony import */__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a"].prototype, properties);
	EAN5Reader.prototype.constructor = EAN5Reader;
	
	EAN5Reader.prototype.decode = function (row, start) {
	    this._row = row;
	    var counters = [0, 0, 0, 0],
	        codeFrequency = 0,
	        i = 0,
	        offset = start,
	        end = this._row.length,
	        code,
	        result = [],
	        decodedCodes = [];
	
	    for (i = 0; i < 5 && offset < end; i++) {
	        code = this._decodeCode(offset);
	        if (!code) {
	            return null;
	        }
	        decodedCodes.push(code);
	        result.push(code.code % 10);
	        if (code.code >= this.CODE_G_START) {
	            codeFrequency |= 1 << 4 - i;
	        }
	        if (i != 4) {
	            offset = this._nextSet(this._row, code.end);
	            offset = this._nextUnset(this._row, offset);
	        }
	    }
	
	    if (result.length != 5) {
	        return null;
	    }
	
	    if (extensionChecksum(result) !== determineCheckDigit(codeFrequency)) {
	        return null;
	    }
	    return {
	        code: result.join(""),
	        decodedCodes: decodedCodes,
	        end: code.end
	    };
	};
	
	function determineCheckDigit(codeFrequency) {
	    var i;
	    for (i = 0; i < 10; i++) {
	        if (codeFrequency === CHECK_DIGIT_ENCODINGS[i]) {
	            return i;
	        }
	    }
	    return null;
	}
	
	function extensionChecksum(result) {
	    var length = result.length,
	        sum = 0,
	        i;
	
	    for (i = length - 2; i >= 0; i -= 2) {
	        sum += result[i];
	    }
	    sum *= 3;
	    for (i = length - 1; i >= 0; i -= 2) {
	        sum += result[i];
	    }
	    sum *= 3;
	    return sum % 10;
	}
	
	/* harmony default export */ exports["a"] = EAN5Reader;

/***/ },
/* 71 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__ean_reader__ = __webpack_require__(3);
	
	
	function EAN8Reader(opts, supplements) {
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a"].call(this, opts, supplements);
	}
	
	var properties = {
	    FORMAT: { value: "ean_8", writeable: false }
	};
	
	EAN8Reader.prototype = Object.create(/* harmony import */__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a"].prototype, properties);
	EAN8Reader.prototype.constructor = EAN8Reader;
	
	EAN8Reader.prototype._decodePayload = function (code, result, decodedCodes) {
	    var i,
	        self = this;
	
	    for (i = 0; i < 4; i++) {
	        code = self._decodeCode(code.end, self.CODE_G_START);
	        if (!code) {
	            return null;
	        }
	        result.push(code.code);
	        decodedCodes.push(code);
	    }
	
	    code = self._findPattern(self.MIDDLE_PATTERN, code.end, true, false);
	    if (code === null) {
	        return null;
	    }
	    decodedCodes.push(code);
	
	    for (i = 0; i < 4; i++) {
	        code = self._decodeCode(code.end, self.CODE_G_START);
	        if (!code) {
	            return null;
	        }
	        decodedCodes.push(code);
	        result.push(code.code);
	    }
	
	    return code;
	};
	
	/* harmony default export */ exports["a"] = EAN8Reader;

/***/ },
/* 72 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_merge__ = __webpack_require__(17);
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_merge___default = __WEBPACK_IMPORTED_MODULE_0_lodash_merge__ && __WEBPACK_IMPORTED_MODULE_0_lodash_merge__.__esModule ? function() { return __WEBPACK_IMPORTED_MODULE_0_lodash_merge__['default'] } : function() { return __WEBPACK_IMPORTED_MODULE_0_lodash_merge__; }
	/* harmony import */ Object.defineProperty(__WEBPACK_IMPORTED_MODULE_0_lodash_merge___default, 'a', { get: __WEBPACK_IMPORTED_MODULE_0_lodash_merge___default });
	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__barcode_reader__ = __webpack_require__(6);
	
	
	
	
	function I2of5Reader(opts) {
	    opts = /* harmony import */__WEBPACK_IMPORTED_MODULE_0_lodash_merge___default.a.bind()(getDefaulConfig(), opts);
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_1__barcode_reader__["a"].call(this, opts);
	    this.barSpaceRatio = [1, 1];
	    if (opts.normalizeBarSpaceWidth) {
	        this.SINGLE_CODE_ERROR = 0.38;
	        this.AVG_CODE_ERROR = 0.09;
	    }
	}
	
	function getDefaulConfig() {
	    var config = {};
	
	    Object.keys(I2of5Reader.CONFIG_KEYS).forEach(function (key) {
	        config[key] = I2of5Reader.CONFIG_KEYS[key].default;
	    });
	    return config;
	}
	
	var N = 1,
	    W = 3,
	    properties = {
	    START_PATTERN: { value: [N, N, N, N] },
	    STOP_PATTERN: { value: [N, N, W] },
	    CODE_PATTERN: { value: [[N, N, W, W, N], [W, N, N, N, W], [N, W, N, N, W], [W, W, N, N, N], [N, N, W, N, W], [W, N, W, N, N], [N, W, W, N, N], [N, N, N, W, W], [W, N, N, W, N], [N, W, N, W, N]] },
	    SINGLE_CODE_ERROR: { value: 0.78, writable: true },
	    AVG_CODE_ERROR: { value: 0.38, writable: true },
	    MAX_CORRECTION_FACTOR: { value: 5 },
	    FORMAT: { value: "i2of5" }
	};
	
	I2of5Reader.prototype = Object.create(/* harmony import */__WEBPACK_IMPORTED_MODULE_1__barcode_reader__["a"].prototype, properties);
	I2of5Reader.prototype.constructor = I2of5Reader;
	
	I2of5Reader.prototype._matchPattern = function (counter, code) {
	    if (this.config.normalizeBarSpaceWidth) {
	        var i,
	            counterSum = [0, 0],
	            codeSum = [0, 0],
	            correction = [0, 0],
	            correctionRatio = this.MAX_CORRECTION_FACTOR,
	            correctionRatioInverse = 1 / correctionRatio;
	
	        for (i = 0; i < counter.length; i++) {
	            counterSum[i % 2] += counter[i];
	            codeSum[i % 2] += code[i];
	        }
	        correction[0] = codeSum[0] / counterSum[0];
	        correction[1] = codeSum[1] / counterSum[1];
	
	        correction[0] = Math.max(Math.min(correction[0], correctionRatio), correctionRatioInverse);
	        correction[1] = Math.max(Math.min(correction[1], correctionRatio), correctionRatioInverse);
	        this.barSpaceRatio = correction;
	        for (i = 0; i < counter.length; i++) {
	            counter[i] *= this.barSpaceRatio[i % 2];
	        }
	    }
	    return /* harmony import */__WEBPACK_IMPORTED_MODULE_1__barcode_reader__["a"].prototype._matchPattern.call(this, counter, code);
	};
	
	I2of5Reader.prototype._findPattern = function (pattern, offset, isWhite, tryHarder) {
	    var counter = [],
	        self = this,
	        i,
	        counterPos = 0,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: 0,
	        end: 0
	    },
	        error,
	        j,
	        sum,
	        normalized,
	        epsilon = self.AVG_CODE_ERROR;
	
	    isWhite = isWhite || false;
	    tryHarder = tryHarder || false;
	
	    if (!offset) {
	        offset = self._nextSet(self._row);
	    }
	
	    for (i = 0; i < pattern.length; i++) {
	        counter[i] = 0;
	    }
	
	    for (i = offset; i < self._row.length; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            if (counterPos === counter.length - 1) {
	                sum = 0;
	                for (j = 0; j < counter.length; j++) {
	                    sum += counter[j];
	                }
	                error = self._matchPattern(counter, pattern);
	                if (error < epsilon) {
	                    bestMatch.error = error;
	                    bestMatch.start = i - sum;
	                    bestMatch.end = i;
	                    return bestMatch;
	                }
	                if (tryHarder) {
	                    for (j = 0; j < counter.length - 2; j++) {
	                        counter[j] = counter[j + 2];
	                    }
	                    counter[counter.length - 2] = 0;
	                    counter[counter.length - 1] = 0;
	                    counterPos--;
	                } else {
	                    return null;
	                }
	            } else {
	                counterPos++;
	            }
	            counter[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return null;
	};
	
	I2of5Reader.prototype._findStart = function () {
	    var self = this,
	        leadingWhitespaceStart,
	        offset = self._nextSet(self._row),
	        startInfo,
	        narrowBarWidth = 1;
	
	    while (!startInfo) {
	        startInfo = self._findPattern(self.START_PATTERN, offset, false, true);
	        if (!startInfo) {
	            return null;
	        }
	        narrowBarWidth = Math.floor((startInfo.end - startInfo.start) / 4);
	        leadingWhitespaceStart = startInfo.start - narrowBarWidth * 10;
	        if (leadingWhitespaceStart >= 0) {
	            if (self._matchRange(leadingWhitespaceStart, startInfo.start, 0)) {
	                return startInfo;
	            }
	        }
	        offset = startInfo.end;
	        startInfo = null;
	    }
	};
	
	I2of5Reader.prototype._verifyTrailingWhitespace = function (endInfo) {
	    var self = this,
	        trailingWhitespaceEnd;
	
	    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
	    if (trailingWhitespaceEnd < self._row.length) {
	        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
	            return endInfo;
	        }
	    }
	    return null;
	};
	
	I2of5Reader.prototype._findEnd = function () {
	    var self = this,
	        endInfo,
	        tmp;
	
	    self._row.reverse();
	    endInfo = self._findPattern(self.STOP_PATTERN);
	    self._row.reverse();
	
	    if (endInfo === null) {
	        return null;
	    }
	
	    // reverse numbers
	    tmp = endInfo.start;
	    endInfo.start = self._row.length - endInfo.end;
	    endInfo.end = self._row.length - tmp;
	
	    return endInfo !== null ? self._verifyTrailingWhitespace(endInfo) : null;
	};
	
	I2of5Reader.prototype._decodePair = function (counterPair) {
	    var i,
	        code,
	        codes = [],
	        self = this;
	
	    for (i = 0; i < counterPair.length; i++) {
	        code = self._decodeCode(counterPair[i]);
	        if (!code) {
	            return null;
	        }
	        codes.push(code);
	    }
	    return codes;
	};
	
	I2of5Reader.prototype._decodeCode = function (counter) {
	    var j,
	        self = this,
	        sum = 0,
	        normalized,
	        error,
	        epsilon = self.AVG_CODE_ERROR,
	        code,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: 0,
	        end: 0
	    };
	
	    for (j = 0; j < counter.length; j++) {
	        sum += counter[j];
	    }
	    for (code = 0; code < self.CODE_PATTERN.length; code++) {
	        error = self._matchPattern(counter, self.CODE_PATTERN[code]);
	        if (error < bestMatch.error) {
	            bestMatch.code = code;
	            bestMatch.error = error;
	        }
	    }
	    if (bestMatch.error < epsilon) {
	        return bestMatch;
	    }
	};
	
	I2of5Reader.prototype._decodePayload = function (counters, result, decodedCodes) {
	    var i,
	        self = this,
	        pos = 0,
	        counterLength = counters.length,
	        counterPair = [[0, 0, 0, 0, 0], [0, 0, 0, 0, 0]],
	        codes;
	
	    while (pos < counterLength) {
	        for (i = 0; i < 5; i++) {
	            counterPair[0][i] = counters[pos] * this.barSpaceRatio[0];
	            counterPair[1][i] = counters[pos + 1] * this.barSpaceRatio[1];
	            pos += 2;
	        }
	        codes = self._decodePair(counterPair);
	        if (!codes) {
	            return null;
	        }
	        for (i = 0; i < codes.length; i++) {
	            result.push(codes[i].code + "");
	            decodedCodes.push(codes[i]);
	        }
	    }
	    return codes;
	};
	
	I2of5Reader.prototype._verifyCounterLength = function (counters) {
	    return counters.length % 10 === 0;
	};
	
	I2of5Reader.prototype._decode = function () {
	    var startInfo,
	        endInfo,
	        self = this,
	        code,
	        result = [],
	        decodedCodes = [],
	        counters;
	
	    startInfo = self._findStart();
	    if (!startInfo) {
	        return null;
	    }
	    decodedCodes.push(startInfo);
	
	    endInfo = self._findEnd();
	    if (!endInfo) {
	        return null;
	    }
	
	    counters = self._fillCounters(startInfo.end, endInfo.start, false);
	    if (!self._verifyCounterLength(counters)) {
	        return null;
	    }
	    code = self._decodePayload(counters, result, decodedCodes);
	    if (!code) {
	        return null;
	    }
	    if (result.length % 2 !== 0 || result.length < 6) {
	        return null;
	    }
	
	    decodedCodes.push(endInfo);
	    return {
	        code: result.join(""),
	        start: startInfo.start,
	        end: endInfo.end,
	        startInfo: startInfo,
	        decodedCodes: decodedCodes
	    };
	};
	
	I2of5Reader.CONFIG_KEYS = {
	    normalizeBarSpaceWidth: {
	        'type': 'boolean',
	        'default': false,
	        'description': 'If true, the reader tries to normalize the' + 'width-difference between bars and spaces'
	    }
	};
	
	/* harmony default export */ exports["a"] = I2of5Reader;

/***/ },
/* 73 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__ean_reader__ = __webpack_require__(3);
	
	
	function UPCEReader(opts, supplements) {
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a"].call(this, opts, supplements);
	}
	
	var properties = {
	    CODE_FREQUENCY: { value: [[56, 52, 50, 49, 44, 38, 35, 42, 41, 37], [7, 11, 13, 14, 19, 25, 28, 21, 22, 26]] },
	    STOP_PATTERN: { value: [1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7] },
	    FORMAT: { value: "upc_e", writeable: false }
	};
	
	UPCEReader.prototype = Object.create(/* harmony import */__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a"].prototype, properties);
	UPCEReader.prototype.constructor = UPCEReader;
	
	UPCEReader.prototype._decodePayload = function (code, result, decodedCodes) {
	    var i,
	        self = this,
	        codeFrequency = 0x0;
	
	    for (i = 0; i < 6; i++) {
	        code = self._decodeCode(code.end);
	        if (!code) {
	            return null;
	        }
	        if (code.code >= self.CODE_G_START) {
	            code.code = code.code - self.CODE_G_START;
	            codeFrequency |= 1 << 5 - i;
	        }
	        result.push(code.code);
	        decodedCodes.push(code);
	    }
	    if (!self._determineParity(codeFrequency, result)) {
	        return null;
	    }
	
	    return code;
	};
	
	UPCEReader.prototype._determineParity = function (codeFrequency, result) {
	    var i, nrSystem;
	
	    for (nrSystem = 0; nrSystem < this.CODE_FREQUENCY.length; nrSystem++) {
	        for (i = 0; i < this.CODE_FREQUENCY[nrSystem].length; i++) {
	            if (codeFrequency === this.CODE_FREQUENCY[nrSystem][i]) {
	                result.unshift(nrSystem);
	                result.push(i);
	                return true;
	            }
	        }
	    }
	    return false;
	};
	
	UPCEReader.prototype._convertToUPCA = function (result) {
	    var upca = [result[0]],
	        lastDigit = result[result.length - 2];
	
	    if (lastDigit <= 2) {
	        upca = upca.concat(result.slice(1, 3)).concat([lastDigit, 0, 0, 0, 0]).concat(result.slice(3, 6));
	    } else if (lastDigit === 3) {
	        upca = upca.concat(result.slice(1, 4)).concat([0, 0, 0, 0, 0]).concat(result.slice(4, 6));
	    } else if (lastDigit === 4) {
	        upca = upca.concat(result.slice(1, 5)).concat([0, 0, 0, 0, 0, result[5]]);
	    } else {
	        upca = upca.concat(result.slice(1, 6)).concat([0, 0, 0, 0, lastDigit]);
	    }
	
	    upca.push(result[result.length - 1]);
	    return upca;
	};
	
	UPCEReader.prototype._checksum = function (result) {
	    return /* harmony import */__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a"].prototype._checksum.call(this, this._convertToUPCA(result));
	};
	
	UPCEReader.prototype._findEnd = function (offset, isWhite) {
	    isWhite = true;
	    return /* harmony import */__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a"].prototype._findEnd.call(this, offset, isWhite);
	};
	
	UPCEReader.prototype._verifyTrailingWhitespace = function (endInfo) {
	    var self = this,
	        trailingWhitespaceEnd;
	
	    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
	    if (trailingWhitespaceEnd < self._row.length) {
	        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
	            return endInfo;
	        }
	    }
	};
	
	/* harmony default export */ exports["a"] = UPCEReader;

/***/ },
/* 74 */
/***/ function(module, exports, __webpack_require__) {

	/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__ean_reader__ = __webpack_require__(3);
	
	
	function UPCReader(opts, supplements) {
	    /* harmony import */__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a"].call(this, opts, supplements);
	}
	
	var properties = {
	    FORMAT: { value: "upc_a", writeable: false }
	};
	
	UPCReader.prototype = Object.create(/* harmony import */__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a"].prototype, properties);
	UPCReader.prototype.constructor = UPCReader;
	
	UPCReader.prototype._decode = function () {
	    var result = /* harmony import */__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a"].prototype._decode.call(this);
	
	    if (result && result.code && result.code.length === 13 && result.code.charAt(0) === "0") {
	        result.code = result.code.substring(1);
	        return result;
	    }
	    return null;
	};
	
	/* harmony default export */ exports["a"] = UPCReader;

/***/ },
/* 75 */
/***/ function(module, exports, __webpack_require__) {

	module.e = copy
	
	/**
	 * Copy the values from one mat2 to another
	 *
	 * @alias mat2.copy
	 * @param {mat2} out the receiving matrix
	 * @param {mat2} a the source matrix
	 * @returns {mat2} out
	 */
	function copy(out, a) {
	  out[0] = a[0]
	  out[1] = a[1]
	  out[2] = a[2]
	  out[3] = a[3]
	  return out
	}


/***/ },
/* 76 */
/***/ function(module, exports, __webpack_require__) {

	module.e = create
	
	/**
	 * Creates a new identity mat2
	 *
	 * @alias mat2.create
	 * @returns {mat2} a new 2x2 matrix
	 */
	function create() {
	  var out = new Float32Array(4)
	  out[0] = 1
	  out[1] = 0
	  out[2] = 0
	  out[3] = 1
	  return out
	}


/***/ },
/* 77 */
/***/ function(module, exports, __webpack_require__) {

	module.e = invert
	
	/**
	 * Inverts a mat2
	 *
	 * @alias mat2.invert
	 * @param {mat2} out the receiving matrix
	 * @param {mat2} a the source matrix
	 * @returns {mat2} out
	 */
	function invert(out, a) {
	  var a0 = a[0]
	  var a1 = a[1]
	  var a2 = a[2]
	  var a3 = a[3]
	  var det = a0 * a3 - a2 * a1
	
	  if (!det) return null
	  det = 1.0 / det
	
	  out[0] =  a3 * det
	  out[1] = -a1 * det
	  out[2] = -a2 * det
	  out[3] =  a0 * det
	
	  return out
	}


/***/ },
/* 78 */
/***/ function(module, exports, __webpack_require__) {

	module.e = scale
	
	/**
	 * Scales a vec2 by a scalar number
	 *
	 * @param {vec2} out the receiving vector
	 * @param {vec2} a the vector to scale
	 * @param {Number} b amount to scale the vector by
	 * @returns {vec2} out
	 */
	function scale(out, a, b) {
	    out[0] = a[0] * b
	    out[1] = a[1] * b
	    return out
	}

/***/ },
/* 79 */
/***/ function(module, exports, __webpack_require__) {

	module.e = transformMat2
	
	/**
	 * Transforms the vec2 with a mat2
	 *
	 * @param {vec2} out the receiving vector
	 * @param {vec2} a the vector to transform
	 * @param {mat2} m matrix to transform with
	 * @returns {vec2} out
	 */
	function transformMat2(out, a, m) {
	    var x = a[0],
	        y = a[1]
	    out[0] = m[0] * x + m[2] * y
	    out[1] = m[1] * x + m[3] * y
	    return out
	}

/***/ },
/* 80 */
/***/ function(module, exports, __webpack_require__) {

	module.e = clone;
	
	/**
	 * Creates a new vec3 initialized with values from an existing vector
	 *
	 * @param {vec3} a vector to clone
	 * @returns {vec3} a new 3D vector
	 */
	function clone(a) {
	    var out = new Float32Array(3)
	    out[0] = a[0]
	    out[1] = a[1]
	    out[2] = a[2]
	    return out
	}

/***/ },
/* 81 */
/***/ function(module, exports, __webpack_require__) {

	var nativeCreate = __webpack_require__(14);
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/**
	 * Creates an hash object.
	 *
	 * @private
	 * @constructor
	 * @returns {Object} Returns the new hash object.
	 */
	function Hash() {}
	
	// Avoid inheriting from `Object.prototype` when possible.
	Hash.prototype = nativeCreate ? nativeCreate(null) : objectProto;
	
	module.e = Hash;


/***/ },
/* 82 */
/***/ function(module, exports, __webpack_require__) {

	var mapClear = __webpack_require__(128),
	    mapDelete = __webpack_require__(129),
	    mapGet = __webpack_require__(130),
	    mapHas = __webpack_require__(131),
	    mapSet = __webpack_require__(132);
	
	/**
	 * Creates a map cache object to store key-value pairs.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [values] The values to cache.
	 */
	function MapCache(values) {
	  var index = -1,
	      length = values ? values.length : 0;
	
	  this.clear();
	  while (++index < length) {
	    var entry = values[index];
	    this.set(entry[0], entry[1]);
	  }
	}
	
	// Add functions to the `MapCache`.
	MapCache.prototype.clear = mapClear;
	MapCache.prototype['delete'] = mapDelete;
	MapCache.prototype.get = mapGet;
	MapCache.prototype.has = mapHas;
	MapCache.prototype.set = mapSet;
	
	module.e = MapCache;


/***/ },
/* 83 */
/***/ function(module, exports, __webpack_require__) {

	var root = __webpack_require__(1);
	
	/** Built-in value references. */
	var Reflect = root.Reflect;
	
	module.e = Reflect;


/***/ },
/* 84 */
/***/ function(module, exports, __webpack_require__) {

	var getNative = __webpack_require__(12),
	    root = __webpack_require__(1);
	
	/* Built-in method references that are verified to be native. */
	var Set = getNative(root, 'Set');
	
	module.e = Set;


/***/ },
/* 85 */
/***/ function(module, exports, __webpack_require__) {

	var root = __webpack_require__(1);
	
	/** Built-in value references. */
	var Symbol = root.Symbol;
	
	module.e = Symbol;


/***/ },
/* 86 */
/***/ function(module, exports, __webpack_require__) {

	var root = __webpack_require__(1);
	
	/** Built-in value references. */
	var Uint8Array = root.Uint8Array;
	
	module.e = Uint8Array;


/***/ },
/* 87 */
/***/ function(module, exports, __webpack_require__) {

	var getNative = __webpack_require__(12),
	    root = __webpack_require__(1);
	
	/* Built-in method references that are verified to be native. */
	var WeakMap = getNative(root, 'WeakMap');
	
	module.e = WeakMap;


/***/ },
/* 88 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Adds the key-value `pair` to `map`.
	 *
	 * @private
	 * @param {Object} map The map to modify.
	 * @param {Array} pair The key-value pair to add.
	 * @returns {Object} Returns `map`.
	 */
	function addMapEntry(map, pair) {
	  // Don't return `Map#set` because it doesn't return the map instance in IE 11.
	  map.set(pair[0], pair[1]);
	  return map;
	}
	
	module.e = addMapEntry;


/***/ },
/* 89 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Adds `value` to `set`.
	 *
	 * @private
	 * @param {Object} set The set to modify.
	 * @param {*} value The value to add.
	 * @returns {Object} Returns `set`.
	 */
	function addSetEntry(set, value) {
	  set.add(value);
	  return set;
	}
	
	module.e = addSetEntry;


/***/ },
/* 90 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * A faster alternative to `Function#apply`, this function invokes `func`
	 * with the `this` binding of `thisArg` and the arguments of `args`.
	 *
	 * @private
	 * @param {Function} func The function to invoke.
	 * @param {*} thisArg The `this` binding of `func`.
	 * @param {...*} args The arguments to invoke `func` with.
	 * @returns {*} Returns the result of `func`.
	 */
	function apply(func, thisArg, args) {
	  var length = args.length;
	  switch (length) {
	    case 0: return func.call(thisArg);
	    case 1: return func.call(thisArg, args[0]);
	    case 2: return func.call(thisArg, args[0], args[1]);
	    case 3: return func.call(thisArg, args[0], args[1], args[2]);
	  }
	  return func.apply(thisArg, args);
	}
	
	module.e = apply;


/***/ },
/* 91 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Appends the elements of `values` to `array`.
	 *
	 * @private
	 * @param {Array} array The array to modify.
	 * @param {Array} values The values to append.
	 * @returns {Array} Returns `array`.
	 */
	function arrayPush(array, values) {
	  var index = -1,
	      length = values.length,
	      offset = array.length;
	
	  while (++index < length) {
	    array[offset + index] = values[index];
	  }
	  return array;
	}
	
	module.e = arrayPush;


/***/ },
/* 92 */
/***/ function(module, exports, __webpack_require__) {

	var copyObject = __webpack_require__(21),
	    keys = __webpack_require__(45);
	
	/**
	 * The base implementation of `_.assign` without support for multiple sources
	 * or `customizer` functions.
	 *
	 * @private
	 * @param {Object} object The destination object.
	 * @param {Object} source The source object.
	 * @returns {Object} Returns `object`.
	 */
	function baseAssign(object, source) {
	  return object && copyObject(source, keys(source), object);
	}
	
	module.e = baseAssign;


/***/ },
/* 93 */
/***/ function(module, exports, __webpack_require__) {

	var Stack = __webpack_require__(32),
	    arrayEach = __webpack_require__(33),
	    assignValue = __webpack_require__(35),
	    baseAssign = __webpack_require__(92),
	    baseForOwn = __webpack_require__(97),
	    cloneBuffer = __webpack_require__(107),
	    copyArray = __webpack_require__(41),
	    copySymbols = __webpack_require__(114),
	    getTag = __webpack_require__(119),
	    initCloneArray = __webpack_require__(123),
	    initCloneByTag = __webpack_require__(124),
	    initCloneObject = __webpack_require__(125),
	    isArray = __webpack_require__(5),
	    isBuffer = __webpack_require__(141),
	    isHostObject = __webpack_require__(22),
	    isObject = __webpack_require__(2);
	
	/** `Object#toString` result references. */
	var argsTag = '[object Arguments]',
	    arrayTag = '[object Array]',
	    boolTag = '[object Boolean]',
	    dateTag = '[object Date]',
	    errorTag = '[object Error]',
	    funcTag = '[object Function]',
	    genTag = '[object GeneratorFunction]',
	    mapTag = '[object Map]',
	    numberTag = '[object Number]',
	    objectTag = '[object Object]',
	    regexpTag = '[object RegExp]',
	    setTag = '[object Set]',
	    stringTag = '[object String]',
	    symbolTag = '[object Symbol]',
	    weakMapTag = '[object WeakMap]';
	
	var arrayBufferTag = '[object ArrayBuffer]',
	    float32Tag = '[object Float32Array]',
	    float64Tag = '[object Float64Array]',
	    int8Tag = '[object Int8Array]',
	    int16Tag = '[object Int16Array]',
	    int32Tag = '[object Int32Array]',
	    uint8Tag = '[object Uint8Array]',
	    uint8ClampedTag = '[object Uint8ClampedArray]',
	    uint16Tag = '[object Uint16Array]',
	    uint32Tag = '[object Uint32Array]';
	
	/** Used to identify `toStringTag` values supported by `_.clone`. */
	var cloneableTags = {};
	cloneableTags[argsTag] = cloneableTags[arrayTag] =
	cloneableTags[arrayBufferTag] = cloneableTags[boolTag] =
	cloneableTags[dateTag] = cloneableTags[float32Tag] =
	cloneableTags[float64Tag] = cloneableTags[int8Tag] =
	cloneableTags[int16Tag] = cloneableTags[int32Tag] =
	cloneableTags[mapTag] = cloneableTags[numberTag] =
	cloneableTags[objectTag] = cloneableTags[regexpTag] =
	cloneableTags[setTag] = cloneableTags[stringTag] =
	cloneableTags[symbolTag] = cloneableTags[uint8Tag] =
	cloneableTags[uint8ClampedTag] = cloneableTags[uint16Tag] =
	cloneableTags[uint32Tag] = true;
	cloneableTags[errorTag] = cloneableTags[funcTag] =
	cloneableTags[weakMapTag] = false;
	
	/**
	 * The base implementation of `_.clone` and `_.cloneDeep` which tracks
	 * traversed objects.
	 *
	 * @private
	 * @param {*} value The value to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @param {boolean} [isFull] Specify a clone including symbols.
	 * @param {Function} [customizer] The function to customize cloning.
	 * @param {string} [key] The key of `value`.
	 * @param {Object} [object] The parent object of `value`.
	 * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
	 * @returns {*} Returns the cloned value.
	 */
	function baseClone(value, isDeep, isFull, customizer, key, object, stack) {
	  var result;
	  if (customizer) {
	    result = object ? customizer(value, key, object, stack) : customizer(value);
	  }
	  if (result !== undefined) {
	    return result;
	  }
	  if (!isObject(value)) {
	    return value;
	  }
	  var isArr = isArray(value);
	  if (isArr) {
	    result = initCloneArray(value);
	    if (!isDeep) {
	      return copyArray(value, result);
	    }
	  } else {
	    var tag = getTag(value),
	        isFunc = tag == funcTag || tag == genTag;
	
	    if (isBuffer(value)) {
	      return cloneBuffer(value, isDeep);
	    }
	    if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
	      if (isHostObject(value)) {
	        return object ? value : {};
	      }
	      result = initCloneObject(isFunc ? {} : value);
	      if (!isDeep) {
	        result = baseAssign(result, value);
	        return isFull ? copySymbols(value, result) : result;
	      }
	    } else {
	      if (!cloneableTags[tag]) {
	        return object ? value : {};
	      }
	      result = initCloneByTag(value, tag, isDeep);
	    }
	  }
	  // Check for circular references and return its corresponding clone.
	  stack || (stack = new Stack);
	  var stacked = stack.get(value);
	  if (stacked) {
	    return stacked;
	  }
	  stack.set(value, result);
	
	  // Recursively populate clone (susceptible to call stack limits).
	  (isArr ? arrayEach : baseForOwn)(value, function(subValue, key) {
	    assignValue(result, key, baseClone(subValue, isDeep, isFull, customizer, key, value, stack));
	  });
	  return (isFull && !isArr) ? copySymbols(value, result) : result;
	}
	
	module.e = baseClone;


/***/ },
/* 94 */
/***/ function(module, exports, __webpack_require__) {

	var isObject = __webpack_require__(2);
	
	/** Built-in value references. */
	var objectCreate = Object.create;
	
	/**
	 * The base implementation of `_.create` without support for assigning
	 * properties to the created object.
	 *
	 * @private
	 * @param {Object} prototype The object to inherit from.
	 * @returns {Object} Returns the new object.
	 */
	function baseCreate(proto) {
	  return isObject(proto) ? objectCreate(proto) : {};
	}
	
	module.e = baseCreate;


/***/ },
/* 95 */
/***/ function(module, exports, __webpack_require__) {

	var arrayPush = __webpack_require__(91),
	    isArguments = __webpack_require__(25),
	    isArray = __webpack_require__(5),
	    isArrayLikeObject = __webpack_require__(27);
	
	/**
	 * The base implementation of `_.flatten` with support for restricting flattening.
	 *
	 * @private
	 * @param {Array} array The array to flatten.
	 * @param {number} depth The maximum recursion depth.
	 * @param {boolean} [isStrict] Restrict flattening to arrays-like objects.
	 * @param {Array} [result=[]] The initial result value.
	 * @returns {Array} Returns the new flattened array.
	 */
	function baseFlatten(array, depth, isStrict, result) {
	  result || (result = []);
	
	  var index = -1,
	      length = array.length;
	
	  while (++index < length) {
	    var value = array[index];
	    if (depth > 0 && isArrayLikeObject(value) &&
	        (isStrict || isArray(value) || isArguments(value))) {
	      if (depth > 1) {
	        // Recursively flatten arrays (susceptible to call stack limits).
	        baseFlatten(value, depth - 1, isStrict, result);
	      } else {
	        arrayPush(result, value);
	      }
	    } else if (!isStrict) {
	      result[result.length] = value;
	    }
	  }
	  return result;
	}
	
	module.e = baseFlatten;


/***/ },
/* 96 */
/***/ function(module, exports, __webpack_require__) {

	var createBaseFor = __webpack_require__(116);
	
	/**
	 * The base implementation of `baseForIn` and `baseForOwn` which iterates
	 * over `object` properties returned by `keysFunc` invoking `iteratee` for
	 * each property. Iteratee functions may exit iteration early by explicitly
	 * returning `false`.
	 *
	 * @private
	 * @param {Object} object The object to iterate over.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @param {Function} keysFunc The function to get the keys of `object`.
	 * @returns {Object} Returns `object`.
	 */
	var baseFor = createBaseFor();
	
	module.e = baseFor;


/***/ },
/* 97 */
/***/ function(module, exports, __webpack_require__) {

	var baseFor = __webpack_require__(96),
	    keys = __webpack_require__(45);
	
	/**
	 * The base implementation of `_.forOwn` without support for iteratee shorthands.
	 *
	 * @private
	 * @param {Object} object The object to iterate over.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @returns {Object} Returns `object`.
	 */
	function baseForOwn(object, iteratee) {
	  return object && baseFor(object, iteratee, keys);
	}
	
	module.e = baseForOwn;


/***/ },
/* 98 */
/***/ function(module, exports, __webpack_require__) {

	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/** Built-in value references. */
	var getPrototypeOf = Object.getPrototypeOf;
	
	/**
	 * The base implementation of `_.has` without support for deep paths.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {Array|string} key The key to check.
	 * @returns {boolean} Returns `true` if `key` exists, else `false`.
	 */
	function baseHas(object, key) {
	  // Avoid a bug in IE 10-11 where objects with a [[Prototype]] of `null`,
	  // that are composed entirely of index properties, return `false` for
	  // `hasOwnProperty` checks of them.
	  return hasOwnProperty.call(object, key) ||
	    (typeof object == 'object' && key in object && getPrototypeOf(object) === null);
	}
	
	module.e = baseHas;


/***/ },
/* 99 */
/***/ function(module, exports, __webpack_require__) {

	/* Built-in method references for those with the same name as other `lodash` methods. */
	var nativeKeys = Object.keys;
	
	/**
	 * The base implementation of `_.keys` which doesn't skip the constructor
	 * property of prototypes or treat sparse arrays as dense.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 */
	function baseKeys(object) {
	  return nativeKeys(Object(object));
	}
	
	module.e = baseKeys;


/***/ },
/* 100 */
/***/ function(module, exports, __webpack_require__) {

	var Reflect = __webpack_require__(83),
	    iteratorToArray = __webpack_require__(127);
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Built-in value references. */
	var enumerate = Reflect ? Reflect.enumerate : undefined,
	    propertyIsEnumerable = objectProto.propertyIsEnumerable;
	
	/**
	 * The base implementation of `_.keysIn` which doesn't skip the constructor
	 * property of prototypes or treat sparse arrays as dense.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 */
	function baseKeysIn(object) {
	  object = object == null ? object : Object(object);
	
	  var result = [];
	  for (var key in object) {
	    result.push(key);
	  }
	  return result;
	}
	
	// Fallback for IE < 9 with es6-shim.
	if (enumerate && !propertyIsEnumerable.call({ 'valueOf': 1 }, 'valueOf')) {
	  baseKeysIn = function(object) {
	    return iteratorToArray(enumerate(object));
	  };
	}
	
	module.e = baseKeysIn;


/***/ },
/* 101 */
/***/ function(module, exports, __webpack_require__) {

	var Stack = __webpack_require__(32),
	    arrayEach = __webpack_require__(33),
	    assignMergeValue = __webpack_require__(34),
	    baseMergeDeep = __webpack_require__(102),
	    isArray = __webpack_require__(5),
	    isObject = __webpack_require__(2),
	    isTypedArray = __webpack_require__(44),
	    keysIn = __webpack_require__(46);
	
	/**
	 * The base implementation of `_.merge` without support for multiple sources.
	 *
	 * @private
	 * @param {Object} object The destination object.
	 * @param {Object} source The source object.
	 * @param {number} srcIndex The index of `source`.
	 * @param {Function} [customizer] The function to customize merged values.
	 * @param {Object} [stack] Tracks traversed source values and their merged counterparts.
	 */
	function baseMerge(object, source, srcIndex, customizer, stack) {
	  if (object === source) {
	    return;
	  }
	  var props = (isArray(source) || isTypedArray(source))
	    ? undefined
	    : keysIn(source);
	
	  arrayEach(props || source, function(srcValue, key) {
	    if (props) {
	      key = srcValue;
	      srcValue = source[key];
	    }
	    if (isObject(srcValue)) {
	      stack || (stack = new Stack);
	      baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
	    }
	    else {
	      var newValue = customizer
	        ? customizer(object[key], srcValue, (key + ''), object, source, stack)
	        : undefined;
	
	      if (newValue === undefined) {
	        newValue = srcValue;
	      }
	      assignMergeValue(object, key, newValue);
	    }
	  });
	}
	
	module.e = baseMerge;


/***/ },
/* 102 */
/***/ function(module, exports, __webpack_require__) {

	var assignMergeValue = __webpack_require__(34),
	    baseClone = __webpack_require__(93),
	    copyArray = __webpack_require__(41),
	    isArguments = __webpack_require__(25),
	    isArray = __webpack_require__(5),
	    isArrayLikeObject = __webpack_require__(27),
	    isFunction = __webpack_require__(16),
	    isObject = __webpack_require__(2),
	    isPlainObject = __webpack_require__(143),
	    isTypedArray = __webpack_require__(44),
	    toPlainObject = __webpack_require__(148);
	
	/**
	 * A specialized version of `baseMerge` for arrays and objects which performs
	 * deep merges and tracks traversed objects enabling objects with circular
	 * references to be merged.
	 *
	 * @private
	 * @param {Object} object The destination object.
	 * @param {Object} source The source object.
	 * @param {string} key The key of the value to merge.
	 * @param {number} srcIndex The index of `source`.
	 * @param {Function} mergeFunc The function to merge values.
	 * @param {Function} [customizer] The function to customize assigned values.
	 * @param {Object} [stack] Tracks traversed source values and their merged counterparts.
	 */
	function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
	  var objValue = object[key],
	      srcValue = source[key],
	      stacked = stack.get(srcValue);
	
	  if (stacked) {
	    assignMergeValue(object, key, stacked);
	    return;
	  }
	  var newValue = customizer
	    ? customizer(objValue, srcValue, (key + ''), object, source, stack)
	    : undefined;
	
	  var isCommon = newValue === undefined;
	
	  if (isCommon) {
	    newValue = srcValue;
	    if (isArray(srcValue) || isTypedArray(srcValue)) {
	      if (isArray(objValue)) {
	        newValue = objValue;
	      }
	      else if (isArrayLikeObject(objValue)) {
	        newValue = copyArray(objValue);
	      }
	      else {
	        isCommon = false;
	        newValue = baseClone(srcValue, !customizer);
	      }
	    }
	    else if (isPlainObject(srcValue) || isArguments(srcValue)) {
	      if (isArguments(objValue)) {
	        newValue = toPlainObject(objValue);
	      }
	      else if (!isObject(objValue) || (srcIndex && isFunction(objValue))) {
	        isCommon = false;
	        newValue = baseClone(srcValue, !customizer);
	      }
	      else {
	        newValue = objValue;
	      }
	    }
	    else {
	      isCommon = false;
	    }
	  }
	  stack.set(srcValue, newValue);
	
	  if (isCommon) {
	    // Recursively merge objects and arrays (susceptible to call stack limits).
	    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
	  }
	  stack['delete'](srcValue);
	  assignMergeValue(object, key, newValue);
	}
	
	module.e = baseMergeDeep;


/***/ },
/* 103 */
/***/ function(module, exports, __webpack_require__) {

	var arrayReduce = __webpack_require__(20);
	
	/**
	 * The base implementation of `_.pick` without support for individual
	 * property names.
	 *
	 * @private
	 * @param {Object} object The source object.
	 * @param {string[]} props The property names to pick.
	 * @returns {Object} Returns the new object.
	 */
	function basePick(object, props) {
	  object = Object(object);
	  return arrayReduce(props, function(result, key) {
	    if (key in object) {
	      result[key] = object[key];
	    }
	    return result;
	  }, {});
	}
	
	module.e = basePick;


/***/ },
/* 104 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * The base implementation of `_.property` without support for deep paths.
	 *
	 * @private
	 * @param {string} key The key of the property to get.
	 * @returns {Function} Returns the new function.
	 */
	function baseProperty(key) {
	  return function(object) {
	    return object == null ? undefined : object[key];
	  };
	}
	
	module.e = baseProperty;


/***/ },
/* 105 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * The base implementation of `_.times` without support for iteratee shorthands
	 * or max array length checks.
	 *
	 * @private
	 * @param {number} n The number of times to invoke `iteratee`.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @returns {Array} Returns the array of results.
	 */
	function baseTimes(n, iteratee) {
	  var index = -1,
	      result = Array(n);
	
	  while (++index < n) {
	    result[index] = iteratee(index);
	  }
	  return result;
	}
	
	module.e = baseTimes;


/***/ },
/* 106 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Checks if `value` is a global object.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {null|Object} Returns `value` if it's a global object, else `null`.
	 */
	function checkGlobal(value) {
	  return (value && value.Object === Object) ? value : null;
	}
	
	module.e = checkGlobal;


/***/ },
/* 107 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Creates a clone of  `buffer`.
	 *
	 * @private
	 * @param {Buffer} buffer The buffer to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Buffer} Returns the cloned buffer.
	 */
	function cloneBuffer(buffer, isDeep) {
	  if (isDeep) {
	    return buffer.slice();
	  }
	  var result = new buffer.constructor(buffer.length);
	  buffer.copy(result);
	  return result;
	}
	
	module.e = cloneBuffer;


/***/ },
/* 108 */
/***/ function(module, exports, __webpack_require__) {

	var addMapEntry = __webpack_require__(88),
	    arrayReduce = __webpack_require__(20),
	    mapToArray = __webpack_require__(133);
	
	/**
	 * Creates a clone of `map`.
	 *
	 * @private
	 * @param {Object} map The map to clone.
	 * @returns {Object} Returns the cloned map.
	 */
	function cloneMap(map) {
	  return arrayReduce(mapToArray(map), addMapEntry, new map.constructor);
	}
	
	module.e = cloneMap;


/***/ },
/* 109 */
/***/ function(module, exports, __webpack_require__) {

	/** Used to match `RegExp` flags from their coerced string values. */
	var reFlags = /\w*$/;
	
	/**
	 * Creates a clone of `regexp`.
	 *
	 * @private
	 * @param {Object} regexp The regexp to clone.
	 * @returns {Object} Returns the cloned regexp.
	 */
	function cloneRegExp(regexp) {
	  var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
	  result.lastIndex = regexp.lastIndex;
	  return result;
	}
	
	module.e = cloneRegExp;


/***/ },
/* 110 */
/***/ function(module, exports, __webpack_require__) {

	var addSetEntry = __webpack_require__(89),
	    arrayReduce = __webpack_require__(20),
	    setToArray = __webpack_require__(134);
	
	/**
	 * Creates a clone of `set`.
	 *
	 * @private
	 * @param {Object} set The set to clone.
	 * @returns {Object} Returns the cloned set.
	 */
	function cloneSet(set) {
	  return arrayReduce(setToArray(set), addSetEntry, new set.constructor);
	}
	
	module.e = cloneSet;


/***/ },
/* 111 */
/***/ function(module, exports, __webpack_require__) {

	var Symbol = __webpack_require__(85);
	
	/** Used to convert symbols to primitives and strings. */
	var symbolProto = Symbol ? Symbol.prototype : undefined,
	    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;
	
	/**
	 * Creates a clone of the `symbol` object.
	 *
	 * @private
	 * @param {Object} symbol The symbol object to clone.
	 * @returns {Object} Returns the cloned symbol object.
	 */
	function cloneSymbol(symbol) {
	  return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
	}
	
	module.e = cloneSymbol;


/***/ },
/* 112 */
/***/ function(module, exports, __webpack_require__) {

	var cloneArrayBuffer = __webpack_require__(40);
	
	/**
	 * Creates a clone of `typedArray`.
	 *
	 * @private
	 * @param {Object} typedArray The typed array to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Object} Returns the cloned typed array.
	 */
	function cloneTypedArray(typedArray, isDeep) {
	  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
	  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
	}
	
	module.e = cloneTypedArray;


/***/ },
/* 113 */
/***/ function(module, exports, __webpack_require__) {

	var assignValue = __webpack_require__(35);
	
	/**
	 * This function is like `copyObject` except that it accepts a function to
	 * customize copied values.
	 *
	 * @private
	 * @param {Object} source The object to copy properties from.
	 * @param {Array} props The property names to copy.
	 * @param {Object} [object={}] The object to copy properties to.
	 * @param {Function} [customizer] The function to customize copied values.
	 * @returns {Object} Returns `object`.
	 */
	function copyObjectWith(source, props, object, customizer) {
	  object || (object = {});
	
	  var index = -1,
	      length = props.length;
	
	  while (++index < length) {
	    var key = props[index];
	
	    var newValue = customizer
	      ? customizer(object[key], source[key], key, object, source)
	      : source[key];
	
	    assignValue(object, key, newValue);
	  }
	  return object;
	}
	
	module.e = copyObjectWith;


/***/ },
/* 114 */
/***/ function(module, exports, __webpack_require__) {

	var copyObject = __webpack_require__(21),
	    getSymbols = __webpack_require__(118);
	
	/**
	 * Copies own symbol properties of `source` to `object`.
	 *
	 * @private
	 * @param {Object} source The object to copy symbols from.
	 * @param {Object} [object={}] The object to copy symbols to.
	 * @returns {Object} Returns `object`.
	 */
	function copySymbols(source, object) {
	  return copyObject(source, getSymbols(source), object);
	}
	
	module.e = copySymbols;


/***/ },
/* 115 */
/***/ function(module, exports, __webpack_require__) {

	var isIterateeCall = __webpack_require__(126),
	    rest = __webpack_require__(47);
	
	/**
	 * Creates a function like `_.assign`.
	 *
	 * @private
	 * @param {Function} assigner The function to assign values.
	 * @returns {Function} Returns the new assigner function.
	 */
	function createAssigner(assigner) {
	  return rest(function(object, sources) {
	    var index = -1,
	        length = sources.length,
	        customizer = length > 1 ? sources[length - 1] : undefined,
	        guard = length > 2 ? sources[2] : undefined;
	
	    customizer = typeof customizer == 'function'
	      ? (length--, customizer)
	      : undefined;
	
	    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
	      customizer = length < 3 ? undefined : customizer;
	      length = 1;
	    }
	    object = Object(object);
	    while (++index < length) {
	      var source = sources[index];
	      if (source) {
	        assigner(object, source, index, customizer);
	      }
	    }
	    return object;
	  });
	}
	
	module.e = createAssigner;


/***/ },
/* 116 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Creates a base function for methods like `_.forIn`.
	 *
	 * @private
	 * @param {boolean} [fromRight] Specify iterating from right to left.
	 * @returns {Function} Returns the new base function.
	 */
	function createBaseFor(fromRight) {
	  return function(object, iteratee, keysFunc) {
	    var index = -1,
	        iterable = Object(object),
	        props = keysFunc(object),
	        length = props.length;
	
	    while (length--) {
	      var key = props[fromRight ? length : ++index];
	      if (iteratee(iterable[key], key, iterable) === false) {
	        break;
	      }
	    }
	    return object;
	  };
	}
	
	module.e = createBaseFor;


/***/ },
/* 117 */
/***/ function(module, exports, __webpack_require__) {

	var baseProperty = __webpack_require__(104);
	
	/**
	 * Gets the "length" property value of `object`.
	 *
	 * **Note:** This function is used to avoid a [JIT bug](https://bugs.webkit.org/show_bug.cgi?id=142792)
	 * that affects Safari on at least iOS 8.1-8.3 ARM64.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {*} Returns the "length" value.
	 */
	var getLength = baseProperty('length');
	
	module.e = getLength;


/***/ },
/* 118 */
/***/ function(module, exports, __webpack_require__) {

	/** Built-in value references. */
	var getOwnPropertySymbols = Object.getOwnPropertySymbols;
	
	/**
	 * Creates an array of the own symbol properties of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of symbols.
	 */
	var getSymbols = getOwnPropertySymbols || function() {
	  return [];
	};
	
	module.e = getSymbols;


/***/ },
/* 119 */
/***/ function(module, exports, __webpack_require__) {

	var Map = __webpack_require__(4),
	    Set = __webpack_require__(84),
	    WeakMap = __webpack_require__(87);
	
	/** `Object#toString` result references. */
	var mapTag = '[object Map]',
	    objectTag = '[object Object]',
	    setTag = '[object Set]',
	    weakMapTag = '[object WeakMap]';
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to resolve the decompiled source of functions. */
	var funcToString = Function.prototype.toString;
	
	/**
	 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;
	
	/** Used to detect maps, sets, and weakmaps. */
	var mapCtorString = Map ? funcToString.call(Map) : '',
	    setCtorString = Set ? funcToString.call(Set) : '',
	    weakMapCtorString = WeakMap ? funcToString.call(WeakMap) : '';
	
	/**
	 * Gets the `toStringTag` of `value`.
	 *
	 * @private
	 * @param {*} value The value to query.
	 * @returns {string} Returns the `toStringTag`.
	 */
	function getTag(value) {
	  return objectToString.call(value);
	}
	
	// Fallback for IE 11 providing `toStringTag` values for maps, sets, and weakmaps.
	if ((Map && getTag(new Map) != mapTag) ||
	    (Set && getTag(new Set) != setTag) ||
	    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
	  getTag = function(value) {
	    var result = objectToString.call(value),
	        Ctor = result == objectTag ? value.constructor : null,
	        ctorString = typeof Ctor == 'function' ? funcToString.call(Ctor) : '';
	
	    if (ctorString) {
	      switch (ctorString) {
	        case mapCtorString: return mapTag;
	        case setCtorString: return setTag;
	        case weakMapCtorString: return weakMapTag;
	      }
	    }
	    return result;
	  };
	}
	
	module.e = getTag;


/***/ },
/* 120 */
/***/ function(module, exports, __webpack_require__) {

	var hashHas = __webpack_require__(42);
	
	/**
	 * Removes `key` and its value from the hash.
	 *
	 * @private
	 * @param {Object} hash The hash to modify.
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function hashDelete(hash, key) {
	  return hashHas(hash, key) && delete hash[key];
	}
	
	module.e = hashDelete;


/***/ },
/* 121 */
/***/ function(module, exports, __webpack_require__) {

	var nativeCreate = __webpack_require__(14);
	
	/** Used to stand-in for `undefined` hash values. */
	var HASH_UNDEFINED = '__lodash_hash_undefined__';
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/**
	 * Gets the hash value for `key`.
	 *
	 * @private
	 * @param {Object} hash The hash to query.
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function hashGet(hash, key) {
	  if (nativeCreate) {
	    var result = hash[key];
	    return result === HASH_UNDEFINED ? undefined : result;
	  }
	  return hasOwnProperty.call(hash, key) ? hash[key] : undefined;
	}
	
	module.e = hashGet;


/***/ },
/* 122 */
/***/ function(module, exports, __webpack_require__) {

	var nativeCreate = __webpack_require__(14);
	
	/** Used to stand-in for `undefined` hash values. */
	var HASH_UNDEFINED = '__lodash_hash_undefined__';
	
	/**
	 * Sets the hash `key` to `value`.
	 *
	 * @private
	 * @param {Object} hash The hash to modify.
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 */
	function hashSet(hash, key, value) {
	  hash[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
	}
	
	module.e = hashSet;


/***/ },
/* 123 */
/***/ function(module, exports, __webpack_require__) {

	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/**
	 * Initializes an array clone.
	 *
	 * @private
	 * @param {Array} array The array to clone.
	 * @returns {Array} Returns the initialized clone.
	 */
	function initCloneArray(array) {
	  var length = array.length,
	      result = array.constructor(length);
	
	  // Add properties assigned by `RegExp#exec`.
	  if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
	    result.index = array.index;
	    result.input = array.input;
	  }
	  return result;
	}
	
	module.e = initCloneArray;


/***/ },
/* 124 */
/***/ function(module, exports, __webpack_require__) {

	var cloneArrayBuffer = __webpack_require__(40),
	    cloneMap = __webpack_require__(108),
	    cloneRegExp = __webpack_require__(109),
	    cloneSet = __webpack_require__(110),
	    cloneSymbol = __webpack_require__(111),
	    cloneTypedArray = __webpack_require__(112);
	
	/** `Object#toString` result references. */
	var boolTag = '[object Boolean]',
	    dateTag = '[object Date]',
	    mapTag = '[object Map]',
	    numberTag = '[object Number]',
	    regexpTag = '[object RegExp]',
	    setTag = '[object Set]',
	    stringTag = '[object String]',
	    symbolTag = '[object Symbol]';
	
	var arrayBufferTag = '[object ArrayBuffer]',
	    float32Tag = '[object Float32Array]',
	    float64Tag = '[object Float64Array]',
	    int8Tag = '[object Int8Array]',
	    int16Tag = '[object Int16Array]',
	    int32Tag = '[object Int32Array]',
	    uint8Tag = '[object Uint8Array]',
	    uint8ClampedTag = '[object Uint8ClampedArray]',
	    uint16Tag = '[object Uint16Array]',
	    uint32Tag = '[object Uint32Array]';
	
	/**
	 * Initializes an object clone based on its `toStringTag`.
	 *
	 * **Note:** This function only supports cloning values with tags of
	 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
	 *
	 * @private
	 * @param {Object} object The object to clone.
	 * @param {string} tag The `toStringTag` of the object to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Object} Returns the initialized clone.
	 */
	function initCloneByTag(object, tag, isDeep) {
	  var Ctor = object.constructor;
	  switch (tag) {
	    case arrayBufferTag:
	      return cloneArrayBuffer(object);
	
	    case boolTag:
	    case dateTag:
	      return new Ctor(+object);
	
	    case float32Tag: case float64Tag:
	    case int8Tag: case int16Tag: case int32Tag:
	    case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
	      return cloneTypedArray(object, isDeep);
	
	    case mapTag:
	      return cloneMap(object);
	
	    case numberTag:
	    case stringTag:
	      return new Ctor(object);
	
	    case regexpTag:
	      return cloneRegExp(object);
	
	    case setTag:
	      return cloneSet(object);
	
	    case symbolTag:
	      return cloneSymbol(object);
	  }
	}
	
	module.e = initCloneByTag;


/***/ },
/* 125 */
/***/ function(module, exports, __webpack_require__) {

	var baseCreate = __webpack_require__(94),
	    isPrototype = __webpack_require__(24);
	
	/** Built-in value references. */
	var getPrototypeOf = Object.getPrototypeOf;
	
	/**
	 * Initializes an object clone.
	 *
	 * @private
	 * @param {Object} object The object to clone.
	 * @returns {Object} Returns the initialized clone.
	 */
	function initCloneObject(object) {
	  return (typeof object.constructor == 'function' && !isPrototype(object))
	    ? baseCreate(getPrototypeOf(object))
	    : {};
	}
	
	module.e = initCloneObject;


/***/ },
/* 126 */
/***/ function(module, exports, __webpack_require__) {

	var eq = __webpack_require__(15),
	    isArrayLike = __webpack_require__(26),
	    isIndex = __webpack_require__(23),
	    isObject = __webpack_require__(2);
	
	/**
	 * Checks if the given arguments are from an iteratee call.
	 *
	 * @private
	 * @param {*} value The potential iteratee value argument.
	 * @param {*} index The potential iteratee index or key argument.
	 * @param {*} object The potential iteratee object argument.
	 * @returns {boolean} Returns `true` if the arguments are from an iteratee call, else `false`.
	 */
	function isIterateeCall(value, index, object) {
	  if (!isObject(object)) {
	    return false;
	  }
	  var type = typeof index;
	  if (type == 'number'
	      ? (isArrayLike(object) && isIndex(index, object.length))
	      : (type == 'string' && index in object)) {
	    return eq(object[index], value);
	  }
	  return false;
	}
	
	module.e = isIterateeCall;


/***/ },
/* 127 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Converts `iterator` to an array.
	 *
	 * @private
	 * @param {Object} iterator The iterator to convert.
	 * @returns {Array} Returns the converted array.
	 */
	function iteratorToArray(iterator) {
	  var data,
	      result = [];
	
	  while (!(data = iterator.next()).done) {
	    result.push(data.value);
	  }
	  return result;
	}
	
	module.e = iteratorToArray;


/***/ },
/* 128 */
/***/ function(module, exports, __webpack_require__) {

	var Hash = __webpack_require__(81),
	    Map = __webpack_require__(4);
	
	/**
	 * Removes all key-value entries from the map.
	 *
	 * @private
	 * @name clear
	 * @memberOf MapCache
	 */
	function mapClear() {
	  this.__data__ = {
	    'hash': new Hash,
	    'map': Map ? new Map : [],
	    'string': new Hash
	  };
	}
	
	module.e = mapClear;


/***/ },
/* 129 */
/***/ function(module, exports, __webpack_require__) {

	var Map = __webpack_require__(4),
	    assocDelete = __webpack_require__(36),
	    hashDelete = __webpack_require__(120),
	    isKeyable = __webpack_require__(13);
	
	/**
	 * Removes `key` and its value from the map.
	 *
	 * @private
	 * @name delete
	 * @memberOf MapCache
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function mapDelete(key) {
	  var data = this.__data__;
	  if (isKeyable(key)) {
	    return hashDelete(typeof key == 'string' ? data.string : data.hash, key);
	  }
	  return Map ? data.map['delete'](key) : assocDelete(data.map, key);
	}
	
	module.e = mapDelete;


/***/ },
/* 130 */
/***/ function(module, exports, __webpack_require__) {

	var Map = __webpack_require__(4),
	    assocGet = __webpack_require__(37),
	    hashGet = __webpack_require__(121),
	    isKeyable = __webpack_require__(13);
	
	/**
	 * Gets the map value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf MapCache
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function mapGet(key) {
	  var data = this.__data__;
	  if (isKeyable(key)) {
	    return hashGet(typeof key == 'string' ? data.string : data.hash, key);
	  }
	  return Map ? data.map.get(key) : assocGet(data.map, key);
	}
	
	module.e = mapGet;


/***/ },
/* 131 */
/***/ function(module, exports, __webpack_require__) {

	var Map = __webpack_require__(4),
	    assocHas = __webpack_require__(38),
	    hashHas = __webpack_require__(42),
	    isKeyable = __webpack_require__(13);
	
	/**
	 * Checks if a map value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf MapCache
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function mapHas(key) {
	  var data = this.__data__;
	  if (isKeyable(key)) {
	    return hashHas(typeof key == 'string' ? data.string : data.hash, key);
	  }
	  return Map ? data.map.has(key) : assocHas(data.map, key);
	}
	
	module.e = mapHas;


/***/ },
/* 132 */
/***/ function(module, exports, __webpack_require__) {

	var Map = __webpack_require__(4),
	    assocSet = __webpack_require__(39),
	    hashSet = __webpack_require__(122),
	    isKeyable = __webpack_require__(13);
	
	/**
	 * Sets the map `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf MapCache
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the map cache object.
	 */
	function mapSet(key, value) {
	  var data = this.__data__;
	  if (isKeyable(key)) {
	    hashSet(typeof key == 'string' ? data.string : data.hash, key, value);
	  } else if (Map) {
	    data.map.set(key, value);
	  } else {
	    assocSet(data.map, key, value);
	  }
	  return this;
	}
	
	module.e = mapSet;


/***/ },
/* 133 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Converts `map` to an array.
	 *
	 * @private
	 * @param {Object} map The map to convert.
	 * @returns {Array} Returns the converted array.
	 */
	function mapToArray(map) {
	  var index = -1,
	      result = Array(map.size);
	
	  map.forEach(function(value, key) {
	    result[++index] = [key, value];
	  });
	  return result;
	}
	
	module.e = mapToArray;


/***/ },
/* 134 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Converts `set` to an array.
	 *
	 * @private
	 * @param {Object} set The set to convert.
	 * @returns {Array} Returns the converted array.
	 */
	function setToArray(set) {
	  var index = -1,
	      result = Array(set.size);
	
	  set.forEach(function(value) {
	    result[++index] = value;
	  });
	  return result;
	}
	
	module.e = setToArray;


/***/ },
/* 135 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Removes all key-value entries from the stack.
	 *
	 * @private
	 * @name clear
	 * @memberOf Stack
	 */
	function stackClear() {
	  this.__data__ = { 'array': [], 'map': null };
	}
	
	module.e = stackClear;


/***/ },
/* 136 */
/***/ function(module, exports, __webpack_require__) {

	var assocDelete = __webpack_require__(36);
	
	/**
	 * Removes `key` and its value from the stack.
	 *
	 * @private
	 * @name delete
	 * @memberOf Stack
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function stackDelete(key) {
	  var data = this.__data__,
	      array = data.array;
	
	  return array ? assocDelete(array, key) : data.map['delete'](key);
	}
	
	module.e = stackDelete;


/***/ },
/* 137 */
/***/ function(module, exports, __webpack_require__) {

	var assocGet = __webpack_require__(37);
	
	/**
	 * Gets the stack value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf Stack
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function stackGet(key) {
	  var data = this.__data__,
	      array = data.array;
	
	  return array ? assocGet(array, key) : data.map.get(key);
	}
	
	module.e = stackGet;


/***/ },
/* 138 */
/***/ function(module, exports, __webpack_require__) {

	var assocHas = __webpack_require__(38);
	
	/**
	 * Checks if a stack value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf Stack
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function stackHas(key) {
	  var data = this.__data__,
	      array = data.array;
	
	  return array ? assocHas(array, key) : data.map.has(key);
	}
	
	module.e = stackHas;


/***/ },
/* 139 */
/***/ function(module, exports, __webpack_require__) {

	var MapCache = __webpack_require__(82),
	    assocSet = __webpack_require__(39);
	
	/** Used as the size to enable large array optimizations. */
	var LARGE_ARRAY_SIZE = 200;
	
	/**
	 * Sets the stack `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf Stack
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the stack cache object.
	 */
	function stackSet(key, value) {
	  var data = this.__data__,
	      array = data.array;
	
	  if (array) {
	    if (array.length < (LARGE_ARRAY_SIZE - 1)) {
	      assocSet(array, key, value);
	    } else {
	      data.array = null;
	      data.map = new MapCache(array);
	    }
	  }
	  var map = data.map;
	  if (map) {
	    map.set(key, value);
	  }
	  return this;
	}
	
	module.e = stackSet;


/***/ },
/* 140 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Creates a function that returns `value`.
	 *
	 * @static
	 * @memberOf _
	 * @category Util
	 * @param {*} value The value to return from the new function.
	 * @returns {Function} Returns the new function.
	 * @example
	 *
	 * var object = { 'user': 'fred' };
	 * var getter = _.constant(object);
	 *
	 * getter() === object;
	 * // => true
	 */
	function constant(value) {
	  return function() {
	    return value;
	  };
	}
	
	module.e = constant;


/***/ },
/* 141 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {var constant = __webpack_require__(140),
	    root = __webpack_require__(1);
	
	/** Used to determine if values are of the language type `Object`. */
	var objectTypes = {
	  'function': true,
	  'object': true
	};
	
	/** Detect free variable `exports`. */
	var freeExports = (objectTypes[typeof exports] && exports && !exports.nodeType)
	  ? exports
	  : undefined;
	
	/** Detect free variable `module`. */
	var freeModule = (objectTypes[typeof module] && module && !module.nodeType)
	  ? module
	  : undefined;
	
	/** Detect the popular CommonJS extension `module.exports`. */
	var moduleExports = (freeModule && freeModule.exports === freeExports)
	  ? freeExports
	  : undefined;
	
	/** Built-in value references. */
	var Buffer = moduleExports ? root.Buffer : undefined;
	
	/**
	 * Checks if `value` is a buffer.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
	 * @example
	 *
	 * _.isBuffer(new Buffer(2));
	 * // => true
	 *
	 * _.isBuffer(new Uint8Array(2));
	 * // => false
	 */
	var isBuffer = !Buffer ? constant(false) : function(value) {
	  return value instanceof Buffer;
	};
	
	module.e = isBuffer;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(48)(module)))

/***/ },
/* 142 */
/***/ function(module, exports, __webpack_require__) {

	var isFunction = __webpack_require__(16),
	    isHostObject = __webpack_require__(22),
	    isObjectLike = __webpack_require__(8);
	
	/** Used to match `RegExp` [syntax characters](http://ecma-international.org/ecma-262/6.0/#sec-patterns). */
	var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
	
	/** Used to detect host constructors (Safari > 5). */
	var reIsHostCtor = /^\[object .+?Constructor\]$/;
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to resolve the decompiled source of functions. */
	var funcToString = Function.prototype.toString;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/** Used to detect if a method is native. */
	var reIsNative = RegExp('^' +
	  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
	  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
	);
	
	/**
	 * Checks if `value` is a native function.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a native function, else `false`.
	 * @example
	 *
	 * _.isNative(Array.prototype.push);
	 * // => true
	 *
	 * _.isNative(_);
	 * // => false
	 */
	function isNative(value) {
	  if (value == null) {
	    return false;
	  }
	  if (isFunction(value)) {
	    return reIsNative.test(funcToString.call(value));
	  }
	  return isObjectLike(value) &&
	    (isHostObject(value) ? reIsNative : reIsHostCtor).test(value);
	}
	
	module.e = isNative;


/***/ },
/* 143 */
/***/ function(module, exports, __webpack_require__) {

	var isHostObject = __webpack_require__(22),
	    isObjectLike = __webpack_require__(8);
	
	/** `Object#toString` result references. */
	var objectTag = '[object Object]';
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to resolve the decompiled source of functions. */
	var funcToString = Function.prototype.toString;
	
	/** Used to infer the `Object` constructor. */
	var objectCtorString = funcToString.call(Object);
	
	/**
	 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;
	
	/** Built-in value references. */
	var getPrototypeOf = Object.getPrototypeOf;
	
	/**
	 * Checks if `value` is a plain object, that is, an object created by the
	 * `Object` constructor or one with a `[[Prototype]]` of `null`.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
	 * @example
	 *
	 * function Foo() {
	 *   this.a = 1;
	 * }
	 *
	 * _.isPlainObject(new Foo);
	 * // => false
	 *
	 * _.isPlainObject([1, 2, 3]);
	 * // => false
	 *
	 * _.isPlainObject({ 'x': 0, 'y': 0 });
	 * // => true
	 *
	 * _.isPlainObject(Object.create(null));
	 * // => true
	 */
	function isPlainObject(value) {
	  if (!isObjectLike(value) ||
	      objectToString.call(value) != objectTag || isHostObject(value)) {
	    return false;
	  }
	  var proto = getPrototypeOf(value);
	  if (proto === null) {
	    return true;
	  }
	  var Ctor = proto.constructor;
	  return (typeof Ctor == 'function' &&
	    Ctor instanceof Ctor && funcToString.call(Ctor) == objectCtorString);
	}
	
	module.e = isPlainObject;


/***/ },
/* 144 */
/***/ function(module, exports, __webpack_require__) {

	var isArray = __webpack_require__(5),
	    isObjectLike = __webpack_require__(8);
	
	/** `Object#toString` result references. */
	var stringTag = '[object String]';
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/**
	 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;
	
	/**
	 * Checks if `value` is classified as a `String` primitive or object.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
	 * @example
	 *
	 * _.isString('abc');
	 * // => true
	 *
	 * _.isString(1);
	 * // => false
	 */
	function isString(value) {
	  return typeof value == 'string' ||
	    (!isArray(value) && isObjectLike(value) && objectToString.call(value) == stringTag);
	}
	
	module.e = isString;


/***/ },
/* 145 */
/***/ function(module, exports, __webpack_require__) {

	var baseFlatten = __webpack_require__(95),
	    basePick = __webpack_require__(103),
	    rest = __webpack_require__(47);
	
	/**
	 * Creates an object composed of the picked `object` properties.
	 *
	 * @static
	 * @memberOf _
	 * @category Object
	 * @param {Object} object The source object.
	 * @param {...(string|string[])} [props] The property names to pick, specified
	 *  individually or in arrays.
	 * @returns {Object} Returns the new object.
	 * @example
	 *
	 * var object = { 'a': 1, 'b': '2', 'c': 3 };
	 *
	 * _.pick(object, ['a', 'c']);
	 * // => { 'a': 1, 'c': 3 }
	 */
	var pick = rest(function(object, props) {
	  return object == null ? {} : basePick(object, baseFlatten(props, 1));
	});
	
	module.e = pick;


/***/ },
/* 146 */
/***/ function(module, exports, __webpack_require__) {

	var toNumber = __webpack_require__(147);
	
	/** Used as references for various `Number` constants. */
	var INFINITY = 1 / 0,
	    MAX_INTEGER = 1.7976931348623157e+308;
	
	/**
	 * Converts `value` to an integer.
	 *
	 * **Note:** This function is loosely based on [`ToInteger`](http://www.ecma-international.org/ecma-262/6.0/#sec-tointeger).
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to convert.
	 * @returns {number} Returns the converted integer.
	 * @example
	 *
	 * _.toInteger(3);
	 * // => 3
	 *
	 * _.toInteger(Number.MIN_VALUE);
	 * // => 0
	 *
	 * _.toInteger(Infinity);
	 * // => 1.7976931348623157e+308
	 *
	 * _.toInteger('3');
	 * // => 3
	 */
	function toInteger(value) {
	  if (!value) {
	    return value === 0 ? value : 0;
	  }
	  value = toNumber(value);
	  if (value === INFINITY || value === -INFINITY) {
	    var sign = (value < 0 ? -1 : 1);
	    return sign * MAX_INTEGER;
	  }
	  var remainder = value % 1;
	  return value === value ? (remainder ? value - remainder : value) : 0;
	}
	
	module.e = toInteger;


/***/ },
/* 147 */
/***/ function(module, exports, __webpack_require__) {

	var isFunction = __webpack_require__(16),
	    isObject = __webpack_require__(2);
	
	/** Used as references for various `Number` constants. */
	var NAN = 0 / 0;
	
	/** Used to match leading and trailing whitespace. */
	var reTrim = /^\s+|\s+$/g;
	
	/** Used to detect bad signed hexadecimal string values. */
	var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
	
	/** Used to detect binary string values. */
	var reIsBinary = /^0b[01]+$/i;
	
	/** Used to detect octal string values. */
	var reIsOctal = /^0o[0-7]+$/i;
	
	/** Built-in method references without a dependency on `root`. */
	var freeParseInt = parseInt;
	
	/**
	 * Converts `value` to a number.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to process.
	 * @returns {number} Returns the number.
	 * @example
	 *
	 * _.toNumber(3);
	 * // => 3
	 *
	 * _.toNumber(Number.MIN_VALUE);
	 * // => 5e-324
	 *
	 * _.toNumber(Infinity);
	 * // => Infinity
	 *
	 * _.toNumber('3');
	 * // => 3
	 */
	function toNumber(value) {
	  if (isObject(value)) {
	    var other = isFunction(value.valueOf) ? value.valueOf() : value;
	    value = isObject(other) ? (other + '') : other;
	  }
	  if (typeof value != 'string') {
	    return value === 0 ? value : +value;
	  }
	  value = value.replace(reTrim, '');
	  var isBinary = reIsBinary.test(value);
	  return (isBinary || reIsOctal.test(value))
	    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
	    : (reIsBadHex.test(value) ? NAN : +value);
	}
	
	module.e = toNumber;


/***/ },
/* 148 */
/***/ function(module, exports, __webpack_require__) {

	var copyObject = __webpack_require__(21),
	    keysIn = __webpack_require__(46);
	
	/**
	 * Converts `value` to a plain object flattening inherited enumerable
	 * properties of `value` to own properties of the plain object.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to convert.
	 * @returns {Object} Returns the converted plain object.
	 * @example
	 *
	 * function Foo() {
	 *   this.b = 2;
	 * }
	 *
	 * Foo.prototype.c = 3;
	 *
	 * _.assign({ 'a': 1 }, new Foo);
	 * // => { 'a': 1, 'b': 2 }
	 *
	 * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
	 * // => { 'a': 1, 'b': 2, 'c': 3 }
	 */
	function toPlainObject(value) {
	  return copyObject(value, keysIn(value));
	}
	
	module.e = toPlainObject;


/***/ },
/* 149 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	
	// Shimming starts here.
	(function() {
	  // Utils.
	  var logging = __webpack_require__(0).log;
	  var browserDetails = __webpack_require__(0).browserDetails;
	  // Export to the adapter global object visible in the browser.
	  module.e.browserDetails = browserDetails;
	  module.e.extractVersion = __webpack_require__(0).extractVersion;
	  module.e.disableLog = __webpack_require__(0).disableLog;
	
	  // Uncomment if you do not want any logging at all including the switch
	  // statement below. Can also be turned off in the browser via
	  // adapter.disableLog(true) but then logging from the switch statement below
	  // will still appear.
	  //require('./utils').disableLog(true);
	
	  // Browser shims.
	  var chromeShim = __webpack_require__(150) || null;
	  var edgeShim = __webpack_require__(153) || null;
	  var firefoxShim = __webpack_require__(154) || null;
	
	  // Shim browser if found.
	  switch (browserDetails.browser) {
	    case 'chrome':
	      if (!chromeShim || !chromeShim.shimPeerConnection) {
	        logging('Chrome shim is not included in this adapter release.');
	        return;
	      }
	      logging('adapter.js shimming chrome!');
	      // Export to the adapter global object visible in the browser.
	      module.e.browserShim = chromeShim;
	
	      chromeShim.shimGetUserMedia();
	      chromeShim.shimSourceObject();
	      chromeShim.shimPeerConnection();
	      chromeShim.shimOnTrack();
	      break;
	    case 'edge':
	      if (!edgeShim || !edgeShim.shimPeerConnection) {
	        logging('MS edge shim is not included in this adapter release.');
	        return;
	      }
	      logging('adapter.js shimming edge!');
	      // Export to the adapter global object visible in the browser.
	      module.e.browserShim = edgeShim;
	
	      edgeShim.shimPeerConnection();
	      break;
	    case 'firefox':
	      if (!firefoxShim || !firefoxShim.shimPeerConnection) {
	        logging('Firefox shim is not included in this adapter release.');
	        return;
	      }
	      logging('adapter.js shimming firefox!');
	      // Export to the adapter global object visible in the browser.
	      module.e.browserShim = firefoxShim;
	
	      firefoxShim.shimGetUserMedia();
	      firefoxShim.shimSourceObject();
	      firefoxShim.shimPeerConnection();
	      firefoxShim.shimOnTrack();
	      break;
	    default:
	      logging('Unsupported browser!');
	  }
	})();


/***/ },
/* 150 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	var logging = __webpack_require__(0).log;
	var browserDetails = __webpack_require__(0).browserDetails;
	
	var chromeShim = {
	  shimOnTrack: function() {
	    if (typeof window === 'object' && window.RTCPeerConnection && !('ontrack' in
	        window.RTCPeerConnection.prototype)) {
	      Object.defineProperty(window.RTCPeerConnection.prototype, 'ontrack', {
	        get: function() { return this._ontrack; },
	        set: function(f) {
	          var self = this;
	          if (this._ontrack) {
	            this.removeEventListener('track', this._ontrack);
	            this.removeEventListener('addstream', this._ontrackpoly);
	          }
	          this.addEventListener('track', this._ontrack = f);
	          this.addEventListener('addstream', this._ontrackpoly = function(e) {
	            // onaddstream does not fire when a track is added to an existing stream.
	            // but stream.onaddtrack is implemented so we use that
	            e.stream.addEventListener('addtrack', function(te) {
	              var event = new Event('track');
	              event.track = te.track;
	              event.receiver = {track: te.track};
	              event.streams = [e.stream];
	              self.dispatchEvent(event);
	            });
	            e.stream.getTracks().forEach(function(track) {
	              var event = new Event('track');
	              event.track = track;
	              event.receiver = {track: track};
	              event.streams = [e.stream];
	              this.dispatchEvent(event);
	            }.bind(this));
	          }.bind(this));
	        }
	      });
	    }
	  },
	
	  shimSourceObject: function() {
	    if (typeof window === 'object') {
	      if (window.HTMLMediaElement &&
	        !('srcObject' in window.HTMLMediaElement.prototype)) {
	        // Shim the srcObject property, once, when HTMLMediaElement is found.
	        Object.defineProperty(window.HTMLMediaElement.prototype, 'srcObject', {
	          get: function() {
	            return this._srcObject;
	          },
	          set: function(stream) {
	            var self = this;
	            // Use _srcObject as a private property for this shim
	            this._srcObject = stream;
	            if (this.src) {
	              URL.revokeObjectURL(this.src);
	            }
	
	            if (!stream) {
	              this.src = '';
	              return;
	            }
	            this.src = URL.createObjectURL(stream);
	            // We need to recreate the blob url when a track is added or removed.
	            // Doing it manually since we want to avoid a recursion.
	            stream.addEventListener('addtrack', function() {
	              if (self.src) {
	                URL.revokeObjectURL(self.src);
	              }
	              self.src = URL.createObjectURL(stream);
	            });
	            stream.addEventListener('removetrack', function() {
	              if (self.src) {
	                URL.revokeObjectURL(self.src);
	              }
	              self.src = URL.createObjectURL(stream);
	            });
	          }
	        });
	      }
	    }
	  },
	
	  shimPeerConnection: function() {
	    // The RTCPeerConnection object.
	    window.RTCPeerConnection = function(pcConfig, pcConstraints) {
	      // Translate iceTransportPolicy to iceTransports,
	      // see https://code.google.com/p/webrtc/issues/detail?id=4869
	      logging('PeerConnection');
	      if (pcConfig && pcConfig.iceTransportPolicy) {
	        pcConfig.iceTransports = pcConfig.iceTransportPolicy;
	      }
	
	      var pc = new webkitRTCPeerConnection(pcConfig, pcConstraints); // jscs:ignore requireCapitalizedConstructors
	      var origGetStats = pc.getStats.bind(pc);
	      pc.getStats = function(selector, successCallback, errorCallback) { // jshint ignore: line
	        var self = this;
	        var args = arguments;
	
	        // If selector is a function then we are in the old style stats so just
	        // pass back the original getStats format to avoid breaking old users.
	        if (arguments.length > 0 && typeof selector === 'function') {
	          return origGetStats(selector, successCallback);
	        }
	
	        var fixChromeStats_ = function(response) {
	          var standardReport = {};
	          var reports = response.result();
	          reports.forEach(function(report) {
	            var standardStats = {
	              id: report.id,
	              timestamp: report.timestamp,
	              type: report.type
	            };
	            report.names().forEach(function(name) {
	              standardStats[name] = report.stat(name);
	            });
	            standardReport[standardStats.id] = standardStats;
	          });
	
	          return standardReport;
	        };
	
	        if (arguments.length >= 2) {
	          var successCallbackWrapper_ = function(response) {
	            args[1](fixChromeStats_(response));
	          };
	
	          return origGetStats.apply(this, [successCallbackWrapper_, arguments[0]]);
	        }
	
	        // promise-support
	        return new Promise(function(resolve, reject) {
	          if (args.length === 1 && selector === null) {
	            origGetStats.apply(self, [
	                function(response) {
	                  resolve.apply(null, [fixChromeStats_(response)]);
	                }, reject]);
	          } else {
	            origGetStats.apply(self, [resolve, reject]);
	          }
	        });
	      };
	
	      return pc;
	    };
	    window.RTCPeerConnection.prototype = webkitRTCPeerConnection.prototype;
	
	    // wrap static methods. Currently just generateCertificate.
	    if (webkitRTCPeerConnection.generateCertificate) {
	      Object.defineProperty(window.RTCPeerConnection, 'generateCertificate', {
	        get: function() {
	          if (arguments.length) {
	            return webkitRTCPeerConnection.generateCertificate.apply(null,
	                arguments);
	          } else {
	            return webkitRTCPeerConnection.generateCertificate;
	          }
	        }
	      });
	    }
	
	    // add promise support
	    ['createOffer', 'createAnswer'].forEach(function(method) {
	      var nativeMethod = webkitRTCPeerConnection.prototype[method];
	      webkitRTCPeerConnection.prototype[method] = function() {
	        var self = this;
	        if (arguments.length < 1 || (arguments.length === 1 &&
	            typeof(arguments[0]) === 'object')) {
	          var opts = arguments.length === 1 ? arguments[0] : undefined;
	          return new Promise(function(resolve, reject) {
	            nativeMethod.apply(self, [resolve, reject, opts]);
	          });
	        } else {
	          return nativeMethod.apply(this, arguments);
	        }
	      };
	    });
	
	    ['setLocalDescription', 'setRemoteDescription',
	        'addIceCandidate'].forEach(function(method) {
	      var nativeMethod = webkitRTCPeerConnection.prototype[method];
	      webkitRTCPeerConnection.prototype[method] = function() {
	        var args = arguments;
	        var self = this;
	        return new Promise(function(resolve, reject) {
	          nativeMethod.apply(self, [args[0],
	              function() {
	                resolve();
	                if (args.length >= 2) {
	                  args[1].apply(null, []);
	                }
	              },
	              function(err) {
	                reject(err);
	                if (args.length >= 3) {
	                  args[2].apply(null, [err]);
	                }
	              }]
	            );
	        });
	      };
	    });
	  },
	
	  // Attach a media stream to an element.
	  attachMediaStream: function(element, stream) {
	    logging('DEPRECATED, attachMediaStream will soon be removed.');
	    if (browserDetails.version >= 43) {
	      element.srcObject = stream;
	    } else if (typeof element.src !== 'undefined') {
	      element.src = URL.createObjectURL(stream);
	    } else {
	      logging('Error attaching stream to element.');
	    }
	  },
	
	  reattachMediaStream: function(to, from) {
	    logging('DEPRECATED, reattachMediaStream will soon be removed.');
	    if (browserDetails.version >= 43) {
	      to.srcObject = from.srcObject;
	    } else {
	      to.src = from.src;
	    }
	  }
	}
	
	
	// Expose public methods.
	module.e = {
	  shimOnTrack: chromeShim.shimOnTrack,
	  shimSourceObject: chromeShim.shimSourceObject,
	  shimPeerConnection: chromeShim.shimPeerConnection,
	  shimGetUserMedia: __webpack_require__(151),
	  attachMediaStream: chromeShim.attachMediaStream,
	  reattachMediaStream: chromeShim.reattachMediaStream
	};


/***/ },
/* 151 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	var logging = __webpack_require__(0).log;
	
	// Expose public methods.
	module.e = function() {
	  var constraintsToChrome_ = function(c) {
	    if (typeof c !== 'object' || c.mandatory || c.optional) {
	      return c;
	    }
	    var cc = {};
	    Object.keys(c).forEach(function(key) {
	      if (key === 'require' || key === 'advanced' || key === 'mediaSource') {
	        return;
	      }
	      var r = (typeof c[key] === 'object') ? c[key] : {ideal: c[key]};
	      if (r.exact !== undefined && typeof r.exact === 'number') {
	        r.min = r.max = r.exact;
	      }
	      var oldname_ = function(prefix, name) {
	        if (prefix) {
	          return prefix + name.charAt(0).toUpperCase() + name.slice(1);
	        }
	        return (name === 'deviceId') ? 'sourceId' : name;
	      };
	      if (r.ideal !== undefined) {
	        cc.optional = cc.optional || [];
	        var oc = {};
	        if (typeof r.ideal === 'number') {
	          oc[oldname_('min', key)] = r.ideal;
	          cc.optional.push(oc);
	          oc = {};
	          oc[oldname_('max', key)] = r.ideal;
	          cc.optional.push(oc);
	        } else {
	          oc[oldname_('', key)] = r.ideal;
	          cc.optional.push(oc);
	        }
	      }
	      if (r.exact !== undefined && typeof r.exact !== 'number') {
	        cc.mandatory = cc.mandatory || {};
	        cc.mandatory[oldname_('', key)] = r.exact;
	      } else {
	        ['min', 'max'].forEach(function(mix) {
	          if (r[mix] !== undefined) {
	            cc.mandatory = cc.mandatory || {};
	            cc.mandatory[oldname_(mix, key)] = r[mix];
	          }
	        });
	      }
	    });
	    if (c.advanced) {
	      cc.optional = (cc.optional || []).concat(c.advanced);
	    }
	    return cc;
	  };
	
	  var getUserMedia_ = function(constraints, onSuccess, onError) {
	    if (constraints.audio) {
	      constraints.audio = constraintsToChrome_(constraints.audio);
	    }
	    if (constraints.video) {
	      constraints.video = constraintsToChrome_(constraints.video);
	    }
	    logging('chrome: ' + JSON.stringify(constraints));
	    return navigator.webkitGetUserMedia(constraints, onSuccess, onError);
	  };
	  navigator.getUserMedia = getUserMedia_;
	
	  // Returns the result of getUserMedia as a Promise.
	  var getUserMediaPromise_ = function(constraints) {
	    return new Promise(function(resolve, reject) {
	      navigator.getUserMedia(constraints, resolve, reject);
	    });
	  }
	
	  if (!navigator.mediaDevices) {
	    navigator.mediaDevices = {getUserMedia: getUserMediaPromise_,
	                             enumerateDevices: function() {
	      return new Promise(function(resolve) {
	        var kinds = {audio: 'audioinput', video: 'videoinput'};
	        return MediaStreamTrack.getSources(function(devices) {
	          resolve(devices.map(function(device) {
	            return {label: device.label,
	                    kind: kinds[device.kind],
	                    deviceId: device.id,
	                    groupId: ''};
	          }));
	        });
	      });
	    }};
	  }
	
	  // A shim for getUserMedia method on the mediaDevices object.
	  // TODO(KaptenJansson) remove once implemented in Chrome stable.
	  if (!navigator.mediaDevices.getUserMedia) {
	    navigator.mediaDevices.getUserMedia = function(constraints) {
	      return getUserMediaPromise_(constraints);
	    };
	  } else {
	    // Even though Chrome 45 has navigator.mediaDevices and a getUserMedia
	    // function which returns a Promise, it does not accept spec-style
	    // constraints.
	    var origGetUserMedia = navigator.mediaDevices.getUserMedia.
	        bind(navigator.mediaDevices);
	    navigator.mediaDevices.getUserMedia = function(c) {
	      if (c) {
	        logging('spec:   ' + JSON.stringify(c)); // whitespace for alignment
	        c.audio = constraintsToChrome_(c.audio);
	        c.video = constraintsToChrome_(c.video);
	        logging('chrome: ' + JSON.stringify(c));
	      }
	      return origGetUserMedia(c);
	    }.bind(this);
	  }
	
	  // Dummy devicechange event methods.
	  // TODO(KaptenJansson) remove once implemented in Chrome stable.
	  if (typeof navigator.mediaDevices.addEventListener === 'undefined') {
	    navigator.mediaDevices.addEventListener = function() {
	      logging('Dummy mediaDevices.addEventListener called.');
	    };
	  }
	  if (typeof navigator.mediaDevices.removeEventListener === 'undefined') {
	    navigator.mediaDevices.removeEventListener = function() {
	      logging('Dummy mediaDevices.removeEventListener called.');
	    };
	  }
	};


/***/ },
/* 152 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	
	// SDP helpers.
	var SDPUtils = {};
	
	// Generate an alphanumeric identifier for cname or mids.
	// TODO: use UUIDs instead? https://gist.github.com/jed/982883
	SDPUtils.generateIdentifier = function() {
	  return Math.random().toString(36).substr(2, 10);
	};
	
	// The RTCP CNAME used by all peerconnections from the same JS.
	SDPUtils.localCName = SDPUtils.generateIdentifier();
	
	
	// Splits SDP into lines, dealing with both CRLF and LF.
	SDPUtils.splitLines = function(blob) {
	  return blob.trim().split('\n').map(function(line) {
	    return line.trim();
	  });
	};
	// Splits SDP into sessionpart and mediasections. Ensures CRLF.
	SDPUtils.splitSections = function(blob) {
	  var parts = blob.split('\r\nm=');
	  return parts.map(function(part, index) {
	    return (index > 0 ? 'm=' + part : part).trim() + '\r\n';
	  });
	};
	
	// Returns lines that start with a certain prefix.
	SDPUtils.matchPrefix = function(blob, prefix) {
	  return SDPUtils.splitLines(blob).filter(function(line) {
	    return line.indexOf(prefix) === 0;
	  });
	};
	
	// Parses an ICE candidate line. Sample input:
	// candidate:702786350 2 udp 41819902 8.8.8.8 60769 typ relay raddr 8.8.8.8 rport 55996"
	SDPUtils.parseCandidate = function(line) {
	  var parts;
	  // Parse both variants.
	  if (line.indexOf('a=candidate:') === 0) {
	    parts = line.substring(12).split(' ');
	  } else {
	    parts = line.substring(10).split(' ');
	  }
	
	  var candidate = {
	    foundation: parts[0],
	    component: parts[1],
	    protocol: parts[2].toLowerCase(),
	    priority: parseInt(parts[3], 10),
	    ip: parts[4],
	    port: parseInt(parts[5], 10),
	    // skip parts[6] == 'typ'
	    type: parts[7]
	  };
	
	  for (var i = 8; i < parts.length; i += 2) {
	    switch (parts[i]) {
	      case 'raddr':
	        candidate.relatedAddress = parts[i + 1];
	        break;
	      case 'rport':
	        candidate.relatedPort = parseInt(parts[i + 1], 10);
	        break;
	      case 'tcptype':
	        candidate.tcpType = parts[i + 1];
	        break;
	      default: // Unknown extensions are silently ignored.
	        break;
	    }
	  }
	  return candidate;
	};
	
	// Translates a candidate object into SDP candidate attribute.
	SDPUtils.writeCandidate = function(candidate) {
	  var sdp = [];
	  sdp.push(candidate.foundation);
	  sdp.push(candidate.component);
	  sdp.push(candidate.protocol.toUpperCase());
	  sdp.push(candidate.priority);
	  sdp.push(candidate.ip);
	  sdp.push(candidate.port);
	
	  var type = candidate.type;
	  sdp.push('typ');
	  sdp.push(type);
	  if (type !== 'host' && candidate.relatedAddress &&
	      candidate.relatedPort) {
	    sdp.push('raddr');
	    sdp.push(candidate.relatedAddress); // was: relAddr
	    sdp.push('rport');
	    sdp.push(candidate.relatedPort); // was: relPort
	  }
	  if (candidate.tcpType && candidate.protocol.toLowerCase() === 'tcp') {
	    sdp.push('tcptype');
	    sdp.push(candidate.tcpType);
	  }
	  return 'candidate:' + sdp.join(' ');
	};
	
	// Parses an rtpmap line, returns RTCRtpCoddecParameters. Sample input:
	// a=rtpmap:111 opus/48000/2
	SDPUtils.parseRtpMap = function(line) {
	  var parts = line.substr(9).split(' ');
	  var parsed = {
	    payloadType: parseInt(parts.shift(), 10) // was: id
	  };
	
	  parts = parts[0].split('/');
	
	  parsed.name = parts[0];
	  parsed.clockRate = parseInt(parts[1], 10); // was: clockrate
	  parsed.numChannels = parts.length === 3 ? parseInt(parts[2], 10) : 1; // was: channels
	  return parsed;
	};
	
	// Generate an a=rtpmap line from RTCRtpCodecCapability or RTCRtpCodecParameters.
	SDPUtils.writeRtpMap = function(codec) {
	  var pt = codec.payloadType;
	  if (codec.preferredPayloadType !== undefined) {
	    pt = codec.preferredPayloadType;
	  }
	  return 'a=rtpmap:' + pt + ' ' + codec.name + '/' + codec.clockRate +
	      (codec.numChannels !== 1 ? '/' + codec.numChannels : '') + '\r\n';
	};
	
	// Parses an ftmp line, returns dictionary. Sample input:
	// a=fmtp:96 vbr=on;cng=on
	// Also deals with vbr=on; cng=on
	SDPUtils.parseFmtp = function(line) {
	  var parsed = {};
	  var kv;
	  var parts = line.substr(line.indexOf(' ') + 1).split(';');
	  for (var j = 0; j < parts.length; j++) {
	    kv = parts[j].trim().split('=');
	    parsed[kv[0].trim()] = kv[1];
	  }
	  return parsed;
	};
	
	// Generates an a=ftmp line from RTCRtpCodecCapability or RTCRtpCodecParameters.
	SDPUtils.writeFtmp = function(codec) {
	  var line = '';
	  var pt = codec.payloadType;
	  if (codec.preferredPayloadType !== undefined) {
	    pt = codec.preferredPayloadType;
	  }
	  if (codec.parameters && codec.parameters.length) {
	    var params = [];
	    Object.keys(codec.parameters).forEach(function(param) {
	      params.push(param + '=' + codec.parameters[param]);
	    });
	    line += 'a=fmtp:' + pt + ' ' + params.join(';') + '\r\n';
	  }
	  return line;
	};
	
	// Parses an rtcp-fb line, returns RTCPRtcpFeedback object. Sample input:
	// a=rtcp-fb:98 nack rpsi
	SDPUtils.parseRtcpFb = function(line) {
	  var parts = line.substr(line.indexOf(' ') + 1).split(' ');
	  return {
	    type: parts.shift(),
	    parameter: parts.join(' ')
	  };
	};
	// Generate a=rtcp-fb lines from RTCRtpCodecCapability or RTCRtpCodecParameters.
	SDPUtils.writeRtcpFb = function(codec) {
	  var lines = '';
	  var pt = codec.payloadType;
	  if (codec.preferredPayloadType !== undefined) {
	    pt = codec.preferredPayloadType;
	  }
	  if (codec.rtcpFeedback && codec.rtcpFeedback.length) {
	    // FIXME: special handling for trr-int?
	    codec.rtcpFeedback.forEach(function(fb) {
	      lines += 'a=rtcp-fb:' + pt + ' ' + fb.type + ' ' + fb.parameter +
	          '\r\n';
	    });
	  }
	  return lines;
	};
	
	// Parses an RFC 5576 ssrc media attribute. Sample input:
	// a=ssrc:3735928559 cname:something
	SDPUtils.parseSsrcMedia = function(line) {
	  var sp = line.indexOf(' ');
	  var parts = {
	    ssrc: line.substr(7, sp - 7),
	  };
	  var colon = line.indexOf(':', sp);
	  if (colon > -1) {
	    parts.attribute = line.substr(sp + 1, colon - sp - 1);
	    parts.value = line.substr(colon + 1);
	  } else {
	    parts.attribute = line.substr(sp + 1);
	  }
	  return parts;
	};
	
	// Extracts DTLS parameters from SDP media section or sessionpart.
	// FIXME: for consistency with other functions this should only
	//   get the fingerprint line as input. See also getIceParameters.
	SDPUtils.getDtlsParameters = function(mediaSection, sessionpart) {
	  var lines = SDPUtils.splitLines(mediaSection);
	  lines = lines.concat(SDPUtils.splitLines(sessionpart)); // Search in session part, too.
	  var fpLine = lines.filter(function(line) {
	    return line.indexOf('a=fingerprint:') === 0;
	  })[0].substr(14);
	  // Note: a=setup line is ignored since we use the 'auto' role.
	  var dtlsParameters = {
	    role: 'auto',
	    fingerprints: [{
	      algorithm: fpLine.split(' ')[0],
	      value: fpLine.split(' ')[1]
	    }]
	  };
	  return dtlsParameters;
	};
	
	// Serializes DTLS parameters to SDP.
	SDPUtils.writeDtlsParameters = function(params, setupType) {
	  var sdp = 'a=setup:' + setupType + '\r\n';
	  params.fingerprints.forEach(function(fp) {
	    sdp += 'a=fingerprint:' + fp.algorithm + ' ' + fp.value + '\r\n';
	  });
	  return sdp;
	};
	// Parses ICE information from SDP media section or sessionpart.
	// FIXME: for consistency with other functions this should only
	//   get the ice-ufrag and ice-pwd lines as input.
	SDPUtils.getIceParameters = function(mediaSection, sessionpart) {
	  var lines = SDPUtils.splitLines(mediaSection);
	  lines = lines.concat(SDPUtils.splitLines(sessionpart)); // Search in session part, too.
	  var iceParameters = {
	    usernameFragment: lines.filter(function(line) {
	      return line.indexOf('a=ice-ufrag:') === 0;
	    })[0].substr(12),
	    password: lines.filter(function(line) {
	      return line.indexOf('a=ice-pwd:') === 0;
	    })[0].substr(10)
	  };
	  return iceParameters;
	};
	
	// Serializes ICE parameters to SDP.
	SDPUtils.writeIceParameters = function(params) {
	  return 'a=ice-ufrag:' + params.usernameFragment + '\r\n' +
	      'a=ice-pwd:' + params.password + '\r\n';
	};
	
	// Parses the SDP media section and returns RTCRtpParameters.
	SDPUtils.parseRtpParameters = function(mediaSection) {
	  var description = {
	    codecs: [],
	    headerExtensions: [],
	    fecMechanisms: [],
	    rtcp: []
	  };
	  var lines = SDPUtils.splitLines(mediaSection);
	  var mline = lines[0].split(' ');
	  for (var i = 3; i < mline.length; i++) { // find all codecs from mline[3..]
	    var pt = mline[i];
	    var rtpmapline = SDPUtils.matchPrefix(
	        mediaSection, 'a=rtpmap:' + pt + ' ')[0];
	    if (rtpmapline) {
	      var codec = SDPUtils.parseRtpMap(rtpmapline);
	      var fmtps = SDPUtils.matchPrefix(
	          mediaSection, 'a=fmtp:' + pt + ' ');
	      // Only the first a=fmtp:<pt> is considered.
	      codec.parameters = fmtps.length ? SDPUtils.parseFmtp(fmtps[0]) : {};
	      codec.rtcpFeedback = SDPUtils.matchPrefix(
	          mediaSection, 'a=rtcp-fb:' + pt + ' ')
	        .map(SDPUtils.parseRtcpFb);
	      description.codecs.push(codec);
	    }
	  }
	  // FIXME: parse headerExtensions, fecMechanisms and rtcp.
	  return description;
	};
	
	// Generates parts of the SDP media section describing the capabilities / parameters.
	SDPUtils.writeRtpDescription = function(kind, caps) {
	  var sdp = '';
	
	  // Build the mline.
	  sdp += 'm=' + kind + ' ';
	  sdp += caps.codecs.length > 0 ? '9' : '0'; // reject if no codecs.
	  sdp += ' UDP/TLS/RTP/SAVPF ';
	  sdp += caps.codecs.map(function(codec) {
	    if (codec.preferredPayloadType !== undefined) {
	      return codec.preferredPayloadType;
	    }
	    return codec.payloadType;
	  }).join(' ') + '\r\n';
	
	  sdp += 'c=IN IP4 0.0.0.0\r\n';
	  sdp += 'a=rtcp:9 IN IP4 0.0.0.0\r\n';
	
	  // Add a=rtpmap lines for each codec. Also fmtp and rtcp-fb.
	  caps.codecs.forEach(function(codec) {
	    sdp += SDPUtils.writeRtpMap(codec);
	    sdp += SDPUtils.writeFtmp(codec);
	    sdp += SDPUtils.writeRtcpFb(codec);
	  });
	  // FIXME: add headerExtensions, fecMechanismş and rtcp.
	  sdp += 'a=rtcp-mux\r\n';
	  return sdp;
	};
	
	SDPUtils.writeSessionBoilerplate = function() {
	  // FIXME: sess-id should be an NTP timestamp.
	  return 'v=0\r\n' +
	      'o=thisisadapterortc 8169639915646943137 2 IN IP4 127.0.0.1\r\n' +
	      's=-\r\n' +
	      't=0 0\r\n';
	};
	
	SDPUtils.writeMediaSection = function(transceiver, caps, type, stream) {
	  var sdp = SDPUtils.writeRtpDescription(transceiver.kind, caps);
	
	  // Map ICE parameters (ufrag, pwd) to SDP.
	  sdp += SDPUtils.writeIceParameters(
	      transceiver.iceGatherer.getLocalParameters());
	
	  // Map DTLS parameters to SDP.
	  sdp += SDPUtils.writeDtlsParameters(
	      transceiver.dtlsTransport.getLocalParameters(),
	      type === 'offer' ? 'actpass' : 'active');
	
	  sdp += 'a=mid:' + transceiver.mid + '\r\n';
	
	  if (transceiver.rtpSender && transceiver.rtpReceiver) {
	    sdp += 'a=sendrecv\r\n';
	  } else if (transceiver.rtpSender) {
	    sdp += 'a=sendonly\r\n';
	  } else if (transceiver.rtpReceiver) {
	    sdp += 'a=recvonly\r\n';
	  } else {
	    sdp += 'a=inactive\r\n';
	  }
	
	  // FIXME: for RTX there might be multiple SSRCs. Not implemented in Edge yet.
	  if (transceiver.rtpSender) {
	    var msid = 'msid:' + stream.id + ' ' +
	        transceiver.rtpSender.track.id + '\r\n';
	    sdp += 'a=' + msid;
	    sdp += 'a=ssrc:' + transceiver.sendSsrc + ' ' + msid;
	  }
	  // FIXME: this should be written by writeRtpDescription.
	  sdp += 'a=ssrc:' + transceiver.sendSsrc + ' cname:' +
	      SDPUtils.localCName + '\r\n';
	  return sdp;
	};
	
	// Gets the direction from the mediaSection or the sessionpart.
	SDPUtils.getDirection = function(mediaSection, sessionpart) {
	  // Look for sendrecv, sendonly, recvonly, inactive, default to sendrecv.
	  var lines = SDPUtils.splitLines(mediaSection);
	  for (var i = 0; i < lines.length; i++) {
	    switch (lines[i]) {
	      case 'a=sendrecv':
	      case 'a=sendonly':
	      case 'a=recvonly':
	      case 'a=inactive':
	        return lines[i].substr(2);
	    }
	  }
	  if (sessionpart) {
	    return SDPUtils.getDirection(sessionpart);
	  }
	  return 'sendrecv';
	};
	
	// Expose public methods.
	module.e = SDPUtils;


/***/ },
/* 153 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	
	var SDPUtils = __webpack_require__(152);
	var logging = __webpack_require__(0).log;
	var browserDetails = __webpack_require__(0).browserDetails;
	
	var edgeShim = {
	  shimPeerConnection: function() {
	    if (window.RTCIceGatherer) {
	      // ORTC defines an RTCIceCandidate object but no constructor.
	      // Not implemented in Edge.
	      if (!window.RTCIceCandidate) {
	        window.RTCIceCandidate = function(args) {
	          return args;
	        };
	      }
	      // ORTC does not have a session description object but
	      // other browsers (i.e. Chrome) that will support both PC and ORTC
	      // in the future might have this defined already.
	      if (!window.RTCSessionDescription) {
	        window.RTCSessionDescription = function(args) {
	          return args;
	        };
	      }
	    }
	
	    window.RTCPeerConnection = function(config) {
	      var self = this;
	
	      var _eventTarget = document.createDocumentFragment();
	      ['addEventListener', 'removeEventListener', 'dispatchEvent'].forEach(
	          function(method) {
	        self[method] = _eventTarget[method].bind(_eventTarget);
	      });
	
	      this.onicecandidate = null;
	      this.onaddstream = null;
	      this.ontrack = null;
	      this.onremovestream = null;
	      this.onsignalingstatechange = null;
	      this.oniceconnectionstatechange = null;
	      this.onnegotiationneeded = null;
	      this.ondatachannel = null;
	
	      this.localStreams = [];
	      this.remoteStreams = [];
	      this.getLocalStreams = function() { return self.localStreams; };
	      this.getRemoteStreams = function() { return self.remoteStreams; };
	
	      this.localDescription = new RTCSessionDescription({
	        type: '',
	        sdp: ''
	      });
	      this.remoteDescription = new RTCSessionDescription({
	        type: '',
	        sdp: ''
	      });
	      this.signalingState = 'stable';
	      this.iceConnectionState = 'new';
	      this.iceGatheringState = 'new';
	
	      this.iceOptions = {
	        gatherPolicy: 'all',
	        iceServers: []
	      };
	      if (config && config.iceTransportPolicy) {
	        switch (config.iceTransportPolicy) {
	          case 'all':
	          case 'relay':
	            this.iceOptions.gatherPolicy = config.iceTransportPolicy;
	            break;
	          case 'none':
	            // FIXME: remove once implementation and spec have added this.
	            throw new TypeError('iceTransportPolicy "none" not supported');
	        }
	      }
	      if (config && config.iceServers) {
	        // Edge does not like
	        // 1) stun:
	        // 2) turn: that does not have all of turn:host:port?transport=udp
	        this.iceOptions.iceServers = config.iceServers.filter(function(server) {
	          if (server && server.urls) {
	            server.urls = server.urls.filter(function(url) {
	              return url.indexOf('transport=udp') !== -1;
	            })[0];
	            return true;
	          }
	          return false;
	        });
	      }
	
	      // per-track iceGathers, iceTransports, dtlsTransports, rtpSenders, ...
	      // everything that is needed to describe a SDP m-line.
	      this.transceivers = [];
	
	      // since the iceGatherer is currently created in createOffer but we
	      // must not emit candidates until after setLocalDescription we buffer
	      // them in this array.
	      this._localIceCandidatesBuffer = [];
	    };
	
	    window.RTCPeerConnection.prototype._emitBufferedCandidates = function() {
	      var self = this;
	      var sections = SDPUtils.splitSections(self.localDescription.sdp);
	      // FIXME: need to apply ice candidates in a way which is async but in-order
	      this._localIceCandidatesBuffer.forEach(function(event) {
	        var end = !event.candidate || Object.keys(event.candidate).length == 0;
	        if (end) {
	          for (var j = 1; j < sections.length; j++) {
	            sections[j] += 'a=end-of-candidates\r\n';
	          }
	        } else {
	          sections[event.candidate.sdpMLineIndex + 1] +=
	              'a=' + event.candidate.candidate + '\r\n';
	        }
	        self.dispatchEvent(event);
	        if (self.onicecandidate !== null) {
	          self.onicecandidate(event);
	        }
	        if (!event.candidate) {
	          self.iceGatheringState = 'complete';
	        }
	      });
	      this._localIceCandidatesBuffer = [];
	      this.localDescription.sdp = sections.join('');
	    };
	
	    window.RTCPeerConnection.prototype.addStream = function(stream) {
	      // Clone is necessary for local demos mostly, attaching directly
	      // to two different senders does not work (build 10547).
	      this.localStreams.push(stream.clone());
	      this._maybeFireNegotiationNeeded();
	    };
	
	    window.RTCPeerConnection.prototype.removeStream = function(stream) {
	      var idx = this.localStreams.indexOf(stream);
	      if (idx > -1) {
	        this.localStreams.splice(idx, 1);
	        this._maybeFireNegotiationNeeded();
	      }
	    };
	
	    // Determines the intersection of local and remote capabilities.
	    window.RTCPeerConnection.prototype._getCommonCapabilities =
	        function(localCapabilities, remoteCapabilities) {
	      var commonCapabilities = {
	        codecs: [],
	        headerExtensions: [],
	        fecMechanisms: []
	      };
	      localCapabilities.codecs.forEach(function(lCodec) {
	        for (var i = 0; i < remoteCapabilities.codecs.length; i++) {
	          var rCodec = remoteCapabilities.codecs[i];
	          if (lCodec.name.toLowerCase() === rCodec.name.toLowerCase() &&
	              lCodec.clockRate === rCodec.clockRate &&
	              lCodec.numChannels === rCodec.numChannels) {
	            // push rCodec so we reply with offerer payload type
	            commonCapabilities.codecs.push(rCodec);
	
	            // FIXME: also need to determine intersection between
	            // .rtcpFeedback and .parameters
	            break;
	          }
	        }
	      });
	
	      localCapabilities.headerExtensions.forEach(function(lHeaderExtension) {
	        for (var i = 0; i < remoteCapabilities.headerExtensions.length; i++) {
	          var rHeaderExtension = remoteCapabilities.headerExtensions[i];
	          if (lHeaderExtension.uri === rHeaderExtension.uri) {
	            commonCapabilities.headerExtensions.push(rHeaderExtension);
	            break;
	          }
	        }
	      });
	
	      // FIXME: fecMechanisms
	      return commonCapabilities;
	    };
	
	    // Create ICE gatherer, ICE transport and DTLS transport.
	    window.RTCPeerConnection.prototype._createIceAndDtlsTransports =
	        function(mid, sdpMLineIndex) {
	      var self = this;
	      var iceGatherer = new RTCIceGatherer(self.iceOptions);
	      var iceTransport = new RTCIceTransport(iceGatherer);
	      iceGatherer.onlocalcandidate = function(evt) {
	        var event = new Event('icecandidate');
	        event.candidate = {sdpMid: mid, sdpMLineIndex: sdpMLineIndex};
	
	        var cand = evt.candidate;
	        var end = !cand || Object.keys(cand).length === 0;
	        // Edge emits an empty object for RTCIceCandidateComplete‥
	        if (end) {
	          // polyfill since RTCIceGatherer.state is not implemented in Edge 10547 yet.
	          if (iceGatherer.state === undefined) {
	            iceGatherer.state = 'completed';
	          }
	
	          // Emit a candidate with type endOfCandidates to make the samples work.
	          // Edge requires addIceCandidate with this empty candidate to start checking.
	          // The real solution is to signal end-of-candidates to the other side when
	          // getting the null candidate but some apps (like the samples) don't do that.
	          event.candidate.candidate =
	              'candidate:1 1 udp 1 0.0.0.0 9 typ endOfCandidates';
	        } else {
	          // RTCIceCandidate doesn't have a component, needs to be added
	          cand.component = iceTransport.component === 'RTCP' ? 2 : 1;
	          event.candidate.candidate = SDPUtils.writeCandidate(cand);
	        }
	
	        var complete = self.transceivers.every(function(transceiver) {
	          return transceiver.iceGatherer &&
	              transceiver.iceGatherer.state === 'completed';
	        });
	        // update .localDescription with candidate and (potentially) end-of-candidates.
	        //     To make this harder, the gatherer might emit candidates before localdescription
	        //     is set. To make things worse, gather.getLocalCandidates still errors in
	        //     Edge 10547 when no candidates have been gathered yet.
	        if (self.localDescription && self.localDescription.type !== '') {
	          var sections = SDPUtils.splitSections(self.localDescription.sdp);
	          sections[sdpMLineIndex + 1] += (!end ? 'a=' + event.candidate.candidate :
	              'a=end-of-candidates') + '\r\n';
	          self.localDescription.sdp = sections.join('');
	        }
	
	        // Emit candidate if localDescription is set.
	        // Also emits null candidate when all gatherers are complete.
	        switch(self.iceGatheringState) {
	        case 'new':
	          self._localIceCandidatesBuffer.push(event);
	          if (complete) {
	            self._localIceCandidatesBuffer.push(new Event('icecandidate'));
	          }
	          break;
	        case 'gathering':
	          self._emitBufferedCandidates();
	          self.dispatchEvent(event);
	          if (self.onicecandidate !== null) {
	            self.onicecandidate(event);
	          }
	          if (complete) {
	            self.dispatchEvent(new Event('icecandidate'));
	            if (self.onicecandidate !== null) {
	              self.onicecandidate(new Event('icecandidate'));
	            }
	            self.iceGatheringState = 'complete';
	          }
	          break;
	        case 'complete':
	          // should not happen... currently!
	          break;
	        }
	      };
	      iceTransport.onicestatechange = function() {
	        self._updateConnectionState();
	      };
	
	      var dtlsTransport = new RTCDtlsTransport(iceTransport);
	      dtlsTransport.ondtlsstatechange = function() {
	        self._updateConnectionState();
	      };
	      dtlsTransport.onerror = function() {
	        // onerror does not set state to failed by itself.
	        dtlsTransport.state = 'failed';
	        self._updateConnectionState();
	      };
	
	      return {
	        iceGatherer: iceGatherer,
	        iceTransport: iceTransport,
	        dtlsTransport: dtlsTransport
	      };
	    };
	
	    // Start the RTP Sender and Receiver for a transceiver.
	    window.RTCPeerConnection.prototype._transceive = function(transceiver,
	        send, recv) {
	      var params = this._getCommonCapabilities(transceiver.localCapabilities,
	          transceiver.remoteCapabilities);
	      if (send && transceiver.rtpSender) {
	        params.encodings = [{
	          ssrc: transceiver.sendSsrc
	        }];
	        params.rtcp = {
	          cname: SDPUtils.localCName,
	          ssrc: transceiver.recvSsrc
	        };
	        transceiver.rtpSender.send(params);
	      }
	      if (recv && transceiver.rtpReceiver) {
	        params.encodings = [{
	          ssrc: transceiver.recvSsrc
	        }];
	        params.rtcp = {
	          cname: transceiver.cname,
	          ssrc: transceiver.sendSsrc
	        };
	        transceiver.rtpReceiver.receive(params);
	      }
	    };
	
	    window.RTCPeerConnection.prototype.setLocalDescription =
	        function(description) {
	      var self = this;
	      if (description.type === 'offer') {
	        if (!this._pendingOffer) {
	        } else {
	          this.transceivers = this._pendingOffer;
	          delete this._pendingOffer;
	        }
	      } else if (description.type === 'answer') {
	        var sections = SDPUtils.splitSections(self.remoteDescription.sdp);
	        var sessionpart = sections.shift();
	        sections.forEach(function(mediaSection, sdpMLineIndex) {
	          var transceiver = self.transceivers[sdpMLineIndex];
	          var iceGatherer = transceiver.iceGatherer;
	          var iceTransport = transceiver.iceTransport;
	          var dtlsTransport = transceiver.dtlsTransport;
	          var localCapabilities = transceiver.localCapabilities;
	          var remoteCapabilities = transceiver.remoteCapabilities;
	          var rejected = mediaSection.split('\n', 1)[0]
	              .split(' ', 2)[1] === '0';
	
	          if (!rejected) {
	            var remoteIceParameters = SDPUtils.getIceParameters(mediaSection,
	                sessionpart);
	            iceTransport.start(iceGatherer, remoteIceParameters, 'controlled');
	
	            var remoteDtlsParameters = SDPUtils.getDtlsParameters(mediaSection,
	              sessionpart);
	            dtlsTransport.start(remoteDtlsParameters);
	
	            // Calculate intersection of capabilities.
	            var params = self._getCommonCapabilities(localCapabilities,
	                remoteCapabilities);
	
	            // Start the RTCRtpSender. The RTCRtpReceiver for this transceiver
	            // has already been started in setRemoteDescription.
	            self._transceive(transceiver,
	                params.codecs.length > 0,
	                false);
	          }
	        });
	      }
	
	      this.localDescription = {
	        type: description.type,
	        sdp: description.sdp
	      };
	      switch (description.type) {
	        case 'offer':
	          this._updateSignalingState('have-local-offer');
	          break;
	        case 'answer':
	          this._updateSignalingState('stable');
	          break;
	        default:
	          throw new TypeError('unsupported type "' + description.type + '"');
	      }
	
	      // If a success callback was provided, emit ICE candidates after it has been
	      // executed. Otherwise, emit callback after the Promise is resolved.
	      var hasCallback = arguments.length > 1 &&
	        typeof arguments[1] === 'function';
	      if (hasCallback) {
	        var cb = arguments[1];
	        window.setTimeout(function() {
	          cb();
	          if (self.iceGatheringState === 'new') {
	            self.iceGatheringState = 'gathering';
	          }
	          self._emitBufferedCandidates();
	        }, 0);
	      }
	      var p = Promise.resolve();
	      p.then(function() {
	        if (!hasCallback) {
	          if (self.iceGatheringState === 'new') {
	            self.iceGatheringState = 'gathering';
	          }
	          // Usually candidates will be emitted earlier.
	          window.setTimeout(self._emitBufferedCandidates.bind(self), 500);
	        }
	      });
	      return p;
	    };
	
	    window.RTCPeerConnection.prototype.setRemoteDescription =
	        function(description) {
	      var self = this;
	      var stream = new MediaStream();
	      var receiverList = [];
	      var sections = SDPUtils.splitSections(description.sdp);
	      var sessionpart = sections.shift();
	      sections.forEach(function(mediaSection, sdpMLineIndex) {
	        var lines = SDPUtils.splitLines(mediaSection);
	        var mline = lines[0].substr(2).split(' ');
	        var kind = mline[0];
	        var rejected = mline[1] === '0';
	        var direction = SDPUtils.getDirection(mediaSection, sessionpart);
	
	        var transceiver;
	        var iceGatherer;
	        var iceTransport;
	        var dtlsTransport;
	        var rtpSender;
	        var rtpReceiver;
	        var sendSsrc;
	        var recvSsrc;
	        var localCapabilities;
	
	        var track;
	        // FIXME: ensure the mediaSection has rtcp-mux set.
	        var remoteCapabilities = SDPUtils.parseRtpParameters(mediaSection);
	        var remoteIceParameters;
	        var remoteDtlsParameters;
	        if (!rejected) {
	          remoteIceParameters = SDPUtils.getIceParameters(mediaSection,
	              sessionpart);
	          remoteDtlsParameters = SDPUtils.getDtlsParameters(mediaSection,
	              sessionpart);
	        }
	        var mid = SDPUtils.matchPrefix(mediaSection, 'a=mid:')[0].substr(6);
	
	        var cname;
	        // Gets the first SSRC. Note that with RTX there might be multiple SSRCs.
	        var remoteSsrc = SDPUtils.matchPrefix(mediaSection, 'a=ssrc:')
	            .map(function(line) {
	              return SDPUtils.parseSsrcMedia(line);
	            })
	            .filter(function(obj) {
	              return obj.attribute === 'cname';
	            })[0];
	        if (remoteSsrc) {
	          recvSsrc = parseInt(remoteSsrc.ssrc, 10);
	          cname = remoteSsrc.value;
	        }
	
	        if (description.type === 'offer') {
	          var transports = self._createIceAndDtlsTransports(mid, sdpMLineIndex);
	
	          localCapabilities = RTCRtpReceiver.getCapabilities(kind);
	          sendSsrc = (2 * sdpMLineIndex + 2) * 1001;
	
	          rtpReceiver = new RTCRtpReceiver(transports.dtlsTransport, kind);
	
	          track = rtpReceiver.track;
	          receiverList.push([track, rtpReceiver]);
	          // FIXME: not correct when there are multiple streams but that is
	          // not currently supported in this shim.
	          stream.addTrack(track);
	
	          // FIXME: look at direction.
	          if (self.localStreams.length > 0 &&
	              self.localStreams[0].getTracks().length >= sdpMLineIndex) {
	            // FIXME: actually more complicated, needs to match types etc
	            var localtrack = self.localStreams[0].getTracks()[sdpMLineIndex];
	            rtpSender = new RTCRtpSender(localtrack, transports.dtlsTransport);
	          }
	
	          self.transceivers[sdpMLineIndex] = {
	            iceGatherer: transports.iceGatherer,
	            iceTransport: transports.iceTransport,
	            dtlsTransport: transports.dtlsTransport,
	            localCapabilities: localCapabilities,
	            remoteCapabilities: remoteCapabilities,
	            rtpSender: rtpSender,
	            rtpReceiver: rtpReceiver,
	            kind: kind,
	            mid: mid,
	            cname: cname,
	            sendSsrc: sendSsrc,
	            recvSsrc: recvSsrc
	          };
	          // Start the RTCRtpReceiver now. The RTPSender is started in setLocalDescription.
	          self._transceive(self.transceivers[sdpMLineIndex],
	              false,
	              direction === 'sendrecv' || direction === 'sendonly');
	        } else if (description.type === 'answer' && !rejected) {
	          transceiver = self.transceivers[sdpMLineIndex];
	          iceGatherer = transceiver.iceGatherer;
	          iceTransport = transceiver.iceTransport;
	          dtlsTransport = transceiver.dtlsTransport;
	          rtpSender = transceiver.rtpSender;
	          rtpReceiver = transceiver.rtpReceiver;
	          sendSsrc = transceiver.sendSsrc;
	          //recvSsrc = transceiver.recvSsrc;
	          localCapabilities = transceiver.localCapabilities;
	
	          self.transceivers[sdpMLineIndex].recvSsrc = recvSsrc;
	          self.transceivers[sdpMLineIndex].remoteCapabilities =
	              remoteCapabilities;
	          self.transceivers[sdpMLineIndex].cname = cname;
	
	          iceTransport.start(iceGatherer, remoteIceParameters, 'controlling');
	          dtlsTransport.start(remoteDtlsParameters);
	
	          self._transceive(transceiver,
	              direction === 'sendrecv' || direction === 'recvonly',
	              direction === 'sendrecv' || direction === 'sendonly');
	
	          if (rtpReceiver &&
	              (direction === 'sendrecv' || direction === 'sendonly')) {
	            track = rtpReceiver.track;
	            receiverList.push([track, rtpReceiver]);
	            stream.addTrack(track);
	          } else {
	            // FIXME: actually the receiver should be created later.
	            delete transceiver.rtpReceiver;
	          }
	        }
	      });
	
	      this.remoteDescription = {
	          type: description.type,
	          sdp: description.sdp
	      };
	      switch (description.type) {
	        case 'offer':
	          this._updateSignalingState('have-remote-offer');
	          break;
	        case 'answer':
	          this._updateSignalingState('stable');
	          break;
	        default:
	          throw new TypeError('unsupported type "' + description.type + '"');
	      }
	      if (stream.getTracks().length) {
	        self.remoteStreams.push(stream);
	        window.setTimeout(function() {
	          var event = new Event('addstream');
	          event.stream = stream;
	          self.dispatchEvent(event);
	          if (self.onaddstream !== null) {
	            window.setTimeout(function() {
	              self.onaddstream(event);
	            }, 0);
	          }
	
	          receiverList.forEach(function(item) {
	            var track = item[0];
	            var receiver = item[1];
	            var event = new Event('track');
	            event.track = track;
	            event.receiver = receiver;
	            event.streams = [stream];
	            self.dispatchEvent(event);
	            if (self.ontrack !== null) {
	                window.setTimeout(function() {
	                  self.ontrack(event);
	                }, 0);
	            }
	          });
	        }, 0);
	      }
	      if (arguments.length > 1 && typeof arguments[1] === 'function') {
	        window.setTimeout(arguments[1], 0);
	      }
	      return Promise.resolve();
	    };
	
	    window.RTCPeerConnection.prototype.close = function() {
	      this.transceivers.forEach(function(transceiver) {
	        /* not yet
	        if (transceiver.iceGatherer) {
	          transceiver.iceGatherer.close();
	        }
	        */
	        if (transceiver.iceTransport) {
	          transceiver.iceTransport.stop();
	        }
	        if (transceiver.dtlsTransport) {
	          transceiver.dtlsTransport.stop();
	        }
	        if (transceiver.rtpSender) {
	          transceiver.rtpSender.stop();
	        }
	        if (transceiver.rtpReceiver) {
	          transceiver.rtpReceiver.stop();
	        }
	      });
	      // FIXME: clean up tracks, local streams, remote streams, etc
	      this._updateSignalingState('closed');
	    };
	
	    // Update the signaling state.
	    window.RTCPeerConnection.prototype._updateSignalingState =
	        function(newState) {
	      this.signalingState = newState;
	      var event = new Event('signalingstatechange');
	      this.dispatchEvent(event);
	      if (this.onsignalingstatechange !== null) {
	        this.onsignalingstatechange(event);
	      }
	    };
	
	    // Determine whether to fire the negotiationneeded event.
	    window.RTCPeerConnection.prototype._maybeFireNegotiationNeeded =
	        function() {
	      // Fire away (for now).
	      var event = new Event('negotiationneeded');
	      this.dispatchEvent(event);
	      if (this.onnegotiationneeded !== null) {
	        this.onnegotiationneeded(event);
	      }
	    };
	
	    // Update the connection state.
	    window.RTCPeerConnection.prototype._updateConnectionState =
	        function() {
	      var self = this;
	      var newState;
	      var states = {
	        'new': 0,
	        closed: 0,
	        connecting: 0,
	        checking: 0,
	        connected: 0,
	        completed: 0,
	        failed: 0
	      };
	      this.transceivers.forEach(function(transceiver) {
	        states[transceiver.iceTransport.state]++;
	        states[transceiver.dtlsTransport.state]++;
	      });
	      // ICETransport.completed and connected are the same for this purpose.
	      states['connected'] += states['completed'];
	
	      newState = 'new';
	      if (states['failed'] > 0) {
	        newState = 'failed';
	      } else if (states['connecting'] > 0 || states['checking'] > 0) {
	        newState = 'connecting';
	      } else if (states['disconnected'] > 0) {
	        newState = 'disconnected';
	      } else if (states['new'] > 0) {
	        newState = 'new';
	      } else if (states['connecting'] > 0 || states['completed'] > 0) {
	        newState = 'connected';
	      }
	
	      if (newState !== self.iceConnectionState) {
	        self.iceConnectionState = newState;
	        var event = new Event('iceconnectionstatechange');
	        this.dispatchEvent(event);
	        if (this.oniceconnectionstatechange !== null) {
	          this.oniceconnectionstatechange(event);
	        }
	      }
	    };
	
	    window.RTCPeerConnection.prototype.createOffer = function() {
	      var self = this;
	      if (this._pendingOffer) {
	        throw new Error('createOffer called while there is a pending offer.');
	      }
	      var offerOptions;
	      if (arguments.length === 1 && typeof arguments[0] !== 'function') {
	        offerOptions = arguments[0];
	      } else if (arguments.length === 3) {
	        offerOptions = arguments[2];
	      }
	
	      var tracks = [];
	      var numAudioTracks = 0;
	      var numVideoTracks = 0;
	      // Default to sendrecv.
	      if (this.localStreams.length) {
	        numAudioTracks = this.localStreams[0].getAudioTracks().length;
	        numVideoTracks = this.localStreams[0].getVideoTracks().length;
	      }
	      // Determine number of audio and video tracks we need to send/recv.
	      if (offerOptions) {
	        // Reject Chrome legacy constraints.
	        if (offerOptions.mandatory || offerOptions.optional) {
	          throw new TypeError(
	              'Legacy mandatory/optional constraints not supported.');
	        }
	        if (offerOptions.offerToReceiveAudio !== undefined) {
	          numAudioTracks = offerOptions.offerToReceiveAudio;
	        }
	        if (offerOptions.offerToReceiveVideo !== undefined) {
	          numVideoTracks = offerOptions.offerToReceiveVideo;
	        }
	      }
	      if (this.localStreams.length) {
	        // Push local streams.
	        this.localStreams[0].getTracks().forEach(function(track) {
	          tracks.push({
	            kind: track.kind,
	            track: track,
	            wantReceive: track.kind === 'audio' ?
	                numAudioTracks > 0 : numVideoTracks > 0
	          });
	          if (track.kind === 'audio') {
	            numAudioTracks--;
	          } else if (track.kind === 'video') {
	            numVideoTracks--;
	          }
	        });
	      }
	      // Create M-lines for recvonly streams.
	      while (numAudioTracks > 0 || numVideoTracks > 0) {
	        if (numAudioTracks > 0) {
	          tracks.push({
	            kind: 'audio',
	            wantReceive: true
	          });
	          numAudioTracks--;
	        }
	        if (numVideoTracks > 0) {
	          tracks.push({
	            kind: 'video',
	            wantReceive: true
	          });
	          numVideoTracks--;
	        }
	      }
	
	      var sdp = SDPUtils.writeSessionBoilerplate();
	      var transceivers = [];
	      tracks.forEach(function(mline, sdpMLineIndex) {
	        // For each track, create an ice gatherer, ice transport, dtls transport,
	        // potentially rtpsender and rtpreceiver.
	        var track = mline.track;
	        var kind = mline.kind;
	        var mid = SDPUtils.generateIdentifier();
	
	        var transports = self._createIceAndDtlsTransports(mid, sdpMLineIndex);
	
	        var localCapabilities = RTCRtpSender.getCapabilities(kind);
	        var rtpSender;
	        var rtpReceiver;
	
	        // generate an ssrc now, to be used later in rtpSender.send
	        var sendSsrc = (2 * sdpMLineIndex + 1) * 1001;
	        if (track) {
	          rtpSender = new RTCRtpSender(track, transports.dtlsTransport);
	        }
	
	        if (mline.wantReceive) {
	          rtpReceiver = new RTCRtpReceiver(transports.dtlsTransport, kind);
	        }
	
	        transceivers[sdpMLineIndex] = {
	          iceGatherer: transports.iceGatherer,
	          iceTransport: transports.iceTransport,
	          dtlsTransport: transports.dtlsTransport,
	          localCapabilities: localCapabilities,
	          remoteCapabilities: null,
	          rtpSender: rtpSender,
	          rtpReceiver: rtpReceiver,
	          kind: kind,
	          mid: mid,
	          sendSsrc: sendSsrc,
	          recvSsrc: null
	        };
	        var transceiver = transceivers[sdpMLineIndex];
	        sdp += SDPUtils.writeMediaSection(transceiver,
	            transceiver.localCapabilities, 'offer', self.localStreams[0]);
	      });
	
	      this._pendingOffer = transceivers;
	      var desc = new RTCSessionDescription({
	        type: 'offer',
	        sdp: sdp
	      });
	      if (arguments.length && typeof arguments[0] === 'function') {
	        window.setTimeout(arguments[0], 0, desc);
	      }
	      return Promise.resolve(desc);
	    };
	
	    window.RTCPeerConnection.prototype.createAnswer = function() {
	      var self = this;
	      var answerOptions;
	      if (arguments.length === 1 && typeof arguments[0] !== 'function') {
	        answerOptions = arguments[0];
	      } else if (arguments.length === 3) {
	        answerOptions = arguments[2];
	      }
	
	      var sdp = SDPUtils.writeSessionBoilerplate();
	      this.transceivers.forEach(function(transceiver) {
	        // Calculate intersection of capabilities.
	        var commonCapabilities = self._getCommonCapabilities(
	            transceiver.localCapabilities,
	            transceiver.remoteCapabilities);
	
	        sdp += SDPUtils.writeMediaSection(transceiver, commonCapabilities,
	            'answer', self.localStreams[0]);
	      });
	
	      var desc = new RTCSessionDescription({
	        type: 'answer',
	        sdp: sdp
	      });
	      if (arguments.length && typeof arguments[0] === 'function') {
	        window.setTimeout(arguments[0], 0, desc);
	      }
	      return Promise.resolve(desc);
	    };
	
	    window.RTCPeerConnection.prototype.addIceCandidate = function(candidate) {
	      var mLineIndex = candidate.sdpMLineIndex;
	      if (candidate.sdpMid) {
	        for (var i = 0; i < this.transceivers.length; i++) {
	          if (this.transceivers[i].mid === candidate.sdpMid) {
	            mLineIndex = i;
	            break;
	          }
	        }
	      }
	      var transceiver = this.transceivers[mLineIndex];
	      if (transceiver) {
	        var cand = Object.keys(candidate.candidate).length > 0 ?
	            SDPUtils.parseCandidate(candidate.candidate) : {};
	        // Ignore Chrome's invalid candidates since Edge does not like them.
	        if (cand.protocol === 'tcp' && cand.port === 0) {
	          return;
	        }
	        // Ignore RTCP candidates, we assume RTCP-MUX.
	        if (cand.component !== '1') {
	          return;
	        }
	        // A dirty hack to make samples work.
	        if (cand.type === 'endOfCandidates') {
	          cand = {};
	        }
	        transceiver.iceTransport.addRemoteCandidate(cand);
	
	        // update the remoteDescription.
	        var sections = SDPUtils.splitSections(this.remoteDescription.sdp);
	        sections[mLineIndex + 1] += (cand.type ? candidate.candidate.trim()
	            : 'a=end-of-candidates') + '\r\n';
	        this.remoteDescription.sdp = sections.join('');
	      }
	      if (arguments.length > 1 && typeof arguments[1] === 'function') {
	        window.setTimeout(arguments[1], 0);
	      }
	      return Promise.resolve();
	    };
	
	    window.RTCPeerConnection.prototype.getStats = function() {
	      var promises = [];
	      this.transceivers.forEach(function(transceiver) {
	        ['rtpSender', 'rtpReceiver', 'iceGatherer', 'iceTransport',
	            'dtlsTransport'].forEach(function(method) {
	          if (transceiver[method]) {
	            promises.push(transceiver[method].getStats());
	          }
	        });
	      });
	      var cb = arguments.length > 1 && typeof arguments[1] === 'function' &&
	          arguments[1];
	      return new Promise(function(resolve) {
	        var results = {};
	        Promise.all(promises).then(function(res) {
	          res.forEach(function(result) {
	            Object.keys(result).forEach(function(id) {
	              results[id] = result[id];
	            });
	          });
	          if (cb) {
	            window.setTimeout(cb, 0, results);
	          }
	          resolve(results);
	        });
	      });
	    };
	  },
	
	  // Attach a media stream to an element.
	  attachMediaStream: function(element, stream) {
	    logging('DEPRECATED, attachMediaStream will soon be removed.');
	    element.srcObject = stream;
	  },
	
	  reattachMediaStream: function(to, from) {
	    logging('DEPRECATED, reattachMediaStream will soon be removed.');
	    to.srcObject = from.srcObject;
	  }
	}
	
	// Expose public methods.
	module.e = {
	  shimPeerConnection: edgeShim.shimPeerConnection,
	  attachMediaStream: edgeShim.attachMediaStream,
	  reattachMediaStream: edgeShim.reattachMediaStream
	}
	


/***/ },
/* 154 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	
	var logging = __webpack_require__(0).log;
	var browserDetails = __webpack_require__(0).browserDetails;
	
	var firefoxShim = {
	  shimOnTrack: function() {
	    if (typeof window === 'object' && window.RTCPeerConnection && !('ontrack' in
	        window.RTCPeerConnection.prototype)) {
	      Object.defineProperty(window.RTCPeerConnection.prototype, 'ontrack', {
	        get: function() { return this._ontrack; },
	        set: function(f) {
	          var self = this;
	          if (this._ontrack) {
	            this.removeEventListener('track', this._ontrack);
	            this.removeEventListener('addstream', this._ontrackpoly);
	          }
	          this.addEventListener('track', this._ontrack = f);
	          this.addEventListener('addstream', this._ontrackpoly = function(e) {
	            e.stream.getTracks().forEach(function(track) {
	              var event = new Event('track');
	              event.track = track;
	              event.receiver = {track: track};
	              event.streams = [e.stream];
	              this.dispatchEvent(event);
	            }.bind(this));
	          }.bind(this));
	        }
	      });
	    }
	  },
	
	  shimSourceObject: function() {
	    // Firefox has supported mozSrcObject since FF22, unprefixed in 42.
	    if (typeof window === 'object') {
	      if (window.HTMLMediaElement &&
	        !('srcObject' in window.HTMLMediaElement.prototype)) {
	        // Shim the srcObject property, once, when HTMLMediaElement is found.
	        Object.defineProperty(window.HTMLMediaElement.prototype, 'srcObject', {
	          get: function() {
	            return this.mozSrcObject;
	          },
	          set: function(stream) {
	            this.mozSrcObject = stream;
	          }
	        });
	      }
	    }
	  },
	
	  shimPeerConnection: function() {
	    // The RTCPeerConnection object.
	    if (!window.RTCPeerConnection) {
	      window.RTCPeerConnection = function(pcConfig, pcConstraints) {
	        if (browserDetails.version < 38) {
	          // .urls is not supported in FF < 38.
	          // create RTCIceServers with a single url.
	          if (pcConfig && pcConfig.iceServers) {
	            var newIceServers = [];
	            for (var i = 0; i < pcConfig.iceServers.length; i++) {
	              var server = pcConfig.iceServers[i];
	              if (server.hasOwnProperty('urls')) {
	                for (var j = 0; j < server.urls.length; j++) {
	                  var newServer = {
	                    url: server.urls[j]
	                  };
	                  if (server.urls[j].indexOf('turn') === 0) {
	                    newServer.username = server.username;
	                    newServer.credential = server.credential;
	                  }
	                  newIceServers.push(newServer);
	                }
	              } else {
	                newIceServers.push(pcConfig.iceServers[i]);
	              }
	            }
	            pcConfig.iceServers = newIceServers;
	          }
	        }
	        return new mozRTCPeerConnection(pcConfig, pcConstraints); // jscs:ignore requireCapitalizedConstructors
	      };
	      window.RTCPeerConnection.prototype = mozRTCPeerConnection.prototype;
	
	      // wrap static methods. Currently just generateCertificate.
	      if (mozRTCPeerConnection.generateCertificate) {
	        Object.defineProperty(window.RTCPeerConnection, 'generateCertificate', {
	          get: function() {
	            if (arguments.length) {
	              return mozRTCPeerConnection.generateCertificate.apply(null,
	                  arguments);
	            } else {
	              return mozRTCPeerConnection.generateCertificate;
	            }
	          }
	        });
	      }
	
	      window.RTCSessionDescription = mozRTCSessionDescription;
	      window.RTCIceCandidate = mozRTCIceCandidate;
	    }
	  },
	
	  shimGetUserMedia: function() {
	    // getUserMedia constraints shim.
	    var getUserMedia_ = function(constraints, onSuccess, onError) {
	      var constraintsToFF37_ = function(c) {
	        if (typeof c !== 'object' || c.require) {
	          return c;
	        }
	        var require = [];
	        Object.keys(c).forEach(function(key) {
	          if (key === 'require' || key === 'advanced' || key === 'mediaSource') {
	            return;
	          }
	          var r = c[key] = (typeof c[key] === 'object') ?
	              c[key] : {ideal: c[key]};
	          if (r.min !== undefined ||
	              r.max !== undefined || r.exact !== undefined) {
	            require.push(key);
	          }
	          if (r.exact !== undefined) {
	            if (typeof r.exact === 'number') {
	              r. min = r.max = r.exact;
	            } else {
	              c[key] = r.exact;
	            }
	            delete r.exact;
	          }
	          if (r.ideal !== undefined) {
	            c.advanced = c.advanced || [];
	            var oc = {};
	            if (typeof r.ideal === 'number') {
	              oc[key] = {min: r.ideal, max: r.ideal};
	            } else {
	              oc[key] = r.ideal;
	            }
	            c.advanced.push(oc);
	            delete r.ideal;
	            if (!Object.keys(r).length) {
	              delete c[key];
	            }
	          }
	        });
	        if (require.length) {
	          c.require = require;
	        }
	        return c;
	      };
	      if (browserDetails.version < 38) {
	        logging('spec: ' + JSON.stringify(constraints));
	        if (constraints.audio) {
	          constraints.audio = constraintsToFF37_(constraints.audio);
	        }
	        if (constraints.video) {
	          constraints.video = constraintsToFF37_(constraints.video);
	        }
	        logging('ff37: ' + JSON.stringify(constraints));
	      }
	      return navigator.mozGetUserMedia(constraints, onSuccess, onError);
	    };
	
	    navigator.getUserMedia = getUserMedia_;
	
	    // Returns the result of getUserMedia as a Promise.
	    var getUserMediaPromise_ = function(constraints) {
	      return new Promise(function(resolve, reject) {
	        navigator.getUserMedia(constraints, resolve, reject);
	      });
	    }
	
	    // Shim for mediaDevices on older versions.
	    if (!navigator.mediaDevices) {
	      navigator.mediaDevices = {getUserMedia: getUserMediaPromise_,
	        addEventListener: function() { },
	        removeEventListener: function() { }
	      };
	    }
	    navigator.mediaDevices.enumerateDevices =
	        navigator.mediaDevices.enumerateDevices || function() {
	      return new Promise(function(resolve) {
	        var infos = [
	          {kind: 'audioinput', deviceId: 'default', label: '', groupId: ''},
	          {kind: 'videoinput', deviceId: 'default', label: '', groupId: ''}
	        ];
	        resolve(infos);
	      });
	    };
	
	    if (browserDetails.version < 41) {
	      // Work around http://bugzil.la/1169665
	      var orgEnumerateDevices =
	          navigator.mediaDevices.enumerateDevices.bind(navigator.mediaDevices);
	      navigator.mediaDevices.enumerateDevices = function() {
	        return orgEnumerateDevices().then(undefined, function(e) {
	          if (e.name === 'NotFoundError') {
	            return [];
	          }
	          throw e;
	        });
	      };
	    }
	  },
	
	  // Attach a media stream to an element.
	  attachMediaStream: function(element, stream) {
	    logging('DEPRECATED, attachMediaStream will soon be removed.');
	    element.srcObject = stream;
	  },
	
	  reattachMediaStream: function(to, from) {
	    logging('DEPRECATED, reattachMediaStream will soon be removed.');
	    to.srcObject = from.srcObject;
	  }
	}
	
	// Expose public methods.
	module.e = {
	  shimOnTrack: firefoxShim.shimOnTrack,
	  shimSourceObject: firefoxShim.shimSourceObject,
	  shimPeerConnection: firefoxShim.shimPeerConnection,
	  shimGetUserMedia: __webpack_require__(155),
	  attachMediaStream: firefoxShim.attachMediaStream,
	  reattachMediaStream: firefoxShim.reattachMediaStream
	}


/***/ },
/* 155 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	
	var logging = __webpack_require__(0).log;
	var browserDetails = __webpack_require__(0).browserDetails;
	
	// Expose public methods.
	module.e = function() {
	  // getUserMedia constraints shim.
	  var getUserMedia_ = function(constraints, onSuccess, onError) {
	    var constraintsToFF37_ = function(c) {
	      if (typeof c !== 'object' || c.require) {
	        return c;
	      }
	      var require = [];
	      Object.keys(c).forEach(function(key) {
	        if (key === 'require' || key === 'advanced' || key === 'mediaSource') {
	          return;
	        }
	        var r = c[key] = (typeof c[key] === 'object') ?
	            c[key] : {ideal: c[key]};
	        if (r.min !== undefined ||
	            r.max !== undefined || r.exact !== undefined) {
	          require.push(key);
	        }
	        if (r.exact !== undefined) {
	          if (typeof r.exact === 'number') {
	            r. min = r.max = r.exact;
	          } else {
	            c[key] = r.exact;
	          }
	          delete r.exact;
	        }
	        if (r.ideal !== undefined) {
	          c.advanced = c.advanced || [];
	          var oc = {};
	          if (typeof r.ideal === 'number') {
	            oc[key] = {min: r.ideal, max: r.ideal};
	          } else {
	            oc[key] = r.ideal;
	          }
	          c.advanced.push(oc);
	          delete r.ideal;
	          if (!Object.keys(r).length) {
	            delete c[key];
	          }
	        }
	      });
	      if (require.length) {
	        c.require = require;
	      }
	      return c;
	    };
	    if (browserDetails.version < 38) {
	      logging('spec: ' + JSON.stringify(constraints));
	      if (constraints.audio) {
	        constraints.audio = constraintsToFF37_(constraints.audio);
	      }
	      if (constraints.video) {
	        constraints.video = constraintsToFF37_(constraints.video);
	      }
	      logging('ff37: ' + JSON.stringify(constraints));
	    }
	    return navigator.mozGetUserMedia(constraints, onSuccess, onError);
	  };
	
	  navigator.getUserMedia = getUserMedia_;
	
	  // Returns the result of getUserMedia as a Promise.
	  var getUserMediaPromise_ = function(constraints) {
	    return new Promise(function(resolve, reject) {
	      navigator.getUserMedia(constraints, resolve, reject);
	    });
	  }
	
	  // Shim for mediaDevices on older versions.
	  if (!navigator.mediaDevices) {
	    navigator.mediaDevices = {getUserMedia: getUserMediaPromise_,
	      addEventListener: function() { },
	      removeEventListener: function() { }
	    };
	  }
	  navigator.mediaDevices.enumerateDevices =
	      navigator.mediaDevices.enumerateDevices || function() {
	    return new Promise(function(resolve) {
	      var infos = [
	        {kind: 'audioinput', deviceId: 'default', label: '', groupId: ''},
	        {kind: 'videoinput', deviceId: 'default', label: '', groupId: ''}
	      ];
	      resolve(infos);
	    });
	  };
	
	  if (browserDetails.version < 41) {
	    // Work around http://bugzil.la/1169665
	    var orgEnumerateDevices =
	        navigator.mediaDevices.enumerateDevices.bind(navigator.mediaDevices);
	    navigator.mediaDevices.enumerateDevices = function() {
	      return orgEnumerateDevices().then(undefined, function(e) {
	        if (e.name === 'NotFoundError') {
	          return [];
	        }
	        throw e;
	      });
	    };
	  }
	}


/***/ },
/* 156 */
/***/ function(module, exports, __webpack_require__) {

	module.e = __webpack_require__(49);


/***/ }
/******/ ])
});
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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