(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("get-pixels"), require("ndarray"), require("ndarray-linear-interpolate"));
	else if(typeof define === 'function' && define.amd)
		define(["get-pixels", "ndarray", "ndarray-linear-interpolate"], factory);
	else if(typeof exports === 'object')
		exports["Quagga"] = factory(require("get-pixels"), require("ndarray"), require("ndarray-linear-interpolate"));
	else
		root["Quagga"] = factory(root["get-pixels"], root["ndarray"], root["ndarray-linear-interpolate"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_211__, __WEBPACK_EXTERNAL_MODULE_212__, __WEBPACK_EXTERNAL_MODULE_213__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 214);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */


var logDisabled_ = true;

// Utility methods.
var utils = {
  disableLog: function(bool) {
    if (typeof bool !== 'boolean') {
      return new Error('Argument type: ' + typeof bool +
          '. Please use a boolean.');
    }
    logDisabled_ = bool;
    return (bool) ? 'adapter.js logging disabled' :
        'adapter.js logging enabled';
  },

  log: function() {
    if (typeof window === 'object') {
      if (logDisabled_) {
        return;
      }
      if (typeof console !== 'undefined' && typeof console.log === 'function') {
        console.log.apply(console, arguments);
      }
    }
  },

  /**
   * Extract browser version out of the provided user agent string.
   *
   * @param {!string} uastring userAgent string.
   * @param {!string} expr Regular expression used as match criteria.
   * @param {!number} pos position in the version string to be returned.
   * @return {!number} browser version.
   */
  extractVersion: function(uastring, expr, pos) {
    var match = uastring.match(expr);
    return match && match.length >= pos && parseInt(match[pos], 10);
  },

  /**
   * Browser detector.
   *
   * @return {object} result containing browser and version
   *     properties.
   */
  detectBrowser: function() {
    // Returned result object.
    var result = {};
    result.browser = null;
    result.version = null;

    // Fail early if it's not a browser
    if (typeof window === 'undefined' || !window.navigator) {
      result.browser = 'Not a browser.';
      return result;
    }

    // Firefox.
    if (navigator.mozGetUserMedia) {
      result.browser = 'firefox';
      result.version = this.extractVersion(navigator.userAgent,
          /Firefox\/([0-9]+)\./, 1);

    // all webkit-based browsers
    } else if (navigator.webkitGetUserMedia) {
      // Chrome, Chromium, Webview, Opera, all use the chrome shim for now
      if (window.webkitRTCPeerConnection) {
        result.browser = 'chrome';
        result.version = this.extractVersion(navigator.userAgent,
          /Chrom(e|ium)\/([0-9]+)\./, 2);

      // Safari or unknown webkit-based
      // for the time being Safari has support for MediaStreams but not webRTC
      } else {
        // Safari UA substrings of interest for reference:
        // - webkit version:           AppleWebKit/602.1.25 (also used in Op,Cr)
        // - safari UI version:        Version/9.0.3 (unique to Safari)
        // - safari UI webkit version: Safari/601.4.4 (also used in Op,Cr)
        //
        // if the webkit version and safari UI webkit versions are equals,
        // ... this is a stable version.
        //
        // only the internal webkit version is important today to know if
        // media streams are supported
        //
        if (navigator.userAgent.match(/Version\/(\d+).(\d+)/)) {
          result.browser = 'safari';
          result.version = this.extractVersion(navigator.userAgent,
            /AppleWebKit\/([0-9]+)\./, 1);

        // unknown webkit-based browser
        } else {
          result.browser = 'Unsupported webkit-based browser ' +
              'with GUM support but no WebRTC support.';
          return result;
        }
      }

    // Edge.
    } else if (navigator.mediaDevices &&
        navigator.userAgent.match(/Edge\/(\d+).(\d+)$/)) {
      result.browser = 'edge';
      result.version = this.extractVersion(navigator.userAgent,
          /Edge\/(\d+).(\d+)$/, 2);

    // Default fallthrough: not supported.
    } else {
      result.browser = 'Not a supported browser.';
      return result;
    }

    return result;
  }
};

// Export.
module.exports = {
  log: utils.log,
  disableLog: utils.disableLog,
  browserDetails: utils.detectBrowser(),
  extractVersion: utils.extractVersion
};


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

var freeGlobal = __webpack_require__(58);

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

module.exports = root;


/***/ },
/* 2 */
/***/ function(module, exports) {

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

module.exports = isArray;


/***/ },
/* 3 */
/***/ function(module, exports) {

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

module.exports = isObject;


/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

var baseIsNative = __webpack_require__(122),
    getValue = __webpack_require__(152);

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

module.exports = getNative;


/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _merge2 = __webpack_require__(40);

var _merge3 = _interopRequireDefault(_merge2);

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _barcode_reader = __webpack_require__(10);

var _barcode_reader2 = _interopRequireDefault(_barcode_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function EANReader(opts, supplements) {
    opts = (0, _merge3.default)(getDefaulConfig(), opts);
    _barcode_reader2.default.call(this, opts, supplements);
}

function getDefaulConfig() {
    var config = {};

    Object.keys(EANReader.CONFIG_KEYS).forEach(function (key) {
        config[key] = EANReader.CONFIG_KEYS[key].default;
    });
    return config;
}

var properties = {
    CODE_L_START: { value: 0 },
    CODE_G_START: { value: 10 },
    START_PATTERN: { value: [1, 1, 1] },
    STOP_PATTERN: { value: [1, 1, 1] },
    MIDDLE_PATTERN: { value: [1, 1, 1, 1, 1] },
    EXTENSION_START_PATTERN: { value: [1, 1, 2] },
    CODE_PATTERN: { value: [[3, 2, 1, 1], [2, 2, 2, 1], [2, 1, 2, 2], [1, 4, 1, 1], [1, 1, 3, 2], [1, 2, 3, 1], [1, 1, 1, 4], [1, 3, 1, 2], [1, 2, 1, 3], [3, 1, 1, 2], [1, 1, 2, 3], [1, 2, 2, 2], [2, 2, 1, 2], [1, 1, 4, 1], [2, 3, 1, 1], [1, 3, 2, 1], [4, 1, 1, 1], [2, 1, 3, 1], [3, 1, 2, 1], [2, 1, 1, 3]] },
    CODE_FREQUENCY: { value: [0, 11, 13, 14, 19, 25, 28, 21, 22, 26] },
    SINGLE_CODE_ERROR: { value: 0.70 },
    AVG_CODE_ERROR: { value: 0.48 },
    FORMAT: { value: "ean_13", writeable: false }
};

EANReader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
EANReader.prototype.constructor = EANReader;

EANReader.prototype._decodeCode = function (start, coderange) {
    var counter = [0, 0, 0, 0],
        i,
        self = this,
        offset = start,
        isWhite = !self._row[offset],
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: start,
        end: start
    },
        code,
        error;

    if (!coderange) {
        coderange = self.CODE_PATTERN.length;
    }

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                for (code = 0; code < coderange; code++) {
                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
                    if (error < bestMatch.error) {
                        bestMatch.code = code;
                        bestMatch.error = error;
                    }
                }
                bestMatch.end = i;
                if (bestMatch.error > self.AVG_CODE_ERROR) {
                    return null;
                }
                return bestMatch;
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

EANReader.prototype._findPattern = function (pattern, offset, isWhite, tryHarder, epsilon) {
    var counter = [],
        self = this,
        i,
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0
    },
        error,
        j,
        sum;

    if (!offset) {
        offset = self._nextSet(self._row);
    }

    if (isWhite === undefined) {
        isWhite = false;
    }

    if (tryHarder === undefined) {
        tryHarder = true;
    }

    if (epsilon === undefined) {
        epsilon = self.AVG_CODE_ERROR;
    }

    for (i = 0; i < pattern.length; i++) {
        counter[i] = 0;
    }

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                sum = 0;
                for (j = 0; j < counter.length; j++) {
                    sum += counter[j];
                }
                error = self._matchPattern(counter, pattern);

                if (error < epsilon) {
                    bestMatch.error = error;
                    bestMatch.start = i - sum;
                    bestMatch.end = i;
                    return bestMatch;
                }
                if (tryHarder) {
                    for (j = 0; j < counter.length - 2; j++) {
                        counter[j] = counter[j + 2];
                    }
                    counter[counter.length - 2] = 0;
                    counter[counter.length - 1] = 0;
                    counterPos--;
                } else {
                    return null;
                }
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

EANReader.prototype._findStart = function () {
    var self = this,
        leadingWhitespaceStart,
        offset = self._nextSet(self._row),
        startInfo;

    while (!startInfo) {
        startInfo = self._findPattern(self.START_PATTERN, offset);
        if (!startInfo) {
            return null;
        }
        leadingWhitespaceStart = startInfo.start - (startInfo.end - startInfo.start);
        if (leadingWhitespaceStart >= 0) {
            if (self._matchRange(leadingWhitespaceStart, startInfo.start, 0)) {
                return startInfo;
            }
        }
        offset = startInfo.end;
        startInfo = null;
    }
};

EANReader.prototype._verifyTrailingWhitespace = function (endInfo) {
    var self = this,
        trailingWhitespaceEnd;

    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start);
    if (trailingWhitespaceEnd < self._row.length) {
        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
            return endInfo;
        }
    }
    return null;
};

EANReader.prototype._findEnd = function (offset, isWhite) {
    var self = this,
        endInfo = self._findPattern(self.STOP_PATTERN, offset, isWhite, false);

    return endInfo !== null ? self._verifyTrailingWhitespace(endInfo) : null;
};

EANReader.prototype._calculateFirstDigit = function (codeFrequency) {
    var i,
        self = this;

    for (i = 0; i < self.CODE_FREQUENCY.length; i++) {
        if (codeFrequency === self.CODE_FREQUENCY[i]) {
            return i;
        }
    }
    return null;
};

EANReader.prototype._decodePayload = function (code, result, decodedCodes) {
    var i,
        self = this,
        codeFrequency = 0x0,
        firstDigit;

    for (i = 0; i < 6; i++) {
        code = self._decodeCode(code.end);
        if (!code) {
            return null;
        }
        if (code.code >= self.CODE_G_START) {
            code.code = code.code - self.CODE_G_START;
            codeFrequency |= 1 << 5 - i;
        } else {
            codeFrequency |= 0 << 5 - i;
        }
        result.push(code.code);
        decodedCodes.push(code);
    }

    firstDigit = self._calculateFirstDigit(codeFrequency);
    if (firstDigit === null) {
        return null;
    }
    result.unshift(firstDigit);

    code = self._findPattern(self.MIDDLE_PATTERN, code.end, true, false);
    if (code === null) {
        return null;
    }
    decodedCodes.push(code);

    for (i = 0; i < 6; i++) {
        code = self._decodeCode(code.end, self.CODE_G_START);
        if (!code) {
            return null;
        }
        decodedCodes.push(code);
        result.push(code.code);
    }

    return code;
};

EANReader.prototype._decode = function () {
    var startInfo,
        self = this,
        code,
        result = [],
        decodedCodes = [],
        resultInfo = {};

    startInfo = self._findStart();
    if (!startInfo) {
        return null;
    }
    code = {
        code: startInfo.code,
        start: startInfo.start,
        end: startInfo.end
    };
    decodedCodes.push(code);
    code = self._decodePayload(code, result, decodedCodes);
    if (!code) {
        return null;
    }
    code = self._findEnd(code.end, false);
    if (!code) {
        return null;
    }

    decodedCodes.push(code);

    // Checksum
    if (!self._checksum(result)) {
        return null;
    }

    if (this.supplements.length > 0) {
        var ext = this._decodeExtensions(code.end);
        if (!ext) {
            return null;
        }
        var lastCode = ext.decodedCodes[ext.decodedCodes.length - 1],
            endInfo = {
            start: lastCode.start + ((lastCode.end - lastCode.start) / 2 | 0),
            end: lastCode.end
        };
        if (!self._verifyTrailingWhitespace(endInfo)) {
            return null;
        }
        resultInfo = {
            supplement: ext,
            code: result.join("") + ext.code
        };
    }

    return _extends({
        code: result.join(""),
        start: startInfo.start,
        end: code.end,
        codeset: "",
        startInfo: startInfo,
        decodedCodes: decodedCodes
    }, resultInfo);
};

EANReader.prototype._decodeExtensions = function (offset) {
    var i,
        start = this._nextSet(this._row, offset),
        startInfo = this._findPattern(this.EXTENSION_START_PATTERN, start, false, false),
        result;

    if (startInfo === null) {
        return null;
    }

    for (i = 0; i < this.supplements.length; i++) {
        result = this.supplements[i].decode(this._row, startInfo.end);
        if (result !== null) {
            return {
                code: result.code,
                start: start,
                startInfo: startInfo,
                end: result.end,
                codeset: "",
                decodedCodes: result.decodedCodes
            };
        }
    }
    return null;
};

EANReader.prototype._checksum = function (result) {
    var sum = 0,
        i;

    for (i = result.length - 2; i >= 0; i -= 2) {
        sum += result[i];
    }
    sum *= 3;
    for (i = result.length - 1; i >= 0; i -= 2) {
        sum += result[i];
    }
    return sum % 10 === 0;
};

EANReader.CONFIG_KEYS = {
    supplements: {
        'type': 'arrayOf(string)',
        'default': [],
        'description': 'Allowed extensions to be decoded (2 and/or 5)'
    }
};

exports.default = EANReader;

/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(12),
    getRawTag = __webpack_require__(150),
    objectToString = __webpack_require__(181);

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

module.exports = baseGetTag;


/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

var isArray = __webpack_require__(2),
    isKey = __webpack_require__(163),
    stringToPath = __webpack_require__(190),
    toString = __webpack_require__(201);

/**
 * Casts `value` to a path array if it's not one.
 *
 * @private
 * @param {*} value The value to inspect.
 * @param {Object} [object] The object to query keys on.
 * @returns {Array} Returns the cast property path array.
 */
function castPath(value, object) {
  if (isArray(value)) {
    return value;
  }
  return isKey(value, object) ? [value] : stringToPath(toString(value));
}

module.exports = castPath;


/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

var assignValue = __webpack_require__(29),
    baseAssignValue = __webpack_require__(30);

/**
 * Copies properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy properties from.
 * @param {Array} props The property identifiers to copy.
 * @param {Object} [object={}] The object to copy properties to.
 * @param {Function} [customizer] The function to customize copied values.
 * @returns {Object} Returns `object`.
 */
function copyObject(source, props, object, customizer) {
  var isNew = !object;
  object || (object = {});

  var index = -1,
      length = props.length;

  while (++index < length) {
    var key = props[index];

    var newValue = customizer
      ? customizer(object[key], source[key], key, object, source)
      : undefined;

    if (newValue === undefined) {
      newValue = source[key];
    }
    if (isNew) {
      baseAssignValue(object, key, newValue);
    } else {
      assignValue(object, key, newValue);
    }
  }
  return object;
}

module.exports = copyObject;


/***/ },
/* 9 */
/***/ function(module, exports) {

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

module.exports = isObjectLike;


/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
function BarcodeReader(config, supplements) {
    this._row = [];
    this.config = config || {};
    this.supplements = supplements;
    return this;
}

BarcodeReader.prototype._nextUnset = function (line, start) {
    var i;

    if (start === undefined) {
        start = 0;
    }
    for (i = start; i < line.length; i++) {
        if (!line[i]) {
            return i;
        }
    }
    return line.length;
};

BarcodeReader.prototype._matchPattern = function (counter, code, maxSingleError) {
    var i,
        error = 0,
        singleError = 0,
        sum = 0,
        modulo = 0,
        barWidth,
        count,
        scaled;

    maxSingleError = maxSingleError || this.SINGLE_CODE_ERROR || 1;

    for (i = 0; i < counter.length; i++) {
        sum += counter[i];
        modulo += code[i];
    }
    if (sum < modulo) {
        return Number.MAX_VALUE;
    }
    barWidth = sum / modulo;
    maxSingleError *= barWidth;

    for (i = 0; i < counter.length; i++) {
        count = counter[i];
        scaled = code[i] * barWidth;
        singleError = Math.abs(count - scaled) / scaled;
        if (singleError > maxSingleError) {
            return Number.MAX_VALUE;
        }
        error += singleError;
    }
    return error / modulo;
};

BarcodeReader.prototype._nextSet = function (line, offset) {
    var i;

    offset = offset || 0;
    for (i = offset; i < line.length; i++) {
        if (line[i]) {
            return i;
        }
    }
    return line.length;
};

BarcodeReader.prototype._correctBars = function (counter, correction, indices) {
    var length = indices.length,
        tmp = 0;
    while (length--) {
        tmp = counter[indices[length]] * (1 - (1 - correction) / 2);
        if (tmp > 1) {
            counter[indices[length]] = tmp;
        }
    }
};

BarcodeReader.prototype._matchTrace = function (cmpCounter, epsilon) {
    var counter = [],
        i,
        self = this,
        offset = self._nextSet(self._row),
        isWhite = !self._row[offset],
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0
    },
        error;

    if (cmpCounter) {
        for (i = 0; i < cmpCounter.length; i++) {
            counter.push(0);
        }
        for (i = offset; i < self._row.length; i++) {
            if (self._row[i] ^ isWhite) {
                counter[counterPos]++;
            } else {
                if (counterPos === counter.length - 1) {
                    error = self._matchPattern(counter, cmpCounter);

                    if (error < epsilon) {
                        bestMatch.start = i - offset;
                        bestMatch.end = i;
                        bestMatch.counter = counter;
                        return bestMatch;
                    } else {
                        return null;
                    }
                } else {
                    counterPos++;
                }
                counter[counterPos] = 1;
                isWhite = !isWhite;
            }
        }
    } else {
        counter.push(0);
        for (i = offset; i < self._row.length; i++) {
            if (self._row[i] ^ isWhite) {
                counter[counterPos]++;
            } else {
                counterPos++;
                counter.push(0);
                counter[counterPos] = 1;
                isWhite = !isWhite;
            }
        }
    }

    // if cmpCounter was not given
    bestMatch.start = offset;
    bestMatch.end = self._row.length - 1;
    bestMatch.counter = counter;
    return bestMatch;
};

BarcodeReader.prototype.decodePattern = function (pattern) {
    var self = this,
        result;

    self._row = pattern;
    result = self._decode();
    if (result === null) {
        self._row.reverse();
        result = self._decode();
        if (result) {
            result.direction = BarcodeReader.DIRECTION.REVERSE;
            result.start = self._row.length - result.start;
            result.end = self._row.length - result.end;
        }
    } else {
        result.direction = BarcodeReader.DIRECTION.FORWARD;
    }
    if (result) {
        result.format = self.FORMAT;
    }
    return result;
};

BarcodeReader.prototype._matchRange = function (start, end, value) {
    var i;

    start = start < 0 ? 0 : start;
    for (i = start; i < end; i++) {
        if (this._row[i] !== value) {
            return false;
        }
    }
    return true;
};

BarcodeReader.prototype._fillCounters = function (offset, end, isWhite) {
    var self = this,
        counterPos = 0,
        i,
        counters = [];

    isWhite = typeof isWhite !== 'undefined' ? isWhite : true;
    offset = typeof offset !== 'undefined' ? offset : self._nextUnset(self._row);
    end = end || self._row.length;

    counters[counterPos] = 0;
    for (i = offset; i < end; i++) {
        if (self._row[i] ^ isWhite) {
            counters[counterPos]++;
        } else {
            counterPos++;
            counters[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return counters;
};

Object.defineProperty(BarcodeReader.prototype, "FORMAT", {
    value: 'unknown',
    writeable: false
});

BarcodeReader.DIRECTION = {
    FORWARD: 1,
    REVERSE: -1
};

BarcodeReader.Exception = {
    StartNotFoundException: "Start-Info was not found!",
    CodeNotFoundException: "Code could not be found!",
    PatternNotFoundException: "Pattern could not be found!"
};

BarcodeReader.CONFIG_KEYS = {};

exports.default = BarcodeReader;

/***/ },
/* 11 */
/***/ function(module, exports) {

module.exports = clone

/**
 * Creates a new vec2 initialized with values from an existing vector
 *
 * @param {vec2} a vector to clone
 * @returns {vec2} a new 2D vector
 */
function clone(a) {
    var out = new Float32Array(2)
    out[0] = a[0]
    out[1] = a[1]
    return out
}

/***/ },
/* 12 */
/***/ function(module, exports, __webpack_require__) {

var root = __webpack_require__(1);

/** Built-in value references. */
var Symbol = root.Symbol;

module.exports = Symbol;


/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports.default = {
    init: function init(arr, val) {
        var l = arr.length;
        while (l--) {
            arr[l] = val;
        }
    },

    /**
     * Shuffles the content of an array
     * @return {Array} the array itself shuffled
     */
    shuffle: function shuffle(arr) {
        var i = arr.length - 1,
            j,
            x;
        for (i; i >= 0; i--) {
            j = Math.floor(Math.random() * i);
            x = arr[i];
            arr[i] = arr[j];
            arr[j] = x;
        }
        return arr;
    },

    toPointList: function toPointList(arr) {
        var i,
            j,
            row = [],
            rows = [];
        for (i = 0; i < arr.length; i++) {
            row = [];
            for (j = 0; j < arr[i].length; j++) {
                row[j] = arr[i][j];
            }
            rows[i] = "[" + row.join(",") + "]";
        }
        return "[" + rows.join(",\r\n") + "]";
    },

    /**
     * returns the elements which's score is bigger than the threshold
     * @return {Array} the reduced array
     */
    threshold: function threshold(arr, _threshold, scoreFunc) {
        var i,
            queue = [];
        for (i = 0; i < arr.length; i++) {
            if (scoreFunc.apply(arr, [arr[i]]) >= _threshold) {
                queue.push(arr[i]);
            }
        }
        return queue;
    },

    maxIndex: function maxIndex(arr) {
        var i,
            max = 0;
        for (i = 0; i < arr.length; i++) {
            if (arr[i] > arr[max]) {
                max = i;
            }
        }
        return max;
    },

    max: function max(arr) {
        var i,
            max = 0;
        for (i = 0; i < arr.length; i++) {
            if (arr[i] > max) {
                max = arr[i];
            }
        }
        return max;
    },

    sum: function sum(arr) {
        var length = arr.length,
            sum = 0;

        while (length--) {
            sum += arr[length];
        }
        return sum;
    }
};

/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports.default = {
    drawRect: function drawRect(pos, size, ctx, style) {
        ctx.strokeStyle = style.color;
        ctx.fillStyle = style.color;
        ctx.lineWidth = 1;
        ctx.beginPath();
        ctx.strokeRect(pos.x, pos.y, size.x, size.y);
    },
    drawPath: function drawPath(path, def, ctx, style) {
        ctx.strokeStyle = style.color;
        ctx.fillStyle = style.color;
        ctx.lineWidth = style.lineWidth;
        ctx.beginPath();
        ctx.moveTo(path[0][def.x], path[0][def.y]);
        for (var j = 1; j < path.length; j++) {
            ctx.lineTo(path[j][def.x], path[j][def.y]);
        }
        ctx.closePath();
        ctx.stroke();
    },
    drawImage: function drawImage(imageData, size, ctx) {
        var canvasData = ctx.getImageData(0, 0, size.x, size.y),
            data = canvasData.data,
            imageDataPos = imageData.length,
            canvasDataPos = data.length,
            value;

        if (canvasDataPos / imageDataPos !== 4) {
            return false;
        }
        while (imageDataPos--) {
            value = imageData[imageDataPos];
            data[--canvasDataPos] = 255;
            data[--canvasDataPos] = value;
            data[--canvasDataPos] = value;
            data[--canvasDataPos] = value;
        }
        ctx.putImageData(canvasData, 0, 0);
        return true;
    }
};

/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

var listCacheClear = __webpack_require__(166),
    listCacheDelete = __webpack_require__(167),
    listCacheGet = __webpack_require__(168),
    listCacheHas = __webpack_require__(169),
    listCacheSet = __webpack_require__(170);

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

module.exports = ListCache;


/***/ },
/* 16 */
/***/ function(module, exports, __webpack_require__) {

var eq = __webpack_require__(21);

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

module.exports = assocIndexOf;


/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

var isKeyable = __webpack_require__(164);

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

module.exports = getMapData;


/***/ },
/* 18 */
/***/ function(module, exports) {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  length = length == null ? MAX_SAFE_INTEGER : length;
  return !!length &&
    (typeof value == 'number' || reIsUint.test(value)) &&
    (value > -1 && value % 1 == 0 && value < length);
}

module.exports = isIndex;


/***/ },
/* 19 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4);

/* Built-in method references that are verified to be native. */
var nativeCreate = getNative(Object, 'create');

module.exports = nativeCreate;


/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

var isSymbol = __webpack_require__(38);

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/**
 * Converts `value` to a string key if it's not a string or symbol.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {string|symbol} Returns the key.
 */
function toKey(value) {
  if (typeof value == 'string' || isSymbol(value)) {
    return value;
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

module.exports = toKey;


/***/ },
/* 21 */
/***/ function(module, exports) {

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

module.exports = eq;


/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

var baseIsArguments = __webpack_require__(121),
    isObjectLike = __webpack_require__(9);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

module.exports = isArguments;


/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

var isFunction = __webpack_require__(36),
    isLength = __webpack_require__(37);

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

module.exports = isArrayLike;


/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

var arrayLikeKeys = __webpack_require__(47),
    baseKeysIn = __webpack_require__(125),
    isArrayLike = __webpack_require__(23);

/**
 * Creates an array of the own and inherited enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keysIn(new Foo);
 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
 */
function keysIn(object) {
  return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
}

module.exports = keysIn;


/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports._dimensionsConverters = exports.ERODE = exports.DILATE = exports.Tracer = undefined;
exports.imageRef = imageRef;
exports.computeIntegralImage2 = computeIntegralImage2;
exports.computeIntegralImage = computeIntegralImage;
exports.thresholdImage = thresholdImage;
exports.computeHistogram = computeHistogram;
exports.sharpenLine = sharpenLine;
exports.determineOtsuThreshold = determineOtsuThreshold;
exports.otsuThreshold = otsuThreshold;
exports.computeBinaryImage = computeBinaryImage;
exports.cluster = cluster;
exports.dilate = dilate;
exports.erode = erode;
exports.subtract = subtract;
exports.bitwiseOr = bitwiseOr;
exports.countNonZero = countNonZero;
exports.topGeneric = topGeneric;
exports.grayArrayFromImage = grayArrayFromImage;
exports.grayArrayFromContext = grayArrayFromContext;
exports.grayAndHalfSampleFromCanvasData = grayAndHalfSampleFromCanvasData;
exports.computeGray = computeGray;
exports.loadImageArray = loadImageArray;
exports.halfSample = halfSample;
exports.hsv2rgb = hsv2rgb;
exports._computeDivisors = _computeDivisors;
exports.calculatePatchSize = calculatePatchSize;
exports._parseCSSDimensionValues = _parseCSSDimensionValues;
exports.computeImageArea = computeImageArea;

var _cluster = __webpack_require__(75);

var _cluster2 = _interopRequireDefault(_cluster);

var _array_helper = __webpack_require__(13);

var _array_helper2 = _interopRequireDefault(_array_helper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var vec2 = {
    clone: __webpack_require__(11)
};
var vec3 = {
    clone: __webpack_require__(102)
};

/**
 * @param x x-coordinate
 * @param y y-coordinate
 * @return ImageReference {x,y} Coordinate
 */
function imageRef(x, y) {
    var that = {
        x: x,
        y: y,
        toVec2: function toVec2() {
            return vec2.clone([this.x, this.y]);
        },
        toVec3: function toVec3() {
            return vec3.clone([this.x, this.y, 1]);
        },
        round: function round() {
            this.x = this.x > 0.0 ? Math.floor(this.x + 0.5) : Math.floor(this.x - 0.5);
            this.y = this.y > 0.0 ? Math.floor(this.y + 0.5) : Math.floor(this.y - 0.5);
            return this;
        }
    };
    return that;
};

/**
 * Computes an integral image of a given grayscale image.
 * @param imageDataContainer {ImageDataContainer} the image to be integrated
 */
function computeIntegralImage2(imageWrapper, integralWrapper) {
    var imageData = imageWrapper.data;
    var width = imageWrapper.size.x;
    var height = imageWrapper.size.y;
    var integralImageData = integralWrapper.data;
    var sum = 0,
        posA = 0,
        posB = 0,
        posC = 0,
        posD = 0,
        x,
        y;

    // sum up first column
    posB = width;
    sum = 0;
    for (y = 1; y < height; y++) {
        sum += imageData[posA];
        integralImageData[posB] += sum;
        posA += width;
        posB += width;
    }

    posA = 0;
    posB = 1;
    sum = 0;
    for (x = 1; x < width; x++) {
        sum += imageData[posA];
        integralImageData[posB] += sum;
        posA++;
        posB++;
    }

    for (y = 1; y < height; y++) {
        posA = y * width + 1;
        posB = (y - 1) * width + 1;
        posC = y * width;
        posD = (y - 1) * width;
        for (x = 1; x < width; x++) {
            integralImageData[posA] += imageData[posA] + integralImageData[posB] + integralImageData[posC] - integralImageData[posD];
            posA++;
            posB++;
            posC++;
            posD++;
        }
    }
};

function computeIntegralImage(imageWrapper, integralWrapper) {
    var imageData = imageWrapper.data;
    var width = imageWrapper.size.x;
    var height = imageWrapper.size.y;
    var integralImageData = integralWrapper.data;
    var sum = 0;

    // sum up first row
    for (var i = 0; i < width; i++) {
        sum += imageData[i];
        integralImageData[i] = sum;
    }

    for (var v = 1; v < height; v++) {
        sum = 0;
        for (var u = 0; u < width; u++) {
            sum += imageData[v * width + u];
            integralImageData[v * width + u] = sum + integralImageData[(v - 1) * width + u];
        }
    }
};

function thresholdImage(imageWrapper, threshold, targetWrapper) {
    if (!targetWrapper) {
        targetWrapper = imageWrapper;
    }
    var imageData = imageWrapper.data,
        length = imageData.length,
        targetData = targetWrapper.data;

    while (length--) {
        targetData[length] = imageData[length] < threshold ? 1 : 0;
    }
};

function computeHistogram(imageWrapper, bitsPerPixel) {
    if (!bitsPerPixel) {
        bitsPerPixel = 8;
    }
    var imageData = imageWrapper.data,
        length = imageData.length,
        bitShift = 8 - bitsPerPixel,
        bucketCnt = 1 << bitsPerPixel,
        hist = new Int32Array(bucketCnt);

    while (length--) {
        hist[imageData[length] >> bitShift]++;
    }
    return hist;
};

function sharpenLine(line) {
    var i,
        length = line.length,
        left = line[0],
        center = line[1],
        right;

    for (i = 1; i < length - 1; i++) {
        right = line[i + 1];
        //  -1 4 -1 kernel
        line[i - 1] = center * 2 - left - right & 255;
        left = center;
        center = right;
    }
    return line;
};

function determineOtsuThreshold(imageWrapper, bitsPerPixel) {
    if (!bitsPerPixel) {
        bitsPerPixel = 8;
    }
    var hist,
        threshold,
        bitShift = 8 - bitsPerPixel;

    function px(init, end) {
        var sum = 0,
            i;
        for (i = init; i <= end; i++) {
            sum += hist[i];
        }
        return sum;
    }

    function mx(init, end) {
        var i,
            sum = 0;

        for (i = init; i <= end; i++) {
            sum += i * hist[i];
        }

        return sum;
    }

    function determineThreshold() {
        var vet = [0],
            p1,
            p2,
            p12,
            k,
            m1,
            m2,
            m12,
            max = (1 << bitsPerPixel) - 1;

        hist = computeHistogram(imageWrapper, bitsPerPixel);
        for (k = 1; k < max; k++) {
            p1 = px(0, k);
            p2 = px(k + 1, max);
            p12 = p1 * p2;
            if (p12 === 0) {
                p12 = 1;
            }
            m1 = mx(0, k) * p2;
            m2 = mx(k + 1, max) * p1;
            m12 = m1 - m2;
            vet[k] = m12 * m12 / p12;
        }
        return _array_helper2.default.maxIndex(vet);
    }

    threshold = determineThreshold();
    return threshold << bitShift;
};

function otsuThreshold(imageWrapper, targetWrapper) {
    var threshold = determineOtsuThreshold(imageWrapper);

    thresholdImage(imageWrapper, threshold, targetWrapper);
    return threshold;
};

// local thresholding
function computeBinaryImage(imageWrapper, integralWrapper, targetWrapper) {
    computeIntegralImage(imageWrapper, integralWrapper);

    if (!targetWrapper) {
        targetWrapper = imageWrapper;
    }
    var imageData = imageWrapper.data;
    var targetData = targetWrapper.data;
    var width = imageWrapper.size.x;
    var height = imageWrapper.size.y;
    var integralImageData = integralWrapper.data;
    var sum = 0,
        v,
        u,
        kernel = 3,
        A,
        B,
        C,
        D,
        avg,
        size = (kernel * 2 + 1) * (kernel * 2 + 1);

    // clear out top & bottom-border
    for (v = 0; v <= kernel; v++) {
        for (u = 0; u < width; u++) {
            targetData[v * width + u] = 0;
            targetData[(height - 1 - v) * width + u] = 0;
        }
    }

    // clear out left & right border
    for (v = kernel; v < height - kernel; v++) {
        for (u = 0; u <= kernel; u++) {
            targetData[v * width + u] = 0;
            targetData[v * width + (width - 1 - u)] = 0;
        }
    }

    for (v = kernel + 1; v < height - kernel - 1; v++) {
        for (u = kernel + 1; u < width - kernel; u++) {
            A = integralImageData[(v - kernel - 1) * width + (u - kernel - 1)];
            B = integralImageData[(v - kernel - 1) * width + (u + kernel)];
            C = integralImageData[(v + kernel) * width + (u - kernel - 1)];
            D = integralImageData[(v + kernel) * width + (u + kernel)];
            sum = D - C - B + A;
            avg = sum / size;
            targetData[v * width + u] = imageData[v * width + u] > avg + 5 ? 0 : 1;
        }
    }
};

function cluster(points, threshold, property) {
    var i,
        k,
        cluster,
        point,
        clusters = [];

    if (!property) {
        property = "rad";
    }

    function addToCluster(newPoint) {
        var found = false;
        for (k = 0; k < clusters.length; k++) {
            cluster = clusters[k];
            if (cluster.fits(newPoint)) {
                cluster.add(newPoint);
                found = true;
            }
        }
        return found;
    }

    // iterate over each cloud
    for (i = 0; i < points.length; i++) {
        point = _cluster2.default.createPoint(points[i], i, property);
        if (!addToCluster(point)) {
            clusters.push(_cluster2.default.create(point, threshold));
        }
    }
    return clusters;
};

var Tracer = exports.Tracer = {
    trace: function trace(points, vec) {
        var iteration,
            maxIterations = 10,
            top = [],
            result = [],
            centerPos = 0,
            currentPos = 0;

        function trace(idx, forward) {
            var from,
                to,
                toIdx,
                predictedPos,
                thresholdX = 1,
                thresholdY = Math.abs(vec[1] / 10),
                found = false;

            function match(pos, predicted) {
                if (pos.x > predicted.x - thresholdX && pos.x < predicted.x + thresholdX && pos.y > predicted.y - thresholdY && pos.y < predicted.y + thresholdY) {
                    return true;
                } else {
                    return false;
                }
            }

            // check if the next index is within the vec specifications
            // if not, check as long as the threshold is met

            from = points[idx];
            if (forward) {
                predictedPos = {
                    x: from.x + vec[0],
                    y: from.y + vec[1]
                };
            } else {
                predictedPos = {
                    x: from.x - vec[0],
                    y: from.y - vec[1]
                };
            }

            toIdx = forward ? idx + 1 : idx - 1;
            to = points[toIdx];
            while (to && (found = match(to, predictedPos)) !== true && Math.abs(to.y - from.y) < vec[1]) {
                toIdx = forward ? toIdx + 1 : toIdx - 1;
                to = points[toIdx];
            }

            return found ? toIdx : null;
        }

        for (iteration = 0; iteration < maxIterations; iteration++) {
            // randomly select point to start with
            centerPos = Math.floor(Math.random() * points.length);

            // trace forward
            top = [];
            currentPos = centerPos;
            top.push(points[currentPos]);
            while ((currentPos = trace(currentPos, true)) !== null) {
                top.push(points[currentPos]);
            }
            if (centerPos > 0) {
                currentPos = centerPos;
                while ((currentPos = trace(currentPos, false)) !== null) {
                    top.push(points[currentPos]);
                }
            }

            if (top.length > result.length) {
                result = top;
            }
        }
        return result;
    }
};

var DILATE = exports.DILATE = 1;
var ERODE = exports.ERODE = 2;

function dilate(inImageWrapper, outImageWrapper) {
    var v,
        u,
        inImageData = inImageWrapper.data,
        outImageData = outImageWrapper.data,
        height = inImageWrapper.size.y,
        width = inImageWrapper.size.x,
        sum,
        yStart1,
        yStart2,
        xStart1,
        xStart2;

    for (v = 1; v < height - 1; v++) {
        for (u = 1; u < width - 1; u++) {
            yStart1 = v - 1;
            yStart2 = v + 1;
            xStart1 = u - 1;
            xStart2 = u + 1;
            sum = inImageData[yStart1 * width + xStart1] + inImageData[yStart1 * width + xStart2] + inImageData[v * width + u] + inImageData[yStart2 * width + xStart1] + inImageData[yStart2 * width + xStart2];
            outImageData[v * width + u] = sum > 0 ? 1 : 0;
        }
    }
};

function erode(inImageWrapper, outImageWrapper) {
    var v,
        u,
        inImageData = inImageWrapper.data,
        outImageData = outImageWrapper.data,
        height = inImageWrapper.size.y,
        width = inImageWrapper.size.x,
        sum,
        yStart1,
        yStart2,
        xStart1,
        xStart2;

    for (v = 1; v < height - 1; v++) {
        for (u = 1; u < width - 1; u++) {
            yStart1 = v - 1;
            yStart2 = v + 1;
            xStart1 = u - 1;
            xStart2 = u + 1;
            sum = inImageData[yStart1 * width + xStart1] + inImageData[yStart1 * width + xStart2] + inImageData[v * width + u] + inImageData[yStart2 * width + xStart1] + inImageData[yStart2 * width + xStart2];
            outImageData[v * width + u] = sum === 5 ? 1 : 0;
        }
    }
};

function subtract(aImageWrapper, bImageWrapper, resultImageWrapper) {
    if (!resultImageWrapper) {
        resultImageWrapper = aImageWrapper;
    }
    var length = aImageWrapper.data.length,
        aImageData = aImageWrapper.data,
        bImageData = bImageWrapper.data,
        cImageData = resultImageWrapper.data;

    while (length--) {
        cImageData[length] = aImageData[length] - bImageData[length];
    }
};

function bitwiseOr(aImageWrapper, bImageWrapper, resultImageWrapper) {
    if (!resultImageWrapper) {
        resultImageWrapper = aImageWrapper;
    }
    var length = aImageWrapper.data.length,
        aImageData = aImageWrapper.data,
        bImageData = bImageWrapper.data,
        cImageData = resultImageWrapper.data;

    while (length--) {
        cImageData[length] = aImageData[length] || bImageData[length];
    }
};

function countNonZero(imageWrapper) {
    var length = imageWrapper.data.length,
        data = imageWrapper.data,
        sum = 0;

    while (length--) {
        sum += data[length];
    }
    return sum;
};

function topGeneric(list, top, scoreFunc) {
    var i,
        minIdx = 0,
        min = 0,
        queue = [],
        score,
        hit,
        pos;

    for (i = 0; i < top; i++) {
        queue[i] = {
            score: 0,
            item: null
        };
    }

    for (i = 0; i < list.length; i++) {
        score = scoreFunc.apply(this, [list[i]]);
        if (score > min) {
            hit = queue[minIdx];
            hit.score = score;
            hit.item = list[i];
            min = Number.MAX_VALUE;
            for (pos = 0; pos < top; pos++) {
                if (queue[pos].score < min) {
                    min = queue[pos].score;
                    minIdx = pos;
                }
            }
        }
    }

    return queue;
};

function grayArrayFromImage(htmlImage, offsetX, ctx, array) {
    ctx.drawImage(htmlImage, offsetX, 0, htmlImage.width, htmlImage.height);
    var ctxData = ctx.getImageData(offsetX, 0, htmlImage.width, htmlImage.height).data;
    computeGray(ctxData, array);
};

function grayArrayFromContext(ctx, size, offset, array) {
    var ctxData = ctx.getImageData(offset.x, offset.y, size.x, size.y).data;
    computeGray(ctxData, array);
};

function grayAndHalfSampleFromCanvasData(canvasData, size, outArray) {
    var topRowIdx = 0;
    var bottomRowIdx = size.x;
    var endIdx = Math.floor(canvasData.length / 4);
    var outWidth = size.x / 2;
    var outImgIdx = 0;
    var inWidth = size.x;
    var i;

    while (bottomRowIdx < endIdx) {
        for (i = 0; i < outWidth; i++) {
            outArray[outImgIdx] = Math.floor((0.299 * canvasData[topRowIdx * 4 + 0] + 0.587 * canvasData[topRowIdx * 4 + 1] + 0.114 * canvasData[topRowIdx * 4 + 2] + (0.299 * canvasData[(topRowIdx + 1) * 4 + 0] + 0.587 * canvasData[(topRowIdx + 1) * 4 + 1] + 0.114 * canvasData[(topRowIdx + 1) * 4 + 2]) + (0.299 * canvasData[bottomRowIdx * 4 + 0] + 0.587 * canvasData[bottomRowIdx * 4 + 1] + 0.114 * canvasData[bottomRowIdx * 4 + 2]) + (0.299 * canvasData[(bottomRowIdx + 1) * 4 + 0] + 0.587 * canvasData[(bottomRowIdx + 1) * 4 + 1] + 0.114 * canvasData[(bottomRowIdx + 1) * 4 + 2])) / 4);
            outImgIdx++;
            topRowIdx = topRowIdx + 2;
            bottomRowIdx = bottomRowIdx + 2;
        }
        topRowIdx = topRowIdx + inWidth;
        bottomRowIdx = bottomRowIdx + inWidth;
    }
};

function computeGray(imageData, outArray, config) {
    var l = imageData.length / 4 | 0,
        i,
        singleChannel = config && config.singleChannel === true;

    if (singleChannel) {
        for (i = 0; i < l; i++) {
            outArray[i] = imageData[i * 4 + 0];
        }
    } else {
        for (i = 0; i < l; i++) {
            outArray[i] = Math.floor(0.299 * imageData[i * 4 + 0] + 0.587 * imageData[i * 4 + 1] + 0.114 * imageData[i * 4 + 2]);
        }
    }
};

function loadImageArray(src, callback, canvas) {
    if (!canvas) {
        canvas = document.createElement('canvas');
    }
    var img = new Image();
    img.callback = callback;
    img.onload = function () {
        canvas.width = this.width;
        canvas.height = this.height;
        var ctx = canvas.getContext('2d');
        ctx.drawImage(this, 0, 0);
        var array = new Uint8Array(this.width * this.height);
        ctx.drawImage(this, 0, 0);
        var data = ctx.getImageData(0, 0, this.width, this.height).data;
        computeGray(data, array);
        this.callback(array, {
            x: this.width,
            y: this.height
        }, this);
    };
    img.src = src;
};

/**
 * @param inImg {ImageWrapper} input image to be sampled
 * @param outImg {ImageWrapper} to be stored in
 */
function halfSample(inImgWrapper, outImgWrapper) {
    var inImg = inImgWrapper.data;
    var inWidth = inImgWrapper.size.x;
    var outImg = outImgWrapper.data;
    var topRowIdx = 0;
    var bottomRowIdx = inWidth;
    var endIdx = inImg.length;
    var outWidth = inWidth / 2;
    var outImgIdx = 0;
    while (bottomRowIdx < endIdx) {
        for (var i = 0; i < outWidth; i++) {
            outImg[outImgIdx] = Math.floor((inImg[topRowIdx] + inImg[topRowIdx + 1] + inImg[bottomRowIdx] + inImg[bottomRowIdx + 1]) / 4);
            outImgIdx++;
            topRowIdx = topRowIdx + 2;
            bottomRowIdx = bottomRowIdx + 2;
        }
        topRowIdx = topRowIdx + inWidth;
        bottomRowIdx = bottomRowIdx + inWidth;
    }
};

function hsv2rgb(hsv, rgb) {
    var h = hsv[0],
        s = hsv[1],
        v = hsv[2],
        c = v * s,
        x = c * (1 - Math.abs(h / 60 % 2 - 1)),
        m = v - c,
        r = 0,
        g = 0,
        b = 0;

    rgb = rgb || [0, 0, 0];

    if (h < 60) {
        r = c;
        g = x;
    } else if (h < 120) {
        r = x;
        g = c;
    } else if (h < 180) {
        g = c;
        b = x;
    } else if (h < 240) {
        g = x;
        b = c;
    } else if (h < 300) {
        r = x;
        b = c;
    } else if (h < 360) {
        r = c;
        b = x;
    }
    rgb[0] = (r + m) * 255 | 0;
    rgb[1] = (g + m) * 255 | 0;
    rgb[2] = (b + m) * 255 | 0;
    return rgb;
};

function _computeDivisors(n) {
    var largeDivisors = [],
        divisors = [],
        i;

    for (i = 1; i < Math.sqrt(n) + 1; i++) {
        if (n % i === 0) {
            divisors.push(i);
            if (i !== n / i) {
                largeDivisors.unshift(Math.floor(n / i));
            }
        }
    }
    return divisors.concat(largeDivisors);
};

function _computeIntersection(arr1, arr2) {
    var i = 0,
        j = 0,
        result = [];

    while (i < arr1.length && j < arr2.length) {
        if (arr1[i] === arr2[j]) {
            result.push(arr1[i]);
            i++;
            j++;
        } else if (arr1[i] > arr2[j]) {
            j++;
        } else {
            i++;
        }
    }
    return result;
};

function calculatePatchSize(patchSize, imgSize) {
    var divisorsX = _computeDivisors(imgSize.x),
        divisorsY = _computeDivisors(imgSize.y),
        wideSide = Math.max(imgSize.x, imgSize.y),
        common = _computeIntersection(divisorsX, divisorsY),
        nrOfPatchesList = [8, 10, 15, 20, 32, 60, 80],
        nrOfPatchesMap = {
        "x-small": 5,
        "small": 4,
        "medium": 3,
        "large": 2,
        "x-large": 1
    },
        nrOfPatchesIdx = nrOfPatchesMap[patchSize] || nrOfPatchesMap.medium,
        nrOfPatches = nrOfPatchesList[nrOfPatchesIdx],
        desiredPatchSize = Math.floor(wideSide / nrOfPatches),
        optimalPatchSize;

    function findPatchSizeForDivisors(divisors) {
        var i = 0,
            found = divisors[Math.floor(divisors.length / 2)];

        while (i < divisors.length - 1 && divisors[i] < desiredPatchSize) {
            i++;
        }
        if (i > 0) {
            if (Math.abs(divisors[i] - desiredPatchSize) > Math.abs(divisors[i - 1] - desiredPatchSize)) {
                found = divisors[i - 1];
            } else {
                found = divisors[i];
            }
        }
        if (desiredPatchSize / found < nrOfPatchesList[nrOfPatchesIdx + 1] / nrOfPatchesList[nrOfPatchesIdx] && desiredPatchSize / found > nrOfPatchesList[nrOfPatchesIdx - 1] / nrOfPatchesList[nrOfPatchesIdx]) {
            return { x: found, y: found };
        }
        return null;
    }

    optimalPatchSize = findPatchSizeForDivisors(common);
    if (!optimalPatchSize) {
        optimalPatchSize = findPatchSizeForDivisors(_computeDivisors(wideSide));
        if (!optimalPatchSize) {
            optimalPatchSize = findPatchSizeForDivisors(_computeDivisors(desiredPatchSize * nrOfPatches));
        }
    }
    return optimalPatchSize;
};

function _parseCSSDimensionValues(value) {
    var dimension = {
        value: parseFloat(value),
        unit: value.indexOf("%") === value.length - 1 ? "%" : "%"
    };

    return dimension;
};

var _dimensionsConverters = exports._dimensionsConverters = {
    top: function top(dimension, context) {
        if (dimension.unit === "%") {
            return Math.floor(context.height * (dimension.value / 100));
        }
    },
    right: function right(dimension, context) {
        if (dimension.unit === "%") {
            return Math.floor(context.width - context.width * (dimension.value / 100));
        }
    },
    bottom: function bottom(dimension, context) {
        if (dimension.unit === "%") {
            return Math.floor(context.height - context.height * (dimension.value / 100));
        }
    },
    left: function left(dimension, context) {
        if (dimension.unit === "%") {
            return Math.floor(context.width * (dimension.value / 100));
        }
    }
};

function computeImageArea(inputWidth, inputHeight, area) {
    var context = { width: inputWidth, height: inputHeight };

    var parsedArea = Object.keys(area).reduce(function (result, key) {
        var value = area[key],
            parsed = _parseCSSDimensionValues(value),
            calculated = _dimensionsConverters[key](parsed, context);

        result[key] = calculated;
        return result;
    }, {});

    return {
        sx: parsedArea.left,
        sy: parsedArea.top,
        sw: parsedArea.right - parsedArea.left,
        sh: parsedArea.bottom - parsedArea.top
    };
};

/***/ },
/* 26 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _subImage = __webpack_require__(78);

var _subImage2 = _interopRequireDefault(_subImage);

var _cv_utils = __webpack_require__(25);

var _array_helper = __webpack_require__(13);

var _array_helper2 = _interopRequireDefault(_array_helper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var vec2 = {
    clone: __webpack_require__(11)
};

/**
 * Represents a basic image combining the data and size.
 * In addition, some methods for manipulation are contained.
 * @param size {x,y} The size of the image in pixel
 * @param data {Array} If given, a flat array containing the pixel data
 * @param ArrayType {Type} If given, the desired DataType of the Array (may be typed/non-typed)
 * @param initialize {Boolean} Indicating if the array should be initialized on creation.
 * @returns {ImageWrapper}
 */
function ImageWrapper(size, data, ArrayType, initialize) {
    if (!data) {
        if (ArrayType) {
            this.data = new ArrayType(size.x * size.y);
            if (ArrayType === Array && initialize) {
                _array_helper2.default.init(this.data, 0);
            }
        } else {
            this.data = new Uint8Array(size.x * size.y);
            if (Uint8Array === Array && initialize) {
                _array_helper2.default.init(this.data, 0);
            }
        }
    } else {
        this.data = data;
    }
    this.size = size;
}

/**
 * tests if a position is within the image with a given offset
 * @param imgRef {x, y} The location to test
 * @param border Number the padding value in pixel
 * @returns {Boolean} true if location inside the image's border, false otherwise
 * @see cvd/image.h
 */
ImageWrapper.prototype.inImageWithBorder = function (imgRef, border) {
    return imgRef.x >= border && imgRef.y >= border && imgRef.x < this.size.x - border && imgRef.y < this.size.y - border;
};

/**
 * Performs bilinear sampling
 * @param inImg Image to extract sample from
 * @param x the x-coordinate
 * @param y the y-coordinate
 * @returns the sampled value
 * @see cvd/vision.h
 */
ImageWrapper.sample = function (inImg, x, y) {
    var lx = Math.floor(x);
    var ly = Math.floor(y);
    var w = inImg.size.x;
    var base = ly * inImg.size.x + lx;
    var a = inImg.data[base + 0];
    var b = inImg.data[base + 1];
    var c = inImg.data[base + w];
    var d = inImg.data[base + w + 1];
    var e = a - b;
    x -= lx;
    y -= ly;

    var result = Math.floor(x * (y * (e - c + d) - e) + y * (c - a) + a);
    return result;
};

/**
 * Initializes a given array. Sets each element to zero.
 * @param array {Array} The array to initialize
 */
ImageWrapper.clearArray = function (array) {
    var l = array.length;
    while (l--) {
        array[l] = 0;
    }
};

/**
 * Creates a {SubImage} from the current image ({this}).
 * @param from {ImageRef} The position where to start the {SubImage} from. (top-left corner)
 * @param size {ImageRef} The size of the resulting image
 * @returns {SubImage} A shared part of the original image
 */
ImageWrapper.prototype.subImage = function (from, size) {
    return new _subImage2.default(from, size, this);
};

/**
 * Creates an {ImageWrapper) and copies the needed underlying image-data area
 * @param imageWrapper {ImageWrapper} The target {ImageWrapper} where the data should be copied
 * @param from {ImageRef} The location where to copy from (top-left location)
 */
ImageWrapper.prototype.subImageAsCopy = function (imageWrapper, from) {
    var sizeY = imageWrapper.size.y,
        sizeX = imageWrapper.size.x;
    var x, y;
    for (x = 0; x < sizeX; x++) {
        for (y = 0; y < sizeY; y++) {
            imageWrapper.data[y * sizeX + x] = this.data[(from.y + y) * this.size.x + from.x + x];
        }
    }
};

ImageWrapper.prototype.copyTo = function (imageWrapper) {
    var length = this.data.length,
        srcData = this.data,
        dstData = imageWrapper.data;

    while (length--) {
        dstData[length] = srcData[length];
    }
};

/**
 * Retrieves a given pixel position from the image
 * @param x {Number} The x-position
 * @param y {Number} The y-position
 * @returns {Number} The grayscale value at the pixel-position
 */
ImageWrapper.prototype.get = function (x, y) {
    return this.data[y * this.size.x + x];
};

/**
 * Retrieves a given pixel position from the image
 * @param x {Number} The x-position
 * @param y {Number} The y-position
 * @returns {Number} The grayscale value at the pixel-position
 */
ImageWrapper.prototype.getSafe = function (x, y) {
    var i;

    if (!this.indexMapping) {
        this.indexMapping = {
            x: [],
            y: []
        };
        for (i = 0; i < this.size.x; i++) {
            this.indexMapping.x[i] = i;
            this.indexMapping.x[i + this.size.x] = i;
        }
        for (i = 0; i < this.size.y; i++) {
            this.indexMapping.y[i] = i;
            this.indexMapping.y[i + this.size.y] = i;
        }
    }
    return this.data[this.indexMapping.y[y + this.size.y] * this.size.x + this.indexMapping.x[x + this.size.x]];
};

/**
 * Sets a given pixel position in the image
 * @param x {Number} The x-position
 * @param y {Number} The y-position
 * @param value {Number} The grayscale value to set
 * @returns {ImageWrapper} The Image itself (for possible chaining)
 */
ImageWrapper.prototype.set = function (x, y, value) {
    this.data[y * this.size.x + x] = value;
    return this;
};

/**
 * Sets the border of the image (1 pixel) to zero
 */
ImageWrapper.prototype.zeroBorder = function () {
    var i,
        width = this.size.x,
        height = this.size.y,
        data = this.data;
    for (i = 0; i < width; i++) {
        data[i] = data[(height - 1) * width + i] = 0;
    }
    for (i = 1; i < height - 1; i++) {
        data[i * width] = data[i * width + (width - 1)] = 0;
    }
};

/**
 * Inverts a binary image in place
 */
ImageWrapper.prototype.invert = function () {
    var data = this.data,
        length = data.length;

    while (length--) {
        data[length] = data[length] ? 0 : 1;
    }
};

ImageWrapper.prototype.convolve = function (kernel) {
    var x,
        y,
        kx,
        ky,
        kSize = kernel.length / 2 | 0,
        accu = 0;
    for (y = 0; y < this.size.y; y++) {
        for (x = 0; x < this.size.x; x++) {
            accu = 0;
            for (ky = -kSize; ky <= kSize; ky++) {
                for (kx = -kSize; kx <= kSize; kx++) {
                    accu += kernel[ky + kSize][kx + kSize] * this.getSafe(x + kx, y + ky);
                }
            }
            this.data[y * this.size.x + x] = accu;
        }
    }
};

ImageWrapper.prototype.moments = function (labelcount) {
    var data = this.data,
        x,
        y,
        height = this.size.y,
        width = this.size.x,
        val,
        ysq,
        labelsum = [],
        i,
        label,
        mu11,
        mu02,
        mu20,
        x_,
        y_,
        tmp,
        result = [],
        PI = Math.PI,
        PI_4 = PI / 4;

    if (labelcount <= 0) {
        return result;
    }

    for (i = 0; i < labelcount; i++) {
        labelsum[i] = {
            m00: 0,
            m01: 0,
            m10: 0,
            m11: 0,
            m02: 0,
            m20: 0,
            theta: 0,
            rad: 0
        };
    }

    for (y = 0; y < height; y++) {
        ysq = y * y;
        for (x = 0; x < width; x++) {
            val = data[y * width + x];
            if (val > 0) {
                label = labelsum[val - 1];
                label.m00 += 1;
                label.m01 += y;
                label.m10 += x;
                label.m11 += x * y;
                label.m02 += ysq;
                label.m20 += x * x;
            }
        }
    }

    for (i = 0; i < labelcount; i++) {
        label = labelsum[i];
        if (!isNaN(label.m00) && label.m00 !== 0) {
            x_ = label.m10 / label.m00;
            y_ = label.m01 / label.m00;
            mu11 = label.m11 / label.m00 - x_ * y_;
            mu02 = label.m02 / label.m00 - y_ * y_;
            mu20 = label.m20 / label.m00 - x_ * x_;
            tmp = (mu02 - mu20) / (2 * mu11);
            tmp = 0.5 * Math.atan(tmp) + (mu11 >= 0 ? PI_4 : -PI_4) + PI;
            label.theta = (tmp * 180 / PI + 90) % 180 - 90;
            if (label.theta < 0) {
                label.theta += 180;
            }
            label.rad = tmp > PI ? tmp - PI : tmp;
            label.vec = vec2.clone([Math.cos(tmp), Math.sin(tmp)]);
            result.push(label);
        }
    }

    return result;
};

/**
 * Displays the {ImageWrapper} in a given canvas
 * @param canvas {Canvas} The canvas element to write to
 * @param scale {Number} Scale which is applied to each pixel-value
 */
ImageWrapper.prototype.show = function (canvas, scale) {
    var ctx, frame, data, current, pixel, x, y;

    if (!scale) {
        scale = 1.0;
    }
    ctx = canvas.getContext('2d');
    canvas.width = this.size.x;
    canvas.height = this.size.y;
    frame = ctx.getImageData(0, 0, canvas.width, canvas.height);
    data = frame.data;
    current = 0;
    for (y = 0; y < this.size.y; y++) {
        for (x = 0; x < this.size.x; x++) {
            pixel = y * this.size.x + x;
            current = this.get(x, y) * scale;
            data[pixel * 4 + 0] = current;
            data[pixel * 4 + 1] = current;
            data[pixel * 4 + 2] = current;
            data[pixel * 4 + 3] = 255;
        }
    }
    //frame.data = data;
    ctx.putImageData(frame, 0, 0);
};

/**
 * Displays the {SubImage} in a given canvas
 * @param canvas {Canvas} The canvas element to write to
 * @param scale {Number} Scale which is applied to each pixel-value
 */
ImageWrapper.prototype.overlay = function (canvas, scale, from) {
    if (!scale || scale < 0 || scale > 360) {
        scale = 360;
    }
    var hsv = [0, 1, 1];
    var rgb = [0, 0, 0];
    var whiteRgb = [255, 255, 255];
    var blackRgb = [0, 0, 0];
    var result = [];
    var ctx = canvas.getContext('2d');
    var frame = ctx.getImageData(from.x, from.y, this.size.x, this.size.y);
    var data = frame.data;
    var length = this.data.length;
    while (length--) {
        hsv[0] = this.data[length] * scale;
        result = hsv[0] <= 0 ? whiteRgb : hsv[0] >= 360 ? blackRgb : (0, _cv_utils.hsv2rgb)(hsv, rgb);
        data[length * 4 + 0] = result[0];
        data[length * 4 + 1] = result[1];
        data[length * 4 + 2] = result[2];
        data[length * 4 + 3] = 255;
    }
    ctx.putImageData(frame, from.x, from.y);
};

exports.default = ImageWrapper;

/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4),
    root = __webpack_require__(1);

/* Built-in method references that are verified to be native. */
var Map = getNative(root, 'Map');

module.exports = Map;


/***/ },
/* 28 */
/***/ function(module, exports) {

/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

module.exports = arrayPush;


/***/ },
/* 29 */
/***/ function(module, exports, __webpack_require__) {

var baseAssignValue = __webpack_require__(30),
    eq = __webpack_require__(21);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignValue(object, key, value) {
  var objValue = object[key];
  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

module.exports = assignValue;


/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

var defineProperty = __webpack_require__(56);

/**
 * The base implementation of `assignValue` and `assignMergeValue` without
 * value checks.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function baseAssignValue(object, key, value) {
  if (key == '__proto__' && defineProperty) {
    defineProperty(object, key, {
      'configurable': true,
      'enumerable': true,
      'value': value,
      'writable': true
    });
  } else {
    object[key] = value;
  }
}

module.exports = baseAssignValue;


/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

var Uint8Array = __webpack_require__(107);

/**
 * Creates a clone of `arrayBuffer`.
 *
 * @private
 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
 * @returns {ArrayBuffer} Returns the cloned array buffer.
 */
function cloneArrayBuffer(arrayBuffer) {
  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
  new Uint8Array(result).set(new Uint8Array(arrayBuffer));
  return result;
}

module.exports = cloneArrayBuffer;


/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

var overArg = __webpack_require__(62);

/** Built-in value references. */
var getPrototype = overArg(Object.getPrototypeOf, Object);

module.exports = getPrototype;


/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

var arrayFilter = __webpack_require__(113),
    stubArray = __webpack_require__(69);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return arrayFilter(nativeGetSymbols(object), function(symbol) {
    return propertyIsEnumerable.call(object, symbol);
  });
};

module.exports = getSymbols;


/***/ },
/* 34 */
/***/ function(module, exports) {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

  return value === proto;
}

module.exports = isPrototype;


/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var root = __webpack_require__(1),
    stubFalse = __webpack_require__(199);

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

module.exports = isBuffer;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(41)(module)))

/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(6),
    isObject = __webpack_require__(3);

/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

module.exports = isFunction;


/***/ },
/* 37 */
/***/ function(module, exports) {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

module.exports = isLength;


/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(6),
    isObjectLike = __webpack_require__(9);

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && baseGetTag(value) == symbolTag);
}

module.exports = isSymbol;


/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

var arrayLikeKeys = __webpack_require__(47),
    baseKeys = __webpack_require__(124),
    isArrayLike = __webpack_require__(23);

/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}

module.exports = keys;


/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

var baseMerge = __webpack_require__(126),
    createAssigner = __webpack_require__(146);

/**
 * This method is like `_.assign` except that it recursively merges own and
 * inherited enumerable string keyed properties of source objects into the
 * destination object. Source properties that resolve to `undefined` are
 * skipped if a destination value exists. Array and plain object properties
 * are merged recursively. Other objects and value types are overridden by
 * assignment. Source objects are applied from left to right. Subsequent
 * sources overwrite property assignments of previous sources.
 *
 * **Note:** This method mutates `object`.
 *
 * @static
 * @memberOf _
 * @since 0.5.0
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} [sources] The source objects.
 * @returns {Object} Returns `object`.
 * @example
 *
 * var object = {
 *   'a': [{ 'b': 2 }, { 'd': 4 }]
 * };
 *
 * var other = {
 *   'a': [{ 'c': 3 }, { 'e': 5 }]
 * };
 *
 * _.merge(object, other);
 * // => { 'a': [{ 'b': 2, 'c': 3 }, { 'd': 4, 'e': 5 }] }
 */
var merge = createAssigner(function(object, source, srcIndex) {
  baseMerge(object, source, srcIndex);
});

module.exports = merge;


/***/ },
/* 41 */
/***/ function(module, exports) {

module.exports = function(module) {
	if(!module.webpackPolyfill) {
		module.deprecate = function() {};
		module.paths = [];
		// module.parent = undefined by default
		if(!module.children) module.children = [];
		Object.defineProperty(module, "loaded", {
			enumerable: true,
			configurable: false,
			get: function() { return module.l; }
		});
		Object.defineProperty(module, "id", {
			enumerable: true,
			configurable: false,
			get: function() { return module.i; }
		});
		module.webpackPolyfill = 1;
	}
	return module;
}


/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
/**
 * http://www.codeproject.com/Tips/407172/Connected-Component-Labeling-and-Vectorization
 */
var Tracer = {
    searchDirections: [[0, 1], [1, 1], [1, 0], [1, -1], [0, -1], [-1, -1], [-1, 0], [-1, 1]],
    create: function create(imageWrapper, labelWrapper) {
        var imageData = imageWrapper.data,
            labelData = labelWrapper.data,
            searchDirections = this.searchDirections,
            width = imageWrapper.size.x,
            pos;

        function _trace(current, color, label, edgelabel) {
            var i, y, x;

            for (i = 0; i < 7; i++) {
                y = current.cy + searchDirections[current.dir][0];
                x = current.cx + searchDirections[current.dir][1];
                pos = y * width + x;
                if (imageData[pos] === color && (labelData[pos] === 0 || labelData[pos] === label)) {
                    labelData[pos] = label;
                    current.cy = y;
                    current.cx = x;
                    return true;
                } else {
                    if (labelData[pos] === 0) {
                        labelData[pos] = edgelabel;
                    }
                    current.dir = (current.dir + 1) % 8;
                }
            }
            return false;
        }

        function vertex2D(x, y, dir) {
            return {
                dir: dir,
                x: x,
                y: y,
                next: null,
                prev: null
            };
        }

        function _contourTracing(sy, sx, label, color, edgelabel) {
            var Fv = null,
                Cv,
                P,
                ldir,
                current = {
                cx: sx,
                cy: sy,
                dir: 0
            };

            if (_trace(current, color, label, edgelabel)) {
                Fv = vertex2D(sx, sy, current.dir);
                Cv = Fv;
                ldir = current.dir;
                P = vertex2D(current.cx, current.cy, 0);
                P.prev = Cv;
                Cv.next = P;
                P.next = null;
                Cv = P;
                do {
                    current.dir = (current.dir + 6) % 8;
                    _trace(current, color, label, edgelabel);
                    if (ldir !== current.dir) {
                        Cv.dir = current.dir;
                        P = vertex2D(current.cx, current.cy, 0);
                        P.prev = Cv;
                        Cv.next = P;
                        P.next = null;
                        Cv = P;
                    } else {
                        Cv.dir = ldir;
                        Cv.x = current.cx;
                        Cv.y = current.cy;
                    }
                    ldir = current.dir;
                } while (current.cx !== sx || current.cy !== sy);
                Fv.prev = Cv.prev;
                Cv.prev.next = Fv;
            }
            return Fv;
        }

        return {
            trace: function trace(current, color, label, edgelabel) {
                return _trace(current, color, label, edgelabel);
            },
            contourTracing: function contourTracing(sy, sx, label, color, edgelabel) {
                return _contourTracing(sy, sx, label, color, edgelabel);
            }
        };
    }
};

exports.default = Tracer;

/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _barcode_reader = __webpack_require__(10);

var _barcode_reader2 = _interopRequireDefault(_barcode_reader);

var _array_helper = __webpack_require__(13);

var _array_helper2 = _interopRequireDefault(_array_helper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Code39Reader() {
    _barcode_reader2.default.call(this);
}

var properties = {
    ALPHABETH_STRING: { value: "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%" },
    ALPHABET: { value: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 45, 46, 32, 42, 36, 47, 43, 37] },
    CHARACTER_ENCODINGS: { value: [0x034, 0x121, 0x061, 0x160, 0x031, 0x130, 0x070, 0x025, 0x124, 0x064, 0x109, 0x049, 0x148, 0x019, 0x118, 0x058, 0x00D, 0x10C, 0x04C, 0x01C, 0x103, 0x043, 0x142, 0x013, 0x112, 0x052, 0x007, 0x106, 0x046, 0x016, 0x181, 0x0C1, 0x1C0, 0x091, 0x190, 0x0D0, 0x085, 0x184, 0x0C4, 0x094, 0x0A8, 0x0A2, 0x08A, 0x02A] },
    ASTERISK: { value: 0x094 },
    FORMAT: { value: "code_39", writeable: false }
};

Code39Reader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
Code39Reader.prototype.constructor = Code39Reader;

Code39Reader.prototype._toCounters = function (start, counter) {
    var self = this,
        numCounters = counter.length,
        end = self._row.length,
        isWhite = !self._row[start],
        i,
        counterPos = 0;

    _array_helper2.default.init(counter, 0);

    for (i = start; i < end; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            counterPos++;
            if (counterPos === numCounters) {
                break;
            } else {
                counter[counterPos] = 1;
                isWhite = !isWhite;
            }
        }
    }

    return counter;
};

Code39Reader.prototype._decode = function () {
    var self = this,
        counters = [0, 0, 0, 0, 0, 0, 0, 0, 0],
        result = [],
        start = self._findStart(),
        decodedChar,
        lastStart,
        pattern,
        nextStart;

    if (!start) {
        return null;
    }
    nextStart = self._nextSet(self._row, start.end);

    do {
        counters = self._toCounters(nextStart, counters);
        pattern = self._toPattern(counters);
        if (pattern < 0) {
            return null;
        }
        decodedChar = self._patternToChar(pattern);
        if (decodedChar < 0) {
            return null;
        }
        result.push(decodedChar);
        lastStart = nextStart;
        nextStart += _array_helper2.default.sum(counters);
        nextStart = self._nextSet(self._row, nextStart);
    } while (decodedChar !== '*');
    result.pop();

    if (!result.length) {
        return null;
    }

    if (!self._verifyTrailingWhitespace(lastStart, nextStart, counters)) {
        return null;
    }

    return {
        code: result.join(""),
        start: start.start,
        end: nextStart,
        startInfo: start,
        decodedCodes: result
    };
};

Code39Reader.prototype._verifyTrailingWhitespace = function (lastStart, nextStart, counters) {
    var trailingWhitespaceEnd,
        patternSize = _array_helper2.default.sum(counters);

    trailingWhitespaceEnd = nextStart - lastStart - patternSize;
    if (trailingWhitespaceEnd * 3 >= patternSize) {
        return true;
    }
    return false;
};

Code39Reader.prototype._patternToChar = function (pattern) {
    var i,
        self = this;

    for (i = 0; i < self.CHARACTER_ENCODINGS.length; i++) {
        if (self.CHARACTER_ENCODINGS[i] === pattern) {
            return String.fromCharCode(self.ALPHABET[i]);
        }
    }
    return -1;
};

Code39Reader.prototype._findNextWidth = function (counters, current) {
    var i,
        minWidth = Number.MAX_VALUE;

    for (i = 0; i < counters.length; i++) {
        if (counters[i] < minWidth && counters[i] > current) {
            minWidth = counters[i];
        }
    }

    return minWidth;
};

Code39Reader.prototype._toPattern = function (counters) {
    var numCounters = counters.length,
        maxNarrowWidth = 0,
        numWideBars = numCounters,
        wideBarWidth = 0,
        self = this,
        pattern,
        i;

    while (numWideBars > 3) {
        maxNarrowWidth = self._findNextWidth(counters, maxNarrowWidth);
        numWideBars = 0;
        pattern = 0;
        for (i = 0; i < numCounters; i++) {
            if (counters[i] > maxNarrowWidth) {
                pattern |= 1 << numCounters - 1 - i;
                numWideBars++;
                wideBarWidth += counters[i];
            }
        }

        if (numWideBars === 3) {
            for (i = 0; i < numCounters && numWideBars > 0; i++) {
                if (counters[i] > maxNarrowWidth) {
                    numWideBars--;
                    if (counters[i] * 2 >= wideBarWidth) {
                        return -1;
                    }
                }
            }
            return pattern;
        }
    }
    return -1;
};

Code39Reader.prototype._findStart = function () {
    var self = this,
        offset = self._nextSet(self._row),
        patternStart = offset,
        counter = [0, 0, 0, 0, 0, 0, 0, 0, 0],
        counterPos = 0,
        isWhite = false,
        i,
        j,
        whiteSpaceMustStart;

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                // find start pattern
                if (self._toPattern(counter) === self.ASTERISK) {
                    whiteSpaceMustStart = Math.floor(Math.max(0, patternStart - (i - patternStart) / 4));
                    if (self._matchRange(whiteSpaceMustStart, patternStart, 0)) {
                        return {
                            start: patternStart,
                            end: i
                        };
                    }
                }

                patternStart += counter[0] + counter[1];
                for (j = 0; j < 7; j++) {
                    counter[j] = counter[j + 2];
                }
                counter[7] = 0;
                counter[8] = 0;
                counterPos--;
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

exports.default = Code39Reader;

/***/ },
/* 44 */
/***/ function(module, exports) {

module.exports = dot

/**
 * Calculates the dot product of two vec2's
 *
 * @param {vec2} a the first operand
 * @param {vec2} b the second operand
 * @returns {Number} dot product of a and b
 */
function dot(a, b) {
    return a[0] * b[0] + a[1] * b[1]
}

/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

var mapCacheClear = __webpack_require__(171),
    mapCacheDelete = __webpack_require__(172),
    mapCacheGet = __webpack_require__(173),
    mapCacheHas = __webpack_require__(174),
    mapCacheSet = __webpack_require__(175);

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

module.exports = MapCache;


/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

var ListCache = __webpack_require__(15),
    stackClear = __webpack_require__(185),
    stackDelete = __webpack_require__(186),
    stackGet = __webpack_require__(187),
    stackHas = __webpack_require__(188),
    stackSet = __webpack_require__(189);

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new ListCache(entries);
  this.size = data.size;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

module.exports = Stack;


/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

var baseTimes = __webpack_require__(134),
    isArguments = __webpack_require__(22),
    isArray = __webpack_require__(2),
    isBuffer = __webpack_require__(35),
    isIndex = __webpack_require__(18),
    isTypedArray = __webpack_require__(68);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray(value),
      isArg = !isArr && isArguments(value),
      isBuff = !isArr && !isArg && isBuffer(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

module.exports = arrayLikeKeys;


/***/ },
/* 48 */
/***/ function(module, exports) {

/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

module.exports = arrayMap;


/***/ },
/* 49 */
/***/ function(module, exports) {

/**
 * A specialized version of `_.reduce` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {*} [accumulator] The initial value.
 * @param {boolean} [initAccum] Specify using the first element of `array` as
 *  the initial value.
 * @returns {*} Returns the accumulated value.
 */
function arrayReduce(array, iteratee, accumulator, initAccum) {
  var index = -1,
      length = array == null ? 0 : array.length;

  if (initAccum && length) {
    accumulator = array[++index];
  }
  while (++index < length) {
    accumulator = iteratee(accumulator, array[index], index, array);
  }
  return accumulator;
}

module.exports = arrayReduce;


/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

var baseAssignValue = __webpack_require__(30),
    eq = __webpack_require__(21);

/**
 * This function is like `assignValue` except that it doesn't assign
 * `undefined` values.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignMergeValue(object, key, value) {
  if ((value !== undefined && !eq(object[key], value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

module.exports = assignMergeValue;


/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

var castPath = __webpack_require__(7),
    toKey = __webpack_require__(20);

/**
 * The base implementation of `_.get` without support for default values.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @returns {*} Returns the resolved value.
 */
function baseGet(object, path) {
  path = castPath(path, object);

  var index = 0,
      length = path.length;

  while (object != null && index < length) {
    object = object[toKey(path[index++])];
  }
  return (index && index == length) ? object : undefined;
}

module.exports = baseGet;


/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

var arrayPush = __webpack_require__(28),
    isArray = __webpack_require__(2);

/**
 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @param {Function} symbolsFunc The function to get the symbols of `object`.
 * @returns {Array} Returns the array of property names and symbols.
 */
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
}

module.exports = baseGetAllKeys;


/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var root = __webpack_require__(1);

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined,
    allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined;

/**
 * Creates a clone of  `buffer`.
 *
 * @private
 * @param {Buffer} buffer The buffer to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Buffer} Returns the cloned buffer.
 */
function cloneBuffer(buffer, isDeep) {
  if (isDeep) {
    return buffer.slice();
  }
  var length = buffer.length,
      result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);

  buffer.copy(result);
  return result;
}

module.exports = cloneBuffer;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(41)(module)))

/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

var cloneArrayBuffer = __webpack_require__(31);

/**
 * Creates a clone of `typedArray`.
 *
 * @private
 * @param {Object} typedArray The typed array to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned typed array.
 */
function cloneTypedArray(typedArray, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}

module.exports = cloneTypedArray;


/***/ },
/* 55 */
/***/ function(module, exports) {

/**
 * Copies the values of `source` to `array`.
 *
 * @private
 * @param {Array} source The array to copy values from.
 * @param {Array} [array=[]] The array to copy values to.
 * @returns {Array} Returns `array`.
 */
function copyArray(source, array) {
  var index = -1,
      length = source.length;

  array || (array = Array(length));
  while (++index < length) {
    array[index] = source[index];
  }
  return array;
}

module.exports = copyArray;


/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4);

var defineProperty = (function() {
  try {
    var func = getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}());

module.exports = defineProperty;


/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

var flatten = __webpack_require__(192),
    overRest = __webpack_require__(63),
    setToString = __webpack_require__(64);

/**
 * A specialized version of `baseRest` which flattens the rest array.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @returns {Function} Returns the new function.
 */
function flatRest(func) {
  return setToString(overRest(func, undefined, flatten), func + '');
}

module.exports = flatRest;


/***/ },
/* 58 */
/***/ function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

module.exports = freeGlobal;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(70)))

/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

var baseGetAllKeys = __webpack_require__(52),
    getSymbolsIn = __webpack_require__(60),
    keysIn = __webpack_require__(24);

/**
 * Creates an array of own and inherited enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeysIn(object) {
  return baseGetAllKeys(object, keysIn, getSymbolsIn);
}

module.exports = getAllKeysIn;


/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

var arrayPush = __webpack_require__(28),
    getPrototype = __webpack_require__(32),
    getSymbols = __webpack_require__(33),
    stubArray = __webpack_require__(69);

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own and inherited enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
  var result = [];
  while (object) {
    arrayPush(result, getSymbols(object));
    object = getPrototype(object);
  }
  return result;
};

module.exports = getSymbolsIn;


/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

var baseCreate = __webpack_require__(117),
    getPrototype = __webpack_require__(32),
    isPrototype = __webpack_require__(34);

/**
 * Initializes an object clone.
 *
 * @private
 * @param {Object} object The object to clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneObject(object) {
  return (typeof object.constructor == 'function' && !isPrototype(object))
    ? baseCreate(getPrototype(object))
    : {};
}

module.exports = initCloneObject;


/***/ },
/* 62 */
/***/ function(module, exports) {

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

module.exports = overArg;


/***/ },
/* 63 */
/***/ function(module, exports, __webpack_require__) {

var apply = __webpack_require__(111);

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * A specialized version of `baseRest` which transforms the rest array.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @param {Function} transform The rest array transform.
 * @returns {Function} Returns the new function.
 */
function overRest(func, start, transform) {
  start = nativeMax(start === undefined ? (func.length - 1) : start, 0);
  return function() {
    var args = arguments,
        index = -1,
        length = nativeMax(args.length - start, 0),
        array = Array(length);

    while (++index < length) {
      array[index] = args[start + index];
    }
    index = -1;
    var otherArgs = Array(start + 1);
    while (++index < start) {
      otherArgs[index] = args[index];
    }
    otherArgs[start] = transform(array);
    return apply(func, this, otherArgs);
  };
}

module.exports = overRest;


/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

var baseSetToString = __webpack_require__(132),
    shortOut = __webpack_require__(184);

/**
 * Sets the `toString` method of `func` to return `string`.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var setToString = shortOut(baseSetToString);

module.exports = setToString;


/***/ },
/* 65 */
/***/ function(module, exports) {

/** Used for built-in method references. */
var funcProto = Function.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

module.exports = toSource;


/***/ },
/* 66 */
/***/ function(module, exports) {

/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}

module.exports = identity;


/***/ },
/* 67 */
/***/ function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(6),
    getPrototype = __webpack_require__(32),
    isObjectLike = __webpack_require__(9);

/** `Object#toString` result references. */
var objectTag = '[object Object]';

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to infer the `Object` constructor. */
var objectCtorString = funcToString.call(Object);

/**
 * Checks if `value` is a plain object, that is, an object created by the
 * `Object` constructor or one with a `[[Prototype]]` of `null`.
 *
 * @static
 * @memberOf _
 * @since 0.8.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * _.isPlainObject(new Foo);
 * // => false
 *
 * _.isPlainObject([1, 2, 3]);
 * // => false
 *
 * _.isPlainObject({ 'x': 0, 'y': 0 });
 * // => true
 *
 * _.isPlainObject(Object.create(null));
 * // => true
 */
function isPlainObject(value) {
  if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
    return false;
  }
  var proto = getPrototype(value);
  if (proto === null) {
    return true;
  }
  var Ctor = hasOwnProperty.call(proto, 'constructor') && proto.constructor;
  return typeof Ctor == 'function' && Ctor instanceof Ctor &&
    funcToString.call(Ctor) == objectCtorString;
}

module.exports = isPlainObject;


/***/ },
/* 68 */
/***/ function(module, exports, __webpack_require__) {

var baseIsTypedArray = __webpack_require__(123),
    baseUnary = __webpack_require__(136),
    nodeUtil = __webpack_require__(180);

/* Node.js helper references. */
var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

module.exports = isTypedArray;


/***/ },
/* 69 */
/***/ function(module, exports) {

/**
 * This method returns a new empty array.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {Array} Returns the new empty array.
 * @example
 *
 * var arrays = _.times(2, _.stubArray);
 *
 * console.log(arrays);
 * // => [[], []]
 *
 * console.log(arrays[0] === arrays[1]);
 * // => false
 */
function stubArray() {
  return [];
}

module.exports = stubArray;


/***/ },
/* 70 */
/***/ function(module, exports) {

var g;

// This works in non-strict mode
g = (function() { return this; })();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ },
/* 71 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _merge2 = __webpack_require__(40);

var _merge3 = _interopRequireDefault(_merge2);

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // eslint-disable-line no-unused-vars
// eslint-disable-line no-unused-vars


var _typedefs = __webpack_require__(79);

var _typedefs2 = _interopRequireDefault(_typedefs);

var _webrtcAdapter = __webpack_require__(203);

var _webrtcAdapter2 = _interopRequireDefault(_webrtcAdapter);

var _image_wrapper = __webpack_require__(26);

var _image_wrapper2 = _interopRequireDefault(_image_wrapper);

var _barcode_locator = __webpack_require__(85);

var _barcode_locator2 = _interopRequireDefault(_barcode_locator);

var _barcode_decoder = __webpack_require__(82);

var _barcode_decoder2 = _interopRequireDefault(_barcode_decoder);

var _events = __webpack_require__(76);

var _events2 = _interopRequireDefault(_events);

var _camera_access = __webpack_require__(84);

var _camera_access2 = _interopRequireDefault(_camera_access);

var _image_debug = __webpack_require__(14);

var _image_debug2 = _interopRequireDefault(_image_debug);

var _result_collector = __webpack_require__(74);

var _result_collector2 = _interopRequireDefault(_result_collector);

var _config2 = __webpack_require__(80);

var _config3 = _interopRequireDefault(_config2);

var _input_stream = __webpack_require__(73);

var _input_stream2 = _interopRequireDefault(_input_stream);

var _frame_grabber = __webpack_require__(72);

var _frame_grabber2 = _interopRequireDefault(_frame_grabber);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var vec2 = {
    clone: __webpack_require__(11)
};

var _inputStream,
    _framegrabber,
    _stopped,
    _canvasContainer = {
    ctx: {
        image: null,
        overlay: null
    },
    dom: {
        image: null,
        overlay: null
    }
},
    _inputImageWrapper,
    _boxSize,
    _decoder,
    _workerPool = [],
    _onUIThread = true,
    _resultCollector,
    _config = {};

function initializeData(imageWrapper) {
    initBuffers(imageWrapper);
    _decoder = _barcode_decoder2.default.create(_config.decoder, _inputImageWrapper);
}

function initInputStream(cb) {
    var video;
    if (_config.inputStream.type === "VideoStream") {
        video = document.createElement("video");
        _inputStream = _input_stream2.default.createVideoStream(video);
    } else if (_config.inputStream.type === "ImageStream") {
        _inputStream = _input_stream2.default.createImageStream();
    } else if (_config.inputStream.type === "LiveStream") {
        var $viewport = getViewPort();
        if ($viewport) {
            video = $viewport.querySelector("video");
            if (!video) {
                video = document.createElement("video");
                $viewport.appendChild(video);
            }
        }
        _inputStream = _input_stream2.default.createLiveStream(video);
        _camera_access2.default.request(video, _config.inputStream.constraints).then(function () {
            _inputStream.trigger("canrecord");
        }).catch(function (err) {
            return cb(err);
        });
    }

    _inputStream.setAttribute("preload", "auto");
    _inputStream.setInputStream(_config.inputStream);
    _inputStream.addEventListener("canrecord", canRecord.bind(undefined, cb));
}

function getViewPort() {
    var target = _config.inputStream.target;
    // Check if target is already a DOM element
    if (target && target.nodeName && target.nodeType === 1) {
        return target;
    } else {
        // Use '#interactive.viewport' as a fallback selector (backwards compatibility)
        var selector = typeof target === 'string' ? target : '#interactive.viewport';
        return document.querySelector(selector);
    }
}

function canRecord(cb) {
    _barcode_locator2.default.checkImageConstraints(_inputStream, _config.locator);
    initCanvas(_config);
    _framegrabber = _frame_grabber2.default.create(_inputStream, _canvasContainer.dom.image);

    adjustWorkerPool(_config.numOfWorkers, function () {
        if (_config.numOfWorkers === 0) {
            initializeData();
        }
        ready(cb);
    });
}

function ready(cb) {
    _inputStream.play();
    cb();
}

function initCanvas() {
    if (typeof document !== "undefined") {
        var $viewport = getViewPort();
        _canvasContainer.dom.image = document.querySelector("canvas.imgBuffer");
        if (!_canvasContainer.dom.image) {
            _canvasContainer.dom.image = document.createElement("canvas");
            _canvasContainer.dom.image.className = "imgBuffer";
            if ($viewport && _config.inputStream.type === "ImageStream") {
                $viewport.appendChild(_canvasContainer.dom.image);
            }
        }
        _canvasContainer.ctx.image = _canvasContainer.dom.image.getContext("2d");
        _canvasContainer.dom.image.width = _inputStream.getCanvasSize().x;
        _canvasContainer.dom.image.height = _inputStream.getCanvasSize().y;

        _canvasContainer.dom.overlay = document.querySelector("canvas.drawingBuffer");
        if (!_canvasContainer.dom.overlay) {
            _canvasContainer.dom.overlay = document.createElement("canvas");
            _canvasContainer.dom.overlay.className = "drawingBuffer";
            if ($viewport) {
                $viewport.appendChild(_canvasContainer.dom.overlay);
            }
            var clearFix = document.createElement("br");
            clearFix.setAttribute("clear", "all");
            if ($viewport) {
                $viewport.appendChild(clearFix);
            }
        }
        _canvasContainer.ctx.overlay = _canvasContainer.dom.overlay.getContext("2d");
        _canvasContainer.dom.overlay.width = _inputStream.getCanvasSize().x;
        _canvasContainer.dom.overlay.height = _inputStream.getCanvasSize().y;
    }
}

function initBuffers(imageWrapper) {
    if (imageWrapper) {
        _inputImageWrapper = imageWrapper;
    } else {
        _inputImageWrapper = new _image_wrapper2.default({
            x: _inputStream.getWidth(),
            y: _inputStream.getHeight()
        });
    }

    if (false) {
        console.log(_inputImageWrapper.size);
    }
    _boxSize = [vec2.clone([0, 0]), vec2.clone([0, _inputImageWrapper.size.y]), vec2.clone([_inputImageWrapper.size.x, _inputImageWrapper.size.y]), vec2.clone([_inputImageWrapper.size.x, 0])];
    _barcode_locator2.default.init(_inputImageWrapper, _config.locator);
}

function getBoundingBoxes() {
    if (_config.locate) {
        return _barcode_locator2.default.locate();
    } else {
        return [[vec2.clone(_boxSize[0]), vec2.clone(_boxSize[1]), vec2.clone(_boxSize[2]), vec2.clone(_boxSize[3])]];
    }
}

function transformResult(result) {
    var topRight = _inputStream.getTopRight(),
        xOffset = topRight.x,
        yOffset = topRight.y,
        i;

    if (xOffset === 0 && yOffset === 0) {
        return;
    }

    if (result.barcodes) {
        for (i = 0; i < result.barcodes.length; i++) {
            transformResult(result.barcodes[i]);
        }
    }

    if (result.line && result.line.length === 2) {
        moveLine(result.line);
    }

    if (result.box) {
        moveBox(result.box);
    }

    if (result.boxes && result.boxes.length > 0) {
        for (i = 0; i < result.boxes.length; i++) {
            moveBox(result.boxes[i]);
        }
    }

    function moveBox(box) {
        var corner = box.length;

        while (corner--) {
            box[corner][0] += xOffset;
            box[corner][1] += yOffset;
        }
    }

    function moveLine(line) {
        line[0].x += xOffset;
        line[0].y += yOffset;
        line[1].x += xOffset;
        line[1].y += yOffset;
    }
}

function addResult(result, imageData) {
    if (!imageData || !_resultCollector) {
        return;
    }

    if (result.barcodes) {
        result.barcodes.filter(function (barcode) {
            return barcode.codeResult;
        }).forEach(function (barcode) {
            return addResult(barcode, imageData);
        });
    } else if (result.codeResult) {
        _resultCollector.addResult(imageData, _inputStream.getCanvasSize(), result.codeResult);
    }
}

function hasCodeResult(result) {
    return result && (result.barcodes ? result.barcodes.some(function (barcode) {
        return barcode.codeResult;
    }) : result.codeResult);
}

function publishResult(result, imageData) {
    var resultToPublish = result;

    if (result && _onUIThread) {
        transformResult(result);
        addResult(result, imageData);
        resultToPublish = result.barcodes || result;
    }

    _events2.default.publish("processed", resultToPublish);
    if (hasCodeResult(result)) {
        _events2.default.publish("detected", resultToPublish);
    }
}

function locateAndDecode() {
    var result, boxes;

    boxes = getBoundingBoxes();
    if (boxes) {
        result = _decoder.decodeFromBoundingBoxes(boxes);
        result = result || {};
        result.boxes = boxes;
        publishResult(result, _inputImageWrapper.data);
    } else {
        publishResult();
    }
}

function update() {
    var availableWorker;

    if (_onUIThread) {
        if (_workerPool.length > 0) {
            availableWorker = _workerPool.filter(function (workerThread) {
                return !workerThread.busy;
            })[0];
            if (availableWorker) {
                _framegrabber.attachData(availableWorker.imageData);
            } else {
                return; // all workers are busy
            }
        } else {
            _framegrabber.attachData(_inputImageWrapper.data);
        }
        if (_framegrabber.grab()) {
            if (availableWorker) {
                availableWorker.busy = true;
                availableWorker.worker.postMessage({
                    cmd: 'process',
                    imageData: availableWorker.imageData
                }, [availableWorker.imageData.buffer]);
            } else {
                locateAndDecode();
            }
        }
    } else {
        locateAndDecode();
    }
}

function startContinuousUpdate() {
    var next = null,
        delay = 1000 / (_config.frequency || 60);

    _stopped = false;
    (function frame(timestamp) {
        next = next || timestamp;
        if (!_stopped) {
            if (timestamp >= next) {
                next += delay;
                update();
            }
            window.requestAnimFrame(frame);
        }
    })(performance.now());
}

function _start() {
    if (_onUIThread && _config.inputStream.type === "LiveStream") {
        startContinuousUpdate();
    } else {
        update();
    }
}

function initWorker(cb) {
    var blobURL,
        workerThread = {
        worker: undefined,
        imageData: new Uint8Array(_inputStream.getWidth() * _inputStream.getHeight()),
        busy: true
    };

    blobURL = generateWorkerBlob();
    workerThread.worker = new Worker(blobURL);

    workerThread.worker.onmessage = function (e) {
        if (e.data.event === 'initialized') {
            URL.revokeObjectURL(blobURL);
            workerThread.busy = false;
            workerThread.imageData = new Uint8Array(e.data.imageData);
            if (false) {
                console.log("Worker initialized");
            }
            return cb(workerThread);
        } else if (e.data.event === 'processed') {
            workerThread.imageData = new Uint8Array(e.data.imageData);
            workerThread.busy = false;
            publishResult(e.data.result, workerThread.imageData);
        } else if (e.data.event === 'error') {
            if (false) {
                console.log("Worker error: " + e.data.message);
            }
        }
    };

    workerThread.worker.postMessage({
        cmd: 'init',
        size: { x: _inputStream.getWidth(), y: _inputStream.getHeight() },
        imageData: workerThread.imageData,
        config: configForWorker(_config)
    }, [workerThread.imageData.buffer]);
}

function configForWorker(config) {
    return _extends({}, config, {
        inputStream: _extends({}, config.inputStream, {
            target: null
        })
    });
}

function workerInterface(factory) {
    /* eslint-disable no-undef*/
    if (factory) {
        var Quagga = factory().default;
        if (!Quagga) {
            self.postMessage({ 'event': 'error', message: 'Quagga could not be created' });
            return;
        }
    }
    var imageWrapper;

    self.onmessage = function (e) {
        if (e.data.cmd === 'init') {
            var config = e.data.config;
            config.numOfWorkers = 0;
            imageWrapper = new Quagga.ImageWrapper({
                x: e.data.size.x,
                y: e.data.size.y
            }, new Uint8Array(e.data.imageData));
            Quagga.init(config, ready, imageWrapper);
            Quagga.onProcessed(onProcessed);
        } else if (e.data.cmd === 'process') {
            imageWrapper.data = new Uint8Array(e.data.imageData);
            Quagga.start();
        } else if (e.data.cmd === 'setReaders') {
            Quagga.setReaders(e.data.readers);
        }
    };

    function onProcessed(result) {
        self.postMessage({
            'event': 'processed',
            imageData: imageWrapper.data,
            result: result
        }, [imageWrapper.data.buffer]);
    }

    function ready() {
        // eslint-disable-line
        self.postMessage({ 'event': 'initialized', imageData: imageWrapper.data }, [imageWrapper.data.buffer]);
    }

    /* eslint-enable */
}

function generateWorkerBlob() {
    var blob, factorySource;

    /* jshint ignore:start */
    if (typeof __factorySource__ !== 'undefined') {
        factorySource = __factorySource__; // eslint-disable-line no-undef
    }
    /* jshint ignore:end */

    blob = new Blob(['(' + workerInterface.toString() + ')(' + factorySource + ');'], { type: 'text/javascript' });

    return window.URL.createObjectURL(blob);
}

function _setReaders(readers) {
    if (_decoder) {
        _decoder.setReaders(readers);
    } else if (_onUIThread && _workerPool.length > 0) {
        _workerPool.forEach(function (workerThread) {
            workerThread.worker.postMessage({ cmd: 'setReaders', readers: readers });
        });
    }
}

function adjustWorkerPool(capacity, cb) {
    var increaseBy = capacity - _workerPool.length;
    if (increaseBy === 0) {
        return cb && cb();
    }
    if (increaseBy < 0) {
        var workersToTerminate = _workerPool.slice(increaseBy);
        workersToTerminate.forEach(function (workerThread) {
            workerThread.worker.terminate();
            if (false) {
                console.log("Worker terminated!");
            }
        });
        _workerPool = _workerPool.slice(0, increaseBy);
        return cb && cb();
    } else {
        var workerInitialized = function workerInitialized(workerThread) {
            _workerPool.push(workerThread);
            if (_workerPool.length >= capacity) {
                cb && cb();
            }
        };

        for (var i = 0; i < increaseBy; i++) {
            initWorker(workerInitialized);
        }
    }
}

exports.default = {
    init: function init(config, cb, imageWrapper) {
        _config = (0, _merge3.default)({}, _config3.default, config);
        if (imageWrapper) {
            _onUIThread = false;
            initializeData(imageWrapper);
            return cb();
        } else {
            initInputStream(cb);
        }
    },
    start: function start() {
        _start();
    },
    stop: function stop() {
        _stopped = true;
        adjustWorkerPool(0);
        if (_config.inputStream.type === "LiveStream") {
            _camera_access2.default.release();
            _inputStream.clearEventHandlers();
        }
    },
    pause: function pause() {
        _stopped = true;
    },
    onDetected: function onDetected(callback) {
        _events2.default.subscribe("detected", callback);
    },
    offDetected: function offDetected(callback) {
        _events2.default.unsubscribe("detected", callback);
    },
    onProcessed: function onProcessed(callback) {
        _events2.default.subscribe("processed", callback);
    },
    offProcessed: function offProcessed(callback) {
        _events2.default.unsubscribe("processed", callback);
    },
    setReaders: function setReaders(readers) {
        _setReaders(readers);
    },
    registerResultCollector: function registerResultCollector(resultCollector) {
        if (resultCollector && typeof resultCollector.addResult === 'function') {
            _resultCollector = resultCollector;
        }
    },
    canvas: _canvasContainer,
    decodeSingle: function decodeSingle(config, resultCallback) {
        var _this = this;

        config = (0, _merge3.default)({
            inputStream: {
                type: "ImageStream",
                sequence: false,
                size: 800,
                src: config.src
            },
            numOfWorkers:  false ? 0 : 1,
            locator: {
                halfSample: false
            }
        }, config);
        this.init(config, function () {
            _events2.default.once("processed", function (result) {
                _this.stop();
                resultCallback.call(null, result);
            }, true);
            _start();
        });
    },
    ImageWrapper: _image_wrapper2.default,
    ImageDebug: _image_debug2.default,
    ResultCollector: _result_collector2.default,
    CameraAccess: _camera_access2.default
};

/***/ },
/* 72 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


var CVUtils = __webpack_require__(25),
    Ndarray = __webpack_require__(212),
    Interp2D = __webpack_require__(213).d2;

var FrameGrabber = {};

FrameGrabber.create = function (inputStream) {
    var _that = {},
        _streamConfig = inputStream.getConfig(),
        _video_size = CVUtils.imageRef(inputStream.getRealWidth(), inputStream.getRealHeight()),
        _canvasSize = inputStream.getCanvasSize(),
        _size = CVUtils.imageRef(inputStream.getWidth(), inputStream.getHeight()),
        _topRight = inputStream.getTopRight(),
        _data = new Uint8Array(_size.x * _size.y),
        _grayData = new Uint8Array(_video_size.x * _video_size.y),
        _canvasData = new Uint8Array(_canvasSize.x * _canvasSize.y),
        _grayImageArray = Ndarray(_grayData, [_video_size.y, _video_size.x]).transpose(1, 0),
        _canvasImageArray = Ndarray(_canvasData, [_canvasSize.y, _canvasSize.x]).transpose(1, 0),
        _targetImageArray = _canvasImageArray.hi(_topRight.x + _size.x, _topRight.y + _size.y).lo(_topRight.x, _topRight.y),
        _stepSizeX = _video_size.x / _canvasSize.x,
        _stepSizeY = _video_size.y / _canvasSize.y;

    console.log("FrameGrabber", JSON.stringify({
        videoSize: _grayImageArray.shape,
        canvasSize: _canvasImageArray.shape,
        stepSize: [_stepSizeX, _stepSizeY],
        size: _targetImageArray.shape,
        topRight: _topRight
    }));

    /**
     * Uses the given array as frame-buffer
     */
    _that.attachData = function (data) {
        _data = data;
    };

    /**
     * Returns the used frame-buffer
     */
    _that.getData = function () {
        return _data;
    };

    /**
     * Fetches a frame from the input-stream and puts into the frame-buffer.
     * The image-data is converted to gray-scale and then half-sampled if configured.
     */
    _that.grab = function () {
        var frame = inputStream.getFrame();

        if (frame) {
            this.scaleAndCrop(frame);
            return true;
        } else {
            return false;
        }
    };

    _that.scaleAndCrop = function (frame) {
        var x, y;

        // 1. compute full-sized gray image
        CVUtils.computeGray(frame.data, _grayData);

        // 2. interpolate
        for (y = 0; y < _canvasSize.y; y++) {
            for (x = 0; x < _canvasSize.x; x++) {
                _canvasImageArray.set(x, y, Interp2D(_grayImageArray, x * _stepSizeX, y * _stepSizeY) | 0);
            }
        }

        // targetImageArray must be equal to targetSize
        if (_targetImageArray.shape[0] !== _size.x || _targetImageArray.shape[1] !== _size.y) {
            throw new Error("Shapes do not match!");
        }

        // 3. crop
        for (y = 0; y < _size.y; y++) {
            for (x = 0; x < _size.x; x++) {
                _data[y * _size.x + x] = _targetImageArray.get(x, y);
            }
        }
    }, _that.getSize = function () {
        return _size;
    };

    return _that;
};

module.exports = FrameGrabber;

/***/ },
/* 73 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


var GetPixels = __webpack_require__(211);

var InputStream = {};

InputStream.createImageStream = function () {
    var that = {};
    var _config = null;

    var width = 0,
        height = 0,
        frameIdx = 0,
        paused = true,
        loaded = false,
        frame = null,
        baseUrl,
        ended = false,
        size,
        calculatedWidth,
        calculatedHeight,
        _eventNames = ['canrecord', 'ended'],
        _eventHandlers = {},
        _topRight = { x: 0, y: 0 },
        _canvasSize = { x: 0, y: 0 };

    function loadImages() {
        loaded = false;
        GetPixels(baseUrl, function (err, pixels) {
            if (err) {
                console.log(err);
                exit(1);
            }
            loaded = true;
            console.log(pixels.shape);
            frame = pixels;
            width = pixels.shape[0];
            height = pixels.shape[1];
            calculatedWidth = _config.size ? width / height > 1 ? _config.size : Math.floor(width / height * _config.size) : width;
            calculatedHeight = _config.size ? width / height > 1 ? Math.floor(height / width * _config.size) : _config.size : height;

            _canvasSize.x = calculatedWidth;
            _canvasSize.y = calculatedHeight;

            setTimeout(function () {
                publishEvent("canrecord", []);
            }, 0);
        });
    }

    function publishEvent(eventName, args) {
        var j,
            handlers = _eventHandlers[eventName];

        if (handlers && handlers.length > 0) {
            for (j = 0; j < handlers.length; j++) {
                handlers[j].apply(that, args);
            }
        }
    }

    that.trigger = publishEvent;

    that.getWidth = function () {
        return calculatedWidth;
    };

    that.getHeight = function () {
        return calculatedHeight;
    };

    that.setWidth = function (width) {
        calculatedWidth = width;
    };

    that.setHeight = function (height) {
        calculatedHeight = height;
    };

    that.getRealWidth = function () {
        return width;
    };

    that.getRealHeight = function () {
        return height;
    };

    that.setInputStream = function (stream) {
        _config = stream;
        baseUrl = _config.src;
        size = 1;
        loadImages();
    };

    that.ended = function () {
        return ended;
    };

    that.setAttribute = function () {};

    that.getConfig = function () {
        return _config;
    };

    that.pause = function () {
        paused = true;
    };

    that.play = function () {
        paused = false;
    };

    that.setCurrentTime = function (time) {
        frameIdx = time;
    };

    that.addEventListener = function (event, f) {
        if (_eventNames.indexOf(event) !== -1) {
            if (!_eventHandlers[event]) {
                _eventHandlers[event] = [];
            }
            _eventHandlers[event].push(f);
        }
    };

    that.setTopRight = function (topRight) {
        _topRight.x = topRight.x;
        _topRight.y = topRight.y;
    };

    that.getTopRight = function () {
        return _topRight;
    };

    that.setCanvasSize = function (size) {
        _canvasSize.x = size.x;
        _canvasSize.y = size.y;
    };

    that.getCanvasSize = function () {
        return _canvasSize;
    };

    that.getFrame = function () {
        if (!loaded) {
            return null;
        }
        return frame;
    };

    return that;
};

module.exports = InputStream;

/***/ },
/* 74 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _image_debug = __webpack_require__(14);

var _image_debug2 = _interopRequireDefault(_image_debug);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function contains(codeResult, list) {
    if (list) {
        return list.some(function (item) {
            return Object.keys(item).every(function (key) {
                return item[key] === codeResult[key];
            });
        });
    }
    return false;
}

function passesFilter(codeResult, filter) {
    if (typeof filter === 'function') {
        return filter(codeResult);
    }
    return true;
}

exports.default = {
    create: function create(config) {
        var canvas = document.createElement("canvas"),
            ctx = canvas.getContext("2d"),
            results = [],
            capacity = config.capacity || 20,
            capture = config.capture === true;

        function matchesConstraints(codeResult) {
            return capacity && codeResult && !contains(codeResult, config.blacklist) && passesFilter(codeResult, config.filter);
        }

        return {
            addResult: function addResult(data, imageSize, codeResult) {
                var result = {};

                if (matchesConstraints(codeResult)) {
                    capacity--;
                    result.codeResult = codeResult;
                    if (capture) {
                        canvas.width = imageSize.x;
                        canvas.height = imageSize.y;
                        _image_debug2.default.drawImage(data, imageSize, ctx);
                        result.frame = canvas.toDataURL();
                    }
                    results.push(result);
                }
            },
            getResults: function getResults() {
                return results;
            }
        };
    }
};

/***/ },
/* 75 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
var vec2 = {
    clone: __webpack_require__(11),
    dot: __webpack_require__(44)
};
/**
 * Creates a cluster for grouping similar orientations of datapoints
 */
exports.default = {
    create: function create(point, threshold) {
        var points = [],
            center = {
            rad: 0,
            vec: vec2.clone([0, 0])
        },
            pointMap = {};

        function init() {
            _add(point);
            updateCenter();
        }

        function _add(pointToAdd) {
            pointMap[pointToAdd.id] = pointToAdd;
            points.push(pointToAdd);
        }

        function updateCenter() {
            var i,
                sum = 0;
            for (i = 0; i < points.length; i++) {
                sum += points[i].rad;
            }
            center.rad = sum / points.length;
            center.vec = vec2.clone([Math.cos(center.rad), Math.sin(center.rad)]);
        }

        init();

        return {
            add: function add(pointToAdd) {
                if (!pointMap[pointToAdd.id]) {
                    _add(pointToAdd);
                    updateCenter();
                }
            },
            fits: function fits(otherPoint) {
                // check cosine similarity to center-angle
                var similarity = Math.abs(vec2.dot(otherPoint.point.vec, center.vec));
                if (similarity > threshold) {
                    return true;
                }
                return false;
            },
            getPoints: function getPoints() {
                return points;
            },
            getCenter: function getCenter() {
                return center;
            }
        };
    },
    createPoint: function createPoint(newPoint, id, property) {
        return {
            rad: newPoint[property],
            point: newPoint,
            id: id
        };
    }
};

/***/ },
/* 76 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

exports.default = function () {
    var events = {};

    function getEvent(eventName) {
        if (!events[eventName]) {
            events[eventName] = {
                subscribers: []
            };
        }
        return events[eventName];
    }

    function clearEvents() {
        events = {};
    }

    function publishSubscription(subscription, data) {
        if (subscription.async) {
            setTimeout(function () {
                subscription.callback(data);
            }, 4);
        } else {
            subscription.callback(data);
        }
    }

    function _subscribe(event, callback, async) {
        var subscription;

        if (typeof callback === "function") {
            subscription = {
                callback: callback,
                async: async
            };
        } else {
            subscription = callback;
            if (!subscription.callback) {
                throw "Callback was not specified on options";
            }
        }

        getEvent(event).subscribers.push(subscription);
    }

    return {
        subscribe: function subscribe(event, callback, async) {
            return _subscribe(event, callback, async);
        },
        publish: function publish(eventName, data) {
            var event = getEvent(eventName),
                subscribers = event.subscribers;

            // Publish one-time subscriptions
            subscribers.filter(function (subscriber) {
                return !!subscriber.once;
            }).forEach(function (subscriber) {
                publishSubscription(subscriber, data);
            });

            // remove them from the subscriber
            event.subscribers = subscribers.filter(function (subscriber) {
                return !subscriber.once;
            });

            // publish the rest
            event.subscribers.forEach(function (subscriber) {
                publishSubscription(subscriber, data);
            });
        },
        once: function once(event, callback, async) {
            _subscribe(event, {
                callback: callback,
                async: async,
                once: true
            });
        },
        unsubscribe: function unsubscribe(eventName, callback) {
            var event;

            if (eventName) {
                event = getEvent(eventName);
                if (event && callback) {
                    event.subscribers = event.subscribers.filter(function (subscriber) {
                        return subscriber.callback !== callback;
                    });
                } else {
                    event.subscribers = [];
                }
            } else {
                clearEvents();
            }
        }
    };
}();

/***/ },
/* 77 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports.enumerateDevices = enumerateDevices;
exports.getUserMedia = getUserMedia;
function enumerateDevices() {
    if (navigator.mediaDevices && typeof navigator.mediaDevices.enumerateDevices === 'function') {
        return navigator.mediaDevices.enumerateDevices();
    }
    return Promise.reject(new Error('enumerateDevices is not defined'));
};

function getUserMedia(constraints) {
    if (navigator.mediaDevices && typeof navigator.mediaDevices.getUserMedia === 'function') {
        return navigator.mediaDevices.getUserMedia(constraints);
    }
    return Promise.reject(new Error('getUserMedia is not defined'));
}

/***/ },
/* 78 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
/**
 * Construct representing a part of another {ImageWrapper}. Shares data
 * between the parent and the child.
 * @param from {ImageRef} The position where to start the {SubImage} from. (top-left corner)
 * @param size {ImageRef} The size of the resulting image
 * @param I {ImageWrapper} The {ImageWrapper} to share from
 * @returns {SubImage} A shared part of the original image
 */
function SubImage(from, size, I) {
    if (!I) {
        I = {
            data: null,
            size: size
        };
    }
    this.data = I.data;
    this.originalSize = I.size;
    this.I = I;

    this.from = from;
    this.size = size;
}

/**
 * Displays the {SubImage} in a given canvas
 * @param canvas {Canvas} The canvas element to write to
 * @param scale {Number} Scale which is applied to each pixel-value
 */
SubImage.prototype.show = function (canvas, scale) {
    var ctx, frame, data, current, y, x, pixel;

    if (!scale) {
        scale = 1.0;
    }
    ctx = canvas.getContext('2d');
    canvas.width = this.size.x;
    canvas.height = this.size.y;
    frame = ctx.getImageData(0, 0, canvas.width, canvas.height);
    data = frame.data;
    current = 0;
    for (y = 0; y < this.size.y; y++) {
        for (x = 0; x < this.size.x; x++) {
            pixel = y * this.size.x + x;
            current = this.get(x, y) * scale;
            data[pixel * 4 + 0] = current;
            data[pixel * 4 + 1] = current;
            data[pixel * 4 + 2] = current;
            data[pixel * 4 + 3] = 255;
        }
    }
    frame.data = data;
    ctx.putImageData(frame, 0, 0);
};

/**
 * Retrieves a given pixel position from the {SubImage}
 * @param x {Number} The x-position
 * @param y {Number} The y-position
 * @returns {Number} The grayscale value at the pixel-position
 */
SubImage.prototype.get = function (x, y) {
    return this.data[(this.from.y + y) * this.originalSize.x + this.from.x + x];
};

/**
 * Updates the underlying data from a given {ImageWrapper}
 * @param image {ImageWrapper} The updated image
 */
SubImage.prototype.updateData = function (image) {
    this.originalSize = image.size;
    this.data = image.data;
};

/**
 * Updates the position of the shared area
 * @param from {x,y} The new location
 * @returns {SubImage} returns {this} for possible chaining
 */
SubImage.prototype.updateFrom = function (from) {
    this.from = from;
    return this;
};

exports.default = SubImage;

/***/ },
/* 79 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


/*
 * typedefs.js
 * Normalizes browser-specific prefixes
 */

if (typeof window !== 'undefined') {
    window.requestAnimFrame = function () {
        return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function ( /* function FrameRequestCallback */callback) {
            window.setTimeout(callback, 1000 / 60);
        };
    }();
}
Math.imul = Math.imul || function (a, b) {
    var ah = a >>> 16 & 0xffff,
        al = a & 0xffff,
        bh = b >>> 16 & 0xffff,
        bl = b & 0xffff;
    // the shift by 0 fixes the sign on the high part
    // the final |0 converts the unsigned value into a signed value
    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
};

if (typeof Object.assign !== 'function') {
    Object.assign = function (target) {
        // .length of function is 2
        'use strict';

        if (target === null) {
            // TypeError if undefined or null
            throw new TypeError('Cannot convert undefined or null to object');
        }

        var to = Object(target);

        for (var index = 1; index < arguments.length; index++) {
            var nextSource = arguments[index];

            if (nextSource !== null) {
                // Skip over if undefined or null
                for (var nextKey in nextSource) {
                    // Avoid bugs when hasOwnProperty is shadowed
                    if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
                        to[nextKey] = nextSource[nextKey];
                    }
                }
            }
        }
        return to;
    };
}

/***/ },
/* 80 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
var config = void 0;

if (false) {
    config = require('./config.dev.js');
} else if (true) {
    config = __webpack_require__(81);
} else {
    config = require('./config.prod.js');
}

exports.default = config;

/***/ },
/* 81 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


module.exports = {
    inputStream: {
        type: "ImageStream",
        sequence: false,
        size: 800,
        area: {
            top: "0%",
            right: "0%",
            left: "0%",
            bottom: "0%"
        },
        singleChannel: false // true: only the red color-channel is read
    },
    locate: true,
    numOfWorkers: 0,
    decoder: {
        readers: ['code_128_reader']
    },
    locator: {
        halfSample: true,
        patchSize: "medium" // x-small, small, medium, large, x-large
    }
};

/***/ },
/* 82 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _bresenham = __webpack_require__(83);

var _bresenham2 = _interopRequireDefault(_bresenham);

var _image_debug = __webpack_require__(14);

var _image_debug2 = _interopRequireDefault(_image_debug);

var _code_128_reader = __webpack_require__(89);

var _code_128_reader2 = _interopRequireDefault(_code_128_reader);

var _ean_reader = __webpack_require__(5);

var _ean_reader2 = _interopRequireDefault(_ean_reader);

var _code_39_reader = __webpack_require__(43);

var _code_39_reader2 = _interopRequireDefault(_code_39_reader);

var _code_39_vin_reader = __webpack_require__(90);

var _code_39_vin_reader2 = _interopRequireDefault(_code_39_vin_reader);

var _codabar_reader = __webpack_require__(88);

var _codabar_reader2 = _interopRequireDefault(_codabar_reader);

var _upc_reader = __webpack_require__(96);

var _upc_reader2 = _interopRequireDefault(_upc_reader);

var _ean_8_reader = __webpack_require__(93);

var _ean_8_reader2 = _interopRequireDefault(_ean_8_reader);

var _ean_2_reader = __webpack_require__(91);

var _ean_2_reader2 = _interopRequireDefault(_ean_2_reader);

var _ean_5_reader = __webpack_require__(92);

var _ean_5_reader2 = _interopRequireDefault(_ean_5_reader);

var _upc_e_reader = __webpack_require__(95);

var _upc_e_reader2 = _interopRequireDefault(_upc_e_reader);

var _i2of5_reader = __webpack_require__(94);

var _i2of5_reader2 = _interopRequireDefault(_i2of5_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var READERS = {
    code_128_reader: _code_128_reader2.default,
    ean_reader: _ean_reader2.default,
    ean_5_reader: _ean_5_reader2.default,
    ean_2_reader: _ean_2_reader2.default,
    ean_8_reader: _ean_8_reader2.default,
    code_39_reader: _code_39_reader2.default,
    code_39_vin_reader: _code_39_vin_reader2.default,
    codabar_reader: _codabar_reader2.default,
    upc_reader: _upc_reader2.default,
    upc_e_reader: _upc_e_reader2.default,
    i2of5_reader: _i2of5_reader2.default
};
exports.default = {
    create: function create(config, inputImageWrapper) {
        var _canvas = {
            ctx: {
                frequency: null,
                pattern: null,
                overlay: null
            },
            dom: {
                frequency: null,
                pattern: null,
                overlay: null
            }
        },
            _barcodeReaders = [];

        initCanvas();
        initReaders();
        initConfig();

        function initCanvas() {
            if (false) {
                var $debug = document.querySelector("#debug.detection");
                _canvas.dom.frequency = document.querySelector("canvas.frequency");
                if (!_canvas.dom.frequency) {
                    _canvas.dom.frequency = document.createElement("canvas");
                    _canvas.dom.frequency.className = "frequency";
                    if ($debug) {
                        $debug.appendChild(_canvas.dom.frequency);
                    }
                }
                _canvas.ctx.frequency = _canvas.dom.frequency.getContext("2d");

                _canvas.dom.pattern = document.querySelector("canvas.patternBuffer");
                if (!_canvas.dom.pattern) {
                    _canvas.dom.pattern = document.createElement("canvas");
                    _canvas.dom.pattern.className = "patternBuffer";
                    if ($debug) {
                        $debug.appendChild(_canvas.dom.pattern);
                    }
                }
                _canvas.ctx.pattern = _canvas.dom.pattern.getContext("2d");

                _canvas.dom.overlay = document.querySelector("canvas.drawingBuffer");
                if (_canvas.dom.overlay) {
                    _canvas.ctx.overlay = _canvas.dom.overlay.getContext("2d");
                }
            }
        }

        function initReaders() {
            config.readers.forEach(function (readerConfig) {
                var reader,
                    configuration = {},
                    supplements = [];

                if ((typeof readerConfig === 'undefined' ? 'undefined' : _typeof(readerConfig)) === 'object') {
                    reader = readerConfig.format;
                    configuration = readerConfig.config;
                } else if (typeof readerConfig === 'string') {
                    reader = readerConfig;
                }
                if (false) {
                    console.log("Before registering reader: ", reader);
                }
                if (configuration.supplements) {
                    supplements = configuration.supplements.map(function (supplement) {
                        return new READERS[supplement]();
                    });
                }
                _barcodeReaders.push(new READERS[reader](configuration, supplements));
            });
            if (false) {
                console.log("Registered Readers: " + _barcodeReaders.map(function (reader) {
                    return JSON.stringify({ format: reader.FORMAT, config: reader.config });
                }).join(', '));
            }
        }

        function initConfig() {
            if (false) {
                var i,
                    vis = [{
                    node: _canvas.dom.frequency,
                    prop: config.debug.showFrequency
                }, {
                    node: _canvas.dom.pattern,
                    prop: config.debug.showPattern
                }];

                for (i = 0; i < vis.length; i++) {
                    if (vis[i].prop === true) {
                        vis[i].node.style.display = "block";
                    } else {
                        vis[i].node.style.display = "none";
                    }
                }
            }
        }

        /**
         * extend the line on both ends
         * @param {Array} line
         * @param {Number} angle
         */
        function getExtendedLine(line, angle, ext) {
            function extendLine(amount) {
                var extension = {
                    y: amount * Math.sin(angle),
                    x: amount * Math.cos(angle)
                };

                line[0].y -= extension.y;
                line[0].x -= extension.x;
                line[1].y += extension.y;
                line[1].x += extension.x;
            }

            // check if inside image
            extendLine(ext);
            while (ext > 1 && (!inputImageWrapper.inImageWithBorder(line[0], 0) || !inputImageWrapper.inImageWithBorder(line[1], 0))) {
                ext -= Math.ceil(ext / 2);
                extendLine(-ext);
            }
            return line;
        }

        function getLine(box) {
            return [{
                x: (box[1][0] - box[0][0]) / 2 + box[0][0],
                y: (box[1][1] - box[0][1]) / 2 + box[0][1]
            }, {
                x: (box[3][0] - box[2][0]) / 2 + box[2][0],
                y: (box[3][1] - box[2][1]) / 2 + box[2][1]
            }];
        }

        function tryDecode(line) {
            var result = null,
                i,
                barcodeLine = _bresenham2.default.getBarcodeLine(inputImageWrapper, line[0], line[1]);

            if (false) {
                _image_debug2.default.drawPath(line, { x: 'x', y: 'y' }, _canvas.ctx.overlay, { color: 'red', lineWidth: 3 });
                _bresenham2.default.debug.printFrequency(barcodeLine.line, _canvas.dom.frequency);
            }

            _bresenham2.default.toBinaryLine(barcodeLine);

            if (false) {
                _bresenham2.default.debug.printPattern(barcodeLine.line, _canvas.dom.pattern);
            }

            for (i = 0; i < _barcodeReaders.length && result === null; i++) {
                result = _barcodeReaders[i].decodePattern(barcodeLine.line);
            }
            if (result === null) {
                return null;
            }
            return {
                codeResult: result,
                barcodeLine: barcodeLine
            };
        }

        /**
         * This method slices the given area apart and tries to detect a barcode-pattern
         * for each slice. It returns the decoded barcode, or null if nothing was found
         * @param {Array} box
         * @param {Array} line
         * @param {Number} lineAngle
         */
        function tryDecodeBruteForce(box, line, lineAngle) {
            var sideLength = Math.sqrt(Math.pow(box[1][0] - box[0][0], 2) + Math.pow(box[1][1] - box[0][1], 2)),
                i,
                slices = 16,
                result = null,
                dir,
                extension,
                xdir = Math.sin(lineAngle),
                ydir = Math.cos(lineAngle);

            for (i = 1; i < slices && result === null; i++) {
                // move line perpendicular to angle
                dir = sideLength / slices * i * (i % 2 === 0 ? -1 : 1);
                extension = {
                    y: dir * xdir,
                    x: dir * ydir
                };
                line[0].y += extension.x;
                line[0].x -= extension.y;
                line[1].y += extension.x;
                line[1].x -= extension.y;

                result = tryDecode(line);
            }
            return result;
        }

        function getLineLength(line) {
            return Math.sqrt(Math.pow(Math.abs(line[1].y - line[0].y), 2) + Math.pow(Math.abs(line[1].x - line[0].x), 2));
        }

        /**
         * With the help of the configured readers (Code128 or EAN) this function tries to detect a
         * valid barcode pattern within the given area.
         * @param {Object} box The area to search in
         * @returns {Object} the result {codeResult, line, angle, pattern, threshold}
         */
        function _decodeFromBoundingBox(box) {
            var line,
                lineAngle,
                ctx = _canvas.ctx.overlay,
                result,
                lineLength;

            if (false) {
                if (config.debug.drawBoundingBox && ctx) {
                    _image_debug2.default.drawPath(box, { x: 0, y: 1 }, ctx, { color: "blue", lineWidth: 2 });
                }
            }

            line = getLine(box);
            lineLength = getLineLength(line);
            lineAngle = Math.atan2(line[1].y - line[0].y, line[1].x - line[0].x);
            line = getExtendedLine(line, lineAngle, Math.floor(lineLength * 0.1));
            if (line === null) {
                return null;
            }

            result = tryDecode(line);
            if (result === null) {
                result = tryDecodeBruteForce(box, line, lineAngle);
            }

            if (result === null) {
                return null;
            }

            if (false) {
                _image_debug2.default.drawPath(line, { x: 'x', y: 'y' }, ctx, { color: 'red', lineWidth: 3 });
            }

            return {
                codeResult: result.codeResult,
                line: line,
                angle: lineAngle,
                pattern: result.barcodeLine.line,
                threshold: result.barcodeLine.threshold
            };
        }

        return {
            decodeFromBoundingBox: function decodeFromBoundingBox(box) {
                return _decodeFromBoundingBox(box);
            },
            decodeFromBoundingBoxes: function decodeFromBoundingBoxes(boxes) {
                var i,
                    result,
                    barcodes = [],
                    multiple = config.multiple;

                for (i = 0; i < boxes.length; i++) {
                    var box = boxes[i];
                    result = _decodeFromBoundingBox(box) || {};
                    result.box = box;

                    if (multiple) {
                        barcodes.push(result);
                    } else if (result.codeResult) {
                        return result;
                    }
                }

                if (multiple) {
                    return {
                        barcodes: barcodes
                    };
                }
            },
            setReaders: function setReaders(readers) {
                config.readers = readers;
                _barcodeReaders.length = 0;
                initReaders();
            }
        };
    }
};

/***/ },
/* 83 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _image_wrapper = __webpack_require__(26);

var _image_wrapper2 = _interopRequireDefault(_image_wrapper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Bresenham = {};

var Slope = {
    DIR: {
        UP: 1,
        DOWN: -1
    }
};
/**
 * Scans a line of the given image from point p1 to p2 and returns a result object containing
 * gray-scale values (0-255) of the underlying pixels in addition to the min
 * and max values.
 * @param {Object} imageWrapper
 * @param {Object} p1 The start point {x,y}
 * @param {Object} p2 The end point {x,y}
 * @returns {line, min, max}
 */
Bresenham.getBarcodeLine = function (imageWrapper, p1, p2) {
    var x0 = p1.x | 0,
        y0 = p1.y | 0,
        x1 = p2.x | 0,
        y1 = p2.y | 0,
        steep = Math.abs(y1 - y0) > Math.abs(x1 - x0),
        deltax,
        deltay,
        error,
        ystep,
        y,
        tmp,
        x,
        line = [],
        imageData = imageWrapper.data,
        width = imageWrapper.size.x,
        sum = 0,
        val,
        min = 255,
        max = 0;

    function read(a, b) {
        val = imageData[b * width + a];
        sum += val;
        min = val < min ? val : min;
        max = val > max ? val : max;
        line.push(val);
    }

    if (steep) {
        tmp = x0;
        x0 = y0;
        y0 = tmp;

        tmp = x1;
        x1 = y1;
        y1 = tmp;
    }
    if (x0 > x1) {
        tmp = x0;
        x0 = x1;
        x1 = tmp;

        tmp = y0;
        y0 = y1;
        y1 = tmp;
    }
    deltax = x1 - x0;
    deltay = Math.abs(y1 - y0);
    error = deltax / 2 | 0;
    y = y0;
    ystep = y0 < y1 ? 1 : -1;
    for (x = x0; x < x1; x++) {
        if (steep) {
            read(y, x);
        } else {
            read(x, y);
        }
        error = error - deltay;
        if (error < 0) {
            y = y + ystep;
            error = error + deltax;
        }
    }

    return {
        line: line,
        min: min,
        max: max
    };
};

/**
 * Converts the result from getBarcodeLine into a binary representation
 * also considering the frequency and slope of the signal for more robust results
 * @param {Object} result {line, min, max}
 */
Bresenham.toBinaryLine = function (result) {
    var min = result.min,
        max = result.max,
        line = result.line,
        slope,
        slope2,
        center = min + (max - min) / 2,
        extrema = [],
        currentDir,
        dir,
        threshold = (max - min) / 12,
        rThreshold = -threshold,
        i,
        j;

    // 1. find extrema
    currentDir = line[0] > center ? Slope.DIR.UP : Slope.DIR.DOWN;
    extrema.push({
        pos: 0,
        val: line[0]
    });
    for (i = 0; i < line.length - 2; i++) {
        slope = line[i + 1] - line[i];
        slope2 = line[i + 2] - line[i + 1];
        if (slope + slope2 < rThreshold && line[i + 1] < center * 1.5) {
            dir = Slope.DIR.DOWN;
        } else if (slope + slope2 > threshold && line[i + 1] > center * 0.5) {
            dir = Slope.DIR.UP;
        } else {
            dir = currentDir;
        }

        if (currentDir !== dir) {
            extrema.push({
                pos: i,
                val: line[i]
            });
            currentDir = dir;
        }
    }
    extrema.push({
        pos: line.length,
        val: line[line.length - 1]
    });

    for (j = extrema[0].pos; j < extrema[1].pos; j++) {
        line[j] = line[j] > center ? 0 : 1;
    }

    // iterate over extrema and convert to binary based on avg between minmax
    for (i = 1; i < extrema.length - 1; i++) {
        if (extrema[i + 1].val > extrema[i].val) {
            threshold = extrema[i].val + (extrema[i + 1].val - extrema[i].val) / 3 * 2 | 0;
        } else {
            threshold = extrema[i + 1].val + (extrema[i].val - extrema[i + 1].val) / 3 | 0;
        }

        for (j = extrema[i].pos; j < extrema[i + 1].pos; j++) {
            line[j] = line[j] > threshold ? 0 : 1;
        }
    }

    return {
        line: line,
        threshold: threshold
    };
};

/**
 * Used for development only
 */
Bresenham.debug = {
    printFrequency: function printFrequency(line, canvas) {
        var i,
            ctx = canvas.getContext("2d");
        canvas.width = line.length;
        canvas.height = 256;

        ctx.beginPath();
        ctx.strokeStyle = "blue";
        for (i = 0; i < line.length; i++) {
            ctx.moveTo(i, 255);
            ctx.lineTo(i, 255 - line[i]);
        }
        ctx.stroke();
        ctx.closePath();
    },

    printPattern: function printPattern(line, canvas) {
        var ctx = canvas.getContext("2d"),
            i;

        canvas.width = line.length;
        ctx.fillColor = "black";
        for (i = 0; i < line.length; i++) {
            if (line[i] === 1) {
                ctx.fillRect(i, 0, 1, 100);
            }
        }
    }
};

exports.default = Bresenham;

/***/ },
/* 84 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _pick2 = __webpack_require__(198);

var _pick3 = _interopRequireDefault(_pick2);

var _omit2 = __webpack_require__(197);

var _omit3 = _interopRequireDefault(_omit2);

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.pickConstraints = pickConstraints;

var _mediaDevices = __webpack_require__(77);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var facingMatching = {
    "user": /front/i,
    "environment": /back/i
};

var streamRef;

function waitForVideo(video) {
    return new Promise(function (resolve, reject) {
        var attempts = 10;

        function checkVideo() {
            if (attempts > 0) {
                if (video.videoWidth > 0 && video.videoHeight > 0) {
                    if (false) {
                        console.log(video.videoWidth + "px x " + video.videoHeight + "px");
                    }
                    resolve();
                } else {
                    window.setTimeout(checkVideo, 500);
                }
            } else {
                reject('Unable to play video stream. Is webcam working?');
            }
            attempts--;
        }
        checkVideo();
    });
}

/**
 * Tries to attach the camera-stream to a given video-element
 * and calls the callback function when the content is ready
 * @param {Object} constraints
 * @param {Object} video
 */
function initCamera(video, constraints) {
    return (0, _mediaDevices.getUserMedia)(constraints).then(function (stream) {
        return new Promise(function (resolve) {
            streamRef = stream;
            video.setAttribute("autoplay", 'true');
            video.srcObject = stream;
            video.addEventListener('loadedmetadata', function () {
                video.play();
                resolve();
            });
        });
    }).then(waitForVideo.bind(null, video));
}

function deprecatedConstraints(videoConstraints) {
    var normalized = (0, _pick3.default)(videoConstraints, ["width", "height", "facingMode", "aspectRatio", "deviceId"]);

    if (typeof videoConstraints.minAspectRatio !== 'undefined' && videoConstraints.minAspectRatio > 0) {
        normalized.aspectRatio = videoConstraints.minAspectRatio;
        console.log("WARNING: Constraint 'minAspectRatio' is deprecated; Use 'aspectRatio' instead");
    }
    if (typeof videoConstraints.facing !== 'undefined') {
        normalized.facingMode = videoConstraints.facing;
        console.log("WARNING: Constraint 'facing' is deprecated. Use 'facingMode' instead'");
    }
    return normalized;
}

function pickDevice(constraints) {
    var desiredFacing = constraints.video.facingMode,
        facingMatch = facingMatching[desiredFacing];

    if (!facingMatch) {
        return Promise.resolve(constraints);
    }
    return (0, _mediaDevices.enumerateDevices)().then(function (devices) {
        var selectedDeviceId = devices.filter(function (device) {
            return device.kind === 'videoinput' && facingMatch.test(device.label);
        }).map(function (facingDevice) {
            return facingDevice.deviceId;
        })[0];
        if (selectedDeviceId) {
            constraints = _extends({}, constraints, {
                video: _extends({}, (0, _omit3.default)(constraints.video, ["facingMode"]), {
                    deviceId: selectedDeviceId
                })
            });
        }
        return Promise.resolve(constraints);
    });
}

function pickConstraints(videoConstraints) {
    var normalizedConstraints = {
        audio: false,
        video: deprecatedConstraints(videoConstraints)
    };

    if (!normalizedConstraints.video.deviceId) {
        if (typeof normalizedConstraints.video.facingMode === 'string' && normalizedConstraints.video.facingMode.length > 0) {
            return pickDevice(normalizedConstraints);
        }
    }
    return Promise.resolve(normalizedConstraints);
}

function enumerateVideoDevices() {
    return (0, _mediaDevices.enumerateDevices)().then(function (devices) {
        return devices.filter(function (device) {
            return device.kind === 'videoinput';
        });
    });
}

exports.default = {
    request: function request(video, videoConstraints) {
        return pickConstraints(videoConstraints).then(initCamera.bind(null, video));
    },
    release: function release() {
        var tracks = streamRef && streamRef.getVideoTracks();
        if (tracks && tracks.length) {
            tracks[0].stop();
        }
        streamRef = null;
    },
    enumerateVideoDevices: enumerateVideoDevices,
    getActiveStreamLabel: function getActiveStreamLabel() {
        if (streamRef) {
            var tracks = streamRef.getVideoTracks();
            if (tracks && tracks.length) {
                return tracks[0].label;
            }
        }
    }
};

/***/ },
/* 85 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

exports.__esModule = true;

var _image_wrapper = __webpack_require__(26);

var _image_wrapper2 = _interopRequireDefault(_image_wrapper);

var _cv_utils = __webpack_require__(25);

var _array_helper = __webpack_require__(13);

var _array_helper2 = _interopRequireDefault(_array_helper);

var _image_debug = __webpack_require__(14);

var _image_debug2 = _interopRequireDefault(_image_debug);

var _rasterizer = __webpack_require__(86);

var _rasterizer2 = _interopRequireDefault(_rasterizer);

var _tracer = __webpack_require__(42);

var _tracer2 = _interopRequireDefault(_tracer);

var _skeletonizer2 = __webpack_require__(87);

var _skeletonizer3 = _interopRequireDefault(_skeletonizer2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var vec2 = {
    clone: __webpack_require__(11),
    dot: __webpack_require__(44),
    scale: __webpack_require__(100),
    transformMat2: __webpack_require__(101)
};
var mat2 = {
    copy: __webpack_require__(97),
    create: __webpack_require__(98),
    invert: __webpack_require__(99)
};

var _config,
    _currentImageWrapper,
    _skelImageWrapper,
    _subImageWrapper,
    _labelImageWrapper,
    _patchGrid,
    _patchLabelGrid,
    _imageToPatchGrid,
    _binaryImageWrapper,
    _patchSize,
    _canvasContainer = {
    ctx: {
        binary: null
    },
    dom: {
        binary: null
    }
},
    _numPatches = { x: 0, y: 0 },
    _inputImageWrapper,
    _skeletonizer;

function initBuffers() {
    var skeletonImageData;

    if (_config.halfSample) {
        _currentImageWrapper = new _image_wrapper2.default({
            x: _inputImageWrapper.size.x / 2 | 0,
            y: _inputImageWrapper.size.y / 2 | 0
        });
    } else {
        _currentImageWrapper = _inputImageWrapper;
    }

    _patchSize = (0, _cv_utils.calculatePatchSize)(_config.patchSize, _currentImageWrapper.size);

    _numPatches.x = _currentImageWrapper.size.x / _patchSize.x | 0;
    _numPatches.y = _currentImageWrapper.size.y / _patchSize.y | 0;

    _binaryImageWrapper = new _image_wrapper2.default(_currentImageWrapper.size, undefined, Uint8Array, false);

    _labelImageWrapper = new _image_wrapper2.default(_patchSize, undefined, Array, true);

    skeletonImageData = new ArrayBuffer(64 * 1024);
    _subImageWrapper = new _image_wrapper2.default(_patchSize, new Uint8Array(skeletonImageData, 0, _patchSize.x * _patchSize.y));
    _skelImageWrapper = new _image_wrapper2.default(_patchSize, new Uint8Array(skeletonImageData, _patchSize.x * _patchSize.y * 3, _patchSize.x * _patchSize.y), undefined, true);
    _skeletonizer = (0, _skeletonizer3.default)(typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : global, {
        size: _patchSize.x
    }, skeletonImageData);

    _imageToPatchGrid = new _image_wrapper2.default({
        x: _currentImageWrapper.size.x / _subImageWrapper.size.x | 0,
        y: _currentImageWrapper.size.y / _subImageWrapper.size.y | 0
    }, undefined, Array, true);
    _patchGrid = new _image_wrapper2.default(_imageToPatchGrid.size, undefined, undefined, true);
    _patchLabelGrid = new _image_wrapper2.default(_imageToPatchGrid.size, undefined, Int32Array, true);
}

function initCanvas() {
    if (_config.useWorker || typeof document === 'undefined') {
        return;
    }
    _canvasContainer.dom.binary = document.createElement("canvas");
    _canvasContainer.dom.binary.className = "binaryBuffer";
    if (false) {
        document.querySelector("#debug").appendChild(_canvasContainer.dom.binary);
    }
    _canvasContainer.ctx.binary = _canvasContainer.dom.binary.getContext("2d");
    _canvasContainer.dom.binary.width = _binaryImageWrapper.size.x;
    _canvasContainer.dom.binary.height = _binaryImageWrapper.size.y;
}

/**
 * Creates a bounding box which encloses all the given patches
 * @returns {Array} The minimal bounding box
 */
function boxFromPatches(patches) {
    var overAvg,
        i,
        j,
        patch,
        transMat,
        minx = _binaryImageWrapper.size.x,
        miny = _binaryImageWrapper.size.y,
        maxx = -_binaryImageWrapper.size.x,
        maxy = -_binaryImageWrapper.size.y,
        box,
        scale;

    // draw all patches which are to be taken into consideration
    overAvg = 0;
    for (i = 0; i < patches.length; i++) {
        patch = patches[i];
        overAvg += patch.rad;
        if (false) {
            _image_debug2.default.drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "red" });
        }
    }

    overAvg /= patches.length;
    overAvg = (overAvg * 180 / Math.PI + 90) % 180 - 90;
    if (overAvg < 0) {
        overAvg += 180;
    }

    overAvg = (180 - overAvg) * Math.PI / 180;
    transMat = mat2.copy(mat2.create(), [Math.cos(overAvg), Math.sin(overAvg), -Math.sin(overAvg), Math.cos(overAvg)]);

    // iterate over patches and rotate by angle
    for (i = 0; i < patches.length; i++) {
        patch = patches[i];
        for (j = 0; j < 4; j++) {
            vec2.transformMat2(patch.box[j], patch.box[j], transMat);
        }

        if (false) {
            _image_debug2.default.drawPath(patch.box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#99ff00', lineWidth: 2 });
        }
    }

    // find bounding box
    for (i = 0; i < patches.length; i++) {
        patch = patches[i];
        for (j = 0; j < 4; j++) {
            if (patch.box[j][0] < minx) {
                minx = patch.box[j][0];
            }
            if (patch.box[j][0] > maxx) {
                maxx = patch.box[j][0];
            }
            if (patch.box[j][1] < miny) {
                miny = patch.box[j][1];
            }
            if (patch.box[j][1] > maxy) {
                maxy = patch.box[j][1];
            }
        }
    }

    box = [[minx, miny], [maxx, miny], [maxx, maxy], [minx, maxy]];

    if (false) {
        _image_debug2.default.drawPath(box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#ff0000', lineWidth: 2 });
    }

    scale = _config.halfSample ? 2 : 1;
    // reverse rotation;
    transMat = mat2.invert(transMat, transMat);
    for (j = 0; j < 4; j++) {
        vec2.transformMat2(box[j], box[j], transMat);
    }

    if (false) {
        _image_debug2.default.drawPath(box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#ff0000', lineWidth: 2 });
    }

    for (j = 0; j < 4; j++) {
        vec2.scale(box[j], box[j], scale);
    }

    return box;
}

/**
 * Creates a binary image of the current image
 */
function binarizeImage() {
    (0, _cv_utils.otsuThreshold)(_currentImageWrapper, _binaryImageWrapper);
    _binaryImageWrapper.zeroBorder();
    if (false) {
        _binaryImageWrapper.show(_canvasContainer.dom.binary, 255);
    }
}

/**
 * Iterate over the entire image
 * extract patches
 */
function findPatches() {
    var i,
        j,
        x,
        y,
        moments,
        patchesFound = [],
        rasterizer,
        rasterResult,
        patch;
    for (i = 0; i < _numPatches.x; i++) {
        for (j = 0; j < _numPatches.y; j++) {
            x = _subImageWrapper.size.x * i;
            y = _subImageWrapper.size.y * j;

            // seperate parts
            skeletonize(x, y);

            // Rasterize, find individual bars
            _skelImageWrapper.zeroBorder();
            _array_helper2.default.init(_labelImageWrapper.data, 0);
            rasterizer = _rasterizer2.default.create(_skelImageWrapper, _labelImageWrapper);
            rasterResult = rasterizer.rasterize(0);

            if (false) {
                _labelImageWrapper.overlay(_canvasContainer.dom.binary, Math.floor(360 / rasterResult.count), { x: x, y: y });
            }

            // calculate moments from the skeletonized patch
            moments = _labelImageWrapper.moments(rasterResult.count);

            // extract eligible patches
            patchesFound = patchesFound.concat(describePatch(moments, [i, j], x, y));
        }
    }

    if (false) {
        for (i = 0; i < patchesFound.length; i++) {
            patch = patchesFound[i];
            _image_debug2.default.drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "#99ff00", lineWidth: 2 });
        }
    }

    return patchesFound;
}

/**
 * Finds those connected areas which contain at least 6 patches
 * and returns them ordered DESC by the number of contained patches
 * @param {Number} maxLabel
 */
function findBiggestConnectedAreas(maxLabel) {
    var i,
        sum,
        labelHist = [],
        topLabels = [];

    for (i = 0; i < maxLabel; i++) {
        labelHist.push(0);
    }
    sum = _patchLabelGrid.data.length;
    while (sum--) {
        if (_patchLabelGrid.data[sum] > 0) {
            labelHist[_patchLabelGrid.data[sum] - 1]++;
        }
    }

    labelHist = labelHist.map(function (val, idx) {
        return {
            val: val,
            label: idx + 1
        };
    });

    labelHist.sort(function (a, b) {
        return b.val - a.val;
    });

    // extract top areas with at least 6 patches present
    topLabels = labelHist.filter(function (el) {
        return el.val >= 5;
    });

    return topLabels;
}

/**
 *
 */
function findBoxes(topLabels, maxLabel) {
    var i,
        j,
        sum,
        patches = [],
        patch,
        box,
        boxes = [],
        hsv = [0, 1, 1],
        rgb = [0, 0, 0];

    for (i = 0; i < topLabels.length; i++) {
        sum = _patchLabelGrid.data.length;
        patches.length = 0;
        while (sum--) {
            if (_patchLabelGrid.data[sum] === topLabels[i].label) {
                patch = _imageToPatchGrid.data[sum];
                patches.push(patch);
            }
        }
        box = boxFromPatches(patches);
        if (box) {
            boxes.push(box);

            // draw patch-labels if requested
            if (false) {
                for (j = 0; j < patches.length; j++) {
                    patch = patches[j];
                    hsv[0] = topLabels[i].label / (maxLabel + 1) * 360;
                    (0, _cv_utils.hsv2rgb)(hsv, rgb);
                    _image_debug2.default.drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "rgb(" + rgb.join(",") + ")", lineWidth: 2 });
                }
            }
        }
    }
    return boxes;
}

/**
 * Find similar moments (via cluster)
 * @param {Object} moments
 */
function similarMoments(moments) {
    var clusters = (0, _cv_utils.cluster)(moments, 0.90);
    var topCluster = (0, _cv_utils.topGeneric)(clusters, 1, function (e) {
        return e.getPoints().length;
    });
    var points = [],
        result = [];
    if (topCluster.length === 1) {
        points = topCluster[0].item.getPoints();
        for (var i = 0; i < points.length; i++) {
            result.push(points[i].point);
        }
    }
    return result;
}

function skeletonize(x, y) {
    _binaryImageWrapper.subImageAsCopy(_subImageWrapper, (0, _cv_utils.imageRef)(x, y));
    _skeletonizer.skeletonize();

    // Show skeleton if requested
    if (false) {
        _skelImageWrapper.overlay(_canvasContainer.dom.binary, 360, (0, _cv_utils.imageRef)(x, y));
    }
}

/**
 * Extracts and describes those patches which seem to contain a barcode pattern
 * @param {Array} moments
 * @param {Object} patchPos,
 * @param {Number} x
 * @param {Number} y
 * @returns {Array} list of patches
 */
function describePatch(moments, patchPos, x, y) {
    var k,
        avg,
        eligibleMoments = [],
        matchingMoments,
        patch,
        patchesFound = [],
        minComponentWeight = Math.ceil(_patchSize.x / 3);

    if (moments.length >= 2) {
        // only collect moments which's area covers at least minComponentWeight pixels.
        for (k = 0; k < moments.length; k++) {
            if (moments[k].m00 > minComponentWeight) {
                eligibleMoments.push(moments[k]);
            }
        }

        // if at least 2 moments are found which have at least minComponentWeights covered
        if (eligibleMoments.length >= 2) {
            matchingMoments = similarMoments(eligibleMoments);
            avg = 0;
            // determine the similarity of the moments
            for (k = 0; k < matchingMoments.length; k++) {
                avg += matchingMoments[k].rad;
            }

            // Only two of the moments are allowed not to fit into the equation
            // add the patch to the set
            if (matchingMoments.length > 1 && matchingMoments.length >= eligibleMoments.length / 4 * 3 && matchingMoments.length > moments.length / 4) {
                avg /= matchingMoments.length;
                patch = {
                    index: patchPos[1] * _numPatches.x + patchPos[0],
                    pos: {
                        x: x,
                        y: y
                    },
                    box: [vec2.clone([x, y]), vec2.clone([x + _subImageWrapper.size.x, y]), vec2.clone([x + _subImageWrapper.size.x, y + _subImageWrapper.size.y]), vec2.clone([x, y + _subImageWrapper.size.y])],
                    moments: matchingMoments,
                    rad: avg,
                    vec: vec2.clone([Math.cos(avg), Math.sin(avg)])
                };
                patchesFound.push(patch);
            }
        }
    }
    return patchesFound;
}

/**
 * finds patches which are connected and share the same orientation
 * @param {Object} patchesFound
 */
function rasterizeAngularSimilarity(patchesFound) {
    var label = 0,
        threshold = 0.95,
        currIdx = 0,
        j,
        patch,
        hsv = [0, 1, 1],
        rgb = [0, 0, 0];

    function notYetProcessed() {
        var i;
        for (i = 0; i < _patchLabelGrid.data.length; i++) {
            if (_patchLabelGrid.data[i] === 0 && _patchGrid.data[i] === 1) {
                return i;
            }
        }
        return _patchLabelGrid.length;
    }

    function trace(currentIdx) {
        var x,
            y,
            currentPatch,
            idx,
            dir,
            current = {
            x: currentIdx % _patchLabelGrid.size.x,
            y: currentIdx / _patchLabelGrid.size.x | 0
        },
            similarity;

        if (currentIdx < _patchLabelGrid.data.length) {
            currentPatch = _imageToPatchGrid.data[currentIdx];
            // assign label
            _patchLabelGrid.data[currentIdx] = label;
            for (dir = 0; dir < _tracer2.default.searchDirections.length; dir++) {
                y = current.y + _tracer2.default.searchDirections[dir][0];
                x = current.x + _tracer2.default.searchDirections[dir][1];
                idx = y * _patchLabelGrid.size.x + x;

                // continue if patch empty
                if (_patchGrid.data[idx] === 0) {
                    _patchLabelGrid.data[idx] = Number.MAX_VALUE;
                    continue;
                }

                if (_patchLabelGrid.data[idx] === 0) {
                    similarity = Math.abs(vec2.dot(_imageToPatchGrid.data[idx].vec, currentPatch.vec));
                    if (similarity > threshold) {
                        trace(idx);
                    }
                }
            }
        }
    }

    // prepare for finding the right patches
    _array_helper2.default.init(_patchGrid.data, 0);
    _array_helper2.default.init(_patchLabelGrid.data, 0);
    _array_helper2.default.init(_imageToPatchGrid.data, null);

    for (j = 0; j < patchesFound.length; j++) {
        patch = patchesFound[j];
        _imageToPatchGrid.data[patch.index] = patch;
        _patchGrid.data[patch.index] = 1;
    }

    // rasterize the patches found to determine area
    _patchGrid.zeroBorder();

    while ((currIdx = notYetProcessed()) < _patchLabelGrid.data.length) {
        label++;
        trace(currIdx);
    }

    // draw patch-labels if requested
    if (false) {
        for (j = 0; j < _patchLabelGrid.data.length; j++) {
            if (_patchLabelGrid.data[j] > 0 && _patchLabelGrid.data[j] <= label) {
                patch = _imageToPatchGrid.data[j];
                hsv[0] = _patchLabelGrid.data[j] / (label + 1) * 360;
                (0, _cv_utils.hsv2rgb)(hsv, rgb);
                _image_debug2.default.drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "rgb(" + rgb.join(",") + ")", lineWidth: 2 });
            }
        }
    }

    return label;
}

exports.default = {
    init: function init(inputImageWrapper, config) {
        _config = config;
        _inputImageWrapper = inputImageWrapper;

        initBuffers();
        initCanvas();
    },

    locate: function locate() {
        var patchesFound, topLabels, boxes;

        if (_config.halfSample) {
            (0, _cv_utils.halfSample)(_inputImageWrapper, _currentImageWrapper);
        }

        binarizeImage();
        patchesFound = findPatches();
        // return unless 5% or more patches are found
        if (patchesFound.length < _numPatches.x * _numPatches.y * 0.05) {
            return null;
        }

        // rasterrize area by comparing angular similarity;
        var maxLabel = rasterizeAngularSimilarity(patchesFound);
        if (maxLabel < 1) {
            return null;
        }

        // search for area with the most patches (biggest connected area)
        topLabels = findBiggestConnectedAreas(maxLabel);
        if (topLabels.length === 0) {
            return null;
        }

        boxes = findBoxes(topLabels, maxLabel);
        return boxes;
    },

    checkImageConstraints: function checkImageConstraints(inputStream, config) {
        var patchSize,
            width = inputStream.getWidth(),
            height = inputStream.getHeight(),
            halfSample = config.halfSample ? 0.5 : 1,
            size,
            area;

        // calculate width and height based on area
        if (inputStream.getConfig().area) {
            area = (0, _cv_utils.computeImageArea)(width, height, inputStream.getConfig().area);
            inputStream.setTopRight({ x: area.sx, y: area.sy });
            inputStream.setCanvasSize({ x: width, y: height });
            width = area.sw;
            height = area.sh;
        }

        size = {
            x: Math.floor(width * halfSample),
            y: Math.floor(height * halfSample)
        };

        patchSize = (0, _cv_utils.calculatePatchSize)(config.patchSize, size);
        if (false) {
            console.log("Patch-Size: " + JSON.stringify(patchSize));
        }

        inputStream.setWidth(Math.floor(Math.floor(size.x / patchSize.x) * (1 / halfSample) * patchSize.x));
        inputStream.setHeight(Math.floor(Math.floor(size.y / patchSize.y) * (1 / halfSample) * patchSize.y));

        if (inputStream.getWidth() % patchSize.x === 0 && inputStream.getHeight() % patchSize.y === 0) {
            return true;
        }

        throw new Error("Image dimensions do not comply with the current settings: Width (" + width + " )and height (" + height + ") must a multiple of " + patchSize.x);
    }
};
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(70)))

/***/ },
/* 86 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _tracer = __webpack_require__(42);

var _tracer2 = _interopRequireDefault(_tracer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * http://www.codeproject.com/Tips/407172/Connected-Component-Labeling-and-Vectorization
 */
var Rasterizer = {
    createContour2D: function createContour2D() {
        return {
            dir: null,
            index: null,
            firstVertex: null,
            insideContours: null,
            nextpeer: null,
            prevpeer: null
        };
    },
    CONTOUR_DIR: {
        CW_DIR: 0,
        CCW_DIR: 1,
        UNKNOWN_DIR: 2
    },
    DIR: {
        OUTSIDE_EDGE: -32767,
        INSIDE_EDGE: -32766
    },
    create: function create(imageWrapper, labelWrapper) {
        var imageData = imageWrapper.data,
            labelData = labelWrapper.data,
            width = imageWrapper.size.x,
            height = imageWrapper.size.y,
            tracer = _tracer2.default.create(imageWrapper, labelWrapper);

        return {
            rasterize: function rasterize(depthlabel) {
                var color,
                    bc,
                    lc,
                    labelindex,
                    cx,
                    cy,
                    colorMap = [],
                    vertex,
                    p,
                    cc,
                    sc,
                    pos,
                    connectedCount = 0,
                    i;

                for (i = 0; i < 400; i++) {
                    colorMap[i] = 0;
                }

                colorMap[0] = imageData[0];
                cc = null;
                for (cy = 1; cy < height - 1; cy++) {
                    labelindex = 0;
                    bc = colorMap[0];
                    for (cx = 1; cx < width - 1; cx++) {
                        pos = cy * width + cx;
                        if (labelData[pos] === 0) {
                            color = imageData[pos];
                            if (color !== bc) {
                                if (labelindex === 0) {
                                    lc = connectedCount + 1;
                                    colorMap[lc] = color;
                                    bc = color;
                                    vertex = tracer.contourTracing(cy, cx, lc, color, Rasterizer.DIR.OUTSIDE_EDGE);
                                    if (vertex !== null) {
                                        connectedCount++;
                                        labelindex = lc;
                                        p = Rasterizer.createContour2D();
                                        p.dir = Rasterizer.CONTOUR_DIR.CW_DIR;
                                        p.index = labelindex;
                                        p.firstVertex = vertex;
                                        p.nextpeer = cc;
                                        p.insideContours = null;
                                        if (cc !== null) {
                                            cc.prevpeer = p;
                                        }
                                        cc = p;
                                    }
                                } else {
                                    vertex = tracer.contourTracing(cy, cx, Rasterizer.DIR.INSIDE_EDGE, color, labelindex);
                                    if (vertex !== null) {
                                        p = Rasterizer.createContour2D();
                                        p.firstVertex = vertex;
                                        p.insideContours = null;
                                        if (depthlabel === 0) {
                                            p.dir = Rasterizer.CONTOUR_DIR.CCW_DIR;
                                        } else {
                                            p.dir = Rasterizer.CONTOUR_DIR.CW_DIR;
                                        }
                                        p.index = depthlabel;
                                        sc = cc;
                                        while (sc !== null && sc.index !== labelindex) {
                                            sc = sc.nextpeer;
                                        }
                                        if (sc !== null) {
                                            p.nextpeer = sc.insideContours;
                                            if (sc.insideContours !== null) {
                                                sc.insideContours.prevpeer = p;
                                            }
                                            sc.insideContours = p;
                                        }
                                    }
                                }
                            } else {
                                labelData[pos] = labelindex;
                            }
                        } else if (labelData[pos] === Rasterizer.DIR.OUTSIDE_EDGE || labelData[pos] === Rasterizer.DIR.INSIDE_EDGE) {
                            labelindex = 0;
                            if (labelData[pos] === Rasterizer.DIR.INSIDE_EDGE) {
                                bc = imageData[pos];
                            } else {
                                bc = colorMap[0];
                            }
                        } else {
                            labelindex = labelData[pos];
                            bc = colorMap[labelindex];
                        }
                    }
                }
                sc = cc;
                while (sc !== null) {
                    sc.index = depthlabel;
                    sc = sc.nextpeer;
                }
                return {
                    cc: cc,
                    count: connectedCount
                };
            },
            debug: {
                drawContour: function drawContour(canvas, firstContour) {
                    var ctx = canvas.getContext("2d"),
                        pq = firstContour,
                        iq,
                        q,
                        p;

                    ctx.strokeStyle = "red";
                    ctx.fillStyle = "red";
                    ctx.lineWidth = 1;

                    if (pq !== null) {
                        iq = pq.insideContours;
                    } else {
                        iq = null;
                    }

                    while (pq !== null) {
                        if (iq !== null) {
                            q = iq;
                            iq = iq.nextpeer;
                        } else {
                            q = pq;
                            pq = pq.nextpeer;
                            if (pq !== null) {
                                iq = pq.insideContours;
                            } else {
                                iq = null;
                            }
                        }

                        switch (q.dir) {
                            case Rasterizer.CONTOUR_DIR.CW_DIR:
                                ctx.strokeStyle = "red";
                                break;
                            case Rasterizer.CONTOUR_DIR.CCW_DIR:
                                ctx.strokeStyle = "blue";
                                break;
                            case Rasterizer.CONTOUR_DIR.UNKNOWN_DIR:
                                ctx.strokeStyle = "green";
                                break;
                        }

                        p = q.firstVertex;
                        ctx.beginPath();
                        ctx.moveTo(p.x, p.y);
                        do {
                            p = p.next;
                            ctx.lineTo(p.x, p.y);
                        } while (p !== q.firstVertex);
                        ctx.stroke();
                    }
                }
            }
        };
    }
};

exports.default = Rasterizer;

/***/ },
/* 87 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
/* @preserve ASM BEGIN */
/* eslint-disable eqeqeq*/
function Skeletonizer(stdlib, foreign, buffer) {
    "use asm";

    var images = new stdlib.Uint8Array(buffer),
        size = foreign.size | 0,
        imul = stdlib.Math.imul;

    function erode(inImagePtr, outImagePtr) {
        inImagePtr = inImagePtr | 0;
        outImagePtr = outImagePtr | 0;

        var v = 0,
            u = 0,
            sum = 0,
            yStart1 = 0,
            yStart2 = 0,
            xStart1 = 0,
            xStart2 = 0,
            offset = 0;

        for (v = 1; (v | 0) < (size - 1 | 0); v = v + 1 | 0) {
            offset = offset + size | 0;
            for (u = 1; (u | 0) < (size - 1 | 0); u = u + 1 | 0) {
                yStart1 = offset - size | 0;
                yStart2 = offset + size | 0;
                xStart1 = u - 1 | 0;
                xStart2 = u + 1 | 0;
                sum = (images[inImagePtr + yStart1 + xStart1 | 0] | 0) + (images[inImagePtr + yStart1 + xStart2 | 0] | 0) + (images[inImagePtr + offset + u | 0] | 0) + (images[inImagePtr + yStart2 + xStart1 | 0] | 0) + (images[inImagePtr + yStart2 + xStart2 | 0] | 0) | 0;
                if ((sum | 0) == (5 | 0)) {
                    images[outImagePtr + offset + u | 0] = 1;
                } else {
                    images[outImagePtr + offset + u | 0] = 0;
                }
            }
        }
        return;
    }

    function subtract(aImagePtr, bImagePtr, outImagePtr) {
        aImagePtr = aImagePtr | 0;
        bImagePtr = bImagePtr | 0;
        outImagePtr = outImagePtr | 0;

        var length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            images[outImagePtr + length | 0] = (images[aImagePtr + length | 0] | 0) - (images[bImagePtr + length | 0] | 0) | 0;
        }
    }

    function bitwiseOr(aImagePtr, bImagePtr, outImagePtr) {
        aImagePtr = aImagePtr | 0;
        bImagePtr = bImagePtr | 0;
        outImagePtr = outImagePtr | 0;

        var length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            images[outImagePtr + length | 0] = images[aImagePtr + length | 0] | 0 | (images[bImagePtr + length | 0] | 0) | 0;
        }
    }

    function countNonZero(imagePtr) {
        imagePtr = imagePtr | 0;

        var sum = 0,
            length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            sum = (sum | 0) + (images[imagePtr + length | 0] | 0) | 0;
        }

        return sum | 0;
    }

    function init(imagePtr, value) {
        imagePtr = imagePtr | 0;
        value = value | 0;

        var length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            images[imagePtr + length | 0] = value;
        }
    }

    function dilate(inImagePtr, outImagePtr) {
        inImagePtr = inImagePtr | 0;
        outImagePtr = outImagePtr | 0;

        var v = 0,
            u = 0,
            sum = 0,
            yStart1 = 0,
            yStart2 = 0,
            xStart1 = 0,
            xStart2 = 0,
            offset = 0;

        for (v = 1; (v | 0) < (size - 1 | 0); v = v + 1 | 0) {
            offset = offset + size | 0;
            for (u = 1; (u | 0) < (size - 1 | 0); u = u + 1 | 0) {
                yStart1 = offset - size | 0;
                yStart2 = offset + size | 0;
                xStart1 = u - 1 | 0;
                xStart2 = u + 1 | 0;
                sum = (images[inImagePtr + yStart1 + xStart1 | 0] | 0) + (images[inImagePtr + yStart1 + xStart2 | 0] | 0) + (images[inImagePtr + offset + u | 0] | 0) + (images[inImagePtr + yStart2 + xStart1 | 0] | 0) + (images[inImagePtr + yStart2 + xStart2 | 0] | 0) | 0;
                if ((sum | 0) > (0 | 0)) {
                    images[outImagePtr + offset + u | 0] = 1;
                } else {
                    images[outImagePtr + offset + u | 0] = 0;
                }
            }
        }
        return;
    }

    function memcpy(srcImagePtr, dstImagePtr) {
        srcImagePtr = srcImagePtr | 0;
        dstImagePtr = dstImagePtr | 0;

        var length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            images[dstImagePtr + length | 0] = images[srcImagePtr + length | 0] | 0;
        }
    }

    function zeroBorder(imagePtr) {
        imagePtr = imagePtr | 0;

        var x = 0,
            y = 0;

        for (x = 0; (x | 0) < (size - 1 | 0); x = x + 1 | 0) {
            images[imagePtr + x | 0] = 0;
            images[imagePtr + y | 0] = 0;
            y = y + size - 1 | 0;
            images[imagePtr + y | 0] = 0;
            y = y + 1 | 0;
        }
        for (x = 0; (x | 0) < (size | 0); x = x + 1 | 0) {
            images[imagePtr + y | 0] = 0;
            y = y + 1 | 0;
        }
    }

    function skeletonize() {
        var subImagePtr = 0,
            erodedImagePtr = 0,
            tempImagePtr = 0,
            skelImagePtr = 0,
            sum = 0,
            done = 0;

        erodedImagePtr = imul(size, size) | 0;
        tempImagePtr = erodedImagePtr + erodedImagePtr | 0;
        skelImagePtr = tempImagePtr + erodedImagePtr | 0;

        // init skel-image
        init(skelImagePtr, 0);
        zeroBorder(subImagePtr);

        do {
            erode(subImagePtr, erodedImagePtr);
            dilate(erodedImagePtr, tempImagePtr);
            subtract(subImagePtr, tempImagePtr, tempImagePtr);
            bitwiseOr(skelImagePtr, tempImagePtr, skelImagePtr);
            memcpy(erodedImagePtr, subImagePtr);
            sum = countNonZero(subImagePtr) | 0;
            done = (sum | 0) == 0 | 0;
        } while (!done);
    }
    return {
        skeletonize: skeletonize
    };
}
/* @preserve ASM END */
exports.default = Skeletonizer;
/* eslint-enable eqeqeq*/

/***/ },
/* 88 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _barcode_reader = __webpack_require__(10);

var _barcode_reader2 = _interopRequireDefault(_barcode_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function CodabarReader() {
    _barcode_reader2.default.call(this);
    this._counters = [];
}

var properties = {
    ALPHABETH_STRING: { value: "0123456789-$:/.+ABCD" },
    ALPHABET: { value: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 36, 58, 47, 46, 43, 65, 66, 67, 68] },
    CHARACTER_ENCODINGS: { value: [0x003, 0x006, 0x009, 0x060, 0x012, 0x042, 0x021, 0x024, 0x030, 0x048, 0x00c, 0x018, 0x045, 0x051, 0x054, 0x015, 0x01A, 0x029, 0x00B, 0x00E] },
    START_END: { value: [0x01A, 0x029, 0x00B, 0x00E] },
    MIN_ENCODED_CHARS: { value: 4 },
    MAX_ACCEPTABLE: { value: 2.0 },
    PADDING: { value: 1.5 },
    FORMAT: { value: "codabar", writeable: false }
};

CodabarReader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
CodabarReader.prototype.constructor = CodabarReader;

CodabarReader.prototype._decode = function () {
    var self = this,
        result = [],
        start,
        decodedChar,
        pattern,
        nextStart,
        end;

    this._counters = self._fillCounters();
    start = self._findStart();
    if (!start) {
        return null;
    }
    nextStart = start.startCounter;

    do {
        pattern = self._toPattern(nextStart);
        if (pattern < 0) {
            return null;
        }
        decodedChar = self._patternToChar(pattern);
        if (decodedChar < 0) {
            return null;
        }
        result.push(decodedChar);
        nextStart += 8;
        if (result.length > 1 && self._isStartEnd(pattern)) {
            break;
        }
    } while (nextStart < self._counters.length);

    // verify end
    if (result.length - 2 < self.MIN_ENCODED_CHARS || !self._isStartEnd(pattern)) {
        return null;
    }

    // verify end white space
    if (!self._verifyWhitespace(start.startCounter, nextStart - 8)) {
        return null;
    }

    if (!self._validateResult(result, start.startCounter)) {
        return null;
    }

    nextStart = nextStart > self._counters.length ? self._counters.length : nextStart;
    end = start.start + self._sumCounters(start.startCounter, nextStart - 8);

    return {
        code: result.join(""),
        start: start.start,
        end: end,
        startInfo: start,
        decodedCodes: result
    };
};

CodabarReader.prototype._verifyWhitespace = function (startCounter, endCounter) {
    if (startCounter - 1 <= 0 || this._counters[startCounter - 1] >= this._calculatePatternLength(startCounter) / 2.0) {
        if (endCounter + 8 >= this._counters.length || this._counters[endCounter + 7] >= this._calculatePatternLength(endCounter) / 2.0) {
            return true;
        }
    }
    return false;
};

CodabarReader.prototype._calculatePatternLength = function (offset) {
    var i,
        sum = 0;

    for (i = offset; i < offset + 7; i++) {
        sum += this._counters[i];
    }

    return sum;
};

CodabarReader.prototype._thresholdResultPattern = function (result, startCounter) {
    var self = this,
        categorization = {
        space: {
            narrow: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE },
            wide: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE }
        },
        bar: {
            narrow: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE },
            wide: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE }
        }
    },
        kind,
        cat,
        i,
        j,
        pos = startCounter,
        pattern;

    for (i = 0; i < result.length; i++) {
        pattern = self._charToPattern(result[i]);
        for (j = 6; j >= 0; j--) {
            kind = (j & 1) === 2 ? categorization.bar : categorization.space;
            cat = (pattern & 1) === 1 ? kind.wide : kind.narrow;
            cat.size += self._counters[pos + j];
            cat.counts++;
            pattern >>= 1;
        }
        pos += 8;
    }

    ["space", "bar"].forEach(function (key) {
        var newkind = categorization[key];
        newkind.wide.min = Math.floor((newkind.narrow.size / newkind.narrow.counts + newkind.wide.size / newkind.wide.counts) / 2);
        newkind.narrow.max = Math.ceil(newkind.wide.min);
        newkind.wide.max = Math.ceil((newkind.wide.size * self.MAX_ACCEPTABLE + self.PADDING) / newkind.wide.counts);
    });

    return categorization;
};

CodabarReader.prototype._charToPattern = function (char) {
    var self = this,
        charCode = char.charCodeAt(0),
        i;

    for (i = 0; i < self.ALPHABET.length; i++) {
        if (self.ALPHABET[i] === charCode) {
            return self.CHARACTER_ENCODINGS[i];
        }
    }
    return 0x0;
};

CodabarReader.prototype._validateResult = function (result, startCounter) {
    var self = this,
        thresholds = self._thresholdResultPattern(result, startCounter),
        i,
        j,
        kind,
        cat,
        size,
        pos = startCounter,
        pattern;

    for (i = 0; i < result.length; i++) {
        pattern = self._charToPattern(result[i]);
        for (j = 6; j >= 0; j--) {
            kind = (j & 1) === 0 ? thresholds.bar : thresholds.space;
            cat = (pattern & 1) === 1 ? kind.wide : kind.narrow;
            size = self._counters[pos + j];
            if (size < cat.min || size > cat.max) {
                return false;
            }
            pattern >>= 1;
        }
        pos += 8;
    }
    return true;
};

CodabarReader.prototype._patternToChar = function (pattern) {
    var i,
        self = this;

    for (i = 0; i < self.CHARACTER_ENCODINGS.length; i++) {
        if (self.CHARACTER_ENCODINGS[i] === pattern) {
            return String.fromCharCode(self.ALPHABET[i]);
        }
    }
    return -1;
};

CodabarReader.prototype._computeAlternatingThreshold = function (offset, end) {
    var i,
        min = Number.MAX_VALUE,
        max = 0,
        counter;

    for (i = offset; i < end; i += 2) {
        counter = this._counters[i];
        if (counter > max) {
            max = counter;
        }
        if (counter < min) {
            min = counter;
        }
    }

    return (min + max) / 2.0 | 0;
};

CodabarReader.prototype._toPattern = function (offset) {
    var numCounters = 7,
        end = offset + numCounters,
        barThreshold,
        spaceThreshold,
        bitmask = 1 << numCounters - 1,
        pattern = 0,
        i,
        threshold;

    if (end > this._counters.length) {
        return -1;
    }

    barThreshold = this._computeAlternatingThreshold(offset, end);
    spaceThreshold = this._computeAlternatingThreshold(offset + 1, end);

    for (i = 0; i < numCounters; i++) {
        threshold = (i & 1) === 0 ? barThreshold : spaceThreshold;
        if (this._counters[offset + i] > threshold) {
            pattern |= bitmask;
        }
        bitmask >>= 1;
    }

    return pattern;
};

CodabarReader.prototype._isStartEnd = function (pattern) {
    var i;

    for (i = 0; i < this.START_END.length; i++) {
        if (this.START_END[i] === pattern) {
            return true;
        }
    }
    return false;
};

CodabarReader.prototype._sumCounters = function (start, end) {
    var i,
        sum = 0;

    for (i = start; i < end; i++) {
        sum += this._counters[i];
    }
    return sum;
};

CodabarReader.prototype._findStart = function () {
    var self = this,
        i,
        pattern,
        start = self._nextUnset(self._row),
        end;

    for (i = 1; i < this._counters.length; i++) {
        pattern = self._toPattern(i);
        if (pattern !== -1 && self._isStartEnd(pattern)) {
            // TODO: Look for whitespace ahead
            start += self._sumCounters(0, i);
            end = start + self._sumCounters(i, i + 8);
            return {
                start: start,
                end: end,
                startCounter: i,
                endCounter: i + 8
            };
        }
    }
};

exports.default = CodabarReader;

/***/ },
/* 89 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _barcode_reader = __webpack_require__(10);

var _barcode_reader2 = _interopRequireDefault(_barcode_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Code128Reader() {
    _barcode_reader2.default.call(this);
}

var properties = {
    CODE_SHIFT: { value: 98 },
    CODE_C: { value: 99 },
    CODE_B: { value: 100 },
    CODE_A: { value: 101 },
    START_CODE_A: { value: 103 },
    START_CODE_B: { value: 104 },
    START_CODE_C: { value: 105 },
    STOP_CODE: { value: 106 },
    CODE_PATTERN: { value: [[2, 1, 2, 2, 2, 2], [2, 2, 2, 1, 2, 2], [2, 2, 2, 2, 2, 1], [1, 2, 1, 2, 2, 3], [1, 2, 1, 3, 2, 2], [1, 3, 1, 2, 2, 2], [1, 2, 2, 2, 1, 3], [1, 2, 2, 3, 1, 2], [1, 3, 2, 2, 1, 2], [2, 2, 1, 2, 1, 3], [2, 2, 1, 3, 1, 2], [2, 3, 1, 2, 1, 2], [1, 1, 2, 2, 3, 2], [1, 2, 2, 1, 3, 2], [1, 2, 2, 2, 3, 1], [1, 1, 3, 2, 2, 2], [1, 2, 3, 1, 2, 2], [1, 2, 3, 2, 2, 1], [2, 2, 3, 2, 1, 1], [2, 2, 1, 1, 3, 2], [2, 2, 1, 2, 3, 1], [2, 1, 3, 2, 1, 2], [2, 2, 3, 1, 1, 2], [3, 1, 2, 1, 3, 1], [3, 1, 1, 2, 2, 2], [3, 2, 1, 1, 2, 2], [3, 2, 1, 2, 2, 1], [3, 1, 2, 2, 1, 2], [3, 2, 2, 1, 1, 2], [3, 2, 2, 2, 1, 1], [2, 1, 2, 1, 2, 3], [2, 1, 2, 3, 2, 1], [2, 3, 2, 1, 2, 1], [1, 1, 1, 3, 2, 3], [1, 3, 1, 1, 2, 3], [1, 3, 1, 3, 2, 1], [1, 1, 2, 3, 1, 3], [1, 3, 2, 1, 1, 3], [1, 3, 2, 3, 1, 1], [2, 1, 1, 3, 1, 3], [2, 3, 1, 1, 1, 3], [2, 3, 1, 3, 1, 1], [1, 1, 2, 1, 3, 3], [1, 1, 2, 3, 3, 1], [1, 3, 2, 1, 3, 1], [1, 1, 3, 1, 2, 3], [1, 1, 3, 3, 2, 1], [1, 3, 3, 1, 2, 1], [3, 1, 3, 1, 2, 1], [2, 1, 1, 3, 3, 1], [2, 3, 1, 1, 3, 1], [2, 1, 3, 1, 1, 3], [2, 1, 3, 3, 1, 1], [2, 1, 3, 1, 3, 1], [3, 1, 1, 1, 2, 3], [3, 1, 1, 3, 2, 1], [3, 3, 1, 1, 2, 1], [3, 1, 2, 1, 1, 3], [3, 1, 2, 3, 1, 1], [3, 3, 2, 1, 1, 1], [3, 1, 4, 1, 1, 1], [2, 2, 1, 4, 1, 1], [4, 3, 1, 1, 1, 1], [1, 1, 1, 2, 2, 4], [1, 1, 1, 4, 2, 2], [1, 2, 1, 1, 2, 4], [1, 2, 1, 4, 2, 1], [1, 4, 1, 1, 2, 2], [1, 4, 1, 2, 2, 1], [1, 1, 2, 2, 1, 4], [1, 1, 2, 4, 1, 2], [1, 2, 2, 1, 1, 4], [1, 2, 2, 4, 1, 1], [1, 4, 2, 1, 1, 2], [1, 4, 2, 2, 1, 1], [2, 4, 1, 2, 1, 1], [2, 2, 1, 1, 1, 4], [4, 1, 3, 1, 1, 1], [2, 4, 1, 1, 1, 2], [1, 3, 4, 1, 1, 1], [1, 1, 1, 2, 4, 2], [1, 2, 1, 1, 4, 2], [1, 2, 1, 2, 4, 1], [1, 1, 4, 2, 1, 2], [1, 2, 4, 1, 1, 2], [1, 2, 4, 2, 1, 1], [4, 1, 1, 2, 1, 2], [4, 2, 1, 1, 1, 2], [4, 2, 1, 2, 1, 1], [2, 1, 2, 1, 4, 1], [2, 1, 4, 1, 2, 1], [4, 1, 2, 1, 2, 1], [1, 1, 1, 1, 4, 3], [1, 1, 1, 3, 4, 1], [1, 3, 1, 1, 4, 1], [1, 1, 4, 1, 1, 3], [1, 1, 4, 3, 1, 1], [4, 1, 1, 1, 1, 3], [4, 1, 1, 3, 1, 1], [1, 1, 3, 1, 4, 1], [1, 1, 4, 1, 3, 1], [3, 1, 1, 1, 4, 1], [4, 1, 1, 1, 3, 1], [2, 1, 1, 4, 1, 2], [2, 1, 1, 2, 1, 4], [2, 1, 1, 2, 3, 2], [2, 3, 3, 1, 1, 1, 2]] },
    SINGLE_CODE_ERROR: { value: 0.64 },
    AVG_CODE_ERROR: { value: 0.30 },
    FORMAT: { value: "code_128", writeable: false },
    MODULE_INDICES: { value: { bar: [0, 2, 4], space: [1, 3, 5] } }
};

Code128Reader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
Code128Reader.prototype.constructor = Code128Reader;

Code128Reader.prototype._decodeCode = function (start, correction) {
    var counter = [0, 0, 0, 0, 0, 0],
        i,
        self = this,
        offset = start,
        isWhite = !self._row[offset],
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: start,
        end: start,
        correction: {
            bar: 1,
            space: 1
        }
    },
        code,
        error;

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                if (correction) {
                    self._correct(counter, correction);
                }
                for (code = 0; code < self.CODE_PATTERN.length; code++) {
                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
                    if (error < bestMatch.error) {
                        bestMatch.code = code;
                        bestMatch.error = error;
                    }
                }
                bestMatch.end = i;
                if (bestMatch.code === -1 || bestMatch.error > self.AVG_CODE_ERROR) {
                    return null;
                }
                if (self.CODE_PATTERN[bestMatch.code]) {
                    bestMatch.correction.bar = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.bar);
                    bestMatch.correction.space = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.space);
                }
                return bestMatch;
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

Code128Reader.prototype._correct = function (counter, correction) {
    this._correctBars(counter, correction.bar, this.MODULE_INDICES.bar);
    this._correctBars(counter, correction.space, this.MODULE_INDICES.space);
};

Code128Reader.prototype._findStart = function () {
    var counter = [0, 0, 0, 0, 0, 0],
        i,
        self = this,
        offset = self._nextSet(self._row),
        isWhite = false,
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0,
        correction: {
            bar: 1,
            space: 1
        }
    },
        code,
        error,
        j,
        sum;

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                sum = 0;
                for (j = 0; j < counter.length; j++) {
                    sum += counter[j];
                }
                for (code = self.START_CODE_A; code <= self.START_CODE_C; code++) {
                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
                    if (error < bestMatch.error) {
                        bestMatch.code = code;
                        bestMatch.error = error;
                    }
                }
                if (bestMatch.error < self.AVG_CODE_ERROR) {
                    bestMatch.start = i - sum;
                    bestMatch.end = i;
                    bestMatch.correction.bar = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.bar);
                    bestMatch.correction.space = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.space);
                    return bestMatch;
                }

                for (j = 0; j < 4; j++) {
                    counter[j] = counter[j + 2];
                }
                counter[4] = 0;
                counter[5] = 0;
                counterPos--;
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

Code128Reader.prototype._decode = function () {
    var self = this,
        startInfo = self._findStart(),
        code = null,
        done = false,
        result = [],
        multiplier = 0,
        checksum = 0,
        codeset,
        rawResult = [],
        decodedCodes = [],
        shiftNext = false,
        unshift,
        removeLastCharacter = true;

    if (startInfo === null) {
        return null;
    }
    code = {
        code: startInfo.code,
        start: startInfo.start,
        end: startInfo.end,
        correction: {
            bar: startInfo.correction.bar,
            space: startInfo.correction.space
        }
    };
    decodedCodes.push(code);
    checksum = code.code;
    switch (code.code) {
        case self.START_CODE_A:
            codeset = self.CODE_A;
            break;
        case self.START_CODE_B:
            codeset = self.CODE_B;
            break;
        case self.START_CODE_C:
            codeset = self.CODE_C;
            break;
        default:
            return null;
    }

    while (!done) {
        unshift = shiftNext;
        shiftNext = false;
        code = self._decodeCode(code.end, code.correction);
        if (code !== null) {
            if (code.code !== self.STOP_CODE) {
                removeLastCharacter = true;
            }

            if (code.code !== self.STOP_CODE) {
                rawResult.push(code.code);
                multiplier++;
                checksum += multiplier * code.code;
            }
            decodedCodes.push(code);

            switch (codeset) {
                case self.CODE_A:
                    if (code.code < 64) {
                        result.push(String.fromCharCode(32 + code.code));
                    } else if (code.code < 96) {
                        result.push(String.fromCharCode(code.code - 64));
                    } else {
                        if (code.code !== self.STOP_CODE) {
                            removeLastCharacter = false;
                        }
                        switch (code.code) {
                            case self.CODE_SHIFT:
                                shiftNext = true;
                                codeset = self.CODE_B;
                                break;
                            case self.CODE_B:
                                codeset = self.CODE_B;
                                break;
                            case self.CODE_C:
                                codeset = self.CODE_C;
                                break;
                            case self.STOP_CODE:
                                done = true;
                                break;
                        }
                    }
                    break;
                case self.CODE_B:
                    if (code.code < 96) {
                        result.push(String.fromCharCode(32 + code.code));
                    } else {
                        if (code.code !== self.STOP_CODE) {
                            removeLastCharacter = false;
                        }
                        switch (code.code) {
                            case self.CODE_SHIFT:
                                shiftNext = true;
                                codeset = self.CODE_A;
                                break;
                            case self.CODE_A:
                                codeset = self.CODE_A;
                                break;
                            case self.CODE_C:
                                codeset = self.CODE_C;
                                break;
                            case self.STOP_CODE:
                                done = true;
                                break;
                        }
                    }
                    break;
                case self.CODE_C:
                    if (code.code < 100) {
                        result.push(code.code < 10 ? "0" + code.code : code.code);
                    } else {
                        if (code.code !== self.STOP_CODE) {
                            removeLastCharacter = false;
                        }
                        switch (code.code) {
                            case self.CODE_A:
                                codeset = self.CODE_A;
                                break;
                            case self.CODE_B:
                                codeset = self.CODE_B;
                                break;
                            case self.STOP_CODE:
                                done = true;
                                break;
                        }
                    }
                    break;
            }
        } else {
            done = true;
        }
        if (unshift) {
            codeset = codeset === self.CODE_A ? self.CODE_B : self.CODE_A;
        }
    }

    if (code === null) {
        return null;
    }

    code.end = self._nextUnset(self._row, code.end);
    if (!self._verifyTrailingWhitespace(code)) {
        return null;
    }

    checksum -= multiplier * rawResult[rawResult.length - 1];
    if (checksum % 103 !== rawResult[rawResult.length - 1]) {
        return null;
    }

    if (!result.length) {
        return null;
    }

    // remove last code from result (checksum)
    if (removeLastCharacter) {
        result.splice(result.length - 1, 1);
    }

    return {
        code: result.join(""),
        start: startInfo.start,
        end: code.end,
        codeset: codeset,
        startInfo: startInfo,
        decodedCodes: decodedCodes,
        endInfo: code
    };
};

_barcode_reader2.default.prototype._verifyTrailingWhitespace = function (endInfo) {
    var self = this,
        trailingWhitespaceEnd;

    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
    if (trailingWhitespaceEnd < self._row.length) {
        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
            return endInfo;
        }
    }
    return null;
};

function calculateCorrection(expected, normalized, indices) {
    var length = indices.length,
        sumNormalized = 0,
        sumExpected = 0;

    while (length--) {
        sumExpected += expected[indices[length]];
        sumNormalized += normalized[indices[length]];
    }
    return sumExpected / sumNormalized;
}

exports.default = Code128Reader;

/***/ },
/* 90 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _code_39_reader = __webpack_require__(43);

var _code_39_reader2 = _interopRequireDefault(_code_39_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Code39VINReader() {
    _code_39_reader2.default.call(this);
}

var patterns = {
    IOQ: /[IOQ]/g,
    AZ09: /[A-Z0-9]{17}/
};

Code39VINReader.prototype = Object.create(_code_39_reader2.default.prototype);
Code39VINReader.prototype.constructor = Code39VINReader;

// Cribbed from:
// https://github.com/zxing/zxing/blob/master/core/src/main/java/com/google/zxing/client/result/VINResultParser.java
Code39VINReader.prototype._decode = function () {
    var result = _code_39_reader2.default.prototype._decode.apply(this);
    if (!result) {
        return null;
    }

    var code = result.code;

    if (!code) {
        return null;
    }

    code = code.replace(patterns.IOQ, '');

    if (!code.match(patterns.AZ09)) {
        if (false) {
            console.log('Failed AZ09 pattern code:', code);
        }
        return null;
    }

    if (!this._checkChecksum(code)) {
        return null;
    }

    result.code = code;
    return result;
};

Code39VINReader.prototype._checkChecksum = function (code) {
    // TODO
    return !!code;
};

exports.default = Code39VINReader;

/***/ },
/* 91 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _ean_reader = __webpack_require__(5);

var _ean_reader2 = _interopRequireDefault(_ean_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function EAN2Reader() {
    _ean_reader2.default.call(this);
}

var properties = {
    FORMAT: { value: "ean_2", writeable: false }
};

EAN2Reader.prototype = Object.create(_ean_reader2.default.prototype, properties);
EAN2Reader.prototype.constructor = EAN2Reader;

EAN2Reader.prototype.decode = function (row, start) {
    this._row = row;
    var counters = [0, 0, 0, 0],
        codeFrequency = 0,
        i = 0,
        offset = start,
        end = this._row.length,
        code,
        result = [],
        decodedCodes = [];

    for (i = 0; i < 2 && offset < end; i++) {
        code = this._decodeCode(offset);
        if (!code) {
            return null;
        }
        decodedCodes.push(code);
        result.push(code.code % 10);
        if (code.code >= this.CODE_G_START) {
            codeFrequency |= 1 << 1 - i;
        }
        if (i != 1) {
            offset = this._nextSet(this._row, code.end);
            offset = this._nextUnset(this._row, offset);
        }
    }

    if (result.length != 2 || parseInt(result.join("")) % 4 !== codeFrequency) {
        return null;
    }
    return {
        code: result.join(""),
        decodedCodes: decodedCodes,
        end: code.end
    };
};

exports.default = EAN2Reader;

/***/ },
/* 92 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _ean_reader = __webpack_require__(5);

var _ean_reader2 = _interopRequireDefault(_ean_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function EAN5Reader() {
    _ean_reader2.default.call(this);
}

var properties = {
    FORMAT: { value: "ean_5", writeable: false }
};

var CHECK_DIGIT_ENCODINGS = [24, 20, 18, 17, 12, 6, 3, 10, 9, 5];

EAN5Reader.prototype = Object.create(_ean_reader2.default.prototype, properties);
EAN5Reader.prototype.constructor = EAN5Reader;

EAN5Reader.prototype.decode = function (row, start) {
    this._row = row;
    var counters = [0, 0, 0, 0],
        codeFrequency = 0,
        i = 0,
        offset = start,
        end = this._row.length,
        code,
        result = [],
        decodedCodes = [];

    for (i = 0; i < 5 && offset < end; i++) {
        code = this._decodeCode(offset);
        if (!code) {
            return null;
        }
        decodedCodes.push(code);
        result.push(code.code % 10);
        if (code.code >= this.CODE_G_START) {
            codeFrequency |= 1 << 4 - i;
        }
        if (i != 4) {
            offset = this._nextSet(this._row, code.end);
            offset = this._nextUnset(this._row, offset);
        }
    }

    if (result.length != 5) {
        return null;
    }

    if (extensionChecksum(result) !== determineCheckDigit(codeFrequency)) {
        return null;
    }
    return {
        code: result.join(""),
        decodedCodes: decodedCodes,
        end: code.end
    };
};

function determineCheckDigit(codeFrequency) {
    var i;
    for (i = 0; i < 10; i++) {
        if (codeFrequency === CHECK_DIGIT_ENCODINGS[i]) {
            return i;
        }
    }
    return null;
}

function extensionChecksum(result) {
    var length = result.length,
        sum = 0,
        i;

    for (i = length - 2; i >= 0; i -= 2) {
        sum += result[i];
    }
    sum *= 3;
    for (i = length - 1; i >= 0; i -= 2) {
        sum += result[i];
    }
    sum *= 3;
    return sum % 10;
}

exports.default = EAN5Reader;

/***/ },
/* 93 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _ean_reader = __webpack_require__(5);

var _ean_reader2 = _interopRequireDefault(_ean_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function EAN8Reader(opts, supplements) {
    _ean_reader2.default.call(this, opts, supplements);
}

var properties = {
    FORMAT: { value: "ean_8", writeable: false }
};

EAN8Reader.prototype = Object.create(_ean_reader2.default.prototype, properties);
EAN8Reader.prototype.constructor = EAN8Reader;

EAN8Reader.prototype._decodePayload = function (code, result, decodedCodes) {
    var i,
        self = this;

    for (i = 0; i < 4; i++) {
        code = self._decodeCode(code.end, self.CODE_G_START);
        if (!code) {
            return null;
        }
        result.push(code.code);
        decodedCodes.push(code);
    }

    code = self._findPattern(self.MIDDLE_PATTERN, code.end, true, false);
    if (code === null) {
        return null;
    }
    decodedCodes.push(code);

    for (i = 0; i < 4; i++) {
        code = self._decodeCode(code.end, self.CODE_G_START);
        if (!code) {
            return null;
        }
        decodedCodes.push(code);
        result.push(code.code);
    }

    return code;
};

exports.default = EAN8Reader;

/***/ },
/* 94 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _merge2 = __webpack_require__(40);

var _merge3 = _interopRequireDefault(_merge2);

var _barcode_reader = __webpack_require__(10);

var _barcode_reader2 = _interopRequireDefault(_barcode_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function I2of5Reader(opts) {
    opts = (0, _merge3.default)(getDefaulConfig(), opts);
    _barcode_reader2.default.call(this, opts);
    this.barSpaceRatio = [1, 1];
    if (opts.normalizeBarSpaceWidth) {
        this.SINGLE_CODE_ERROR = 0.38;
        this.AVG_CODE_ERROR = 0.09;
    }
}

function getDefaulConfig() {
    var config = {};

    Object.keys(I2of5Reader.CONFIG_KEYS).forEach(function (key) {
        config[key] = I2of5Reader.CONFIG_KEYS[key].default;
    });
    return config;
}

var N = 1,
    W = 3,
    properties = {
    START_PATTERN: { value: [N, N, N, N] },
    STOP_PATTERN: { value: [N, N, W] },
    CODE_PATTERN: { value: [[N, N, W, W, N], [W, N, N, N, W], [N, W, N, N, W], [W, W, N, N, N], [N, N, W, N, W], [W, N, W, N, N], [N, W, W, N, N], [N, N, N, W, W], [W, N, N, W, N], [N, W, N, W, N]] },
    SINGLE_CODE_ERROR: { value: 0.78, writable: true },
    AVG_CODE_ERROR: { value: 0.38, writable: true },
    MAX_CORRECTION_FACTOR: { value: 5 },
    FORMAT: { value: "i2of5" }
};

I2of5Reader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
I2of5Reader.prototype.constructor = I2of5Reader;

I2of5Reader.prototype._matchPattern = function (counter, code) {
    if (this.config.normalizeBarSpaceWidth) {
        var i,
            counterSum = [0, 0],
            codeSum = [0, 0],
            correction = [0, 0],
            correctionRatio = this.MAX_CORRECTION_FACTOR,
            correctionRatioInverse = 1 / correctionRatio;

        for (i = 0; i < counter.length; i++) {
            counterSum[i % 2] += counter[i];
            codeSum[i % 2] += code[i];
        }
        correction[0] = codeSum[0] / counterSum[0];
        correction[1] = codeSum[1] / counterSum[1];

        correction[0] = Math.max(Math.min(correction[0], correctionRatio), correctionRatioInverse);
        correction[1] = Math.max(Math.min(correction[1], correctionRatio), correctionRatioInverse);
        this.barSpaceRatio = correction;
        for (i = 0; i < counter.length; i++) {
            counter[i] *= this.barSpaceRatio[i % 2];
        }
    }
    return _barcode_reader2.default.prototype._matchPattern.call(this, counter, code);
};

I2of5Reader.prototype._findPattern = function (pattern, offset, isWhite, tryHarder) {
    var counter = [],
        self = this,
        i,
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0
    },
        error,
        j,
        sum,
        normalized,
        epsilon = self.AVG_CODE_ERROR;

    isWhite = isWhite || false;
    tryHarder = tryHarder || false;

    if (!offset) {
        offset = self._nextSet(self._row);
    }

    for (i = 0; i < pattern.length; i++) {
        counter[i] = 0;
    }

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                sum = 0;
                for (j = 0; j < counter.length; j++) {
                    sum += counter[j];
                }
                error = self._matchPattern(counter, pattern);
                if (error < epsilon) {
                    bestMatch.error = error;
                    bestMatch.start = i - sum;
                    bestMatch.end = i;
                    return bestMatch;
                }
                if (tryHarder) {
                    for (j = 0; j < counter.length - 2; j++) {
                        counter[j] = counter[j + 2];
                    }
                    counter[counter.length - 2] = 0;
                    counter[counter.length - 1] = 0;
                    counterPos--;
                } else {
                    return null;
                }
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

I2of5Reader.prototype._findStart = function () {
    var self = this,
        leadingWhitespaceStart,
        offset = self._nextSet(self._row),
        startInfo,
        narrowBarWidth = 1;

    while (!startInfo) {
        startInfo = self._findPattern(self.START_PATTERN, offset, false, true);
        if (!startInfo) {
            return null;
        }
        narrowBarWidth = Math.floor((startInfo.end - startInfo.start) / 4);
        leadingWhitespaceStart = startInfo.start - narrowBarWidth * 10;
        if (leadingWhitespaceStart >= 0) {
            if (self._matchRange(leadingWhitespaceStart, startInfo.start, 0)) {
                return startInfo;
            }
        }
        offset = startInfo.end;
        startInfo = null;
    }
};

I2of5Reader.prototype._verifyTrailingWhitespace = function (endInfo) {
    var self = this,
        trailingWhitespaceEnd;

    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
    if (trailingWhitespaceEnd < self._row.length) {
        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
            return endInfo;
        }
    }
    return null;
};

I2of5Reader.prototype._findEnd = function () {
    var self = this,
        endInfo,
        tmp;

    self._row.reverse();
    endInfo = self._findPattern(self.STOP_PATTERN);
    self._row.reverse();

    if (endInfo === null) {
        return null;
    }

    // reverse numbers
    tmp = endInfo.start;
    endInfo.start = self._row.length - endInfo.end;
    endInfo.end = self._row.length - tmp;

    return endInfo !== null ? self._verifyTrailingWhitespace(endInfo) : null;
};

I2of5Reader.prototype._decodePair = function (counterPair) {
    var i,
        code,
        codes = [],
        self = this;

    for (i = 0; i < counterPair.length; i++) {
        code = self._decodeCode(counterPair[i]);
        if (!code) {
            return null;
        }
        codes.push(code);
    }
    return codes;
};

I2of5Reader.prototype._decodeCode = function (counter) {
    var j,
        self = this,
        sum = 0,
        normalized,
        error,
        epsilon = self.AVG_CODE_ERROR,
        code,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0
    };

    for (j = 0; j < counter.length; j++) {
        sum += counter[j];
    }
    for (code = 0; code < self.CODE_PATTERN.length; code++) {
        error = self._matchPattern(counter, self.CODE_PATTERN[code]);
        if (error < bestMatch.error) {
            bestMatch.code = code;
            bestMatch.error = error;
        }
    }
    if (bestMatch.error < epsilon) {
        return bestMatch;
    }
};

I2of5Reader.prototype._decodePayload = function (counters, result, decodedCodes) {
    var i,
        self = this,
        pos = 0,
        counterLength = counters.length,
        counterPair = [[0, 0, 0, 0, 0], [0, 0, 0, 0, 0]],
        codes;

    while (pos < counterLength) {
        for (i = 0; i < 5; i++) {
            counterPair[0][i] = counters[pos] * this.barSpaceRatio[0];
            counterPair[1][i] = counters[pos + 1] * this.barSpaceRatio[1];
            pos += 2;
        }
        codes = self._decodePair(counterPair);
        if (!codes) {
            return null;
        }
        for (i = 0; i < codes.length; i++) {
            result.push(codes[i].code + "");
            decodedCodes.push(codes[i]);
        }
    }
    return codes;
};

I2of5Reader.prototype._verifyCounterLength = function (counters) {
    return counters.length % 10 === 0;
};

I2of5Reader.prototype._decode = function () {
    var startInfo,
        endInfo,
        self = this,
        code,
        result = [],
        decodedCodes = [],
        counters;

    startInfo = self._findStart();
    if (!startInfo) {
        return null;
    }
    decodedCodes.push(startInfo);

    endInfo = self._findEnd();
    if (!endInfo) {
        return null;
    }

    counters = self._fillCounters(startInfo.end, endInfo.start, false);
    if (!self._verifyCounterLength(counters)) {
        return null;
    }
    code = self._decodePayload(counters, result, decodedCodes);
    if (!code) {
        return null;
    }
    if (result.length % 2 !== 0 || result.length < 6) {
        return null;
    }

    decodedCodes.push(endInfo);
    return {
        code: result.join(""),
        start: startInfo.start,
        end: endInfo.end,
        startInfo: startInfo,
        decodedCodes: decodedCodes
    };
};

I2of5Reader.CONFIG_KEYS = {
    normalizeBarSpaceWidth: {
        'type': 'boolean',
        'default': false,
        'description': 'If true, the reader tries to normalize the' + 'width-difference between bars and spaces'
    }
};

exports.default = I2of5Reader;

/***/ },
/* 95 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _ean_reader = __webpack_require__(5);

var _ean_reader2 = _interopRequireDefault(_ean_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function UPCEReader(opts, supplements) {
    _ean_reader2.default.call(this, opts, supplements);
}

var properties = {
    CODE_FREQUENCY: { value: [[56, 52, 50, 49, 44, 38, 35, 42, 41, 37], [7, 11, 13, 14, 19, 25, 28, 21, 22, 26]] },
    STOP_PATTERN: { value: [1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7] },
    FORMAT: { value: "upc_e", writeable: false }
};

UPCEReader.prototype = Object.create(_ean_reader2.default.prototype, properties);
UPCEReader.prototype.constructor = UPCEReader;

UPCEReader.prototype._decodePayload = function (code, result, decodedCodes) {
    var i,
        self = this,
        codeFrequency = 0x0;

    for (i = 0; i < 6; i++) {
        code = self._decodeCode(code.end);
        if (!code) {
            return null;
        }
        if (code.code >= self.CODE_G_START) {
            code.code = code.code - self.CODE_G_START;
            codeFrequency |= 1 << 5 - i;
        }
        result.push(code.code);
        decodedCodes.push(code);
    }
    if (!self._determineParity(codeFrequency, result)) {
        return null;
    }

    return code;
};

UPCEReader.prototype._determineParity = function (codeFrequency, result) {
    var i, nrSystem;

    for (nrSystem = 0; nrSystem < this.CODE_FREQUENCY.length; nrSystem++) {
        for (i = 0; i < this.CODE_FREQUENCY[nrSystem].length; i++) {
            if (codeFrequency === this.CODE_FREQUENCY[nrSystem][i]) {
                result.unshift(nrSystem);
                result.push(i);
                return true;
            }
        }
    }
    return false;
};

UPCEReader.prototype._convertToUPCA = function (result) {
    var upca = [result[0]],
        lastDigit = result[result.length - 2];

    if (lastDigit <= 2) {
        upca = upca.concat(result.slice(1, 3)).concat([lastDigit, 0, 0, 0, 0]).concat(result.slice(3, 6));
    } else if (lastDigit === 3) {
        upca = upca.concat(result.slice(1, 4)).concat([0, 0, 0, 0, 0]).concat(result.slice(4, 6));
    } else if (lastDigit === 4) {
        upca = upca.concat(result.slice(1, 5)).concat([0, 0, 0, 0, 0, result[5]]);
    } else {
        upca = upca.concat(result.slice(1, 6)).concat([0, 0, 0, 0, lastDigit]);
    }

    upca.push(result[result.length - 1]);
    return upca;
};

UPCEReader.prototype._checksum = function (result) {
    return _ean_reader2.default.prototype._checksum.call(this, this._convertToUPCA(result));
};

UPCEReader.prototype._findEnd = function (offset, isWhite) {
    isWhite = true;
    return _ean_reader2.default.prototype._findEnd.call(this, offset, isWhite);
};

UPCEReader.prototype._verifyTrailingWhitespace = function (endInfo) {
    var self = this,
        trailingWhitespaceEnd;

    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
    if (trailingWhitespaceEnd < self._row.length) {
        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
            return endInfo;
        }
    }
};

exports.default = UPCEReader;

/***/ },
/* 96 */
/***/ function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _ean_reader = __webpack_require__(5);

var _ean_reader2 = _interopRequireDefault(_ean_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function UPCReader(opts, supplements) {
    _ean_reader2.default.call(this, opts, supplements);
}

var properties = {
    FORMAT: { value: "upc_a", writeable: false }
};

UPCReader.prototype = Object.create(_ean_reader2.default.prototype, properties);
UPCReader.prototype.constructor = UPCReader;

UPCReader.prototype._decode = function () {
    var result = _ean_reader2.default.prototype._decode.call(this);

    if (result && result.code && result.code.length === 13 && result.code.charAt(0) === "0") {
        result.code = result.code.substring(1);
        return result;
    }
    return null;
};

exports.default = UPCReader;

/***/ },
/* 97 */
/***/ function(module, exports) {

module.exports = copy

/**
 * Copy the values from one mat2 to another
 *
 * @alias mat2.copy
 * @param {mat2} out the receiving matrix
 * @param {mat2} a the source matrix
 * @returns {mat2} out
 */
function copy(out, a) {
  out[0] = a[0]
  out[1] = a[1]
  out[2] = a[2]
  out[3] = a[3]
  return out
}


/***/ },
/* 98 */
/***/ function(module, exports) {

module.exports = create

/**
 * Creates a new identity mat2
 *
 * @alias mat2.create
 * @returns {mat2} a new 2x2 matrix
 */
function create() {
  var out = new Float32Array(4)
  out[0] = 1
  out[1] = 0
  out[2] = 0
  out[3] = 1
  return out
}


/***/ },
/* 99 */
/***/ function(module, exports) {

module.exports = invert

/**
 * Inverts a mat2
 *
 * @alias mat2.invert
 * @param {mat2} out the receiving matrix
 * @param {mat2} a the source matrix
 * @returns {mat2} out
 */
function invert(out, a) {
  var a0 = a[0]
  var a1 = a[1]
  var a2 = a[2]
  var a3 = a[3]
  var det = a0 * a3 - a2 * a1

  if (!det) return null
  det = 1.0 / det

  out[0] =  a3 * det
  out[1] = -a1 * det
  out[2] = -a2 * det
  out[3] =  a0 * det

  return out
}


/***/ },
/* 100 */
/***/ function(module, exports) {

module.exports = scale

/**
 * Scales a vec2 by a scalar number
 *
 * @param {vec2} out the receiving vector
 * @param {vec2} a the vector to scale
 * @param {Number} b amount to scale the vector by
 * @returns {vec2} out
 */
function scale(out, a, b) {
    out[0] = a[0] * b
    out[1] = a[1] * b
    return out
}

/***/ },
/* 101 */
/***/ function(module, exports) {

module.exports = transformMat2

/**
 * Transforms the vec2 with a mat2
 *
 * @param {vec2} out the receiving vector
 * @param {vec2} a the vector to transform
 * @param {mat2} m matrix to transform with
 * @returns {vec2} out
 */
function transformMat2(out, a, m) {
    var x = a[0],
        y = a[1]
    out[0] = m[0] * x + m[2] * y
    out[1] = m[1] * x + m[3] * y
    return out
}

/***/ },
/* 102 */
/***/ function(module, exports) {

module.exports = clone;

/**
 * Creates a new vec3 initialized with values from an existing vector
 *
 * @param {vec3} a vector to clone
 * @returns {vec3} a new 3D vector
 */
function clone(a) {
    var out = new Float32Array(3)
    out[0] = a[0]
    out[1] = a[1]
    out[2] = a[2]
    return out
}

/***/ },
/* 103 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4),
    root = __webpack_require__(1);

/* Built-in method references that are verified to be native. */
var DataView = getNative(root, 'DataView');

module.exports = DataView;


/***/ },
/* 104 */
/***/ function(module, exports, __webpack_require__) {

var hashClear = __webpack_require__(154),
    hashDelete = __webpack_require__(155),
    hashGet = __webpack_require__(156),
    hashHas = __webpack_require__(157),
    hashSet = __webpack_require__(158);

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

module.exports = Hash;


/***/ },
/* 105 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4),
    root = __webpack_require__(1);

/* Built-in method references that are verified to be native. */
var Promise = getNative(root, 'Promise');

module.exports = Promise;


/***/ },
/* 106 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4),
    root = __webpack_require__(1);

/* Built-in method references that are verified to be native. */
var Set = getNative(root, 'Set');

module.exports = Set;


/***/ },
/* 107 */
/***/ function(module, exports, __webpack_require__) {

var root = __webpack_require__(1);

/** Built-in value references. */
var Uint8Array = root.Uint8Array;

module.exports = Uint8Array;


/***/ },
/* 108 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4),
    root = __webpack_require__(1);

/* Built-in method references that are verified to be native. */
var WeakMap = getNative(root, 'WeakMap');

module.exports = WeakMap;


/***/ },
/* 109 */
/***/ function(module, exports) {

/**
 * Adds the key-value `pair` to `map`.
 *
 * @private
 * @param {Object} map The map to modify.
 * @param {Array} pair The key-value pair to add.
 * @returns {Object} Returns `map`.
 */
function addMapEntry(map, pair) {
  // Don't return `map.set` because it's not chainable in IE 11.
  map.set(pair[0], pair[1]);
  return map;
}

module.exports = addMapEntry;


/***/ },
/* 110 */
/***/ function(module, exports) {

/**
 * Adds `value` to `set`.
 *
 * @private
 * @param {Object} set The set to modify.
 * @param {*} value The value to add.
 * @returns {Object} Returns `set`.
 */
function addSetEntry(set, value) {
  // Don't return `set.add` because it's not chainable in IE 11.
  set.add(value);
  return set;
}

module.exports = addSetEntry;


/***/ },
/* 111 */
/***/ function(module, exports) {

/**
 * A faster alternative to `Function#apply`, this function invokes `func`
 * with the `this` binding of `thisArg` and the arguments of `args`.
 *
 * @private
 * @param {Function} func The function to invoke.
 * @param {*} thisArg The `this` binding of `func`.
 * @param {Array} args The arguments to invoke `func` with.
 * @returns {*} Returns the result of `func`.
 */
function apply(func, thisArg, args) {
  switch (args.length) {
    case 0: return func.call(thisArg);
    case 1: return func.call(thisArg, args[0]);
    case 2: return func.call(thisArg, args[0], args[1]);
    case 3: return func.call(thisArg, args[0], args[1], args[2]);
  }
  return func.apply(thisArg, args);
}

module.exports = apply;


/***/ },
/* 112 */
/***/ function(module, exports) {

/**
 * A specialized version of `_.forEach` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns `array`.
 */
function arrayEach(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (iteratee(array[index], index, array) === false) {
      break;
    }
  }
  return array;
}

module.exports = arrayEach;


/***/ },
/* 113 */
/***/ function(module, exports) {

/**
 * A specialized version of `_.filter` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function arrayFilter(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length,
      resIndex = 0,
      result = [];

  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}

module.exports = arrayFilter;


/***/ },
/* 114 */
/***/ function(module, exports, __webpack_require__) {

var copyObject = __webpack_require__(8),
    keys = __webpack_require__(39);

/**
 * The base implementation of `_.assign` without support for multiple sources
 * or `customizer` functions.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @returns {Object} Returns `object`.
 */
function baseAssign(object, source) {
  return object && copyObject(source, keys(source), object);
}

module.exports = baseAssign;


/***/ },
/* 115 */
/***/ function(module, exports, __webpack_require__) {

var copyObject = __webpack_require__(8),
    keysIn = __webpack_require__(24);

/**
 * The base implementation of `_.assignIn` without support for multiple sources
 * or `customizer` functions.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @returns {Object} Returns `object`.
 */
function baseAssignIn(object, source) {
  return object && copyObject(source, keysIn(source), object);
}

module.exports = baseAssignIn;


/***/ },
/* 116 */
/***/ function(module, exports, __webpack_require__) {

var Stack = __webpack_require__(46),
    arrayEach = __webpack_require__(112),
    assignValue = __webpack_require__(29),
    baseAssign = __webpack_require__(114),
    baseAssignIn = __webpack_require__(115),
    cloneBuffer = __webpack_require__(53),
    copyArray = __webpack_require__(55),
    copySymbols = __webpack_require__(143),
    copySymbolsIn = __webpack_require__(144),
    getAllKeys = __webpack_require__(149),
    getAllKeysIn = __webpack_require__(59),
    getTag = __webpack_require__(151),
    initCloneArray = __webpack_require__(159),
    initCloneByTag = __webpack_require__(160),
    initCloneObject = __webpack_require__(61),
    isArray = __webpack_require__(2),
    isBuffer = __webpack_require__(35),
    isObject = __webpack_require__(3),
    keys = __webpack_require__(39);

/** Used to compose bitmasks for cloning. */
var CLONE_DEEP_FLAG = 1,
    CLONE_FLAT_FLAG = 2,
    CLONE_SYMBOLS_FLAG = 4;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values supported by `_.clone`. */
var cloneableTags = {};
cloneableTags[argsTag] = cloneableTags[arrayTag] =
cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] =
cloneableTags[boolTag] = cloneableTags[dateTag] =
cloneableTags[float32Tag] = cloneableTags[float64Tag] =
cloneableTags[int8Tag] = cloneableTags[int16Tag] =
cloneableTags[int32Tag] = cloneableTags[mapTag] =
cloneableTags[numberTag] = cloneableTags[objectTag] =
cloneableTags[regexpTag] = cloneableTags[setTag] =
cloneableTags[stringTag] = cloneableTags[symbolTag] =
cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
cloneableTags[errorTag] = cloneableTags[funcTag] =
cloneableTags[weakMapTag] = false;

/**
 * The base implementation of `_.clone` and `_.cloneDeep` which tracks
 * traversed objects.
 *
 * @private
 * @param {*} value The value to clone.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Deep clone
 *  2 - Flatten inherited properties
 *  4 - Clone symbols
 * @param {Function} [customizer] The function to customize cloning.
 * @param {string} [key] The key of `value`.
 * @param {Object} [object] The parent object of `value`.
 * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
 * @returns {*} Returns the cloned value.
 */
function baseClone(value, bitmask, customizer, key, object, stack) {
  var result,
      isDeep = bitmask & CLONE_DEEP_FLAG,
      isFlat = bitmask & CLONE_FLAT_FLAG,
      isFull = bitmask & CLONE_SYMBOLS_FLAG;

  if (customizer) {
    result = object ? customizer(value, key, object, stack) : customizer(value);
  }
  if (result !== undefined) {
    return result;
  }
  if (!isObject(value)) {
    return value;
  }
  var isArr = isArray(value);
  if (isArr) {
    result = initCloneArray(value);
    if (!isDeep) {
      return copyArray(value, result);
    }
  } else {
    var tag = getTag(value),
        isFunc = tag == funcTag || tag == genTag;

    if (isBuffer(value)) {
      return cloneBuffer(value, isDeep);
    }
    if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
      result = (isFlat || isFunc) ? {} : initCloneObject(value);
      if (!isDeep) {
        return isFlat
          ? copySymbolsIn(value, baseAssignIn(result, value))
          : copySymbols(value, baseAssign(result, value));
      }
    } else {
      if (!cloneableTags[tag]) {
        return object ? value : {};
      }
      result = initCloneByTag(value, tag, baseClone, isDeep);
    }
  }
  // Check for circular references and return its corresponding clone.
  stack || (stack = new Stack);
  var stacked = stack.get(value);
  if (stacked) {
    return stacked;
  }
  stack.set(value, result);

  var keysFunc = isFull
    ? (isFlat ? getAllKeysIn : getAllKeys)
    : (isFlat ? keysIn : keys);

  var props = isArr ? undefined : keysFunc(value);
  arrayEach(props || value, function(subValue, key) {
    if (props) {
      key = subValue;
      subValue = value[key];
    }
    // Recursively populate clone (susceptible to call stack limits).
    assignValue(result, key, baseClone(subValue, bitmask, customizer, key, value, stack));
  });
  return result;
}

module.exports = baseClone;


/***/ },
/* 117 */
/***/ function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(3);

/** Built-in value references. */
var objectCreate = Object.create;

/**
 * The base implementation of `_.create` without support for assigning
 * properties to the created object.
 *
 * @private
 * @param {Object} proto The object to inherit from.
 * @returns {Object} Returns the new object.
 */
var baseCreate = (function() {
  function object() {}
  return function(proto) {
    if (!isObject(proto)) {
      return {};
    }
    if (objectCreate) {
      return objectCreate(proto);
    }
    object.prototype = proto;
    var result = new object;
    object.prototype = undefined;
    return result;
  };
}());

module.exports = baseCreate;


/***/ },
/* 118 */
/***/ function(module, exports, __webpack_require__) {

var arrayPush = __webpack_require__(28),
    isFlattenable = __webpack_require__(161);

/**
 * The base implementation of `_.flatten` with support for restricting flattening.
 *
 * @private
 * @param {Array} array The array to flatten.
 * @param {number} depth The maximum recursion depth.
 * @param {boolean} [predicate=isFlattenable] The function invoked per iteration.
 * @param {boolean} [isStrict] Restrict to values that pass `predicate` checks.
 * @param {Array} [result=[]] The initial result value.
 * @returns {Array} Returns the new flattened array.
 */
function baseFlatten(array, depth, predicate, isStrict, result) {
  var index = -1,
      length = array.length;

  predicate || (predicate = isFlattenable);
  result || (result = []);

  while (++index < length) {
    var value = array[index];
    if (depth > 0 && predicate(value)) {
      if (depth > 1) {
        // Recursively flatten arrays (susceptible to call stack limits).
        baseFlatten(value, depth - 1, predicate, isStrict, result);
      } else {
        arrayPush(result, value);
      }
    } else if (!isStrict) {
      result[result.length] = value;
    }
  }
  return result;
}

module.exports = baseFlatten;


/***/ },
/* 119 */
/***/ function(module, exports, __webpack_require__) {

var createBaseFor = __webpack_require__(147);

/**
 * The base implementation of `baseForOwn` which iterates over `object`
 * properties returned by `keysFunc` and invokes `iteratee` for each property.
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = createBaseFor();

module.exports = baseFor;


/***/ },
/* 120 */
/***/ function(module, exports) {

/**
 * The base implementation of `_.hasIn` without support for deep paths.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {Array|string} key The key to check.
 * @returns {boolean} Returns `true` if `key` exists, else `false`.
 */
function baseHasIn(object, key) {
  return object != null && key in Object(object);
}

module.exports = baseHasIn;


/***/ },
/* 121 */
/***/ function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(6),
    isObjectLike = __webpack_require__(9);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag;
}

module.exports = baseIsArguments;


/***/ },
/* 122 */
/***/ function(module, exports, __webpack_require__) {

var isFunction = __webpack_require__(36),
    isMasked = __webpack_require__(165),
    isObject = __webpack_require__(3),
    toSource = __webpack_require__(65);

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

module.exports = baseIsNative;


/***/ },
/* 123 */
/***/ function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(6),
    isLength = __webpack_require__(37),
    isObjectLike = __webpack_require__(9);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}

module.exports = baseIsTypedArray;


/***/ },
/* 124 */
/***/ function(module, exports, __webpack_require__) {

var isPrototype = __webpack_require__(34),
    nativeKeys = __webpack_require__(178);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

module.exports = baseKeys;


/***/ },
/* 125 */
/***/ function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(3),
    isPrototype = __webpack_require__(34),
    nativeKeysIn = __webpack_require__(179);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeysIn(object) {
  if (!isObject(object)) {
    return nativeKeysIn(object);
  }
  var isProto = isPrototype(object),
      result = [];

  for (var key in object) {
    if (!(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
      result.push(key);
    }
  }
  return result;
}

module.exports = baseKeysIn;


/***/ },
/* 126 */
/***/ function(module, exports, __webpack_require__) {

var Stack = __webpack_require__(46),
    assignMergeValue = __webpack_require__(50),
    baseFor = __webpack_require__(119),
    baseMergeDeep = __webpack_require__(127),
    isObject = __webpack_require__(3),
    keysIn = __webpack_require__(24);

/**
 * The base implementation of `_.merge` without support for multiple sources.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} [customizer] The function to customize merged values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMerge(object, source, srcIndex, customizer, stack) {
  if (object === source) {
    return;
  }
  baseFor(source, function(srcValue, key) {
    if (isObject(srcValue)) {
      stack || (stack = new Stack);
      baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
    }
    else {
      var newValue = customizer
        ? customizer(object[key], srcValue, (key + ''), object, source, stack)
        : undefined;

      if (newValue === undefined) {
        newValue = srcValue;
      }
      assignMergeValue(object, key, newValue);
    }
  }, keysIn);
}

module.exports = baseMerge;


/***/ },
/* 127 */
/***/ function(module, exports, __webpack_require__) {

var assignMergeValue = __webpack_require__(50),
    cloneBuffer = __webpack_require__(53),
    cloneTypedArray = __webpack_require__(54),
    copyArray = __webpack_require__(55),
    initCloneObject = __webpack_require__(61),
    isArguments = __webpack_require__(22),
    isArray = __webpack_require__(2),
    isArrayLikeObject = __webpack_require__(194),
    isBuffer = __webpack_require__(35),
    isFunction = __webpack_require__(36),
    isObject = __webpack_require__(3),
    isPlainObject = __webpack_require__(67),
    isTypedArray = __webpack_require__(68),
    toPlainObject = __webpack_require__(200);

/**
 * A specialized version of `baseMerge` for arrays and objects which performs
 * deep merges and tracks traversed objects enabling objects with circular
 * references to be merged.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {string} key The key of the value to merge.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} mergeFunc The function to merge values.
 * @param {Function} [customizer] The function to customize assigned values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
  var objValue = object[key],
      srcValue = source[key],
      stacked = stack.get(srcValue);

  if (stacked) {
    assignMergeValue(object, key, stacked);
    return;
  }
  var newValue = customizer
    ? customizer(objValue, srcValue, (key + ''), object, source, stack)
    : undefined;

  var isCommon = newValue === undefined;

  if (isCommon) {
    var isArr = isArray(srcValue),
        isBuff = !isArr && isBuffer(srcValue),
        isTyped = !isArr && !isBuff && isTypedArray(srcValue);

    newValue = srcValue;
    if (isArr || isBuff || isTyped) {
      if (isArray(objValue)) {
        newValue = objValue;
      }
      else if (isArrayLikeObject(objValue)) {
        newValue = copyArray(objValue);
      }
      else if (isBuff) {
        isCommon = false;
        newValue = cloneBuffer(srcValue, true);
      }
      else if (isTyped) {
        isCommon = false;
        newValue = cloneTypedArray(srcValue, true);
      }
      else {
        newValue = [];
      }
    }
    else if (isPlainObject(srcValue) || isArguments(srcValue)) {
      newValue = objValue;
      if (isArguments(objValue)) {
        newValue = toPlainObject(objValue);
      }
      else if (!isObject(objValue) || (srcIndex && isFunction(objValue))) {
        newValue = initCloneObject(srcValue);
      }
    }
    else {
      isCommon = false;
    }
  }
  if (isCommon) {
    // Recursively merge objects and arrays (susceptible to call stack limits).
    stack.set(srcValue, newValue);
    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
    stack['delete'](srcValue);
  }
  assignMergeValue(object, key, newValue);
}

module.exports = baseMergeDeep;


/***/ },
/* 128 */
/***/ function(module, exports, __webpack_require__) {

var basePickBy = __webpack_require__(129),
    hasIn = __webpack_require__(193);

/**
 * The base implementation of `_.pick` without support for individual
 * property identifiers.
 *
 * @private
 * @param {Object} object The source object.
 * @param {string[]} paths The property paths to pick.
 * @returns {Object} Returns the new object.
 */
function basePick(object, paths) {
  return basePickBy(object, paths, function(value, path) {
    return hasIn(object, path);
  });
}

module.exports = basePick;


/***/ },
/* 129 */
/***/ function(module, exports, __webpack_require__) {

var baseGet = __webpack_require__(51),
    baseSet = __webpack_require__(131),
    castPath = __webpack_require__(7);

/**
 * The base implementation of  `_.pickBy` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The source object.
 * @param {string[]} paths The property paths to pick.
 * @param {Function} predicate The function invoked per property.
 * @returns {Object} Returns the new object.
 */
function basePickBy(object, paths, predicate) {
  var index = -1,
      length = paths.length,
      result = {};

  while (++index < length) {
    var path = paths[index],
        value = baseGet(object, path);

    if (predicate(value, path)) {
      baseSet(result, castPath(path, object), value);
    }
  }
  return result;
}

module.exports = basePickBy;


/***/ },
/* 130 */
/***/ function(module, exports, __webpack_require__) {

var identity = __webpack_require__(66),
    overRest = __webpack_require__(63),
    setToString = __webpack_require__(64);

/**
 * The base implementation of `_.rest` which doesn't validate or coerce arguments.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @returns {Function} Returns the new function.
 */
function baseRest(func, start) {
  return setToString(overRest(func, start, identity), func + '');
}

module.exports = baseRest;


/***/ },
/* 131 */
/***/ function(module, exports, __webpack_require__) {

var assignValue = __webpack_require__(29),
    castPath = __webpack_require__(7),
    isIndex = __webpack_require__(18),
    isObject = __webpack_require__(3),
    toKey = __webpack_require__(20);

/**
 * The base implementation of `_.set`.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {Array|string} path The path of the property to set.
 * @param {*} value The value to set.
 * @param {Function} [customizer] The function to customize path creation.
 * @returns {Object} Returns `object`.
 */
function baseSet(object, path, value, customizer) {
  if (!isObject(object)) {
    return object;
  }
  path = castPath(path, object);

  var index = -1,
      length = path.length,
      lastIndex = length - 1,
      nested = object;

  while (nested != null && ++index < length) {
    var key = toKey(path[index]),
        newValue = value;

    if (index != lastIndex) {
      var objValue = nested[key];
      newValue = customizer ? customizer(objValue, key, nested) : undefined;
      if (newValue === undefined) {
        newValue = isObject(objValue)
          ? objValue
          : (isIndex(path[index + 1]) ? [] : {});
      }
    }
    assignValue(nested, key, newValue);
    nested = nested[key];
  }
  return object;
}

module.exports = baseSet;


/***/ },
/* 132 */
/***/ function(module, exports, __webpack_require__) {

var constant = __webpack_require__(191),
    defineProperty = __webpack_require__(56),
    identity = __webpack_require__(66);

/**
 * The base implementation of `setToString` without support for hot loop shorting.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var baseSetToString = !defineProperty ? identity : function(func, string) {
  return defineProperty(func, 'toString', {
    'configurable': true,
    'enumerable': false,
    'value': constant(string),
    'writable': true
  });
};

module.exports = baseSetToString;


/***/ },
/* 133 */
/***/ function(module, exports) {

/**
 * The base implementation of `_.slice` without an iteratee call guard.
 *
 * @private
 * @param {Array} array The array to slice.
 * @param {number} [start=0] The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the slice of `array`.
 */
function baseSlice(array, start, end) {
  var index = -1,
      length = array.length;

  if (start < 0) {
    start = -start > length ? 0 : (length + start);
  }
  end = end > length ? length : end;
  if (end < 0) {
    end += length;
  }
  length = start > end ? 0 : ((end - start) >>> 0);
  start >>>= 0;

  var result = Array(length);
  while (++index < length) {
    result[index] = array[index + start];
  }
  return result;
}

module.exports = baseSlice;


/***/ },
/* 134 */
/***/ function(module, exports) {

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

module.exports = baseTimes;


/***/ },
/* 135 */
/***/ function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(12),
    arrayMap = __webpack_require__(48),
    isArray = __webpack_require__(2),
    isSymbol = __webpack_require__(38);

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isArray(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return arrayMap(value, baseToString) + '';
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

module.exports = baseToString;


/***/ },
/* 136 */
/***/ function(module, exports) {

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

module.exports = baseUnary;


/***/ },
/* 137 */
/***/ function(module, exports, __webpack_require__) {

var castPath = __webpack_require__(7),
    last = __webpack_require__(195),
    parent = __webpack_require__(182),
    toKey = __webpack_require__(20);

/**
 * The base implementation of `_.unset`.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {Array|string} path The property path to unset.
 * @returns {boolean} Returns `true` if the property is deleted, else `false`.
 */
function baseUnset(object, path) {
  path = castPath(path, object);
  object = parent(object, path);
  return object == null || delete object[toKey(last(path))];
}

module.exports = baseUnset;


/***/ },
/* 138 */
/***/ function(module, exports, __webpack_require__) {

var cloneArrayBuffer = __webpack_require__(31);

/**
 * Creates a clone of `dataView`.
 *
 * @private
 * @param {Object} dataView The data view to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned data view.
 */
function cloneDataView(dataView, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
  return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
}

module.exports = cloneDataView;


/***/ },
/* 139 */
/***/ function(module, exports, __webpack_require__) {

var addMapEntry = __webpack_require__(109),
    arrayReduce = __webpack_require__(49),
    mapToArray = __webpack_require__(176);

/** Used to compose bitmasks for cloning. */
var CLONE_DEEP_FLAG = 1;

/**
 * Creates a clone of `map`.
 *
 * @private
 * @param {Object} map The map to clone.
 * @param {Function} cloneFunc The function to clone values.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned map.
 */
function cloneMap(map, isDeep, cloneFunc) {
  var array = isDeep ? cloneFunc(mapToArray(map), CLONE_DEEP_FLAG) : mapToArray(map);
  return arrayReduce(array, addMapEntry, new map.constructor);
}

module.exports = cloneMap;


/***/ },
/* 140 */
/***/ function(module, exports) {

/** Used to match `RegExp` flags from their coerced string values. */
var reFlags = /\w*$/;

/**
 * Creates a clone of `regexp`.
 *
 * @private
 * @param {Object} regexp The regexp to clone.
 * @returns {Object} Returns the cloned regexp.
 */
function cloneRegExp(regexp) {
  var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
  result.lastIndex = regexp.lastIndex;
  return result;
}

module.exports = cloneRegExp;


/***/ },
/* 141 */
/***/ function(module, exports, __webpack_require__) {

var addSetEntry = __webpack_require__(110),
    arrayReduce = __webpack_require__(49),
    setToArray = __webpack_require__(183);

/** Used to compose bitmasks for cloning. */
var CLONE_DEEP_FLAG = 1;

/**
 * Creates a clone of `set`.
 *
 * @private
 * @param {Object} set The set to clone.
 * @param {Function} cloneFunc The function to clone values.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned set.
 */
function cloneSet(set, isDeep, cloneFunc) {
  var array = isDeep ? cloneFunc(setToArray(set), CLONE_DEEP_FLAG) : setToArray(set);
  return arrayReduce(array, addSetEntry, new set.constructor);
}

module.exports = cloneSet;


/***/ },
/* 142 */
/***/ function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(12);

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * Creates a clone of the `symbol` object.
 *
 * @private
 * @param {Object} symbol The symbol object to clone.
 * @returns {Object} Returns the cloned symbol object.
 */
function cloneSymbol(symbol) {
  return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
}

module.exports = cloneSymbol;


/***/ },
/* 143 */
/***/ function(module, exports, __webpack_require__) {

var copyObject = __webpack_require__(8),
    getSymbols = __webpack_require__(33);

/**
 * Copies own symbols of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy symbols from.
 * @param {Object} [object={}] The object to copy symbols to.
 * @returns {Object} Returns `object`.
 */
function copySymbols(source, object) {
  return copyObject(source, getSymbols(source), object);
}

module.exports = copySymbols;


/***/ },
/* 144 */
/***/ function(module, exports, __webpack_require__) {

var copyObject = __webpack_require__(8),
    getSymbolsIn = __webpack_require__(60);

/**
 * Copies own and inherited symbols of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy symbols from.
 * @param {Object} [object={}] The object to copy symbols to.
 * @returns {Object} Returns `object`.
 */
function copySymbolsIn(source, object) {
  return copyObject(source, getSymbolsIn(source), object);
}

module.exports = copySymbolsIn;


/***/ },
/* 145 */
/***/ function(module, exports, __webpack_require__) {

var root = __webpack_require__(1);

/** Used to detect overreaching core-js shims. */
var coreJsData = root['__core-js_shared__'];

module.exports = coreJsData;


/***/ },
/* 146 */
/***/ function(module, exports, __webpack_require__) {

var baseRest = __webpack_require__(130),
    isIterateeCall = __webpack_require__(162);

/**
 * Creates a function like `_.assign`.
 *
 * @private
 * @param {Function} assigner The function to assign values.
 * @returns {Function} Returns the new assigner function.
 */
function createAssigner(assigner) {
  return baseRest(function(object, sources) {
    var index = -1,
        length = sources.length,
        customizer = length > 1 ? sources[length - 1] : undefined,
        guard = length > 2 ? sources[2] : undefined;

    customizer = (assigner.length > 3 && typeof customizer == 'function')
      ? (length--, customizer)
      : undefined;

    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
      customizer = length < 3 ? undefined : customizer;
      length = 1;
    }
    object = Object(object);
    while (++index < length) {
      var source = sources[index];
      if (source) {
        assigner(object, source, index, customizer);
      }
    }
    return object;
  });
}

module.exports = createAssigner;


/***/ },
/* 147 */
/***/ function(module, exports) {

/**
 * Creates a base function for methods like `_.forIn` and `_.forOwn`.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseFor(fromRight) {
  return function(object, iteratee, keysFunc) {
    var index = -1,
        iterable = Object(object),
        props = keysFunc(object),
        length = props.length;

    while (length--) {
      var key = props[fromRight ? length : ++index];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}

module.exports = createBaseFor;


/***/ },
/* 148 */
/***/ function(module, exports, __webpack_require__) {

var isPlainObject = __webpack_require__(67);

/**
 * Used by `_.omit` to customize its `_.cloneDeep` use to only clone plain
 * objects.
 *
 * @private
 * @param {*} value The value to inspect.
 * @param {string} key The key of the property to inspect.
 * @returns {*} Returns the uncloned value or `undefined` to defer cloning to `_.cloneDeep`.
 */
function customOmitClone(value) {
  return isPlainObject(value) ? undefined : value;
}

module.exports = customOmitClone;


/***/ },
/* 149 */
/***/ function(module, exports, __webpack_require__) {

var baseGetAllKeys = __webpack_require__(52),
    getSymbols = __webpack_require__(33),
    keys = __webpack_require__(39);

/**
 * Creates an array of own enumerable property names and symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeys(object) {
  return baseGetAllKeys(object, keys, getSymbols);
}

module.exports = getAllKeys;


/***/ },
/* 150 */
/***/ function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(12);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty.call(value, symToStringTag),
      tag = value[symToStringTag];

  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}

module.exports = getRawTag;


/***/ },
/* 151 */
/***/ function(module, exports, __webpack_require__) {

var DataView = __webpack_require__(103),
    Map = __webpack_require__(27),
    Promise = __webpack_require__(105),
    Set = __webpack_require__(106),
    WeakMap = __webpack_require__(108),
    baseGetTag = __webpack_require__(6),
    toSource = __webpack_require__(65);

/** `Object#toString` result references. */
var mapTag = '[object Map]',
    objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    setTag = '[object Set]',
    weakMapTag = '[object WeakMap]';

var dataViewTag = '[object DataView]';

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = toSource(DataView),
    mapCtorString = toSource(Map),
    promiseCtorString = toSource(Promise),
    setCtorString = toSource(Set),
    weakMapCtorString = toSource(WeakMap);

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
    (Map && getTag(new Map) != mapTag) ||
    (Promise && getTag(Promise.resolve()) != promiseTag) ||
    (Set && getTag(new Set) != setTag) ||
    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
  getTag = function(value) {
    var result = baseGetTag(value),
        Ctor = result == objectTag ? value.constructor : undefined,
        ctorString = Ctor ? toSource(Ctor) : '';

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return dataViewTag;
        case mapCtorString: return mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return setTag;
        case weakMapCtorString: return weakMapTag;
      }
    }
    return result;
  };
}

module.exports = getTag;


/***/ },
/* 152 */
/***/ function(module, exports) {

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

module.exports = getValue;


/***/ },
/* 153 */
/***/ function(module, exports, __webpack_require__) {

var castPath = __webpack_require__(7),
    isArguments = __webpack_require__(22),
    isArray = __webpack_require__(2),
    isIndex = __webpack_require__(18),
    isLength = __webpack_require__(37),
    toKey = __webpack_require__(20);

/**
 * Checks if `path` exists on `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @param {Function} hasFunc The function to check properties.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 */
function hasPath(object, path, hasFunc) {
  path = castPath(path, object);

  var index = -1,
      length = path.length,
      result = false;

  while (++index < length) {
    var key = toKey(path[index]);
    if (!(result = object != null && hasFunc(object, key))) {
      break;
    }
    object = object[key];
  }
  if (result || ++index != length) {
    return result;
  }
  length = object == null ? 0 : object.length;
  return !!length && isLength(length) && isIndex(key, length) &&
    (isArray(object) || isArguments(object));
}

module.exports = hasPath;


/***/ },
/* 154 */
/***/ function(module, exports, __webpack_require__) {

var nativeCreate = __webpack_require__(19);

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
  this.size = 0;
}

module.exports = hashClear;


/***/ },
/* 155 */
/***/ function(module, exports) {

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}

module.exports = hashDelete;


/***/ },
/* 156 */
/***/ function(module, exports, __webpack_require__) {

var nativeCreate = __webpack_require__(19);

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return hasOwnProperty.call(data, key) ? data[key] : undefined;
}

module.exports = hashGet;


/***/ },
/* 157 */
/***/ function(module, exports, __webpack_require__) {

var nativeCreate = __webpack_require__(19);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
}

module.exports = hashHas;


/***/ },
/* 158 */
/***/ function(module, exports, __webpack_require__) {

var nativeCreate = __webpack_require__(19);

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

module.exports = hashSet;


/***/ },
/* 159 */
/***/ function(module, exports) {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Initializes an array clone.
 *
 * @private
 * @param {Array} array The array to clone.
 * @returns {Array} Returns the initialized clone.
 */
function initCloneArray(array) {
  var length = array.length,
      result = array.constructor(length);

  // Add properties assigned by `RegExp#exec`.
  if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
    result.index = array.index;
    result.input = array.input;
  }
  return result;
}

module.exports = initCloneArray;


/***/ },
/* 160 */
/***/ function(module, exports, __webpack_require__) {

var cloneArrayBuffer = __webpack_require__(31),
    cloneDataView = __webpack_require__(138),
    cloneMap = __webpack_require__(139),
    cloneRegExp = __webpack_require__(140),
    cloneSet = __webpack_require__(141),
    cloneSymbol = __webpack_require__(142),
    cloneTypedArray = __webpack_require__(54);

/** `Object#toString` result references. */
var boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/**
 * Initializes an object clone based on its `toStringTag`.
 *
 * **Note:** This function only supports cloning values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to clone.
 * @param {string} tag The `toStringTag` of the object to clone.
 * @param {Function} cloneFunc The function to clone values.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneByTag(object, tag, cloneFunc, isDeep) {
  var Ctor = object.constructor;
  switch (tag) {
    case arrayBufferTag:
      return cloneArrayBuffer(object);

    case boolTag:
    case dateTag:
      return new Ctor(+object);

    case dataViewTag:
      return cloneDataView(object, isDeep);

    case float32Tag: case float64Tag:
    case int8Tag: case int16Tag: case int32Tag:
    case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
      return cloneTypedArray(object, isDeep);

    case mapTag:
      return cloneMap(object, isDeep, cloneFunc);

    case numberTag:
    case stringTag:
      return new Ctor(object);

    case regexpTag:
      return cloneRegExp(object);

    case setTag:
      return cloneSet(object, isDeep, cloneFunc);

    case symbolTag:
      return cloneSymbol(object);
  }
}

module.exports = initCloneByTag;


/***/ },
/* 161 */
/***/ function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(12),
    isArguments = __webpack_require__(22),
    isArray = __webpack_require__(2);

/** Built-in value references. */
var spreadableSymbol = Symbol ? Symbol.isConcatSpreadable : undefined;

/**
 * Checks if `value` is a flattenable `arguments` object or array.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is flattenable, else `false`.
 */
function isFlattenable(value) {
  return isArray(value) || isArguments(value) ||
    !!(spreadableSymbol && value && value[spreadableSymbol]);
}

module.exports = isFlattenable;


/***/ },
/* 162 */
/***/ function(module, exports, __webpack_require__) {

var eq = __webpack_require__(21),
    isArrayLike = __webpack_require__(23),
    isIndex = __webpack_require__(18),
    isObject = __webpack_require__(3);

/**
 * Checks if the given arguments are from an iteratee call.
 *
 * @private
 * @param {*} value The potential iteratee value argument.
 * @param {*} index The potential iteratee index or key argument.
 * @param {*} object The potential iteratee object argument.
 * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
 *  else `false`.
 */
function isIterateeCall(value, index, object) {
  if (!isObject(object)) {
    return false;
  }
  var type = typeof index;
  if (type == 'number'
        ? (isArrayLike(object) && isIndex(index, object.length))
        : (type == 'string' && index in object)
      ) {
    return eq(object[index], value);
  }
  return false;
}

module.exports = isIterateeCall;


/***/ },
/* 163 */
/***/ function(module, exports, __webpack_require__) {

var isArray = __webpack_require__(2),
    isSymbol = __webpack_require__(38);

/** Used to match property names within property paths. */
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
    reIsPlainProp = /^\w*$/;

/**
 * Checks if `value` is a property name and not a property path.
 *
 * @private
 * @param {*} value The value to check.
 * @param {Object} [object] The object to query keys on.
 * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
 */
function isKey(value, object) {
  if (isArray(value)) {
    return false;
  }
  var type = typeof value;
  if (type == 'number' || type == 'symbol' || type == 'boolean' ||
      value == null || isSymbol(value)) {
    return true;
  }
  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
    (object != null && value in Object(object));
}

module.exports = isKey;


/***/ },
/* 164 */
/***/ function(module, exports) {

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

module.exports = isKeyable;


/***/ },
/* 165 */
/***/ function(module, exports, __webpack_require__) {

var coreJsData = __webpack_require__(145);

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

module.exports = isMasked;


/***/ },
/* 166 */
/***/ function(module, exports) {

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

module.exports = listCacheClear;


/***/ },
/* 167 */
/***/ function(module, exports, __webpack_require__) {

var assocIndexOf = __webpack_require__(16);

/** Used for built-in method references. */
var arrayProto = Array.prototype;

/** Built-in value references. */
var splice = arrayProto.splice;

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}

module.exports = listCacheDelete;


/***/ },
/* 168 */
/***/ function(module, exports, __webpack_require__) {

var assocIndexOf = __webpack_require__(16);

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

module.exports = listCacheGet;


/***/ },
/* 169 */
/***/ function(module, exports, __webpack_require__) {

var assocIndexOf = __webpack_require__(16);

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

module.exports = listCacheHas;


/***/ },
/* 170 */
/***/ function(module, exports, __webpack_require__) {

var assocIndexOf = __webpack_require__(16);

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

module.exports = listCacheSet;


/***/ },
/* 171 */
/***/ function(module, exports, __webpack_require__) {

var Hash = __webpack_require__(104),
    ListCache = __webpack_require__(15),
    Map = __webpack_require__(27);

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    'hash': new Hash,
    'map': new (Map || ListCache),
    'string': new Hash
  };
}

module.exports = mapCacheClear;


/***/ },
/* 172 */
/***/ function(module, exports, __webpack_require__) {

var getMapData = __webpack_require__(17);

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

module.exports = mapCacheDelete;


/***/ },
/* 173 */
/***/ function(module, exports, __webpack_require__) {

var getMapData = __webpack_require__(17);

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}

module.exports = mapCacheGet;


/***/ },
/* 174 */
/***/ function(module, exports, __webpack_require__) {

var getMapData = __webpack_require__(17);

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

module.exports = mapCacheHas;


/***/ },
/* 175 */
/***/ function(module, exports, __webpack_require__) {

var getMapData = __webpack_require__(17);

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = getMapData(this, key),
      size = data.size;

  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}

module.exports = mapCacheSet;


/***/ },
/* 176 */
/***/ function(module, exports) {

/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

module.exports = mapToArray;


/***/ },
/* 177 */
/***/ function(module, exports, __webpack_require__) {

var memoize = __webpack_require__(196);

/** Used as the maximum memoize cache size. */
var MAX_MEMOIZE_SIZE = 500;

/**
 * A specialized version of `_.memoize` which clears the memoized function's
 * cache when it exceeds `MAX_MEMOIZE_SIZE`.
 *
 * @private
 * @param {Function} func The function to have its output memoized.
 * @returns {Function} Returns the new memoized function.
 */
function memoizeCapped(func) {
  var result = memoize(func, function(key) {
    if (cache.size === MAX_MEMOIZE_SIZE) {
      cache.clear();
    }
    return key;
  });

  var cache = result.cache;
  return result;
}

module.exports = memoizeCapped;


/***/ },
/* 178 */
/***/ function(module, exports, __webpack_require__) {

var overArg = __webpack_require__(62);

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeKeys = overArg(Object.keys, Object);

module.exports = nativeKeys;


/***/ },
/* 179 */
/***/ function(module, exports) {

/**
 * This function is like
 * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * except that it includes inherited enumerable properties.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function nativeKeysIn(object) {
  var result = [];
  if (object != null) {
    for (var key in Object(object)) {
      result.push(key);
    }
  }
  return result;
}

module.exports = nativeKeysIn;


/***/ },
/* 180 */
/***/ function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var freeGlobal = __webpack_require__(58);

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports && freeGlobal.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}());

module.exports = nodeUtil;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(41)(module)))

/***/ },
/* 181 */
/***/ function(module, exports) {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

module.exports = objectToString;


/***/ },
/* 182 */
/***/ function(module, exports, __webpack_require__) {

var baseGet = __webpack_require__(51),
    baseSlice = __webpack_require__(133);

/**
 * Gets the parent value at `path` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array} path The path to get the parent value of.
 * @returns {*} Returns the parent value.
 */
function parent(object, path) {
  return path.length < 2 ? object : baseGet(object, baseSlice(path, 0, -1));
}

module.exports = parent;


/***/ },
/* 183 */
/***/ function(module, exports) {

/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
      result = Array(set.size);

  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}

module.exports = setToArray;


/***/ },
/* 184 */
/***/ function(module, exports) {

/** Used to detect hot functions by number of calls within a span of milliseconds. */
var HOT_COUNT = 800,
    HOT_SPAN = 16;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeNow = Date.now;

/**
 * Creates a function that'll short out and invoke `identity` instead
 * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`
 * milliseconds.
 *
 * @private
 * @param {Function} func The function to restrict.
 * @returns {Function} Returns the new shortable function.
 */
function shortOut(func) {
  var count = 0,
      lastCalled = 0;

  return function() {
    var stamp = nativeNow(),
        remaining = HOT_SPAN - (stamp - lastCalled);

    lastCalled = stamp;
    if (remaining > 0) {
      if (++count >= HOT_COUNT) {
        return arguments[0];
      }
    } else {
      count = 0;
    }
    return func.apply(undefined, arguments);
  };
}

module.exports = shortOut;


/***/ },
/* 185 */
/***/ function(module, exports, __webpack_require__) {

var ListCache = __webpack_require__(15);

/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new ListCache;
  this.size = 0;
}

module.exports = stackClear;


/***/ },
/* 186 */
/***/ function(module, exports) {

/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  var data = this.__data__,
      result = data['delete'](key);

  this.size = data.size;
  return result;
}

module.exports = stackDelete;


/***/ },
/* 187 */
/***/ function(module, exports) {

/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

module.exports = stackGet;


/***/ },
/* 188 */
/***/ function(module, exports) {

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

module.exports = stackHas;


/***/ },
/* 189 */
/***/ function(module, exports, __webpack_require__) {

var ListCache = __webpack_require__(15),
    Map = __webpack_require__(27),
    MapCache = __webpack_require__(45);

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof ListCache) {
    var pairs = data.__data__;
    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}

module.exports = stackSet;


/***/ },
/* 190 */
/***/ function(module, exports, __webpack_require__) {

var memoizeCapped = __webpack_require__(177);

/** Used to match property names within property paths. */
var reLeadingDot = /^\./,
    rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

/** Used to match backslashes in property paths. */
var reEscapeChar = /\\(\\)?/g;

/**
 * Converts `string` to a property path array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the property path array.
 */
var stringToPath = memoizeCapped(function(string) {
  var result = [];
  if (reLeadingDot.test(string)) {
    result.push('');
  }
  string.replace(rePropName, function(match, number, quote, string) {
    result.push(quote ? string.replace(reEscapeChar, '$1') : (number || match));
  });
  return result;
});

module.exports = stringToPath;


/***/ },
/* 191 */
/***/ function(module, exports) {

/**
 * Creates a function that returns `value`.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {*} value The value to return from the new function.
 * @returns {Function} Returns the new constant function.
 * @example
 *
 * var objects = _.times(2, _.constant({ 'a': 1 }));
 *
 * console.log(objects);
 * // => [{ 'a': 1 }, { 'a': 1 }]
 *
 * console.log(objects[0] === objects[1]);
 * // => true
 */
function constant(value) {
  return function() {
    return value;
  };
}

module.exports = constant;


/***/ },
/* 192 */
/***/ function(module, exports, __webpack_require__) {

var baseFlatten = __webpack_require__(118);

/**
 * Flattens `array` a single level deep.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Array
 * @param {Array} array The array to flatten.
 * @returns {Array} Returns the new flattened array.
 * @example
 *
 * _.flatten([1, [2, [3, [4]], 5]]);
 * // => [1, 2, [3, [4]], 5]
 */
function flatten(array) {
  var length = array == null ? 0 : array.length;
  return length ? baseFlatten(array, 1) : [];
}

module.exports = flatten;


/***/ },
/* 193 */
/***/ function(module, exports, __webpack_require__) {

var baseHasIn = __webpack_require__(120),
    hasPath = __webpack_require__(153);

/**
 * Checks if `path` is a direct or inherited property of `object`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 * @example
 *
 * var object = _.create({ 'a': _.create({ 'b': 2 }) });
 *
 * _.hasIn(object, 'a');
 * // => true
 *
 * _.hasIn(object, 'a.b');
 * // => true
 *
 * _.hasIn(object, ['a', 'b']);
 * // => true
 *
 * _.hasIn(object, 'b');
 * // => false
 */
function hasIn(object, path) {
  return object != null && hasPath(object, path, baseHasIn);
}

module.exports = hasIn;


/***/ },
/* 194 */
/***/ function(module, exports, __webpack_require__) {

var isArrayLike = __webpack_require__(23),
    isObjectLike = __webpack_require__(9);

/**
 * This method is like `_.isArrayLike` except that it also checks if `value`
 * is an object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array-like object,
 *  else `false`.
 * @example
 *
 * _.isArrayLikeObject([1, 2, 3]);
 * // => true
 *
 * _.isArrayLikeObject(document.body.children);
 * // => true
 *
 * _.isArrayLikeObject('abc');
 * // => false
 *
 * _.isArrayLikeObject(_.noop);
 * // => false
 */
function isArrayLikeObject(value) {
  return isObjectLike(value) && isArrayLike(value);
}

module.exports = isArrayLikeObject;


/***/ },
/* 195 */
/***/ function(module, exports) {

/**
 * Gets the last element of `array`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Array
 * @param {Array} array The array to query.
 * @returns {*} Returns the last element of `array`.
 * @example
 *
 * _.last([1, 2, 3]);
 * // => 3
 */
function last(array) {
  var length = array == null ? 0 : array.length;
  return length ? array[length - 1] : undefined;
}

module.exports = last;


/***/ },
/* 196 */
/***/ function(module, exports, __webpack_require__) {

var MapCache = __webpack_require__(45);

/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * Creates a function that memoizes the result of `func`. If `resolver` is
 * provided, it determines the cache key for storing the result based on the
 * arguments provided to the memoized function. By default, the first argument
 * provided to the memoized function is used as the map cache key. The `func`
 * is invoked with the `this` binding of the memoized function.
 *
 * **Note:** The cache is exposed as the `cache` property on the memoized
 * function. Its creation may be customized by replacing the `_.memoize.Cache`
 * constructor with one whose instances implement the
 * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
 * method interface of `clear`, `delete`, `get`, `has`, and `set`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to have its output memoized.
 * @param {Function} [resolver] The function to resolve the cache key.
 * @returns {Function} Returns the new memoized function.
 * @example
 *
 * var object = { 'a': 1, 'b': 2 };
 * var other = { 'c': 3, 'd': 4 };
 *
 * var values = _.memoize(_.values);
 * values(object);
 * // => [1, 2]
 *
 * values(other);
 * // => [3, 4]
 *
 * object.a = 2;
 * values(object);
 * // => [1, 2]
 *
 * // Modify the result cache.
 * values.cache.set(object, ['a', 'b']);
 * values(object);
 * // => ['a', 'b']
 *
 * // Replace `_.memoize.Cache`.
 * _.memoize.Cache = WeakMap;
 */
function memoize(func, resolver) {
  if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var memoized = function() {
    var args = arguments,
        key = resolver ? resolver.apply(this, args) : args[0],
        cache = memoized.cache;

    if (cache.has(key)) {
      return cache.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache.set(key, result) || cache;
    return result;
  };
  memoized.cache = new (memoize.Cache || MapCache);
  return memoized;
}

// Expose `MapCache`.
memoize.Cache = MapCache;

module.exports = memoize;


/***/ },
/* 197 */
/***/ function(module, exports, __webpack_require__) {

var arrayMap = __webpack_require__(48),
    baseClone = __webpack_require__(116),
    baseUnset = __webpack_require__(137),
    castPath = __webpack_require__(7),
    copyObject = __webpack_require__(8),
    customOmitClone = __webpack_require__(148),
    flatRest = __webpack_require__(57),
    getAllKeysIn = __webpack_require__(59);

/** Used to compose bitmasks for cloning. */
var CLONE_DEEP_FLAG = 1,
    CLONE_FLAT_FLAG = 2,
    CLONE_SYMBOLS_FLAG = 4;

/**
 * The opposite of `_.pick`; this method creates an object composed of the
 * own and inherited enumerable property paths of `object` that are not omitted.
 *
 * **Note:** This method is considerably slower than `_.pick`.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The source object.
 * @param {...(string|string[])} [paths] The property paths to omit.
 * @returns {Object} Returns the new object.
 * @example
 *
 * var object = { 'a': 1, 'b': '2', 'c': 3 };
 *
 * _.omit(object, ['a', 'c']);
 * // => { 'b': '2' }
 */
var omit = flatRest(function(object, paths) {
  var result = {};
  if (object == null) {
    return result;
  }
  var isDeep = false;
  paths = arrayMap(paths, function(path) {
    path = castPath(path, object);
    isDeep || (isDeep = path.length > 1);
    return path;
  });
  copyObject(object, getAllKeysIn(object), result);
  if (isDeep) {
    result = baseClone(result, CLONE_DEEP_FLAG | CLONE_FLAT_FLAG | CLONE_SYMBOLS_FLAG, customOmitClone);
  }
  var length = paths.length;
  while (length--) {
    baseUnset(result, paths[length]);
  }
  return result;
});

module.exports = omit;


/***/ },
/* 198 */
/***/ function(module, exports, __webpack_require__) {

var basePick = __webpack_require__(128),
    flatRest = __webpack_require__(57);

/**
 * Creates an object composed of the picked `object` properties.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The source object.
 * @param {...(string|string[])} [paths] The property paths to pick.
 * @returns {Object} Returns the new object.
 * @example
 *
 * var object = { 'a': 1, 'b': '2', 'c': 3 };
 *
 * _.pick(object, ['a', 'c']);
 * // => { 'a': 1, 'c': 3 }
 */
var pick = flatRest(function(object, paths) {
  return object == null ? {} : basePick(object, paths);
});

module.exports = pick;


/***/ },
/* 199 */
/***/ function(module, exports) {

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

module.exports = stubFalse;


/***/ },
/* 200 */
/***/ function(module, exports, __webpack_require__) {

var copyObject = __webpack_require__(8),
    keysIn = __webpack_require__(24);

/**
 * Converts `value` to a plain object flattening inherited enumerable string
 * keyed properties of `value` to own properties of the plain object.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {Object} Returns the converted plain object.
 * @example
 *
 * function Foo() {
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.assign({ 'a': 1 }, new Foo);
 * // => { 'a': 1, 'b': 2 }
 *
 * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
 * // => { 'a': 1, 'b': 2, 'c': 3 }
 */
function toPlainObject(value) {
  return copyObject(value, keysIn(value));
}

module.exports = toPlainObject;


/***/ },
/* 201 */
/***/ function(module, exports, __webpack_require__) {

var baseToString = __webpack_require__(135);

/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : baseToString(value);
}

module.exports = toString;


/***/ },
/* 202 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
 /* eslint-env node */


// SDP helpers.
var SDPUtils = {};

// Generate an alphanumeric identifier for cname or mids.
// TODO: use UUIDs instead? https://gist.github.com/jed/982883
SDPUtils.generateIdentifier = function() {
  return Math.random().toString(36).substr(2, 10);
};

// The RTCP CNAME used by all peerconnections from the same JS.
SDPUtils.localCName = SDPUtils.generateIdentifier();

// Splits SDP into lines, dealing with both CRLF and LF.
SDPUtils.splitLines = function(blob) {
  return blob.trim().split('\n').map(function(line) {
    return line.trim();
  });
};
// Splits SDP into sessionpart and mediasections. Ensures CRLF.
SDPUtils.splitSections = function(blob) {
  var parts = blob.split('\nm=');
  return parts.map(function(part, index) {
    return (index > 0 ? 'm=' + part : part).trim() + '\r\n';
  });
};

// Returns lines that start with a certain prefix.
SDPUtils.matchPrefix = function(blob, prefix) {
  return SDPUtils.splitLines(blob).filter(function(line) {
    return line.indexOf(prefix) === 0;
  });
};

// Parses an ICE candidate line. Sample input:
// candidate:702786350 2 udp 41819902 8.8.8.8 60769 typ relay raddr 8.8.8.8
// rport 55996"
SDPUtils.parseCandidate = function(line) {
  var parts;
  // Parse both variants.
  if (line.indexOf('a=candidate:') === 0) {
    parts = line.substring(12).split(' ');
  } else {
    parts = line.substring(10).split(' ');
  }

  var candidate = {
    foundation: parts[0],
    component: parts[1],
    protocol: parts[2].toLowerCase(),
    priority: parseInt(parts[3], 10),
    ip: parts[4],
    port: parseInt(parts[5], 10),
    // skip parts[6] == 'typ'
    type: parts[7]
  };

  for (var i = 8; i < parts.length; i += 2) {
    switch (parts[i]) {
      case 'raddr':
        candidate.relatedAddress = parts[i + 1];
        break;
      case 'rport':
        candidate.relatedPort = parseInt(parts[i + 1], 10);
        break;
      case 'tcptype':
        candidate.tcpType = parts[i + 1];
        break;
      default: // Unknown extensions are silently ignored.
        break;
    }
  }
  return candidate;
};

// Translates a candidate object into SDP candidate attribute.
SDPUtils.writeCandidate = function(candidate) {
  var sdp = [];
  sdp.push(candidate.foundation);
  sdp.push(candidate.component);
  sdp.push(candidate.protocol.toUpperCase());
  sdp.push(candidate.priority);
  sdp.push(candidate.ip);
  sdp.push(candidate.port);

  var type = candidate.type;
  sdp.push('typ');
  sdp.push(type);
  if (type !== 'host' && candidate.relatedAddress &&
      candidate.relatedPort) {
    sdp.push('raddr');
    sdp.push(candidate.relatedAddress); // was: relAddr
    sdp.push('rport');
    sdp.push(candidate.relatedPort); // was: relPort
  }
  if (candidate.tcpType && candidate.protocol.toLowerCase() === 'tcp') {
    sdp.push('tcptype');
    sdp.push(candidate.tcpType);
  }
  return 'candidate:' + sdp.join(' ');
};

// Parses an rtpmap line, returns RTCRtpCoddecParameters. Sample input:
// a=rtpmap:111 opus/48000/2
SDPUtils.parseRtpMap = function(line) {
  var parts = line.substr(9).split(' ');
  var parsed = {
    payloadType: parseInt(parts.shift(), 10) // was: id
  };

  parts = parts[0].split('/');

  parsed.name = parts[0];
  parsed.clockRate = parseInt(parts[1], 10); // was: clockrate
  // was: channels
  parsed.numChannels = parts.length === 3 ? parseInt(parts[2], 10) : 1;
  return parsed;
};

// Generate an a=rtpmap line from RTCRtpCodecCapability or
// RTCRtpCodecParameters.
SDPUtils.writeRtpMap = function(codec) {
  var pt = codec.payloadType;
  if (codec.preferredPayloadType !== undefined) {
    pt = codec.preferredPayloadType;
  }
  return 'a=rtpmap:' + pt + ' ' + codec.name + '/' + codec.clockRate +
      (codec.numChannels !== 1 ? '/' + codec.numChannels : '') + '\r\n';
};

// Parses an a=extmap line (headerextension from RFC 5285). Sample input:
// a=extmap:2 urn:ietf:params:rtp-hdrext:toffset
SDPUtils.parseExtmap = function(line) {
  var parts = line.substr(9).split(' ');
  return {
    id: parseInt(parts[0], 10),
    uri: parts[1]
  };
};

// Generates a=extmap line from RTCRtpHeaderExtensionParameters or
// RTCRtpHeaderExtension.
SDPUtils.writeExtmap = function(headerExtension) {
  return 'a=extmap:' + (headerExtension.id || headerExtension.preferredId) +
       ' ' + headerExtension.uri + '\r\n';
};

// Parses an ftmp line, returns dictionary. Sample input:
// a=fmtp:96 vbr=on;cng=on
// Also deals with vbr=on; cng=on
SDPUtils.parseFmtp = function(line) {
  var parsed = {};
  var kv;
  var parts = line.substr(line.indexOf(' ') + 1).split(';');
  for (var j = 0; j < parts.length; j++) {
    kv = parts[j].trim().split('=');
    parsed[kv[0].trim()] = kv[1];
  }
  return parsed;
};

// Generates an a=ftmp line from RTCRtpCodecCapability or RTCRtpCodecParameters.
SDPUtils.writeFmtp = function(codec) {
  var line = '';
  var pt = codec.payloadType;
  if (codec.preferredPayloadType !== undefined) {
    pt = codec.preferredPayloadType;
  }
  if (codec.parameters && Object.keys(codec.parameters).length) {
    var params = [];
    Object.keys(codec.parameters).forEach(function(param) {
      params.push(param + '=' + codec.parameters[param]);
    });
    line += 'a=fmtp:' + pt + ' ' + params.join(';') + '\r\n';
  }
  return line;
};

// Parses an rtcp-fb line, returns RTCPRtcpFeedback object. Sample input:
// a=rtcp-fb:98 nack rpsi
SDPUtils.parseRtcpFb = function(line) {
  var parts = line.substr(line.indexOf(' ') + 1).split(' ');
  return {
    type: parts.shift(),
    parameter: parts.join(' ')
  };
};
// Generate a=rtcp-fb lines from RTCRtpCodecCapability or RTCRtpCodecParameters.
SDPUtils.writeRtcpFb = function(codec) {
  var lines = '';
  var pt = codec.payloadType;
  if (codec.preferredPayloadType !== undefined) {
    pt = codec.preferredPayloadType;
  }
  if (codec.rtcpFeedback && codec.rtcpFeedback.length) {
    // FIXME: special handling for trr-int?
    codec.rtcpFeedback.forEach(function(fb) {
      lines += 'a=rtcp-fb:' + pt + ' ' + fb.type +
      (fb.parameter && fb.parameter.length ? ' ' + fb.parameter : '') +
          '\r\n';
    });
  }
  return lines;
};

// Parses an RFC 5576 ssrc media attribute. Sample input:
// a=ssrc:3735928559 cname:something
SDPUtils.parseSsrcMedia = function(line) {
  var sp = line.indexOf(' ');
  var parts = {
    ssrc: parseInt(line.substr(7, sp - 7), 10)
  };
  var colon = line.indexOf(':', sp);
  if (colon > -1) {
    parts.attribute = line.substr(sp + 1, colon - sp - 1);
    parts.value = line.substr(colon + 1);
  } else {
    parts.attribute = line.substr(sp + 1);
  }
  return parts;
};

// Extracts DTLS parameters from SDP media section or sessionpart.
// FIXME: for consistency with other functions this should only
//   get the fingerprint line as input. See also getIceParameters.
SDPUtils.getDtlsParameters = function(mediaSection, sessionpart) {
  var lines = SDPUtils.splitLines(mediaSection);
  // Search in session part, too.
  lines = lines.concat(SDPUtils.splitLines(sessionpart));
  var fpLine = lines.filter(function(line) {
    return line.indexOf('a=fingerprint:') === 0;
  })[0].substr(14);
  // Note: a=setup line is ignored since we use the 'auto' role.
  var dtlsParameters = {
    role: 'auto',
    fingerprints: [{
      algorithm: fpLine.split(' ')[0],
      value: fpLine.split(' ')[1]
    }]
  };
  return dtlsParameters;
};

// Serializes DTLS parameters to SDP.
SDPUtils.writeDtlsParameters = function(params, setupType) {
  var sdp = 'a=setup:' + setupType + '\r\n';
  params.fingerprints.forEach(function(fp) {
    sdp += 'a=fingerprint:' + fp.algorithm + ' ' + fp.value + '\r\n';
  });
  return sdp;
};
// Parses ICE information from SDP media section or sessionpart.
// FIXME: for consistency with other functions this should only
//   get the ice-ufrag and ice-pwd lines as input.
SDPUtils.getIceParameters = function(mediaSection, sessionpart) {
  var lines = SDPUtils.splitLines(mediaSection);
  // Search in session part, too.
  lines = lines.concat(SDPUtils.splitLines(sessionpart));
  var iceParameters = {
    usernameFragment: lines.filter(function(line) {
      return line.indexOf('a=ice-ufrag:') === 0;
    })[0].substr(12),
    password: lines.filter(function(line) {
      return line.indexOf('a=ice-pwd:') === 0;
    })[0].substr(10)
  };
  return iceParameters;
};

// Serializes ICE parameters to SDP.
SDPUtils.writeIceParameters = function(params) {
  return 'a=ice-ufrag:' + params.usernameFragment + '\r\n' +
      'a=ice-pwd:' + params.password + '\r\n';
};

// Parses the SDP media section and returns RTCRtpParameters.
SDPUtils.parseRtpParameters = function(mediaSection) {
  var description = {
    codecs: [],
    headerExtensions: [],
    fecMechanisms: [],
    rtcp: []
  };
  var lines = SDPUtils.splitLines(mediaSection);
  var mline = lines[0].split(' ');
  for (var i = 3; i < mline.length; i++) { // find all codecs from mline[3..]
    var pt = mline[i];
    var rtpmapline = SDPUtils.matchPrefix(
        mediaSection, 'a=rtpmap:' + pt + ' ')[0];
    if (rtpmapline) {
      var codec = SDPUtils.parseRtpMap(rtpmapline);
      var fmtps = SDPUtils.matchPrefix(
          mediaSection, 'a=fmtp:' + pt + ' ');
      // Only the first a=fmtp:<pt> is considered.
      codec.parameters = fmtps.length ? SDPUtils.parseFmtp(fmtps[0]) : {};
      codec.rtcpFeedback = SDPUtils.matchPrefix(
          mediaSection, 'a=rtcp-fb:' + pt + ' ')
        .map(SDPUtils.parseRtcpFb);
      description.codecs.push(codec);
      // parse FEC mechanisms from rtpmap lines.
      switch (codec.name.toUpperCase()) {
        case 'RED':
        case 'ULPFEC':
          description.fecMechanisms.push(codec.name.toUpperCase());
          break;
        default: // only RED and ULPFEC are recognized as FEC mechanisms.
          break;
      }
    }
  }
  SDPUtils.matchPrefix(mediaSection, 'a=extmap:').forEach(function(line) {
    description.headerExtensions.push(SDPUtils.parseExtmap(line));
  });
  // FIXME: parse rtcp.
  return description;
};

// Generates parts of the SDP media section describing the capabilities /
// parameters.
SDPUtils.writeRtpDescription = function(kind, caps) {
  var sdp = '';

  // Build the mline.
  sdp += 'm=' + kind + ' ';
  sdp += caps.codecs.length > 0 ? '9' : '0'; // reject if no codecs.
  sdp += ' UDP/TLS/RTP/SAVPF ';
  sdp += caps.codecs.map(function(codec) {
    if (codec.preferredPayloadType !== undefined) {
      return codec.preferredPayloadType;
    }
    return codec.payloadType;
  }).join(' ') + '\r\n';

  sdp += 'c=IN IP4 0.0.0.0\r\n';
  sdp += 'a=rtcp:9 IN IP4 0.0.0.0\r\n';

  // Add a=rtpmap lines for each codec. Also fmtp and rtcp-fb.
  caps.codecs.forEach(function(codec) {
    sdp += SDPUtils.writeRtpMap(codec);
    sdp += SDPUtils.writeFmtp(codec);
    sdp += SDPUtils.writeRtcpFb(codec);
  });
  sdp += 'a=rtcp-mux\r\n';

  caps.headerExtensions.forEach(function(extension) {
    sdp += SDPUtils.writeExtmap(extension);
  });
  // FIXME: write fecMechanisms.
  return sdp;
};

// Parses the SDP media section and returns an array of
// RTCRtpEncodingParameters.
SDPUtils.parseRtpEncodingParameters = function(mediaSection) {
  var encodingParameters = [];
  var description = SDPUtils.parseRtpParameters(mediaSection);
  var hasRed = description.fecMechanisms.indexOf('RED') !== -1;
  var hasUlpfec = description.fecMechanisms.indexOf('ULPFEC') !== -1;

  // filter a=ssrc:... cname:, ignore PlanB-msid
  var ssrcs = SDPUtils.matchPrefix(mediaSection, 'a=ssrc:')
  .map(function(line) {
    return SDPUtils.parseSsrcMedia(line);
  })
  .filter(function(parts) {
    return parts.attribute === 'cname';
  });
  var primarySsrc = ssrcs.length > 0 && ssrcs[0].ssrc;
  var secondarySsrc;

  var flows = SDPUtils.matchPrefix(mediaSection, 'a=ssrc-group:FID')
  .map(function(line) {
    var parts = line.split(' ');
    parts.shift();
    return parts.map(function(part) {
      return parseInt(part, 10);
    });
  });
  if (flows.length > 0 && flows[0].length > 1 && flows[0][0] === primarySsrc) {
    secondarySsrc = flows[0][1];
  }

  description.codecs.forEach(function(codec) {
    if (codec.name.toUpperCase() === 'RTX' && codec.parameters.apt) {
      var encParam = {
        ssrc: primarySsrc,
        codecPayloadType: parseInt(codec.parameters.apt, 10),
        rtx: {
          payloadType: codec.payloadType,
          ssrc: secondarySsrc
        }
      };
      encodingParameters.push(encParam);
      if (hasRed) {
        encParam = JSON.parse(JSON.stringify(encParam));
        encParam.fec = {
          ssrc: secondarySsrc,
          mechanism: hasUlpfec ? 'red+ulpfec' : 'red'
        };
        encodingParameters.push(encParam);
      }
    }
  });
  if (encodingParameters.length === 0 && primarySsrc) {
    encodingParameters.push({
      ssrc: primarySsrc
    });
  }

  // we support both b=AS and b=TIAS but interpret AS as TIAS.
  var bandwidth = SDPUtils.matchPrefix(mediaSection, 'b=');
  if (bandwidth.length) {
    if (bandwidth[0].indexOf('b=TIAS:') === 0) {
      bandwidth = parseInt(bandwidth[0].substr(7), 10);
    } else if (bandwidth[0].indexOf('b=AS:') === 0) {
      bandwidth = parseInt(bandwidth[0].substr(5), 10);
    }
    encodingParameters.forEach(function(params) {
      params.maxBitrate = bandwidth;
    });
  }
  return encodingParameters;
};

SDPUtils.writeSessionBoilerplate = function() {
  // FIXME: sess-id should be an NTP timestamp.
  return 'v=0\r\n' +
      'o=thisisadapterortc 8169639915646943137 2 IN IP4 127.0.0.1\r\n' +
      's=-\r\n' +
      't=0 0\r\n';
};

SDPUtils.writeMediaSection = function(transceiver, caps, type, stream) {
  var sdp = SDPUtils.writeRtpDescription(transceiver.kind, caps);

  // Map ICE parameters (ufrag, pwd) to SDP.
  sdp += SDPUtils.writeIceParameters(
      transceiver.iceGatherer.getLocalParameters());

  // Map DTLS parameters to SDP.
  sdp += SDPUtils.writeDtlsParameters(
      transceiver.dtlsTransport.getLocalParameters(),
      type === 'offer' ? 'actpass' : 'active');

  sdp += 'a=mid:' + transceiver.mid + '\r\n';

  if (transceiver.rtpSender && transceiver.rtpReceiver) {
    sdp += 'a=sendrecv\r\n';
  } else if (transceiver.rtpSender) {
    sdp += 'a=sendonly\r\n';
  } else if (transceiver.rtpReceiver) {
    sdp += 'a=recvonly\r\n';
  } else {
    sdp += 'a=inactive\r\n';
  }

  // FIXME: for RTX there might be multiple SSRCs. Not implemented in Edge yet.
  if (transceiver.rtpSender) {
    var msid = 'msid:' + stream.id + ' ' +
        transceiver.rtpSender.track.id + '\r\n';
    sdp += 'a=' + msid;
    sdp += 'a=ssrc:' + transceiver.sendEncodingParameters[0].ssrc +
        ' ' + msid;
  }
  // FIXME: this should be written by writeRtpDescription.
  sdp += 'a=ssrc:' + transceiver.sendEncodingParameters[0].ssrc +
      ' cname:' + SDPUtils.localCName + '\r\n';
  return sdp;
};

// Gets the direction from the mediaSection or the sessionpart.
SDPUtils.getDirection = function(mediaSection, sessionpart) {
  // Look for sendrecv, sendonly, recvonly, inactive, default to sendrecv.
  var lines = SDPUtils.splitLines(mediaSection);
  for (var i = 0; i < lines.length; i++) {
    switch (lines[i]) {
      case 'a=sendrecv':
      case 'a=sendonly':
      case 'a=recvonly':
      case 'a=inactive':
        return lines[i].substr(2);
      default:
        // FIXME: What should happen here?
    }
  }
  if (sessionpart) {
    return SDPUtils.getDirection(sessionpart);
  }
  return 'sendrecv';
};

// Expose public methods.
module.exports = SDPUtils;


/***/ },
/* 203 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */



// Shimming starts here.
(function() {
  // Utils.
  var logging = __webpack_require__(0).log;
  var browserDetails = __webpack_require__(0).browserDetails;
  // Export to the adapter global object visible in the browser.
  module.exports.browserDetails = browserDetails;
  module.exports.extractVersion = __webpack_require__(0).extractVersion;
  module.exports.disableLog = __webpack_require__(0).disableLog;

  // Uncomment the line below if you want logging to occur, including logging
  // for the switch statement below. Can also be turned on in the browser via
  // adapter.disableLog(false), but then logging from the switch statement below
  // will not appear.
  // require('./utils').disableLog(false);

  // Browser shims.
  var chromeShim = __webpack_require__(204) || null;
  var edgeShim = __webpack_require__(206) || null;
  var firefoxShim = __webpack_require__(208) || null;
  var safariShim = __webpack_require__(210) || null;

  // Shim browser if found.
  switch (browserDetails.browser) {
    case 'opera': // fallthrough as it uses chrome shims
    case 'chrome':
      if (!chromeShim || !chromeShim.shimPeerConnection) {
        logging('Chrome shim is not included in this adapter release.');
        return;
      }
      logging('adapter.js shimming chrome.');
      // Export to the adapter global object visible in the browser.
      module.exports.browserShim = chromeShim;

      chromeShim.shimGetUserMedia();
      chromeShim.shimMediaStream();
      chromeShim.shimSourceObject();
      chromeShim.shimPeerConnection();
      chromeShim.shimOnTrack();
      break;
    case 'firefox':
      if (!firefoxShim || !firefoxShim.shimPeerConnection) {
        logging('Firefox shim is not included in this adapter release.');
        return;
      }
      logging('adapter.js shimming firefox.');
      // Export to the adapter global object visible in the browser.
      module.exports.browserShim = firefoxShim;

      firefoxShim.shimGetUserMedia();
      firefoxShim.shimSourceObject();
      firefoxShim.shimPeerConnection();
      firefoxShim.shimOnTrack();
      break;
    case 'edge':
      if (!edgeShim || !edgeShim.shimPeerConnection) {
        logging('MS edge shim is not included in this adapter release.');
        return;
      }
      logging('adapter.js shimming edge.');
      // Export to the adapter global object visible in the browser.
      module.exports.browserShim = edgeShim;

      edgeShim.shimGetUserMedia();
      edgeShim.shimPeerConnection();
      break;
    case 'safari':
      if (!safariShim) {
        logging('Safari shim is not included in this adapter release.');
        return;
      }
      logging('adapter.js shimming safari.');
      // Export to the adapter global object visible in the browser.
      module.exports.browserShim = safariShim;

      safariShim.shimGetUserMedia();
      break;
    default:
      logging('Unsupported browser!');
  }
})();


/***/ },
/* 204 */
/***/ function(module, exports, __webpack_require__) {

"use strict";

/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */

var logging = __webpack_require__(0).log;
var browserDetails = __webpack_require__(0).browserDetails;

var chromeShim = {
  shimMediaStream: function() {
    window.MediaStream = window.MediaStream || window.webkitMediaStream;
  },

  shimOnTrack: function() {
    if (typeof window === 'object' && window.RTCPeerConnection && !('ontrack' in
        window.RTCPeerConnection.prototype)) {
      Object.defineProperty(window.RTCPeerConnection.prototype, 'ontrack', {
        get: function() {
          return this._ontrack;
        },
        set: function(f) {
          var self = this;
          if (this._ontrack) {
            this.removeEventListener('track', this._ontrack);
            this.removeEventListener('addstream', this._ontrackpoly);
          }
          this.addEventListener('track', this._ontrack = f);
          this.addEventListener('addstream', this._ontrackpoly = function(e) {
            // onaddstream does not fire when a track is added to an existing
            // stream. But stream.onaddtrack is implemented so we use that.
            e.stream.addEventListener('addtrack', function(te) {
              var event = new Event('track');
              event.track = te.track;
              event.receiver = {track: te.track};
              event.streams = [e.stream];
              self.dispatchEvent(event);
            });
            e.stream.getTracks().forEach(function(track) {
              var event = new Event('track');
              event.track = track;
              event.receiver = {track: track};
              event.streams = [e.stream];
              this.dispatchEvent(event);
            }.bind(this));
          }.bind(this));
        }
      });
    }
  },

  shimSourceObject: function() {
    if (typeof window === 'object') {
      if (window.HTMLMediaElement &&
        !('srcObject' in window.HTMLMediaElement.prototype)) {
        // Shim the srcObject property, once, when HTMLMediaElement is found.
        Object.defineProperty(window.HTMLMediaElement.prototype, 'srcObject', {
          get: function() {
            return this._srcObject;
          },
          set: function(stream) {
            var self = this;
            // Use _srcObject as a private property for this shim
            this._srcObject = stream;
            if (this.src) {
              URL.revokeObjectURL(this.src);
            }

            if (!stream) {
              this.src = '';
              return;
            }
            this.src = URL.createObjectURL(stream);
            // We need to recreate the blob url when a track is added or
            // removed. Doing it manually since we want to avoid a recursion.
            stream.addEventListener('addtrack', function() {
              if (self.src) {
                URL.revokeObjectURL(self.src);
              }
              self.src = URL.createObjectURL(stream);
            });
            stream.addEventListener('removetrack', function() {
              if (self.src) {
                URL.revokeObjectURL(self.src);
              }
              self.src = URL.createObjectURL(stream);
            });
          }
        });
      }
    }
  },

  shimPeerConnection: function() {
    // The RTCPeerConnection object.
    window.RTCPeerConnection = function(pcConfig, pcConstraints) {
      // Translate iceTransportPolicy to iceTransports,
      // see https://code.google.com/p/webrtc/issues/detail?id=4869
      logging('PeerConnection');
      if (pcConfig && pcConfig.iceTransportPolicy) {
        pcConfig.iceTransports = pcConfig.iceTransportPolicy;
      }

      var pc = new webkitRTCPeerConnection(pcConfig, pcConstraints);
      var origGetStats = pc.getStats.bind(pc);
      pc.getStats = function(selector, successCallback, errorCallback) {
        var self = this;
        var args = arguments;

        // If selector is a function then we are in the old style stats so just
        // pass back the original getStats format to avoid breaking old users.
        if (arguments.length > 0 && typeof selector === 'function') {
          return origGetStats(selector, successCallback);
        }

        var fixChromeStats_ = function(response) {
          var standardReport = {};
          var reports = response.result();
          reports.forEach(function(report) {
            var standardStats = {
              id: report.id,
              timestamp: report.timestamp,
              type: report.type
            };
            report.names().forEach(function(name) {
              standardStats[name] = report.stat(name);
            });
            standardReport[standardStats.id] = standardStats;
          });

          return standardReport;
        };

        // shim getStats with maplike support
        var makeMapStats = function(stats, legacyStats) {
          var map = new Map(Object.keys(stats).map(function(key) {
            return[key, stats[key]];
          }));
          legacyStats = legacyStats || stats;
          Object.keys(legacyStats).forEach(function(key) {
            map[key] = legacyStats[key];
          });
          return map;
        };

        if (arguments.length >= 2) {
          var successCallbackWrapper_ = function(response) {
            args[1](makeMapStats(fixChromeStats_(response)));
          };

          return origGetStats.apply(this, [successCallbackWrapper_,
              arguments[0]]);
        }

        // promise-support
        return new Promise(function(resolve, reject) {
          if (args.length === 1 && typeof selector === 'object') {
            origGetStats.apply(self, [
              function(response) {
                resolve(makeMapStats(fixChromeStats_(response)));
              }, reject]);
          } else {
            // Preserve legacy chrome stats only on legacy access of stats obj
            origGetStats.apply(self, [
              function(response) {
                resolve(makeMapStats(fixChromeStats_(response),
                    response.result()));
              }, reject]);
          }
        }).then(successCallback, errorCallback);
      };

      return pc;
    };
    window.RTCPeerConnection.prototype = webkitRTCPeerConnection.prototype;

    // wrap static methods. Currently just generateCertificate.
    if (webkitRTCPeerConnection.generateCertificate) {
      Object.defineProperty(window.RTCPeerConnection, 'generateCertificate', {
        get: function() {
          return webkitRTCPeerConnection.generateCertificate;
        }
      });
    }

    ['createOffer', 'createAnswer'].forEach(function(method) {
      var nativeMethod = webkitRTCPeerConnection.prototype[method];
      webkitRTCPeerConnection.prototype[method] = function() {
        var self = this;
        if (arguments.length < 1 || (arguments.length === 1 &&
            typeof arguments[0] === 'object')) {
          var opts = arguments.length === 1 ? arguments[0] : undefined;
          return new Promise(function(resolve, reject) {
            nativeMethod.apply(self, [resolve, reject, opts]);
          });
        }
        return nativeMethod.apply(this, arguments);
      };
    });

    // add promise support -- natively available in Chrome 51
    if (browserDetails.version < 51) {
      ['setLocalDescription', 'setRemoteDescription', 'addIceCandidate']
          .forEach(function(method) {
            var nativeMethod = webkitRTCPeerConnection.prototype[method];
            webkitRTCPeerConnection.prototype[method] = function() {
              var args = arguments;
              var self = this;
              var promise = new Promise(function(resolve, reject) {
                nativeMethod.apply(self, [args[0], resolve, reject]);
              });
              if (args.length < 2) {
                return promise;
              }
              return promise.then(function() {
                args[1].apply(null, []);
              },
              function(err) {
                if (args.length >= 3) {
                  args[2].apply(null, [err]);
                }
              });
            };
          });
    }

    // shim implicit creation of RTCSessionDescription/RTCIceCandidate
    ['setLocalDescription', 'setRemoteDescription', 'addIceCandidate']
        .forEach(function(method) {
          var nativeMethod = webkitRTCPeerConnection.prototype[method];
          webkitRTCPeerConnection.prototype[method] = function() {
            arguments[0] = new ((method === 'addIceCandidate') ?
                RTCIceCandidate : RTCSessionDescription)(arguments[0]);
            return nativeMethod.apply(this, arguments);
          };
        });

    // support for addIceCandidate(null or undefined)
    var nativeAddIceCandidate =
        RTCPeerConnection.prototype.addIceCandidate;
    RTCPeerConnection.prototype.addIceCandidate = function() {
      if (!arguments[0]) {
        if (arguments[1]) {
          arguments[1].apply(null);
        }
        return Promise.resolve();
      }
      return nativeAddIceCandidate.apply(this, arguments);
    };
  }
};


// Expose public methods.
module.exports = {
  shimMediaStream: chromeShim.shimMediaStream,
  shimOnTrack: chromeShim.shimOnTrack,
  shimSourceObject: chromeShim.shimSourceObject,
  shimPeerConnection: chromeShim.shimPeerConnection,
  shimGetUserMedia: __webpack_require__(205)
};


/***/ },
/* 205 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */

var logging = __webpack_require__(0).log;

// Expose public methods.
module.exports = function() {
  var constraintsToChrome_ = function(c) {
    if (typeof c !== 'object' || c.mandatory || c.optional) {
      return c;
    }
    var cc = {};
    Object.keys(c).forEach(function(key) {
      if (key === 'require' || key === 'advanced' || key === 'mediaSource') {
        return;
      }
      var r = (typeof c[key] === 'object') ? c[key] : {ideal: c[key]};
      if (r.exact !== undefined && typeof r.exact === 'number') {
        r.min = r.max = r.exact;
      }
      var oldname_ = function(prefix, name) {
        if (prefix) {
          return prefix + name.charAt(0).toUpperCase() + name.slice(1);
        }
        return (name === 'deviceId') ? 'sourceId' : name;
      };
      if (r.ideal !== undefined) {
        cc.optional = cc.optional || [];
        var oc = {};
        if (typeof r.ideal === 'number') {
          oc[oldname_('min', key)] = r.ideal;
          cc.optional.push(oc);
          oc = {};
          oc[oldname_('max', key)] = r.ideal;
          cc.optional.push(oc);
        } else {
          oc[oldname_('', key)] = r.ideal;
          cc.optional.push(oc);
        }
      }
      if (r.exact !== undefined && typeof r.exact !== 'number') {
        cc.mandatory = cc.mandatory || {};
        cc.mandatory[oldname_('', key)] = r.exact;
      } else {
        ['min', 'max'].forEach(function(mix) {
          if (r[mix] !== undefined) {
            cc.mandatory = cc.mandatory || {};
            cc.mandatory[oldname_(mix, key)] = r[mix];
          }
        });
      }
    });
    if (c.advanced) {
      cc.optional = (cc.optional || []).concat(c.advanced);
    }
    return cc;
  };

  var shimConstraints_ = function(constraints, func) {
    constraints = JSON.parse(JSON.stringify(constraints));
    if (constraints && constraints.audio) {
      constraints.audio = constraintsToChrome_(constraints.audio);
    }
    if (constraints && typeof constraints.video === 'object') {
      // Shim facingMode for mobile, where it defaults to "user".
      var face = constraints.video.facingMode;
      face = face && ((typeof face === 'object') ? face : {ideal: face});

      if ((face && (face.exact === 'user' || face.exact === 'environment' ||
                    face.ideal === 'user' || face.ideal === 'environment')) &&
          !(navigator.mediaDevices.getSupportedConstraints &&
            navigator.mediaDevices.getSupportedConstraints().facingMode)) {
        delete constraints.video.facingMode;
        if (face.exact === 'environment' || face.ideal === 'environment') {
          // Look for "back" in label, or use last cam (typically back cam).
          return navigator.mediaDevices.enumerateDevices()
          .then(function(devices) {
            devices = devices.filter(function(d) {
              return d.kind === 'videoinput';
            });
            var back = devices.find(function(d) {
              return d.label.toLowerCase().indexOf('back') !== -1;
            }) || (devices.length && devices[devices.length - 1]);
            if (back) {
              constraints.video.deviceId = face.exact ? {exact: back.deviceId} :
                                                        {ideal: back.deviceId};
            }
            constraints.video = constraintsToChrome_(constraints.video);
            logging('chrome: ' + JSON.stringify(constraints));
            return func(constraints);
          });
        }
      }
      constraints.video = constraintsToChrome_(constraints.video);
    }
    logging('chrome: ' + JSON.stringify(constraints));
    return func(constraints);
  };

  var shimError_ = function(e) {
    return {
      name: {
        PermissionDeniedError: 'NotAllowedError',
        ConstraintNotSatisfiedError: 'OverconstrainedError'
      }[e.name] || e.name,
      message: e.message,
      constraint: e.constraintName,
      toString: function() {
        return this.name + (this.message && ': ') + this.message;
      }
    };
  };

  var getUserMedia_ = function(constraints, onSuccess, onError) {
    shimConstraints_(constraints, function(c) {
      navigator.webkitGetUserMedia(c, onSuccess, function(e) {
        onError(shimError_(e));
      });
    });
  };

  navigator.getUserMedia = getUserMedia_;

  // Returns the result of getUserMedia as a Promise.
  var getUserMediaPromise_ = function(constraints) {
    return new Promise(function(resolve, reject) {
      navigator.getUserMedia(constraints, resolve, reject);
    });
  };

  if (!navigator.mediaDevices) {
    navigator.mediaDevices = {
      getUserMedia: getUserMediaPromise_,
      enumerateDevices: function() {
        return new Promise(function(resolve) {
          var kinds = {audio: 'audioinput', video: 'videoinput'};
          return MediaStreamTrack.getSources(function(devices) {
            resolve(devices.map(function(device) {
              return {label: device.label,
                      kind: kinds[device.kind],
                      deviceId: device.id,
                      groupId: ''};
            }));
          });
        });
      }
    };
  }

  // A shim for getUserMedia method on the mediaDevices object.
  // TODO(KaptenJansson) remove once implemented in Chrome stable.
  if (!navigator.mediaDevices.getUserMedia) {
    navigator.mediaDevices.getUserMedia = function(constraints) {
      return getUserMediaPromise_(constraints);
    };
  } else {
    // Even though Chrome 45 has navigator.mediaDevices and a getUserMedia
    // function which returns a Promise, it does not accept spec-style
    // constraints.
    var origGetUserMedia = navigator.mediaDevices.getUserMedia.
        bind(navigator.mediaDevices);
    navigator.mediaDevices.getUserMedia = function(cs) {
      return shimConstraints_(cs, function(c) {
        return origGetUserMedia(c).then(function(stream) {
          if (c.audio && !stream.getAudioTracks().length ||
              c.video && !stream.getVideoTracks().length) {
            stream.getTracks().forEach(function(track) {
              track.stop();
            });
            throw new DOMException('', 'NotFoundError');
          }
          return stream;
        }, function(e) {
          return Promise.reject(shimError_(e));
        });
      });
    };
  }

  // Dummy devicechange event methods.
  // TODO(KaptenJansson) remove once implemented in Chrome stable.
  if (typeof navigator.mediaDevices.addEventListener === 'undefined') {
    navigator.mediaDevices.addEventListener = function() {
      logging('Dummy mediaDevices.addEventListener called.');
    };
  }
  if (typeof navigator.mediaDevices.removeEventListener === 'undefined') {
    navigator.mediaDevices.removeEventListener = function() {
      logging('Dummy mediaDevices.removeEventListener called.');
    };
  }
};


/***/ },
/* 206 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */


var SDPUtils = __webpack_require__(202);
var browserDetails = __webpack_require__(0).browserDetails;

var edgeShim = {
  shimPeerConnection: function() {
    if (window.RTCIceGatherer) {
      // ORTC defines an RTCIceCandidate object but no constructor.
      // Not implemented in Edge.
      if (!window.RTCIceCandidate) {
        window.RTCIceCandidate = function(args) {
          return args;
        };
      }
      // ORTC does not have a session description object but
      // other browsers (i.e. Chrome) that will support both PC and ORTC
      // in the future might have this defined already.
      if (!window.RTCSessionDescription) {
        window.RTCSessionDescription = function(args) {
          return args;
        };
      }
      // this adds an additional event listener to MediaStrackTrack that signals
      // when a tracks enabled property was changed.
      var origMSTEnabled = Object.getOwnPropertyDescriptor(
          MediaStreamTrack.prototype, 'enabled');
      Object.defineProperty(MediaStreamTrack.prototype, 'enabled', {
        set: function(value) {
          origMSTEnabled.set.call(this, value);
          var ev = new Event('enabled');
          ev.enabled = value;
          this.dispatchEvent(ev);
        }
      });
    }

    window.RTCPeerConnection = function(config) {
      var self = this;

      var _eventTarget = document.createDocumentFragment();
      ['addEventListener', 'removeEventListener', 'dispatchEvent']
          .forEach(function(method) {
            self[method] = _eventTarget[method].bind(_eventTarget);
          });

      this.onicecandidate = null;
      this.onaddstream = null;
      this.ontrack = null;
      this.onremovestream = null;
      this.onsignalingstatechange = null;
      this.oniceconnectionstatechange = null;
      this.onnegotiationneeded = null;
      this.ondatachannel = null;

      this.localStreams = [];
      this.remoteStreams = [];
      this.getLocalStreams = function() {
        return self.localStreams;
      };
      this.getRemoteStreams = function() {
        return self.remoteStreams;
      };

      this.localDescription = new RTCSessionDescription({
        type: '',
        sdp: ''
      });
      this.remoteDescription = new RTCSessionDescription({
        type: '',
        sdp: ''
      });
      this.signalingState = 'stable';
      this.iceConnectionState = 'new';
      this.iceGatheringState = 'new';

      this.iceOptions = {
        gatherPolicy: 'all',
        iceServers: []
      };
      if (config && config.iceTransportPolicy) {
        switch (config.iceTransportPolicy) {
          case 'all':
          case 'relay':
            this.iceOptions.gatherPolicy = config.iceTransportPolicy;
            break;
          case 'none':
            // FIXME: remove once implementation and spec have added this.
            throw new TypeError('iceTransportPolicy "none" not supported');
          default:
            // don't set iceTransportPolicy.
            break;
        }
      }
      this.usingBundle = config && config.bundlePolicy === 'max-bundle';

      if (config && config.iceServers) {
        // Edge does not like
        // 1) stun:
        // 2) turn: that does not have all of turn:host:port?transport=udp
        // 3) turn: with ipv6 addresses
        var iceServers = JSON.parse(JSON.stringify(config.iceServers));
        this.iceOptions.iceServers = iceServers.filter(function(server) {
          if (server && server.urls) {
            var urls = server.urls;
            if (typeof urls === 'string') {
              urls = [urls];
            }
            urls = urls.filter(function(url) {
              return (url.indexOf('turn:') === 0 &&
                  url.indexOf('transport=udp') !== -1 &&
                  url.indexOf('turn:[') === -1) ||
                  (url.indexOf('stun:') === 0 &&
                    browserDetails.version >= 14393);
            })[0];
            return !!urls;
          }
          return false;
        });
      }
      this._config = config;

      // per-track iceGathers, iceTransports, dtlsTransports, rtpSenders, ...
      // everything that is needed to describe a SDP m-line.
      this.transceivers = [];

      // since the iceGatherer is currently created in createOffer but we
      // must not emit candidates until after setLocalDescription we buffer
      // them in this array.
      this._localIceCandidatesBuffer = [];
    };

    window.RTCPeerConnection.prototype._emitBufferedCandidates = function() {
      var self = this;
      var sections = SDPUtils.splitSections(self.localDescription.sdp);
      // FIXME: need to apply ice candidates in a way which is async but
      // in-order
      this._localIceCandidatesBuffer.forEach(function(event) {
        var end = !event.candidate || Object.keys(event.candidate).length === 0;
        if (end) {
          for (var j = 1; j < sections.length; j++) {
            if (sections[j].indexOf('\r\na=end-of-candidates\r\n') === -1) {
              sections[j] += 'a=end-of-candidates\r\n';
            }
          }
        } else if (event.candidate.candidate.indexOf('typ endOfCandidates')
            === -1) {
          sections[event.candidate.sdpMLineIndex + 1] +=
              'a=' + event.candidate.candidate + '\r\n';
        }
        self.localDescription.sdp = sections.join('');
        self.dispatchEvent(event);
        if (self.onicecandidate !== null) {
          self.onicecandidate(event);
        }
        if (!event.candidate && self.iceGatheringState !== 'complete') {
          var complete = self.transceivers.every(function(transceiver) {
            return transceiver.iceGatherer &&
                transceiver.iceGatherer.state === 'completed';
          });
          if (complete) {
            self.iceGatheringState = 'complete';
          }
        }
      });
      this._localIceCandidatesBuffer = [];
    };

    window.RTCPeerConnection.prototype.getConfiguration = function() {
      return this._config;
    };

    window.RTCPeerConnection.prototype.addStream = function(stream) {
      // Clone is necessary for local demos mostly, attaching directly
      // to two different senders does not work (build 10547).
      var clonedStream = stream.clone();
      stream.getTracks().forEach(function(track, idx) {
        var clonedTrack = clonedStream.getTracks()[idx];
        track.addEventListener('enabled', function(event) {
          clonedTrack.enabled = event.enabled;
        });
      });
      this.localStreams.push(clonedStream);
      this._maybeFireNegotiationNeeded();
    };

    window.RTCPeerConnection.prototype.removeStream = function(stream) {
      var idx = this.localStreams.indexOf(stream);
      if (idx > -1) {
        this.localStreams.splice(idx, 1);
        this._maybeFireNegotiationNeeded();
      }
    };

    window.RTCPeerConnection.prototype.getSenders = function() {
      return this.transceivers.filter(function(transceiver) {
        return !!transceiver.rtpSender;
      })
      .map(function(transceiver) {
        return transceiver.rtpSender;
      });
    };

    window.RTCPeerConnection.prototype.getReceivers = function() {
      return this.transceivers.filter(function(transceiver) {
        return !!transceiver.rtpReceiver;
      })
      .map(function(transceiver) {
        return transceiver.rtpReceiver;
      });
    };

    // Determines the intersection of local and remote capabilities.
    window.RTCPeerConnection.prototype._getCommonCapabilities =
        function(localCapabilities, remoteCapabilities) {
          var commonCapabilities = {
            codecs: [],
            headerExtensions: [],
            fecMechanisms: []
          };
          localCapabilities.codecs.forEach(function(lCodec) {
            for (var i = 0; i < remoteCapabilities.codecs.length; i++) {
              var rCodec = remoteCapabilities.codecs[i];
              if (lCodec.name.toLowerCase() === rCodec.name.toLowerCase() &&
                  lCodec.clockRate === rCodec.clockRate) {
                // number of channels is the highest common number of channels
                rCodec.numChannels = Math.min(lCodec.numChannels,
                    rCodec.numChannels);
                // push rCodec so we reply with offerer payload type
                commonCapabilities.codecs.push(rCodec);

                // determine common feedback mechanisms
                rCodec.rtcpFeedback = rCodec.rtcpFeedback.filter(function(fb) {
                  for (var j = 0; j < lCodec.rtcpFeedback.length; j++) {
                    if (lCodec.rtcpFeedback[j].type === fb.type &&
                        lCodec.rtcpFeedback[j].parameter === fb.parameter) {
                      return true;
                    }
                  }
                  return false;
                });
                // FIXME: also need to determine .parameters
                //  see https://github.com/openpeer/ortc/issues/569
                break;
              }
            }
          });

          localCapabilities.headerExtensions
              .forEach(function(lHeaderExtension) {
                for (var i = 0; i < remoteCapabilities.headerExtensions.length;
                     i++) {
                  var rHeaderExtension = remoteCapabilities.headerExtensions[i];
                  if (lHeaderExtension.uri === rHeaderExtension.uri) {
                    commonCapabilities.headerExtensions.push(rHeaderExtension);
                    break;
                  }
                }
              });

          // FIXME: fecMechanisms
          return commonCapabilities;
        };

    // Create ICE gatherer, ICE transport and DTLS transport.
    window.RTCPeerConnection.prototype._createIceAndDtlsTransports =
        function(mid, sdpMLineIndex) {
          var self = this;
          var iceGatherer = new RTCIceGatherer(self.iceOptions);
          var iceTransport = new RTCIceTransport(iceGatherer);
          iceGatherer.onlocalcandidate = function(evt) {
            var event = new Event('icecandidate');
            event.candidate = {sdpMid: mid, sdpMLineIndex: sdpMLineIndex};

            var cand = evt.candidate;
            var end = !cand || Object.keys(cand).length === 0;
            // Edge emits an empty object for RTCIceCandidateComplete‥
            if (end) {
              // polyfill since RTCIceGatherer.state is not implemented in
              // Edge 10547 yet.
              if (iceGatherer.state === undefined) {
                iceGatherer.state = 'completed';
              }

              // Emit a candidate with type endOfCandidates to make the samples
              // work. Edge requires addIceCandidate with this empty candidate
              // to start checking. The real solution is to signal
              // end-of-candidates to the other side when getting the null
              // candidate but some apps (like the samples) don't do that.
              event.candidate.candidate =
                  'candidate:1 1 udp 1 0.0.0.0 9 typ endOfCandidates';
            } else {
              // RTCIceCandidate doesn't have a component, needs to be added
              cand.component = iceTransport.component === 'RTCP' ? 2 : 1;
              event.candidate.candidate = SDPUtils.writeCandidate(cand);
            }

            // update local description.
            var sections = SDPUtils.splitSections(self.localDescription.sdp);
            if (event.candidate.candidate.indexOf('typ endOfCandidates')
                === -1) {
              sections[event.candidate.sdpMLineIndex + 1] +=
                  'a=' + event.candidate.candidate + '\r\n';
            } else {
              sections[event.candidate.sdpMLineIndex + 1] +=
                  'a=end-of-candidates\r\n';
            }
            self.localDescription.sdp = sections.join('');

            var complete = self.transceivers.every(function(transceiver) {
              return transceiver.iceGatherer &&
                  transceiver.iceGatherer.state === 'completed';
            });

            // Emit candidate if localDescription is set.
            // Also emits null candidate when all gatherers are complete.
            switch (self.iceGatheringState) {
              case 'new':
                self._localIceCandidatesBuffer.push(event);
                if (end && complete) {
                  self._localIceCandidatesBuffer.push(
                      new Event('icecandidate'));
                }
                break;
              case 'gathering':
                self._emitBufferedCandidates();
                self.dispatchEvent(event);
                if (self.onicecandidate !== null) {
                  self.onicecandidate(event);
                }
                if (complete) {
                  self.dispatchEvent(new Event('icecandidate'));
                  if (self.onicecandidate !== null) {
                    self.onicecandidate(new Event('icecandidate'));
                  }
                  self.iceGatheringState = 'complete';
                }
                break;
              case 'complete':
                // should not happen... currently!
                break;
              default: // no-op.
                break;
            }
          };
          iceTransport.onicestatechange = function() {
            self._updateConnectionState();
          };

          var dtlsTransport = new RTCDtlsTransport(iceTransport);
          dtlsTransport.ondtlsstatechange = function() {
            self._updateConnectionState();
          };
          dtlsTransport.onerror = function() {
            // onerror does not set state to failed by itself.
            dtlsTransport.state = 'failed';
            self._updateConnectionState();
          };

          return {
            iceGatherer: iceGatherer,
            iceTransport: iceTransport,
            dtlsTransport: dtlsTransport
          };
        };

    // Start the RTP Sender and Receiver for a transceiver.
    window.RTCPeerConnection.prototype._transceive = function(transceiver,
        send, recv) {
      var params = this._getCommonCapabilities(transceiver.localCapabilities,
          transceiver.remoteCapabilities);
      if (send && transceiver.rtpSender) {
        params.encodings = transceiver.sendEncodingParameters;
        params.rtcp = {
          cname: SDPUtils.localCName
        };
        if (transceiver.recvEncodingParameters.length) {
          params.rtcp.ssrc = transceiver.recvEncodingParameters[0].ssrc;
        }
        transceiver.rtpSender.send(params);
      }
      if (recv && transceiver.rtpReceiver) {
        // remove RTX field in Edge 14942
        if (transceiver.kind === 'video'
            && transceiver.recvEncodingParameters) {
          transceiver.recvEncodingParameters.forEach(function(p) {
            delete p.rtx;
          });
        }
        params.encodings = transceiver.recvEncodingParameters;
        params.rtcp = {
          cname: transceiver.cname
        };
        if (transceiver.sendEncodingParameters.length) {
          params.rtcp.ssrc = transceiver.sendEncodingParameters[0].ssrc;
        }
        transceiver.rtpReceiver.receive(params);
      }
    };

    window.RTCPeerConnection.prototype.setLocalDescription =
        function(description) {
          var self = this;
          var sections;
          var sessionpart;
          if (description.type === 'offer') {
            // FIXME: What was the purpose of this empty if statement?
            // if (!this._pendingOffer) {
            // } else {
            if (this._pendingOffer) {
              // VERY limited support for SDP munging. Limited to:
              // * changing the order of codecs
              sections = SDPUtils.splitSections(description.sdp);
              sessionpart = sections.shift();
              sections.forEach(function(mediaSection, sdpMLineIndex) {
                var caps = SDPUtils.parseRtpParameters(mediaSection);
                self._pendingOffer[sdpMLineIndex].localCapabilities = caps;
              });
              this.transceivers = this._pendingOffer;
              delete this._pendingOffer;
            }
          } else if (description.type === 'answer') {
            sections = SDPUtils.splitSections(self.remoteDescription.sdp);
            sessionpart = sections.shift();
            var isIceLite = SDPUtils.matchPrefix(sessionpart,
                'a=ice-lite').length > 0;
            sections.forEach(function(mediaSection, sdpMLineIndex) {
              var transceiver = self.transceivers[sdpMLineIndex];
              var iceGatherer = transceiver.iceGatherer;
              var iceTransport = transceiver.iceTransport;
              var dtlsTransport = transceiver.dtlsTransport;
              var localCapabilities = transceiver.localCapabilities;
              var remoteCapabilities = transceiver.remoteCapabilities;

              var rejected = mediaSection.split('\n', 1)[0]
                  .split(' ', 2)[1] === '0';

              if (!rejected && !transceiver.isDatachannel) {
                var remoteIceParameters = SDPUtils.getIceParameters(
                    mediaSection, sessionpart);
                if (isIceLite) {
                  var cands = SDPUtils.matchPrefix(mediaSection, 'a=candidate:')
                  .map(function(cand) {
                    return SDPUtils.parseCandidate(cand);
                  })
                  .filter(function(cand) {
                    return cand.component === '1';
                  });
                  // ice-lite only includes host candidates in the SDP so we can
                  // use setRemoteCandidates (which implies an
                  // RTCIceCandidateComplete)
                  if (cands.length) {
                    iceTransport.setRemoteCandidates(cands);
                  }
                }
                var remoteDtlsParameters = SDPUtils.getDtlsParameters(
                    mediaSection, sessionpart);
                if (isIceLite) {
                  remoteDtlsParameters.role = 'server';
                }

                if (!self.usingBundle || sdpMLineIndex === 0) {
                  iceTransport.start(iceGatherer, remoteIceParameters,
                      isIceLite ? 'controlling' : 'controlled');
                  dtlsTransport.start(remoteDtlsParameters);
                }

                // Calculate intersection of capabilities.
                var params = self._getCommonCapabilities(localCapabilities,
                    remoteCapabilities);

                // Start the RTCRtpSender. The RTCRtpReceiver for this
                // transceiver has already been started in setRemoteDescription.
                self._transceive(transceiver,
                    params.codecs.length > 0,
                    false);
              }
            });
          }

          this.localDescription = {
            type: description.type,
            sdp: description.sdp
          };
          switch (description.type) {
            case 'offer':
              this._updateSignalingState('have-local-offer');
              break;
            case 'answer':
              this._updateSignalingState('stable');
              break;
            default:
              throw new TypeError('unsupported type "' + description.type +
                  '"');
          }

          // If a success callback was provided, emit ICE candidates after it
          // has been executed. Otherwise, emit callback after the Promise is
          // resolved.
          var hasCallback = arguments.length > 1 &&
            typeof arguments[1] === 'function';
          if (hasCallback) {
            var cb = arguments[1];
            window.setTimeout(function() {
              cb();
              if (self.iceGatheringState === 'new') {
                self.iceGatheringState = 'gathering';
              }
              self._emitBufferedCandidates();
            }, 0);
          }
          var p = Promise.resolve();
          p.then(function() {
            if (!hasCallback) {
              if (self.iceGatheringState === 'new') {
                self.iceGatheringState = 'gathering';
              }
              // Usually candidates will be emitted earlier.
              window.setTimeout(self._emitBufferedCandidates.bind(self), 500);
            }
          });
          return p;
        };

    window.RTCPeerConnection.prototype.setRemoteDescription =
        function(description) {
          var self = this;
          var stream = new MediaStream();
          var receiverList = [];
          var sections = SDPUtils.splitSections(description.sdp);
          var sessionpart = sections.shift();
          var isIceLite = SDPUtils.matchPrefix(sessionpart,
              'a=ice-lite').length > 0;
          this.usingBundle = SDPUtils.matchPrefix(sessionpart,
              'a=group:BUNDLE ').length > 0;
          sections.forEach(function(mediaSection, sdpMLineIndex) {
            var lines = SDPUtils.splitLines(mediaSection);
            var mline = lines[0].substr(2).split(' ');
            var kind = mline[0];
            var rejected = mline[1] === '0';
            var direction = SDPUtils.getDirection(mediaSection, sessionpart);

            var mid = SDPUtils.matchPrefix(mediaSection, 'a=mid:');
            if (mid.length) {
              mid = mid[0].substr(6);
            } else {
              mid = SDPUtils.generateIdentifier();
            }

            // Reject datachannels which are not implemented yet.
            if (kind === 'application' && mline[2] === 'DTLS/SCTP') {
              self.transceivers[sdpMLineIndex] = {
                mid: mid,
                isDatachannel: true
              };
              return;
            }

            var transceiver;
            var iceGatherer;
            var iceTransport;
            var dtlsTransport;
            var rtpSender;
            var rtpReceiver;
            var sendEncodingParameters;
            var recvEncodingParameters;
            var localCapabilities;

            var track;
            // FIXME: ensure the mediaSection has rtcp-mux set.
            var remoteCapabilities = SDPUtils.parseRtpParameters(mediaSection);
            var remoteIceParameters;
            var remoteDtlsParameters;
            if (!rejected) {
              remoteIceParameters = SDPUtils.getIceParameters(mediaSection,
                  sessionpart);
              remoteDtlsParameters = SDPUtils.getDtlsParameters(mediaSection,
                  sessionpart);
              remoteDtlsParameters.role = 'client';
            }
            recvEncodingParameters =
                SDPUtils.parseRtpEncodingParameters(mediaSection);

            var cname;
            // Gets the first SSRC. Note that with RTX there might be multiple
            // SSRCs.
            var remoteSsrc = SDPUtils.matchPrefix(mediaSection, 'a=ssrc:')
                .map(function(line) {
                  return SDPUtils.parseSsrcMedia(line);
                })
                .filter(function(obj) {
                  return obj.attribute === 'cname';
                })[0];
            if (remoteSsrc) {
              cname = remoteSsrc.value;
            }

            var isComplete = SDPUtils.matchPrefix(mediaSection,
                'a=end-of-candidates', sessionpart).length > 0;
            var cands = SDPUtils.matchPrefix(mediaSection, 'a=candidate:')
                .map(function(cand) {
                  return SDPUtils.parseCandidate(cand);
                })
                .filter(function(cand) {
                  return cand.component === '1';
                });
            if (description.type === 'offer' && !rejected) {
              var transports = self.usingBundle && sdpMLineIndex > 0 ? {
                iceGatherer: self.transceivers[0].iceGatherer,
                iceTransport: self.transceivers[0].iceTransport,
                dtlsTransport: self.transceivers[0].dtlsTransport
              } : self._createIceAndDtlsTransports(mid, sdpMLineIndex);

              if (isComplete) {
                transports.iceTransport.setRemoteCandidates(cands);
              }

              localCapabilities = RTCRtpReceiver.getCapabilities(kind);

              // filter RTX until additional stuff needed for RTX is implemented
              // in adapter.js
              localCapabilities.codecs = localCapabilities.codecs.filter(
                  function(codec) {
                    return codec.name !== 'rtx';
                  });

              sendEncodingParameters = [{
                ssrc: (2 * sdpMLineIndex + 2) * 1001
              }];

              rtpReceiver = new RTCRtpReceiver(transports.dtlsTransport, kind);

              track = rtpReceiver.track;
              receiverList.push([track, rtpReceiver]);
              // FIXME: not correct when there are multiple streams but that is
              // not currently supported in this shim.
              stream.addTrack(track);

              // FIXME: look at direction.
              if (self.localStreams.length > 0 &&
                  self.localStreams[0].getTracks().length >= sdpMLineIndex) {
                var localTrack;
                if (kind === 'audio') {
                  localTrack = self.localStreams[0].getAudioTracks()[0];
                } else if (kind === 'video') {
                  localTrack = self.localStreams[0].getVideoTracks()[0];
                }
                if (localTrack) {
                  rtpSender = new RTCRtpSender(localTrack,
                      transports.dtlsTransport);
                }
              }

              self.transceivers[sdpMLineIndex] = {
                iceGatherer: transports.iceGatherer,
                iceTransport: transports.iceTransport,
                dtlsTransport: transports.dtlsTransport,
                localCapabilities: localCapabilities,
                remoteCapabilities: remoteCapabilities,
                rtpSender: rtpSender,
                rtpReceiver: rtpReceiver,
                kind: kind,
                mid: mid,
                cname: cname,
                sendEncodingParameters: sendEncodingParameters,
                recvEncodingParameters: recvEncodingParameters
              };
              // Start the RTCRtpReceiver now. The RTPSender is started in
              // setLocalDescription.
              self._transceive(self.transceivers[sdpMLineIndex],
                  false,
                  direction === 'sendrecv' || direction === 'sendonly');
            } else if (description.type === 'answer' && !rejected) {
              transceiver = self.transceivers[sdpMLineIndex];
              iceGatherer = transceiver.iceGatherer;
              iceTransport = transceiver.iceTransport;
              dtlsTransport = transceiver.dtlsTransport;
              rtpSender = transceiver.rtpSender;
              rtpReceiver = transceiver.rtpReceiver;
              sendEncodingParameters = transceiver.sendEncodingParameters;
              localCapabilities = transceiver.localCapabilities;

              self.transceivers[sdpMLineIndex].recvEncodingParameters =
                  recvEncodingParameters;
              self.transceivers[sdpMLineIndex].remoteCapabilities =
                  remoteCapabilities;
              self.transceivers[sdpMLineIndex].cname = cname;

              if ((isIceLite || isComplete) && cands.length) {
                iceTransport.setRemoteCandidates(cands);
              }
              if (!self.usingBundle || sdpMLineIndex === 0) {
                iceTransport.start(iceGatherer, remoteIceParameters,
                    'controlling');
                dtlsTransport.start(remoteDtlsParameters);
              }

              self._transceive(transceiver,
                  direction === 'sendrecv' || direction === 'recvonly',
                  direction === 'sendrecv' || direction === 'sendonly');

              if (rtpReceiver &&
                  (direction === 'sendrecv' || direction === 'sendonly')) {
                track = rtpReceiver.track;
                receiverList.push([track, rtpReceiver]);
                stream.addTrack(track);
              } else {
                // FIXME: actually the receiver should be created later.
                delete transceiver.rtpReceiver;
              }
            }
          });

          this.remoteDescription = {
            type: description.type,
            sdp: description.sdp
          };
          switch (description.type) {
            case 'offer':
              this._updateSignalingState('have-remote-offer');
              break;
            case 'answer':
              this._updateSignalingState('stable');
              break;
            default:
              throw new TypeError('unsupported type "' + description.type +
                  '"');
          }
          if (stream.getTracks().length) {
            self.remoteStreams.push(stream);
            window.setTimeout(function() {
              var event = new Event('addstream');
              event.stream = stream;
              self.dispatchEvent(event);
              if (self.onaddstream !== null) {
                window.setTimeout(function() {
                  self.onaddstream(event);
                }, 0);
              }

              receiverList.forEach(function(item) {
                var track = item[0];
                var receiver = item[1];
                var trackEvent = new Event('track');
                trackEvent.track = track;
                trackEvent.receiver = receiver;
                trackEvent.streams = [stream];
                self.dispatchEvent(event);
                if (self.ontrack !== null) {
                  window.setTimeout(function() {
                    self.ontrack(trackEvent);
                  }, 0);
                }
              });
            }, 0);
          }
          if (arguments.length > 1 && typeof arguments[1] === 'function') {
            window.setTimeout(arguments[1], 0);
          }
          return Promise.resolve();
        };

    window.RTCPeerConnection.prototype.close = function() {
      this.transceivers.forEach(function(transceiver) {
        /* not yet
        if (transceiver.iceGatherer) {
          transceiver.iceGatherer.close();
        }
        */
        if (transceiver.iceTransport) {
          transceiver.iceTransport.stop();
        }
        if (transceiver.dtlsTransport) {
          transceiver.dtlsTransport.stop();
        }
        if (transceiver.rtpSender) {
          transceiver.rtpSender.stop();
        }
        if (transceiver.rtpReceiver) {
          transceiver.rtpReceiver.stop();
        }
      });
      // FIXME: clean up tracks, local streams, remote streams, etc
      this._updateSignalingState('closed');
    };

    // Update the signaling state.
    window.RTCPeerConnection.prototype._updateSignalingState =
        function(newState) {
          this.signalingState = newState;
          var event = new Event('signalingstatechange');
          this.dispatchEvent(event);
          if (this.onsignalingstatechange !== null) {
            this.onsignalingstatechange(event);
          }
        };

    // Determine whether to fire the negotiationneeded event.
    window.RTCPeerConnection.prototype._maybeFireNegotiationNeeded =
        function() {
          // Fire away (for now).
          var event = new Event('negotiationneeded');
          this.dispatchEvent(event);
          if (this.onnegotiationneeded !== null) {
            this.onnegotiationneeded(event);
          }
        };

    // Update the connection state.
    window.RTCPeerConnection.prototype._updateConnectionState = function() {
      var self = this;
      var newState;
      var states = {
        'new': 0,
        closed: 0,
        connecting: 0,
        checking: 0,
        connected: 0,
        completed: 0,
        failed: 0
      };
      this.transceivers.forEach(function(transceiver) {
        states[transceiver.iceTransport.state]++;
        states[transceiver.dtlsTransport.state]++;
      });
      // ICETransport.completed and connected are the same for this purpose.
      states.connected += states.completed;

      newState = 'new';
      if (states.failed > 0) {
        newState = 'failed';
      } else if (states.connecting > 0 || states.checking > 0) {
        newState = 'connecting';
      } else if (states.disconnected > 0) {
        newState = 'disconnected';
      } else if (states.new > 0) {
        newState = 'new';
      } else if (states.connected > 0 || states.completed > 0) {
        newState = 'connected';
      }

      if (newState !== self.iceConnectionState) {
        self.iceConnectionState = newState;
        var event = new Event('iceconnectionstatechange');
        this.dispatchEvent(event);
        if (this.oniceconnectionstatechange !== null) {
          this.oniceconnectionstatechange(event);
        }
      }
    };

    window.RTCPeerConnection.prototype.createOffer = function() {
      var self = this;
      if (this._pendingOffer) {
        throw new Error('createOffer called while there is a pending offer.');
      }
      var offerOptions;
      if (arguments.length === 1 && typeof arguments[0] !== 'function') {
        offerOptions = arguments[0];
      } else if (arguments.length === 3) {
        offerOptions = arguments[2];
      }

      var tracks = [];
      var numAudioTracks = 0;
      var numVideoTracks = 0;
      // Default to sendrecv.
      if (this.localStreams.length) {
        numAudioTracks = this.localStreams[0].getAudioTracks().length;
        numVideoTracks = this.localStreams[0].getVideoTracks().length;
      }
      // Determine number of audio and video tracks we need to send/recv.
      if (offerOptions) {
        // Reject Chrome legacy constraints.
        if (offerOptions.mandatory || offerOptions.optional) {
          throw new TypeError(
              'Legacy mandatory/optional constraints not supported.');
        }
        if (offerOptions.offerToReceiveAudio !== undefined) {
          numAudioTracks = offerOptions.offerToReceiveAudio;
        }
        if (offerOptions.offerToReceiveVideo !== undefined) {
          numVideoTracks = offerOptions.offerToReceiveVideo;
        }
      }
      if (this.localStreams.length) {
        // Push local streams.
        this.localStreams[0].getTracks().forEach(function(track) {
          tracks.push({
            kind: track.kind,
            track: track,
            wantReceive: track.kind === 'audio' ?
                numAudioTracks > 0 : numVideoTracks > 0
          });
          if (track.kind === 'audio') {
            numAudioTracks--;
          } else if (track.kind === 'video') {
            numVideoTracks--;
          }
        });
      }
      // Create M-lines for recvonly streams.
      while (numAudioTracks > 0 || numVideoTracks > 0) {
        if (numAudioTracks > 0) {
          tracks.push({
            kind: 'audio',
            wantReceive: true
          });
          numAudioTracks--;
        }
        if (numVideoTracks > 0) {
          tracks.push({
            kind: 'video',
            wantReceive: true
          });
          numVideoTracks--;
        }
      }

      var sdp = SDPUtils.writeSessionBoilerplate();
      var transceivers = [];
      tracks.forEach(function(mline, sdpMLineIndex) {
        // For each track, create an ice gatherer, ice transport,
        // dtls transport, potentially rtpsender and rtpreceiver.
        var track = mline.track;
        var kind = mline.kind;
        var mid = SDPUtils.generateIdentifier();

        var transports = self.usingBundle && sdpMLineIndex > 0 ? {
          iceGatherer: transceivers[0].iceGatherer,
          iceTransport: transceivers[0].iceTransport,
          dtlsTransport: transceivers[0].dtlsTransport
        } : self._createIceAndDtlsTransports(mid, sdpMLineIndex);

        var localCapabilities = RTCRtpSender.getCapabilities(kind);
        // filter RTX until additional stuff needed for RTX is implemented
        // in adapter.js
        localCapabilities.codecs = localCapabilities.codecs.filter(
            function(codec) {
              return codec.name !== 'rtx';
            });
        localCapabilities.codecs.forEach(function(codec) {
          // work around https://bugs.chromium.org/p/webrtc/issues/detail?id=6552
          // by adding level-asymmetry-allowed=1
          if (codec.name === 'H264' &&
              codec.parameters['level-asymmetry-allowed'] === undefined) {
            codec.parameters['level-asymmetry-allowed'] = '1';
          }
        });

        var rtpSender;
        var rtpReceiver;

        // generate an ssrc now, to be used later in rtpSender.send
        var sendEncodingParameters = [{
          ssrc: (2 * sdpMLineIndex + 1) * 1001
        }];
        if (track) {
          rtpSender = new RTCRtpSender(track, transports.dtlsTransport);
        }

        if (mline.wantReceive) {
          rtpReceiver = new RTCRtpReceiver(transports.dtlsTransport, kind);
        }

        transceivers[sdpMLineIndex] = {
          iceGatherer: transports.iceGatherer,
          iceTransport: transports.iceTransport,
          dtlsTransport: transports.dtlsTransport,
          localCapabilities: localCapabilities,
          remoteCapabilities: null,
          rtpSender: rtpSender,
          rtpReceiver: rtpReceiver,
          kind: kind,
          mid: mid,
          sendEncodingParameters: sendEncodingParameters,
          recvEncodingParameters: null
        };
      });
      if (this.usingBundle) {
        sdp += 'a=group:BUNDLE ' + transceivers.map(function(t) {
          return t.mid;
        }).join(' ') + '\r\n';
      }
      tracks.forEach(function(mline, sdpMLineIndex) {
        var transceiver = transceivers[sdpMLineIndex];
        sdp += SDPUtils.writeMediaSection(transceiver,
            transceiver.localCapabilities, 'offer', self.localStreams[0]);
      });

      this._pendingOffer = transceivers;
      var desc = new RTCSessionDescription({
        type: 'offer',
        sdp: sdp
      });
      if (arguments.length && typeof arguments[0] === 'function') {
        window.setTimeout(arguments[0], 0, desc);
      }
      return Promise.resolve(desc);
    };

    window.RTCPeerConnection.prototype.createAnswer = function() {
      var self = this;

      var sdp = SDPUtils.writeSessionBoilerplate();
      if (this.usingBundle) {
        sdp += 'a=group:BUNDLE ' + this.transceivers.map(function(t) {
          return t.mid;
        }).join(' ') + '\r\n';
      }
      this.transceivers.forEach(function(transceiver) {
        if (transceiver.isDatachannel) {
          sdp += 'm=application 0 DTLS/SCTP 5000\r\n' +
              'c=IN IP4 0.0.0.0\r\n' +
              'a=mid:' + transceiver.mid + '\r\n';
          return;
        }
        // Calculate intersection of capabilities.
        var commonCapabilities = self._getCommonCapabilities(
            transceiver.localCapabilities,
            transceiver.remoteCapabilities);

        sdp += SDPUtils.writeMediaSection(transceiver, commonCapabilities,
            'answer', self.localStreams[0]);
      });

      var desc = new RTCSessionDescription({
        type: 'answer',
        sdp: sdp
      });
      if (arguments.length && typeof arguments[0] === 'function') {
        window.setTimeout(arguments[0], 0, desc);
      }
      return Promise.resolve(desc);
    };

    window.RTCPeerConnection.prototype.addIceCandidate = function(candidate) {
      if (!candidate) {
        this.transceivers.forEach(function(transceiver) {
          transceiver.iceTransport.addRemoteCandidate({});
        });
      } else {
        var mLineIndex = candidate.sdpMLineIndex;
        if (candidate.sdpMid) {
          for (var i = 0; i < this.transceivers.length; i++) {
            if (this.transceivers[i].mid === candidate.sdpMid) {
              mLineIndex = i;
              break;
            }
          }
        }
        var transceiver = this.transceivers[mLineIndex];
        if (transceiver) {
          var cand = Object.keys(candidate.candidate).length > 0 ?
              SDPUtils.parseCandidate(candidate.candidate) : {};
          // Ignore Chrome's invalid candidates since Edge does not like them.
          if (cand.protocol === 'tcp' && (cand.port === 0 || cand.port === 9)) {
            return;
          }
          // Ignore RTCP candidates, we assume RTCP-MUX.
          if (cand.component !== '1') {
            return;
          }
          // A dirty hack to make samples work.
          if (cand.type === 'endOfCandidates') {
            cand = {};
          }
          transceiver.iceTransport.addRemoteCandidate(cand);

          // update the remoteDescription.
          var sections = SDPUtils.splitSections(this.remoteDescription.sdp);
          sections[mLineIndex + 1] += (cand.type ? candidate.candidate.trim()
              : 'a=end-of-candidates') + '\r\n';
          this.remoteDescription.sdp = sections.join('');
        }
      }
      if (arguments.length > 1 && typeof arguments[1] === 'function') {
        window.setTimeout(arguments[1], 0);
      }
      return Promise.resolve();
    };

    window.RTCPeerConnection.prototype.getStats = function() {
      var promises = [];
      this.transceivers.forEach(function(transceiver) {
        ['rtpSender', 'rtpReceiver', 'iceGatherer', 'iceTransport',
            'dtlsTransport'].forEach(function(method) {
              if (transceiver[method]) {
                promises.push(transceiver[method].getStats());
              }
            });
      });
      var cb = arguments.length > 1 && typeof arguments[1] === 'function' &&
          arguments[1];
      return new Promise(function(resolve) {
        // shim getStats with maplike support
        var results = new Map();
        Promise.all(promises).then(function(res) {
          res.forEach(function(result) {
            Object.keys(result).forEach(function(id) {
              results.set(id, result[id]);
              results[id] = result[id];
            });
          });
          if (cb) {
            window.setTimeout(cb, 0, results);
          }
          resolve(results);
        });
      });
    };
  }
};

// Expose public methods.
module.exports = {
  shimPeerConnection: edgeShim.shimPeerConnection,
  shimGetUserMedia: __webpack_require__(207)
};


/***/ },
/* 207 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */


// Expose public methods.
module.exports = function() {
  var shimError_ = function(e) {
    return {
      name: {PermissionDeniedError: 'NotAllowedError'}[e.name] || e.name,
      message: e.message,
      constraint: e.constraint,
      toString: function() {
        return this.name;
      }
    };
  };

  // getUserMedia error shim.
  var origGetUserMedia = navigator.mediaDevices.getUserMedia.
      bind(navigator.mediaDevices);
  navigator.mediaDevices.getUserMedia = function(c) {
    return origGetUserMedia(c).catch(function(e) {
      return Promise.reject(shimError_(e));
    });
  };
};


/***/ },
/* 208 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */


var browserDetails = __webpack_require__(0).browserDetails;

var firefoxShim = {
  shimOnTrack: function() {
    if (typeof window === 'object' && window.RTCPeerConnection && !('ontrack' in
        window.RTCPeerConnection.prototype)) {
      Object.defineProperty(window.RTCPeerConnection.prototype, 'ontrack', {
        get: function() {
          return this._ontrack;
        },
        set: function(f) {
          if (this._ontrack) {
            this.removeEventListener('track', this._ontrack);
            this.removeEventListener('addstream', this._ontrackpoly);
          }
          this.addEventListener('track', this._ontrack = f);
          this.addEventListener('addstream', this._ontrackpoly = function(e) {
            e.stream.getTracks().forEach(function(track) {
              var event = new Event('track');
              event.track = track;
              event.receiver = {track: track};
              event.streams = [e.stream];
              this.dispatchEvent(event);
            }.bind(this));
          }.bind(this));
        }
      });
    }
  },

  shimSourceObject: function() {
    // Firefox has supported mozSrcObject since FF22, unprefixed in 42.
    if (typeof window === 'object') {
      if (window.HTMLMediaElement &&
        !('srcObject' in window.HTMLMediaElement.prototype)) {
        // Shim the srcObject property, once, when HTMLMediaElement is found.
        Object.defineProperty(window.HTMLMediaElement.prototype, 'srcObject', {
          get: function() {
            return this.mozSrcObject;
          },
          set: function(stream) {
            this.mozSrcObject = stream;
          }
        });
      }
    }
  },

  shimPeerConnection: function() {
    if (typeof window !== 'object' || !(window.RTCPeerConnection ||
        window.mozRTCPeerConnection)) {
      return; // probably media.peerconnection.enabled=false in about:config
    }
    // The RTCPeerConnection object.
    if (!window.RTCPeerConnection) {
      window.RTCPeerConnection = function(pcConfig, pcConstraints) {
        if (browserDetails.version < 38) {
          // .urls is not supported in FF < 38.
          // create RTCIceServers with a single url.
          if (pcConfig && pcConfig.iceServers) {
            var newIceServers = [];
            for (var i = 0; i < pcConfig.iceServers.length; i++) {
              var server = pcConfig.iceServers[i];
              if (server.hasOwnProperty('urls')) {
                for (var j = 0; j < server.urls.length; j++) {
                  var newServer = {
                    url: server.urls[j]
                  };
                  if (server.urls[j].indexOf('turn') === 0) {
                    newServer.username = server.username;
                    newServer.credential = server.credential;
                  }
                  newIceServers.push(newServer);
                }
              } else {
                newIceServers.push(pcConfig.iceServers[i]);
              }
            }
            pcConfig.iceServers = newIceServers;
          }
        }
        return new mozRTCPeerConnection(pcConfig, pcConstraints);
      };
      window.RTCPeerConnection.prototype = mozRTCPeerConnection.prototype;

      // wrap static methods. Currently just generateCertificate.
      if (mozRTCPeerConnection.generateCertificate) {
        Object.defineProperty(window.RTCPeerConnection, 'generateCertificate', {
          get: function() {
            return mozRTCPeerConnection.generateCertificate;
          }
        });
      }

      window.RTCSessionDescription = mozRTCSessionDescription;
      window.RTCIceCandidate = mozRTCIceCandidate;
    }

    // shim away need for obsolete RTCIceCandidate/RTCSessionDescription.
    ['setLocalDescription', 'setRemoteDescription', 'addIceCandidate']
        .forEach(function(method) {
          var nativeMethod = RTCPeerConnection.prototype[method];
          RTCPeerConnection.prototype[method] = function() {
            arguments[0] = new ((method === 'addIceCandidate') ?
                RTCIceCandidate : RTCSessionDescription)(arguments[0]);
            return nativeMethod.apply(this, arguments);
          };
        });

    // support for addIceCandidate(null or undefined)
    var nativeAddIceCandidate =
        RTCPeerConnection.prototype.addIceCandidate;
    RTCPeerConnection.prototype.addIceCandidate = function() {
      if (!arguments[0]) {
        if (arguments[1]) {
          arguments[1].apply(null);
        }
        return Promise.resolve();
      }
      return nativeAddIceCandidate.apply(this, arguments);
    };

    if (browserDetails.version < 48) {
      // shim getStats with maplike support
      var makeMapStats = function(stats) {
        var map = new Map();
        Object.keys(stats).forEach(function(key) {
          map.set(key, stats[key]);
          map[key] = stats[key];
        });
        return map;
      };

      var nativeGetStats = RTCPeerConnection.prototype.getStats;
      RTCPeerConnection.prototype.getStats = function(selector, onSucc, onErr) {
        return nativeGetStats.apply(this, [selector || null])
          .then(function(stats) {
            return makeMapStats(stats);
          })
          .then(onSucc, onErr);
      };
    }
  }
};

// Expose public methods.
module.exports = {
  shimOnTrack: firefoxShim.shimOnTrack,
  shimSourceObject: firefoxShim.shimSourceObject,
  shimPeerConnection: firefoxShim.shimPeerConnection,
  shimGetUserMedia: __webpack_require__(209)
};


/***/ },
/* 209 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */


var logging = __webpack_require__(0).log;
var browserDetails = __webpack_require__(0).browserDetails;

// Expose public methods.
module.exports = function() {
  var shimError_ = function(e) {
    return {
      name: {
        SecurityError: 'NotAllowedError',
        PermissionDeniedError: 'NotAllowedError'
      }[e.name] || e.name,
      message: {
        'The operation is insecure.': 'The request is not allowed by the ' +
        'user agent or the platform in the current context.'
      }[e.message] || e.message,
      constraint: e.constraint,
      toString: function() {
        return this.name + (this.message && ': ') + this.message;
      }
    };
  };

  // getUserMedia constraints shim.
  var getUserMedia_ = function(constraints, onSuccess, onError) {
    var constraintsToFF37_ = function(c) {
      if (typeof c !== 'object' || c.require) {
        return c;
      }
      var require = [];
      Object.keys(c).forEach(function(key) {
        if (key === 'require' || key === 'advanced' || key === 'mediaSource') {
          return;
        }
        var r = c[key] = (typeof c[key] === 'object') ?
            c[key] : {ideal: c[key]};
        if (r.min !== undefined ||
            r.max !== undefined || r.exact !== undefined) {
          require.push(key);
        }
        if (r.exact !== undefined) {
          if (typeof r.exact === 'number') {
            r. min = r.max = r.exact;
          } else {
            c[key] = r.exact;
          }
          delete r.exact;
        }
        if (r.ideal !== undefined) {
          c.advanced = c.advanced || [];
          var oc = {};
          if (typeof r.ideal === 'number') {
            oc[key] = {min: r.ideal, max: r.ideal};
          } else {
            oc[key] = r.ideal;
          }
          c.advanced.push(oc);
          delete r.ideal;
          if (!Object.keys(r).length) {
            delete c[key];
          }
        }
      });
      if (require.length) {
        c.require = require;
      }
      return c;
    };
    constraints = JSON.parse(JSON.stringify(constraints));
    if (browserDetails.version < 38) {
      logging('spec: ' + JSON.stringify(constraints));
      if (constraints.audio) {
        constraints.audio = constraintsToFF37_(constraints.audio);
      }
      if (constraints.video) {
        constraints.video = constraintsToFF37_(constraints.video);
      }
      logging('ff37: ' + JSON.stringify(constraints));
    }
    return navigator.mozGetUserMedia(constraints, onSuccess, function(e) {
      onError(shimError_(e));
    });
  };

  // Returns the result of getUserMedia as a Promise.
  var getUserMediaPromise_ = function(constraints) {
    return new Promise(function(resolve, reject) {
      getUserMedia_(constraints, resolve, reject);
    });
  };

  // Shim for mediaDevices on older versions.
  if (!navigator.mediaDevices) {
    navigator.mediaDevices = {getUserMedia: getUserMediaPromise_,
      addEventListener: function() { },
      removeEventListener: function() { }
    };
  }
  navigator.mediaDevices.enumerateDevices =
      navigator.mediaDevices.enumerateDevices || function() {
        return new Promise(function(resolve) {
          var infos = [
            {kind: 'audioinput', deviceId: 'default', label: '', groupId: ''},
            {kind: 'videoinput', deviceId: 'default', label: '', groupId: ''}
          ];
          resolve(infos);
        });
      };

  if (browserDetails.version < 41) {
    // Work around http://bugzil.la/1169665
    var orgEnumerateDevices =
        navigator.mediaDevices.enumerateDevices.bind(navigator.mediaDevices);
    navigator.mediaDevices.enumerateDevices = function() {
      return orgEnumerateDevices().then(undefined, function(e) {
        if (e.name === 'NotFoundError') {
          return [];
        }
        throw e;
      });
    };
  }
  if (browserDetails.version < 49) {
    var origGetUserMedia = navigator.mediaDevices.getUserMedia.
        bind(navigator.mediaDevices);
    navigator.mediaDevices.getUserMedia = function(c) {
      return origGetUserMedia(c).then(function(stream) {
        // Work around https://bugzil.la/802326
        if (c.audio && !stream.getAudioTracks().length ||
            c.video && !stream.getVideoTracks().length) {
          stream.getTracks().forEach(function(track) {
            track.stop();
          });
          throw new DOMException('The object can not be found here.',
                                 'NotFoundError');
        }
        return stream;
      }, function(e) {
        return Promise.reject(shimError_(e));
      });
    };
  }
  navigator.getUserMedia = function(constraints, onSuccess, onError) {
    if (browserDetails.version < 44) {
      return getUserMedia_(constraints, onSuccess, onError);
    }
    // Replace Firefox 44+'s deprecation warning with unprefixed version.
    console.warn('navigator.getUserMedia has been replaced by ' +
                 'navigator.mediaDevices.getUserMedia');
    navigator.mediaDevices.getUserMedia(constraints).then(onSuccess, onError);
  };
};


/***/ },
/* 210 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */

var safariShim = {
  // TODO: DrAlex, should be here, double check against LayoutTests
  // shimOnTrack: function() { },

  // TODO: once the back-end for the mac port is done, add.
  // TODO: check for webkitGTK+
  // shimPeerConnection: function() { },

  shimGetUserMedia: function() {
    navigator.getUserMedia = navigator.webkitGetUserMedia;
  }
};

// Expose public methods.
module.exports = {
  shimGetUserMedia: safariShim.shimGetUserMedia
  // TODO
  // shimOnTrack: safariShim.shimOnTrack,
  // shimPeerConnection: safariShim.shimPeerConnection
};


/***/ },
/* 211 */
/***/ function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_211__;

/***/ },
/* 212 */
/***/ function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_212__;

/***/ },
/* 213 */
/***/ function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_213__;

/***/ },
/* 214 */
/***/ function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(71);


/***/ }
/******/ ]);
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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