---
layout: docs
title: Syntax Highlighter Module
permalink: /docs/modules/syntax/
redirect_from:
  - /docs/modules/code-highlighter/
---

The Syntax Module enhances the Code Block format by automatically detecting and applying syntax highlighting. The excellent [highlight.js](https://highlightjs.org/) library is used as a dependency to parse and tokenize code blocks.

In general, you may [configure](http://highlightjs.readthedocs.io/en/latest/api.html#configure-options) highlight.js as needed. However, Quill expects and requires the `useBR` option to be `false`.


### Example

```html
<!-- Include your favorite highlight.js stylesheet -->
<link href="highlight.js/monokai-sublime.min.css" rel="stylesheet">

<!-- Include the highlight.js library -->
<script href="highlight.js"></script>

<script>
hljs.configure({   // optionally configure hljs
  languages: ['javascript', 'ruby', 'python']
});

var quill = new Quill('#editor', {
  modules: {
    syntax: true,              // Include syntax module
    toolbar: [['code-block']]  // Include button in toolbar
  },
  theme: 'snow'
});
</script>
```
