var _assoc = require('./internal/_assoc');
var _curry3 = require('./internal/_curry3');


/**
 * Makes a shallow clone of an object, setting or overriding the specified
 * property with the given value.  Note that this copies and flattens
 * prototype properties onto the new object as well.  All non-primitive
 * properties are copied by reference.
 *
 * @func
 * @memberOf R
 * @category Object
 * @sig String -> a -> {k: v} -> {k: v}
 * @param {String} prop the property name to set
 * @param {*} val the new value
 * @param {Object} obj the object to clone
 * @return {Object} a new object similar to the original except for the specified property.
 * @example
 *
 *      R.assoc('c', 3, {a: 1, b: 2}); //=> {a: 1, b: 2, c: 3}
 */
module.exports = _curry3(_assoc);
