var _curry1 = require('./internal/_curry1');
var _slice = require('./internal/_slice');


/**
 * Returns a new list with the same elements as the original list, just
 * in the reverse order.
 *
 * @func
 * @memberOf R
 * @category List
 * @sig [a] -> [a]
 * @param {Array} list The list to reverse.
 * @return {Array} A copy of the list in reverse order.
 * @example
 *
 *      R.reverse([1, 2, 3]);  //=> [3, 2, 1]
 *      R.reverse([1, 2]);     //=> [2, 1]
 *      R.reverse([1]);        //=> [1]
 *      R.reverse([]);         //=> []
 */
module.exports = _curry1(function reverse(list) {
  return _slice(list).reverse();
});
