var _concat = require('./internal/_concat');
var _curry2 = require('./internal/_curry2');
var _hasMethod = require('./internal/_hasMethod');
var _reduce = require('./internal/_reduce');
var map = require('./map');


/**
 * ap applies a list of functions to a list of values.
 *
 * @func
 * @memberOf R
 * @category Function
 * @sig [f] -> [a] -> [f a]
 * @param {Array} fns An array of functions
 * @param {Array} vs An array of values
 * @return {Array} An array of results of applying each of `fns` to all of `vs` in turn.
 * @example
 *
 *      R.ap([R.multiply(2), R.add(3)], [1,2,3]); //=> [2, 4, 6, 4, 5, 6]
 */
module.exports = _curry2(function ap(fns, vs) {
  return _hasMethod('ap', fns) ? fns.ap(vs) : _reduce(function(acc, fn) {
    return _concat(acc, map(fn, vs));
  }, [], fns);
});
