var _curry1 = require('./internal/_curry1');
var merge = require('./merge');
var reduce = require('./reduce');


/**
 * Merges a list of objects together into one object.
 *
 * @func
 * @memberOf R
 * @category List
 * @sig [{k: v}] -> {k: v}
 * @param {Array} list An array of objects
 * @return {Object} A merged object.
 * @see R.reduce
 * @example
 *
 *      R.mergeAll([{foo:1},{bar:2},{baz:3}]); //=> {foo:1,bar:2,baz:3}
 *      R.mergeAll([{foo:1},{foo:2},{bar:2}]); //=> {foo:2,bar:2}
 */
module.exports = _curry1(function mergeAll(list) {
  return reduce(merge, {}, list);
});
