var _curry2 = require('./internal/_curry2');


/**
 * Retrieve the value at a given path.
 *
 * @func
 * @memberOf R
 * @category Object
 * @sig [String] -> {k: v} -> v | Undefined
 * @param {Array} path The path to use.
 * @return {*} The data at `path`.
 * @example
 *
 *      R.path(['a', 'b'], {a: {b: 2}}); //=> 2
 *      R.path(['a', 'b'], {c: {b: 2}}); //=> undefined
 */
module.exports = _curry2(function path(paths, obj) {
  if (obj == null) {
    return;
  } else {
    var val = obj;
    for (var idx = 0, len = paths.length; idx < len && val != null; idx += 1) {
      val = val[paths[idx]];
    }
    return val;
  }
});
