(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("React"), require("d3"));
	else if(typeof define === 'function' && define.amd)
		define(["React", "d3"], factory);
	else if(typeof exports === 'object')
		exports["ReactD3"] = factory(require("React"), require("d3"));
	else
		root["ReactD3"] = factory(root["React"], root["d3"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_7__, __WEBPACK_EXTERNAL_MODULE_8__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar BarChart = __webpack_require__(1);\nvar PieChart = __webpack_require__(2);\nvar ScatterPlot = __webpack_require__(3);\nvar LineChart = __webpack_require__(4);\nvar AreaChart = __webpack_require__(5);\nvar Brush = __webpack_require__(6);\n\nmodule.exports = {\n\tBarChart: BarChart,\n\tPieChart: PieChart,\n\tScatterPlot: ScatterPlot,\n\tLineChart: LineChart,\n\tAreaChart: AreaChart,\n\tBrush: Brush\n};\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/index.jsx\n ** module id = 0\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/index.jsx?");

/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar Chart = __webpack_require__(9);\nvar Axis = __webpack_require__(10);\nvar Bar = __webpack_require__(11);\nvar Tooltip = __webpack_require__(12);\n\nvar DefaultPropsMixin = __webpack_require__(13);\nvar HeightWidthMixin = __webpack_require__(14);\nvar ArrayifyMixin = __webpack_require__(15);\nvar StackAccessorMixin = __webpack_require__(16);\nvar StackDataMixin = __webpack_require__(17);\nvar DefaultScalesMixin = __webpack_require__(18);\nvar TooltipMixin = __webpack_require__(19);\n\nvar DataSet = React.createClass({\n\tdisplayName: \"DataSet\",\n\n\tpropTypes: {\n\t\tdata: React.PropTypes.array.isRequired,\n\t\txScale: React.PropTypes.func.isRequired,\n\t\tyScale: React.PropTypes.func.isRequired,\n\t\tcolorScale: React.PropTypes.func.isRequired,\n\t\tvalues: React.PropTypes.func.isRequired,\n\t\tlabel: React.PropTypes.func.isRequired,\n\t\tx: React.PropTypes.func.isRequired,\n\t\ty: React.PropTypes.func.isRequired,\n\t\ty0: React.PropTypes.func.isRequired\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar data = _props.data;\n\t\tvar xScale = _props.xScale;\n\t\tvar yScale = _props.yScale;\n\t\tvar colorScale = _props.colorScale;\n\t\tvar values = _props.values;\n\t\tvar label = _props.label;\n\t\tvar x = _props.x;\n\t\tvar y = _props.y;\n\t\tvar y0 = _props.y0;\n\t\tvar onMouseEnter = _props.onMouseEnter;\n\t\tvar onMouseLeave = _props.onMouseLeave;\n\n\t\tvar bars = data.map(function (stack) {\n\t\t\treturn values(stack).map(function (e, index) {\n\t\t\t\treturn React.createElement(Bar, {\n\t\t\t\t\tkey: \"\" + label(stack) + \".\" + index,\n\t\t\t\t\twidth: xScale.rangeBand(),\n\t\t\t\t\theight: yScale(yScale.domain()[0]) - yScale(y(e)),\n\t\t\t\t\tx: xScale(x(e)),\n\t\t\t\t\ty: yScale(y0(e) + y(e)),\n\t\t\t\t\tfill: colorScale(label(stack)),\n\t\t\t\t\tdata: e,\n\t\t\t\t\tonMouseEnter: onMouseEnter,\n\t\t\t\t\tonMouseLeave: onMouseLeave\n\t\t\t\t});\n\t\t\t});\n\t\t});\n\n\t\treturn React.createElement(\n\t\t\t\"g\",\n\t\t\tnull,\n\t\t\tbars\n\t\t);\n\t}\n});\n\nvar BarChart = React.createClass({\n\tdisplayName: \"BarChart\",\n\n\tmixins: [DefaultPropsMixin, HeightWidthMixin, ArrayifyMixin, StackAccessorMixin, StackDataMixin, DefaultScalesMixin, TooltipMixin],\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {};\n\t},\n\n\t_tooltipHtml: function _tooltipHtml(d, position) {\n\t\treturn this.props.tooltipHtml(this.props.x(d), this.props.y0(d), this.props.y(d));\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar height = _props.height;\n\t\tvar width = _props.width;\n\t\tvar margin = _props.margin;\n\t\tvar colorScale = _props.colorScale;\n\t\tvar values = _props.values;\n\t\tvar label = _props.label;\n\t\tvar y = _props.y;\n\t\tvar y0 = _props.y0;\n\t\tvar x = _props.x;\n\t\tvar xAxis = _props.xAxis;\n\t\tvar yAxis = _props.yAxis;\n\t\tvar data = this._data;\n\t\tvar innerWidth = this._innerWidth;\n\t\tvar innerHeight = this._innerHeight;\n\t\tvar xScale = this._xScale;\n\t\tvar yScale = this._yScale;\n\n\t\treturn React.createElement(\n\t\t\t\"div\",\n\t\t\tnull,\n\t\t\tReact.createElement(\n\t\t\t\tChart,\n\t\t\t\t{ height: height, width: width, margin: margin },\n\t\t\t\tReact.createElement(DataSet, {\n\t\t\t\t\tdata: data,\n\t\t\t\t\txScale: xScale,\n\t\t\t\t\tyScale: yScale,\n\t\t\t\t\tcolorScale: colorScale,\n\t\t\t\t\tvalues: values,\n\t\t\t\t\tlabel: label,\n\t\t\t\t\ty: y,\n\t\t\t\t\ty0: y0,\n\t\t\t\t\tx: x,\n\t\t\t\t\tonMouseEnter: this.onMouseEnter,\n\t\t\t\t\tonMouseLeave: this.onMouseLeave\n\t\t\t\t}),\n\t\t\t\tReact.createElement(Axis, _extends({\n\t\t\t\t\tclassName: \"x axis\",\n\t\t\t\t\torientation: \"bottom\",\n\t\t\t\t\tscale: xScale,\n\t\t\t\t\theight: innerHeight,\n\t\t\t\t\twidth: innerWidth\n\t\t\t\t}, xAxis)),\n\t\t\t\tReact.createElement(Axis, _extends({\n\t\t\t\t\tclassName: \"y axis\",\n\t\t\t\t\torientation: \"left\",\n\t\t\t\t\tscale: yScale,\n\t\t\t\t\theight: innerHeight,\n\t\t\t\t\twidth: innerWidth\n\t\t\t\t}, yAxis))\n\t\t\t),\n\t\t\tReact.createElement(Tooltip, {\n\t\t\t\thidden: this.state.tooltip.hidden,\n\t\t\t\ttop: this.state.tooltip.top,\n\t\t\t\tleft: this.state.tooltip.left,\n\t\t\t\thtml: this.state.tooltip.html })\n\t\t);\n\t}\n});\n\nmodule.exports = BarChart;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/BarChart.jsx\n ** module id = 1\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/BarChart.jsx?");

/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar Chart = __webpack_require__(9);\nvar Tooltip = __webpack_require__(12);\n\nvar DefaultPropsMixin = __webpack_require__(13);\nvar HeightWidthMixin = __webpack_require__(14);\nvar AccessorMixin = __webpack_require__(20);\nvar TooltipMixin = __webpack_require__(19);\n\nvar Wedge = React.createClass({\n\tdisplayName: \"Wedge\",\n\n\tpropTypes: {\n\t\td: React.PropTypes.string.isRequired,\n\t\tfill: React.PropTypes.string.isRequired\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar fill = _props.fill;\n\t\tvar d = _props.d;\n\t\tvar data = _props.data;\n\t\tvar onMouseEnter = _props.onMouseEnter;\n\t\tvar onMouseLeave = _props.onMouseLeave;\n\n\t\treturn React.createElement(\"path\", {\n\t\t\tfill: fill,\n\t\t\td: d,\n\t\t\tonMouseMove: function (evt) {\n\t\t\t\tonMouseEnter(evt, data);\n\t\t\t},\n\t\t\tonMouseLeave: function (evt) {\n\t\t\t\tonMouseLeave(evt);\n\t\t\t}\n\t\t});\n\t}\n});\n\nvar DataSet = React.createClass({\n\tdisplayName: \"DataSet\",\n\n\tpropTypes: {\n\t\tpie: React.PropTypes.array.isRequired,\n\t\tarc: React.PropTypes.func.isRequired,\n\t\touterArc: React.PropTypes.func.isRequired,\n\t\tcolorScale: React.PropTypes.func.isRequired,\n\t\tradius: React.PropTypes.number.isRequired,\n\t\tstrokeWidth: React.PropTypes.number,\n\t\tstroke: React.PropTypes.string,\n\t\tfill: React.PropTypes.string,\n\t\topacity: React.PropTypes.number,\n\t\tx: React.PropTypes.func.isRequired\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\tstrokeWidth: 2,\n\t\t\tstroke: \"#000\",\n\t\t\tfill: \"none\",\n\t\t\topacity: 0.3\n\t\t};\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar pie = _props.pie;\n\t\tvar arc = _props.arc;\n\t\tvar outerArc = _props.outerArc;\n\t\tvar colorScale = _props.colorScale;\n\t\tvar radius = _props.radius;\n\t\tvar strokeWidth = _props.strokeWidth;\n\t\tvar stroke = _props.stroke;\n\t\tvar fill = _props.fill;\n\t\tvar opacity = _props.opacity;\n\t\tvar x = _props.x;\n\t\tvar y = _props.y;\n\t\tvar onMouseEnter = _props.onMouseEnter;\n\t\tvar onMouseLeave = _props.onMouseLeave;\n\n\t\tvar wedges = pie.map(function (e, index) {\n\t\t\tfunction midAngle(d) {\n\t\t\t\treturn d.startAngle + (d.endAngle - d.startAngle) / 2;\n\t\t\t}\n\n\t\t\tvar d = arc(e);\n\n\t\t\tvar labelPos = outerArc.centroid(e);\n\t\t\tlabelPos[0] = radius * (midAngle(e) < Math.PI ? 1 : -1);\n\n\t\t\tvar textAnchor = midAngle(e) < Math.PI ? \"start\" : \"end\";\n\n\t\t\tvar linePos = outerArc.centroid(e);\n\t\t\tlinePos[0] = radius * 0.95 * (midAngle(e) < Math.PI ? 1 : -1);\n\n\t\t\treturn React.createElement(\n\t\t\t\t\"g\",\n\t\t\t\t{ key: \"\" + x(e.data) + \".\" + y(e.data) + \".\" + index, className: \"arc\" },\n\t\t\t\tReact.createElement(Wedge, {\n\t\t\t\t\tdata: e.data,\n\t\t\t\t\tfill: colorScale(x(e.data)),\n\t\t\t\t\td: d,\n\t\t\t\t\tonMouseEnter: onMouseEnter,\n\t\t\t\t\tonMouseLeave: onMouseLeave\n\t\t\t\t}),\n\t\t\t\tReact.createElement(\"polyline\", {\n\t\t\t\t\topacity: opacity,\n\t\t\t\t\tstrokeWidth: strokeWidth,\n\t\t\t\t\tstroke: stroke,\n\t\t\t\t\tfill: fill,\n\t\t\t\t\tpoints: [arc.centroid(e), outerArc.centroid(e), linePos]\n\t\t\t\t}),\n\t\t\t\tReact.createElement(\n\t\t\t\t\t\"text\",\n\t\t\t\t\t{\n\t\t\t\t\t\tdy: \".35em\",\n\t\t\t\t\t\tx: labelPos[0],\n\t\t\t\t\t\ty: labelPos[1],\n\t\t\t\t\t\ttextAnchor: textAnchor },\n\t\t\t\t\tx(e.data)\n\t\t\t\t)\n\t\t\t);\n\t\t});\n\n\t\treturn React.createElement(\n\t\t\t\"g\",\n\t\t\tnull,\n\t\t\twedges\n\t\t);\n\t}\n});\n\nvar PieChart = React.createClass({\n\tdisplayName: \"PieChart\",\n\n\tmixins: [DefaultPropsMixin, HeightWidthMixin, AccessorMixin, TooltipMixin],\n\n\tpropTypes: {\n\t\tinnerRadius: React.PropTypes.number,\n\t\touterRadius: React.PropTypes.number,\n\t\tlabelRadius: React.PropTypes.number,\n\t\tpadRadius: React.PropTypes.string,\n\t\tcornerRadius: React.PropTypes.number,\n\t\tsort: React.PropTypes.any\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\tinnerRadius: null,\n\t\t\touterRadius: null,\n\t\t\tlabelRadius: null,\n\t\t\tpadRadius: \"auto\",\n\t\t\tcornerRadius: 0,\n\t\t\tsort: undefined\n\t\t};\n\t},\n\n\t_tooltipHtml: function _tooltipHtml(d, position) {\n\t\treturn this.props.tooltipHtml(this.props.x(d), this.props.y(d));\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar data = _props.data;\n\t\tvar width = _props.width;\n\t\tvar height = _props.height;\n\t\tvar margin = _props.margin;\n\t\tvar colorScale = _props.colorScale;\n\t\tvar innerRadius = _props.innerRadius;\n\t\tvar outerRadius = _props.outerRadius;\n\t\tvar labelRadius = _props.labelRadius;\n\t\tvar padRadius = _props.padRadius;\n\t\tvar cornerRadius = _props.cornerRadius;\n\t\tvar sort = _props.sort;\n\t\tvar x = _props.x;\n\t\tvar y = _props.y;\n\t\tvar values = _props.values;\n\t\tvar innerWidth = this._innerWidth;\n\t\tvar innerHeight = this._innerHeight;\n\n\t\tvar pie = d3.layout.pie().value(function (e) {\n\t\t\treturn y(e);\n\t\t});\n\n\t\tif (typeof sort !== \"undefined\") {\n\t\t\tpie = pie.sort(sort);\n\t\t}\n\n\t\tvar radius = Math.min(innerWidth, innerHeight) / 2;\n\t\tif (!innerRadius) {\n\t\t\tinnerRadius = radius * 0.8;\n\t\t}\n\n\t\tif (!outerRadius) {\n\t\t\touterRadius = radius * 0.4;\n\t\t}\n\n\t\tif (!labelRadius) {\n\t\t\tlabelRadius = radius * 0.9;\n\t\t}\n\n\t\tvar arc = d3.svg.arc().innerRadius(innerRadius).outerRadius(outerRadius).padRadius(padRadius).cornerRadius(cornerRadius);\n\n\t\tvar outerArc = d3.svg.arc().innerRadius(labelRadius).outerRadius(labelRadius);\n\n\t\tvar pieData = pie(values(data));\n\n\t\tvar translation = \"translate(\" + innerWidth / 2 + \", \" + innerHeight / 2 + \")\";\n\t\treturn React.createElement(\n\t\t\t\"div\",\n\t\t\tnull,\n\t\t\tReact.createElement(\n\t\t\t\tChart,\n\t\t\t\t{ height: height, width: width, margin: margin },\n\t\t\t\tReact.createElement(\n\t\t\t\t\t\"g\",\n\t\t\t\t\t{ transform: translation },\n\t\t\t\t\tReact.createElement(DataSet, {\n\t\t\t\t\t\twidth: innerWidth,\n\t\t\t\t\t\theight: innerHeight,\n\t\t\t\t\t\tcolorScale: colorScale,\n\t\t\t\t\t\tpie: pieData,\n\t\t\t\t\t\tarc: arc,\n\t\t\t\t\t\touterArc: outerArc,\n\t\t\t\t\t\tradius: radius,\n\t\t\t\t\t\tx: x,\n\t\t\t\t\t\ty: y,\n\t\t\t\t\t\tonMouseEnter: this.onMouseEnter,\n\t\t\t\t\t\tonMouseLeave: this.onMouseLeave\n\t\t\t\t\t})\n\t\t\t\t)\n\t\t\t),\n\t\t\tReact.createElement(Tooltip, {\n\t\t\t\thidden: this.state.tooltip.hidden,\n\t\t\t\ttop: this.state.tooltip.top,\n\t\t\t\tleft: this.state.tooltip.left,\n\t\t\t\thtml: this.state.tooltip.html })\n\t\t);\n\t}\n});\n\nmodule.exports = PieChart;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/PieChart.jsx\n ** module id = 2\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/PieChart.jsx?");

/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar Chart = __webpack_require__(9);\nvar Axis = __webpack_require__(10);\nvar Tooltip = __webpack_require__(12);\n\nvar DefaultPropsMixin = __webpack_require__(13);\nvar HeightWidthMixin = __webpack_require__(14);\nvar ArrayifyMixin = __webpack_require__(15);\nvar AccessorMixin = __webpack_require__(20);\nvar DefaultScalesMixin = __webpack_require__(18);\nvar TooltipMixin = __webpack_require__(19);\n\nvar DataSet = React.createClass({\n\tdisplayName: \"DataSet\",\n\n\tpropTypes: {\n\t\tdata: React.PropTypes.array.isRequired,\n\t\tsymbol: React.PropTypes.func.isRequired,\n\t\txScale: React.PropTypes.func.isRequired,\n\t\tyScale: React.PropTypes.func.isRequired,\n\t\tcolorScale: React.PropTypes.func.isRequired,\n\t\tonMouseEnter: React.PropTypes.func,\n\t\tonMouseLeave: React.PropTypes.func\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar data = _props.data;\n\t\tvar symbol = _props.symbol;\n\t\tvar xScale = _props.xScale;\n\t\tvar yScale = _props.yScale;\n\t\tvar colorScale = _props.colorScale;\n\t\tvar label = _props.label;\n\t\tvar values = _props.values;\n\t\tvar x = _props.x;\n\t\tvar y = _props.y;\n\t\tvar onMouseEnter = _props.onMouseEnter;\n\t\tvar onMouseLeave = _props.onMouseLeave;\n\n\t\tvar circles = data.map(function (stack) {\n\t\t\treturn values(stack).map(function (e, index) {\n\t\t\t\tvar translate = \"translate(\" + xScale(x(e)) + \", \" + yScale(y(e)) + \")\";\n\t\t\t\treturn React.createElement(\"path\", {\n\t\t\t\t\tkey: \"\" + label(stack) + \".\" + index,\n\t\t\t\t\tclassName: \"dot\",\n\t\t\t\t\td: symbol(),\n\t\t\t\t\ttransform: translate,\n\t\t\t\t\tfill: colorScale(label(stack)),\n\t\t\t\t\tonMouseOver: function (evt) {\n\t\t\t\t\t\tonMouseEnter(evt, e);\n\t\t\t\t\t},\n\t\t\t\t\tonMouseLeave: function (evt) {\n\t\t\t\t\t\tonMouseLeave(evt);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\t\t});\n\n\t\treturn React.createElement(\n\t\t\t\"g\",\n\t\t\tnull,\n\t\t\tcircles\n\t\t);\n\t}\n});\n\nvar ScatterPlot = React.createClass({\n\tdisplayName: \"ScatterPlot\",\n\n\tmixins: [DefaultPropsMixin, HeightWidthMixin, ArrayifyMixin, AccessorMixin, DefaultScalesMixin, TooltipMixin],\n\n\tpropTypes: {\n\t\trScale: React.PropTypes.func,\n\t\tshape: React.PropTypes.string\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\trScale: null,\n\t\t\tshape: \"circle\"\n\t\t};\n\t},\n\n\t_tooltipHtml: function _tooltipHtml(d, position) {\n\t\treturn this.props.tooltipHtml(this.props.x(d), this.props.y(d));\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar height = _props.height;\n\t\tvar width = _props.width;\n\t\tvar margin = _props.margin;\n\t\tvar colorScale = _props.colorScale;\n\t\tvar rScale = _props.rScale;\n\t\tvar shape = _props.shape;\n\t\tvar label = _props.label;\n\t\tvar values = _props.values;\n\t\tvar x = _props.x;\n\t\tvar y = _props.y;\n\t\tvar xAxis = _props.xAxis;\n\t\tvar yAxis = _props.yAxis;\n\t\tvar data = this._data;\n\t\tvar innerWidth = this._innerWidth;\n\t\tvar innerHeight = this._innerHeight;\n\t\tvar xScale = this._xScale;\n\t\tvar yScale = this._yScale;\n\t\tvar xIntercept = this._xIntercept;\n\t\tvar yIntercept = this._yIntercept;\n\n\t\tvar symbol = d3.svg.symbol().type(shape);\n\n\t\tif (rScale) {\n\t\t\tsymbol = symbol.size(rScale);\n\t\t}\n\n\t\treturn React.createElement(\n\t\t\t\"div\",\n\t\t\tnull,\n\t\t\tReact.createElement(\n\t\t\t\tChart,\n\t\t\t\t{ height: height, width: width, margin: margin },\n\t\t\t\tReact.createElement(Axis, _extends({\n\t\t\t\t\tclassName: \"x axis\",\n\t\t\t\t\torientation: \"bottom\",\n\t\t\t\t\tscale: xScale,\n\t\t\t\t\theight: innerHeight,\n\t\t\t\t\twidth: innerWidth,\n\t\t\t\t\tzero: yIntercept\n\t\t\t\t}, xAxis)),\n\t\t\t\tReact.createElement(Axis, _extends({\n\t\t\t\t\tclassName: \"y axis\",\n\t\t\t\t\torientation: \"left\",\n\t\t\t\t\tscale: yScale,\n\t\t\t\t\theight: innerHeight,\n\t\t\t\t\twidth: innerWidth,\n\t\t\t\t\tzero: xIntercept\n\t\t\t\t}, yAxis)),\n\t\t\t\tReact.createElement(DataSet, {\n\t\t\t\t\tdata: data,\n\t\t\t\t\txScale: xScale,\n\t\t\t\t\tyScale: yScale,\n\t\t\t\t\tcolorScale: colorScale,\n\t\t\t\t\tsymbol: symbol,\n\t\t\t\t\tlabel: label,\n\t\t\t\t\tvalues: values,\n\t\t\t\t\tx: x,\n\t\t\t\t\ty: y,\n\t\t\t\t\tonMouseEnter: this.onMouseEnter,\n\t\t\t\t\tonMouseLeave: this.onMouseLeave\n\t\t\t\t})\n\t\t\t),\n\t\t\tReact.createElement(Tooltip, {\n\t\t\t\thidden: this.state.tooltip.hidden,\n\t\t\t\ttop: this.state.tooltip.top,\n\t\t\t\tleft: this.state.tooltip.left,\n\t\t\t\thtml: this.state.tooltip.html })\n\t\t);\n\t}\n});\n\nmodule.exports = ScatterPlot;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/ScatterPlot.jsx\n ** module id = 3\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/ScatterPlot.jsx?");

/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar Chart = __webpack_require__(9);\nvar Axis = __webpack_require__(10);\nvar Path = __webpack_require__(21);\nvar Tooltip = __webpack_require__(12);\n\nvar DefaultPropsMixin = __webpack_require__(13);\nvar HeightWidthMixin = __webpack_require__(14);\nvar ArrayifyMixin = __webpack_require__(15);\nvar AccessorMixin = __webpack_require__(20);\nvar DefaultScalesMixin = __webpack_require__(18);\nvar TooltipMixin = __webpack_require__(19);\n\nvar DataSet = React.createClass({\n\tdisplayName: \"DataSet\",\n\n\tpropTypes: {\n\t\tdata: React.PropTypes.array.isRequired,\n\t\tline: React.PropTypes.func.isRequired,\n\t\tcolorScale: React.PropTypes.func.isRequired\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar width = _props.width;\n\t\tvar height = _props.height;\n\t\tvar data = _props.data;\n\t\tvar line = _props.line;\n\t\tvar strokeWidth = _props.strokeWidth;\n\t\tvar strokeLinecap = _props.strokeLinecap;\n\t\tvar strokeDasharray = _props.strokeDasharray;\n\t\tvar colorScale = _props.colorScale;\n\t\tvar values = _props.values;\n\t\tvar label = _props.label;\n\t\tvar onMouseEnter = _props.onMouseEnter;\n\t\tvar onMouseLeave = _props.onMouseLeave;\n\n\t\tvar lines = data.map(function (stack, index) {\n\t\t\treturn React.createElement(Path, {\n\t\t\t\tkey: \"\" + label(stack) + \".\" + index,\n\t\t\t\tclassName: \"line\",\n\t\t\t\td: line(values(stack)),\n\t\t\t\tstroke: colorScale(label(stack)),\n\t\t\t\tstrokeWidth: typeof strokeWidth === \"function\" ? strokeWidth(label(stack)) : strokeWidth,\n\t\t\t\tstrokeLinecap: typeof strokeLinecap === \"function\" ? strokeLinecap(label(stack)) : strokeLinecap,\n\t\t\t\tstrokeDasharray: typeof strokeDasharray === \"function\" ? strokeDasharray(label(stack)) : strokeDasharray,\n\t\t\t\tdata: values(stack),\n\t\t\t\tonMouseEnter: onMouseEnter,\n\t\t\t\tonMouseLeave: onMouseLeave,\n\t\t\t\tstyle: { clipPath: \"url(#lineClip)\" }\n\t\t\t});\n\t\t});\n\n\t\t/*\n   The <rect> below is needed in case we want to show the tooltip no matter where on the chart the mouse is.\n   Not sure if this should be used.\n   */\n\t\tvar rect = React.renderToString(React.createElement(\"rect\", { width: width, height: height }));\n\t\treturn React.createElement(\n\t\t\t\"g\",\n\t\t\tnull,\n\t\t\tReact.createElement(\"g\", { dangerouslySetInnerHTML: { __html: \"<defs><clipPath id=\\\"lineClip\\\">\" + rect } }),\n\t\t\tlines,\n\t\t\tReact.createElement(\"rect\", { width: width, height: height, fill: \"none\", stroke: \"none\", style: { pointerEvents: \"all\" },\n\t\t\t\tonMouseMove: function (evt) {\n\t\t\t\t\tonMouseEnter(evt, data);\n\t\t\t\t},\n\t\t\t\tonMouseLeave: function (evt) {\n\t\t\t\t\tonMouseLeave(evt);\n\t\t\t\t}\n\t\t\t})\n\t\t);\n\t}\n});\n\nvar LineChart = React.createClass({\n\tdisplayName: \"LineChart\",\n\n\tmixins: [DefaultPropsMixin, HeightWidthMixin, ArrayifyMixin, AccessorMixin, DefaultScalesMixin, TooltipMixin],\n\n\tpropTypes: {\n\t\tinterpolate: React.PropTypes.string\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\tinterpolate: \"linear\",\n\t\t\tshape: \"circle\",\n\t\t\tshapeColor: null\n\t\t};\n\t},\n\n\t/*\n  The code below supports finding the data values for the line closest to the mouse cursor.\n  Since it gets all events from the Rect overlaying the Chart the tooltip gets shown everywhere.\n  For now I don't want to use this method.\n  */\n\t_tooltipHtml: function _tooltipHtml(data, position) {\n\t\tvar _props = this.props;\n\t\tvar x = _props.x;\n\t\tvar y0 = _props.y0;\n\t\tvar y = _props.y;\n\t\tvar values = _props.values;\n\t\tvar label = _props.label;\n\t\tvar xScale = this._xScale;\n\t\tvar yScale = this._yScale;\n\n\t\tvar xValueCursor = xScale.invert(position[0]);\n\t\tvar yValueCursor = yScale.invert(position[1]);\n\n\t\tvar xBisector = d3.bisector(function (e) {\n\t\t\treturn x(e);\n\t\t}).left;\n\t\tvar valuesAtX = data.map(function (stack) {\n\t\t\tvar idx = xBisector(values(stack), xValueCursor);\n\n\t\t\tvar indexRight = idx === values(stack).length ? idx - 1 : idx;\n\t\t\tvar valueRight = x(values(stack)[indexRight]);\n\n\t\t\tvar indexLeft = idx === 0 ? idx : idx - 1;\n\t\t\tvar valueLeft = x(values(stack)[indexLeft]);\n\n\t\t\tvar index = undefined;\n\t\t\tif (Math.abs(xValueCursor - valueRight) < Math.abs(xValueCursor - valueLeft)) {\n\t\t\t\tindex = indexRight;\n\t\t\t} else {\n\t\t\t\tindex = indexLeft;\n\t\t\t}\n\n\t\t\treturn { label: label(stack), value: values(stack)[index] };\n\t\t});\n\n\t\tvaluesAtX.sort(function (a, b) {\n\t\t\treturn y(a.value) - y(b.value);\n\t\t});\n\n\t\tvar yBisector = d3.bisector(function (e) {\n\t\t\treturn y(e.value);\n\t\t}).left;\n\t\tvar yIndex = yBisector(valuesAtX, yValueCursor);\n\n\t\tvar yIndexRight = yIndex === valuesAtX.length ? yIndex - 1 : yIndex;\n\t\tvar yIndexLeft = yIndex === 0 ? yIndex : yIndex - 1;\n\n\t\tvar yValueRight = y(valuesAtX[yIndexRight].value);\n\t\tvar yValueLeft = y(valuesAtX[yIndexLeft].value);\n\n\t\tvar index = undefined;\n\t\tif (Math.abs(yValueCursor - yValueRight) < Math.abs(yValueCursor - yValueLeft)) {\n\t\t\tindex = yIndexRight;\n\t\t} else {\n\t\t\tindex = yIndexLeft;\n\t\t}\n\n\t\tthis._tooltipData = valuesAtX[index];\n\n\t\treturn this.props.tooltipHtml(valuesAtX[index].label, valuesAtX[index].value);\n\t},\n\n\t/*\n _tooltipHtml(data, position) {\n \tlet {x, y0, y, values, label} = this.props;\n \tlet [xScale, yScale] = [this._xScale, this._yScale];\n \t\tlet xValueCursor = xScale.invert(position[0]);\n \tlet yValueCursor = yScale.invert(position[1]);\n \t\tlet xBisector = d3.bisector(e => { return x(e); }).left;\n \tlet xIndex = xBisector(data, xScale.invert(position[0]));\n \t\tlet indexRight = xIndex == data.length ? xIndex - 1 : xIndex;\n \tlet valueRight = x(data[indexRight]);\n \t\tlet indexLeft = xIndex == 0 ? xIndex : xIndex - 1;\n \tlet valueLeft = x(data[indexLeft]);\n \t\tlet index;\n \tif (Math.abs(xValueCursor - valueRight) < Math.abs(xValueCursor - valueLeft)) {\n \t\tindex = indexRight;\n \t} else {\n \t\tindex = indexLeft;\n \t}\n \t\tlet yValue = y(data[index]);\n \tlet cursorValue = d3.round(yScale.invert(position[1]), 2);\n \t\treturn this.props.tooltipHtml(yValue, cursorValue);\n },\n  */\n\n\t/*\n \t\t stroke,\n \t\t strokeWidth,\n \t\t strokeLinecap,\n \t\t strokeDasharray,\n  */\n\trender: function render() {\n\t\tvar _this = this;\n\n\t\tvar _props = this.props;\n\t\tvar height = _props.height;\n\t\tvar width = _props.width;\n\t\tvar margin = _props.margin;\n\t\tvar colorScale = _props.colorScale;\n\t\tvar interpolate = _props.interpolate;\n\t\tvar stroke = _props.stroke;\n\t\tvar values = _props.values;\n\t\tvar label = _props.label;\n\t\tvar x = _props.x;\n\t\tvar y = _props.y;\n\t\tvar xAxis = _props.xAxis;\n\t\tvar yAxis = _props.yAxis;\n\t\tvar shape = _props.shape;\n\t\tvar shapeColor = _props.shapeColor;\n\t\tvar data = this._data;\n\t\tvar innerWidth = this._innerWidth;\n\t\tvar innerHeight = this._innerHeight;\n\t\tvar xScale = this._xScale;\n\t\tvar yScale = this._yScale;\n\t\tvar xIntercept = this._xIntercept;\n\t\tvar yIntercept = this._yIntercept;\n\n\t\tvar line = d3.svg.line().x(function (e) {\n\t\t\treturn xScale(x(e));\n\t\t}).y(function (e) {\n\t\t\treturn yScale(y(e));\n\t\t}).interpolate(interpolate);\n\n\t\tvar tooltipSymbol = undefined;\n\t\tif (!this.state.tooltip.hidden) {\n\t\t\tvar symbol = d3.svg.symbol().type(shape);\n\t\t\tvar symbolColor = shapeColor ? shapeColor : colorScale(this._tooltipData.label);\n\n\t\t\tvar translate = this._tooltipData ? \"translate(\" + xScale(x(this._tooltipData.value)) + \", \" + yScale(y(this._tooltipData.value)) + \")\" : \"\";\n\t\t\ttooltipSymbol = this.state.tooltip.hidden ? null : React.createElement(\"path\", {\n\t\t\t\tclassName: \"dot\",\n\t\t\t\td: symbol(),\n\t\t\t\ttransform: translate,\n\t\t\t\tfill: symbolColor,\n\t\t\t\tonMouseEnter: function (evt) {\n\t\t\t\t\t_this.onMouseEnter(evt, data);\n\t\t\t\t},\n\t\t\t\tonMouseLeave: function (evt) {\n\t\t\t\t\t_this.onMouseLeave(evt);\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\n\t\treturn React.createElement(\n\t\t\t\"div\",\n\t\t\tnull,\n\t\t\tReact.createElement(\n\t\t\t\tChart,\n\t\t\t\t{ height: height, width: width, margin: margin },\n\t\t\t\tReact.createElement(DataSet, _extends({\n\t\t\t\t\theight: innerHeight,\n\t\t\t\t\twidth: innerWidth,\n\t\t\t\t\tdata: data,\n\t\t\t\t\tline: line,\n\t\t\t\t\tcolorScale: colorScale,\n\t\t\t\t\tvalues: values,\n\t\t\t\t\tlabel: label,\n\t\t\t\t\tonMouseEnter: this.onMouseEnter,\n\t\t\t\t\tonMouseLeave: this.onMouseLeave\n\t\t\t\t}, stroke)),\n\t\t\t\tReact.createElement(Axis, _extends({\n\t\t\t\t\tclassName: \"x axis\",\n\t\t\t\t\torientation: \"bottom\",\n\t\t\t\t\tscale: xScale,\n\t\t\t\t\theight: innerHeight,\n\t\t\t\t\twidth: innerWidth,\n\t\t\t\t\tzero: yIntercept\n\t\t\t\t}, xAxis)),\n\t\t\t\tReact.createElement(Axis, _extends({\n\t\t\t\t\tclassName: \"y axis\",\n\t\t\t\t\torientation: \"left\",\n\t\t\t\t\tscale: yScale,\n\t\t\t\t\theight: innerHeight,\n\t\t\t\t\twidth: innerWidth,\n\t\t\t\t\tzero: xIntercept\n\t\t\t\t}, yAxis)),\n\t\t\t\ttooltipSymbol\n\t\t\t),\n\t\t\tReact.createElement(Tooltip, {\n\t\t\t\thidden: this.state.tooltip.hidden,\n\t\t\t\ttop: this.state.tooltip.top,\n\t\t\t\tleft: this.state.tooltip.left,\n\t\t\t\thtml: this.state.tooltip.html\n\t\t\t})\n\t\t);\n\t}\n});\n\nmodule.exports = LineChart;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/LineChart.jsx\n ** module id = 4\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/LineChart.jsx?");

/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar Chart = __webpack_require__(9);\nvar Axis = __webpack_require__(10);\nvar Path = __webpack_require__(21);\nvar Tooltip = __webpack_require__(12);\n\nvar DefaultPropsMixin = __webpack_require__(13);\nvar HeightWidthMixin = __webpack_require__(14);\nvar ArrayifyMixin = __webpack_require__(15);\nvar StackAccessorMixin = __webpack_require__(16);\nvar StackDataMixin = __webpack_require__(17);\nvar DefaultScalesMixin = __webpack_require__(18);\nvar TooltipMixin = __webpack_require__(19);\n\nvar DataSet = React.createClass({\n\tdisplayName: \"DataSet\",\n\n\tpropTypes: {\n\t\tdata: React.PropTypes.array.isRequired,\n\t\tarea: React.PropTypes.func.isRequired,\n\t\tline: React.PropTypes.func.isRequired,\n\t\tcolorScale: React.PropTypes.func.isRequired,\n\t\tstroke: React.PropTypes.func.isRequired\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar data = _props.data;\n\t\tvar area = _props.area;\n\t\tvar line = _props.line;\n\t\tvar colorScale = _props.colorScale;\n\t\tvar stroke = _props.stroke;\n\t\tvar values = _props.values;\n\t\tvar label = _props.label;\n\t\tvar onMouseEnter = _props.onMouseEnter;\n\t\tvar onMouseLeave = _props.onMouseLeave;\n\n\t\tvar areas = data.map(function (stack, index) {\n\t\t\treturn React.createElement(Path, {\n\t\t\t\tkey: \"\" + label(stack) + \".\" + index,\n\t\t\t\tclassName: \"area\",\n\t\t\t\tstroke: \"none\",\n\t\t\t\tfill: colorScale(label(stack)),\n\t\t\t\td: area(values(stack)),\n\t\t\t\tonMouseEnter: onMouseEnter,\n\t\t\t\tonMouseLeave: onMouseLeave,\n\t\t\t\tdata: data\n\t\t\t});\n\t\t});\n\n\t\tvar lines = data.map(function (stack) {\n\t\t\treturn React.createElement(Path, {\n\t\t\t\tclassName: \"line\",\n\t\t\t\td: line(values(stack)),\n\t\t\t\tstroke: stroke(label(stack))\n\t\t\t});\n\t\t});\n\n\t\treturn React.createElement(\n\t\t\t\"g\",\n\t\t\tnull,\n\t\t\tareas\n\t\t);\n\t}\n});\n\nvar AreaChart = React.createClass({\n\tdisplayName: \"AreaChart\",\n\n\tmixins: [DefaultPropsMixin, HeightWidthMixin, ArrayifyMixin, StackAccessorMixin, StackDataMixin, DefaultScalesMixin, TooltipMixin],\n\n\tpropTypes: {\n\t\tinterpolate: React.PropTypes.string,\n\t\tstroke: React.PropTypes.func\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\tinterpolate: \"linear\",\n\t\t\tstroke: d3.scale.category20()\n\t\t};\n\t},\n\n\t_tooltipHtml: function _tooltipHtml(d, position) {\n\t\tvar _props = this.props;\n\t\tvar x = _props.x;\n\t\tvar y0 = _props.y0;\n\t\tvar y = _props.y;\n\t\tvar values = _props.values;\n\t\tvar label = _props.label;\n\t\tvar xScale = this._xScale;\n\t\tvar yScale = this._yScale;\n\n\t\tvar xValueCursor = xScale.invert(position[0]);\n\n\t\tvar xBisector = d3.bisector(function (e) {\n\t\t\treturn x(e);\n\t\t}).right;\n\t\tvar xIndex = xBisector(values(d[0]), xScale.invert(position[0]));\n\t\txIndex = xIndex == values(d[0]).length ? xIndex - 1 : xIndex;\n\n\t\tvar xIndexRight = xIndex == values(d[0]).length ? xIndex - 1 : xIndex;\n\t\tvar xValueRight = x(values(d[0])[xIndexRight]);\n\n\t\tvar xIndexLeft = xIndex == 0 ? xIndex : xIndex - 1;\n\t\tvar xValueLeft = x(values(d[0])[xIndexLeft]);\n\n\t\tif (Math.abs(xValueCursor - xValueRight) < Math.abs(xValueCursor - xValueLeft)) {\n\t\t\txIndex = xIndexRight;\n\t\t} else {\n\t\t\txIndex = xIndexLeft;\n\t\t}\n\n\t\tvar yValueCursor = yScale.invert(position[1]);\n\n\t\tvar yBisector = d3.bisector(function (e) {\n\t\t\treturn y0(values(e)[xIndex]) + y(values(e)[xIndex]);\n\t\t}).left;\n\t\tvar yIndex = yBisector(d, yValueCursor);\n\t\tyIndex = yIndex == d.length ? yIndex - 1 : yIndex;\n\n\t\tvar yValue = y(values(d[yIndex])[xIndex]);\n\t\tvar yValueCumulative = y0(values(d[d.length - 1])[xIndex]) + y(values(d[d.length - 1])[xIndex]);\n\n\t\treturn this.props.tooltipHtml(yValue, yValueCumulative);\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar height = _props.height;\n\t\tvar width = _props.width;\n\t\tvar margin = _props.margin;\n\t\tvar colorScale = _props.colorScale;\n\t\tvar interpolate = _props.interpolate;\n\t\tvar stroke = _props.stroke;\n\t\tvar offset = _props.offset;\n\t\tvar values = _props.values;\n\t\tvar label = _props.label;\n\t\tvar x = _props.x;\n\t\tvar y = _props.y;\n\t\tvar y0 = _props.y0;\n\t\tvar xAxis = _props.xAxis;\n\t\tvar yAxis = _props.yAxis;\n\t\tvar data = this._data;\n\t\tvar innerWidth = this._innerWidth;\n\t\tvar innerHeight = this._innerHeight;\n\t\tvar xScale = this._xScale;\n\t\tvar yScale = this._yScale;\n\t\tvar xIntercept = this._xIntercept;\n\t\tvar yIntercept = this._yIntercept;\n\n\t\tvar line = d3.svg.line().x(function (e) {\n\t\t\treturn xScale(x(e));\n\t\t}).y(function (e) {\n\t\t\treturn yScale(y0(e) + y(e));\n\t\t}).interpolate(interpolate);\n\n\t\tvar area = d3.svg.area().x(function (e) {\n\t\t\treturn xScale(x(e));\n\t\t}).y0(function (e) {\n\t\t\treturn yScale(yScale.domain()[0] + y0(e));\n\t\t}).y1(function (e) {\n\t\t\treturn yScale(y0(e) + y(e));\n\t\t}).interpolate(interpolate);\n\n\t\treturn React.createElement(\n\t\t\t\"div\",\n\t\t\tnull,\n\t\t\tReact.createElement(\n\t\t\t\tChart,\n\t\t\t\t{ height: height, width: width, margin: margin },\n\t\t\t\tReact.createElement(DataSet, {\n\t\t\t\t\tdata: data,\n\t\t\t\t\tline: line,\n\t\t\t\t\tarea: area,\n\t\t\t\t\tcolorScale: colorScale,\n\t\t\t\t\tstroke: stroke,\n\t\t\t\t\tlabel: label,\n\t\t\t\t\tvalues: values,\n\t\t\t\t\tonMouseEnter: this.onMouseEnter,\n\t\t\t\t\tonMouseLeave: this.onMouseLeave\n\t\t\t\t}),\n\t\t\t\tReact.createElement(Axis, _extends({\n\t\t\t\t\tclassName: \"x axis\",\n\t\t\t\t\torientation: \"bottom\",\n\t\t\t\t\tscale: xScale,\n\t\t\t\t\theight: innerHeight,\n\t\t\t\t\twidth: innerWidth\n\t\t\t\t}, xAxis)),\n\t\t\t\tReact.createElement(Axis, _extends({\n\t\t\t\t\tclassName: \"y axis\",\n\t\t\t\t\torientation: \"left\",\n\t\t\t\t\tscale: yScale,\n\t\t\t\t\theight: innerHeight,\n\t\t\t\t\twidth: innerWidth\n\t\t\t\t}, yAxis))\n\t\t\t),\n\t\t\tReact.createElement(Tooltip, {\n\t\t\t\thidden: this.state.tooltip.hidden,\n\t\t\t\ttop: this.state.tooltip.top,\n\t\t\t\tleft: this.state.tooltip.left,\n\t\t\t\thtml: this.state.tooltip.html })\n\t\t);\n\t}\n});\n\nmodule.exports = AreaChart;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/AreaChart.jsx\n ** module id = 5\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/AreaChart.jsx?");

/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar Chart = __webpack_require__(9);\nvar Axis = __webpack_require__(10);\n\nvar HeightWidthMixin = __webpack_require__(14);\n\n// Adapted for React from https://github.com/mbostock/d3/blob/master/src/svg/brush.js\n// TODO: Add D3 License\nvar _d3_svg_brushCursor = {\n\tn: \"ns-resize\",\n\te: \"ew-resize\",\n\ts: \"ns-resize\",\n\tw: \"ew-resize\",\n\tnw: \"nwse-resize\",\n\tne: \"nesw-resize\",\n\tse: \"nwse-resize\",\n\tsw: \"nesw-resize\"\n};\n\nvar _d3_svg_brushResizes = [[\"n\", \"e\", \"s\", \"w\", \"nw\", \"ne\", \"se\", \"sw\"], [\"e\", \"w\"], [\"n\", \"s\"], []];\n\n// TODO: add y axis support\nvar Brush = React.createClass({\n\tdisplayName: \"Brush\",\n\n\tmixins: [HeightWidthMixin],\n\n\tgetInitialState: function getInitialState() {\n\t\treturn {\n\t\t\tresizers: _d3_svg_brushResizes[0],\n\t\t\txExtent: [0, 0],\n\t\t\tyExtent: [0, 0],\n\t\t\txExtentDomain: undefined,\n\t\t\tyExtentDomain: undefined\n\t\t};\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\txScale: null,\n\t\t\tyScale: null\n\t\t};\n\t},\n\n\tcomponentWillMount: function componentWillMount() {\n\t\tthis._extent(this.props.extent);\n\n\t\tthis.setState({\n\t\t\tresizers: _d3_svg_brushResizes[!this.props.xScale << 1 | !this.props.yScale]\n\t\t});\n\t},\n\n\tcomponentWillReceiveProps: function componentWillReceiveProps(nextProps) {\n\t\t// when <Brush/> is used inside a component\n\t\t// we should not set the extent prop on every redraw of the parent, because it will\n\t\t// stop us from actually setting the extent with the brush.\n\t\tif (nextProps.xScale !== this.props.xScale) {\n\t\t\tthis._extent(nextProps.extent, nextProps.xScale);\n\t\t\tthis.setState({\n\t\t\t\tresizers: _d3_svg_brushResizes[!this.props.xScale << 1 | !this.props.yScale]\n\t\t\t});\n\t\t}\n\t},\n\n\trender: function render() {\n\t\tvar _this = this;\n\n\t\t// TODO: remove this.state this.props\n\t\tvar xRange = this.props.xScale ? this._d3_scaleRange(this.props.xScale) : null;\n\t\tvar yRange = this.props.yScale ? this._d3_scaleRange(this.props.yScale) : null;\n\n\t\tvar background = React.createElement(\"rect\", {\n\t\t\tclassName: \"background\",\n\t\t\tstyle: { visibility: \"visible\", cursor: \"crosshair\" },\n\t\t\tx: xRange ? xRange[0] : \"\",\n\t\t\twidth: xRange ? xRange[1] - xRange[0] : \"\",\n\t\t\ty: yRange ? yRange[0] : \"\",\n\t\t\theight: yRange ? yRange[1] - yRange[0] : this._innerHeight,\n\t\t\tonMouseDown: this._onMouseDownBackground\n\t\t});\n\n\t\t// TODO: it seems like actually we can have both x and y scales at the same time. need to find example.\n\n\t\tvar extent = undefined;\n\t\tif (this.props.xScale) {\n\t\t\textent = React.createElement(\"rect\", {\n\t\t\t\tclassName: \"extent\",\n\t\t\t\tstyle: { cursor: \"move\" },\n\t\t\t\tx: this.state.xExtent[0],\n\t\t\t\twidth: this.state.xExtent[1] - this.state.xExtent[0],\n\t\t\t\theight: this._innerHeight,\n\t\t\t\tonMouseDown: this._onMouseDownExtent\n\t\t\t});\n\t\t}\n\n\t\tvar resizers = this.state.resizers.map(function (e) {\n\t\t\treturn React.createElement(\n\t\t\t\t\"g\",\n\t\t\t\t{\n\t\t\t\t\tkey: e,\n\t\t\t\t\tclassName: \"resize \" + e,\n\t\t\t\t\tstyle: { cursor: _d3_svg_brushCursor[e] },\n\t\t\t\t\ttransform: \"translate(\" + _this.state.xExtent[+/e$/.test(e)] + \", \" + _this.state.yExtent[+/^s/.test(e)] + \")\",\n\t\t\t\t\tonMouseDown: function (event) {\n\t\t\t\t\t\t_this._onMouseDownResizer(event, e);\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tReact.createElement(\"rect\", {\n\t\t\t\t\tx: /[ew]$/.test(e) ? -3 : null,\n\t\t\t\t\ty: /^[ns]/.test(e) ? -3 : null,\n\t\t\t\t\twidth: \"6\",\n\t\t\t\t\theight: _this._innerHeight,\n\t\t\t\t\tstyle: { visibility: \"hidden\", display: _this._empty() ? \"none\" : null }\n\t\t\t\t})\n\t\t\t);\n\t\t});\n\n\t\treturn React.createElement(\n\t\t\t\"div\",\n\t\t\tnull,\n\t\t\tReact.createElement(\n\t\t\t\tChart,\n\t\t\t\t{ height: this.props.height, width: this.props.width, margin: this.props.margin },\n\t\t\t\tReact.createElement(\n\t\t\t\t\t\"g\",\n\t\t\t\t\t{\n\t\t\t\t\t\tstyle: { pointerEvents: \"all\" },\n\t\t\t\t\t\tonMouseUp: this._onMouseUp,\n\t\t\t\t\t\tonMouseMove: this._onMouseMove\n\t\t\t\t\t},\n\t\t\t\t\tbackground,\n\t\t\t\t\textent,\n\t\t\t\t\tresizers\n\t\t\t\t),\n\t\t\t\tReact.createElement(Axis, _extends({\n\t\t\t\t\tclassName: \"x axis\",\n\t\t\t\t\torientation: \"bottom\",\n\t\t\t\t\tscale: this.props.xScale,\n\t\t\t\t\theight: this._innerHeight,\n\t\t\t\t\twidth: this._innerWidth\n\t\t\t\t}, this.props.xAxis))\n\t\t\t)\n\t\t);\n\t},\n\n\t// TODO: Code duplicated in TooltipMixin.jsx, move outside.\n\t_getMousePosition: function _getMousePosition(e) {\n\t\tvar svg = this.getDOMNode().getElementsByTagName(\"svg\")[0];\n\t\tvar position = undefined;\n\t\tif (svg.createSVGPoint) {\n\t\t\tvar point = svg.createSVGPoint();\n\t\t\tpoint.x = e.clientX, point.y = e.clientY;\n\t\t\tpoint = point.matrixTransform(svg.getScreenCTM().inverse());\n\t\t\tposition = [point.x - this.props.margin.left, point.y - this.props.margin.top];\n\t\t} else {\n\t\t\tvar rect = svg.getBoundingClientRect();\n\t\t\tposition = [e.clientX - rect.left - svg.clientLeft - this.props.margin.left, e.clientY - rect.top - svg.clientTop - this.props.margin.left];\n\t\t}\n\n\t\treturn position;\n\t},\n\n\t_onMouseDownBackground: function _onMouseDownBackground(e) {\n\t\te.preventDefault();\n\t\tvar range = this._d3_scaleRange(this.props.xScale);\n\t\tvar point = this._getMousePosition(e);\n\n\t\tvar size = this.state.xExtent[1] - this.state.xExtent[0];\n\n\t\trange[1] -= size;\n\n\t\tvar min = Math.max(range[0], Math.min(range[1], point[0]));\n\t\tthis.setState({ xExtent: [min, min + size] });\n\t},\n\n\t// TODO: use constants instead of strings\n\t_onMouseDownExtent: function _onMouseDownExtent(e) {\n\t\te.preventDefault();\n\t\tthis._mouseMode = \"drag\";\n\n\t\tvar point = this._getMousePosition(e);\n\t\tvar distanceFromBorder = point[0] - this.state.xExtent[0];\n\n\t\tthis._startPosition = distanceFromBorder;\n\t},\n\n\t_onMouseDownResizer: function _onMouseDownResizer(e, dir) {\n\t\te.preventDefault();\n\t\tthis._mouseMode = \"resize\";\n\t\tthis._resizeDir = dir;\n\t},\n\n\t_onDrag: function _onDrag(e) {\n\t\tvar range = this._d3_scaleRange(this.props.xScale);\n\t\tvar point = this._getMousePosition(e);\n\n\t\tvar size = this.state.xExtent[1] - this.state.xExtent[0];\n\n\t\trange[1] -= size;\n\n\t\tvar min = Math.max(range[0], Math.min(range[1], point[0] - this._startPosition));\n\n\t\tthis.setState({ xExtent: [min, min + size], xExtentDomain: null });\n\t},\n\n\t_onResize: function _onResize(e) {\n\t\tvar range = this._d3_scaleRange(this.props.xScale);\n\t\tvar point = this._getMousePosition(e);\n\t\t// Don't let the extent go outside of its limits\n\t\t// TODO: support clamp argument of D3\n\t\tvar min = Math.max(range[0], Math.min(range[1], point[0]));\n\n\t\tif (this._resizeDir == \"w\") {\n\t\t\tif (min > this.state.xExtent[1]) {\n\t\t\t\tthis.setState({ xExtent: [this.state.xExtent[1], min], xExtentDomain: null });\n\t\t\t\tthis._resizeDir = \"e\";\n\t\t\t} else {\n\t\t\t\tthis.setState({ xExtent: [min, this.state.xExtent[1]], xExtentDomain: null });\n\t\t\t}\n\t\t} else if (this._resizeDir == \"e\") {\n\t\t\tif (min < this.state.xExtent[0]) {\n\t\t\t\tthis.setState({ xExtent: [min, this.state.xExtent[0]], xExtentDomain: null });\n\t\t\t\tthis._resizeDir = \"w\";\n\t\t\t} else {\n\t\t\t\tthis.setState({ xExtent: [this.state.xExtent[0], min], xExtentDomain: null });\n\t\t\t}\n\t\t}\n\t},\n\n\t_onMouseMove: function _onMouseMove(e) {\n\t\te.preventDefault();\n\n\t\tif (this._mouseMode == \"resize\") {\n\t\t\tthis._onResize(e);\n\t\t} else if (this._mouseMode == \"drag\") {\n\t\t\tthis._onDrag(e);\n\t\t}\n\t},\n\n\t_onMouseUp: function _onMouseUp(e) {\n\t\te.preventDefault();\n\n\t\tthis._mouseMode = null;\n\n\t\tthis.props.onChange(this._extent());\n\t},\n\n\t_extent: function _extent(z, xScale) {\n\t\tvar x = xScale || this.props.xScale;\n\t\tvar y = this.props.yScale;\n\t\tvar _state = this.state;\n\t\tvar xExtent = _state.xExtent;\n\t\tvar yExtent = _state.yExtent;\n\t\tvar xExtentDomain = _state.xExtentDomain;\n\t\tvar yExtentDomain = _state.yExtentDomain;\n\n\t\tvar x0, x1, y0, y1, t;\n\n\t\t// Invert the pixel extent to data-space.\n\t\tif (!arguments.length) {\n\t\t\tif (x) {\n\t\t\t\tif (xExtentDomain) {\n\t\t\t\t\tx0 = xExtentDomain[0], x1 = xExtentDomain[1];\n\t\t\t\t} else {\n\t\t\t\t\tx0 = xExtent[0], x1 = xExtent[1];\n\t\t\t\t\tif (x.invert) x0 = x.invert(x0), x1 = x.invert(x1);\n\t\t\t\t\tif (x1 < x0) t = x0, x0 = x1, x1 = t;\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (y) {\n\t\t\t\tif (yExtentDomain) {\n\t\t\t\t\ty0 = yExtentDomain[0], y1 = yExtentDomain[1];\n\t\t\t\t} else {\n\t\t\t\t\ty0 = yExtent[0], y1 = yExtent[1];\n\t\t\t\t\tif (y.invert) y0 = y.invert(y0), y1 = y.invert(y1);\n\t\t\t\t\tif (y1 < y0) t = y0, y0 = y1, y1 = t;\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn x && y ? [[x0, y0], [x1, y1]] : x ? [x0, x1] : y && [y0, y1];\n\t\t}\n\n\t\t// Scale the data-space extent to pixels.\n\t\tif (x) {\n\t\t\tx0 = z[0], x1 = z[1];\n\t\t\tif (y) x0 = x0[0], x1 = x1[0];\n\t\t\txExtentDomain = [x0, x1];\n\t\t\tif (x.invert) x0 = x(x0), x1 = x(x1);\n\t\t\tif (x1 < x0) t = x0, x0 = x1, x1 = t;\n\t\t\tif (x0 != xExtent[0] || x1 != xExtent[1]) xExtent = [x0, x1]; // copy-on-write\n\t\t}\n\t\tif (y) {\n\t\t\ty0 = z[0], y1 = z[1];\n\t\t\tif (x) y0 = y0[1], y1 = y1[1];\n\t\t\tyExtentDomain = [y0, y1];\n\t\t\tif (y.invert) y0 = y(y0), y1 = y(y1);\n\t\t\tif (y1 < y0) t = y0, y0 = y1, y1 = t;\n\t\t\tif (y0 != yExtent[0] || y1 != yExtent[1]) yExtent = [y0, y1]; // copy-on-write\n\t\t}\n\n\t\tthis.setState({ xExtent: xExtent, yExtent: yExtent, xExtentDomain: xExtentDomain, yExtentDomain: yExtentDomain });\n\t},\n\n\t_empty: function _empty() {\n\t\treturn !!this.props.xScale && this.state.xExtent[0] == this.state.xExtent[1] || !!this.props.yScale && this.state.yExtent[0] == this.state.yExtent[1];\n\t},\n\n\t// TODO: Code duplicated in Axis.jsx, move outside.\n\t_d3_scaleExtent: function _d3_scaleExtent(domain) {\n\t\tvar start = domain[0],\n\t\t    stop = domain[domain.length - 1];\n\t\treturn start < stop ? [start, stop] : [stop, start];\n\t},\n\n\t_d3_scaleRange: function _d3_scaleRange(scale) {\n\t\treturn scale.rangeExtent ? scale.rangeExtent() : this._d3_scaleExtent(scale.range());\n\t}\n});\n\nmodule.exports = Brush;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/Brush.jsx\n ** module id = 6\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/Brush.jsx?");

/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	eval("module.exports = __WEBPACK_EXTERNAL_MODULE_7__;\n\n/*****************\n ** WEBPACK FOOTER\n ** external \"React\"\n ** module id = 7\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///external_%22React%22?");

/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	eval("module.exports = __WEBPACK_EXTERNAL_MODULE_8__;\n\n/*****************\n ** WEBPACK FOOTER\n ** external \"d3\"\n ** module id = 8\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///external_%22d3%22?");

/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar React = __webpack_require__(7);\n\nvar Chart = React.createClass({\n\tdisplayName: \"Chart\",\n\n\tpropTypes: {\n\t\theight: React.PropTypes.number.isRequired,\n\t\twidth: React.PropTypes.number.isRequired,\n\t\tmargin: React.PropTypes.shape({\n\t\t\ttop: React.PropTypes.number,\n\t\t\tbottom: React.PropTypes.number,\n\t\t\tleft: React.PropTypes.number,\n\t\t\tright: React.PropTypes.number\n\t\t}).isRequired\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar width = _props.width;\n\t\tvar height = _props.height;\n\t\tvar margin = _props.margin;\n\t\tvar children = _props.children;\n\n\t\treturn React.createElement(\n\t\t\t\"svg\",\n\t\t\t{ ref: \"svg\", width: width, height: height },\n\t\t\tReact.createElement(\n\t\t\t\t\"g\",\n\t\t\t\t{ transform: \"translate(\" + margin.left + \", \" + margin.top + \")\" },\n\t\t\t\tchildren\n\t\t\t)\n\t\t);\n\t}\n});\n\nmodule.exports = Chart;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/Chart.jsx\n ** module id = 9\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/Chart.jsx?");

/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar Axis = React.createClass({\n\tdisplayName: \"Axis\",\n\n\tpropTypes: {\n\t\ttickArguments: React.PropTypes.array,\n\t\ttickValues: React.PropTypes.array,\n\t\ttickFormat: React.PropTypes.func,\n\t\tinnerTickSize: React.PropTypes.number,\n\t\ttickPadding: React.PropTypes.number,\n\t\touterTickSize: React.PropTypes.number,\n\t\tscale: React.PropTypes.func.isRequired,\n\t\tclassName: React.PropTypes.string,\n\t\tzero: React.PropTypes.number,\n\t\torientation: React.PropTypes.oneOf([\"top\", \"bottom\", \"left\", \"right\"]).isRequired,\n\t\tlabel: React.PropTypes.string\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\ttickArguments: [10],\n\t\t\ttickValues: null,\n\t\t\ttickFormat: null,\n\t\t\tinnerTickSize: 6,\n\t\t\ttickPadding: 3,\n\t\t\touterTickSize: 6,\n\t\t\tclassName: \"axis\",\n\t\t\tzero: 0,\n\t\t\tlabel: \"\"\n\t\t};\n\t},\n\n\t_getTranslateString: function _getTranslateString() {\n\t\tvar _props = this.props;\n\t\tvar orientation = _props.orientation;\n\t\tvar height = _props.height;\n\t\tvar width = _props.width;\n\t\tvar zero = _props.zero;\n\n\t\tif (orientation === \"top\") {\n\t\t\treturn \"translate(0, \" + zero + \")\";\n\t\t} else if (orientation === \"bottom\") {\n\t\t\treturn \"translate(0, \" + (zero == 0 ? height : zero) + \")\";\n\t\t} else if (orientation === \"left\") {\n\t\t\treturn \"translate(\" + zero + \", 0)\";\n\t\t} else if (orientation === \"right\") {\n\t\t\treturn \"translate(\" + (zero == 0 ? width : zero) + \", 0)\";\n\t\t} else {\n\t\t\treturn \"\";\n\t\t}\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar height = _props.height;\n\t\tvar width = _props.width;\n\t\tvar tickArguments = _props.tickArguments;\n\t\tvar tickValues = _props.tickValues;\n\t\tvar tickFormat = _props.tickFormat;\n\t\tvar innerTickSize = _props.innerTickSize;\n\t\tvar tickPadding = _props.tickPadding;\n\t\tvar outerTickSize = _props.outerTickSize;\n\t\tvar scale = _props.scale;\n\t\tvar orientation = _props.orientation;\n\t\tvar className = _props.className;\n\t\tvar zero = _props.zero;\n\t\tvar label = _props.label;\n\n\t\tvar ticks = tickValues == null ? scale.ticks ? scale.ticks.apply(scale, tickArguments) : scale.domain() : tickValues;\n\n\t\tif (!tickFormat) {\n\t\t\tif (scale.tickFormat) {\n\t\t\t\ttickFormat = scale.tickFormat.apply(scale, tickArguments);\n\t\t\t} else {\n\t\t\t\ttickFormat = function (x) {\n\t\t\t\t\treturn x;\n\t\t\t\t};\n\t\t\t}\n\t\t}\n\n\t\t// TODO: is there a cleaner way? removes the 0 tick if axes are crossing\n\t\tif (zero != height && zero != width && zero != 0) {\n\t\t\tticks = ticks.filter(function (element, index, array) {\n\t\t\t\treturn element == 0 ? false : true;\n\t\t\t});\n\t\t}\n\n\t\tvar tickSpacing = Math.max(innerTickSize, 0) + tickPadding;\n\n\t\tvar sign = orientation === \"top\" || orientation === \"left\" ? -1 : 1;\n\n\t\tvar range = this._d3_scaleRange(scale);\n\n\t\tvar activeScale = scale.rangeBand ? function (e) {\n\t\t\treturn scale(e) + scale.rangeBand() / 2;\n\t\t} : scale;\n\n\t\tvar transform = undefined,\n\t\t    x = undefined,\n\t\t    y = undefined,\n\t\t    x2 = undefined,\n\t\t    y2 = undefined,\n\t\t    dy = undefined,\n\t\t    textAnchor = undefined,\n\t\t    d = undefined,\n\t\t    labelElement = undefined;\n\t\tif (orientation === \"bottom\" || orientation === \"top\") {\n\t\t\ttransform = \"translate({}, 0)\";\n\t\t\tx = 0;\n\t\t\ty = sign * tickSpacing;\n\t\t\tx2 = 0;\n\t\t\ty2 = sign * innerTickSize;\n\t\t\tdy = sign < 0 ? \"0em\" : \".71em\";\n\t\t\ttextAnchor = \"middle\";\n\t\t\td = \"M\" + range[0] + \", \" + sign * outerTickSize + \"V0H\" + range[1] + \"V\" + sign * outerTickSize;\n\n\t\t\tlabelElement = React.createElement(\n\t\t\t\t\"text\",\n\t\t\t\t{ className: \"\" + className + \" label\", textAnchor: \"end\", x: width, y: -6 },\n\t\t\t\tlabel\n\t\t\t);\n\t\t} else {\n\t\t\ttransform = \"translate(0, {})\";\n\t\t\tx = sign * tickSpacing;\n\t\t\ty = 0;\n\t\t\tx2 = sign * innerTickSize;\n\t\t\ty2 = 0;\n\t\t\tdy = \".32em\";\n\t\t\ttextAnchor = sign < 0 ? \"end\" : \"start\";\n\t\t\td = \"M\" + sign * outerTickSize + \", \" + range[0] + \"H0V\" + range[1] + \"H\" + sign * outerTickSize;\n\n\t\t\tlabelElement = React.createElement(\n\t\t\t\t\"text\",\n\t\t\t\t{ className: \"\" + className + \" label\", textAnchor: \"end\", y: 6, dy: \".75em\", transform: \"rotate(-90)\" },\n\t\t\t\tlabel\n\t\t\t);\n\t\t}\n\n\t\tvar tickElements = ticks.map(function (tick, index) {\n\t\t\tvar position = activeScale(tick);\n\t\t\tvar translate = transform.replace(\"{}\", position);\n\t\t\treturn React.createElement(\n\t\t\t\t\"g\",\n\t\t\t\t{ key: \"\" + tick + \".\" + index, className: \"tick\", transform: translate },\n\t\t\t\tReact.createElement(\"line\", { x2: x2, y2: y2, stroke: \"#aaa\" }),\n\t\t\t\tReact.createElement(\n\t\t\t\t\t\"text\",\n\t\t\t\t\t{ x: x, y: y, dy: dy, textAnchor: textAnchor },\n\t\t\t\t\ttickFormat(tick)\n\t\t\t\t)\n\t\t\t);\n\t\t});\n\n\t\tvar pathElement = React.createElement(\"path\", { className: \"domain\", d: d, fill: \"none\", stroke: \"#aaa\" });\n\n\t\treturn React.createElement(\n\t\t\t\"g\",\n\t\t\t{ ref: \"axis\", className: className, transform: this._getTranslateString(), style: { shapeRendering: \"crispEdges\" } },\n\t\t\ttickElements,\n\t\t\tpathElement,\n\t\t\tlabelElement\n\t\t);\n\t},\n\n\t_d3_scaleExtent: function _d3_scaleExtent(domain) {\n\t\tvar start = domain[0],\n\t\t    stop = domain[domain.length - 1];\n\t\treturn start < stop ? [start, stop] : [stop, start];\n\t},\n\n\t_d3_scaleRange: function _d3_scaleRange(scale) {\n\t\treturn scale.rangeExtent ? scale.rangeExtent() : this._d3_scaleExtent(scale.range());\n\t}\n});\n\nmodule.exports = Axis;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/Axis.jsx\n ** module id = 10\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/Axis.jsx?");

/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar Bar = React.createClass({\n\tdisplayName: \"Bar\",\n\n\tpropTypes: {\n\t\twidth: React.PropTypes.number.isRequired,\n\t\theight: React.PropTypes.number.isRequired,\n\t\tx: React.PropTypes.number.isRequired,\n\t\ty: React.PropTypes.number.isRequired,\n\t\tfill: React.PropTypes.string.isRequired,\n\t\tdata: React.PropTypes.oneOfType([React.PropTypes.array, React.PropTypes.object]).isRequired,\n\t\tonMouseEnter: React.PropTypes.func,\n\t\tonMouseLeave: React.PropTypes.func\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar x = _props.x;\n\t\tvar y = _props.y;\n\t\tvar width = _props.width;\n\t\tvar height = _props.height;\n\t\tvar fill = _props.fill;\n\t\tvar data = _props.data;\n\t\tvar onMouseEnter = _props.onMouseEnter;\n\t\tvar onMouseLeave = _props.onMouseLeave;\n\n\t\treturn React.createElement(\"rect\", {\n\t\t\tclassName: \"bar\",\n\t\t\tx: x,\n\t\t\ty: y,\n\t\t\twidth: width,\n\t\t\theight: height,\n\t\t\tfill: fill,\n\t\t\tonMouseMove: function (e) {\n\t\t\t\tonMouseEnter(e, data);\n\t\t\t},\n\t\t\tonMouseLeave: function (e) {\n\t\t\t\tonMouseLeave(e);\n\t\t\t}\n\t\t});\n\t}\n});\n\nmodule.exports = Bar;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/Bar.jsx\n ** module id = 11\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/Bar.jsx?");

/***/ },
/* 12 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar Tooltip = React.createClass({\n\tdisplayName: \"Tooltip\",\n\n\tpropTypes: {\n\t\ttop: React.PropTypes.number.isRequired,\n\t\tleft: React.PropTypes.number.isRequired,\n\t\thtml: React.PropTypes.string\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\ttop: 150,\n\t\t\tleft: 100,\n\t\t\thtml: \"\"\n\t\t};\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar top = _props.top;\n\t\tvar left = _props.left;\n\t\tvar hidden = _props.hidden;\n\t\tvar html = _props.html;\n\n\t\tvar style = {\n\t\t\tdisplay: hidden ? \"none\" : \"block\",\n\t\t\tposition: \"fixed\",\n\t\t\ttop: top,\n\t\t\tleft: left\n\t\t};\n\n\t\treturn React.createElement(\n\t\t\t\"div\",\n\t\t\t{ className: \"tooltip\", style: style },\n\t\t\thtml\n\t\t);\n\t}\n});\n\nmodule.exports = Tooltip;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/Tooltip.jsx\n ** module id = 12\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/Tooltip.jsx?");

/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar DefaultPropsMixin = {\n\tpropTypes: {\n\t\tdata: React.PropTypes.oneOfType([React.PropTypes.object, React.PropTypes.array]).isRequired,\n\t\theight: React.PropTypes.number.isRequired,\n\t\twidth: React.PropTypes.number.isRequired,\n\t\tmargin: React.PropTypes.shape({\n\t\t\ttop: React.PropTypes.number,\n\t\t\tbottom: React.PropTypes.number,\n\t\t\tleft: React.PropTypes.number,\n\t\t\tright: React.PropTypes.number\n\t\t}),\n\t\txScale: React.PropTypes.func,\n\t\tyScale: React.PropTypes.func,\n\t\tcolorScale: React.PropTypes.func\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\tdata: { label: \"No data available\", values: [{ x: \"No data available\", y: 1 }] },\n\t\t\tmargin: { top: 0, bottom: 0, left: 0, right: 0 },\n\t\t\txScale: null,\n\t\t\tyScale: null,\n\t\t\tcolorScale: d3.scale.category20()\n\t\t};\n\t}\n};\n\nmodule.exports = DefaultPropsMixin;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/DefaultPropsMixin.jsx\n ** module id = 13\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/DefaultPropsMixin.jsx?");

/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar HeightWidthMixin = {\n\tcomponentWillMount: function componentWillMount() {\n\t\tthis._calculateInner(this.props);\n\t},\n\n\tcomponentWillReceiveProps: function componentWillReceiveProps(nextProps) {\n\t\tthis._calculateInner(nextProps);\n\t},\n\n\t_calculateInner: function _calculateInner(props) {\n\t\tvar height = props.height;\n\t\tvar width = props.width;\n\t\tvar margin = props.margin;\n\n\t\tthis._innerHeight = height - margin.top - margin.bottom;\n\t\tthis._innerWidth = width - margin.left - margin.right;\n\t}\n};\n\nmodule.exports = HeightWidthMixin;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/HeightWidthMixin.jsx\n ** module id = 14\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/HeightWidthMixin.jsx?");

/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar ArrayifyMixin = {\n\tcomponentWillMount: function componentWillMount() {\n\t\tthis._arrayify(this.props);\n\t},\n\n\tcomponentWillReceiveProps: function componentWillReceiveProps(nextProps) {\n\t\tthis._arrayify(nextProps);\n\t},\n\n\t_arrayify: function _arrayify(props) {\n\t\tif (props.data === null) {\n\t\t\tthis._data = [{\n\t\t\t\tlabel: \"No data available\",\n\t\t\t\tvalues: [{ x: \"No data available\", y: 1 }]\n\t\t\t}];\n\t\t} else if (!Array.isArray(props.data)) {\n\t\t\tthis._data = [props.data];\n\t\t} else {\n\t\t\tthis._data = props.data;\n\t\t}\n\t}\n};\n\nmodule.exports = ArrayifyMixin;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/ArrayifyMixin.jsx\n ** module id = 15\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/ArrayifyMixin.jsx?");

/***/ },
/* 16 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar React = __webpack_require__(7);\n\nvar StackAccessorMixin = {\n\tpropTypes: {\n\t\tlabel: React.PropTypes.func,\n\t\tvalues: React.PropTypes.func,\n\t\tx: React.PropTypes.func,\n\t\ty: React.PropTypes.func,\n\t\ty0: React.PropTypes.func\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\tlabel: function (stack) {\n\t\t\t\treturn stack.label;\n\t\t\t},\n\t\t\tvalues: function (stack) {\n\t\t\t\treturn stack.values;\n\t\t\t},\n\t\t\tx: function (e) {\n\t\t\t\treturn e.x;\n\t\t\t},\n\t\t\ty: function (e) {\n\t\t\t\treturn e.y;\n\t\t\t},\n\t\t\ty0: function (e) {\n\t\t\t\treturn e.y0;\n\t\t\t}\n\t\t};\n\t}\n};\n\nmodule.exports = StackAccessorMixin;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/StackAccessorMixin.jsx\n ** module id = 16\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/StackAccessorMixin.jsx?");

/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar StackDataMixin = {\n\tpropTypes: {\n\t\toffset: React.PropTypes.string\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\toffset: \"zero\",\n\t\t\torder: \"default\"\n\t\t};\n\t},\n\n\tcomponentWillMount: function componentWillMount() {\n\t\tthis._stackData(this.props);\n\t},\n\n\tcomponentWillReceiveProps: function componentWillReceiveProps(nextProps) {\n\t\tthis._stackData(nextProps);\n\t},\n\n\t_stackData: function _stackData(props) {\n\t\tvar offset = props.offset;\n\t\tvar order = props.order;\n\t\tvar x = props.x;\n\t\tvar y = props.y;\n\t\tvar values = props.values;\n\n\t\tvar stack = d3.layout.stack().offset(offset).order(order).x(x).y(y).values(values);\n\n\t\tthis._data = stack(this._data);\n\t}\n};\n\nmodule.exports = StackDataMixin;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/StackDataMixin.jsx\n ** module id = 17\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/StackDataMixin.jsx?");

/***/ },
/* 18 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar _slicedToArray = function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { var _arr = []; for (var _iterator = arr[Symbol.iterator](), _step; !(_step = _iterator.next()).done;) { _arr.push(_step.value); if (i && _arr.length === i) break; } return _arr; } else { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); } };\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar DefaultScalesMixin = {\n\tpropTypes: {\n\t\tbarPadding: React.PropTypes.number\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\tbarPadding: 0.5\n\t\t};\n\t},\n\n\tcomponentWillMount: function componentWillMount() {\n\t\tthis._makeScales(this.props);\n\t},\n\n\tcomponentWillReceiveProps: function componentWillReceiveProps(nextProps) {\n\t\tthis._makeScales(nextProps);\n\t},\n\n\t_makeScales: function _makeScales(props) {\n\t\tvar xScale = props.xScale;\n\t\tvar xIntercept = props.xIntercept;\n\t\tvar yScale = props.yScale;\n\t\tvar yIntercept = props.yIntercept;\n\n\t\tif (!xScale) {\n\t\t\tvar _ref = this._makeXScale();\n\n\t\t\tvar _ref2 = _slicedToArray(_ref, 2);\n\n\t\t\tthis._xScale = _ref2[0];\n\t\t\tthis._xIntercept = _ref2[1];\n\t\t} else {\n\t\t\tvar _ref3 = [xScale, xIntercept];\n\n\t\t\tvar _ref32 = _slicedToArray(_ref3, 2);\n\n\t\t\tthis._xScale = _ref32[0];\n\t\t\tthis._xIntercept = _ref32[1];\n\t\t}\n\n\t\tif (!yScale) {\n\t\t\tvar _ref4 = this._makeYScale();\n\n\t\t\tvar _ref42 = _slicedToArray(_ref4, 2);\n\n\t\t\tthis._yScale = _ref42[0];\n\t\t\tthis._yIntercept = _ref42[1];\n\t\t} else {\n\t\t\tvar _ref5 = [yScale, yIntercept];\n\n\t\t\tvar _ref52 = _slicedToArray(_ref5, 2);\n\n\t\t\tthis._yScale = _ref52[0];\n\t\t\tthis._yIntercept = _ref52[1];\n\t\t}\n\t},\n\n\t_makeXScale: function _makeXScale() {\n\t\tvar _props = this.props;\n\t\tvar x = _props.x;\n\t\tvar values = _props.values;\n\n\t\tvar data = this._data;\n\n\t\tif (typeof x(values(data[0])[0]) === \"number\") {\n\t\t\treturn this._makeLinearXScale();\n\t\t} else if (typeof x(values(data[0])[0]).getMonth === \"function\") {\n\t\t\treturn this._makeTimeXScale();\n\t\t} else {\n\t\t\treturn this._makeOrdinalXScale();\n\t\t}\n\t},\n\n\t_makeLinearXScale: function _makeLinearXScale() {\n\t\tvar _props = this.props;\n\t\tvar x = _props.x;\n\t\tvar values = _props.values;\n\t\tvar data = this._data;\n\t\tvar innerWidth = this._innerWidth;\n\n\t\tvar extents = d3.extent(Array.prototype.concat.apply([], data.map(function (stack) {\n\t\t\treturn values(stack).map(function (e) {\n\t\t\t\treturn x(e);\n\t\t\t});\n\t\t})));\n\n\t\tvar scale = d3.scale.linear().domain(extents).range([0, innerWidth]);\n\n\t\tvar zero = d3.max([0, scale.domain()[0]]);\n\t\tvar xIntercept = scale(zero);\n\n\t\treturn [scale, xIntercept];\n\t},\n\n\t_makeOrdinalXScale: function _makeOrdinalXScale() {\n\t\tvar _props = this.props;\n\t\tvar x = _props.x;\n\t\tvar values = _props.values;\n\t\tvar barPadding = _props.barPadding;\n\t\tvar data = this._data;\n\t\tvar innerWidth = this._innerWidth;\n\n\t\tvar scale = d3.scale.ordinal().domain(values(data[0]).map(function (e) {\n\t\t\treturn x(e);\n\t\t})).rangeRoundBands([0, innerWidth], barPadding);\n\n\t\treturn [scale, 0];\n\t},\n\n\t_makeTimeXScale: function _makeTimeXScale() {\n\t\tvar _props = this.props;\n\t\tvar x = _props.x;\n\t\tvar values = _props.values;\n\t\tvar barPadding = _props.barPadding;\n\t\tvar data = this._data;\n\t\tvar innerWidth = this._innerWidth;\n\n\t\tvar scale = d3.time.scale().domain(values(data[0]).map(function (e) {\n\t\t\treturn x(e);\n\t\t})).range([0, innerWidth]);\n\n\t\treturn [scale, 0];\n\t},\n\n\t_makeYScale: function _makeYScale() {\n\t\tvar _props = this.props;\n\t\tvar y = _props.y;\n\t\tvar values = _props.values;\n\n\t\tvar data = this._data;\n\n\t\tif (typeof y(values(data[0])[0]) === \"number\") {\n\t\t\treturn this._makeLinearYScale();\n\t\t} else {\n\t\t\treturn this._makeOrdinalYScale();\n\t\t}\n\t},\n\n\t_makeLinearYScale: function _makeLinearYScale() {\n\t\tvar _props = this.props;\n\t\tvar y = _props.y;\n\t\tvar y0 = _props.y0;\n\t\tvar values = _props.values;\n\t\tvar data = this._data;\n\t\tvar innerHeight = this._innerHeight;\n\n\t\tvar extents = d3.extent(Array.prototype.concat.apply([], data.map(function (stack) {\n\t\t\treturn values(stack).map(function (e) {\n\t\t\t\treturn y0(e) + y(e);\n\t\t\t});\n\t\t})));\n\n\t\textents = [d3.min([0, extents[0]]), extents[1]];\n\n\t\tvar scale = d3.scale.linear().domain(extents).range([innerHeight, 0]);\n\n\t\tvar zero = d3.max([0, scale.domain()[0]]);\n\t\tvar yIntercept = scale(zero);\n\n\t\treturn [scale, yIntercept];\n\t},\n\n\t_makeOrdinalYScale: function _makeOrdinalYScale() {\n\t\tvar data = this._data;\n\t\tvar innerHeight = this._innerHeight;\n\n\t\tvar scale = d3.scale.ordinal().range([innerHeight, 0]);\n\n\t\tvar yIntercept = scale(0);\n\n\t\treturn [scale, yIntercept];\n\t}\n};\n\nmodule.exports = DefaultScalesMixin;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/DefaultScalesMixin.jsx\n ** module id = 18\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/DefaultScalesMixin.jsx?");

/***/ },
/* 19 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar TooltipMixin = {\n\tpropTypes: {\n\t\ttooltipHtml: React.PropTypes.func\n\t},\n\n\tgetInitialState: function getInitialState() {\n\t\treturn {\n\t\t\ttooltip: {\n\t\t\t\thidden: true\n\t\t\t}\n\t\t};\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\ttooltipOffset: { top: -20, left: 15 },\n\t\t\ttooltipHtml: null\n\t\t};\n\t},\n\n\tcomponentDidMount: function componentDidMount() {\n\t\tthis._svg_node = this.getDOMNode().getElementsByTagName(\"svg\")[0];\n\t},\n\n\tonMouseEnter: function onMouseEnter(e, data) {\n\t\tif (!this.props.tooltipHtml) {\n\t\t\treturn;\n\t\t}\n\n\t\te.preventDefault();\n\n\t\tvar _props = this.props;\n\t\tvar margin = _props.margin;\n\t\tvar tooltipHtml = _props.tooltipHtml;\n\n\t\tvar svg = this._svg_node;\n\t\tvar position = undefined;\n\t\tif (svg.createSVGPoint) {\n\t\t\tvar point = svg.createSVGPoint();\n\t\t\tpoint.x = e.clientX, point.y = e.clientY;\n\t\t\tpoint = point.matrixTransform(svg.getScreenCTM().inverse());\n\t\t\tposition = [point.x - margin.left, point.y - margin.top];\n\t\t} else {\n\t\t\tvar rect = svg.getBoundingClientRect();\n\t\t\tposition = [e.clientX - rect.left - svg.clientLeft - margin.left, e.clientY - rect.top - svg.clientTop - margin.top];\n\t\t}\n\n\t\tthis.setState({\n\t\t\ttooltip: {\n\t\t\t\ttop: e.clientY + this.props.tooltipOffset.top,\n\t\t\t\tleft: e.clientX + this.props.tooltipOffset.left,\n\t\t\t\thidden: false,\n\t\t\t\thtml: this._tooltipHtml(data, position)\n\t\t\t}\n\t\t});\n\t},\n\n\tonMouseLeave: function onMouseLeave(e) {\n\t\tif (!this.props.tooltipHtml) {\n\t\t\treturn;\n\t\t}\n\n\t\te.preventDefault();\n\n\t\tthis.setState({\n\t\t\ttooltip: {\n\t\t\t\thidden: true\n\t\t\t}\n\t\t});\n\t}\n};\n\nmodule.exports = TooltipMixin;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/TooltipMixin.jsx\n ** module id = 19\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/TooltipMixin.jsx?");

/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar React = __webpack_require__(7);\n\nvar AccessorMixin = {\n\tpropTypes: {\n\t\tlabel: React.PropTypes.func,\n\t\tvalues: React.PropTypes.func,\n\t\tx: React.PropTypes.func,\n\t\ty: React.PropTypes.func,\n\t\ty0: React.PropTypes.func\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\tlabel: function (stack) {\n\t\t\t\treturn stack.label;\n\t\t\t},\n\t\t\tvalues: function (stack) {\n\t\t\t\treturn stack.values;\n\t\t\t},\n\t\t\tx: function (e) {\n\t\t\t\treturn e.x;\n\t\t\t},\n\t\t\ty: function (e) {\n\t\t\t\treturn e.y;\n\t\t\t},\n\t\t\ty0: function (e) {\n\t\t\t\treturn 0;\n\t\t\t}\n\t\t};\n\t}\n};\n\nmodule.exports = AccessorMixin;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/AccessorMixin.jsx\n ** module id = 20\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/AccessorMixin.jsx?");

/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

	eval("\"use strict\";\n\nvar React = __webpack_require__(7);\nvar d3 = __webpack_require__(8);\n\nvar Path = React.createClass({\n\tdisplayName: \"Path\",\n\n\tpropTypes: {\n\t\tclassName: React.PropTypes.string,\n\t\tstroke: React.PropTypes.string.isRequired,\n\t\tstrokeLinecap: React.PropTypes.string,\n\t\tstrokeWidth: React.PropTypes.string,\n\t\tstrokeDasharray: React.PropTypes.string,\n\t\tfill: React.PropTypes.string,\n\t\td: React.PropTypes.string.isRequired,\n\t\tdata: React.PropTypes.array.isRequired\n\t},\n\n\tgetDefaultProps: function getDefaultProps() {\n\t\treturn {\n\t\t\tclassName: \"path\",\n\t\t\tfill: \"none\",\n\t\t\tstrokeWidth: \"2\",\n\t\t\tstrokeLinecap: \"butt\",\n\t\t\tstrokeDasharray: \"none\"\n\t\t};\n\t},\n\n\trender: function render() {\n\t\tvar _props = this.props;\n\t\tvar className = _props.className;\n\t\tvar stroke = _props.stroke;\n\t\tvar strokeWidth = _props.strokeWidth;\n\t\tvar strokeLinecap = _props.strokeLinecap;\n\t\tvar strokeDasharray = _props.strokeDasharray;\n\t\tvar fill = _props.fill;\n\t\tvar d = _props.d;\n\t\tvar style = _props.style;\n\t\tvar data = _props.data;\n\t\tvar onMouseEnter = _props.onMouseEnter;\n\t\tvar onMouseLeave = _props.onMouseLeave;\n\n\t\treturn React.createElement(\"path\", {\n\t\t\tclassName: className,\n\t\t\tstroke: stroke,\n\t\t\tstrokeWidth: strokeWidth,\n\t\t\tstrokeLinecap: strokeLinecap,\n\t\t\tstrokeDasharray: strokeDasharray,\n\t\t\tfill: fill,\n\t\t\td: d,\n\t\t\tonMouseMove: function (evt) {\n\t\t\t\tonMouseEnter(evt, data);\n\t\t\t},\n\t\t\tonMouseLeave: function (evt) {\n\t\t\t\tonMouseLeave(evt);\n\t\t\t},\n\t\t\tstyle: style\n\t\t});\n\t}\n});\n\nmodule.exports = Path;\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/Path.jsx\n ** module id = 21\n ** module chunks = 0\n **/\n//# sourceURL=webpack:///./src/Path.jsx?");

/***/ }
/******/ ])
});
;