'use strict';
var fs = require('fs');
var ejs = require('ejs');
var data = require('./vars');
var tpl = fs.readFileSync(__dirname + '/template.ejs').toString();

var base = 'http://localhost:4002';
var banner = 'Do not edit this file! It is generated by `generate.js` in this folder, from `template.ejs` and ' +
  'vars.js.';

data.forEach(function(datum, i) {
  datum.base = base;
  datum.index = i;
  datum.banner = banner;
  datum.previous = data[i - 1];
  datum.next = data[i + 1];
  var html = ejs.render(tpl, datum);
  fs.writeFileSync(__dirname + '/' + i + '-' + datum.source + '.html', html);
});
