# &lt;BrowserRouter> {id=browserrouter}

A [`<Router>`](#router) that uses the HTML5 history API (`pushState`, `replaceState` and the `popstate` event) to keep your UI in sync with the URL.

```js
import { BrowserRouter } from 'react-router-dom'

<BrowserRouter
  basename={optionalString}
  forceRefresh={optionalBool}
  getUserConfirmation={optionalFunc}
  keyLength={optionalNumber}
>
  <App/>
</BrowserRouter>
```

## basename: string _`<BrowserRouter>`_ {id=browserrouter.basename}

The base URL for all locations. If your app is served from a sub-directory on your server, you'll want to set this to the sub-directory.

```js
<BrowserRouter basename="/calendar"/>
<Link to="/today"/> // renders <a href="/calendar/today">
```

## getUserConfirmation: func _`<BrowserRouter>`_ {id=browserrouter.getuserconfirmation}

A function to use to confirm navigation. Defaults to using [`window.confirm`](https://developer.mozilla.org/en-US/docs/Web/API/Window/confirm).

```js
// this is the default behavior
const getConfirmation = (message, callback) => {
  const allowTransition = window.confirm(message)
  callback(allowTransition)
}

<BrowserRouter getUserConfirmation={getConfirmation}/>
```

## forceRefresh: bool _`<BrowserRouter>`_ {id=browserrouter.forcerefresh}

If `true` the router will use full page refreshes on page navigation. You probably only want this in [browsers that don't support the HTML5 history API](http://caniuse.com/#feat=history).

```js
const supportsHistory = 'pushState' in window.history
<BrowserRouter forceRefresh={!supportsHistory}/>
```

## keyLength: number _`<BrowserRouter>`_ {id=browserrouter.keylength}

The length of `location.key`. Defaults to 6.

```js
<BrowserRouter keyLength={12}/>
```

## children: node _`<BrowserRouter>`_ {id=browserrouter.children}

A [single child element](https://facebook.github.io/react/docs/react-api.html#react.children.only) to render.
