# Table of Contents

* [Read Me](/README.md)
* [Introduction](/docs/introduction/README.md)
  * [Motivation](/docs/introduction/Motivation.md)
  * [Core Concepts](/docs/introduction/CoreConcepts.md)
  * [Three Principles](/docs/introduction/ThreePrinciples.md)
  * [Prior Art](/docs/introduction/PriorArt.md)
  * [Learning Resources](/docs/introduction/LearningResources.md)
  * [Ecosystem](/docs/introduction/Ecosystem.md)
  * [Examples](/docs/introduction/Examples.md)
* [Basics](/docs/basics/README.md)
  * [Actions](/docs/basics/Actions.md)
  * [Reducers](/docs/basics/Reducers.md)
  * [Store](/docs/basics/Store.md)
  * [Data Flow](/docs/basics/DataFlow.md)
  * [Usage with React](/docs/basics/UsageWithReact.md)
  * [Example: Todo List](/docs/basics/ExampleTodoList.md)
* [Advanced](/docs/advanced/README.md)
  * [Async Actions](/docs/advanced/AsyncActions.md)
  * [Async Flow](/docs/advanced/AsyncFlow.md)
  * [Middleware](/docs/advanced/Middleware.md)
  * [Usage with React Router](/docs/advanced/UsageWithReactRouter.md)
  * [Example: Reddit API](/docs/advanced/ExampleRedditAPI.md)
  * Next Steps
* [Recipes](/docs/recipes/README.md)
  * [Migrating to Redux](/docs/recipes/MigratingToRedux.md)
  * [Using Object Spread Operator](/docs/recipes/UsingObjectSpreadOperator.md)
  * [Reducing Boilerplate](/docs/recipes/ReducingBoilerplate.md)
  * [Server Rendering](/docs/recipes/ServerRendering.md)
  * [Writing Tests](/docs/recipes/WritingTests.md)
  * [Computing Derived Data](/docs/recipes/ComputingDerivedData.md)
  * [Implementing Undo History](/docs/recipes/ImplementingUndoHistory.md)
  * [Isolating Subapps](/docs/recipes/IsolatingSubapps.md)
  * [Structuring Reducers](/docs/recipes/StructuringReducers.md)
    * [Prerequisite Concepts](/docs/recipes/reducers/PrerequisiteConcepts.md)
    * [Basic Reducer Structure](/docs/recipes/reducers/BasicReducerStructure.md)
    * [Splitting Reducer Logic](/docs/recipes/reducers/SplittingReducerLogic.md)
    * [Refactoring Reducers Example](/docs/recipes/reducers/RefactoringReducersExample.md)
    * [Using `combineReducers`](/docs/recipes/reducers/UsingCombineReducers.md)
    * [Beyond `combineReducers`](/docs/recipes/reducers/BeyondCombineReducers.md)
    * [Normalizing State Shape](/docs/recipes/reducers/NormalizingStateShape.md)
    * [Updating Normalized Data](/docs/recipes/reducers/UpdatingNormalizedData.md)
    * [Reusing Reducer Logic](/docs/recipes/reducers/ReusingReducerLogic.md)
    * [Immutable Update Patterns](/docs/recipes/reducers/ImmutableUpdatePatterns.md)
    * [Initializing State](/docs/recipes/reducers/InitializingState.md)
  * [Using Immutable.JS with Redux](/docs/recipes/UsingImmutableJS.md)
* [FAQ](/docs/FAQ.md)
  * [General](/docs/faq/General.md)
  * [Reducers](/docs/faq/Reducers.md)
  * [Organizing State](/docs/faq/OrganizingState.md)
  * [Store Setup](/docs/faq/StoreSetup.md)
  * [Actions](/docs/faq/Actions.md)
  * [Immutable Data](/docs/faq/ImmutableData.md)
  * [Code Structure](/docs/faq/CodeStructure.md)
  * [Performance](/docs/faq/Performance.md)
  * [Design Decisions](/docs/faq/DesignDecisions.md)
  * [React Redux](/docs/faq/ReactRedux.md)
  * [Miscellaneous](/docs/faq/Miscellaneous.md)
* [Troubleshooting](/docs/Troubleshooting.md)
* [Glossary](/docs/Glossary.md)
* [API Reference](/docs/api/README.md)
  * [createStore](/docs/api/createStore.md)
  * [Store](/docs/api/Store.md)
  * [combineReducers](/docs/api/combineReducers.md)
  * [applyMiddleware](/docs/api/applyMiddleware.md)
  * [bindActionCreators](/docs/api/bindActionCreators.md)
  * [compose](/docs/api/compose.md)
* [Change Log](/CHANGELOG.md)
* [Patrons](/PATRONS.md)
* [Feedback](/docs/Feedback.md)
