# Rollbar.js

[![Build Status](https://api.travis-ci.org/rollbar/rollbar.js.png?branch=v2.15.2)](https://travis-ci.org/rollbar/rollbar.js)
[![Code Quality: Javascript](https://img.shields.io/lgtm/grade/javascript/g/rollbar/rollbar.js.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/rollbar/rollbar.js/context:javascript)
[![Total Alerts](https://img.shields.io/lgtm/alerts/g/rollbar/rollbar.js.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/rollbar/rollbar.js/alerts)

Rollbar.js is the Javascript SDK for [Rollbar](https://rollbar.com).  It supports both Node.js and client-side Javascript, including frameworks such as React, Angular, Ember, and more.

## Setup Instructions

1. [Sign up for a Rollbar account](https://rollbar.com/signup).
2. For client-side Javascript, follow the [Browser Quick Start](https://docs.rollbar.com/docs/javascript#section-quick-start-browser) instructions.  For Node.js, follow the [Server Quick Start](https://docs.rollbar.com/docs/javascript#section-quick-start-server).

## Usage and Reference

For complete usage instructions and configuration reference, see our [Javascript SDK docs](https://docs.rollbar.com/docs/javascript).
  
## Release History & Changelog

See our [Releases](https://github.com/rollbar/rollbar.js/releases) page for a list of all releases, including changes.

## Help / Support

If you run into any issues, please email us at [support@rollbar.com](mailto:support@rollbar.com).

For bug reports, please [open an issue on GitHub](https://github.com/rollbar/rollbar.js/issues/new).

## Developing

To set up a development environment, you'll need Node.js and npm.

1. `git submodule update --init`
2. `npm install -D`
3. `make`

To run the tests, run `make test`.

## Contributing

1. [Fork it](https://github.com/rollbar/rollbar.js).
2. Create your feature branch (`git checkout -b my-new-feature`).
3. Commit your changes (`git commit -am 'Added some feature'`).
4. Push to the branch (`git push origin my-new-feature`).
5. Create a new Pull Request.
