/*!
 * # Semantic UI 2.2.1 - Progress
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,r){"use strict";t="undefined"!=typeof t&&t.Math==Math?t:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"undefined"!=typeof t&&t.Math==Math?t:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();e.fn.progress=function(t){var a,o=e(this),s=o.selector||"",i=(new Date).getTime(),l=[],c=arguments[0],u="string"==typeof c,g=[].slice.call(arguments,1);return o.each(function(){var o,p,v=e.isPlainObject(t)?e.extend(!0,{},e.fn.progress.settings,t):e.extend({},e.fn.progress.settings),d=v.className,m=v.metadata,f=v.namespace,b=v.selector,h=v.error,x="."+f,w="module-"+f,y=e(this),V=e(this).find(b.bar),C=e(this).find(b.progress),P=e(this).find(b.label),M=this,T=y.data(w),E=!1;p={initialize:function(){p.debug("Initializing progress bar",v),p.set.duration(),p.set.transitionEvent(),p.read.metadata(),p.read.settings(),p.instantiate()},instantiate:function(){p.verbose("Storing instance of progress",p),T=p,y.data(w,p)},destroy:function(){p.verbose("Destroying previous progress for",y),clearInterval(T.interval),p.remove.state(),y.removeData(w),T=r},reset:function(){p.remove.nextValue(),p.update.progress(0)},complete:function(){(p.percent===r||p.percent<100)&&(p.remove.progressPoll(),p.set.percent(100))},read:{metadata:function(){var e={percent:y.data(m.percent),total:y.data(m.total),value:y.data(m.value)};e.percent&&(p.debug("Current percent value set from metadata",e.percent),p.set.percent(e.percent)),e.total&&(p.debug("Total value set from metadata",e.total),p.set.total(e.total)),e.value&&(p.debug("Current value set from metadata",e.value),p.set.value(e.value),p.set.progress(e.value))},settings:function(){v.total!==!1&&(p.debug("Current total set in settings",v.total),p.set.total(v.total)),v.value!==!1&&(p.debug("Current value set in settings",v.value),p.set.value(v.value),p.set.progress(p.value)),v.percent!==!1&&(p.debug("Current percent set in settings",v.percent),p.set.percent(v.percent))}},increment:function(e){var t,n,r;p.has.total()?(n=p.get.value(),e=e||1,r=n+e):(n=p.get.percent(),e=e||p.get.randomValue(),r=n+e,t=100,p.debug("Incrementing percentage by",n,r)),r=p.get.normalizedValue(r),p.set.progress(r)},decrement:function(e){var t,n,r=p.get.total();r?(t=p.get.value(),e=e||1,n=t-e,p.debug("Decrementing value by",e,t)):(t=p.get.percent(),e=e||p.get.randomValue(),n=t-e,p.debug("Decrementing percentage by",e,t)),n=p.get.normalizedValue(n),p.set.progress(n)},has:{progressPoll:function(){return p.progressPoll},total:function(){return p.get.total()!==!1}},get:{text:function(e){var t=p.value||0,n=p.total||0,r=E?p.get.displayPercent():p.percent||0,a=p.total>0?n-t:100-r;return e=e||"",e=e.replace("{value}",t).replace("{total}",n).replace("{left}",a).replace("{percent}",r),p.verbose("Adding variables to progress bar text",e),e},normalizedValue:function(e){if(0>e)return p.debug("Value cannot decrement below 0"),0;if(p.has.total()){if(e>p.total)return p.debug("Value cannot increment above total",p.total),p.total}else if(e>100)return p.debug("Value cannot increment above 100 percent"),100;return e},updateInterval:function(){return"auto"==v.updateInterval?v.duration:v.updateInterval},randomValue:function(){return p.debug("Generating random increment percentage"),Math.floor(Math.random()*v.random.max+v.random.min)},numericValue:function(e){return"string"==typeof e?""!==e.replace(/[^\d.]/g,"")?+e.replace(/[^\d.]/g,""):!1:e},transitionEnd:function(){var e,t=n.createElement("element"),a={transition:"transitionend",OTransition:"oTransitionEnd",MozTransition:"transitionend",WebkitTransition:"webkitTransitionEnd"};for(e in a)if(t.style[e]!==r)return a[e]},displayPercent:function(){var e=V.width(),t=y.width(),n=parseInt(V.css("min-width"),10),r=e>n?e/t*100:p.percent;return v.precision>0?Math.round(r*(10*v.precision))/(10*v.precision):Math.round(r)},percent:function(){return p.percent||0},value:function(){return p.nextValue||p.value||0},total:function(){return p.total||!1}},create:{progressPoll:function(){p.progressPoll=setTimeout(function(){p.update.toNextValue(),p.remove.progressPoll()},p.get.updateInterval())}},is:{complete:function(){return p.is.success()||p.is.warning()||p.is.error()},success:function(){return y.hasClass(d.success)},warning:function(){return y.hasClass(d.warning)},error:function(){return y.hasClass(d.error)},active:function(){return y.hasClass(d.active)},visible:function(){return y.is(":visible")}},remove:{progressPoll:function(){p.verbose("Removing progress poll timer"),p.progressPoll&&(clearTimeout(p.progressPoll),delete p.progressPoll)},nextValue:function(){p.verbose("Removing progress value stored for next update"),delete p.nextValue},state:function(){p.verbose("Removing stored state"),delete p.total,delete p.percent,delete p.value},active:function(){p.verbose("Removing active state"),y.removeClass(d.active)},success:function(){p.verbose("Removing success state"),y.removeClass(d.success)},warning:function(){p.verbose("Removing warning state"),y.removeClass(d.warning)},error:function(){p.verbose("Removing error state"),y.removeClass(d.error)}},set:{barWidth:function(e){e>100?p.error(h.tooHigh,e):0>e?p.error(h.tooLow,e):(V.css("width",e+"%"),y.attr("data-percent",parseInt(e,10)))},duration:function(e){e=e||v.duration,e="number"==typeof e?e+"ms":e,p.verbose("Setting progress bar transition duration",e),V.css({"transition-duration":e})},percent:function(e){e="string"==typeof e?+e.replace("%",""):e,e=v.precision>0?Math.round(e*(10*v.precision))/(10*v.precision):Math.round(e),p.percent=e,p.has.total()||(p.value=v.precision>0?Math.round(e/100*p.total*(10*v.precision))/(10*v.precision):Math.round(e/100*p.total*10)/10,v.limitValues&&(p.value=p.value>100?100:p.value<0?0:p.value)),p.set.barWidth(e),p.set.labelInterval(),p.set.labels(),v.onChange.call(M,e,p.value,p.total)},labelInterval:function(){var t=function(){p.verbose("Bar finished animating, removing continuous label updates"),clearInterval(p.interval),E=!1,p.set.labels()};clearInterval(p.interval),V.one(o+x,t),E=!0,p.interval=setInterval(function(){var t=e.contains(n.documentElement,M);t||(clearInterval(p.interval),E=!1),p.set.labels()},v.framerate)},labels:function(){p.verbose("Setting both bar progress and outer label text"),p.set.barLabel(),p.set.state()},label:function(e){e=e||"",e&&(e=p.get.text(e),p.verbose("Setting label to text",e),P.text(e))},state:function(e){e=e!==r?e:p.percent,100===e?v.autoSuccess&&!(p.is.warning()||p.is.error()||p.is.success())?(p.set.success(),p.debug("Automatically triggering success at 100%")):(p.verbose("Reached 100% removing active state"),p.remove.active(),p.remove.progressPoll()):e>0?(p.verbose("Adjusting active progress bar label",e),p.set.active()):(p.remove.active(),p.set.label(v.text.active))},barLabel:function(e){e!==r?C.text(p.get.text(e)):"ratio"==v.label&&p.total?(p.verbose("Adding ratio to bar label"),C.text(p.get.text(v.text.ratio))):"percent"==v.label&&(p.verbose("Adding percentage to bar label"),C.text(p.get.text(v.text.percent)))},active:function(e){e=e||v.text.active,p.debug("Setting active state"),v.showActivity&&!p.is.active()&&y.addClass(d.active),p.remove.warning(),p.remove.error(),p.remove.success(),e=v.onLabelUpdate("active",e,p.value,p.total),e&&p.set.label(e),V.one(o+x,function(){v.onActive.call(M,p.value,p.total)})},success:function(e){e=e||v.text.success||v.text.active,p.debug("Setting success state"),y.addClass(d.success),p.remove.active(),p.remove.warning(),p.remove.error(),p.complete(),v.text.success?(e=v.onLabelUpdate("success",e,p.value,p.total),p.set.label(e)):(e=v.onLabelUpdate("active",e,p.value,p.total),p.set.label(e)),V.one(o+x,function(){v.onSuccess.call(M,p.total)})},warning:function(e){e=e||v.text.warning,p.debug("Setting warning state"),y.addClass(d.warning),p.remove.active(),p.remove.success(),p.remove.error(),p.complete(),e=v.onLabelUpdate("warning",e,p.value,p.total),e&&p.set.label(e),V.one(o+x,function(){v.onWarning.call(M,p.value,p.total)})},error:function(e){e=e||v.text.error,p.debug("Setting error state"),y.addClass(d.error),p.remove.active(),p.remove.success(),p.remove.warning(),p.complete(),e=v.onLabelUpdate("error",e,p.value,p.total),e&&p.set.label(e),V.one(o+x,function(){v.onError.call(M,p.value,p.total)})},transitionEvent:function(){o=p.get.transitionEnd()},total:function(e){p.total=e},value:function(e){p.value=e},progress:function(e){p.has.progressPoll()?(p.debug("Updated within interval, setting next update to use new value",e),p.set.nextValue(e)):(p.debug("First update in progress update interval, immediately updating",e),p.update.progress(e),p.create.progressPoll())},nextValue:function(e){p.nextValue=e}},update:{toNextValue:function(){var e=p.nextValue;e&&(p.debug("Update interval complete using last updated value",e),p.update.progress(e),p.remove.nextValue())},progress:function(e){var t;e=p.get.numericValue(e),e===!1&&p.error(h.nonNumeric,e),e=p.get.normalizedValue(e),p.has.total()?(p.set.value(e),t=e/p.total*100,p.debug("Calculating percent complete from total",t),p.set.percent(t)):(t=e,p.debug("Setting value to exact percentage value",t),p.set.percent(t))}},setting:function(t,n){if(p.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,v,t);else{if(n===r)return v[t];e.isPlainObject(v[t])?e.extend(!0,v[t],n):v[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,p,t);else{if(n===r)return p[t];p[t]=n}},debug:function(){!v.silent&&v.debug&&(v.performance?p.performance.log(arguments):(p.debug=Function.prototype.bind.call(console.info,console,v.name+":"),p.debug.apply(console,arguments)))},verbose:function(){!v.silent&&v.verbose&&v.debug&&(v.performance?p.performance.log(arguments):(p.verbose=Function.prototype.bind.call(console.info,console,v.name+":"),p.verbose.apply(console,arguments)))},error:function(){v.silent||(p.error=Function.prototype.bind.call(console.error,console,v.name+":"),p.error.apply(console,arguments))},performance:{log:function(e){var t,n,r;v.performance&&(t=(new Date).getTime(),r=i||t,n=t-r,i=t,l.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:M,"Execution Time":n})),clearTimeout(p.performance.timer),p.performance.timer=setTimeout(p.performance.display,500)},display:function(){var t=v.name+":",n=0;i=!1,clearTimeout(p.performance.timer),e.each(l,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",s&&(t+=" '"+s+"'"),(console.group!==r||console.table!==r)&&l.length>0&&(console.groupCollapsed(t),console.table?console.table(l):e.each(l,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),l=[]}},invoke:function(t,n,o){var s,i,l,c=T;return n=n||g,o=M||o,"string"==typeof t&&c!==r&&(t=t.split(/[\. ]/),s=t.length-1,e.each(t,function(n,a){var o=n!=s?a+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(c[o])&&n!=s)c=c[o];else{if(c[o]!==r)return i=c[o],!1;if(!e.isPlainObject(c[a])||n==s)return c[a]!==r?(i=c[a],!1):(p.error(h.method,t),!1);c=c[a]}})),e.isFunction(i)?l=i.apply(o,n):i!==r&&(l=i),e.isArray(a)?a.push(l):a!==r?a=[a,l]:l!==r&&(a=l),i}},u?(T===r&&p.initialize(),p.invoke(c)):(T!==r&&T.invoke("destroy"),p.initialize())}),a!==r?a:this},e.fn.progress.settings={name:"Progress",namespace:"progress",silent:!1,debug:!1,verbose:!1,performance:!0,random:{min:2,max:5},duration:300,updateInterval:"auto",autoSuccess:!0,showActivity:!0,limitValues:!0,label:"percent",precision:0,framerate:1e3/30,percent:!1,total:!1,value:!1,onLabelUpdate:function(e,t,n,r){return t},onChange:function(e,t,n){},onSuccess:function(e){},onActive:function(e,t){},onError:function(e,t){},onWarning:function(e,t){},error:{method:"The method you called is not defined.",nonNumeric:"Progress value is non numeric",tooHigh:"Value specified is above 100%",tooLow:"Value specified is below 0%"},regExp:{variable:/\{\$*[A-z0-9]+\}/g},metadata:{percent:"percent",total:"total",value:"value"},selector:{bar:"> .bar",label:"> .label",progress:".bar > .progress"},text:{active:!1,error:!1,success:!1,warning:!1,percent:"{percent}%",ratio:"{value} of {total}"},className:{active:"active",error:"error",success:"success",warning:"warning"}}}(jQuery,window,document);