![Semantic](http://semantic-ui.com/images/logo.png)

# Semantic UI

[![Join the chat at https://gitter.im/Semantic-Org/Semantic-UI](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/Semantic-Org/Semantic-UI?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

[![ProjectTalk Messageboard](http://www.projecttalk.io/images/gh_badge-3e578a9f437f841de7446bab9a49d103.svg?vsn=d)](http://www.projecttalk.io/boards/Semantic-Org%2FSemantic-UI?utm_campaign=gh-badge&utm_medium=badge&utm_source=github)

Semantic is a UI framework designed for theming.

Key Features
* 50+ UI elements
* 3000 + CSS variables
* 3 Levels of variable inheritance (similar to SublimeText)
* Built with EM values for responsive design
* Flexbox friendly

Semantic allows developers to build beautiful websites fast, with **concise HTML**, **intuitive javascript**, and **simplified debugging**, helping make front-end development a delightful experience. Semantic is responsively designed allowing your website to scale on multiple devices. Semantic is production ready and partnered with frameworks such as **React**, **Angular**, **Meteor**, and **Ember**, which means you can integrate it with any of these frameworks to organize your UI layer alongside your application logic.

## 2.2 Release

Semantic UI `2.2` is now available (June 2016). Read up on [what's new](http://www.semantic-ui.com/introduction/new.html) in the docs.

Migration info from `1.x` can be found in the [2.0 release notes](https://github.com/Semantic-Org/Semantic-UI/blob/master/RELEASE-NOTES.md#version-200---march-xx-2015)

## User Support

Please help us keep the issue tracker organized. For all questions that do not include a specific [jsfiddle test case](http://jsfiddle.net/efp8z6Ln/) (bug reports), or feature request please use our user forums at [http://forums.semantic-ui.com](http://forums.semantic-ui.com) to discuss. 

Visit our [contributing guide](https://github.com/Semantic-Org/Semantic-UI/blob/master/CONTRIBUTING.md) for more on what should be posted to GitHub Issues.

## Install

#### Recommended Install
```bash
npm install semantic-ui  # Use themes, import build/watch tasks into your own gulpfile.
```

Semantic UI includes an interactive installer to help setup your project
![Getting Started](https://dl.dropboxusercontent.com/u/2657007/install.gif)

* For more details on setup visit our [getting started guide](http://semantic-ui.com/introduction/getting-started.html).
* To learn more about theming please read our [theming guide](http://www.semantic-ui.com/usage/theming.html)

#### Additional Versions

Environment | Install Script | Repo
--- | --- | --- |
CSS Only | `npm install semantic-ui-css` | [CSS Repo](https://github.com/Semantic-Org/Semantic-UI-CSS)
[LESS](https://github.com/less/less.js/) Only | `npm install semantic-ui-less` | [LESS Repo](https://github.com/Semantic-Org/Semantic-UI-LESS)
[LESS](https://github.com/less/less.js/) plugin | `npm install less-plugin-semantic-ui` | [LESS Plugin Repo](https://github.com/bassjobsen/less-plugin-semantic-ui/)
[EmberJS](http://emberjs.com/) | `ember install:addon semantic-ui-ember` | [Ember Repo](https://github.com/Semantic-Org/Semantic-UI-Ember)
|[Meteor](https://www.meteor.com/) - [LESS](https://github.com/less/less.js/) | `meteor add semantic:ui` | [Meteor Repo](https://github.com/Semantic-Org/Semantic-UI-Meteor) |
|[Meteor](https://www.meteor.com/) - CSS | `meteor add semantic:ui-css` | [CSS Repo](https://github.com/Semantic-Org/Semantic-UI-CSS) |
[Bower](http://bower.io/) | `bower install semantic-ui` |

Check out our [integration wiki](https://github.com/Semantic-Org/Semantic-UI/wiki/Integration) for more options.

#### Browser Support

* Last 2 Versions FF, Chrome, Safari Mac
* IE 11+
* Android 4.4+, Chrome for Android 44+
* iOS Safari 7+
* Microsoft Edge 12 & 13

Although some components will work in IE9, [grids](http://semantic-ui.com/collections/grid.html) and other [flexbox](https://developer.mozilla.org/en-US/docs/Web/Guide/CSS/Flexible_boxes) components are not supported by IE9 and may not appear correctly.

## Community

#### Getting Help
Please **do not post** usage questions to GitHub Issues. For these types of questions use [StackOverflow](http://stackoverflow.com/questions/tagged/semantic-ui), [ProjectTalk](http://www.projecttalk.io/boards/Semantic-Org%2FSemantic-UI) or join our [Gitter chatroom](https://gitter.im/Semantic-Org/Semantic-UI).

#### Submitting Bugs and Enhancements
[GitHub Issues](https://github.com/Semantic-Org/Semantic-UI/issues) is for suggesting enhancements and reporting bugs. Before submiting a bug make sure you do the following:
* Check out our [contributing guide](https://github.com/Semantic-Org/Semantic-UI/blob/master/CONTRIBUTING.md) for info on our release cycle.
* [Fork this boilerplate JSFiddle](http://jsfiddle.net/efp8z6Ln/) to create a test case for your bug. If a bug is apparent in the docs, that's ok as a test case, just make it clear exactly how to reproduce the issue. Only bugs that include a test case can be triaged.


#### Pull Requests

When adding pull requests, be sure to merge into the [next](https://github.com/Semantic-Org/Semantic-UI/tree/next) branch. If you need to demonstrate a fix in ``next`` release, you can use [this jsfiddle](http://jsfiddle.net/rduvhn8u/1/)


#### International

* **Chinese** A Chinese mirror site is available at [http://www.semantic-ui.cn](http://www.semantic-ui.cn).
* **Right-to-Left (RTL)** An RTL version can be created using our build tools by selecting `rtl` from the install script.
* **Translation** To help translate see the [Wiki Guide](https://github.com/Semantic-Org/Semantic-UI/wiki/Translating-Semantic-UI-Docs) for translations.

#### Resources

Resource | Description
--- | --- |
Bugs & Feature Requests |  All bug submission **require** a link to a test case, and a set of steps to reproduce the issue. You can make a test case by forking this [jsfiddle](http://jsfiddle.net/efp8z6Ln/), then submit your [bug report on GitHub Issues](https://github.com/Semantic-Org/Semantic-UI/issues)
Live Chat | Join our [Gitter.im Room](https://gitter.im/Semantic-Org/Semantic-UI)
Message Board | [ProjectTalk Board](http://www.projecttalk.io/boards/Semantic-Org%2FSemantic-UI)
Newsletter Updates | Sign up for updates at [semantic-ui.com](http://www.semantic-ui.com)
Additional Resources  | Submit a question on [StackOverflow](http://stackoverflow.com/questions/tagged/semantic-ui) or ask our [Google Group](https://groups.google.com/forum/#!forum/semantic-ui)

#### Places to Help

Project | How To Help | Next Step
--- | --- | --- |
Localization | Help us translate Semantic UI into your language | [Join our Translation Community](https://github.com/Semantic-Org/Semantic-UI/wiki/Translating-Semantic-UI-Docs)
[SCSS](http://sass-lang.com/) | SASS needs PR to support variables inside `@import` | [Add Pull Request](https://github.com/sass/sass/pulls) for [#739](https://github.com/sass/sass/issues/739#issuecomment-73984809)
[Angular](https://angularjs.org/) | Help develop angular bindings | Reach Out on [GitHub Issues](https://github.com/Semantic-Org/Semantic-UI-Angular/issues/8)
Guides & Tutorials | Help write guides and tutorials | [Join the discussion](https://github.com/Semantic-Org/Semantic-UI/issues/1571)

#### Reaching Out

If you'd like to start a conversation about Semantic feel free to e-mail me at [jack@semantic-ui.com](mailto:jack@semantic-ui.com)

[![Flattr This](https://api.flattr.com/button/flattr-badge-large.png)](https://flattr.com/submit/auto?user_id=jlukic&url=https%3A%2F%2Fgithub.com%2Fjlukic%2FSemantic-UI)

<a href="http://packagequality.com/#?package=semantic-ui"><img src="http://npm.packagequality.com/badge/semantic-ui.png"/></a>
