# Contributing to Semantic UI

### Usage Questions

Questions about usage should be asked on [the ProjectTalk message board](http://www.projecttalk.io/boards/Semantic-Org%2FSemantic-UI), [StackOverflow](http://stackoverflow.com/questions/tagged/semantic-ui) or [Gitter](https://gitter.im/Semantic-Org/Semantic-UI).

Examples of usage questions
* *Why isnt my code working?*
* *Can Semantic UI do this?*

Once you receive feedback through community channels you may find your question is actually a bug. At this point it's a good idea to submit it as a bug report. Just keep in mind the following suggestions.

### Bugs & Issues

**Please create a fork of this [jsfiddle](http://jsfiddle.net/efp8z6Ln/) to demonstrate bugs.**

[Github Issues Tracker](https://github.com/Semantic-Org/Semantic-UI/issues) is used to track all upcoming milestones and changes to the project.

When submiting a bug report, please include a set of steps to reproduce the issue and any related information, browser, OS etc. If we can't see the issue then it will make solving things much more difficult.


If your bug uses a third party framework like Ember, Meteor, or Angular. Be sure to submit the issue to their respective issues boards. If you are confident the bug is part of the 'vanilla' SUI release, keep in mind not all maintainers are familiar with all framework and a simple test case is greatly appreciated.

If your bug is reproduced by a maintainer it will be asssigned the [`confirmed bug`](https://github.com/Semantic-Org/Semantic-UI/issues?q=is%3Aopen+is%3Aissue+label%3A%22Confirmed+Bug%22) tag. Browsing this tag is a good way to keep track of known issues with SUI.


### Upcoming Releases & Roadmap

As bugs and features are triaged they will be assigned to milestones. The best indication of when a change will land is to check the date on the  [upcoming milestones](https://github.com/Semantic-Org/Semantic-UI/milestones) page.

### Pull Requests

**All pull requests should be merged into the `next` branch.**

Anyone can jump on the issues board and grab off bugs to fix. This is probably the best way to become a contributor to Semantic. Be sure to adhere to the style guides when submitting code.

* [Create a Pull Request](https://github.com/Semantic-Org/Semantic-UI/compare)
* [View Open Issues](https://github.com/Semantic-Org/Semantic-UI/issues)
