/*!
 * # Semantic UI 2.2.1 - Modal
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,n,i,t){"use strict";n="undefined"!=typeof n&&n.Math==Math?n:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),e.fn.modal=function(o){var a,r=e(this),s=e(n),c=e(i),l=e("body"),d=r.selector||"",u=(new Date).getTime(),m=[],f=arguments[0],g="string"==typeof f,h=[].slice.call(arguments,1),v=n.requestAnimationFrame||n.mozRequestAnimationFrame||n.webkitRequestAnimationFrame||n.msRequestAnimationFrame||function(e){setTimeout(e,0)};return r.each(function(){var r,b,p,y,k,w,M,C,S,F=e.isPlainObject(o)?e.extend(!0,{},e.fn.modal.settings,o):e.extend({},e.fn.modal.settings),A=F.selector,D=F.className,H=F.namespace,T=F.error,x="."+H,z="module-"+H,O=e(this),q=e(F.context),E=O.find(A.close),j=this,P=O.data(z);S={initialize:function(){S.verbose("Initializing dimmer",q),S.create.id(),S.create.dimmer(),S.refreshModals(),S.bind.events(),F.observeChanges&&S.observeChanges(),S.instantiate()},instantiate:function(){S.verbose("Storing instance of modal"),P=S,O.data(z,P)},create:{dimmer:function(){var n={debug:F.debug,dimmerName:"modals",duration:{show:F.duration,hide:F.duration}},i=e.extend(!0,n,F.dimmerSettings);return F.inverted&&(i.variation=i.variation!==t?i.variation+" inverted":"inverted"),e.fn.dimmer===t?void S.error(T.dimmer):(S.debug("Creating dimmer with settings",i),y=q.dimmer(i),F.detachable?(S.verbose("Modal is detachable, moving content into dimmer"),y.dimmer("add content",O)):S.set.undetached(),F.blurring&&y.addClass(D.blurring),void(k=y.dimmer("get dimmer")))},id:function(){M=(Math.random().toString(16)+"000000000").substr(2,8),w="."+M,S.verbose("Creating unique id for element",M)}},destroy:function(){S.verbose("Destroying previous modal"),O.removeData(z).off(x),s.off(w),k.off(w),E.off(x),q.dimmer("destroy")},observeChanges:function(){"MutationObserver"in n&&(C=new MutationObserver(function(e){S.debug("DOM tree modified, refreshing"),S.refresh()}),C.observe(j,{childList:!0,subtree:!0}),S.debug("Setting up mutation observer",C))},refresh:function(){S.remove.scrolling(),S.cacheSizes(),S.set.screenHeight(),S.set.type(),S.set.position()},refreshModals:function(){b=O.siblings(A.modal),r=b.add(O)},attachEvents:function(n,i){var t=e(n);i=e.isFunction(S[i])?S[i]:S.toggle,t.length>0?(S.debug("Attaching modal events to element",n,i),t.off(x).on("click"+x,i)):S.error(T.notFound,n)},bind:{events:function(){S.verbose("Attaching events"),O.on("click"+x,A.close,S.event.close).on("click"+x,A.approve,S.event.approve).on("click"+x,A.deny,S.event.deny),s.on("resize"+w,S.event.resize)}},get:{id:function(){return(Math.random().toString(16)+"000000000").substr(2,8)}},event:{approve:function(){return F.onApprove.call(j,e(this))===!1?void S.verbose("Approve callback returned false cancelling hide"):void S.hide()},deny:function(){return F.onDeny.call(j,e(this))===!1?void S.verbose("Deny callback returned false cancelling hide"):void S.hide()},close:function(){S.hide()},click:function(n){var t=e(n.target),o=t.closest(A.modal).length>0,a=e.contains(i.documentElement,n.target);!o&&a&&(S.debug("Dimmer clicked, hiding all modals"),S.is.active()&&(S.remove.clickaway(),F.allowMultiple?S.hide():S.hideAll()))},debounce:function(e,n){clearTimeout(S.timer),S.timer=setTimeout(e,n)},keyboard:function(e){var n=e.which,i=27;n==i&&(F.closable?(S.debug("Escape key pressed hiding modal"),S.hide()):S.debug("Escape key pressed, but closable is set to false"),e.preventDefault())},resize:function(){y.dimmer("is active")&&v(S.refresh)}},toggle:function(){S.is.active()||S.is.animating()?S.hide():S.show()},show:function(n){n=e.isFunction(n)?n:function(){},S.refreshModals(),S.showModal(n)},hide:function(n){n=e.isFunction(n)?n:function(){},S.refreshModals(),S.hideModal(n)},showModal:function(n){n=e.isFunction(n)?n:function(){},S.is.animating()||!S.is.active()?(S.showDimmer(),S.cacheSizes(),S.set.position(),S.set.screenHeight(),S.set.type(),S.set.clickaway(),!F.allowMultiple&&S.others.active()?S.hideOthers(S.showModal):(F.onShow.call(j),F.transition&&e.fn.transition!==t&&O.transition("is supported")?(S.debug("Showing modal with css animations"),O.transition({debug:F.debug,animation:F.transition+" in",queue:F.queue,duration:F.duration,useFailSafe:!0,onComplete:function(){F.onVisible.apply(j),S.add.keyboardShortcuts(),S.save.focus(),S.set.active(),F.autofocus&&S.set.autofocus(),n()}})):S.error(T.noTransition))):S.debug("Modal is already visible")},hideModal:function(n,i){return n=e.isFunction(n)?n:function(){},S.debug("Hiding modal"),F.onHide.call(j,e(this))===!1?void S.verbose("Hide callback returned false cancelling hide"):void((S.is.animating()||S.is.active())&&(F.transition&&e.fn.transition!==t&&O.transition("is supported")?(S.remove.active(),O.transition({debug:F.debug,animation:F.transition+" out",queue:F.queue,duration:F.duration,useFailSafe:!0,onStart:function(){S.others.active()||i||S.hideDimmer(),S.remove.keyboardShortcuts()},onComplete:function(){F.onHidden.call(j),S.restore.focus(),n()}})):S.error(T.noTransition)))},showDimmer:function(){y.dimmer("is animating")||!y.dimmer("is active")?(S.debug("Showing dimmer"),y.dimmer("show")):S.debug("Dimmer already visible")},hideDimmer:function(){return y.dimmer("is animating")||y.dimmer("is active")?void y.dimmer("hide",function(){S.remove.clickaway(),S.remove.screenHeight()}):void S.debug("Dimmer is not visible cannot hide")},hideAll:function(n){var i=r.filter("."+D.active+", ."+D.animating);n=e.isFunction(n)?n:function(){},i.length>0&&(S.debug("Hiding all visible modals"),S.hideDimmer(),i.modal("hide modal",n))},hideOthers:function(n){var i=b.filter("."+D.active+", ."+D.animating);n=e.isFunction(n)?n:function(){},i.length>0&&(S.debug("Hiding other modals",b),i.modal("hide modal",n,!0))},others:{active:function(){return b.filter("."+D.active).length>0},animating:function(){return b.filter("."+D.animating).length>0}},add:{keyboardShortcuts:function(){S.verbose("Adding keyboard shortcuts"),c.on("keyup"+x,S.event.keyboard)}},save:{focus:function(){p=e(i.activeElement).blur()}},restore:{focus:function(){p&&p.length>0&&p.focus()}},remove:{active:function(){O.removeClass(D.active)},clickaway:function(){F.closable&&k.off("click"+w)},bodyStyle:function(){""===l.attr("style")&&(S.verbose("Removing style attribute"),l.removeAttr("style"))},screenHeight:function(){S.debug("Removing page height"),l.css("height","")},keyboardShortcuts:function(){S.verbose("Removing keyboard shortcuts"),c.off("keyup"+x)},scrolling:function(){y.removeClass(D.scrolling),O.removeClass(D.scrolling)}},cacheSizes:function(){var o=O.outerHeight();(S.cache===t||0!==o)&&(S.cache={pageHeight:e(i).outerHeight(),height:o+F.offset,contextHeight:"body"==F.context?e(n).height():y.height()}),S.debug("Caching modal and container sizes",S.cache)},can:{fit:function(){return S.cache.height+2*F.padding<S.cache.contextHeight}},is:{active:function(){return O.hasClass(D.active)},animating:function(){return O.transition("is supported")?O.transition("is animating"):O.is(":visible")},scrolling:function(){return y.hasClass(D.scrolling)},modernBrowser:function(){return!(n.ActiveXObject||"ActiveXObject"in n)}},set:{autofocus:function(){var e=O.find(":input").filter(":visible"),n=e.filter("[autofocus]"),i=n.length>0?n.first():e.first();i.length>0&&i.focus()},clickaway:function(){F.closable&&k.on("click"+w,S.event.click)},screenHeight:function(){S.can.fit()?l.css("height",""):(S.debug("Modal is taller than page content, resizing page height"),l.css("height",S.cache.height+2*F.padding))},active:function(){O.addClass(D.active)},scrolling:function(){y.addClass(D.scrolling),O.addClass(D.scrolling)},type:function(){S.can.fit()?(S.verbose("Modal fits on screen"),S.others.active()||S.others.animating()||S.remove.scrolling()):(S.verbose("Modal cannot fit on screen setting to scrolling"),S.set.scrolling())},position:function(){S.verbose("Centering modal on page",S.cache),S.can.fit()?O.css({top:"",marginTop:-(S.cache.height/2)}):O.css({marginTop:"",top:c.scrollTop()})},undetached:function(){y.addClass(D.undetached)}},setting:function(n,i){if(S.debug("Changing setting",n,i),e.isPlainObject(n))e.extend(!0,F,n);else{if(i===t)return F[n];e.isPlainObject(F[n])?e.extend(!0,F[n],i):F[n]=i}},internal:function(n,i){if(e.isPlainObject(n))e.extend(!0,S,n);else{if(i===t)return S[n];S[n]=i}},debug:function(){!F.silent&&F.debug&&(F.performance?S.performance.log(arguments):(S.debug=Function.prototype.bind.call(console.info,console,F.name+":"),S.debug.apply(console,arguments)))},verbose:function(){!F.silent&&F.verbose&&F.debug&&(F.performance?S.performance.log(arguments):(S.verbose=Function.prototype.bind.call(console.info,console,F.name+":"),S.verbose.apply(console,arguments)))},error:function(){F.silent||(S.error=Function.prototype.bind.call(console.error,console,F.name+":"),S.error.apply(console,arguments))},performance:{log:function(e){var n,i,t;F.performance&&(n=(new Date).getTime(),t=u||n,i=n-t,u=n,m.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:j,"Execution Time":i})),clearTimeout(S.performance.timer),S.performance.timer=setTimeout(S.performance.display,500)},display:function(){var n=F.name+":",i=0;u=!1,clearTimeout(S.performance.timer),e.each(m,function(e,n){i+=n["Execution Time"]}),n+=" "+i+"ms",d&&(n+=" '"+d+"'"),(console.group!==t||console.table!==t)&&m.length>0&&(console.groupCollapsed(n),console.table?console.table(m):e.each(m,function(e,n){console.log(n.Name+": "+n["Execution Time"]+"ms")}),console.groupEnd()),m=[]}},invoke:function(n,i,o){var r,s,c,l=P;return i=i||h,o=j||o,"string"==typeof n&&l!==t&&(n=n.split(/[\. ]/),r=n.length-1,e.each(n,function(i,o){var a=i!=r?o+n[i+1].charAt(0).toUpperCase()+n[i+1].slice(1):n;if(e.isPlainObject(l[a])&&i!=r)l=l[a];else{if(l[a]!==t)return s=l[a],!1;if(!e.isPlainObject(l[o])||i==r)return l[o]!==t?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(o,i):s!==t&&(c=s),e.isArray(a)?a.push(c):a!==t?a=[a,c]:c!==t&&(a=c),s}},g?(P===t&&S.initialize(),S.invoke(f)):(P!==t&&P.invoke("destroy"),S.initialize())}),a!==t?a:this},e.fn.modal.settings={name:"Modal",namespace:"modal",silent:!1,debug:!1,verbose:!1,performance:!0,observeChanges:!1,allowMultiple:!1,detachable:!0,closable:!0,autofocus:!0,inverted:!1,blurring:!1,dimmerSettings:{closable:!1,useCSS:!0},context:"body",queue:!1,duration:500,offset:0,transition:"scale",padding:50,onShow:function(){},onVisible:function(){},onHide:function(){return!0},onHidden:function(){},onApprove:function(){return!0},onDeny:function(){return!0},selector:{close:"> .close",approve:".actions .positive, .actions .approve, .actions .ok",deny:".actions .negative, .actions .deny, .actions .cancel",modal:".ui.modal"},error:{dimmer:"UI Dimmer, a required component is not included in this page",method:"The method you called is not defined.",notFound:"The element you specified could not be found"},className:{active:"active",animating:"animating",blurring:"blurring",scrolling:"scrolling",undetached:"undetached"}}}(jQuery,window,document);