/*!
 * # Semantic UI 2.2.10 - Visibility
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,o,n,t){"use strict";o="undefined"!=typeof o&&o.Math==Math?o:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),e.fn.visibility=function(i){var s,c=e(this),r=c.selector||"",a=(new Date).getTime(),l=[],d=arguments[0],u="string"==typeof d,f=[].slice.call(arguments,1),b=c.length,g=0;return c.each(function(){var c,m,v,p,h=e.isPlainObject(i)?e.extend(!0,{},e.fn.visibility.settings,i):e.extend({},e.fn.visibility.settings),P=h.className,x=h.namespace,C=h.error,y=h.metadata,S="."+x,R="module-"+x,V=e(o),k=e(this),T=e(h.context),O=(k.selector||"",k.data(R)),z=o.requestAnimationFrame||o.mozRequestAnimationFrame||o.webkitRequestAnimationFrame||o.msRequestAnimationFrame||function(e){setTimeout(e,0)},A=this,w=!1;p={initialize:function(){p.debug("Initializing",h),p.setup.cache(),p.should.trackChanges()&&("image"==h.type&&p.setup.image(),"fixed"==h.type&&p.setup.fixed(),h.observeChanges&&p.observeChanges(),p.bind.events()),p.save.position(),p.is.visible()||p.error(C.visible,k),h.initialCheck&&p.checkVisibility(),p.instantiate()},instantiate:function(){p.debug("Storing instance",p),k.data(R,p),O=p},destroy:function(){p.verbose("Destroying previous module"),v&&v.disconnect(),m&&m.disconnect(),V.off("load"+S,p.event.load).off("resize"+S,p.event.resize),T.off("scroll"+S,p.event.scroll).off("scrollchange"+S,p.event.scrollchange),"fixed"==h.type&&(p.resetFixed(),p.remove.placeholder()),k.off(S).removeData(R)},observeChanges:function(){"MutationObserver"in o&&(m=new MutationObserver(p.event.contextChanged),v=new MutationObserver(p.event.changed),m.observe(n,{childList:!0,subtree:!0}),v.observe(A,{childList:!0,subtree:!0}),p.debug("Setting up mutation observer",v))},bind:{events:function(){p.verbose("Binding visibility events to scroll and resize"),h.refreshOnLoad&&V.on("load"+S,p.event.load),V.on("resize"+S,p.event.resize),T.off("scroll"+S).on("scroll"+S,p.event.scroll).on("scrollchange"+S,p.event.scrollchange)}},event:{changed:function(e){p.verbose("DOM tree modified, updating visibility calculations"),p.timer=setTimeout(function(){p.verbose("DOM tree modified, updating sticky menu"),p.refresh()},100)},contextChanged:function(o){[].forEach.call(o,function(o){o.removedNodes&&[].forEach.call(o.removedNodes,function(o){(o==A||e(o).find(A).length>0)&&(p.debug("Element removed from DOM, tearing down events"),p.destroy())})})},resize:function(){p.debug("Window resized"),h.refreshOnResize&&z(p.refresh)},load:function(){p.debug("Page finished loading"),z(p.refresh)},scroll:function(){h.throttle?(clearTimeout(p.timer),p.timer=setTimeout(function(){T.triggerHandler("scrollchange"+S,[T.scrollTop()])},h.throttle)):z(function(){T.triggerHandler("scrollchange"+S,[T.scrollTop()])})},scrollchange:function(e,o){p.checkVisibility(o)}},precache:function(o,t){o instanceof Array||(o=[o]);for(var i=o.length,s=0,c=[],r=n.createElement("img"),a=function(){s++,s>=o.length&&e.isFunction(t)&&t()};i--;)r=n.createElement("img"),r.onload=a,r.onerror=a,r.src=o[i],c.push(r)},enableCallbacks:function(){p.debug("Allowing callbacks to occur"),w=!1},disableCallbacks:function(){p.debug("Disabling all callbacks temporarily"),w=!0},should:{trackChanges:function(){return u?(p.debug("One time query, no need to bind events"),!1):(p.debug("Callbacks being attached"),!0)}},setup:{cache:function(){p.cache={occurred:{},screen:{},element:{}}},image:function(){var e=k.data(y.src);e&&(p.verbose("Lazy loading image",e),h.once=!0,h.observeChanges=!1,h.onOnScreen=function(){p.debug("Image on screen",A),p.precache(e,function(){p.set.image(e,function(){g++,g==b&&h.onAllLoaded.call(this),h.onLoad.call(this)})})})},fixed:function(){p.debug("Setting up fixed"),h.once=!1,h.observeChanges=!1,h.initialCheck=!0,h.refreshOnLoad=!0,i.transition||(h.transition=!1),p.create.placeholder(),p.debug("Added placeholder",c),h.onTopPassed=function(){p.debug("Element passed, adding fixed position",k),p.show.placeholder(),p.set.fixed(),h.transition&&e.fn.transition!==t&&k.transition(h.transition,h.duration)},h.onTopPassedReverse=function(){p.debug("Element returned to position, removing fixed",k),p.hide.placeholder(),p.remove.fixed()}}},create:{placeholder:function(){p.verbose("Creating fixed position placeholder"),c=k.clone(!1).css("display","none").addClass(P.placeholder).insertAfter(k)}},show:{placeholder:function(){p.verbose("Showing placeholder"),c.css("display","block").css("visibility","hidden")}},hide:{placeholder:function(){p.verbose("Hiding placeholder"),c.css("display","none").css("visibility","")}},set:{fixed:function(){p.verbose("Setting element to fixed position"),k.addClass(P.fixed).css({position:"fixed",top:h.offset+"px",left:"auto",zIndex:h.zIndex}),h.onFixed.call(A)},image:function(o,n){if(k.attr("src",o),h.transition)if(e.fn.transition!==t){if(k.hasClass(P.visible))return void p.debug("Transition already occurred on this image, skipping animation");k.transition(h.transition,h.duration,n)}else k.fadeIn(h.duration,n);else k.show()}},is:{onScreen:function(){var e=p.get.elementCalculations();return e.onScreen},offScreen:function(){var e=p.get.elementCalculations();return e.offScreen},visible:function(){return p.cache&&p.cache.element?!(0===p.cache.element.width&&0===p.cache.element.offset.top):!1},verticallyScrollableContext:function(){var e=T.get(0)!==o?T.css("overflow-y"):!1;return"auto"==e||"scroll"==e},horizontallyScrollableContext:function(){var e=T.get(0)!==o?T.css("overflow-x"):!1;return"auto"==e||"scroll"==e}},refresh:function(){p.debug("Refreshing constants (width/height)"),"fixed"==h.type&&p.resetFixed(),p.reset(),p.save.position(),h.checkOnRefresh&&p.checkVisibility(),h.onRefresh.call(A)},resetFixed:function(){p.remove.fixed(),p.remove.occurred()},reset:function(){p.verbose("Resetting all cached values"),e.isPlainObject(p.cache)&&(p.cache.screen={},p.cache.element={})},checkVisibility:function(e){p.verbose("Checking visibility of element",p.cache.element),!w&&p.is.visible()&&(p.save.scroll(e),p.save.calculations(),p.passed(),p.passingReverse(),p.topVisibleReverse(),p.bottomVisibleReverse(),p.topPassedReverse(),p.bottomPassedReverse(),p.onScreen(),p.offScreen(),p.passing(),p.topVisible(),p.bottomVisible(),p.topPassed(),p.bottomPassed(),h.onUpdate&&h.onUpdate.call(A,p.get.elementCalculations()))},passed:function(o,n){var i=p.get.elementCalculations();if(o&&n)h.onPassed[o]=n;else{if(o!==t)return p.get.pixelsPassed(o)>i.pixelsPassed;i.passing&&e.each(h.onPassed,function(e,o){i.bottomVisible||i.pixelsPassed>p.get.pixelsPassed(e)?p.execute(o,e):h.once||p.remove.occurred(o)})}},onScreen:function(e){var o=p.get.elementCalculations(),n=e||h.onOnScreen,i="onScreen";return e&&(p.debug("Adding callback for onScreen",e),h.onOnScreen=e),o.onScreen?p.execute(n,i):h.once||p.remove.occurred(i),e!==t?o.onOnScreen:void 0},offScreen:function(e){var o=p.get.elementCalculations(),n=e||h.onOffScreen,i="offScreen";return e&&(p.debug("Adding callback for offScreen",e),h.onOffScreen=e),o.offScreen?p.execute(n,i):h.once||p.remove.occurred(i),e!==t?o.onOffScreen:void 0},passing:function(e){var o=p.get.elementCalculations(),n=e||h.onPassing,i="passing";return e&&(p.debug("Adding callback for passing",e),h.onPassing=e),o.passing?p.execute(n,i):h.once||p.remove.occurred(i),e!==t?o.passing:void 0},topVisible:function(e){var o=p.get.elementCalculations(),n=e||h.onTopVisible,i="topVisible";return e&&(p.debug("Adding callback for top visible",e),h.onTopVisible=e),o.topVisible?p.execute(n,i):h.once||p.remove.occurred(i),e===t?o.topVisible:void 0},bottomVisible:function(e){var o=p.get.elementCalculations(),n=e||h.onBottomVisible,i="bottomVisible";return e&&(p.debug("Adding callback for bottom visible",e),h.onBottomVisible=e),o.bottomVisible?p.execute(n,i):h.once||p.remove.occurred(i),e===t?o.bottomVisible:void 0},topPassed:function(e){var o=p.get.elementCalculations(),n=e||h.onTopPassed,i="topPassed";return e&&(p.debug("Adding callback for top passed",e),h.onTopPassed=e),o.topPassed?p.execute(n,i):h.once||p.remove.occurred(i),e===t?o.topPassed:void 0},bottomPassed:function(e){var o=p.get.elementCalculations(),n=e||h.onBottomPassed,i="bottomPassed";return e&&(p.debug("Adding callback for bottom passed",e),h.onBottomPassed=e),o.bottomPassed?p.execute(n,i):h.once||p.remove.occurred(i),e===t?o.bottomPassed:void 0},passingReverse:function(e){var o=p.get.elementCalculations(),n=e||h.onPassingReverse,i="passingReverse";return e&&(p.debug("Adding callback for passing reverse",e),h.onPassingReverse=e),o.passing?h.once||p.remove.occurred(i):p.get.occurred("passing")&&p.execute(n,i),e!==t?!o.passing:void 0},topVisibleReverse:function(e){var o=p.get.elementCalculations(),n=e||h.onTopVisibleReverse,i="topVisibleReverse";return e&&(p.debug("Adding callback for top visible reverse",e),h.onTopVisibleReverse=e),o.topVisible?h.once||p.remove.occurred(i):p.get.occurred("topVisible")&&p.execute(n,i),e===t?!o.topVisible:void 0},bottomVisibleReverse:function(e){var o=p.get.elementCalculations(),n=e||h.onBottomVisibleReverse,i="bottomVisibleReverse";return e&&(p.debug("Adding callback for bottom visible reverse",e),h.onBottomVisibleReverse=e),o.bottomVisible?h.once||p.remove.occurred(i):p.get.occurred("bottomVisible")&&p.execute(n,i),e===t?!o.bottomVisible:void 0},topPassedReverse:function(e){var o=p.get.elementCalculations(),n=e||h.onTopPassedReverse,i="topPassedReverse";return e&&(p.debug("Adding callback for top passed reverse",e),h.onTopPassedReverse=e),o.topPassed?h.once||p.remove.occurred(i):p.get.occurred("topPassed")&&p.execute(n,i),e===t?!o.onTopPassed:void 0},bottomPassedReverse:function(e){var o=p.get.elementCalculations(),n=e||h.onBottomPassedReverse,i="bottomPassedReverse";return e&&(p.debug("Adding callback for bottom passed reverse",e),h.onBottomPassedReverse=e),o.bottomPassed?h.once||p.remove.occurred(i):p.get.occurred("bottomPassed")&&p.execute(n,i),e===t?!o.bottomPassed:void 0},execute:function(e,o){var n=p.get.elementCalculations(),t=p.get.screenCalculations();e=e||!1,e&&(h.continuous?(p.debug("Callback being called continuously",o,n),e.call(A,n,t)):p.get.occurred(o)||(p.debug("Conditions met",o,n),e.call(A,n,t))),p.save.occurred(o)},remove:{fixed:function(){p.debug("Removing fixed position"),k.removeClass(P.fixed).css({position:"",top:"",left:"",zIndex:""}),h.onUnfixed.call(A)},placeholder:function(){p.debug("Removing placeholder content"),c&&c.remove()},occurred:function(e){if(e){var o=p.cache.occurred;o[e]!==t&&o[e]===!0&&(p.debug("Callback can now be called again",e),p.cache.occurred[e]=!1)}else p.cache.occurred={}}},save:{calculations:function(){p.verbose("Saving all calculations necessary to determine positioning"),p.save.direction(),p.save.screenCalculations(),p.save.elementCalculations()},occurred:function(e){e&&(p.cache.occurred[e]!==t&&p.cache.occurred[e]===!0||(p.verbose("Saving callback occurred",e),p.cache.occurred[e]=!0))},scroll:function(e){e=e+h.offset||T.scrollTop()+h.offset,p.cache.scroll=e},direction:function(){var e,o=p.get.scroll(),n=p.get.lastScroll();return e=o>n&&n?"down":n>o&&n?"up":"static",p.cache.direction=e,p.cache.direction},elementPosition:function(){var e=p.cache.element,o=p.get.screenSize();return p.verbose("Saving element position"),e.fits=e.height<o.height,e.offset=k.offset(),e.width=k.outerWidth(),e.height=k.outerHeight(),p.is.verticallyScrollableContext()&&(e.offset.top+=T.scrollTop()-T.offset().top),p.is.horizontallyScrollableContext()&&(e.offset.left+=T.scrollLeft-T.offset().left),p.cache.element=e,e},elementCalculations:function(){var e=p.get.screenCalculations(),o=p.get.elementPosition();return h.includeMargin?(o.margin={},o.margin.top=parseInt(k.css("margin-top"),10),o.margin.bottom=parseInt(k.css("margin-bottom"),10),o.top=o.offset.top-o.margin.top,o.bottom=o.offset.top+o.height+o.margin.bottom):(o.top=o.offset.top,o.bottom=o.offset.top+o.height),o.topPassed=e.top>=o.top,o.bottomPassed=e.top>=o.bottom,o.topVisible=e.bottom>=o.top&&!o.bottomPassed,o.bottomVisible=e.bottom>=o.bottom&&!o.topPassed,o.pixelsPassed=0,o.percentagePassed=0,o.onScreen=o.topVisible&&!o.bottomPassed,o.passing=o.topPassed&&!o.bottomPassed,o.offScreen=!o.onScreen,o.passing&&(o.pixelsPassed=e.top-o.top,o.percentagePassed=(e.top-o.top)/o.height),p.cache.element=o,p.verbose("Updated element calculations",o),o},screenCalculations:function(){var e=p.get.scroll();return p.save.direction(),p.cache.screen.top=e,p.cache.screen.bottom=e+p.cache.screen.height,p.cache.screen},screenSize:function(){p.verbose("Saving window position"),p.cache.screen={height:T.height()}},position:function(){p.save.screenSize(),p.save.elementPosition()}},get:{pixelsPassed:function(e){var o=p.get.elementCalculations();return e.search("%")>-1?o.height*(parseInt(e,10)/100):parseInt(e,10)},occurred:function(e){return p.cache.occurred!==t?p.cache.occurred[e]||!1:!1},direction:function(){return p.cache.direction===t&&p.save.direction(),p.cache.direction},elementPosition:function(){return p.cache.element===t&&p.save.elementPosition(),p.cache.element},elementCalculations:function(){return p.cache.element===t&&p.save.elementCalculations(),p.cache.element},screenCalculations:function(){return p.cache.screen===t&&p.save.screenCalculations(),p.cache.screen},screenSize:function(){return p.cache.screen===t&&p.save.screenSize(),p.cache.screen},scroll:function(){return p.cache.scroll===t&&p.save.scroll(),p.cache.scroll},lastScroll:function(){return p.cache.screen===t?(p.debug("First scroll event, no last scroll could be found"),!1):p.cache.screen.top}},setting:function(o,n){if(e.isPlainObject(o))e.extend(!0,h,o);else{if(n===t)return h[o];h[o]=n}},internal:function(o,n){if(e.isPlainObject(o))e.extend(!0,p,o);else{if(n===t)return p[o];p[o]=n}},debug:function(){!h.silent&&h.debug&&(h.performance?p.performance.log(arguments):(p.debug=Function.prototype.bind.call(console.info,console,h.name+":"),p.debug.apply(console,arguments)))},verbose:function(){!h.silent&&h.verbose&&h.debug&&(h.performance?p.performance.log(arguments):(p.verbose=Function.prototype.bind.call(console.info,console,h.name+":"),p.verbose.apply(console,arguments)))},error:function(){h.silent||(p.error=Function.prototype.bind.call(console.error,console,h.name+":"),p.error.apply(console,arguments))},performance:{log:function(e){var o,n,t;h.performance&&(o=(new Date).getTime(),t=a||o,n=o-t,a=o,l.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:A,"Execution Time":n})),clearTimeout(p.performance.timer),p.performance.timer=setTimeout(p.performance.display,500)},display:function(){var o=h.name+":",n=0;a=!1,clearTimeout(p.performance.timer),e.each(l,function(e,o){n+=o["Execution Time"]}),o+=" "+n+"ms",r&&(o+=" '"+r+"'"),(console.group!==t||console.table!==t)&&l.length>0&&(console.groupCollapsed(o),console.table?console.table(l):e.each(l,function(e,o){console.log(o.Name+": "+o["Execution Time"]+"ms")}),console.groupEnd()),l=[]}},invoke:function(o,n,i){var c,r,a,l=O;return n=n||f,i=A||i,"string"==typeof o&&l!==t&&(o=o.split(/[\. ]/),c=o.length-1,e.each(o,function(n,i){var s=n!=c?i+o[n+1].charAt(0).toUpperCase()+o[n+1].slice(1):o;if(e.isPlainObject(l[s])&&n!=c)l=l[s];else{if(l[s]!==t)return r=l[s],!1;if(!e.isPlainObject(l[i])||n==c)return l[i]!==t?(r=l[i],!1):(p.error(C.method,o),!1);l=l[i]}})),e.isFunction(r)?a=r.apply(i,n):r!==t&&(a=r),e.isArray(s)?s.push(a):s!==t?s=[s,a]:a!==t&&(s=a),r}},u?(O===t&&p.initialize(),O.save.scroll(),O.save.calculations(),p.invoke(d)):(O!==t&&O.invoke("destroy"),p.initialize())}),s!==t?s:this},e.fn.visibility.settings={name:"Visibility",namespace:"visibility",debug:!1,verbose:!1,performance:!0,observeChanges:!0,initialCheck:!0,refreshOnLoad:!0,refreshOnResize:!0,checkOnRefresh:!0,once:!0,continuous:!1,offset:0,includeMargin:!1,context:o,throttle:!1,type:!1,zIndex:"10",transition:"fade in",duration:1e3,onPassed:{},onOnScreen:!1,onOffScreen:!1,onPassing:!1,onTopVisible:!1,onBottomVisible:!1,onTopPassed:!1,onBottomPassed:!1,onPassingReverse:!1,onTopVisibleReverse:!1,onBottomVisibleReverse:!1,onTopPassedReverse:!1,onBottomPassedReverse:!1,onLoad:function(){},onAllLoaded:function(){},onFixed:function(){},onUnfixed:function(){},onUpdate:!1,onRefresh:function(){},metadata:{src:"src"},className:{fixed:"fixed",placeholder:"placeholder",visible:"visible"},error:{method:"The method you called is not defined.",visible:"Element is hidden, you must call refresh after element becomes visible"}}}(jQuery,window,document);