/*!
 * # Semantic UI 2.2.2 - Visibility
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,n,o,t){"use strict";n="undefined"!=typeof n&&n.Math==Math?n:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),e.fn.visibility=function(i){var s,c=e(this),r=c.selector||"",a=(new Date).getTime(),l=[],d=arguments[0],u="string"==typeof d,f=[].slice.call(arguments,1),m=c.length,g=0;return c.each(function(){var c,b,v,p,h=e.isPlainObject(i)?e.extend(!0,{},e.fn.visibility.settings,i):e.extend({},e.fn.visibility.settings),P=h.className,x=h.namespace,C=h.error,y=h.metadata,R="."+x,V="module-"+x,S=e(n),k=e(this),T=e(h.context),O=(k.selector||"",k.data(V)),A=n.requestAnimationFrame||n.mozRequestAnimationFrame||n.webkitRequestAnimationFrame||n.msRequestAnimationFrame||function(e){setTimeout(e,0)},z=this,w=!1;p={initialize:function(){p.debug("Initializing",h),p.setup.cache(),p.should.trackChanges()&&("image"==h.type&&p.setup.image(),"fixed"==h.type&&p.setup.fixed(),h.observeChanges&&p.observeChanges(),p.bind.events()),p.save.position(),p.is.visible()||p.error(C.visible,k),h.initialCheck&&p.checkVisibility(),p.instantiate()},instantiate:function(){p.debug("Storing instance",p),k.data(V,p),O=p},destroy:function(){p.verbose("Destroying previous module"),v&&v.disconnect(),b&&b.disconnect(),S.off("load"+R,p.event.load).off("resize"+R,p.event.resize),T.off("scroll"+R,p.event.scroll).off("scrollchange"+R,p.event.scrollchange),"fixed"==h.type&&(p.resetFixed(),p.remove.placeholder()),k.off(R).removeData(V)},observeChanges:function(){"MutationObserver"in n&&(b=new MutationObserver(p.event.contextChanged),v=new MutationObserver(p.event.changed),b.observe(o,{childList:!0,subtree:!0}),v.observe(z,{childList:!0,subtree:!0}),p.debug("Setting up mutation observer",v))},bind:{events:function(){p.verbose("Binding visibility events to scroll and resize"),h.refreshOnLoad&&S.on("load"+R,p.event.load),S.on("resize"+R,p.event.resize),T.off("scroll"+R).on("scroll"+R,p.event.scroll).on("scrollchange"+R,p.event.scrollchange)}},event:{changed:function(e){p.verbose("DOM tree modified, updating visibility calculations"),p.timer=setTimeout(function(){p.verbose("DOM tree modified, updating sticky menu"),p.refresh()},100)},contextChanged:function(n){[].forEach.call(n,function(n){n.removedNodes&&[].forEach.call(n.removedNodes,function(n){(n==z||e(n).find(z).length>0)&&(p.debug("Element removed from DOM, tearing down events"),p.destroy())})})},resize:function(){p.debug("Window resized"),h.refreshOnResize&&A(p.refresh)},load:function(){p.debug("Page finished loading"),A(p.refresh)},scroll:function(){h.throttle?(clearTimeout(p.timer),p.timer=setTimeout(function(){T.triggerHandler("scrollchange"+R,[T.scrollTop()])},h.throttle)):A(function(){T.triggerHandler("scrollchange"+R,[T.scrollTop()])})},scrollchange:function(e,n){p.checkVisibility(n)}},precache:function(n,t){n instanceof Array||(n=[n]);for(var i=n.length,s=0,c=[],r=o.createElement("img"),a=function(){s++,s>=n.length&&e.isFunction(t)&&t()};i--;)r=o.createElement("img"),r.onload=a,r.onerror=a,r.src=n[i],c.push(r)},enableCallbacks:function(){p.debug("Allowing callbacks to occur"),w=!1},disableCallbacks:function(){p.debug("Disabling all callbacks temporarily"),w=!0},should:{trackChanges:function(){return u?(p.debug("One time query, no need to bind events"),!1):(p.debug("Callbacks being attached"),!0)}},setup:{cache:function(){p.cache={occurred:{},screen:{},element:{}}},image:function(){var e=k.data(y.src);e&&(p.verbose("Lazy loading image",e),h.once=!0,h.observeChanges=!1,h.onOnScreen=function(){p.debug("Image on screen",z),p.precache(e,function(){p.set.image(e,function(){g++,g==m&&h.onAllLoaded.call(this),h.onLoad.call(this)})})})},fixed:function(){p.debug("Setting up fixed"),h.once=!1,h.observeChanges=!1,h.initialCheck=!0,h.refreshOnLoad=!0,i.transition||(h.transition=!1),p.create.placeholder(),p.debug("Added placeholder",c),h.onTopPassed=function(){p.debug("Element passed, adding fixed position",k),p.show.placeholder(),p.set.fixed(),h.transition&&e.fn.transition!==t&&k.transition(h.transition,h.duration)},h.onTopPassedReverse=function(){p.debug("Element returned to position, removing fixed",k),p.hide.placeholder(),p.remove.fixed()}}},create:{placeholder:function(){p.verbose("Creating fixed position placeholder"),c=k.clone(!1).css("display","none").addClass(P.placeholder).insertAfter(k)}},show:{placeholder:function(){p.verbose("Showing placeholder"),c.css("display","block").css("visibility","hidden")}},hide:{placeholder:function(){p.verbose("Hiding placeholder"),c.css("display","none").css("visibility","")}},set:{fixed:function(){p.verbose("Setting element to fixed position"),k.addClass(P.fixed).css({position:"fixed",top:h.offset+"px",left:"auto",zIndex:h.zIndex}),h.onFixed.call(z)},image:function(n,o){k.attr("src",n),h.transition?e.fn.transition!==t?k.transition(h.transition,h.duration,o):k.fadeIn(h.duration,o):k.show()}},is:{onScreen:function(){var e=p.get.elementCalculations();return e.onScreen},offScreen:function(){var e=p.get.elementCalculations();return e.offScreen},visible:function(){return p.cache&&p.cache.element?!(0===p.cache.element.width&&0===p.cache.element.offset.top):!1}},refresh:function(){p.debug("Refreshing constants (width/height)"),"fixed"==h.type&&p.resetFixed(),p.reset(),p.save.position(),h.checkOnRefresh&&p.checkVisibility(),h.onRefresh.call(z)},resetFixed:function(){p.remove.fixed(),p.remove.occurred()},reset:function(){p.verbose("Resetting all cached values"),e.isPlainObject(p.cache)&&(p.cache.screen={},p.cache.element={})},checkVisibility:function(e){p.verbose("Checking visibility of element",p.cache.element),!w&&p.is.visible()&&(p.save.scroll(e),p.save.calculations(),p.passed(),p.passingReverse(),p.topVisibleReverse(),p.bottomVisibleReverse(),p.topPassedReverse(),p.bottomPassedReverse(),p.onScreen(),p.offScreen(),p.passing(),p.topVisible(),p.bottomVisible(),p.topPassed(),p.bottomPassed(),h.onUpdate&&h.onUpdate.call(z,p.get.elementCalculations()))},passed:function(n,o){var i=p.get.elementCalculations();if(n&&o)h.onPassed[n]=o;else{if(n!==t)return p.get.pixelsPassed(n)>i.pixelsPassed;i.passing&&e.each(h.onPassed,function(e,n){i.bottomVisible||i.pixelsPassed>p.get.pixelsPassed(e)?p.execute(n,e):h.once||p.remove.occurred(n)})}},onScreen:function(e){var n=p.get.elementCalculations(),o=e||h.onOnScreen,i="onScreen";return e&&(p.debug("Adding callback for onScreen",e),h.onOnScreen=e),n.onScreen?p.execute(o,i):h.once||p.remove.occurred(i),e!==t?n.onOnScreen:void 0},offScreen:function(e){var n=p.get.elementCalculations(),o=e||h.onOffScreen,i="offScreen";return e&&(p.debug("Adding callback for offScreen",e),h.onOffScreen=e),n.offScreen?p.execute(o,i):h.once||p.remove.occurred(i),e!==t?n.onOffScreen:void 0},passing:function(e){var n=p.get.elementCalculations(),o=e||h.onPassing,i="passing";return e&&(p.debug("Adding callback for passing",e),h.onPassing=e),n.passing?p.execute(o,i):h.once||p.remove.occurred(i),e!==t?n.passing:void 0},topVisible:function(e){var n=p.get.elementCalculations(),o=e||h.onTopVisible,i="topVisible";return e&&(p.debug("Adding callback for top visible",e),h.onTopVisible=e),n.topVisible?p.execute(o,i):h.once||p.remove.occurred(i),e===t?n.topVisible:void 0},bottomVisible:function(e){var n=p.get.elementCalculations(),o=e||h.onBottomVisible,i="bottomVisible";return e&&(p.debug("Adding callback for bottom visible",e),h.onBottomVisible=e),n.bottomVisible?p.execute(o,i):h.once||p.remove.occurred(i),e===t?n.bottomVisible:void 0},topPassed:function(e){var n=p.get.elementCalculations(),o=e||h.onTopPassed,i="topPassed";return e&&(p.debug("Adding callback for top passed",e),h.onTopPassed=e),n.topPassed?p.execute(o,i):h.once||p.remove.occurred(i),e===t?n.topPassed:void 0},bottomPassed:function(e){var n=p.get.elementCalculations(),o=e||h.onBottomPassed,i="bottomPassed";return e&&(p.debug("Adding callback for bottom passed",e),h.onBottomPassed=e),n.bottomPassed?p.execute(o,i):h.once||p.remove.occurred(i),e===t?n.bottomPassed:void 0},passingReverse:function(e){var n=p.get.elementCalculations(),o=e||h.onPassingReverse,i="passingReverse";return e&&(p.debug("Adding callback for passing reverse",e),h.onPassingReverse=e),n.passing?h.once||p.remove.occurred(i):p.get.occurred("passing")&&p.execute(o,i),e!==t?!n.passing:void 0},topVisibleReverse:function(e){var n=p.get.elementCalculations(),o=e||h.onTopVisibleReverse,i="topVisibleReverse";return e&&(p.debug("Adding callback for top visible reverse",e),h.onTopVisibleReverse=e),n.topVisible?h.once||p.remove.occurred(i):p.get.occurred("topVisible")&&p.execute(o,i),e===t?!n.topVisible:void 0},bottomVisibleReverse:function(e){var n=p.get.elementCalculations(),o=e||h.onBottomVisibleReverse,i="bottomVisibleReverse";return e&&(p.debug("Adding callback for bottom visible reverse",e),h.onBottomVisibleReverse=e),n.bottomVisible?h.once||p.remove.occurred(i):p.get.occurred("bottomVisible")&&p.execute(o,i),e===t?!n.bottomVisible:void 0},topPassedReverse:function(e){var n=p.get.elementCalculations(),o=e||h.onTopPassedReverse,i="topPassedReverse";return e&&(p.debug("Adding callback for top passed reverse",e),h.onTopPassedReverse=e),n.topPassed?h.once||p.remove.occurred(i):p.get.occurred("topPassed")&&p.execute(o,i),e===t?!n.onTopPassed:void 0},bottomPassedReverse:function(e){var n=p.get.elementCalculations(),o=e||h.onBottomPassedReverse,i="bottomPassedReverse";return e&&(p.debug("Adding callback for bottom passed reverse",e),h.onBottomPassedReverse=e),n.bottomPassed?h.once||p.remove.occurred(i):p.get.occurred("bottomPassed")&&p.execute(o,i),e===t?!n.bottomPassed:void 0},execute:function(e,n){var o=p.get.elementCalculations(),t=p.get.screenCalculations();e=e||!1,e&&(h.continuous?(p.debug("Callback being called continuously",n,o),e.call(z,o,t)):p.get.occurred(n)||(p.debug("Conditions met",n,o),e.call(z,o,t))),p.save.occurred(n)},remove:{fixed:function(){p.debug("Removing fixed position"),k.removeClass(P.fixed).css({position:"",top:"",left:"",zIndex:""}),h.onUnfixed.call(z)},placeholder:function(){p.debug("Removing placeholder content"),c&&c.remove()},occurred:function(e){if(e){var n=p.cache.occurred;n[e]!==t&&n[e]===!0&&(p.debug("Callback can now be called again",e),p.cache.occurred[e]=!1)}else p.cache.occurred={}}},save:{calculations:function(){p.verbose("Saving all calculations necessary to determine positioning"),p.save.direction(),p.save.screenCalculations(),p.save.elementCalculations()},occurred:function(e){e&&(p.cache.occurred[e]===t||p.cache.occurred[e]!==!0)&&(p.verbose("Saving callback occurred",e),p.cache.occurred[e]=!0)},scroll:function(e){e=e+h.offset||T.scrollTop()+h.offset,p.cache.scroll=e},direction:function(){var e,n=p.get.scroll(),o=p.get.lastScroll();return e=n>o&&o?"down":o>n&&o?"up":"static",p.cache.direction=e,p.cache.direction},elementPosition:function(){var e=p.cache.element,n=p.get.screenSize();return p.verbose("Saving element position"),e.fits=e.height<n.height,e.offset=k.offset(),e.width=k.outerWidth(),e.height=k.outerHeight(),p.cache.element=e,e},elementCalculations:function(){var e=p.get.screenCalculations(),n=p.get.elementPosition();return h.includeMargin?(n.margin={},n.margin.top=parseInt(k.css("margin-top"),10),n.margin.bottom=parseInt(k.css("margin-bottom"),10),n.top=n.offset.top-n.margin.top,n.bottom=n.offset.top+n.height+n.margin.bottom):(n.top=n.offset.top,n.bottom=n.offset.top+n.height),n.topVisible=e.bottom>=n.top,n.topPassed=e.top>=n.top,n.bottomVisible=e.bottom>=n.bottom,n.bottomPassed=e.top>=n.bottom,n.pixelsPassed=0,n.percentagePassed=0,n.onScreen=n.topVisible&&!n.bottomPassed,n.passing=n.topPassed&&!n.bottomPassed,n.offScreen=!n.onScreen,n.passing&&(n.pixelsPassed=e.top-n.top,n.percentagePassed=(e.top-n.top)/n.height),p.cache.element=n,p.verbose("Updated element calculations",n),n},screenCalculations:function(){var e=p.get.scroll();return p.save.direction(),p.cache.screen.top=e,p.cache.screen.bottom=e+p.cache.screen.height,p.cache.screen},screenSize:function(){p.verbose("Saving window position"),p.cache.screen={height:T.height()}},position:function(){p.save.screenSize(),p.save.elementPosition()}},get:{pixelsPassed:function(e){var n=p.get.elementCalculations();return e.search("%")>-1?n.height*(parseInt(e,10)/100):parseInt(e,10)},occurred:function(e){return p.cache.occurred!==t?p.cache.occurred[e]||!1:!1},direction:function(){return p.cache.direction===t&&p.save.direction(),p.cache.direction},elementPosition:function(){return p.cache.element===t&&p.save.elementPosition(),p.cache.element},elementCalculations:function(){return p.cache.element===t&&p.save.elementCalculations(),p.cache.element},screenCalculations:function(){return p.cache.screen===t&&p.save.screenCalculations(),p.cache.screen},screenSize:function(){return p.cache.screen===t&&p.save.screenSize(),p.cache.screen},scroll:function(){return p.cache.scroll===t&&p.save.scroll(),p.cache.scroll},lastScroll:function(){return p.cache.screen===t?(p.debug("First scroll event, no last scroll could be found"),!1):p.cache.screen.top}},setting:function(n,o){if(e.isPlainObject(n))e.extend(!0,h,n);else{if(o===t)return h[n];h[n]=o}},internal:function(n,o){if(e.isPlainObject(n))e.extend(!0,p,n);else{if(o===t)return p[n];p[n]=o}},debug:function(){!h.silent&&h.debug&&(h.performance?p.performance.log(arguments):(p.debug=Function.prototype.bind.call(console.info,console,h.name+":"),p.debug.apply(console,arguments)))},verbose:function(){!h.silent&&h.verbose&&h.debug&&(h.performance?p.performance.log(arguments):(p.verbose=Function.prototype.bind.call(console.info,console,h.name+":"),p.verbose.apply(console,arguments)))},error:function(){h.silent||(p.error=Function.prototype.bind.call(console.error,console,h.name+":"),p.error.apply(console,arguments))},performance:{log:function(e){var n,o,t;h.performance&&(n=(new Date).getTime(),t=a||n,o=n-t,a=n,l.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:z,"Execution Time":o})),clearTimeout(p.performance.timer),p.performance.timer=setTimeout(p.performance.display,500)},display:function(){var n=h.name+":",o=0;a=!1,clearTimeout(p.performance.timer),e.each(l,function(e,n){o+=n["Execution Time"]}),n+=" "+o+"ms",r&&(n+=" '"+r+"'"),(console.group!==t||console.table!==t)&&l.length>0&&(console.groupCollapsed(n),console.table?console.table(l):e.each(l,function(e,n){console.log(n.Name+": "+n["Execution Time"]+"ms")}),console.groupEnd()),l=[]}},invoke:function(n,o,i){var c,r,a,l=O;return o=o||f,i=z||i,"string"==typeof n&&l!==t&&(n=n.split(/[\. ]/),c=n.length-1,e.each(n,function(o,i){var s=o!=c?i+n[o+1].charAt(0).toUpperCase()+n[o+1].slice(1):n;if(e.isPlainObject(l[s])&&o!=c)l=l[s];else{if(l[s]!==t)return r=l[s],!1;if(!e.isPlainObject(l[i])||o==c)return l[i]!==t?(r=l[i],!1):(p.error(C.method,n),!1);l=l[i]}})),e.isFunction(r)?a=r.apply(i,o):r!==t&&(a=r),e.isArray(s)?s.push(a):s!==t?s=[s,a]:a!==t&&(s=a),r}},u?(O===t&&p.initialize(),O.save.scroll(),O.save.calculations(),p.invoke(d)):(O!==t&&O.invoke("destroy"),p.initialize())}),s!==t?s:this},e.fn.visibility.settings={name:"Visibility",namespace:"visibility",debug:!1,verbose:!1,performance:!0,observeChanges:!0,initialCheck:!0,refreshOnLoad:!0,refreshOnResize:!0,checkOnRefresh:!0,once:!0,continuous:!1,offset:0,includeMargin:!1,context:n,throttle:!1,type:!1,zIndex:"10",transition:"fade in",duration:1e3,onPassed:{},onOnScreen:!1,onOffScreen:!1,onPassing:!1,onTopVisible:!1,onBottomVisible:!1,onTopPassed:!1,onBottomPassed:!1,onPassingReverse:!1,onTopVisibleReverse:!1,onBottomVisibleReverse:!1,onTopPassedReverse:!1,onBottomPassedReverse:!1,onLoad:function(){},onAllLoaded:function(){},onFixed:function(){},onUnfixed:function(){},onUpdate:!1,onRefresh:function(){},metadata:{src:"src"},className:{fixed:"fixed",placeholder:"placeholder"},error:{method:"The method you called is not defined.",visible:"Element is hidden, you must call refresh after element becomes visible"}}}(jQuery,window,document);