'use strict';

angular
  .module('demoApp', [
    'ngAnimate',
    'ui.router',
    'ngMessages',
    'ngMaterial',
    'smDateTimeRangePicker'
  ])
  .run(function($http,$templateCache) {
      $http.get("views/massages.html")
      .then(function(response) {
        $templateCache.put('error-messages', response.data); 
      })
     }) 
.config(function ($stateProvider, $urlRouterProvider,$mdThemingProvider,pickerProvider) {

    pickerProvider.setDayHeader('single');

    pickerProvider.setOkLabel('Save');
    
    $urlRouterProvider.otherwise('/home');

    $stateProvider.state('home', {
            url: '/home',  
            templateUrl: 'views/home.html',
            controller: 'MainCtrl',
            controllerAs : 'vm',
            data: {
                title: 'Dashboard',
            }            
    }).state('date-time-picker', {
            url: '/date-time-picker-demo',  
            templateUrl: 'views/date-time-picker-demo.html',
            controller: 'MainCtrl',
            controllerAs : 'vm',
            data: {
                title: 'Date Time Picker Demo',
            }            
    }).state('date-time-picker-api', {
            url: '/date-time-picker-api',  
            templateUrl: 'views/date-time-picker-api.html',
            controller: 'MainCtrl',
            controllerAs : 'vm',
            data: {
                title: 'Date Time Picker API',
            }            
    }).state('range-picker-demo', {
            url: '/range-picker-demo',  
            templateUrl: 'views/range-picker-demo.html',
            controller: 'MainCtrl',
            controllerAs : 'vm',
            data: {
                title: 'Range Picker Demo',
            }            
    }).state('range-picker-api', {
            url: '/range-picker-api',  
            templateUrl: 'views/range-picker-api.html',
            controller: 'MainCtrl',
            controllerAs : 'vm',
            data: {
                title: 'Range Picker API',
            }            
    }).state('timepicker', {
            url: '/timepicker',  
            templateUrl: 'views/timepicker.html',
            controller: 'MainCtrl',
            controllerAs : 'vm',
            data: {
                title: 'Range Picker API',
            }            
    }).state('time-picker-demo', {
            url: '/time-picker-demo',  
            templateUrl: 'views/time-picker-demo.html',
            controller: 'MainCtrl',
            controllerAs : 'vm',
            data: {
                title: 'Range Picker API',
            }            
    }).state('time-picker-api', {
            url: '/time-picker-api',  
            templateUrl: 'views/time-picker-api.html',
            controller: 'MainCtrl',
            controllerAs : 'vm',
            data: {
                title: 'Range Picker API',
            }            
    });
   



    $mdThemingProvider.theme('default')
        .primaryPalette('green');
  });
    
'use strict';

     function MainCtrl($scope,$timeout, $mdSidenav, $mdUtil, $log,$state,$mdDialog,smDateTimePicker) {
        var vm = this;
        vm.minDate = moment().add(10,'d').format('MM-DD-YYYY');
        vm.maxDate = moment().add(1,'M').format('MM-DD-YYYY');
        vm.dateOfBirth = moment().add(10,'d').format('MM-DD-YYYY HH:mm');

        vm.hours = [1,2,3,4,5,6,7,8,9,10,11,12];

        vm.overrideList = [{
          position:1,
          label:'Custom',
          startDate: moment(),
          endDate: moment()
        }]

        vm.dateSelected = function(date){


          vm.callBackValue = date;
        }

        vm.changeModelValue = function(){
          $scope.$apply(function(){
            vm.dateOfBirth = moment();
          });
        }

        vm.currentDate = '10-15-2015';  
        var options = {
          mode : 'date',
          view : 'DATE',
          format : 'MM-DD-YYYY',
          minDate : '03-10-2016',
          maxDate : null,    
          weekStartDay :'Sunday',
          closeOnSelect : true
        }

        vm.currentDate1 = moment();  
        var options1 = {
          mode : 'date-time',
          format : 'MM-DD-YYYY HH:mm',
          minDate : '03-10-2016',
          maxDate : null,    
          weekStartDay :'Sunday'
        }        

        vm.showCalander = function(ev){
          options.targetEvent = ev;
          smDateTimePicker(vm.currentDate,options)
          .then(function(selectedDate) {

            vm.currentDate = selectedDate;
          });          
        }



        vm.showCalander1 = function(ev){
          options1.targetEvent = ev;
          smDateTimePicker(vm.currentDate1,options1).then(function(selectedDate) {
            vm.currentDate1 = selectedDate;
            var ele = document.getElementsByClassName("md-scroll-mask");
            if(ele.length!==0){ 
                angular.element(ele).remove();
            }            
          });          
        }        

        vm.showDailog = function(ev){
          $mdDialog.show({
            templateUrl: 'views/dailog.html',
            parent: angular.element(document.body),
            targetEvent: ev,
            clickOutsideToClose:true,
            fullscreen: false
          });          
        }

        vm.logout = function(ev){
          var confirm = $mdDialog.confirm()
                .title('Logout')
                .content('Save all your work before logout')
                .ariaLabel('Logout')
                .targetEvent(ev)
                .ok('Logout')
                .fullscreen(true)
                .cancel('Cancel');
          $mdDialog.show(confirm).then(function() {
             Auth.logout(); 
          }, function() {
            
          });          
        };
        
        vm.dayofPaySelected = function(range){
          vm.rangeObj = range;
        }

        vm.dayofPay2Selected = function(range){
          vm.rangeObj2 = range;
        }

        function buildToggler(navID) {
          var debounceFn =  $mdUtil.debounce(function(){
                $mdSidenav(navID)
                  .toggle().then(function () {
                    $log.debug('toggle ' + navID + ' is done');
                  });
              },300);
          return debounceFn;
        }
        vm.toggleLeft = buildToggler('left');

        vm.save = function(){
          console.log(vm.employee);
        }
        
    }

      function LeftCtrl($timeout, $mdSidenav, $mdUtil, $log){
        var vm = this;
            vm.close = function () {
            $mdSidenav('left').close()
              .then(function () {
              });
          };
      }




angular.module('demoApp')
.controller('MainCtrl',['$scope','$timeout', '$mdSidenav', '$mdUtil', '$log','$state', '$mdDialog','smDateTimePicker',MainCtrl])
.controller('LeftCtrl', ['$timeout', '$mdSidenav', '$mdUtil', '$log',LeftCtrl]);

(function(){

'use strict';

function Calender($timeout,picker){
    
	return {
	  restrict : 'E',
	  replace:false,
      require: ['^ngModel', 'smCalender'],
      scope :{
	      	minDate: "=",
	      	maxDate: "=",
	      	initialDate : "=",
	      	format: '@',
	      	mode: '@',
	      	startView:'@',	      	
	      	weekStartDay:'@',
	      	disableYearSelection:'@',
	      	dateSelectCall : '&'
	    },
	   	controller:["$scope","$timeout","picker","$mdMedia",CalenderCtrl],
	    controllerAs : 'vm',
	    templateUrl:"picker/calender-date.html",
		link : function(scope,element,attr,ctrls){
			var ngModelCtrl = ctrls[0];
	        var calCtrl = ctrls[1];
	        calCtrl.configureNgModel(ngModelCtrl);
		}      
	}
}

var CalenderCtrl = function($scope,$timeout,picker,$mdMedia){
	var self  = this;

	self.$scope = $scope;
	self.$timeout = $timeout;
    self.picker = picker;
    self.dayHeader = self.picker.dayHeader;
	self.initialDate = $scope.initialDate; 	
    self.viewModeSmall = $mdMedia('xs');
	self.startDay = angular.isUndefined($scope.weekStartDay) || $scope.weekStartDay==='' ? 'Sunday' : $scope.weekStartDay ;	   	
	self.minDate = $scope.minDate;			//Minimum date 
	self.maxDate = $scope.maxDate;			//Maximum date 
	self.mode = angular.isUndefined($scope.mode) ? 'DATE' : $scope.mode;
	self.format = $scope.format;
	self.restrictToMinDate = angular.isUndefined($scope.minDate) ? false : true;
	self.restrictToMaxDate = angular.isUndefined($scope.maxDate) ? false : true;
	self.stopScrollPrevious =false;
	self.stopScrollNext = false;
	self.disableYearSelection = $scope.disableYearSelection;
	self.monthCells=[];
	self.dateCellHeader= [];	
	self.dateCells = [];
	self.monthList =  moment.monthsShort();
	self.moveCalenderAnimation='';

	self.format = angular.isUndefined(self.format) ? 'MM-DD-YYYY': self.format;
	self.initialDate =	angular.isUndefined(self.initialDate) ? moment() : moment(self.initialDate,self.format);
	
	self.currentDate = self.initialDate.clone();



	if(self.restrictToMinDate) 
		self.minDate = moment(self.minDate, self.format).subtract(1,'d');
	if(self.restrictToMaxDate) 
		self.maxDate = moment(self.maxDate, self.format);

    self.yearItems = {
        currentIndex_: 0,
        PAGE_SIZE: 7,
        START: 1900,
        getItemAtIndex: function(index) {
            if(this.currentIndex_ < index)
                this.currentIndex_ = index;
            return this.START + index;
        },
        getLength: function() {
            return this.currentIndex_ + Math.floor(this.PAGE_SIZE / 2);
        }
    };	

	self.init();
}

CalenderCtrl.prototype.setInitDate = function(dt) {
    var self = this;
    self.initialDate =angular.isUndefined( dt) ? moment() : moment( dt,self.format);
  };


CalenderCtrl.prototype.configureNgModel = function(ngModelCtrl) {
    var self = this;

    self.ngModelCtrl = ngModelCtrl;

    ngModelCtrl.$render = function() {
      self.ngModelCtrl.$viewValue= self.currentDate;
    };

  };


  CalenderCtrl.prototype.setNgModelValue = function(date) {
  	var self = this;
    self.ngModelCtrl.$setViewValue(date);
    self.ngModelCtrl.$render();
  };

CalenderCtrl.prototype.init = function(){
	var self = this;
	self.buildDateCells();
	self.buildDateCellHeader();
	self.buildMonthCells();
	self.setView()
    self.showYear();


};

CalenderCtrl.prototype.setView = function(){
	var self = this;
	self.headerDispalyFormat = "ddd, MMM DD";	
	switch(self.mode) {
	    case 'date-time':
			self.view = 'DATE'
			self.headerDispalyFormat = "ddd, MMM DD HH:mm";			
	        break;
	    case 'time':
	        self.view = 'HOUR';
			self.headerDispalyFormat = "HH:mm";
	        break;
	    default:
	        self.view = 'DATE';
	}	
}


CalenderCtrl.prototype.showYear = function() { 
	var self = this;
    self.yearTopIndex = (self.initialDate.year() - self.yearItems.START) + Math.floor(self.yearItems.PAGE_SIZE / 2);
    self.yearItems.currentIndex_ = (self.initialDate.year() - self.yearItems.START) + 1;
};


CalenderCtrl.prototype.buildMonthCells = function(){
	var self = this;
	self.monthCells = moment.months();
};

CalenderCtrl.prototype.buildDateCells = function(){
	var self = this;
	var currentMonth = self.initialDate.month();
    var calStartDate  = self.initialDate.clone().date(0).day(self.startDay);
    var weekend = false;
    var isDisabledDate =false;


    /*
    	Check if min date is greater than first date of month
    	if true than set stopScrollPrevious=true 
    */
	if(!angular.isUndefined(self.minDate)){	
		self.stopScrollPrevious	 = self.minDate.unix() > calStartDate.unix();
	}

    self.dateCells =[];
	for (var i = 0; i < 6; i++) {
		var week = [];
		for (var j = 0; j < 7; j++) {
			
			var isCurrentMonth = (calStartDate.month()=== currentMonth);	

			isDisabledDate = isCurrentMonth? false:true; 
			//if(isCurrentMonth){isDisabledDate=false}else{isDisabledDate=true};

			if(self.restrictToMinDate && !angular.isUndefined(self.minDate) && !isDisabledDate)
				isDisabledDate = self.minDate.isAfter(calStartDate);
			
			if(self.restrictToMaxDate && !angular.isUndefined(self.maxDate) && !isDisabledDate)
				isDisabledDate = self.maxDate.isBefore(calStartDate);
			

			var  day = {
	            date : calStartDate.clone(),
	            dayNum: isCurrentMonth ? calStartDate.date() :"",
	            month : calStartDate.month(),
	            today: calStartDate.isSame(moment(),'day') && calStartDate.isSame(moment(),'month'),
	            year : calStartDate.year(),
	            dayName : calStartDate.format('dddd'),
	            isWeekEnd : weekend,
	            isDisabledDate : isDisabledDate,
	            isCurrentMonth : isCurrentMonth
			};
			
			week.push(day);
            calStartDate.add(1,'d')
		}
		self.dateCells.push(week);
	}
    /*
    	Check if max date is greater than first date of month
    	if true than set stopScrollPrevious=true 
    */
	if(self.restrictToMaxDate && !angular.isUndefined(self.maxDate)){	
		self.stopScrollNext	= self.maxDate.unix() < calStartDate.unix();
	}

	if(self.dateCells[0][6].isDisabledDate && !self.dateCells[0][6].isCurrentMonth){
		self.dateCells[0].splice(0);
	}

};

CalenderCtrl.prototype.changePeriod = function(c){
	var self = this;
	if(c === 'p'){
		if(self.stopScrollPrevious) return;
		self.moveCalenderAnimation='slideLeft';
		self.initialDate.subtract(1,'M');
	}else{
		if(self.stopScrollNext) return;
		self.moveCalenderAnimation='slideRight';
		self.initialDate.add(1,'M');
	}

	self.buildDateCells();
	self.$timeout(function(){
		self.moveCalenderAnimation='';
	},500);
};


CalenderCtrl.prototype.selectDate = function(d,isDisabled){
	var self = this;
	if (isDisabled) return;
	self.currentDate = d;
	self.$scope.dateSelectCall({date:d});
	self.setNgModelValue(d);

	self.$scope.$emit('calender:date-selected');

}


CalenderCtrl.prototype.buildDateCellHeader = function(startFrom){
	var self = this;
	var daysByName = self.picker.daysNames;
	
	var keys = [];
	for (var key in daysByName) {
		keys.push(key)
	}
	var startIndex = moment().day(self.startDay).day(), count = 0;
	for (var key in daysByName) {

    	self.dateCellHeader.push(daysByName[ keys[ (count + startIndex) % (keys.length)] ]);
        count++; // Don't forget to increase count.
    }  
}
/*
	Month Picker
*/

CalenderCtrl.prototype.changeView = function(view){
	var self = this;
	if(self.disableYearSelection){
		return;
	}else{ 
	    if(view==='YEAR_MONTH'){
	   		self.showYear();
    	}
   		self.view =view;
	}
}

/*
	Year Picker
*/


CalenderCtrl.prototype.changeYear = function(yr,mn){
	var self = this;
	self.initialDate.year(yr).month(mn);
	self.buildDateCells();
	self.view='DATE';	
}

/*
	Hour and Time
*/


CalenderCtrl.prototype.setHour = function(h){
	var self = this;
	self.currentDate.hour(h);
}

CalenderCtrl.prototype.setMinute = function(m){
	var self = this;
	self.currentDate.minute(m);
}

CalenderCtrl.prototype.selectedDateTime = function(){
	var self = this;
	self.setNgModelValue(self.currentDate);
	if(self.mode === 'time') 
		self.view='HOUR' 
	else 
		self.view='DATE';
	self.$scope.$emit('calender:close');			
}

CalenderCtrl.prototype.closeDateTime = function(){
	var self = this;
	if(self.mode === 'time') 
		self.view='HOUR' 
	else 
		self.view='DATE';
	self.$scope.$emit('calender:close');
}





var app = angular.module('smDateTimeRangePicker',[]);

app.directive('smCalender',['$timeout','picker',Calender]);

})();
(function(){

'use strict';

function TimePicker(){
	return {
	  restrict : 'E',
	  replace:true,
      require: ['^ngModel', 'smTime'],
      scope :{
	      	initialTime : "@",
	      	format:"@",
	      	timeSelectCall : '&'	      	
	    },
	   	controller:["$scope","$timeout",TimePickerCtrl],
	    controllerAs : 'vm',
	    templateUrl:"picker/calender-hour.html",
		link : function(scope,element,att,ctrls){
			var ngModelCtrl = ctrls[0];
	        var calCtrl = ctrls[1];
	        calCtrl.configureNgModel(ngModelCtrl);

		}      
	}
}

var TimePickerCtrl = function($scope,$timeout){
	var self  = this;
	self.uid = Math.random().toString(36).substr(2,5);
	self.$scope = $scope;
	self.$timeout = $timeout;
	self.initialDate = $scope.initialTime; 	//if calender to be  initiated with specific date 
	self.format = $scope.format;
	self.hourItems =[];
	self.minuteCells =[];
	self.format = angular.isUndefined(self.format) ? 'HH:mm': self.format;
	self.initialDate =	angular.isUndefined(self.initialDate)? moment() : moment(self.initialDate,self.format);
	self.currentDate = self.initialDate.clone();
	self.hourSet =false;
	self.minuteSet = false;

	self.show=true;
	self.init();
}

TimePickerCtrl.prototype.init = function(){
	var self = this;
	self.buidHourCells();
	self.buidMinuteCells();
	self.headerDispalyFormat = "HH:mm";
	self.showHour();
};

TimePickerCtrl.prototype.showHour = function() { 
	var self = this;

	self.hourTopIndex = 22;
	self.minuteTopIndex	= (self.initialDate.minute() -0) + Math.floor(7 / 2);	
    //self.yearTopIndex = (self.initialDate.year() - self.yearItems.START) + Math.floor(self.yearItems.PAGE_SIZE / 2);	
//	self.hourItems.currentIndex_ = (self.initialDate.hour() - self.hourItems.START) + 1;
};





 TimePickerCtrl.prototype.configureNgModel = function(ngModelCtrl) {
    this.ngModelCtrl = ngModelCtrl;
    var self = this;
    ngModelCtrl.$render = function() {
      self.ngModelCtrl.$viewValue= self.currentDate;
    };
  };


  TimePickerCtrl.prototype.setNgModelValue = function(date) {
  	var self = this;
    self.ngModelCtrl.$setViewValue(date);
    self.ngModelCtrl.$render();
  };




TimePickerCtrl.prototype.buidHourCells = function(){
	var self = this;

	for (var i = 0 ; i <= 23; i++) {
		var hour={
			hour : i,
			isCurrent :(self.initialDate.hour())=== i 
		}
		self.hourItems.push(hour);
	};	
};

TimePickerCtrl.prototype.buidMinuteCells = function(){
	var self = this;
	self.minuteTopIndex	= self.initialDate.minute();
	for (var i = 0 ; i <= 59; i++) {
		var minute = {
			minute : i,
			isCurrent : (self.initialDate.minute())=== i,
		}
		self.minuteCells.push(minute);
	};
};


TimePickerCtrl.prototype.selectDate = function(d,isDisabled){
	var self = this;
	if (isDisabled) return;
	self.currentDate = d;

	self.$scope.$emit('calender:date-selected');

}


TimePickerCtrl.prototype.setHour = function(h){
	var self = this;
	self.currentDate.hour(h);
	self.setNgModelValue(self.currentDate);
	self.hourSet =true;
	if(self.hourSet && self.minuteSet){
		self.$scope.timeSelectCall({time: self.currentDate});
		self.hourSet=false; 
		self.minuteSet=false;
	}	
}

TimePickerCtrl.prototype.setMinute = function(m){
	var self = this;
	self.currentDate.minute(m);
	self.setNgModelValue(self.currentDate);		
	self.minuteSet =true;	
	if(self.hourSet && self.minuteSet){
		self.$scope.timeSelectCall({time: self.currentDate});
		self.hourSet=false; 
		self.minuteSet=false;		
	}	

}

TimePickerCtrl.prototype.selectedDateTime = function(){
	var self = this;
	self.setNgModelValue(self.currentDate);
	if(self.mode === 'time') 
		self.view='HOUR' 
	else 
		self.view='DATE';
	self.$scope.$emit('calender:close');			
}

var app = angular.module('smDateTimeRangePicker');

app.directive('smTime',['$timeout',TimePicker]);


})();

(function(){

'use strict';

function DatePickerDir($timeout,picker,$mdMedia,$window){
	return {
	  restrict : 'E',
      require: ['^ngModel','smDatePicker'],
      replace: false,
      scope :{
	      	initialDate : "=",
	      	minDate	:"=",
	      	maxDate:"=",
	      	format:"@",
	      	mode:"@",	      	
	      	startDay:"@",
	      	closeOnSelect:"@",
	      	weekStartDay:"@",
	      	disableYearSelection: "@",
	      	onSelectCall : '&'	      	
	    },
	    controller: ['$scope','picker','$mdMedia',PickerCtrl],
	    controllerAs: 'vm',
	    bindToController:true,
	    templateUrl:"picker/date-picker.html",
		link : function(scope,element,att,ctrls){
		      var ngModelCtrl = ctrls[0];
		      var calCtrl = ctrls[1];
		      calCtrl.configureNgModel(ngModelCtrl);
		}      
	}
}

var PickerCtrl = function($scope,picker,$mdMedia){
	var self = this;
	self.scope = $scope;
	self.okLabel = picker.okLabel;
	self.cancelLabel = picker.cancelLabel;	
	self.picker = picker;		
	self.$mdMedia =$mdMedia;
	self.init();

}

PickerCtrl.prototype.init = function() {
	var self = this;

	if(angular.isUndefined(self.mode) || self.mode ===''){
		self.mode = 'date';	
	}
	self.currentDate = isNaN(self.ngModelCtrl)  ? moment():  self.ngModelCtrl.$viewValue ;

	self.setViewMode(self.mode);
};


PickerCtrl.prototype.configureNgModel = function(ngModelCtrl) {
    var self = this;
    self.ngModelCtrl = ngModelCtrl;
    self.ngModelCtrl.$render = function() {
      self.ngModelCtrl.$viewValue= self.initialDate;
    };
};


PickerCtrl.prototype.setViewMode = function(mode){
	var self = this;
	switch(mode) {
			case 'date':
			self.view = 'DATE';
			self.headerDispalyFormat = self.picker.customHeader.date;				        
			break;
		case 'date-time':
			self.view = 'DATE'
			self.headerDispalyFormat =  self.picker.customHeader.dateTime;			
			break;
		case 'time':
			self.view = 'TIME';
			self.headerDispalyFormat = "HH:mm";
			break;
		default:
			self.headerDispalyFormat = "ddd, MMM DD ";
			self.view = 'DATE';
	}					
}

PickerCtrl.prototype.setNextView = function(){
	var self = this;
  switch (self.mode){
    case  'date':
        self.view = 'DATE';             
      break;
    case  'date-time':
		 self.view = self.view==='DATE' ? 'TIME':'DATE';
      break;
    default:
        self.view = 'DATE';
  }    
} 

PickerCtrl.prototype.selectedDateTime = function(){
	var self = this;
	var date = moment(self.selectedDate,this.format);
	if(!date.isValid()){
		date = moment();
		self.selectedDate =date;
	}
	if(!angular.isUndefined(self.selectedTime)){
		date.hour(self.selectedTime.hour()).minute(self.selectedTime.minute());
	}
	self.setNgModelValue(date);
}

PickerCtrl.prototype.dateSelected = function(date){
	var self = this;
  	self.currentDate.date(date.date()).month(date.month()).year(date.year());
  	self.selectedDate = self.currentDate;
  	if(self.closeOnSelect && self.mode==='date'){
  		self.selectedDateTime();
  	}else{
  		self.setNextView();	
  	}
}

PickerCtrl.prototype.timeSelected = function(time){
	var self = this;
  	self.currentDate.hours(time.hour()).minutes(time.minute());
  	self.selectedTime= self.currentDate;

  	if(self.closeOnSelect && self.mode==='date-time')
  		self.selectedDateTime();
  	else
  		self.setNextView();
}

PickerCtrl.prototype.setNgModelValue = function(date) {
    var self = this;
	self.onSelectCall({date: date});
    self.ngModelCtrl.$setViewValue(date.format(self.format));
    self.ngModelCtrl.$render();    
    self.closeDateTime();  
};


PickerCtrl.prototype.closeDateTime = function(){
	this.view = 'DATE';
	this.scope.$emit('calender:close');			
}



function TimePickerDir($timeout,picker,$mdMedia,$window){
	return {
	  restrict : 'E',
      require: '^ngModel',
      replace:true,
      scope :{
	    initialDate : "@",
	    format:"@",
	    mode:"@",	      	
	    closeOnSelect:"@"
	},
	templateUrl:"picker/time-picker.html",
	link : function(scope,element,att,ngModelCtrl){
			setViewMode(scope.mode)
		    
		    scope.okLabel = picker.okLabel;
		    scope.cancelLabel = picker.cancelLabel;

			scope.currentDate = isNaN(ngModelCtrl.$viewValue)  ? moment(): ngModelCtrl.$viewValue ;

			scope.$mdMedia =$mdMedia;
			function setViewMode(mode){
				switch(mode) {
				    case 'date-time':
						scope.view = 'DATE'
						scope.headerDispalyFormat = "ddd, MMM DD HH:mm";			
				        break;
				    case 'time':
				        scope.view = 'HOUR';
						scope.headerDispalyFormat = "HH:mm";
				        break;
				    default:
				        scope.view = 'DATE';
				}					
			}

			scope.$on('calender:date-selected',function(){
				if(scope.closeOnSelect && (scope.mode!=='date-time' || scope.mode!=='time')){
					var date = moment(scope.selectedDate,scope.format);
					if(!date.isValid()){
						date = moment();
						scope.selectedDate =date;
					}
					if(!angular.isUndefined(scope.selectedTime)){	
						date.hour(scope.selectedTime.hour()).minute(scope.selectedTime.minute());
					}
					scope.currentDate =scope.selectedDate;
					ngModelCtrl.$setViewValue(date.format(scope.format));
					ngModelCtrl.$render();
					setViewMode(scope.mode)
					scope.$emit('calender:close');			

				}
			})

			scope.selectedDateTime = function(){
				var date = moment(scope.selectedDate,scope.format);
				if(!date.isValid()){
					date = moment();
					scope.selectedDate =date;
				}
				if(!angular.isUndefined(scope.selectedTime)){	
					date.hour(scope.selectedTime.hour()).minute(scope.selectedTime.minute());
				}
				scope.currentDate =scope.selectedDate;
				ngModelCtrl.$setViewValue(date.format(scope.format));
				ngModelCtrl.$render();
				setViewMode(scope.mode)
				scope.$emit('calender:close');			
			}


			scope.closeDateTime = function(){
				scope.$emit('calender:close');			
			}

		}      
	}
}


var app = angular.module('smDateTimeRangePicker');

app.directive('smDatePicker',['$timeout','picker','$mdMedia','$window',DatePickerDir]);
app.directive('smTimePicker',['$timeout','picker','$mdMedia','$window',TimePickerDir]);


})();



(function(){

'use strict';

var app = angular.module('smDateTimeRangePicker');


function DatePickerServiceCtrl($scope, $mdDialog, $mdMedia, $timeout,$mdUtil,picker){
    var self = this;

    if(!angular.isUndefined(self.options) && (angular.isObject(self.options))){
        self.mode = isExist(self.options.mode,self.mode); 
        self.format = isExist(self.options.format,'MM-DD-YYYY');
        self.minDate = isExist(self.options.minDate,undefined);
        self.maxDate = isExist(self.options.maxDate,undefined);
        self.weekStartDay = isExist(self.options.weekStartDay,'Sunday');
        self.closeOnSelect =isExist(self.options.closeOnSelect,false);
    }

    console.log(self.format);
    if(!angular.isObject(self.initialDate)){
        self.initialDate = moment(self.initialDate,self.format);
        self.selectedDate = self.initialDate;                  
    }

    self.currentDate = self.initialDate;
    self.viewDate = self.currentDate;

    self.view = 'DATE';
    self.$mdMedia = $mdMedia;
    self.$mdUtil = $mdUtil;

    self.okLabel = picker.okLabel;
    self.cancelLabel = picker.cancelLabel;         



    setViewMode(self.mode);

    function isExist(val,def){
        return angular.isUndefined(val)? def:val;
    }


    function setViewMode(mode){
        switch(mode) {
            case 'date':
                self.headerDispalyFormat = "ddd, MMM DD ";                     
            break;
            case 'date-time':
                self.headerDispalyFormat = "ddd, MMM DD HH:mm";            
            break;
            case 'time':
                self.headerDispalyFormat = "HH:mm";
            break;
            default:
                self.headerDispalyFormat = "ddd, MMM DD ";
        }                   
    }

    self.autoClosePicker = function(){
        if(self.closeOnSelect){        
            if(angular.isUndefined(self.selectedDate)){
              self.selectedDate = self.initialDate;
            }
            //removeMask();            
            $mdDialog.hide(self.selectedDate.format(self.format));
        }    
    }

    self.dateSelected = function(date){
        self.selectedDate = date;
        self.viewDate = date;
        if(self.mode==='date-time')  
            self.view = 'HOUR';
        else
            self.autoClosePicker();
    }

    self.timeSelected = function(time){
        self.selectedDate.hour(time.hour()).minute(time.minute());        
        self.viewDate = self.selectedDate;
        self.autoClosePicker();                
    }    

    self.closeDateTime = function(){
        $mdDialog.cancel();
        removeMask();
    }
    self.selectedDateTime = function(){
        if(angular.isUndefined(self.selectedDate)){
         self.selectedDate= self.currentDate;   
        }
        $mdDialog.hide(self.selectedDate.format(self.format));
        removeMask();
    }

    function removeMask(){
        var ele = document.getElementsByClassName("md-scroll-mask");
        if(ele.length!==0){ 
            angular.element(ele).remove();
        }            
    }

}


app.provider("smDateTimePicker", function() {
    
    this.$get = ["$mdDialog", function($mdDialog) {

        var datePicker = function(initialDate, options) {


            if (angular.isUndefined(initialDate)) initialDate = moment();


            if (!angular.isObject(options)) options = {};
            
            return $mdDialog.show({
                controller:  ['$scope','$mdDialog', '$mdMedia', '$timeout','$mdUtil','picker', DatePickerServiceCtrl],
                controllerAs: 'vm',
                bindToController: true,
                clickOutsideToClose: true,
                targetEvent: options.targetEvent,
                templateUrl: "picker/date-picker-service.html",
                locals: {
                    initialDate: initialDate,
                    options: options
                },
                skipHide: true
            });
        };
    
        return datePicker;
    }];
});


})();







function DateTimePicker($mdUtil, $mdMedia, $document, picker) {
    return {
        restrict: 'E',
        require: ['^ngModel'],
        scope: {
            weekStartDay: '@',
            startView: "@",
            mode: '@',
            format: '@',
            minDate: '@',
            maxDate: '@',
            fname: "@",
            label: "@",
            isRequired: '@',
            disable: '=',
            noFloatingLabel: "=",
            disableYearSelection: '@',
            closeOnSelect: "@",
            onDateSelectedCall: "&"
        },
        controller: ['$scope', '$element', '$mdUtil', '$mdMedia', '$document', SMDateTimePickerCtrl],
        controllerAs: 'vm',
        bindToController:true,
        template: function (element,attributes){
          var inputType ="";
          if(attributes.hasOwnProperty('onFocus')){
            inputType =  '<input name="{{vm.fname}}" data-ng-model="vm.value" '
                  + '  type="text" placeholder="{{vm.label}}"'
                  + '  aria-label="{{vm.fname}}" ng-focus="vm.show()" data-ng-required="vm.isRequired"  ng-disabled="vm.disable"' 
                  + '  server-error class="sm-input-container" />' ;

          }else{
             inputType = '      <input class="" name="{{vm.fname}}" data-ng-model="vm.value" '
                      + '             type="text" placeholder="{{vm.label}}" '
                      + '             aria-label="{{vm.fname}}" aria-hidden="true" data-ng-required="vm.isRequired"  ng-disabled="vm.disable"/>' 
                      + '     <md-button tabindex="-1" class="sm-picker-icon md-icon-button" aria-label="showCalender" ng-disabled="vm.disable" aria-hidden="true" type="button" ng-click="vm.show()">'
                      + '         <svg  fill="#000000" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/><path d="M0 0h24v24H0z" fill="none"/></svg>'
                      + '     </md-button>' ;
          }

          return  '  <md-input-container class="sm-input-container md-icon-float md-block" md-no-float="vm.noFloatingLabel">' + 
                    inputType +
                  '     <div id="picker" class="sm-calender-pane md-whiteframe-z1 hide-animate">' +
                  '          <sm-date-picker ' +
                  '              id="{{vm.fname}}Picker" ' +
                  '              initial-date="vm.value"' +
                  '              mode="{{vm.mode}}" ' +
                  '              disable-year-selection={{vm.disableYearSelection}}' +
                  '              close-on-select="{{vm.closeOnSelect}}"' +
                  '              start-view="{{vm.startView}}" ' +
                  '              data-min-date="vm.minDate" ' + 
                  '              data-max-date="vm.maxDate"  ' + 
                  '              data-format="{{vm.format}}"  ' +
                  '              data-on-select-call="vm.onDateSelected(date)"' +
                  '              data-week-start-day="{{vm.weekStartDay}}" > ' +
                  '         </sm-date-picker>' +
                  '     </div>' +
                  ' </md-input-container>';    
        },
        link: function(scope, $element, attr, ctrl) {
          console.log(ctrl[0]);
            // set value to input if any provided
          ctrl[0].$viewChangeListeners.push(function(){ 
              /*Set model value differently based on the viewvalue entered*/
            console.log('$viewChangeListeners',o,n);
          });
          scope.$watch('vm.value',function(o,n){
            console.log('vm.value',o,n);
          })
            ctrl[0].$render = function() {
                scope.vm.value = this.$viewValue;
            }
        }
    }
}
var SMDateTimePickerCtrl = function($scope, $element, $mdUtil, $mdMedia, $document) {
    var self = this;
    self.$scope = $scope;
    self.$element = $element;    
    self.$mdUtil = $mdUtil;
    self.$mdMedia = $mdMedia;
    self.$document = $document;
    self.isCalenderOpen = false;


    self.calenderHeight = 320;
    self.calenderWidth = 450;


    //find input button and assign to variable
    self.inputPane = $element[0].querySelector('.sm-input-container');
    
    //find Calender Picker  and assign to variable    
    self.calenderPane = $element[0].querySelector('.sm-calender-pane');
    //button to start calender        
    self.button = $element[0].querySelector('.sm-picker-icon');

    self.calenderPan = angular.element(self.calenderPane);

    //check if mode is undefied set to date mode 
    self.mode = angular.isUndefined($scope.mode) ? 'date' : $scope.mode;
    // check if Pre defined format is supplied
    self.format = angular.isUndefined($scope.format) ? 'MM-DD-YYYY' : $scope.format;

    self.calenderPan.addClass('hide hide-animate');

    self.bodyClickHandler = angular.bind(self,self.clickOutSideHandler);

    self.$scope.$on('calender:close', function() {
      self.$document.off('keydown');
      self.hideElement();
    });

    self.$scope.$on('$destroy', function() {
      self.calenderPane.parentNode.removeChild(self.calenderPane);
    }); 

    // if tab out hide key board
    angular.element(self.inputPane).on('keydown', function(e) {
      switch(e.which){
        case  27:
        case  9:
          self.hideElement();
            break;
        }
    });

}


/*get visiable port

  @param : elementnRect 

  @param : bodyRect 

*/

SMDateTimePickerCtrl.prototype.getVisibleViewPort = function(elementRect, bodyRect) {
    var self = this;

    var top = elementRect.top;
    if (elementRect.top + self.calenderHeight > bodyRect.bottom) {
        top = elementRect.top - ((elementRect.top + self.calenderHeight) - (bodyRect.bottom - 20));
    }
    var left = elementRect.left;
    if (elementRect.left + self.calenderWidth > bodyRect.right) {
        left = elementRect.left - ((elementRect.left + self.calenderWidth) - (bodyRect.right - 10));
    }
    return {
        top: top,
        left: left
    };
}

SMDateTimePickerCtrl.prototype.onDateSelected = function(date){
  var self = this;
  self.onDateSelectedCall({date: date});
  self.value = date.format(self.format);
}


SMDateTimePickerCtrl.prototype.show = function($event) {
  var self = this;
  var elementRect = self.inputPane.getBoundingClientRect();
  var bodyRect = document.body.getBoundingClientRect();

  self.calenderPan.removeClass('hide hide-animate');
  
  if (self.$mdMedia('sm') || self.$mdMedia('xs')) {
    self.calenderPane.style.left = (bodyRect.width - 320) / 2 + 'px';
    self.calenderPane.style.top = (bodyRect.height - 450) / 2 + 'px';
  } else {
    var rect = self.getVisibleViewPort(elementRect, bodyRect);
    self.calenderPane.style.left = (rect.left) + 'px';
    self.calenderPane.style.top = (rect.top) + 'px';
  }

  
  document.body.appendChild(self.calenderPane);
  angular.element(self.calenderPane).focus();

  
  self.calenderPan.addClass('show');
  self.$mdUtil.disableScrollAround(self.calenderPane);    
  
  
  self.isCalenderOpen =true;
  self.$document.on('click',self.bodyClickHandler);
}


SMDateTimePickerCtrl.prototype.tabOutEvent= function(element){
  var self = this;
    if (element.which === 9) {
      self.hideElement();
    }
}

SMDateTimePickerCtrl.prototype.hideElement= function() {
  var self = this;
  self.calenderPan.addClass('hide-animate');
  self.calenderPan.removeClass('show');
  self.$mdUtil.enableScrolling();

  if(self.button){
    angular.element(self.button).focus();    
  }
  self.$document.off('click'); 
  self.isCalenderOpen =false;

}


SMDateTimePickerCtrl.prototype.clickOutSideHandler = function(e){
  var self = this;
  if(!self.button){
    if ((self.calenderPane !== e.target && self.inputPane !== e.target ) && (!self.calenderPane.contains(e.target)  && !self.inputPane.contains(e.target))) {
      self.hideElement();
    }
  }else{
    if ((self.calenderPane !== e.target && self.button !== e.target ) && (!self.calenderPane.contains(e.target)  && !self.button.contains(e.target))) {
      self.hideElement();
    }
  }
}

SMDateTimePickerCtrl.prototype.getCalenderCtrl = function(e){

}


var app = angular.module('smDateTimeRangePicker');
app.directive('smDateTimePicker', ['$mdUtil', '$mdMedia', '$document', 'picker', DateTimePicker]);
function picker(){
    var massagePath = "X";
    var cancelLabel = "Cancel";
    var okLabel = "Ok";
    var customHeader ={
        date:'ddd, MMM DD',
        dateTime:'ddd, MMM DD HH:mm',
        time:'HH:mm',
    }


    //date picker configuration
    var daysNames =  [
        {'single':'S','shortName':'Su','fullName':'Su startDate:nday'}, 
        {'single':'M','shortName':'Mo','fullName':'MonDay'}, 
        {'single':'T','shortName':'Tu','fullName':'TuesDay'}, 
        {'single':'W','shortName':'We','fullName':'Wednesday'}, 
        {'single':'T','shortName':'Th','fullName':'Thursday'}, 
        {'single':'F','shortName':'Fr','fullName':'Friday'}, 
        {'single':'S','shortName':'Sa','fullName':'Saturday'}
    ];

    var dayHeader = "single";

    var monthNames = moment.months();

    //range picker configuration
    var rangeDivider = "To";
    var rangeDefaultList = [
    		{	label:'Today',
    			startDate:moment().startOf('day'),
    			endDate:moment().endOf('day')
    		},
            {	label:'Last 7 Days',
            	startDate: moment().subtract(7,'d'),
            	endDate:moment()
            },
            {	
            	label:'This Month',
            	startDate:moment().startOf('month'), 
            	endDate: moment().endOf('month')
            },
            {
				label:'Last Month',
				startDate:moment().subtract(1,'month').startOf('month'),
				endDate: moment()
			},
            {
				label: 'This Quarter',
				startDate: moment().startOf('quarter'),
            	endDate: moment().endOf('quarter')
            },
            {
				label:  'Year To Date',
				startDate:  moment().startOf('year'),
            	endDate:  moment()
            },
            {
            	label:  'This Year',
				startDate:  moment().startOf('year'),
            	endDate:  moment().endOf('year')
            }/*, 
            { 
				label:  'Custom Range',
				startDate:  'custom',
				endDate: 'custom'
			}*/
		];

    var rangeCustomStartEnd =['Start Date','End Date'];            

	
    return{
		setMassagePath : function(param){
			massagePath = param;
		},
		setDivider : function(value){
			divider = value
		},  
        setDaysNames : function(array){
            daysNames =array;
        },
        setMonthNames : function(array){
            monthNames = array;
        }, 
        setDayHeader : function(param){
            dayHeader = param;
        },
        setOkLabel : function(param){
            okLabel = param;
        },               
        setCancelLabel : function(param){
            cancelLabel = param;
        },     
        setRangeDefaultList : function(array){
            rangeDefaultList = array;
        },
        setRangeCustomStartEnd : function(array){
            rangeCustomStartEnd = array;
        },           
        setCustomHeader : function(obj){
            if(!angular.isUndefined(obj.date)){
                customHeader.date= obj.date;
            }
            if(!angular.isUndefined(obj.dateTime)){
                customHeader.dateTime= obj.dateTime;
            }
            if(!angular.isUndefined(obj.time)){
                customHeader.time= obj.time;
            }                        
        },               
		$get: function(){
			return {
				massagePath : massagePath,
                cancelLabel: cancelLabel,
                okLabel : okLabel,

                daysNames : daysNames,
                monthNames:monthNames,
                dayHeader :dayHeader,
                customHeader:customHeader,

                rangeDivider : rangeDivider,
                rangeCustomStartEnd : rangeCustomStartEnd,
                rangeDefaultList :rangeDefaultList                 
			}
		}
	}
}

var app = angular.module('smDateTimeRangePicker');

app.provider('picker',[picker]);
(function(){

'use strict';

function RangePickerInput($document,$mdMedia,$mdUtil,picker){
    return {
      restrict : 'EA',
      replace: true,
      require: ['^ngModel'],
      scope :{
        label : "@",
        fname : "@",
        isRequired : '@',
        closeOnSelect: '@',
        disable : '=',
        format : '@',
        mode : '@',
        divider: '@',
        showCustom:'@',
        weekStartDay :"@",
        customToHome: "@",
        customList: '=',
        noFloatingLabel:"=", 
        minDate : '@',
        maxDate : '@',               
        onRangeSelect : '&'  
      },
      controller: ['$scope', '$element', '$mdUtil', '$mdMedia', '$document', SMRangePickerCtrl],
      controllerAs: 'vm',
      bindToController:true,
      template: function (element,attributes){
        return ' <md-input-container md-no-float="vm.noFloatingLabel">'
                +'      <input name="{{vm.fname}}" ng-model="vm.value" ng-readonly="true"'
                +'             type="text" '
                +'             aria-label="{{vm.fname}}" ng-required="{{vm.isRequired}}" class="sm-input-container"'
                +'             ng-focus="vm.show()" placeholder="{{vm.label}}">'
                +'   <div id="picker" class="sm-calender-pane md-whiteframe-4dp" ng-model="value">'                
                +'    <sm-range-picker ng-model="vm.value" custom-to-home="{{vm.customToHome}}" custom-list="vm.customList" mode="{{vm.mode}}" min-date="{{vm.minDate}}"  max-date="{{vm.maxDate}}" range-select-call="vm.rangeSelected(range)" close-on-select="{{vm.closeOnSelect}}" show-custom="{{vm.showCustom}}" week-start-day="{{vm.weekStartDay}}"  divider="{{vm.divider}}" format="{{vm.format}}" ></sm-range-picker>'
                +'   </div> '  
                +'  </md-input-container>';
      },
      link :  function(scope,$element,attr,ctrl){

            ctrl[0].$render = function() {
                scope.vm.value = this.$viewValue;
            }

/*        var inputPane = $element[0].querySelector('.sm-input-container');
        var calenderPane = $element[0].querySelector('.sm-calender-pane');
        var cElement = angular.element(calenderPane);
        scope.format = angular.isUndefined(scope.format) ? 'MM-DD-YYYY': scope.format;
        
        cElement.addClass('hide hide-animate');

        scope.startDate  = angular.isUndefined(scope.value)? scope.startDate : scope.value;

        $document.on('click', function (e) {
            if ((calenderPane !== e.target && inputPane !==e.target) && (!calenderPane.contains(e.target) && !inputPane.contains(e.target))) {
              hideElement();
            }
        });
        angular.element(inputPane).on('keydown', function (e) {
            if(e.which===9){
              hideElement();
            }
        });

      scope.rangeSelected = function(range){
          scope.onRangeSelect({range:range});
        }


        scope.show= function(){
          var elementRect = inputPane.getBoundingClientRect();
          var bodyRect = document.body.getBoundingClientRect();
           cElement.removeClass('hide');
          if($mdMedia('sm') ||  $mdMedia('xs')){
            calenderPane.style.left = (bodyRect.width-296)/2+'px';
            calenderPane.style.top =  (bodyRect.height-450)/2+ 'px';
          }else{
            var rect = getVisibleViewPort(elementRect,bodyRect);
            calenderPane.style.left = (rect.left) + 'px';
            calenderPane.style.top = (rect.top) + 'px';
          }

          document.body.appendChild(calenderPane);
          $mdUtil.disableScrollAround(calenderPane);
          cElement.addClass('show');

        }

        // calculate visible port to display calender
        function getVisibleViewPort(elementRect,bodyRect){
          var calenderHeight = 460;
          var calenderWidth = 296;

          var top =elementRect.top;
          if(elementRect.top +calenderHeight > bodyRect.bottom){
            top = elementRect.top - ((elementRect.top +calenderHeight) - (bodyRect.bottom -20));
          }
          var left = elementRect.left;
          if(elementRect.left +calenderWidth > bodyRect.right){
             left = elementRect.left - ((elementRect.left +calenderWidth) - (bodyRect.right -10));
          }
          return {top : top, left : left };
        }



        scope.$on('range-picker:close',function(){
          hideElement();
        });

        scope.$on('$destroy',function(){
          calenderPane.parentNode.removeChild(calenderPane);
        });

        function hideElement(){
            cElement.addClass('hide-animate');
            cElement.removeClass('show');          
            $mdUtil.enableScrolling();                                    
        }

        function destroyCalender(){
          calenderPane.parentNode.removeChild(calenderPane);
        }
*/

    }
  }
} 


var SMRangePickerCtrl = function($scope, $element, $mdUtil, $mdMedia, $document) {
    var self = this;
    self.$scope = $scope;
    self.$element = $element;    
    self.$mdUtil = $mdUtil;
    self.$mdMedia = $mdMedia;
    self.$document = $document;
    self.isCalenderOpen = false;


    self.calenderHeight = 460;
    self.calenderWidth = 296;


    //find input button and assign to variable
    self.inputPane = $element[0].querySelector('.sm-input-container');
    
    //find Calender Picker  and assign to variable    
    self.calenderPane = $element[0].querySelector('.sm-calender-pane');
    //button to start calender        
    self.button = $element[0].querySelector('.sm-picker-icon');

    self.calenderPan = angular.element(self.calenderPane);

    //check if mode is undefied set to date mode 
    self.mode = angular.isUndefined($scope.mode) ? 'date' : $scope.mode;
    // check if Pre defined format is supplied
    self.format = angular.isUndefined($scope.format) ? 'MM-DD-YYYY' : $scope.format;

    self.calenderPan.addClass('hide hide-animate');

    self.bodyClickHandler = angular.bind(self,self.clickOutSideHandler);

    self.$scope.$on('range-picker:close', function() {
      self.$document.off('keydown');
      self.hideElement();
    });

    self.$scope.$on('$destroy', function() {
      self.calenderPane.parentNode.removeChild(self.calenderPane);
    }); 

    // if tab out hide key board
    angular.element(self.inputPane).on('keydown', function(e) {
      switch(e.which){
        case  27:
        case  9:
          self.hideElement();
            break;
        }
    });

}


/*get visiable port

  @param : elementnRect 

  @param : bodyRect 

*/

SMRangePickerCtrl.prototype.getVisibleViewPort = function(elementRect, bodyRect) {
    var self = this;

    var top = elementRect.top;
    if (elementRect.top + self.calenderHeight > bodyRect.bottom) {
        top = elementRect.top - ((elementRect.top + self.calenderHeight) - (bodyRect.bottom - 20));
    }
    var left = elementRect.left;
    if (elementRect.left + self.calenderWidth > bodyRect.right) {
        left = elementRect.left - ((elementRect.left + self.calenderWidth) - (bodyRect.right - 10));
    }
    return {
        top: top,
        left: left
    };
}

SMRangePickerCtrl.prototype.rangeSelected = function(range){
  var self = this;
  console.log(range);
  self.onRangeSelect({range: range});
  self.value = range;
}


SMRangePickerCtrl.prototype.show = function($event) {
  var self = this;
  var elementRect = self.inputPane.getBoundingClientRect();
  var bodyRect = document.body.getBoundingClientRect();

  self.calenderPan.removeClass('hide hide-animate');
  
  if (self.$mdMedia('sm') || self.$mdMedia('xs')) {
    self.calenderPane.style.left = (bodyRect.width - 320) / 2 + 'px';
    self.calenderPane.style.top = (bodyRect.height - 450) / 2 + 'px';
  } else {
    var rect = self.getVisibleViewPort(elementRect, bodyRect);
    self.calenderPane.style.left = (rect.left) + 'px';
    self.calenderPane.style.top = (rect.top) + 'px';
  }

  
  document.body.appendChild(self.calenderPane);
  angular.element(self.calenderPane).focus();

  
  self.calenderPan.addClass('show');
  self.$mdUtil.disableScrollAround(self.calenderPane);    
  
  
  self.isCalenderOpen =true;
  self.$document.on('click',self.bodyClickHandler);
}


SMRangePickerCtrl.prototype.tabOutEvent= function(element){
  var self = this;
    if (element.which === 9) {
      self.hideElement();
    }
}

SMRangePickerCtrl.prototype.hideElement= function() {
  var self = this;
  self.calenderPan.addClass('hide-animate');
  self.calenderPan.removeClass('show');
  self.$mdUtil.enableScrolling();

  if(self.button){
    angular.element(self.button).focus();    
  }
  self.$document.off('click'); 
  self.isCalenderOpen =false;

}


SMRangePickerCtrl.prototype.clickOutSideHandler = function(e){
  var self = this;
  if(!self.button){
    if ((self.calenderPane !== e.target && self.inputPane !== e.target ) && (!self.calenderPane.contains(e.target)  && !self.inputPane.contains(e.target))) {
      self.hideElement();
    }
  }else{
    if ((self.calenderPane !== e.target && self.button !== e.target ) && (!self.calenderPane.contains(e.target)  && !self.button.contains(e.target))) {
      self.hideElement();
    }
  }
}

var app = angular.module('smDateTimeRangePicker');
app.directive('smRangePickerInput',['$document','$mdMedia','$mdUtil','picker',RangePickerInput]);

})();
function smRangePicker (picker){
  return{
    restrict : 'E',
    require : ['^?ngModel','smRangePicker'],
    scope:{
      format:'@',
      divider: '@',
      weekStartDay :"@",
      customToHome: "@",
      closeOnSelect: "@",
      mode: "@",      
      showCustom:'@',
      customList: '=',
      minDate : '@',
      maxDate : '@',          
      rangeSelectCall : '&'      
    },
    terminal:true,
    controller: ['$scope','picker',RangePickerCtrl],
    controllerAs : 'vm',
    bindToController:true,
    templateUrl : 'picker/range-picker.html',
    link : function(scope,element,att,ctrls){
      var ngModelCtrl = ctrls[0];
      var calCtrl = ctrls[1];
      calCtrl.configureNgModel(ngModelCtrl);
    }    
  }
}

var RangePickerCtrl = function($scope,picker){
  var self = this;
  self.scope = $scope;
  self.clickedButton = 0;
  self.startShowCustomSettting =self.showCustom;


  self.startDate = moment();
  self.endDate = moment();

  self.divider = angular.isUndefined(self.scope.divider) || self.scope.divider ===''? picker.rangeDivider : $scope.divider;

  self.okLabel = picker.okLabel;
  self.cancelLabel = picker.cancelLabel;
  self.view = 'DATE';

  self.rangeCustomStartEnd = picker.rangeCustomStartEnd;
  var defaultList = [];
  angular.copy(picker.rangeDefaultList,defaultList);
  self.rangeDefaultList =  defaultList;
  if(self.customList){
    for (var i = 0; i < self.customList.length; i++) {
      self.rangeDefaultList[self.customList[i].position] = self.customList[i];
    }
  }

  if(self.showCustom){
    self.selectedTabIndex=0;    
  }else{
    self.selectedTabIndex = $scope.selectedTabIndex;
  }

}

RangePickerCtrl.prototype.configureNgModel = function(ngModelCtrl) {
    this.ngModelCtrl = ngModelCtrl;
    var self = this;
    ngModelCtrl.$render = function() {
      self.ngModelCtrl.$viewValue= self.startDate+' '+ self.divider +' '+self.endDate;
    };
};

RangePickerCtrl.prototype.setNextView = function(){
  switch (this.mode){
    case  'date':
        this.view = 'DATE';             
        if(this.selectedTabIndex ===0 ){
          this.selectedTabIndex =1 
        }
      break;
    case  'date-time':
      if(this.view === 'DATE'){
        this.view = 'TIME';
      }else{
        this.view = 'DATE';
        if(this.selectedTabIndex ===0 ){
          this.selectedTabIndex =1 
        }
      }
      break;
    default:
        this.view = 'DATE';
        if(this.selectedTabIndex ===0 ){
          this.selectedTabIndex =1 
        }        
  }    
} 

RangePickerCtrl.prototype.showCustomView = function(){
  this.showCustom=true;
  this.selectedTabIndex=0

}

RangePickerCtrl.prototype.dateRangeSelected = function(){
    var self = this;
    self.selectedTabIndex =0;
    self.view= 'DATE';
    if(self.startShowCustomSettting){
      self.showCustom=true;
    }else{
      self.showCustom=false;
    }
    self.setNgModelValue(self.startDate,self.divider,self.endDate);
}


RangePickerCtrl.prototype.startDateSelected = function(date){
  this.startDate = date;
  this.scope.$emit('range-picker:startDateSelected');
  this.setNextView();
}

RangePickerCtrl.prototype.startTimeSelected = function(time){

  this.startDate.hour(time.hour()).minute(time.minute());
  this.scope.$emit('range-picker:startTimeSelected');
  this.setNextView();
}


RangePickerCtrl.prototype.endDateSelected = function(date){
  this.endDate = date;
  this.scope.$emit('range-picker:endDateSelected');
  if(this.closeOnSelect && this.mode==='date'){
    this.setNgModelValue(this.startDate,this.divider,this.endDate);
  }else{
    this.setNextView();
  }
}

RangePickerCtrl.prototype.endTimeSelected = function(time){
  this.endDate.hour(time.hour()).minute(time.minute());
  this.scope.$emit('range-picker:endTimeSelected');  
  if(this.closeOnSelect && this.mode==='date-time'){
    this.setNgModelValue(this.startDate,this.divider,this.endDate);    
  }
}


RangePickerCtrl.prototype.setNgModelValue = function(startDate,divider,endDate) {
    var self = this;
    var range = {startDate: startDate.format(self.format) , endDate: endDate.format(self.format)};
    self.rangeSelectCall({range: range});
    self.ngModelCtrl.$setViewValue(startDate.format(self.format)+' '+ divider +' '+endDate.format(self.format));
    self.ngModelCtrl.$render();    
    self.selectedTabIndex =0 
    self.view ="DATE";
    self.scope.$emit('range-picker:close');    
};

RangePickerCtrl.prototype.cancel = function(){
  var self = this;
  if(self.customToHome && self.showCustom){
    self.showCustom=false; 
  }else{
    self.selectedTabIndex =0;
    self.showCustom=false; 
    self.scope.$emit('range-picker:close');        
  }
}

var app = angular.module('smDateTimeRangePicker');
app.directive('smRangePicker',['picker',smRangePicker]);
function smTimePickerNew($mdUtil,$mdMedia,$document,$timeout,picker){
    return {
      restrict : 'E',
      replace:true,
      scope :{
        value: '=',
        startDate : '@',
        weekStartDay : '@',
        startView:"@",                  
        mode : '@',
        format : '@',
        minDate : '@',
        maxDate : '@',
        fname : "@",
        lable : "@",
        isRequired : '@',
        disable : '=',
        form : '=',
	    closeOnSelect:"@"
      },
      template: '  <md-input-container >'
                +'    <label for="{{fname}}">{{lable }}</label>'
                +'    <input name="{{fname}}" ng-model="value" ng-readonly="true"'
                +'             type="text" placeholde="{{lable}}"'
                +'             aria-label="{{fname}}" data-ng-required="isRequired"'
                +'             ng-focus="show()" server-error class="sm-input-container">'
                +'    <div ng-messages="form.fname.$error" ng-if="form[fname].$touched">'
                +'    		<div ng-messages-include="{{ngMassagedTempaltePath}}"></div>'
                +'    </div>'
                +'    <div id="picker" class="sm-calender-pane md-whiteframe-15dp">'
                +'     		<sm-time-picker '
                +'              id="{{fname}}Picker" '  
                +'              ng-model="value" '
                +'				initial-date="{{value}}"'
                +'              mode="{{mode}}" '
                +'				close-on-select="{{closeOnSelect}}"'
                +'              start-view="{{startView}}" '  
                +'              data-min-date="minDate" '
                +'              data-max-date="maxDate"  '
                +'              format="{{format}}"  '
                +'          	start-day="{{weekStartDay}}" > '
                +'			</sm-time-picker>'
                +'    </div>'                
                +'  </md-input-container>',
      link :  function(scope,$element,attr){
        var inputPane = $element[0].querySelector('.sm-input-container');
        var calenderPane = $element[0].querySelector('.sm-calender-pane');
        var cElement = angular.element(calenderPane);
        scope.ngMassagedTempaltePath =picker.massagePath;
        // check if Pre defined format is supplied
        scope.format = angular.isUndefined(scope.format) ? 'MM-DD-YYYY': scope.format;

        
        // Hide calender pane on initialization
        cElement.addClass('hide hide-animate');

        // set start date
        scope.startDate  = angular.isUndefined(scope.value)? scope.startDate : scope.value;

        // Hide Calender on click out side
        $document.on('click', function (e) {
            if ((calenderPane !== e.target && inputPane !==e.target) && (!calenderPane.contains(e.target) && !inputPane.contains(e.target))) {
        		hideElement();
            }
        });

        // if tab out hide key board
        angular.element(inputPane).on('keydown', function (e) {
            if(e.which===9){
        		hideElement();
            }
        });

        // show calender 
        scope.show= function(){
          var elementRect = inputPane.getBoundingClientRect();
          var bodyRect = document.body.getBoundingClientRect();

          cElement.removeClass('hide');
          if($mdMedia('sm') ||  $mdMedia('xs')){
            calenderPane.style.left = (bodyRect.width-300)/2+'px';
            calenderPane.style.top =  (bodyRect.height-450)/2+ 'px';
          }else{
            var rect = getVisibleViewPort(elementRect,bodyRect);
            calenderPane.style.left = (rect.left) + 'px';
            calenderPane.style.top = (rect.top) + 'px';
          }
          document.body.appendChild(calenderPane);
          $mdUtil.disableScrollAround(calenderPane);
          cElement.addClass('show');
        }

        // calculate visible port to display calender
        function getVisibleViewPort(elementRect,bodyRect){
          var calenderHeight = 460;
          var calenderWidth = 296;

          var top =elementRect.top;
          if(elementRect.top +calenderHeight > bodyRect.bottom){
            top = elementRect.top - ((elementRect.top +calenderHeight) - (bodyRect.bottom -20));
          }
          var left = elementRect.left;
          if(elementRect.left +calenderWidth > bodyRect.right){
             left = elementRect.left - ((elementRect.left +calenderWidth) - (bodyRect.right -10));
          }
          return {top : top, left : left };
        }

        function hideElement(){
			     cElement.addClass('hide-animate');
        	cElement.removeClass('show');
          	 //this is only for animation
            //calenderPane.parentNode.removeChild(calenderPane);          
            $mdUtil.enableScrolling();
        }

        scope.$on('$destroy',function(){
          calenderPane.parentNode.removeChild(calenderPane);
        });
                
        //listen to emit for closing calender
        scope.$on('calender:close',function(){
        	hideElement();
        });
    }
  }
} 

var app = angular.module('smDateTimeRangePicker');
app.directive('smTimePickerNew',['$mdUtil','$mdMedia','$document','$timeout','picker',smTimePickerNew]);

(function(){
  'use strict';

      function MenuCtrl ($log, $state, $timeout, $location,$mdSidenav, menu) {

        var vm = this;

        //functions for menu-link and menu-toggle
        vm.isOpen = isOpen;
        vm.toggleOpen = toggleOpen;
        vm.isSectionSelected = isSectionSelected;
        vm.autoFocusContent = false;
        vm.goToState = goToState;
        vm.menu = menu;


        vm.status = {
          isFirstOpen: true,
          isFirstDisabled: false
        };


       function isOpen(section) {
          return menu.isSectionSelected(section);
        }

        function toggleOpen(section) {
          menu.toggleSelectSection(section);
        }

        function isSectionSelected(section) {
          var selected = false;
          var openedSection = menu.openedSection;
          if(openedSection === section){
            selected = true;
          }
          else if(section.children) {
            section.children.forEach(function(childSection) {
              if(childSection === openedSection){
                selected = true;
              }
            });
          }
          return selected;
        }

        function goToState(state){
            $state.go(state);

            $mdSidenav('left').close()
              .then(function () {
                $log.debug('close RIGHT is done ssss');
            });

        };            

      }

  angular.module('demoApp')
    .controller('MenuCtrl', ['$log','$state','$timeout','$location','$mdSidenav','menu', MenuCtrl]);

})();
(function(){
  'use strict';

  angular.module('demoApp')
    .run(['$templateCache', function ($templateCache) {
      $templateCache.put('partials/menu-link.tmpl.html',
        '<md-button class="md-button" href  \n' +
        ' ng-click="focusSection(section)">\n' +
        '  <i ng-if="section.icon" class="menu-icon material-icons">' +
        '     {{section.icon}}</i>\n' +
        '    <div class="menu-text-container">\n' +
        '       <span class="menu-text">{{section | humanizeDoc}}</span>\n' +
        '    </div>\n' +
        '</md-button>');
    }])
    .directive('menuLink', function () {
      return {
        scope: {
          section: '='
        },
        templateUrl: 'partials/menu-link.tmpl.html',
        link: function ($scope, $element) {

          var controller = $element.parent().controller();

          $scope.focusSection = function (section) {
            // set flag to be used later when
            // $locationChangeSuccess calls openPage()
            controller.autoFocusContent = true;
            controller.goToState(section.state);

          };
        }
      };
    })
})();

(function(){

  'use strict';

  angular.module('demoApp')
    .factory('menu', [
      '$location',
      function ($location) {

        var sections = [{
          name: 'Home',
          state: 'home',
          type: 'link',
          icon: 'home',
        }];

        sections.push({
          name: 'Date Picker',
          type: 'toggle',
          iconp: 'date_range',
          pages: [{
            name: 'Demo',
            type: 'link',
            state: 'date-time-picker'
          },{
            name: 'API',
            type: 'link',
            state: 'date-time-picker-api'
          }]
        });

        sections.push({
          name: 'Time Picker',
          type: 'toggle',
          iconp: 'watch_later',
          pages: [{
            name: 'Demo',
            type: 'link',
            state: 'time-picker-demo'
          },{
            name: 'API',
            type: 'link',
            state: 'time-picker-api'
          }]
        });


        sections.push({
          name: 'Range Picker',
          type: 'toggle',
          iconp: 'timeline',
          pages: [{
            name: 'Demo',
            type: 'link',
            state: 'range-picker-demo'
          },{
            name: 'API',
            type: 'link',
            state: 'range-picker-api'
          }]
          
        });


        var self;

        return self = {
          sections: sections,

          toggleSelectSection: function (section) {
            self.openedSection = (self.openedSection === section ? null : section);
          },
          isSectionSelected: function (section) {
            return self.openedSection === section;
          },

          selectPage: function (section, page) {
            page && page.url && $location.path(page.url);
            self.currentSection = section;
            self.currentPage = page;
          }
        };
      }]).filter('nospace', function () {
      return function (value) {
        return (!value) ? '' : value.replace(/ /g, '');
      };
    })
    //replace uppercase to regular case
    .filter('humanizeDoc', function () {
      return function (doc) {
        if (!doc) return;
        if (doc.type === 'directive') {
          return doc.name.replace(/([A-Z])/g, function ($1) {
            return '-' + $1.toLowerCase();
          });
        }

        return doc.label || doc.name;
      };
    });

})();


(function(){
  angular.module('demoApp')
    .run(['$templateCache', function($templateCache){
      $templateCache.put('partials/menu-toggle.tmpl.html',
        '<a href\n' +
        '  ng-click="toggle()"\n' +
        '  aria-controls="side-menu-{{section.name | nospace}}"\n' +
        '  aria-expanded="{{isOpen()}}">\n' +
        '  <md-icon class="menu-icon" md-font-icon="material-icons">{{section.iconp}}</md-icon> ' +
        ' <div class="menu-text-container">\n ' +
        '      <span class="menu-text">{{section.name}}</span>\n' +
        '      <md-icon aria-hidden="true" class="menu-toggle-icon" ng-class="{\'toggled\' : isOpen()}">keyboard_arrow_right</md-icon>\n' +
        ' </div>\n' +
        '</a>\n' +
        '<ul ng-show="isOpen()" id="side-menu-{{section.name | nospace}}" class="menu-toggle-list">\n' +
        '  <li ng-repeat="page in section.pages">\n' +
        '    <menu-link section="page"></menu-link>\n' +
        '  </li>\n' +
        '</ul>\n' +
        '');
    }])
    .directive('menuToggle', [ '$timeout', function($timeout) {
      return {
        scope: {
          section: '='
        },
        templateUrl: 'partials/menu-toggle.tmpl.html',
        link: function($scope, $element) {
          
          var controller = $element.parent().controller();

          $scope.isOpen = function() {
            return controller.isOpen($scope.section);
          };
          $scope.toggle = function() {
            controller.toggleOpen($scope.section);
          };
        }
      };
    }])

})();


/*(function(){
  angular.module('demoApp')
    .run(['$templateCache', function($templateCache){
      $templateCache.put('partials/menu-toggle.tmpl.html',
        '<a class="md-button-toggle"\n' +
        '  ng-click="toggle()"\n' +
        '  aria-controls="side-menu-{{section.name | nospace}}"\n' +
        '  flex layout="row"\n' +
        '  aria-expanded="{{isOpen()}}">\n' +
        '  <md-icon md-font-icon="material-icons">{{section.iconp}}</md-icon> {{section.name}}\n' +
        '  <span aria-hidden="true" class="pull-right material-icons md-toggle-icon"\n' +
        '  ng-class="{\'toggled\' : isOpen()}">keyboard_arrow_down</span>\n' +
        '</a>\n' +
        '<ul ng-show="isOpen()" id="side-menu-{{section.name | nospace}}" class="menu-toggle-list">\n' +
        '  <li ng-repeat="page in section.pages">\n' +
        '    <menu-link section="page"></menu-link>\n' +
        '  </li>\n' +
        '</ul>\n' +
        '');
    }])
    .directive('menuToggle', [ '$timeout', function($timeout) {
      return {
        scope: {
          section: '='
        },
        templateUrl: 'partials/menu-toggle.tmpl.html',
        link: function($scope, $element) {
          var controller = $element.parent().controller();

          $scope.isOpen = function() {
            return controller.isOpen($scope.section);
          };
          $scope.toggle = function() {
            controller.toggleOpen($scope.section);
          };
        }
      };
    }])

})();*/