/**
 * allows override of the default value based on the parameter being
 * supplied
 **/
var applyParameterMacro = function (operation, parameter) {
  var e = (typeof window !== 'undefined' ? window : exports);
  if(e.parameterMacro)
    return e.parameterMacro(operation, parameter);
  else
    return parameter.defaultValue;
};

/**
 * allows overriding the default value of an model property
 **/
var applyModelPropertyMacro = function (model, property) {
  var e = (typeof window !== 'undefined' ? window : exports);
  if(e.modelPropertyMacro)
    return e.modelPropertyMacro(model, property);
  else
    return property.defaultValue;
};
