SwaggerClient.prototype.buildFrom1_2Spec = function (response) {
  if (response.apiVersion !== null) {
    this.apiVersion = response.apiVersion;
  }
  this.apis = {};
  this.apisArray = [];
  this.consumes = response.consumes;
  this.produces = response.produces;
  this.authSchemes = response.authorizations;
  this.info = this.convertInfo(response.info);

  var isApi = false, i, res;
  for (i = 0; i < response.apis.length; i++) {
    var api = response.apis[i];
    if (api.operations) {
      var j;
      for (j = 0; j < api.operations.length; j++) {
        operation = api.operations[j];
        isApi = true;
      }
    }
  }
  if (response.basePath)
    this.basePath = response.basePath;
  else if (this.url.indexOf('?') > 0)
    this.basePath = this.url.substring(0, this.url.lastIndexOf('?'));
  else
    this.basePath = this.url;

  if (isApi) {
    var newName = response.resourcePath.replace(/\//g, '');
    this.resourcePath = response.resourcePath;
    res = new SwaggerResource(response, this);
    this.apis[newName] = res;
    this.apisArray.push(res);
    this.finish();
  } else {
    var k;
    this.expectedResourceCount = response.apis.length;
    for (k = 0; k < response.apis.length; k++) {
      var resource = response.apis[k];
      res = new SwaggerResource(resource, this);
      this.apis[res.name] = res;
      this.apisArray.push(res);
    }
  }
  this.isValid = true;
  return this;
};

SwaggerClient.prototype.finish = function() {
  if (typeof this.success === 'function') {
    this.isValid = true;
    this.ready = true;
    this.isBuilt = true;
    this.selfReflect();
    this.success();
  }  
};

SwaggerClient.prototype.buildFrom1_1Spec = function (response) {
  log('This API is using a deprecated version of Swagger!  Please see http://github.com/wordnik/swagger-core/wiki for more info');
  if (response.apiVersion !== null)
    this.apiVersion = response.apiVersion;
  this.apis = {};
  this.apisArray = [];
  this.produces = response.produces;
  this.info = this.convertInfo(response.info);
  var isApi = false, res;
  for (var i = 0; i < response.apis.length; i++) {
    var api = response.apis[i];
    if (api.operations) {
      for (var j = 0; j < api.operations.length; j++) {
        operation = api.operations[j];
        isApi = true;
      }
    }
  }
  if (response.basePath) {
    this.basePath = response.basePath;
  } else if (this.url.indexOf('?') > 0) {
    this.basePath = this.url.substring(0, this.url.lastIndexOf('?'));
  } else {
    this.basePath = this.url;
  }
  if (isApi) {
    var newName = response.resourcePath.replace(/\//g, '');
    this.resourcePath = response.resourcePath;
    res = new SwaggerResource(response, this);
    this.apis[newName] = res;
    this.apisArray.push(res);
    this.finish();
  } else {
    this.expectedResourceCount = response.apis.length;
    for (k = 0; k < response.apis.length; k++) {
      resource = response.apis[k];
      res = new SwaggerResource(resource, this);
      this.apis[res.name] = res;
      this.apisArray.push(res);
    }
  }
  this.isValid = true;
  return this;
};

SwaggerClient.prototype.convertInfo = function (resp) {
  if(typeof resp == 'object') {
    var info = {};

    info.title = resp.title;
    info.description = resp.description;
    info.termsOfService = resp.termsOfServiceUrl;
    info.contact = {};
    info.contact.name = resp.contact;
    info.license = {};
    info.license.name = resp.license;
    info.license.url = resp.licenseUrl;

    return info;
  }
};

SwaggerClient.prototype.selfReflect = function () {
  var resource, tag, ref;
  if (this.apis === null) {
    return false;
  }
  ref = this.apis;
  for (tag in ref) {
    api = ref[tag];
    if (api.ready === null) {
      return false;
    }
    this[tag] = api;
    this[tag].help = __bind(api.help, api);
  }
  this.setConsolidatedModels();
  this.ready = true;
};

SwaggerClient.prototype.setConsolidatedModels = function () {
  var model, modelName, resource, resource_name, i, apis, models, results;
  this.models = {};
  apis = this.apis;
  for (resource_name in apis) {
    resource = apis[resource_name];
    for (modelName in resource.models) {
      if (typeof this.models[modelName] === 'undefined') {
        this.models[modelName] = resource.models[modelName];
        this.modelsArray.push(resource.models[modelName]);
      }
    }
  }
  models = this.modelsArray;
  results = [];
  for (i = 0; i < models.length; i++) {
    model = models[i];
    results.push(model.setReferencedModels(this.models));
  }
  return results;
};

var SwaggerResource = function (resourceObj, api) {
  var _this = this;
  this.api = api;
  this.swaggerRequestHeaders = api.swaggerRequestHeaders;
  this.path = (typeof this.api.resourcePath === 'string') ? this.api.resourcePath : resourceObj.path;
  this.description = resourceObj.description;
  this.authorizations = (resourceObj.authorizations || {});

  var parts = this.path.split('/');
  this.name = parts[parts.length - 1].replace('.{format}', '');
  this.basePath = this.api.basePath;
  this.operations = {};
  this.operationsArray = [];
  this.modelsArray = [];
  this.models = api.models || {};
  this.rawModels = {};
  this.useJQuery = (typeof api.useJQuery !== 'undefined') ? api.useJQuery : null;

  if ((resourceObj.apis) && this.api.resourcePath) {
    this.addApiDeclaration(resourceObj);
  } else {
    if (typeof this.path === 'undefined') {
      this.api.fail('SwaggerResources must have a path.');
    }
    if (this.path.substring(0, 4) === 'http') {
      this.url = this.path.replace('{format}', 'json');
    } else {
      this.url = this.api.basePath + this.path.replace('{format}', 'json');
    }
    this.api.progress('fetching resource ' + this.name + ': ' + this.url);
    var obj = {
      url: this.url,
      method: 'GET',
      useJQuery: this.useJQuery,
      headers: {
        accept: this.swaggerRequestHeaders
      },
      on: {
        response: function (resp) {
          var responseObj = resp.obj || JSON.parse(resp.data);
          _this.api.resourceCount += 1;
          return _this.addApiDeclaration(responseObj);
        },
        error: function (response) {
          _this.api.resourceCount += 1;
          return _this.api.fail('Unable to read api \'' +
          _this.name + '\' from path ' + _this.url + ' (server returned ' + response.statusText + ')');
        }
      }
    };
    var e = typeof window !== 'undefined' ? window : exports;
    e.authorizations.apply(obj);
    new SwaggerHttp().execute(obj);
  }
};

SwaggerResource.prototype.help = function (dontPrint) {
  var i;
  var output = 'operations for the "' + this.name + '" tag';
  for(i = 0; i < this.operationsArray.length; i++) {
    var api = this.operationsArray[i];
    output += '\n  * ' + api.nickname + ': ' + api.description;
  }
  if(dontPrint)
    return output;
  else {
    log(output);
    return output;
  }
};

SwaggerResource.prototype.getAbsoluteBasePath = function (relativeBasePath) {
  var pos, url;
  url = this.api.basePath;
  pos = url.lastIndexOf(relativeBasePath);
  var parts = url.split('/');
  var rootUrl = parts[0] + '//' + parts[2];

  if (relativeBasePath.indexOf('http') === 0)
    return relativeBasePath;
  if (relativeBasePath === '/')
    return rootUrl;
  if (relativeBasePath.substring(0, 1) == '/') {
    // use root + relative
    return rootUrl + relativeBasePath;
  }
  else {
    pos = this.basePath.lastIndexOf('/');
    var base = this.basePath.substring(0, pos);
    if (base.substring(base.length - 1) == '/')
      return base + relativeBasePath;
    else
      return base + '/' + relativeBasePath;
  }
};

SwaggerResource.prototype.addApiDeclaration = function (response) {
  if (typeof response.produces === 'string')
    this.produces = response.produces;
  if (typeof response.consumes === 'string')
    this.consumes = response.consumes;
  if ((typeof response.basePath === 'string') && response.basePath.replace(/\s/g, '').length > 0)
    this.basePath = response.basePath.indexOf('http') === -1 ? this.getAbsoluteBasePath(response.basePath) : response.basePath;
  this.resourcePath = response.resourcePath;
  this.addModels(response.models);
  if (response.apis) {
    for (var i = 0 ; i < response.apis.length; i++) {
      var endpoint = response.apis[i];
      this.addOperations(endpoint.path, endpoint.operations, response.consumes, response.produces);
    }
  }
  this.api[this.name] = this;
  this.ready = true;
  if(this.api.resourceCount === this.api.expectedResourceCount)
    this.api.finish();
  return this;
};

SwaggerResource.prototype.addModels = function (models) {
  if (typeof models === 'object') {
    var modelName;
    for (modelName in models) {
      if (typeof this.models[modelName] === 'undefined') {
        var swaggerModel = new SwaggerModel(modelName, models[modelName]);
        this.modelsArray.push(swaggerModel);
        this.models[modelName] = swaggerModel;
        this.rawModels[modelName] = models[modelName];
      }
    }
    var output = [];
    for (var i = 0; i < this.modelsArray.length; i++) {
      var model = this.modelsArray[i];
      output.push(model.setReferencedModels(this.models));
    }
    return output;
  }
};

SwaggerResource.prototype.addOperations = function (resource_path, ops, consumes, produces) {
  if (ops) {
    var output = [];
    for (var i = 0; i < ops.length; i++) {
      var o = ops[i];
      consumes = this.consumes;
      produces = this.produces;
      if (typeof o.consumes !== 'undefined')
        consumes = o.consumes;
      else
        consumes = this.consumes;

      if (typeof o.produces !== 'undefined')
        produces = o.produces;
      else
        produces = this.produces;
      var type = (o.type || o.responseClass);

      if (type === 'array') {
        ref = null;
        if (o.items)
          ref = o.items.type || o.items.$ref;
        type = 'array[' + ref + ']';
      }
      var responseMessages = o.responseMessages;
      var method = o.method;
      if (o.httpMethod) {
        method = o.httpMethod;
      }
      if (o.supportedContentTypes) {
        consumes = o.supportedContentTypes;
      }
      if (o.errorResponses) {
        responseMessages = o.errorResponses;
        for (var j = 0; j < responseMessages.length; j++) {
          r = responseMessages[j];
          r.message = r.reason;
          r.reason = null;
        }
      }
      o.nickname = this.sanitize(o.nickname);
      var op = new SwaggerOperation(o.nickname,
          resource_path,
          method,
          o.parameters,
          o.summary,
          o.notes,
          type,
          responseMessages, 
          this, 
          consumes, 
          produces, 
          o.authorizations, 
          o.deprecated);

      this.operations[op.nickname] = op;
      output.push(this.operationsArray.push(op));
    }
    return output;
  }
};

SwaggerResource.prototype.sanitize = function (nickname) {
  var op;
  op = nickname.replace(/[\s!@#$%^&*()_+=\[{\]};:<>|.\/?,\\'""-]/g, '_');
  op = op.replace(/((_){2,})/g, '_');
  op = op.replace(/^(_)*/g, '');
  op = op.replace(/([_])*$/g, '');
  return op;
};

var SwaggerModel = function (modelName, obj) {
  this.name = typeof obj.id !== 'undefined' ? obj.id : modelName;
  this.properties = [];
  var propertyName;
  for (propertyName in obj.properties) {
    if (obj.required) {
      var value;
      for (value in obj.required) {
        if (propertyName === obj.required[value]) {
          obj.properties[propertyName].required = true;
        }
      }
    }
    var prop = new SwaggerModelProperty(propertyName, obj.properties[propertyName], this);
    this.properties.push(prop);
  }
};

SwaggerModel.prototype.setReferencedModels = function (allModels) {
  var results = [];
  for (var i = 0; i < this.properties.length; i++) {
    var property = this.properties[i];
    var type = property.type || property.dataType;
    if (allModels[type])
      results.push(property.refModel = allModels[type]);
    else if ((property.refDataType) && (allModels[property.refDataType]))
      results.push(property.refModel = allModels[property.refDataType]);
    else
      results.push(void 0);
  }
  return results;
};

SwaggerModel.prototype.getMockSignature = function (modelsToIgnore) {
  var i, prop, propertiesStr = [];
  for (i = 0; i < this.properties.length; i++) {
    prop = this.properties[i];
    propertiesStr.push(prop.toString());
  }

  var strong = '<span class="strong">';
  var strongClose = '</span>';
  var classOpen = strong + this.name + ' {' + strongClose;
  var classClose = strong + '}' + strongClose;
  var returnVal = classOpen + '<div>' + propertiesStr.join(',</div><div>') + '</div>' + classClose;
  if (!modelsToIgnore)
    modelsToIgnore = [];
  modelsToIgnore.push(this.name);

  for (i = 0; i < this.properties.length; i++) {
    prop = this.properties[i];
    if ((prop.refModel) && modelsToIgnore.indexOf(prop.refModel.name) === -1) {
      returnVal = returnVal + ('<br>' + prop.refModel.getMockSignature(modelsToIgnore));
    }
  }
  return returnVal;
};

SwaggerModel.prototype.createJSONSample = function (modelsToIgnore) {
  if (sampleModels[this.name]) {
    return sampleModels[this.name];
  }
  else {
    var result = {};
    modelsToIgnore = (modelsToIgnore || []);
    modelsToIgnore.push(this.name);
    for (var i = 0; i < this.properties.length; i++) {
      var prop = this.properties[i];
      result[prop.name] = prop.getSampleValue(modelsToIgnore);
    }
    modelsToIgnore.pop(this.name);
    return result;
  }
};

var SwaggerModelProperty = function (name, obj, model) {
  this.name = name;
  this.dataType = obj.type || obj.dataType || obj.$ref;
  this.isCollection = this.dataType && (this.dataType.toLowerCase() === 'array' || this.dataType.toLowerCase() === 'list' || this.dataType.toLowerCase() === 'set');
  this.descr = obj.description;
  this.required = obj.required;
  this.defaultValue = applyModelPropertyMacro(obj, model);
  if (obj.items) {
    if (obj.items.type) {
      this.refDataType = obj.items.type;
    }
    if (obj.items.$ref) {
      this.refDataType = obj.items.$ref;
    }
  }
  this.dataTypeWithRef = this.refDataType ? (this.dataType + '[' + this.refDataType + ']') : this.dataType;
  if (obj.allowableValues) {
    this.valueType = obj.allowableValues.valueType;
    this.values = obj.allowableValues.values;
    if (this.values) {
      this.valuesString = '\'' + this.values.join('\' or \'') + '\'';
    }
  }
  if (obj['enum']) {
    this.valueType = 'string';
    this.values = obj['enum'];
    if (this.values) {
      this.valueString = '\'' + this.values.join('\' or \'') + '\'';
    }
  }
};

SwaggerModelProperty.prototype.getSampleValue = function (modelsToIgnore) {
  var result;
  if ((this.refModel) && (modelsToIgnore.indexOf(this.refModel.name) === -1)) {
    result = this.refModel.createJSONSample(modelsToIgnore);
  } else {
    if (this.isCollection) {
      result = this.toSampleValue(this.refDataType);
    } else {
      result = this.toSampleValue(this.dataType);
    }
  }
  if (this.isCollection) {
    return [result];
  } else {
    return result;
  }
};

SwaggerModelProperty.prototype.toSampleValue = function (value) {
  var result;
  if ((typeof this.defaultValue !== 'undefined') && this.defaultValue) {
    result = this.defaultValue;
  } else if (value === 'integer') {
    result = 0;
  } else if (value === 'boolean') {
    result = false;
  } else if (value === 'double' || value === 'number') {
    result = 0.0;
  } else if (value === 'string') {
    result = '';
  } else {
    result = value;
  }
  return result;
};

SwaggerModelProperty.prototype.toString = function () {
  var req = this.required ? 'propReq' : 'propOpt';
  var str = '<span class="propName ' + req + '">' + this.name + '</span> (<span class="propType">' + this.dataTypeWithRef + '</span>';
  if (!this.required) {
    str += ', <span class="propOptKey">optional</span>';
  }
  str += ')';
  if (this.values) {
    str += ' = <span class="propVals">[\'' + this.values.join('\' or \'') + '\']</span>';
  }
  if (this.descr) {
    str += ': <span class="propDesc">' + this.descr + '</span>';
  }
  return str;
};

var SwaggerOperation = function (nickname, path, method, parameters, summary, notes, type, responseMessages, resource, consumes, produces, authorizations, deprecated) {
  var _this = this;

  var errors = [];
  this.nickname = (nickname || errors.push('SwaggerOperations must have a nickname.'));
  this.path = (path || errors.push('SwaggerOperation ' + nickname + ' is missing path.'));
  this.method = (method || errors.push('SwaggerOperation ' + nickname + ' is missing method.'));
  this.parameters = parameters ? parameters : [];
  this.summary = summary;
  this.notes = notes;
  this.type = type;
  this.responseMessages = (responseMessages || []);
  this.resource = (resource || errors.push('Resource is required'));
  this.consumes = consumes;
  this.produces = produces;
  this.authorizations = typeof authorizations !== 'undefined' ? authorizations : resource.authorizations;
  this.deprecated = deprecated;
  this['do'] = __bind(this['do'], this);


  if(typeof this.deprecated === 'string') {
    switch(this.deprecated.toLowerCase()) {
      case 'true': case 'yes': case '1': {
        this.deprecated = true;
        break;
      }
      case 'false': case 'no': case '0': case null: {
        this.deprecated = false;
        break;
      }
      default: this.deprecated = Boolean(this.deprecated);
    }
  }

  if (errors.length > 0) {
    console.error('SwaggerOperation errors', errors, arguments);
    this.resource.api.fail(errors);
  }

  this.path = this.path.replace('{format}', 'json');
  this.method = this.method.toLowerCase();
  this.isGetMethod = this.method === 'get';

  var i, j, v;
  this.resourceName = this.resource.name;
  if (typeof this.type !== 'undefined' && this.type === 'void')
    this.type = null;
  else {
    this.responseClassSignature = this.getSignature(this.type, this.resource.models);
    this.responseSampleJSON = this.getSampleJSON(this.type, this.resource.models);
  }

  for (i = 0; i < this.parameters.length; i++) {
    var param = this.parameters[i];
    // might take this away
    param.name = param.name || param.type || param.dataType;
    // for 1.1 compatibility
    type = param.type || param.dataType;
    if (type === 'array') {
      type = 'array[' + (param.items.$ref ? param.items.$ref : param.items.type) + ']';
    }
    param.type = type;

    if (type && type.toLowerCase() === 'boolean') {
      param.allowableValues = {};
      param.allowableValues.values = ['true', 'false'];
    }
    param.signature = this.getSignature(type, this.resource.models);
    param.sampleJSON = this.getSampleJSON(type, this.resource.models);

    var enumValue = param['enum'];
    if (typeof enumValue !== 'undefined') {
      param.isList = true;
      param.allowableValues = {};
      param.allowableValues.descriptiveValues = [];

      for (j = 0; j < enumValue.length; j++) {
        v = enumValue[j];
        if (param.defaultValue) {
          param.allowableValues.descriptiveValues.push({
            value: String(v),
            isDefault: (v === param.defaultValue)
          });
        }
        else {
          param.allowableValues.descriptiveValues.push({
            value: String(v),
            isDefault: false
          });
        }
      }
    }
    else if (param.allowableValues) {
      if (param.allowableValues.valueType === 'RANGE')
        param.isRange = true;
      else
        param.isList = true;
      if (param.allowableValues) {
        param.allowableValues.descriptiveValues = [];
        if (param.allowableValues.values) {
          for (j = 0; j < param.allowableValues.values.length; j++) {
            v = param.allowableValues.values[j];
            if (param.defaultValue !== null) {
              param.allowableValues.descriptiveValues.push({
                value: String(v),
                isDefault: (v === param.defaultValue)
              });
            }
            else {
              param.allowableValues.descriptiveValues.push({
                value: String(v),
                isDefault: false
              });
            }
          }
        }
      }
    }
    param.defaultValue = applyParameterMacro(this, param);
  }
  var defaultSuccessCallback = this.resource.api.defaultSuccessCallback || null;
  var defaultErrorCallback = this.resource.api.defaultErrorCallback || null;

  this.resource[this.nickname] = function (args, opts, callback, error) {
    var arg1, arg2, arg3, arg4;
    if(typeof args === 'function') {  // right shift 3
      arg1 = {}; arg2 = {}; arg3 = args; arg4 = opts;
    }
    else if(typeof args === 'object' && typeof opts === 'function') { // right shift 2
      arg1 = args; arg2 = {}; arg3 = opts; arg4 = callback;
    }
    else {
      arg1 = args; arg2 = opts; arg3 = callback; arg4 = error;
    }
    return _this['do'](arg1 || {}, arg2 || {}, arg3 || defaultSuccessCallback, arg4 || defaultErrorCallback);
  };

  this.resource[this.nickname].help = function (dontPrint) {
    return _this.help(dontPrint);
  };
  this.resource[this.nickname].asCurl = function (args) {
    return _this.asCurl(args);
  };
};

SwaggerOperation.prototype.isListType = function (type) {
  if (type && type.indexOf('[') >= 0) {
    return type.substring(type.indexOf('[') + 1, type.indexOf(']'));
  } else {
    return void 0;
  }
};

SwaggerOperation.prototype.getSignature = function (type, models) {
  var isPrimitive, listType;
  listType = this.isListType(type);
  isPrimitive = ((typeof listType !== 'undefined') && models[listType]) || (typeof models[type] !== 'undefined') ? false : true;
  if (isPrimitive) {
    return type;
  } else {
    if (typeof listType !== 'undefined') {
      return models[listType].getMockSignature();
    } else {
      return models[type].getMockSignature();
    }
  }
};

SwaggerOperation.prototype.getSampleJSON = function (type, models) {
  var isPrimitive, listType, val;
  listType = this.isListType(type);
  isPrimitive = ((typeof listType !== 'undefined') && models[listType]) || (typeof models[type] !== 'undefined') ? false : true;
  val = isPrimitive ? void 0 : (listType ? models[listType].createJSONSample() : models[type].createJSONSample());
  if (val) {
    val = listType ? [val] : val;
    if (typeof val == 'string')
      return val;
    else if (typeof val === 'object') {
      var t = val;
      if (val instanceof Array && val.length > 0) {
        t = val[0];
      }
      if (t.nodeName) {
        var xmlString = new XMLSerializer().serializeToString(t);
        return this.formatXml(xmlString);
      }
      else
        return JSON.stringify(val, null, 2);
    }
    else
      return val;
  }
};

SwaggerOperation.prototype['do'] = function (args, opts, callback, error) {
  var key, param, params, possibleParams = [], req, value;

  if (typeof error !== 'function') {
    error = function (xhr, textStatus, error) {
      return log(xhr, textStatus, error);
    };
  }

  if (typeof callback !== 'function') {
    callback = function (response) {
      var content;
      content = null;
      if (response !== null) {
        content = response.data;
      } else {
        content = 'no data';
      }
      return log('default callback: ' + content);
    };
  }

  params = {};
  params.headers = [];
  if (args.headers) {
    params.headers = args.headers;
    delete args.headers;
  }
  // allow override from the opts
  if(opts && opts.responseContentType) {
    params.headers['Content-Type'] = opts.responseContentType;
  }
  if(opts && opts.requestContentType) {
    params.headers.Accept = opts.requestContentType;
  }

  for (var i = 0; i < this.parameters.length; i++) {
    param = this.parameters[i];
    if (param.paramType === 'header') {
      if (typeof args[param.name] !== 'undefined')
        params.headers[param.name] = args[param.name];
    }
    else if (param.paramType === 'form' || param.paramType.toLowerCase() === 'file')
      possibleParams.push(param);
    else if (param.paramType === 'body' && param.name !== 'body' && typeof args[param.name] !== 'undefined') {
      if (args.body) {
        throw new Error('Saw two body params in an API listing; expecting a max of one.');
      }
      args.body = args[param.name];
    }
  }

  if (typeof args.body !== 'undefined') {
    params.body = args.body;
    delete args.body;
  }

  if (possibleParams) {
    for (key in possibleParams) {
      value = possibleParams[key];
      if (args[value.name]) {
        params[value.name] = args[value.name];
      }
    }
  }

  req = new SwaggerRequest(this.method, this.urlify(args), params, opts, callback, error, this);
  if (opts.mock) {
    return req;
  } else {
    return true;
  }
};

SwaggerOperation.prototype.pathJson = function () {
  return this.path.replace('{format}', 'json');
};

SwaggerOperation.prototype.pathXml = function () {
  return this.path.replace('{format}', 'xml');
};

SwaggerOperation.prototype.encodePathParam = function (pathParam) {
  var encParts, part, parts, _i, _len;
  pathParam = pathParam.toString();
  if (pathParam.indexOf('/') === -1) {
    return encodeURIComponent(pathParam);
  } else {
    parts = pathParam.split('/');
    encParts = [];
    for (_i = 0, _len = parts.length; _i < _len; _i++) {
      part = parts[_i];
      encParts.push(encodeURIComponent(part));
    }
    return encParts.join('/');
  }
};

SwaggerOperation.prototype.urlify = function (args) {
  var i, j, param, url;
  // ensure no double slashing...
  if(this.resource.basePath.length > 1 && this.resource.basePath.slice(-1) === '/' && this.pathJson().charAt(0) === '/')
    url = this.resource.basePath + this.pathJson().substring(1);
  else
    url = this.resource.basePath + this.pathJson();
  var params = this.parameters;
  for (i = 0; i < params.length; i++) {
    param = params[i];
    if (param.paramType === 'path') {
      if (typeof args[param.name] !== 'undefined') {
        // apply path params and remove from args
        var reg = new RegExp('\\{\\s*?' + param.name + '[^\\{\\}\\/]*(?:\\{.*?\\}[^\\{\\}\\/]*)*\\}(?=(\\/?|$))', 'gi');
        url = url.replace(reg, this.encodePathParam(args[param.name]));
        delete args[param.name];
      }
      else
        throw '' + param.name + ' is a required path param.';
    }
  }

  var queryParams = '';
  for (i = 0; i < params.length; i++) {
    param = params[i];
    if(param.paramType === 'query') {
      if (queryParams !== '')
        queryParams += '&';    
      if (Array.isArray(param)) {
        var output = '';   
        for(j = 0; j < param.length; j++) {    
          if(j > 0)    
            output += ',';   
          output += encodeURIComponent(param[j]);    
        }    
        queryParams += encodeURIComponent(param.name) + '=' + output;    
      }
      else {
        if (typeof args[param.name] !== 'undefined') {
          queryParams += encodeURIComponent(param.name) + '=' + encodeURIComponent(args[param.name]);
        } else {
          if (param.required)
            throw '' + param.name + ' is a required query param.';
        }
      }
    }
  }
  if ((queryParams) && queryParams.length > 0)
    url += '?' + queryParams;
  return url;
};

SwaggerOperation.prototype.supportHeaderParams = function () {
  return this.resource.api.supportHeaderParams;
};

SwaggerOperation.prototype.supportedSubmitMethods = function () {
  return this.resource.api.supportedSubmitMethods;
};

SwaggerOperation.prototype.getQueryParams = function (args) {
  return this.getMatchingParams(['query'], args);
};

SwaggerOperation.prototype.getHeaderParams = function (args) {
  return this.getMatchingParams(['header'], args);
};

SwaggerOperation.prototype.getMatchingParams = function (paramTypes, args) {
  var matchingParams = {};
  var params = this.parameters;
  for (var i = 0; i < params.length; i++) {
    param = params[i];
    if (args && args[param.name])
      matchingParams[param.name] = args[param.name];
  }
  var headers = this.resource.api.headers;
  var name;
  for (name in headers) {
    var value = headers[name];
    matchingParams[name] = value;
  }
  return matchingParams;
};

SwaggerOperation.prototype.help = function (dontPrint) {
  var msg = this.nickname + ': ' + this.summary;
  var params = this.parameters;
  for (var i = 0; i < params.length; i++) {
    var param = params[i];
    msg += '\n* ' + param.name + (param.required ? ' (required)' : '') + " - " + param.description;
  }
  if(dontPrint)
    return msg;
  else {
    console.log(msg);
    return msg;
  }
};

SwaggerOperation.prototype.asCurl = function (args) {
  var results = [];
  var i;

  var headers = SwaggerRequest.prototype.setHeaders(args, {}, this);    
  for(i = 0; i < this.parameters.length; i++) {
    var param = this.parameters[i];
    if(param.paramType && param.paramType === 'header' && args[param.name]) {
      headers[param.name] = args[param.name];
    }
  }

  var key;
  for (key in headers) {
    results.push('--header "' + key + ': ' + headers[key] + '"');
  }
  return 'curl ' + (results.join(' ')) + ' ' + this.urlify(args);
};

SwaggerOperation.prototype.formatXml = function (xml) {
  var contexp, formatted, indent, lastType, lines, ln, pad, reg, transitions, wsexp, _fn, _i, _len;
  reg = /(>)(<)(\/*)/g;
  wsexp = /[ ]*(.*)[ ]+\n/g;
  contexp = /(<.+>)(.+\n)/g;
  xml = xml.replace(reg, '$1\n$2$3').replace(wsexp, '$1\n').replace(contexp, '$1\n$2');
  pad = 0;
  formatted = '';
  lines = xml.split('\n');
  indent = 0;
  lastType = 'other';
  transitions = {
    'single->single': 0,
    'single->closing': -1,
    'single->opening': 0,
    'single->other': 0,
    'closing->single': 0,
    'closing->closing': -1,
    'closing->opening': 0,
    'closing->other': 0,
    'opening->single': 1,
    'opening->closing': 0,
    'opening->opening': 1,
    'opening->other': 1,
    'other->single': 0,
    'other->closing': -1,
    'other->opening': 0,
    'other->other': 0
  };
  _fn = function (ln) {
    var fromTo, j, key, padding, type, types, value;
    types = {
      single: Boolean(ln.match(/<.+\/>/)),
      closing: Boolean(ln.match(/<\/.+>/)),
      opening: Boolean(ln.match(/<[^!?].*>/))
    };
    type = ((function () {
      var _results;
      _results = [];
      for (key in types) {
        value = types[key];
        if (value) {
          _results.push(key);
        }
      }
      return _results;
    })())[0];
    type = type === void 0 ? 'other' : type;
    fromTo = lastType + '->' + type;
    lastType = type;
    padding = '';
    indent += transitions[fromTo];
    padding = ((function () {
      var _j, _ref5, _results;
      _results = [];
      for (j = _j = 0, _ref5 = indent; 0 <= _ref5 ? _j < _ref5 : _j > _ref5; j = 0 <= _ref5 ? ++_j : --_j) {
        _results.push('  ');
      }
      return _results;
    })()).join('');
    if (fromTo === 'opening->closing') {
      formatted = formatted.substr(0, formatted.length - 1) + ln + '\n';
    } else {
      formatted += padding + ln + '\n';
    }
  };
  for (_i = 0, _len = lines.length; _i < _len; _i++) {
    ln = lines[_i];
    _fn(ln);
  }
  return formatted;
};

var SwaggerRequest = function (type, url, params, opts, successCallback, errorCallback, operation, execution) {
  var _this = this;
  var errors = [];

  this.useJQuery = (typeof operation.resource.useJQuery !== 'undefined' ? operation.resource.useJQuery : null);
  this.type = (type || errors.push('SwaggerRequest type is required (get/post/put/delete/patch/options).'));
  this.url = (url || errors.push('SwaggerRequest url is required.'));
  this.params = params;
  this.opts = opts;
  this.successCallback = (successCallback || errors.push('SwaggerRequest successCallback is required.'));
  this.errorCallback = (errorCallback || errors.push('SwaggerRequest error callback is required.'));
  this.operation = (operation || errors.push('SwaggerRequest operation is required.'));
  this.execution = execution;
  this.headers = (params.headers || {});

  if (errors.length > 0) {
    throw errors;
  }

  this.type = this.type.toUpperCase();

  // set request, response content type headers
  var headers = this.setHeaders(params, opts, this.operation);
  var body = params.body;

  // encode the body for form submits
  if (headers['Content-Type']) {
    var key, value, values = {}, i;
    var operationParams = this.operation.parameters;
    for (i = 0; i < operationParams.length; i++) {
      var param = operationParams[i];
      if (param.paramType === 'form')
        values[param.name] = param;
    }

    if (headers['Content-Type'].indexOf('application/x-www-form-urlencoded') === 0) {
      var encoded = '';
      for (key in values) {
        value = this.params[key];
        if (typeof value !== 'undefined') {
          if (encoded !== '')
            encoded += '&';
          encoded += encodeURIComponent(key) + '=' + encodeURIComponent(value);
        }
      }
      body = encoded;
    }
    else if (headers['Content-Type'].indexOf('multipart/form-data') === 0) {
      // encode the body for form submits
      var data = '';
      var boundary = '----SwaggerFormBoundary' + Date.now();
      for (key in values) {
        value = this.params[key];
        if (typeof value !== 'undefined') {
          data += '--' + boundary + '\n';
          data += 'Content-Disposition: form-data; name="' + key + '"';
          data += '\n\n';
          data += value + '\n';
        }
      }
      data += '--' + boundary + '--\n';
      headers['Content-Type'] = 'multipart/form-data; boundary=' + boundary;
      body = data;
    }
  }

  var obj;
  if (!((this.headers) && (this.headers.mock))) {
    obj = {
      url: this.url,
      method: this.type,
      headers: headers,
      body: body,
      useJQuery: this.useJQuery,
      on: {
        error: function (response) {
          return _this.errorCallback(response, _this.opts.parent);
        },
        redirect: function (response) {
          return _this.successCallback(response, _this.opts.parent);
        },
        307: function (response) {
          return _this.successCallback(response, _this.opts.parent);
        },
        response: function (response) {
          return _this.successCallback(response, _this.opts.parent);
        }
      }
    };

    var status = false;
    if (this.operation.resource && this.operation.resource.api && this.operation.resource.api.clientAuthorizations) {
      // Get the client authorizations from the resource declaration
      status = this.operation.resource.api.clientAuthorizations.apply(obj, this.operation.authorizations);
    } else {
      // Get the client authorization from the default authorization declaration
      var e;
      if (typeof window !== 'undefined') {
        e = window;
      } else {
        e = exports;
      }
      status = e.authorizations.apply(obj, this.operation.authorizations);
    }

    if (!opts.mock) {
      if (status !== false) {
        new SwaggerHttp().execute(obj);
      } else {
        obj.canceled = true;
      }
    } else {
      return obj;
    }
  }
  return obj;
};

SwaggerRequest.prototype.setHeaders = function (params, opts, operation) {
  // default type
  var accepts = opts.responseContentType || 'application/json';
  var consumes = opts.requestContentType || 'application/json';

  var allDefinedParams = operation.parameters;
  var definedFormParams = [];
  var definedFileParams = [];
  var body = params.body;
  var headers = {};

  // get params from the operation and set them in definedFileParams, definedFormParams, headers
  var i;
  for (i = 0; i < allDefinedParams.length; i++) {
    var param = allDefinedParams[i];
    if (param.paramType === 'form')
      definedFormParams.push(param);
    else if (param.paramType === 'file')
      definedFileParams.push(param);
    else if (param.paramType === 'header' && this.params.headers) {
      var key = param.name;
      var headerValue = this.params.headers[param.name];
      if (typeof this.params.headers[param.name] !== 'undefined')
        headers[key] = headerValue;
    }
  }

  // if there's a body, need to set the accepts header via requestContentType
  if (body && (this.type === 'POST' || this.type === 'PUT' || this.type === 'PATCH' || this.type === 'DELETE')) {
    if (this.opts.requestContentType)
      consumes = this.opts.requestContentType;
  } else {
    // if any form params, content type must be set
    if (definedFormParams.length > 0) {
      if (definedFileParams.length > 0)
        consumes = 'multipart/form-data';
      else
        consumes = 'application/x-www-form-urlencoded';
    }
    else if (this.type === 'DELETE')
      body = '{}';
    else if (this.type != 'DELETE')
      consumes = null;
  }

  if (consumes && this.operation.consumes) {
    if (this.operation.consumes.indexOf(consumes) === -1) {
      log('server doesn\'t consume ' + consumes + ', try ' + JSON.stringify(this.operation.consumes));
    }
  }

  if (this.opts && this.opts.responseContentType) {
    accepts = this.opts.responseContentType;
  } else {
    accepts = 'application/json';
  }
  if (accepts && operation.produces) {
    if (operation.produces.indexOf(accepts) === -1) {
      log('server can\'t produce ' + accepts);
    }
  }

  if ((consumes && body !== '') || (consumes === 'application/x-www-form-urlencoded'))
    headers['Content-Type'] = consumes;
  if (accepts)
    headers.Accept = accepts;
  return headers;
};
