import React from "react"

export default class OnlineValidatorBadge extends React.Component {
    constructor(props, context) {
        super(props, context)
        let { specSelectors, getConfigs } = props
        let { validatorUrl } = getConfigs()
        this.state = {
            url: specSelectors.url(),
            validatorUrl: validatorUrl || "https://online.swagger.io/validator"
        }
    }

    componentWillReceiveProps(nextProps) {
        let { specSelectors, getConfigs } = nextProps
        let { validatorUrl } = getConfigs()

        this.setState({
            url: specSelectors.url(),
            validatorUrl: validatorUrl || "https://online.swagger.io/validator"
        })
    }

    render() {
        let { getConfigs } = this.props
        let { spec } = getConfigs()

        if ( typeof spec === "object" && Object.keys(spec).length) return null

        if (!this.state.url) {
          return null
        }

        return  (<span style={{ float: "right"}}>
                <a target="_blank" href={`${ this.state.validatorUrl }/debug?url=${ this.state.url }`}>
                    <img alt="Online validator badge" src={`${ this.state.validatorUrl }?url=${ this.state.url }`} />
                </a>
            </span>)
    }
}
