/*
 * Alias Extension
 *
 * Allows a module to be a plain copy of another module by module name
 *
 * System.meta['mybootstrapalias'] = { alias: 'bootstrap' };
 *
 */
(function() {
  // aliases
  hook('fetch', function(fetch) {
    return function(load) {
      var alias = load.metadata.alias;
      if (alias) {
        load.metadata.format = 'defined';
        this.defined[load.name] = {
          declarative: true,
          deps: [alias],
          declare: function(_export) {
            return {
              setters: [function(module) {
                for (var p in module)
                  _export(p, module[p]);
              }],
              execute: function() {}
            };
          }
        };
        return '';
      }

      return fetch.call(this, load);
    };
  });
})();