'use strict';

var $$rAFSchedulerFactory = ['$$rAF', function($$rAF) {
  var tickQueue = [];
  var cancelFn;

  function scheduler(tasks) {
    // we make a copy since RAFScheduler mutates the state
    // of the passed in array variable and this would be difficult
    // to track down on the outside code
    tickQueue.push([].concat(tasks));
    nextTick();
  }

  /* waitUntilQuiet does two things:
   * 1. It will run the FINAL `fn` value only when an uncancelled RAF has passed through
   * 2. It will delay the next wave of tasks from running until the quiet `fn` has run.
   *
   * The motivation here is that animation code can request more time from the scheduler
   * before the next wave runs. This allows for certain DOM properties such as classes to
   * be resolved in time for the next animation to run.
   */
  scheduler.waitUntilQuiet = function(fn) {
    if (cancelFn) cancelFn();

    cancelFn = $$rAF(function() {
      cancelFn = null;
      fn();
      nextTick();
    });
  };

  return scheduler;

  function nextTick() {
    if (!tickQueue.length) return;

    var updatedQueue = [];
    for (var i = 0; i < tickQueue.length; i++) {
      var innerQueue = tickQueue[i];
      runNextTask(innerQueue);
      if (innerQueue.length) {
        updatedQueue.push(innerQueue);
      }
    }
    tickQueue = updatedQueue;

    if (!cancelFn) {
      $$rAF(function() {
        if (!cancelFn) nextTick();
      });
    }
  }

  function runNextTask(tasks) {
    var nextTask = tasks.shift();
    nextTask();
  }
}];
